﻿struct GameDB_Controller {
	unsigned long int PRGCRC;
	STDCONT_TYPE Port1;
	STDCONT_TYPE Port2;
	EXPCONT_TYPE ExpPort;
} GameDB_Controllers [] = {
	// Zapper Games
	{ 0xF2641AD0, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Barker Bill's Trick Shooting
	{ 0x2970D05B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Barker Bill's Trick Shooting
	{ 0x90CA616D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Duck Hunt
	{ 0x7B5BD2DE, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Gumshoe
	{ 0x8963AE6E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Hogan's Alley
	{ 0x0D3CF705, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Wild Gunman
	{ 0x389960DB, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Wild Gunman
	{ 0x163E86C0, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // To The Earth
	{ 0x418C9992, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // To The Earth	
	{ 0xAC6C95F3, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Mad City
	{ 0xE4C04EEA, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Mad City
	{ 0xCB275051, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // The Adventures of Bayou Billy
	{ 0xFBFC6A6C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // The Adventures of Bayou Billy
	{ 0x255B129C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Gun Sight
	{ 0x51D2112F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Laser Invasion
	{ 0x0A866C94, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // The Lone Ranger
	{ 0x900C7442, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Konamic Sports in Seoul
	{ 0x4C25D4F5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Track & Field II
	{ 0x22EE7772, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Track & Field II
	{ 0x8ACAFE51, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Track & Field II
	{ 0x59E3343F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Freedom Force
	{ 0x8335B58A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Freedom Force
	{ 0xEDD6D29B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Day Dreamin' Davey
	{ 0x242A270C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Gotcha! The Sport!
	{ 0x9EEF47AA, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Mechanized Attack
	{ 0x885A8A6D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Shooting Range
	{ 0x42D893E4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Operation Wolf
	{ 0x1388AEB9, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Operation Wolf
	{ 0x54C34223, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Operation Wolf
	{ 0xFB69C131, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Baby Boomer
	{ 0x0BD9FBCF, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Baby Boomer
	{ 0x639CB8B8, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Chiller
	{ 0x98E3B8BB, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Chiller
	{ 0x0BFB7B54, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Cobra Mission
	{ 0xE85B4D3D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Hit Marmot
	{ 0x129BA023, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Hit Marmot
	{ 0x0F5CA99C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Master Shooter
	{ 0x04ACAD5A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Top Hunter
	{ 0x789270E0, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 3-in-1 Supergun
	{ 0xB5DC7EF2, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // TXC 6-in-1
	{ 0x3E7ABB2A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Strike Wolf
	{ 0x1A8B558E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Crime Busters
	{ 0x81069812, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Super Mario Brothers+Duck Hunt
	{ 0xE8F8F7A5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Super Mario Brothers+Duck Hunt
	{ 0x39B481C4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Cosmo Cop, Cyber Monster
	{ 0xB4F460F8, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Tough Cop
	{ 0xF22B14BF, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Blood of Jurassic
	{ 0x353E0572, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Zap Ruder!
	{ 0x2DBC8621, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Lethal Weapon
	{ 0xCEA5ABF3, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // [UNIF] Test Ver. 1.01 Dlya Proverki TV Pristavok (RT-01, by SS aka Snake)
	{ 0x0CD00488, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_BANDAIHYPERSHOT }, // Space Shadow
	{ 0x03B6596C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_BANDAIHYPERSHOT }, // Space Shadow (FFE)
	// Multicarts with Zapper games on them
	{ 0x7349C91A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_BANDAIHYPERSHOT }, // 2-in-1 Uzi Lightgun
	{ 0x7EC6DF24, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 20-in-1 by Professor X
	{ 0x6FE4A699, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Super 4-in-1 Fantasy Gun
	{ 0xE0AABE97, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Super Gun 20-in-1
	{ 0x9C0C5498, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Asder 20-in-1
	{ 0xF8B751D4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Asder 20-in-1
	{ 0xAF58474B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 150-in-1 Unchained Melody
	{ 0x6569F1F5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 200-in-1 Elfland
	{ 0x3E95577D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 200-in-1 Elfland
	{ 0x32F1176B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // PocketGames 150-in-1
	{ 0xC25FD362, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Prima Soft 9999999-in-1
	{ 0xF03BEC60, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 1000-in-1 (JPx72)
	{ 0xC3566FDE, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Golden 190-in-1
	{ 0xC0F85771, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 2011 Super HiK 105-in-1 Turbo Edition
	{ 0xE79F157E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 23 Plus 222-in-1
	{ 0xDC731669, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 400-in-1
	{ 0x09F4DE0B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 4-in-1 (TJ-03)
	{ 0xA831426D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 5000000-in-1 (JPx72)
	{ 0x54F2E672, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Tsang Hai 63-in-1
	{ 0x38A1A7E5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Y2K Play 64-in-1
	{ 0x0BB4FD7A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // 800-in-1
	{ 0x087FCEF9, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // NEW EIGHTEEN-IN-ONE
	{ 0x4A168501, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // Novel Diamond 999999-in-1
	{ 0x41D23E8F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_ZAPPER }, // PocketGames 150-in-1
	// Power Pad/Family Trainer Games
	{ 0xBC5F6C94, STD_STDCONTROLLER, STD_POWERPADA, EXP_UNCONNECTED }, // Athletic World (NTSC)
	{ 0x552FB544, STD_STDCONTROLLER, STD_POWERPADA, EXP_UNCONNECTED }, // Athletic World (PAL)
	{ 0xD836A90B, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Dance Aerobics
	{ 0xF8DA2506, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Aerobics Studio
	{ 0x87738F85, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERA }, // Family Trainer: Athletic World (rev0)
	{ 0x8C8FA83B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERA }, // Family Trainer: Athletic World (rev1)
	{ 0xCA26A0F1, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Daiundoukai
	{ 0x7E704A14, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERA }, // Family Trainer: Jogging Race
	{ 0x10BB8F9A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Manhattan Police
	{ 0xAD3DF455, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Meiro Daisakusen
	{ 0x2330A5D3, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERA }, // Family Trainer: Rai Rai Kyonshis
	{ 0xB8C54977, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERA }, // Family Trainer: Rai Rai Kyonshis (Beta)
	{ 0x8A5B72C0, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Running Stadium
	{ 0x59794F2D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Takeshi-jo 1
	{ 0xEE11FE78, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMTRAINERB }, // Family Trainer: Takeshi-jo 2
	{ 0xE8D34A54, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // NES Power Pad Test Cart
	{ 0xFCC562B4, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Power Pad Test Program by Tennessee Carmel-Veilleux
	{ 0xFD37CA4C, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Short Order/Eggsplode
	{ 0xDD978A90, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Stadium Events (NTSC)
	{ 0xD06CEB9A, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Stadium Events (PAL)
	{ 0x987DCDA3, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Street Cop
	{ 0xF210E68F, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // Super Team Games
	{ 0x1A43BFA9, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // World Class Track Meet (rev0)
	{ 0x2D76A271, STD_STDCONTROLLER, STD_POWERPADB, EXP_UNCONNECTED }, // World Class Track Meet (rev1)
	// Vs. Zapper Games
	{ 0xED588F00, STD_VSZAPPER, STD_STDCONTROLLER, EXP_UNCONNECTED }, // Vs. Duck Hunt
	{ 0xFF5135A3, STD_VSZAPPER, STD_STDCONTROLLER, EXP_UNCONNECTED }, // Vs. Hogan's Alley
	{ 0x9299CA26, STD_VSZAPPER, STD_STDCONTROLLER, EXP_UNCONNECTED }, // Vs. Gumshoe
	{ 0xFE446787, STD_VSZAPPER, STD_STDCONTROLLER, EXP_UNCONNECTED }, // Vs. Gumshoe
	{ 0x17AE56BE, STD_VSZAPPER, STD_STDCONTROLLER, EXP_UNCONNECTED }, // Vs. Freedom Force
	// Subor Keyboard Games
	{ 0xD3906F32, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor Math
	{ 0x8B265862, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // English Word Blaster
	{ 0x36A8FDF6, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 征服太阳系&小管家
	{ 0x60E33D27, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 认知码学习
	{ 0x669A32F2, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 马步迷阵&趣味成语屋
	{ 0xE4460DF2, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 小霸王学习机V1.1
	{ 0xF9BC83B9, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 仓库世家&动脑筋
	{ 0x0A9329B5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 启智屋A
	{ 0x15058291, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 启智屋B
	{ 0xD5D6EAC4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // MXMDHTWO学习卡
	{ 0x82F1FB96, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 1 Russian
	{ 0x6733607A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 3
	{ 0xAC11B570, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 金卡V5
	{ 0x7B959CB2, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 视窗系统2000
	{ 0xF18BC238, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 视窗系统2000
	{ 0x0930349E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 3
	{ 0x41EF9AC4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 4
	{ 0x41401C6D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 4
	{ 0x40A4C574, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 5
	{ 0x85068811, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 小霸王学习机V6
	{ 0xF58761D0, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 8
	{ 0x12D61CE8, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Subor 999/小霸王学习机V11
	{ 0x5F693117, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 小霸王学习机V13
	{ 0xABB2F974, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Study and Game 32-in-1
	{ 0xF1DF9942, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Education Computer 26-in-1 (R) ??? MOUSE
	{ 0xF834F634, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Education Computer 32-in-1 (Game Star) [b]
	{ 0xFA4FA29E, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Education Computer 32-in-1 (Game Star)
	{ 0x6D378420, STD_SUBORMOUSE, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Education Computer 48-in-1 (Game Star)
	{ 0x04EE9E40, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 14-in-1 Russian Study Cartridge (R)
	{ 0x2CFF0B46, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 7-in-1 Russian Study Cartridge (R)
	{ 0xC0A76428, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Arabic Study Cartridge (32-in-1)
	{ 0x6DE05A33, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Asder PC-95 Arabic
	{ 0x6AA52ED1, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // 16-in-1 Chao Ji Shu Biao Jin Ka !!! MOUSE
	{ 0x5A7139F5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // FC BASIC (7-in-1)
	{ 0xE90A6AEB, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Jin Ka Wang
	{ 0xF71CBC0A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Jing Dian Shu Biao You Xi
	{ 0x53A3F6F8, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Jisuanqi
	{ 0x368C19A8, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // LIKO Study Cartridge
	{ 0xDA587B2C, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Balda
	{ 0x13188C21, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Cvetnye Linii
	{ 0x7F463657, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Kibord 003
	{ 0xE9A7FE9E, STD_STDCONTROLLER, STD_SUBORMOUSE,    EXP_SUBORKEYBOARD }, // Educational Computer 2000
	{ 0x51C41A5A, STD_STDCONTROLLER, STD_SUBORMOUSE,    EXP_SUBORKEYBOARD }, // Educational Computer 2000
	{ 0xAA044941, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // SuborWin 2000
	{ 0xED4885E0, STD_STDCONTROLLER, STD_SUBORMOUSE,    EXP_SUBORKEYBOARD }, // Asder PC-95 Korean
	{ 0xB72B17ED, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // GSD Super Student Computer Cartridge
	{ 0x2AF63A19, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // RONG FENG Study Cartridge
	{ 0x5E073A1B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // English Word Blaster V1.0
	{ 0x396ACCAA, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Nuevo Tipo de Computadora (Game Star)
	{ 0xD1CC7724, STD_SUBORMOUSE,    STD_STDCONTROLLER, EXP_SUBORKEYBOARD }, // Nuevo Tipo de Computadora (Game Star)
	// 3/4 Player Games using the Hori Four-Players Adapter
	{ 0x9F03B11F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // Moero Twinbee
	{ 0x0C401790, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // Bomberman II
	{ 0x3E078F29, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // Downtown 熱血行進曲 ~それゆけ大運動会~
	{ 0x346CD5D3, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // いけいけ熱血 Hockey部 ~すべってころんで大乱闘~
	{ 0xDEDDD5E5, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // くにおくんの熱血 Soccer League
	{ 0x85C5B6B4, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // 熱血格闘伝説
	{ 0x7BD7B849, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // 熱血高校 Dodgeball部
	{ 0x67A0D115, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // びっくり熱血新記録! はるかなる金 Medal
	{ 0x4FB460CD, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // 熱血! Street Basket꞉ がんばれ Dunk Heroes
	{ 0x0ABDD5CA, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // Spot
	{ 0x9ADD521E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // US Championship V'Ball
	{ 0x8FF2F9DC, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMI4PLAY }, // US Championship V'Ball
	// NES Four Score
	{ 0x1EBB5B42, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Bomberman II
	{ 0xC1B43207, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Danny Sullivan's Indy Heat
	{ 0x27CA0679, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Danny Sullivan's Indy Heat
	{ 0x34BB757B, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Dynablaster
	{ 0x2C609B52, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Gauntlet II
	{ 0x3B997543, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Gauntlet II
	{ 0x1352F1B9, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Greg Norman's Golf Power
	{ 0xB33BC971, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Harlem Globetrotters
	{ 0xAB8371F6, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Kings of the Beach
	{ 0x3A9DD55C, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Magic Johnson's Fast Break
	{ 0xF7F9785A, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Monster Truck Rally
	{ 0x0939852F, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // M.U.L.E.
	{ 0x17F72EC8, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // NES Play Action Football
	{ 0xDA2CB59A, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // A Nightmare on Elm Street
	{ 0xDE8C89AB, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Nintendo World Cup
	{ 0x725B0234, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Nintendo World Cup
	{ 0xDB2F988D, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Nintendo World Cup
	{ 0x9EDD2159, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // R.C. Pro-Am II
	{ 0x308DA987, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // R.C. Pro-Am II
	{ 0x7F60BF49, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Rackets & Rivals
	{ 0x279B69C0, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Roundball 2-on-2 Challenge
	{ 0x715F3294, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Roundball 2-on-2 Challenge
	{ 0x2989EAD6, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Smash T.V.
	{ 0x5460529A, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Smash T.V.
	{ 0xCFAE9DFA, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Spot
	{ 0x1808BB59, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Mario Brothers + Tetris + Nintendo World Cup
	{ 0x7EEF434C, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Mario Brothers + Tetris + Nintendo World Cup
	{ 0x4B041B6B, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Ivan "Ironman" Stewart's Super Off-Road
	{ 0x05104517, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Ivan "Ironman" Stewart's Super Off-Road
	{ 0xD3428E2E, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Jeopardy!
	{ 0x1E598A14, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Spike V'Ball
	{ 0xEBB9DF3D, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Spike V'Ball
	{ 0x35190A3F, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Super Spike V'Ball + Nintendo World Cup
	{ 0x3417EC46, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Swords and Serpents
	{ 0xD153CAF6, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Swords and Serpents
	{ 0x46135141, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Swords and Serpents
	{ 0xDD564975, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Top Players' Tennis
	{ 0xE16F25CC, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Four Players Tennis
	{ 0x514770A0, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // BMX Simulator
	{ 0x40E1F09E, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // BMX Simulator
	{ 0xC469EC55, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // BMX Simulator
	{ 0xCCCAF368, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Quattro Sports
	{ 0xA045FE1D, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Quattro Sports
	{ 0xB462718E, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Quattro Sports
	{ 0x9219765F, STD_FOURSCORE, STD_FOURSCORE2, EXP_UNCONNECTED }, // Joypad Test Cartridge
	// Family BASIC Keyboard and Data Recorder
	{ 0x868FCD89, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Family BASIC 1.0 
	{ 0xF9DEF527, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Family BASIC 2.0
	{ 0xDE34526E, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Family BASIC 2.1
	{ 0x3AAEED3F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Family BASIC 3.0
	{ 0x2D6B7E5A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Playbox BASIC
	{ 0x3A94FA0B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // ExciteBike
	{ 0x0B5667E9, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // ExciteBike
	{ 0xAF2BBCBC, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Mach Rider
	{ 0x3ACD4BF1, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Mach Rider
	{ 0x8BBE9BEC, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Mach Rider
	{ 0x4328B273, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Wrecking Crew
	{ 0x85534474, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Lode Runner
	{ 0xEC3001C7, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_FAMILYBASICKEYBOARD }, // Lode Runner
	// ASCII Turbo File
	{ 0x9FA1C11F, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Castle Excellent
	{ 0xF79D684A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 (rev0)
	{ 0xE792DE94, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 (rev1)
	{ 0xC2EF3422, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 II
	{ 0x974E8840, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 '90
	{ 0xB8747ABF, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 Special (rev0)
	{ 0xC3DE7C69, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best Play Pro 野球 Special (rev1)
	{ 0x41482DA3, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best 競馬: Derby Stallion (rev0)
	{ 0x9C94A0EC, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Best 競馬: Derby Stallion (rev0)
	{ 0x0B0D4D1B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Derby Stallion: 全国版
	{ 0x728C3D98, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Downtown 熱血物語
	{ 0xD68A6F33, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Dungeon Kid
	{ 0x3B05AC54, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Famicom 将棋: 竜王戦
	{ 0xD39A6E1D, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Famicom 将棋: 竜王戦 (Beta)
	{ 0x3A51EB04, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Fleet Commander
	{ 0x7C46998B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // 覇邪の封印
	{ 0x7E5D2F1A, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // いただきStreet: 私のお店によってって
	{ 0xEA79CC19, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // The Money Game 2: 兜町の奇跡
	{ 0xCEE5857B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // 忍者らホイ!
	{ 0x343E9146, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Wizardry 1
	{ 0x33D07E45, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Wizardry 2
	{ 0x50EC5E8B, STD_STDCONTROLLER, STD_STDCONTROLLER, EXP_TURBOFILE }, // Wizardry 3
	// Template
	{ 0xFFFFFFFF, STD_UNCONNECTED, STD_UNCONNECTED, EXP_UNCONNECTED }, // 
};

int	LastChoice;

void	SetControllersAutomatically (void) {
	Tape::Stop();
	LastChoice =0;
	
	struct GameDB_Controller *info =NULL;
	for (info =&GameDB_Controllers[0]; info->PRGCRC !=0; info++)
		if (info->PRGCRC ==RI.PRGROMCRC32) break;
	if (info->PRGCRC ==0) info =NULL;
	
	StdPort_SetControllerType(FSPort4, STD_UNCONNECTED, FSPort4_Buttons);
	StdPort_SetControllerType(FSPort3, STD_UNCONNECTED, FSPort3_Buttons);
	StdPort_SetControllerType(FSPort2, STD_UNCONNECTED, FSPort2_Buttons);
	StdPort_SetControllerType(FSPort1, STD_UNCONNECTED, FSPort1_Buttons);
	ExpPort_SetControllerType(PortExp, EXP_UNCONNECTED, PortExp_Buttons);
	StdPort_SetControllerType(Port2, STD_UNCONNECTED, Port2_Buttons);
	StdPort_SetControllerType(Port1, STD_UNCONNECTED, Port1_Buttons);
	if (info) {
		if (info->Port1 ==STD_FOURSCORE) {
			StdPort_SetControllerType(Port1, STD_FOURSCORE, Port1_Buttons);
			StdPort_SetControllerType(Port2, STD_FOURSCORE2, Port2_Buttons);
			StdPort_SetControllerType(FSPort1, STD_STDCONTROLLER, FSPort1_Buttons);
			StdPort_SetControllerType(FSPort2, STD_STDCONTROLLER, FSPort2_Buttons);
			StdPort_SetControllerType(FSPort3, STD_STDCONTROLLER, FSPort3_Buttons);
			StdPort_SetControllerType(FSPort4, STD_STDCONTROLLER, FSPort4_Buttons);
		} else if (info->ExpPort ==EXP_FAMI4PLAY) {
			StdPort_SetControllerType(Port1, STD_STDCONTROLLER, Port1_Buttons);
			StdPort_SetControllerType(Port2, STD_STDCONTROLLER, Port2_Buttons);
			StdPort_SetControllerType(FSPort3, STD_STDCONTROLLER, FSPort3_Buttons);
			StdPort_SetControllerType(FSPort4, STD_STDCONTROLLER, FSPort4_Buttons);
			ExpPort_SetControllerType(PortExp, EXP_FAMI4PLAY, PortExp_Buttons);
		} else {
			StdPort_SetControllerType(Port1, info->Port1, Port1_Buttons);
			StdPort_SetControllerType(Port2, info->Port2, Port2_Buttons);
			ExpPort_SetControllerType(PortExp, info->ExpPort, PortExp_Buttons);
		}
		if (info->ExpPort ==EXP_FAMILYBASICKEYBOARD || info->ExpPort ==EXP_SUBORKEYBOARD) {
			EnableMenuItem(hMenu, ID_MISC_PLAYTAPE, MF_ENABLED);
			EnableMenuItem(hMenu, ID_MISC_RECORDTAPE, MF_ENABLED);
			EnableMenuItem(hMenu, ID_MISC_STOPTAPE, MF_GRAYED);
		}
	} else if (RI.INES_MapperNum ==257) {
		StdPort_SetControllerType(Port1, STD_STDCONTROLLER, Port1_Buttons);
		StdPort_SetControllerType(Port2, STD_STDCONTROLLER, Port2_Buttons);
		ExpPort_SetControllerType(PortExp, EXP_PEC586KEYBOARD, PortExp_Buttons);
	} else {
		StdPort_SetControllerType(Port1, STD_STDCONTROLLER, Port1_Buttons);
		StdPort_SetControllerType(Port2, STD_STDCONTROLLER, Port2_Buttons);
		ExpPort_SetControllerType(PortExp, EXP_UNCONNECTED, PortExp_Buttons);
		EnableMenuItem(hMenu, ID_MISC_PLAYTAPE, MF_GRAYED);
		EnableMenuItem(hMenu, ID_MISC_RECORDTAPE, MF_GRAYED);
		EnableMenuItem(hMenu, ID_MISC_STOPTAPE, MF_GRAYED);
	}
	SetDeviceUsed();
}

void	SwitchControllersAutomatically (void) {
	if (RI.PRGROMCRC32 ==0x6BEB5C84 || RI.PRGROMCRC32 ==0xD4F018F5) { // Super Mario Brothers+Duck Hunt+World Class Track Meet
		uint16_t NMIVector =(EI.GetCPUReadHandlerDebug(0xF))(0xF, 0xFFA) | ((EI.GetCPUReadHandlerDebug(0xF))(0xF, 0xFFB) <<8);
		int CurrentChoice =0;
		switch (NMIVector) {
			case 0x8082: CurrentChoice =1; break; // Super Mario Brothers
			case 0xC086: CurrentChoice =2; break; // Duck Hunt
			case 0xF9A4: CurrentChoice =3; break; // World Class Track Meet
		}
		if (CurrentChoice !=0 && CurrentChoice !=LastChoice) {
			ExpPort_SetControllerType(PortExp, EXP_UNCONNECTED, PortExp_Buttons);
			StdPort_SetControllerType(Port2, STD_UNCONNECTED, Port2_Buttons);
			switch(CurrentChoice) {
				case 1:	StdPort_SetControllerType(Port2, STD_STDCONTROLLER, Port2_Buttons); break;	// Super Mario Brothers: Second controller into port 2
				case 2:	ExpPort_SetControllerType(PortExp, EXP_ZAPPER, PortExp_Buttons); break;		// Duck Hunt: Zapper into expansion port
				case 3:	StdPort_SetControllerType(Port2, STD_POWERPADB, Port2_Buttons); break;		// World Class Track Meet: Power Pad Side B into port 2
			}
			SetDeviceUsed();
		}
		LastChoice =CurrentChoice;
	}
}