struct UNIFInfo {
	char* Name;		// Converted to uppercase, trimmed and with prefix removed
	uint16_t Mapper;
	uint8_t Submapper;
	size_t WRAM;		// PRG-RAM (both battery-backed and not backed)
	size_t MaxNVRAM;	// battery-backed amount of PRG-RAM if battery is present
	size_t CHR_RAMwithoutCHR_ROM;
	size_t CHR_RAMwithCHR_ROM;
	int Misc;
} UNIFtoNES2 [] = {
	// Name				 Mapper	 Submap	 WRAM	 MaxNV	 noCROM	 withCROM Misc
	{ "10-24-C-A1"			,327	,0	,8192	,8192	,8192	,0	,0		},
	{ "11160"			,299	,0	,0	,0	,8192	,0	,0		},
	{ "12-IN-1"			,331	,0	,0	,0	,8192	,0	,0		},
	{ "13IN1JY110"			,295	,0	,0	,0	,8192	,0	,0		},
	{ "150IN1A"			,235	,0	,0	,0	,8192	,0	,0		},
	{ "158B"			,258	,0	,0	,0	,8192	,0	,0		},
	{ "190IN1"			,300	,0	,0	,0	,8192	,0	,0		},
	{ "212-HONG-KONG"		,235	,0	,0	,0	,8192	,0	,0		},
	{ "22026"			,271	,0	,0	,0	,8192	,0	,0		},
	{ "22211"			,132	,0	,0	,0	,8192	,0	,0		},
//	{ "3D-BLOCK"			,330	,0	,0	,0	,8192	,0	,0		},
	{ "411120-C"			,287	,0	,0	,0	,8192	,0	,0		},
	{ "42IN1RESETSWITCH"		,233	,0	,0	,0	,8192	,0	,0		},
	{ "43272"			,242	,0	,0	,0	,8192	,0	,0		},
	{ "603-5052"			,238	,0	,0	,0	,8192	,0	,0		},
	{ "60311C"			,289	,0	,0	,0	,8192	,0	,0		},
	{ "64IN1NOREPEAT"		,314	,0	,0	,0	,8192	,0	,0		},
	{ "70IN1"			,236	,0	,0	,0	,8192	,0	,0		},
	{ "70IN1B"			,236	,0	,0	,0	,8192	,0	,0		},
	{ "74LS374N"			,150	,0	,0	,0	,8192	,0	,0		},
	{ "8-IN-1"			,333	,0	,0	,0	,8192	,0	,0		},
	{ "80013-B"			,274	,0	,0	,0	,8192	,0	,0		},
	{ "810544-C-A1"			,261	,0	,0	,0	,8192	,0	,0		},
	{ "8157"			,301	,0	,0	,0	,8192	,0	,0		},
	{ "8237"			,215	,0	,0	,0	,8192	,0	,0		},
	{ "8237A"			,215	,1	,0	,0	,8192	,0	,0		},
	{ "8259A"			,141	,0	,0	,0	,8192	,0	,0		},
	{ "8259B"			,138	,0	,0	,0	,8192	,0	,0		},
	{ "8259C"			,139	,0	,0	,0	,8192	,0	,0		},
	{ "8259D"			,137	,0	,0	,0	,8192	,0	,0		},
	{ "830118C"			,348	,0	,0	,0	,8192	,0	,0		},
	{ "830134C"			,315	,0	,0	,0	,8192	,0	,0		},
	{ "830425C-4391T"		,320	,0	,0	,0	,8192	,0	,0		},
	{ "831128C"			,528	,0	,0	,0	,8192	,0	,0		},
	{ "891227"			,350	,0	,0	,0	,8192	,0	,0		},
	{ "900218"			,524	,0	,0	,0	,8192	,0	,0		},
	{ "AC08"			,42	,0	,0	,0	,8192	,0	,0		},
	{ "MC-ACC"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "A65AS"			,285	,0	,0	,0	,8192	,0	,0		},
	{ "AMROM"			,7	,2	,0	,0	,8192	,0	,0		},
	{ "ANROM"			,7	,1	,0	,0	,8192	,0	,0		},
	{ "AN1ROM"			,7	,1	,0	,0	,8192	,0	,0		},
	{ "AOROM"			,7	,0	,0	,0	,8192	,0	,0		},
	{ "AX-40G"			,527	,0	,0	,0	,8192	,0	,0		},
	{ "AX5705"			,530	,0	,0	,0	,8192	,0	,0		},
	{ "BB"				,108	,0	,0	,0	,8192	,0	,0		},
	{ "BJ-56"			,526	,0	,0	,0	,8192	,0	,0		},
	{ "BNROM"			,34	,2	,0	,0	,8192	,0	,0		},
	{ "BS-5"			,286	,0	,0	,0	,8192	,0	,0		},
	{ "CC-21"			,27	,0	,0	,0	,8192	,0	,0		},
	{ "CHINA_ER_SAN2"		,532	,0	,8320	,8192	,8192	,0	,0		},
	{ "CITYFIGHT"			,266	,0	,0	,0	,8192	,0	,0		},
	{ "CNROM"			,3	,0	,0	,0	,8192	,0	,0		},
	{ "CNROM+SECURITY"		,185	,0	,0	,0	,8192	,0	,0		},
	{ "COOLBOY"			,268	,0	,8192	,8192	,262144 ,8192	,0		},
	{ "COOLGIRL"			,342	,0	,32768	,32768	,262144 ,8192	,0		},
	{ "CPROM"			,13	,0	,0	,0	,16384	,16384	,0		},
	{ "CTC-09"			,335	,0	,0	,0	,8192	,0	,0		},
	{ "CTC-12IN1"			,337	,0	,0	,0	,8192	,0	,0		},
	{ "D1038"			,59	,0	,0	,0	,8192	,0	,0		},
	{ "DANCE"			,256	,0	,8192	,8192	,8192	,0	,0		},
	{ "DANCE2000"			,518	,0	,8192	,8192	,8192	,0	,0		},
	{ "DRAGONFIGHTER"		,292	,0	,0	,0	,8192	,0	,0		},
	{ "DREAMTECH01"			,521	,0	,0	,0	,8192	,0	,0		},
	{ "DRIPGAME"			,259	,0	,8192	,8192	,8192	,0	,0		},
	{ "EDU2000"			,329	,0	,32768	,32768	,8192	,0	,0		},
	{ "EH8813A"			,519	,0	,0	,0	,8192	,0	,0		},
	{ "EKROM"			,5	,0	,8192	,8192	,8192	,0	,0		},
	{ "ELROM"			,5	,0	,0	,0	,8192	,0	,0		},
	{ "ETROM"			,5	,0	,16384	,8192	,8192	,0	,0		},
	{ "EWROM"			,5	,0	,32768	,32768	,8192	,0	,0		},
	{ "FAMILYBASIC"			,0	,0	,2048	,2048	,8192	,0	,0		},
	{ "FARID_SLROM_8-IN-1"		,323	,0	,0	,0	,8192	,0	,0		},
	{ "FARID_UNROM_8-IN-1"		,324	,0	,0	,0	,8192	,0	,0		},
	{ "FJROM"			,10	,0	,8192	,8192	,8192	,0	,0		},
	{ "FK23C"			,176	,0	,0	,0	,262144	,8192	,0		},
	{ "FK23C"			,176	,0	,0	,0	,262144	,8192	,0		},
	{ "FK23CA"			,176	,0	,0	,0	,262144	,8192	,0		},
	{ "FKROM"			,10	,0	,8192	,8192	,8192	,0	,0		},
	{ "FS005"			,176	,0	,32768	,16384	,8192	,8192	,0		},
	{ "FS304"			,162	,0	,8192	,8192	,8192	,0	,0		},
	{ "FW-01"			,242	,0	,8192	,8192	,8192	,0	,0		},
	{ "G-146"			,349	,0	,0	,0	,8192	,0	,0		},
	{ "GHOSTBUSTERS63IN1"		,226	,0	,0	,0	,8192	,0	,0		},
	{ "GKCXIN1"			,279	,0	,0	,0	,8192	,0	,0		},
	{ "GN-26"			,344	,0	,0	,0	,8192	,0	,0		},
	{ "GS-2004"			,283	,0	,0	,0	,8192	,0	,0		},
	{ "GS-2013"			,283	,0	,0	,0	,8192	,0	,0		},
	{ "H2288"			,123	,0	,0	,0	,8192	,0	,0		},
	{ "HKROM"			,4	,1	,1024	,1024	,8192	,0	,0		},
	{ "HPXX"			,260	,0	,8192	,8192	,8192	,0	,0		},
	{ "HP2018-A"			,260	,0	,8192	,8192	,8192	,0	,0		},
	{ "HP898F"			,319	,0	,0	,0	,8192	,0	,0		},
	{ "HROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "JC-016-2"			,205	,0	,0	,0	,8192	,0	,0		},
	{ "K-3006"			,339	,0	,0	,0	,8192	,0	,0		},
	{ "K-3033"			,322	,0	,0	,0	,8192	,0	,0		},
	{ "K-3036"			,340	,0	,0	,0	,8192	,0	,0		},
	{ "K-3046"			,336	,0	,0	,0	,8192	,0	,0		},
	{ "K-3088"			,287	,0	,0	,0	,8192	,0	,0		},
	{ "KOF97"			,263	,0	,0	,0	,8192	,0	,0		},
	{ "KS106C"			,343	,1	,0	,0	,8192	,0	,0		},
	{ "KS7012"			,346	,0	,8192	,0	,8192	,0	,0		},
	{ "KS7013B"			,312	,0	,0	,0	,8192	,0	,0		},
	{ "KS7016"			,306	,0	,0	,0	,8192	,0	,0		},
	{ "KS7017"			,303	,0	,8192	,0	,8192	,0	,0		},
	{ "KS7021A"			,525	,0	,0	,0	,8192	,0	,0		},
	{ "KS7031"			,305	,0	,0	,0	,8192	,0	,0		},
	{ "KS7032"			,142	,0	,0	,0	,8192	,0	,0		},
	{ "KS7037"			,303	,0	,8192	,0	,8192	,0	,0		},
	{ "KS7057"			,302	,0	,0	,0	,8192	,0	,0		},
	{ "L6IN1"			,345	,0	,0	,0	,8192	,0	,0		},
	{ "LH09"			,42	,0	,0	,0	,8192	,0	,0		},
	{ "LH10"			,522	,0	,8192	,0	,8192	,0	,0		},
	{ "LH32"			,125	,0	,8192	,0	,8192	,0	,0		},
	{ "LH51"			,309	,0	,8192	,0	,8192	,0	,0		},
	{ "LH09"			,42	,0	,0	,0	,8192	,0	,0		},
	{ "MALISB"			,325	,0	,2048	,0	,8192	,0	,0		},
	{ "MINDKIDS"			,268	,0	,8192	,8192	,262144 ,8192	,0		},
	{ "N625092"			,221	,0	,0	,0	,8192	,0	,0		},
	{ "NEWSTAR-GRM070-8IN1"		,333	,0	,0	,0	,8192	,0	,0		},
	{ "NOVELDIAMOND9999999IN1"	,201	,0	,0	,0	,8192	,0	,0		},
	{ "NROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "NROM-128"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "NROM-256"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "NTBROM"			,68	,1	,8192	,8192	,8192	,0	,0		},
	{ "NTD-03"			,290	,0	,0	,0	,8192	,0	,0		},
	{ "ONEBUS"			,256	,0	,8192	,0	,8192	,0	,0		},
	{ "PEC-586"			,257	,0	,8192	,8192	,8192	,0	,0		},
	{ "PEEOROM"			,9	,0	,0	,0	,8192	,0	,0		},
	{ "PNROM"			,9	,0	,0	,0	,8192	,0	,0		},
	{ "RESETNROM-XIN1"		,343	,0	,0	,0	,8192	,0	,0		},
	{ "RESET-TXROM"			,313	,0	,0	,0	,8192	,0	,0		},
	{ "RROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "RT-01"			,328	,0	,0	,0	,8192	,0	,0		},
	{ "RTROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "SA005-A"			,338	,0	,0	,0	,8192	,0	,0		},
	{ "SA-016-1M"			,79	,0	,0	,0	,8192	,0	,0		},
	{ "SA-0036"			,149	,0	,0	,0	,8192	,0	,0		},
	{ "SA-0037"			,148	,0	,0	,0	,8192	,0	,0		},
	{ "SA-72007"			,145	,0	,0	,0	,8192	,0	,0		},
	{ "SA-72008"			,133	,0	,0	,0	,8192	,0	,0		},
	{ "SA-9602B"			,513	,0	,0	,0	,32768	,0	,MISC_CHR_NVRAM },
	{ "SA-NROM"			,143	,0	,0	,0	,8192	,0	,0		},
	{ "SAROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SBROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SCROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SC1ROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SEROM"			,1	,5	,0	,0	,8192	,0	,0		},
	{ "SFROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SF1ROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SFEXPROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SGROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SHERO"			,262	,0	,0	,0	,8192	,8192	,MISC_VRAM	},
	{ "SHROM"			,1	,5	,0	,0	,8192	,0	,0		},
	{ "SH1ROM"			,1	,5	,0	,0	,8192	,0	,0		},
	{ "SIROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SJROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SKROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SL12"			,116	,0	,0	,0	,8192	,0	,0		},
	{ "SL1632"			,14	,0	,0	,0	,8192	,0	,0		},
	{ "SLROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SL1ROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SL2ROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SL3ROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SLRROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SMB2J"			,304	,0	,0	,0	,8192	,0	,0		},
	{ "SMROM"			,1	,0	,0	,0	,8192	,0	,0		},
	{ "SROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "SNROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SNWEPROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SOROM"			,1	,0	,16384	,8192	,8192	,0	,0		},
	{ "STREETFIGTER-GAME4IN1"	,49	,1	,0	,0	,8192	,0	,0		}, // sic
	{ "STROM"			,0	,0	,0	,0	,8192	,0	,0		},
	{ "SUNSOFT_UNROM"		,93	,0	,0	,0	,8192	,0	,0		},
	{ "SUPER24IN1SC03"		,176	,0	,0	,0	,8192	,0	,0		},
	{ "SUPERHIK8IN1"		,45	,0	,0	,0	,8192	,0	,0		},
	{ "SUPERVISION16IN1"		,53	,0	,0	,0	,8192	,0	,MISC_REORDER	},
	{ "SUROM"			,1	,0	,8192	,8192	,8192	,0	,0		},
	{ "SXROM"			,1	,0	,32768	,32768	,8192	,0	,0		},
	{ "T-230"			,529	,0	,0	,0	,8192	,0	,0		},
	{ "T-262"			,265	,0	,0	,0	,8192	,0	,0		},
	{ "T3H53"			,59	,0	,0	,0	,8192	,0	,0		},
	{ "T4A54A"			,134	,0	,0	,0	,8192	,0	,0		},
	{ "TBROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TC-U01-1.5M"			,147	,0	,0	,0	,8192	,0	,0		},
	{ "TEROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TEK90"			,90	,0	,0	,0	,8192	,0	,0		},
	{ "TF1201"			,298	,0	,0	,0	,8192	,0	,0		},
	{ "TFROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TGROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TH2131-1"			,308	,0	,0	,0	,8192	,0	,0		},
	{ "TJ-03"			,341	,0	,0	,0	,8192	,0	,0		},
	{ "TKROM"			,4	,0	,8192	,8192	,8192	,0	,0		},
	{ "TK1ROM"			,4	,0	,8192	,8192	,8192	,0	,0		},
	{ "TKSROM"			,118	,0	,8192	,8192	,8192	,0	,0		},
	{ "TLROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TL1ROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TL2ROM"			,4	,0	,0	,0	,8192	,0	,0		},
	{ "TLSROM"			,118	,0	,0	,0	,8192	,0	,0		},
	{ "TNROM"			,4	,0	,8192	,8192	,8192	,0	,0		},
	{ "TQROM"			,119	,0	,0	,0	,8192	,8192	,0		},
	{ "TRANSFORMER"			,0	,0	,8192	,8192	,8192	,0	,0		},
	{ "TR1ROM"			,4	,0	,0	,0	,8192	,0	,MISC_VRAM	},
	{ "TSROM"			,4	,0	,8192	,0	,8192	,0	,0		},
	{ "TVROM"			,4	,0	,0	,0	,8192	,0	,MISC_VRAM	},
	{ "UNROM"			,2	,0	,0	,0	,8192	,0	,0		},
	{ "UOROM"			,2	,0	,0	,0	,8192	,0	,0		},
	{ "VRC7"			,85	,0	,0	,0	,8192	,0	,0		},
	{ "WS"				,332	,0	,0	,0	,8192	,0	,0		},
	{ "YOKO"			,264	,0	,0	,0	,8192	,0	,0		},
	{ ""				,0	,0	,0	,0	,8192	,0	,0		},
};

char* Prefixes [] = {
	"ACCLAIM-",
	"BANDAI-",
	"BMC-",
	"BTL-",
	"HVC-",
	"JALECO-",
	"IREM-",
	"NAMCOT-",
	"NES-",
	"SACHEN-",
	"UNL-",
	"WAIXING-",
	""
}