/* Nintendulator - Win32 NES emulator written in C++
 * Copyright (C) 2002-2011 QMT Productions
 *
 * $URL: svn+ssh://quietust@svn.code.sf.net/p/nintendulator/code/nintendulator/trunk/src/APU.h $
 * $Id: APU.h 1322 2016-05-31 14:22:53Z quietust $
 */

#pragma once

#include <mmsystem.h>
#define DIRECTSOUND_VERSION 0x0800
#include <dsound.h>

namespace Sound {
extern short	*buffer;
extern unsigned long	LockSize;
extern unsigned long	MHz;
extern int	buflen;
extern int	Cycles;
extern BOOL	isEnabled;

void	Init		(void);
void	Destroy		(void);
void	Start		(void);
void	Stop		(void);
void	SoundOFF	(void);
void	SoundON		(void);
void	Config		(HWND);
void	Run		(void);
void	SetRegion	(void);
} // namespace Sound
