#include "stdafx.h"
#include "Nintendulator.h"
#include "Settings.h"
#include "MapperInterface.h"
#include "NES.h"

namespace NES {
static const unsigned char WXNKey[512] = {
	0xD9, 0xA4, 0xCD, 0x11, 0x32, 0xE3, 0x99, 0x1D, 0x84, 0xD3, 0x9D, 0xDA, 0x7E, 0x12, 0x96, 0xA3,
	0x7E, 0xC6, 0x3F, 0x55, 0xCB, 0xCF, 0x76, 0xA4, 0xCA, 0xBE, 0x53, 0xFE, 0x0E, 0x06, 0x14, 0x35,
	0x79, 0x13, 0xBC, 0xEA, 0x01, 0x58, 0x1E, 0x3D, 0xBF, 0xCD, 0x93, 0xE7, 0x9B, 0x8B, 0x6C, 0x34,
	0x7F, 0x8C, 0xB0, 0x20, 0x29, 0x1C, 0x72, 0x26, 0x5B, 0xA7, 0x9B, 0x09, 0x51, 0x5A, 0xC0, 0x63,
	0xFE, 0xD1, 0x2D, 0x2C, 0x6A, 0xA9, 0xB6, 0xBB, 0xFB, 0x38, 0xC1, 0x3D, 0x22, 0x0C, 0xDB, 0x01,
	0x6F, 0xDE, 0x33, 0xA5, 0x81, 0x4C, 0x92, 0x8E, 0x1C, 0x12, 0x51, 0x0B, 0xA7, 0x8C, 0xC3, 0xC7,
	0xCE, 0x94, 0x3B, 0xF3, 0xD5, 0xD6, 0xC2, 0x9F, 0x2F, 0xB2, 0xEC, 0xAE, 0x46, 0x29, 0x42, 0x1A,
	0x1F, 0x07, 0x8C, 0xFB, 0x2A, 0xFF, 0xCF, 0xCE, 0x09, 0x35, 0x44, 0x6E, 0x99, 0x99, 0xA3, 0x57,
	0x02, 0x87, 0x39, 0x98, 0x8C, 0x2E, 0x58, 0x6C, 0xD7, 0x5B, 0xB7, 0x80, 0xC6, 0x0F, 0x86, 0x27,
	0xAF, 0x00, 0x2A, 0x9B, 0xE5, 0xFA, 0x51, 0xA7, 0xA0, 0x4C, 0x47, 0xD8, 0xAF, 0xDD, 0x00, 0x86,
	0xD2, 0x77, 0x7F, 0x88, 0xC8, 0xAE, 0x52, 0x56, 0xC7, 0x9E, 0x96, 0x9A, 0x04, 0x17, 0x84, 0x18,
	0x74, 0x75, 0xB9, 0xD0, 0x77, 0x5F, 0xA5, 0x0C, 0x97, 0xA9, 0x1E, 0x60, 0xFC, 0x61, 0x45, 0x8C,
	0xCB, 0x10, 0xAF, 0xB6, 0xE2, 0xC5, 0x5C, 0x74, 0x85, 0xB1, 0xAE, 0x87, 0x28, 0x5C, 0x89, 0x65,
	0xCD, 0x09, 0x4E, 0x82, 0xC4, 0xBD, 0xED, 0x7C, 0xF5, 0x28, 0xE3, 0xBC, 0x1C, 0x51, 0x78, 0xD0,
	0x41, 0x56, 0x0A, 0xAD, 0xFE, 0x89, 0xAD, 0xF1, 0x55, 0xF8, 0xCE, 0xCA, 0x69, 0x1E, 0xA6, 0x10,
	0x34, 0x7A, 0x92, 0x41, 0x8D, 0x39, 0x65, 0xB8, 0x72, 0xED, 0x18, 0xBD, 0xA8, 0xC1, 0x43, 0x5D,
	0xAE, 0x68, 0x0E, 0x51, 0xDE, 0x03, 0x6F, 0xE4, 0x5C, 0xAC, 0xC9, 0x1B, 0xA0, 0x52, 0xD3, 0x68,
	0x08, 0xD4, 0xF0, 0xD2, 0x65, 0xD9, 0xC7, 0xAA, 0xF8, 0xB5, 0x4C, 0xFD, 0xD6, 0x41, 0xB2, 0x82,
	0x68, 0x0F, 0x8A, 0x38, 0x5E, 0x7C, 0x41, 0xEB, 0x3E, 0xBD, 0xED, 0x89, 0x41, 0xC9, 0x48, 0x9B,
	0xB2, 0x31, 0xE2, 0x50, 0xC3, 0xD5, 0x8D, 0x0B, 0x3A, 0x8B, 0x2E, 0xC5, 0x5B, 0xF5, 0x80, 0x97,
	0x46, 0xA8, 0x0B, 0xF9, 0x30, 0xC3, 0x4D, 0x2F, 0x06, 0xB4, 0xFA, 0xEE, 0x68, 0x37, 0xAB, 0xE8,
	0x0C, 0x90, 0xB8, 0x08, 0x4D, 0xD2, 0xF4, 0x8F, 0x2B, 0x4A, 0x75, 0x91, 0x44, 0xEF, 0xBB, 0xA5,
	0x43, 0x00, 0xEE, 0x5F, 0x6C, 0xE8, 0x62, 0x41, 0xD3, 0x2A, 0xD7, 0xCB, 0xCD, 0x45, 0x00, 0x5F,
	0x93, 0xD0, 0x78, 0x8D, 0x40, 0xF6, 0xDA, 0xAF, 0x36, 0x0B, 0x71, 0x19, 0x4C, 0x27, 0x3C, 0x04,
	0xAB, 0x74, 0xCC, 0x33, 0x37, 0x88, 0xA9, 0x12, 0x67, 0xF9, 0xFF, 0x54, 0xFD, 0x91, 0x38, 0x3E,
	0x0D, 0x48, 0x49, 0x8C, 0x57, 0x9D, 0x95, 0x5E, 0xCF, 0x58, 0xB6, 0xAB, 0xF9, 0x67, 0xA4, 0x9D,
	0xE3, 0x78, 0x64, 0x4F, 0x85, 0x2A, 0x90, 0x38, 0x47, 0x52, 0x62, 0x03, 0xD2, 0x66, 0xF6, 0xDE,
	0x80, 0x7B, 0x60, 0x44, 0x9E, 0x38, 0xC1, 0xF7, 0xDD, 0xD6, 0x4D, 0xD4, 0x16, 0xA5, 0x8E, 0xFD,
	0xB1, 0x18, 0xD2, 0xA2, 0x84, 0x73, 0x3D, 0xB6, 0x13, 0x4E, 0xE0, 0x52, 0x10, 0x16, 0x64, 0xFE,
	0x1A, 0x8D, 0x5C, 0x37, 0xF3, 0x72, 0x6E, 0x7F, 0x9E, 0xC3, 0xC2, 0x02, 0x75, 0x97, 0x98, 0xF2,
	0x9A, 0x82, 0x30, 0x1C, 0x7F, 0x6A, 0xF5, 0x95, 0x52, 0xCE, 0x7E, 0x97, 0xAA, 0xE7, 0x36, 0xFC,
	0xD1, 0xD2, 0x90, 0xFC, 0x6D, 0xB3, 0x9E, 0x09, 0x8E, 0x33, 0x1F, 0x64, 0x88, 0xB9, 0x25, 0xB3
	
};

unsigned char rol (unsigned char val, unsigned char bits) {
	return (val >>(8 -bits)) | (val <<bits);
}

void	DecryptWXN (void) {
	for (int i =0; i <RI.INES_PRGSize <<14; i++) (*PRG_ROM)[i] = rol( (*PRG_ROM)[i], i &7) -rol(WXNKey[i &0x1FF], i &7);
	for (int i =0; i <RI.INES_CHRSize <<13; i++) (*CHR_ROM)[i] = rol( (*CHR_ROM)[i], i &7) -rol(WXNKey[i &0x1FF], i &7);
}
} // namespace