﻿#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

namespace {
uint8_t ProtectionData[4], ProtectionIndex, PRGBank, HorizontalMirroring;
FCPUWrite _Write4;

static uint8_t ProtectionTable[256] = {
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x49, 0x19, 0x09, 0x59, 0x49, 0x19, 0x09,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x49, 0x19, 0x09, 0x59, 0x49, 0x19, 0x09,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x51, 0x41, 0x11, 0x01, 0x51, 0x41, 0x11, 0x01,
	0x00, 0x10, 0x40, 0x50, 0x00, 0x10, 0x40, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x18, 0x48, 0x58, 0x08, 0x18, 0x48, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x10, 0x40, 0x50, 0x00, 0x10, 0x40, 0x50, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x08, 0x18, 0x48, 0x58, 0x08, 0x18, 0x48, 0x58, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x58, 0x48, 0x18, 0x08, 0x58, 0x48, 0x18, 0x08,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x50, 0x40, 0x10, 0x00, 0x50, 0x40, 0x10, 0x00,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x58, 0x48, 0x18, 0x08, 0x58, 0x48, 0x18, 0x08,
	0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x50, 0x40, 0x10, 0x00, 0x50, 0x40, 0x10, 0x00,
	0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x19, 0x49, 0x59, 0x09, 0x19, 0x49, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x01, 0x11, 0x41, 0x51, 0x01, 0x11, 0x41, 0x51, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x09, 0x19, 0x49, 0x59, 0x09, 0x19, 0x49, 0x59, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};


void	Sync (void) {
	if (ROM->INES2_SubMapper ==1) {
		EMU->SetPRG_ROM32(0x8, MMC3::reg[6] >>2);
		MMC3::syncMirror();
	} else {
		EMU->SetPRG_ROM32(0x8, PRGBank);
		if (HorizontalMirroring)
			EMU->Mirror_H();
		else
			EMU->Mirror_V();
	}
	MMC3::syncCHR_ROM(0xFF, 0);
}

BOOL	MAPINT	Load (void) {
	MMC3::load(Sync);
	return TRUE;
}

int	MAPINT	ReadProtection (int Bank, int Addr) {
	return Addr>=0x800? ProtectionData[Addr &3]: 0xFF;
}

void	MAPINT	WriteProtection (int Bank, int Addr, int Val) {
	if (Addr &0x800)
		ProtectionData[Addr &3] = Val ^ ProtectionTable[ProtectionIndex];
	else
		ProtectionIndex =Val;
}

void	MAPINT	WritePRGMirroring (int Bank, int Addr, int Val) {
	if (Addr &0x800) {
		PRGBank = (Val &0x1) | ((Val >>3) &0x2);
		HorizontalMirroring = (Val & 0x20)? 1: 0;
		Sync();
	} else if (Bank==4)
		_Write4(Bank, Addr, Val);
}

void	MAPINT	Reset (RESET_TYPE ResetType) {
	if (ROM->INES2_SubMapper !=1) {
		_Write4 = EMU->GetCPUWriteHandler(0x4);
		EMU->SetCPUReadHandler(5, ReadProtection);
		EMU->SetCPUReadHandlerDebug(5, ReadProtection);
		EMU->SetCPUWriteHandler(5, WriteProtection);
		EMU->SetCPUWriteHandler(4, WritePRGMirroring);
		EMU->SetCPUWriteHandler(6, WritePRGMirroring);
		PRGBank = 3;
		HorizontalMirroring = 0;
	}
	MMC3::reset(ResetType);
}

int	MAPINT	SaveLoad (STATE_TYPE mode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(mode, offset, data);
	if (ROM->INES2_SubMapper !=1) {
		for (int i=0; i<6; i++) SAVELOAD_BYTE(mode, offset, data, ProtectionData[i]);
		SAVELOAD_BYTE(mode, offset, data, ProtectionIndex);
		SAVELOAD_BYTE(mode, offset, data, PRGBank);
		SAVELOAD_BYTE(mode, offset, data, HorizontalMirroring);
	}
	if (mode == STATE_LOAD) Sync();
	return offset;
}

uint16_t MapperNum = 208;
} // namespace

MapperInfo MapperInfo_208 ={
	&MapperNum,
	_T("哥德 SFIV"),
	COMPAT_FULL,
	Load,
	Reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	SaveLoad,
	NULL,
	NULL
};
