#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

#define mixedCHR  !!(reg[4] &0x01)
#define mixedMask   (reg[4] &0xFE)
namespace {
uint8_t		reg[8];

void	sync (void) {
	if (MMC3::wram &0x20) MMC3::wram &=~0x40; // Hack for FS005 games on Mindkids board that only work with emualtion.
	
	int prgMaskMMC3     = (reg[3] &0x10? 0x00: 0x0F) // PRG A13-A16
	                    | (reg[0] &0x40? 0x00: 0x10) // 128 KiB ^=PRG A17
	                    | (reg[1] &0x80? 0x00: 0x20) // 256 KiB ^=PRG A18
			    | (reg[1] &0x40? 0x40: 0x00) // 512 KiB ^=PRG A19
			    | (reg[1] &0x20? 0x80: 0x00);// 1 MiB   ^=PRG A20
	int prgMaskGNROM    = (reg[3] &0x10? (reg[1] &0x02? 0x03: 0x01): 0x00);
	int prgOffset       = (reg[3] &0x0E)
	                    |((reg[0] &0x07) <<4)
			    | (reg[1] &0x10? 0x80: 0x00)
			    |((reg[1] &0x0C) <<6)
			    |((reg[0] &0x30) <<6);
	int maskedPRGOffset = prgOffset &~(prgMaskMMC3 | prgMaskGNROM);
	for (int bank =0; bank <4; bank++) EMU->SetPRG_ROM8(0x8 +bank*2, MMC3::getPRGBank(bank) &prgMaskMMC3 | maskedPRGOffset | bank&prgMaskGNROM);
	
	int chrMaskMMC3     =  reg[3] &0x10? 0x00: reg[0] &0x80? 0x7F: 0xFF;
	int chrOffset       =((reg[0] &0x08) <<4)
	                    |((reg[2] &0x0F) <<3);
	int chrMaskGNROM    =  reg[3] &0x10? 0x07: 0x00;
	int maskedCHROffset = chrOffset &~(chrMaskMMC3 | chrMaskGNROM);
	for (int bank =0; bank <8; bank++) {
		if (mixedCHR && (MMC3::getCHRBank(bank) &0xFE) ==mixedMask)
			EMU->SetCHR_RAM1(bank, MMC3::getCHRBank(bank) &chrMaskMMC3 | maskedCHROffset | bank&chrMaskGNROM);
		else
			iNES_SetCHR_Auto1(bank, MMC3::getCHRBank(bank) &chrMaskMMC3 | maskedCHROffset | bank&chrMaskGNROM);
	}
				   
	// Incomplete MMC4 mode
	if (reg[3] &0x40) {
		if (~MMC3::pointer &0x40) {
			EMU->SetPRG_ROM8(0xC, maskedPRGOffset |(2 &prgMaskGNROM));
			EMU->SetPRG_ROM8(0xE, maskedPRGOffset |(3 &prgMaskGNROM));
		}
		EMU->SetCHR_RAM1(0x0 ^(MMC3::pointer &0x80? 4: 0), MMC3::reg[0] &chrMaskMMC3 |maskedCHROffset | 0&chrMaskGNROM);
		EMU->SetCHR_RAM1(0x1 ^(MMC3::pointer &0x80? 4: 0), 0x00         &chrMaskMMC3 |maskedCHROffset | 1&chrMaskGNROM);
		EMU->SetCHR_RAM1(0x2 ^(MMC3::pointer &0x80? 4: 0), MMC3::reg[1] &chrMaskMMC3 |maskedCHROffset | 2&chrMaskGNROM);
		EMU->SetCHR_RAM1(0x3 ^(MMC3::pointer &0x80? 4: 0), 0x00         &chrMaskMMC3 |maskedCHROffset | 3&chrMaskGNROM);
	}
	
	MMC3::syncMirror();
	MMC3::syncWRAM();	
}

void	MAPINT	writeReg (int bank, int addr, int val) {
	if (bank >=0x6) MMC3::wramWrite(bank, addr, val);
	
	if (~reg[3] &0x80 || reg[3] &0x10) {
		reg[addr &7] =val;
		if ((addr &7) ==5) EMU->DbgOut(L"r5=%02X", val);
		sync();
	}
}

BOOL	MAPINT	load (void) {
	iNES_SetSRAM();
	MMC3::load(sync);
	return TRUE;
}

void	MAPINT	reset (RESET_TYPE resetType) {
	for (auto& r: reg) r =0x00;
	MMC3::reset(RESET_HARD);
	if (ROM->INES_MapperNum ==224 || ROM->INES2_SubMapper &1)
		EMU->SetCPUWriteHandler(0x5, writeReg);
	else {
		EMU->SetCPUWriteHandler(0x6, writeReg);
		EMU->SetCPUWriteHandler(0x7, writeReg);
	}
}

int	MAPINT	saveLoad (STATE_TYPE stateMode, int offset, unsigned char *data) {
	offset =MMC3::saveLoad(stateMode, offset, data);
	for (auto& r: reg) SAVELOAD_BYTE(stateMode, offset, data, r);
	if (stateMode ==STATE_LOAD) sync();
	return offset;
}

uint16_t mapperNum224 =224;
uint16_t mapperNum268 =268;
} // namespace

MapperInfo MapperInfo_224 ={
	&mapperNum224,
	_T("Jncota KT-008"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};

MapperInfo MapperInfo_268 ={
	&mapperNum268,
	_T("KP6022/AA6023 ASIC"),
	COMPAT_FULL,
	load,
	reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	saveLoad,
	NULL,
	NULL
};