#include	"..\DLL\d_iNES.h"
#include	"..\Hardware\h_MMC3.h"

namespace {
uint8_t	Reg;

void	Sync (void) {
	uint8_t OuterBank =((Reg &0x08)? 1: 0) | ((Reg &0x10)? 2: 0) | ((Reg &0x40)? 4: 0);
	if (~Reg &0x20) { // NROM mode
		uint8_t InnerBank =Reg &7;
		if (InnerBank &3)
			EMU->SetPRG_ROM32(0x8,((OuterBank <<3) |InnerBank) >>1);
		else {
			EMU->SetPRG_ROM16(0x8, (OuterBank <<3) |InnerBank);
			EMU->SetPRG_ROM16(0xC, (OuterBank <<3) |InnerBank);
		}
		MMC3::syncCHR_ROM(0x7F, 0);
	} else if (Reg &0x80) {	// MMC3 256 KiB
		MMC3::syncPRG(0x1F, OuterBank <<5);
		MMC3::syncCHR_ROM(0xFF, OuterBank <<8);
	} else {	// MMC3 128 KiB
		MMC3::syncPRG(0x0F, OuterBank <<4);
		MMC3::syncCHR_ROM(0x7F, OuterBank <<7);
	}
	MMC3::syncMirror();
}

void	MAPINT	WriteReg (int Bank, int Addr, int Val) {
	Reg =Addr &0xFF;
	Sync();
}

BOOL	MAPINT	Load (void) {
	MMC3::load(Sync);
	return TRUE;
}

void	MAPINT	Reset (RESET_TYPE ResetType) {
	if (ResetType == RESET_HARD) Reg =0;
	MMC3::reset(ResetType);
	MMC3::setWRAMCallback(NULL, WriteReg);
}

int	MAPINT	SaveLoad (STATE_TYPE mode, int offset, unsigned char *data) {
	offset = MMC3::saveLoad(mode, offset, data);
	SAVELOAD_BYTE(mode, offset, data, Reg);
	if (mode == STATE_LOAD) Sync();
	return offset;
}

uint16_t MapperNum =322;
} // namespace

MapperInfo MapperInfo_322 = {
	&MapperNum,
	_T("6-15-C"),
	COMPAT_FULL,
	Load,
	Reset,
	NULL,
	MMC3::cpuCycle,
	MMC3::ppuCycle,
	SaveLoad,
	NULL,
	NULL
};