import json
import logging
from jsonschema import validate
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem

logger = logging.getLogger(__name__)
SUB_PARTITION_DIRECTORY_TYPES_JSON = 'layout/data/sub_partition_directory_types.json'
SUB_PARTITION_DIRECTORY_TYPES_SCHEMA_JSON = 'layout/data/JSON schemas/sub_partition_directory_types.json'


class SubPartitionDirectoryDescriptor(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START SubPartitionDirectoryDescriptor.__init__ FUNCTION')

        super(SubPartitionDirectoryDescriptor, self).__init__(data, **kwargs)
        self.set_sub_partition_directory_descriptor_attributes(
            kwargs['type'], kwargs['sub_partition_offset'], kwargs['sub_partition_size'])

    def set_sub_partition_directory_descriptor_attributes(self, sub_partition_directory_type, sub_partition_offset, sub_partition_size):
        try:
            with open(SUB_PARTITION_DIRECTORY_TYPES_JSON) as sub_partition_directory_types_json:
                sub_partition_directory_types = json.load(sub_partition_directory_types_json)
            with open(SUB_PARTITION_DIRECTORY_TYPES_SCHEMA_JSON) as sub_partition_directory_types_schema_json:
                sub_partition_directory_types_schema = json.load(
                    sub_partition_directory_types_schema_json)
            validate(instance=sub_partition_directory_types,
                     schema=sub_partition_directory_types_schema)
        except Exception:
            logger.exception('Exception occurred while reading sub partition types JSON file')
            raise Exception('Exception occurred while reading sub partition types JSON file')
        sub_partition_directory_type = DataItem(
            self.value, **sub_partition_directory_type)
        try:
            self.type = sub_partition_directory_types[sub_partition_directory_type.hex_value()]
        except KeyError:
            self.type = None
            logger.warning('sub partition has not been identified')
        self.sub_partition_offset = DataItem(
            self.value, **sub_partition_offset)
        self.sub_partition_size = DataItem(
            self.value, **sub_partition_size)
