import logging
from cse_image_items.BaseItem import BaseItem
from cse_image_items.DataItem import DataItem
from cse_image_items.Manifest import Manifest

logger = logging.getLogger(__name__)

class SubPartitionDirectoryEntry(BaseItem):
    def __init__(self, data, **kwargs):
        logger.info('START SubPartitionDirectoryEntry.__init__ FUNCTION')
        
        super(SubPartitionDirectoryEntry, self).__init__(data, **kwargs)
        self.entry_name = DataItem(self.value, **kwargs['entry_name'])
        self.entry_offset = DataItem(self.value, **kwargs['entry_offset'])
        self.entry_length = DataItem(self.value, **kwargs['entry_length'])
        self.manifest = None
        if self.is_manifest:
            self.manifest = Manifest(
                data,
                offset=self.entry_offset.hex_value(),
                size=self.entry_length.hex_value()
            )

    @property
    def is_manifest(self):
        return self.entry_name.str_value().endswith('.man')