@REM @file
@REM
@REM @copyright
@REM  INTEL CONFIDENTIAL
@REM  Copyright 2014 - 2015 Intel Corporation.
@REM
@REM  The source code contained or described herein and all documents related to the
@REM  source code ("Material") are owned by Intel Corporation or its suppliers or
@REM  licensors. Title to the Material remains with Intel Corporation or its suppliers
@REM  and licensors. The Material may contain trade secrets and proprietary and
@REM  confidential information of Intel Corporation and its suppliers and licensors,
@REM  and is protected by worldwide copyright and trade secret laws and treaty
@REM  provisions. No part of the Material may be used, copied, reproduced, modified,
@REM  published, uploaded, posted, transmitted, distributed, or disclosed in any way
@REM  without Intel's prior express written permission.
@REM
@REM  No license under any patent, copyright, trade secret or other intellectual
@REM  property right is granted to or conferred upon you by disclosure or delivery
@REM  of the Materials, either expressly, by implication, inducement, estoppel or
@REM  otherwise. Any license under such intellectual property rights must be
@REM  express and approved by Intel in writing.
@REM
@REM  Unless otherwise agreed by Intel in writing, you may not remove or alter
@REM  this notice or any other notice embedded in Materials by Intel or
@REM  Intel's suppliers or licensors in any way.
@REM
@REM  This file contains a 'Sample Driver' and is licensed as such under the terms
@REM  of your license agreement with Intel or your vendor. This file may be modified
@REM  by the user, subject to the additional terms of the license agreement.
@REM
@REM @par Specification Reference:
@REM


@echo on

@REM clear the previous setting.
@echo.>PlatformPkgExtConfig.dsc
@set EXT_CONFIG_CLEAR=TRUE

rem ------------------------------------------------------------------------------------------------
rem This tool assumes that it will be executed in PlatSamplePkg\
rem It will verify the compilation with SiBinPkg (Binary) instead of SiPkg (source code)
rem Usage:
rem   BinBuild r -> to compile with SiBin (Release BIN)
rem   BinBuild   -> to compile with SiDbgBin (Debug BIN)
rem ------------------------------------------------------------------------------------------------
  @echo gPlatformModuleTokenSpaceGuid.PcdSipkgBinaryEnable^|TRUE >> PlatformPkgExtConfig.dsc
  set BIN_BUILD_FAIL=0
  @set CurrDir=%CD%

@rem  @ECHO Copy SiPkg\Binaries\*.* to SiBinPkg and SiDbgBinPkg
@rem  XCOPY /I /S /Y ..\KabylakeSiliconPkg\Binaries\*.* ..\KabylakeSiliconBinPkg\Binaries\
@rem  XCOPY /I /S /Y ..\KabylakeSiliconPkg\Binaries\*.* ..\KabylakeSiliconDbgBinPkg\Binaries\

  @if "%1" == "r" (
    goto SiBinBuild
  )

  @ECHO Delete old DbgBinRomImages.7z
  del /F /Q ..\DbgBinRomImages.7z
  @ECHO Replace original SiPkg folder with SiDbgBinPkg
  @ECHO Compile Debug BIOS first
  cd..
  ren KabylakeSiliconPkg KabylakeSiliconSrcPkg
  @if %ERRORLEVEL% NEQ 0 (
  @ECHO Fail to rename folder!! Please re-run again!
    set BIN_BUILD_FAIL=1
    goto DbgRestore
  )
  ren KabylakeSiliconDbgBinPkg KabylakeSiliconPkg
  @if %ERRORLEVEL% NEQ 0 (
  @ECHO Fail to rename folder!! Please re-run again!
    set BIN_BUILD_FAIL=1
    goto DbgRestore
  )
  rd /s /q RomImages
  rd /s /q Build
  cd %CurrDir%
  call prep
  @if %ERRORLEVEL% NEQ 0 (
    set BIN_BUILD_FAIL=1
    goto DbgRestore
  )
  call bld
  @if %ERRORLEVEL% NEQ 0 (
    set BIN_BUILD_FAIL=1
  )

:DbgRestore
  cd %CurrDir%
  cd..
  ren KabylakeSiliconPkg KabylakeSiliconDbgBinPkg
  ren KabylakeSiliconSrcPkg KabylakeSiliconPkg
  cd %CurrDir%
  @if %BIN_BUILD_FAIL% NEQ 0 (
    @exit /b 1
  )
  @ECHO Zip RomImages to DbgBinRomImages
  @if exist "C:\Program Files\7-Zip" (
    call "C:\Program Files\7-Zip"\7z a ..\DbgBinRomImages.7z ..\RomImages
    goto BinBuildDone
  )
  @if exist "C:\Program Files (x86)\7-Zip" (
    call "C:\Program Files\7-Zip"\7z a ..\DbgBinRomImages.7z ..\RomImages
    goto BinBuildDone
  )
  @echo *** ERROR! No 7Z.exe found in the system. ***
    call ..\7z a ..\DbgBinRomImages.7z ..\RomImages
rem  @exit /b 1

:SiBinBuild
  @if %ERRORLEVEL% NEQ 0 (
    @exit /b 1
  )
  @ECHO Delete old RelBinRomImages.7z
  del /F /Q ..\RelBinRomImages.7z
  @ECHO Replace original SiPkg folder with SiBinPkg
  @ECHO Compile Release BIOS
  set BIN_BUILD_FAIL=0
  cd..
  ren KabylakeSiliconPkg KabylakeSiliconSrcPkg
  @if %ERRORLEVEL% NEQ 0 (
  @ECHO Fail to rename folder!! Please re-run again!
    set BIN_BUILD_FAIL=1
    goto RelRestore
  )
  ren KabylakeSiliconBinPkg KabylakeSiliconPkg
  @if %ERRORLEVEL% NEQ 0 (
  @ECHO Fail to rename folder!! Please re-run again!
    set BIN_BUILD_FAIL=1
    goto RelRestore
  )
  rd /s /q RomImages
  rd /s /q Build
  cd %CurrDir%
  call prep r
  @if %ERRORLEVEL% NEQ 0 (
    set BIN_BUILD_FAIL=1
    goto RelRestore
  )
  call bld
  @if %ERRORLEVEL% NEQ 0 (
    set BIN_BUILD_FAIL=1
  )

:RelRestore
  cd %CurrDir%
  cd..
  ren KabylakeSiliconPkg KabylakeSiliconBinPkg
  ren KabylakeSiliconSrcPkg KabylakeSiliconPkg
  cd %CurrDir%
  @if %BIN_BUILD_FAIL% NEQ 0 (
    @exit /b 1
  )

  @ECHO Zip RomImages to RelBinRomImages
  @if exist "C:\Program Files\7-Zip" (
    call "C:\Program Files\7-Zip"\7z a ..\RelBinRomImages.7z ..\RomImages
    goto BinBuildDone
  )
  @if exist "C:\Program Files (x86)\7-Zip" (
    call "C:\Program Files\7-Zip"\7z a ..\RelBinRomImages.7z ..\RomImages
    goto BinBuildDone
  )
  @echo *** ERROR! No 7Z.exe found in the system. ***
    call ..\7z a ..\RelBinRomImages.7z ..\RomImages
rem  @exit /b 1

:BinBuildDone
  @if %ERRORLEVEL% NEQ 0 (
    @exit /b 1
  )
