/**@file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2006 - 2014 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _GET_IMAGE_H_
#define _GET_IMAGE_H_

EFI_STATUS
GetImageEx (
  IN  EFI_HANDLE         ImageHandle,
  IN  EFI_GUID           *NameGuid,
  IN  EFI_SECTION_TYPE   SectionType,
  OUT VOID               **Buffer,
  OUT UINTN              *Size,
  BOOLEAN                WithinImageFv
  )
/*++

Routine Description:
  Search FVs, and fill Buffer with the SectionType section content in NameGuid file.
  If ImageHandle is not NULL, the FV from which the ImageHandle is loaded is searched
  first. If WithinImageFv is TRUE, only the FV from which the ImageHandle is loaded
  is searched. If ImageHandle is NULL or WithinImageFv is FALSE, all FVs in the system
  is searched.

  Note:
  1. when SectionType is EFI_SECTION_PE32, it tries to read NameGuid file after failure on
      reading EFI_SECTION_PE32 section.
  2. when SectionType is EFI_SECTION_TE, it tries to get EFI_SECTION_PE32 section after failure on
      reading EFI_SECTION_TE section. If it's failed again, it tries to read NameGuid file.
  3. Callee allocates memory, which caller is responsible to free.

Arguments:

  ImageHandle         - The caller's driver image handle.
  NameGuid            - Pointer to EFI_GUID, which is file name.
  SectionType         - Required section type.
  Buffer              - Pointer to a pointer in which the read content is returned.
                          Caller is responsible to free Buffer.
  Size                - Pointer to a UINTN, which indicates the size of returned *Buffer.
  WithinImageFv       - Whether the search only performs on the FV from which the caller's
                        driver image is loaded.

Returns:
  EFI_INVALID_PARAMETER - ImageHandle is NULL and WithinImageFv is TRUE.
  EFI_NOT_FOUND         - Required content can not be found.
  EFI_SUCCESS           - Required content can be found, but whether the Buffer is filled
                          with section content or not depends on the Buffer and Size.
--*/
;

#endif //_GET_IMAGE_H_
