/**@file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2009 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification
**/

#ifndef _TYPEDEF_H_
#define _TYPEDEF_H_

#ifdef _MSC_VER
// disable the "zero-sized array" warning
#pragma warning(disable:4200)
#endif

/*++
********************************************************************************
**
** FUNCTION:  C_ASSERT
**
** DESCRIPTION:
**   C_ASSERT() can be used to perform many compile-time assertions:
**   type sizes, field offsets, etc.
**   An assertion failure results in error C2118: negative subscript.
**
********************************************************************************
--*/

#if defined(_DOS) || defined(_LINUX)
#define C_ASSERT(x)
#else
#define C_ASSERT(e) typedef char __C_ASSERT__[(e)?1:-1]
#endif

//#ifdef EFIX64
#define bool BOOLEAN
//#endif


#ifdef WIN32
/*++
********************************************************************************
**
** FUNCTION:  C_ASSERT
**
** DESCRIPTION:
**   C_ASSERT() can be used to perform many compile-time assertions:
**   type sizes, field offsets, etc.
**   An assertion failure results in error C2118: negative subscript.
**
********************************************************************************
--*/
#define C_ASSERT(e) typedef char __C_ASSERT__[(e)?1:-1]
#endif

#ifdef _LINUX
#define U32 unsigned long
#define U8 unsigned char
#define U16 unsigned short
#else

#ifndef EFIX64
#ifndef _BASETSD_H_
typedef unsigned char UINT8;
typedef unsigned short UINT16;
#ifndef _DOS
typedef unsigned int UINT32;
#endif
#endif
#endif

//#ifdef EFIX64

#define true  1
#define false 0
#define True  1
#define False 0


#ifdef _MSC_VER
typedef UINT32 DWORD;
typedef DWORD * PDWORD, *DWORD_PTR;
typedef char INT8;
typedef UINT8 UCHAR;
typedef INT8 CHAR;
typedef CHAR * PCHAR;
//typedef CHAR GUID[16];
#endif

//#endif





#ifdef __cplusplus
extern "C" {
#endif

typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef short INT16;

typedef UINT8 U8;
typedef UINT16 U16;
typedef unsigned int U32;

typedef struct
{
   unsigned long  Data1;
   unsigned short Data2;
   unsigned short Data3;
   unsigned char  Data4[8];
} _UUID;

#ifdef __cplusplus
}
#endif

#endif


/** Declare a structure before it is used to allow of structure pointers within the structure */
#define FORWARD_DECLARATION(x)    typedef struct _##x x

//typedef unsigned int UINT;              /**< Unsigned Integer */
//typedef int INT;          /**< Integer (INT) */


#endif

