;
; This file contains a 'Sample Driver' and is licensed as such
; under the terms of your license agreement with Intel or your
; vendor.  This file may be modified by the user, subject to  
; the additional terms of the license agreement               
;
;
; Copyright (c) 2010 - 2011, Intel Corporation. All rights reserved.<BR>
; This software and associated documentation (if any) is furnished
; under a license and may only be used or copied in accordance
; with the terms of the license. Except as permitted by such
; license, no part of this software or documentation may be
; reproduced, stored in a retrieval system, or transmitted in any
; form or by any means without the express written consent of
; Intel Corporation.
;
;
; Module Name:
; 
;    Smi.inc
;

ISSUE_ASMI MACRO cmd, ah_value, bx_value, cx_value, syntax
ifnb    <syntax>
        .err
endif
ifnb <cx_value>
        push    cx
        mov     cx,cx_value
endif
ifnb <bx_value>
        push    bx
        mov     bx,bx_value
endif
ifnb <ah_value>
        mov     ah,ah_value
endif

        mov     al,cmd
        ASMI

ifnb <bx_value>
        pop     bx
endif
ifnb <cx_value>
        pop     cx
endif
ENDM

APMC                    EQU     0B2h

ASMI MACRO
        out     APMC , al
        WAFORIO
ENDM

MAGIC_STONE     equ     (84h)           ; An unused I/O Port
WAFORIO macro                           ; Delay about a microsecond.
        out     MAGIC_STONE,al          ; Must not change CPU state.
endm                                    ;

;----------------------------------------------------------------
TCG_SMI_STATUS                  equ     TCG_StatusCheck                 ;000h
TCG_SMI_HASHLOGEXTEND           equ     TCG_HashLogExtendEvent          ;001h
TCG_SMI_PTTT                    equ     TCG_PassThroughToTPM            ;002h
TCG_SMI_SHUTDOWN                equ     TCG_ShutdownPreBootInterface    ;003h
TCG_SMI_HASHLOG                 equ     TCG_LogEvent                    ;004h
TCG_SMI_HASH                    equ     TCG_HashAll                     ;005h
TCG_SMI_TSS                     equ     TCG_TSS                         ;006h
TCG_SMI_COMPACTHASHLOGEXTEND    equ     TCG_CompactHashLogExtendEvent   ;007h
TCG_SMI_MOR                     equ     TCG_MemoryOverwriteRequest      ;008h
TCG_SMI_DRVRINIT                equ     020h                            ;020h

