//
// This file contains 'Framework Code' and is licensed as such
// under the terms of your license agreement with Intel or your
// vendor.  This file may not be modified, except as allowed by
// additional terms of your license agreement.
//
/** @file
Header file for MP table builder.

Copyright (c) 2010, Intel Corporation. All rights reserved.<BR>
This software and associated documentation (if any) is furnished
under a license and may only be used or copied in accordance
with the terms of the license. Except as permitted by such
license, no part of this software or documentation may be
reproduced, stored in a retrieval system, or transmitted in any
form or by any means without the express written consent of
Intel Corporation.

**/

#ifndef __MPTABLE__PLATFORM_CONFIG_H__
#define __MPTABLE__PLATFORM_CONFIG_H__

#define ISA_IRQ_MASK      0xFFFF

#define MP_TABLE_MAX_BUS_ENTRIES        0xFF //from 0 to 0xFE, FF reserved means no parent bus
#define MP_TABLE_MAX_IO_APIC_ENTRIES    0x10

#define IO_APIC_BASE_ADDRESS_BOTTOM 0xFEC00000
#define IO_APIC_BASE_ADDRESS_TOP    0xFED00000
#define IO_APIC_SEARCH_STEP         0x1000

#define IO_APIC_INDEX_REG   0x0
#define IO_APIC_DATA_REG    0x4 //(0x10 in bytes = 0x4 in dwords

#define IO_APIC_MAP_ID_REG        0x0
#define IO_APIC_MAP_VERSION_REG   0x1

#define EFI_MSR_IA32_APIC_BASE                0x1B
#define APIC_REGISTER_APIC_VERSION_OFFSET     0x30
#define EFI_EXT_XAPIC_VERSION                 0x803
#define B_EFI_MSR_IA32_APIC_BASE_G_XAPIC      0x800
#define B_EFI_MSR_IA32_APIC_BASE_M_XAPIC      0x400

#define MP_TABLE_MAX_LEN                      4096
#define MP_EX_TABLE_MAX_LEN                   2048
#endif
