/** @file
  Header file for NV data structure definition.

Copyright (c) 2011 - 2014, Intel Corporation. All rights reserved.<BR>
This program and the accompanying materials 
are licensed and made available under the terms and conditions of the BSD License 
which accompanies this distribution.  The full text of the license may be found at 
http://opensource.org/licenses/bsd-license.php

THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS, 
WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#ifndef __TCG_CONFIG_NV_DATA_H__
#define __TCG_CONFIG_NV_DATA_H__

#include <Guid/HiiPlatformSetupFormset.h>
#include <Guid/PhysicalPresenceData.h>
#include <Guid/TcgConfigHii.h>

#define TCG_CONFIGURATION_VARSTORE_ID  0x0002           // ROYAL_PARK_OVERRIDE - RPPO0010
#define TCG_CONFIGURATION_FORM_ID      0x0001

#define KEY_TPM_ACTION                         0x3000

#define LABEL_TCG_CONFIGURATION_TPM_OPERATION  0x0001
#define LABEL_END                              0xffff

//
// Nv Data structure referenced by IFR
//
typedef struct {
//  UINT8   TpmOperation;                               // ROYAL_PARK_OVERRIDE - RPPO0010
  BOOLEAN TpmEnable;
  BOOLEAN TpmActivate;
} TCG_CONFIGURATION;

//
// ROYAL_PARK_OVERRIDE: RoyalParkOverrideBegin - RPPO0010
//
#ifndef SETUP_GUID
#define SETUP_GUID { 0xEC87D643, 0xEBA4, 0x4BB5, 0xA1, 0xE5, 0x3F, 0x3E, 0x36, 0xB2, 0x0D, 0xA9 }
#endif

#ifndef TCG_SETUP_NAME
#define TCG_SETUP_NAME         L"TcgSetup"
#endif

#pragma pack(1)
typedef struct {
  UINT8   dTpm12Present;
  BOOLEAN HideTpm;
  UINT8   TpmCurrentState;
  BOOLEAN MorState;
  UINT8   dTpm20Present;
  UINT8   TpmOperation;
  UINT8   PttPresent;
} TCG_SETUP;
#pragma pack()
//
// ROYAL_PARK_OVERRIDE: RoyalParkOverrideEnd
//

#endif
