## @file
#  Platform description.
#
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2008 - 2019 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification
##
[Defines]
  #
  # Set platform specific package/folder name, same as passed from PREBUILD script.
  # PLATFORM_PACKAGE would be the same as PLATFORM_NAME as well as package build folder
  # DEFINE only takes effect at R9 DSC and FDF.
  #
  DEFINE      PLATFORM_PACKAGE                = KabylakePlatSamplePkg
  DEFINE      PLATFORM_SI_PACKAGE             = KabylakeSiliconPkg
  DEFINE      CLIENT_COMMON_PACKAGE           = ClientCommonPkg         # AdvancedFeaturesContent
  DEFINE      PLATFORMFSP_PACKAGE             = KabylakeFspPkg          # AdvancedFeaturesContent


  DEFINE      PLATFORM_FEATURES_PATH          = $(PLATFORM_PACKAGE)/Features     # AdvancedFeaturesContent

[PcdsFeatureFlag]
  #
  # Platform On/Off features are defined here
  #
  !include $(PLATFORM_PACKAGE)/PlatformPkgConfig.dsc
  !include $(PLATFORM_PACKAGE)/PlatformPkgExtConfig.dsc
  !include $(PLATFORM_PACKAGE)/PlatformPkgConfigOverride.dsc

################################################################################
#
# Defines Section - statements that will be processed to create a Makefile.
#
################################################################################
[Defines]
  PLATFORM_NAME                       = $(PLATFORM_PACKAGE)
  PLATFORM_GUID                       = 465B0A0B-7AC1-443b-8F67-7B8DEC145F90
  PLATFORM_VERSION                    = 0.1
  DSC_SPECIFICATION                   = 0x00010005
  OUTPUT_DIRECTORY                    = Build/$(PLATFORM_PACKAGE)
  SUPPORTED_ARCHITECTURES             = IA32|X64
  BUILD_TARGETS                       = DEBUG|RELEASE
  SKUID_IDENTIFIER                    = DEFAULT

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  !include $(PLATFORM_PACKAGE)/CapsuleUpdateConfig/UpdateConfig.dsc
!endif

  FLASH_DEFINITION                    = $(PLATFORM_PACKAGE)/PlatformPkg.fdf

!if gPlatformModuleTokenSpaceGuid.PcdLfmaEnable == TRUE
  FIX_LOAD_TOP_MEMORY_ADDRESS         = 0xFFFFFFFFFFFFFFFF
  DEFINE   TOP_MEMORY_ADDRESS         = 0xFFFFFFFFFFFFFFFF
!else
  FIX_LOAD_TOP_MEMORY_ADDRESS         = 0x0
  DEFINE   TOP_MEMORY_ADDRESS         = 0x0
!endif

  #
  # Default value for PlatformPkg.fdf use
  #
  DEFINE BIOS_SIZE_OPTION = SIZE_70

!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  DEFINE     TRACEHUB     = TraceHub
  EDK_GLOBAL TRACEHUB     = TraceHub
!else
  DEFINE     TRACEHUB     =
  EDK_GLOBAL TRACEHUB     =
!endif

  DEFINE   COV_TOOLS                  = VS2008


################################################################################
#
# SKU Identification section - list of all SKU IDs supported by this
#                              Platform.
#
################################################################################
[SkuIds]
  0|DEFAULT              # The entry: 0|DEFAULT is reserved and always required.

################################################################################
#
# Library Class section - list of all Library Classes needed by this Platform.
#
################################################################################
[LibraryClasses.common]
  #
  # Entry point
  #
  PeiCoreEntryPoint|MdePkg/Library/PeiCoreEntryPoint/PeiCoreEntryPoint.inf
  PeimEntryPoint|MdePkg/Library/PeimEntryPoint/PeimEntryPoint.inf
  DxeCoreEntryPoint|MdePkg/Library/DxeCoreEntryPoint/DxeCoreEntryPoint.inf
  UefiDriverEntryPoint|MdePkg/Library/UefiDriverEntryPoint/UefiDriverEntryPoint.inf
  UefiApplicationEntryPoint|MdePkg/Library/UefiApplicationEntryPoint/UefiApplicationEntryPoint.inf
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  SerialPortLib|MdeModulePkg/Library/BaseSerialPortLib16550/BaseSerialPortLib16550.inf
  PeCoffExtraActionLib|SourceLevelDebugPkg/Library/PeCoffExtraActionLibDebug/PeCoffExtraActionLibDebug.inf
!if gPlatformModuleTokenSpaceGuid.PcdSourceDebugUseUsb != TRUE
  DebugCommunicationLib|SourceLevelDebugPkg/Library/DebugCommunicationLibSerialPort/DebugCommunicationLibSerialPort.inf
!else
  DebugCommunicationLib|SourceLevelDebugPkg/Library/DebugCommunicationLibUsb/DebugCommunicationLibUsb.inf
!endif
!else
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  SerialPortLib|MdeModulePkg/Library/BaseSerialPortLib16550/BaseSerialPortLib16550.inf
!else
  SerialPortLib|$(PLATFORM_PACKAGE)/Library/BaseSerialPortLib/BaseSerialPortLib$(TRACEHUB).inf
!endif
  PeCoffExtraActionLib|MdePkg/Library/BasePeCoffExtraActionLibNull/BasePeCoffExtraActionLibNull.inf
!endif

  #
  # Basic
  #
  BaseLib|MdePkg/Library/BaseLib/BaseLib.inf
  BaseMemoryLib|MdePkg/Library/BaseMemoryLibRepStr/BaseMemoryLibRepStr.inf
  PlatformVariableLib|$(PLATFORM_PACKAGE)/Library/BasePlatformVariableLib/BasePlatformVariableLib.inf # AdvancedFeaturesContent

  PrintLib|MdePkg/Library/BasePrintLib/BasePrintLib.inf
  CpuLib|MdePkg/Library/BaseCpuLib/BaseCpuLib.inf
  IoLib|MdePkg/Library/BaseIoLibIntrinsic/BaseIoLibIntrinsic.inf
!if gPlatformModuleTokenSpaceGuid.PcdEcEnable == TRUE
  EcLib|$(PLATFORM_PACKAGE)/Library/BaseEcLib/BaseEcLib.inf
  EcHwLib|$(PLATFORM_PACKAGE)/Library/BaseEcHwLib/BaseEcHwLib.inf
  EcMiscLib|$(PLATFORM_PACKAGE)/Library/BaseEcMiscLib/BaseEcMiscLib.inf
!else
  EcLib|$(PLATFORM_PACKAGE)/Library/BaseEcLibNull/BaseEcLibNull.inf
  EcMiscLib|$(PLATFORM_PACKAGE)/Library/BaseEcMiscLibNull/BaseEcMiscLibNull.inf
!endif
  PciLib|MdePkg/Library/BasePciLibCf8/BasePciLibCf8.inf
  BasePciLibPciExpress|MdePkg/Library/BasePciLibPciExpress/BasePciLibPciExpress.inf
#  PciLib|MdePkg/Library/BasePciLibPciExpress/BasePciLibPciExpress.inf
  PciCf8Lib|MdePkg/Library/BasePciCf8Lib/BasePciCf8Lib.inf
  PciExpressLib|MdePkg/Library/BasePciExpressLib/BasePciExpressLib.inf
  PciSegmentLib|MdePkg/Library/BasePciSegmentLibPci/BasePciSegmentLibPci.inf
  CacheMaintenanceLib|MdePkg/Library/BaseCacheMaintenanceLib/BaseCacheMaintenanceLib.inf
  PeCoffLib|MdePkg/Library/BasePeCoffLib/BasePeCoffLib.inf
  PeCoffGetEntryPointLib|MdePkg/Library/BasePeCoffGetEntryPointLib/BasePeCoffGetEntryPointLib.inf
  SortLib|MdeModulePkg/Library/BaseSortLib/BaseSortLib.inf
  #
  # UEFI & PI
  #
  UefiBootServicesTableLib|MdePkg/Library/UefiBootServicesTableLib/UefiBootServicesTableLib.inf
  UefiRuntimeServicesTableLib|MdePkg/Library/UefiRuntimeServicesTableLib/UefiRuntimeServicesTableLib.inf
  UefiRuntimeLib|MdePkg/Library/UefiRuntimeLib/UefiRuntimeLib.inf
  UefiLib|MdePkg/Library/UefiLib/UefiLib.inf
  HiiLib|MdeModulePkg/Library/UefiHiiLib/UefiHiiLib.inf
  UefiHiiServicesLib|MdeModulePkg/Library/UefiHiiServicesLib/UefiHiiServicesLib.inf
  DevicePathLib|$(PLATFORM_PACKAGE)/Override/MdePkg/Library/UefiDevicePathLib/UefiDevicePathLib.inf

#
# SICO-KBL-0009: RoyalParkOverrideBegin
#
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  UefiDecompressLib|MdePkg/Library/BaseUefiDecompressLib/BaseUefiDecompressLib.inf
!else
  UefiDecompressLib|$(PLATFORM_SI_PACKAGE)/Override/MdePkg/Library/BaseUefiDecompressLib/BaseUefiDecompressLib.inf
!endif
#
# SICO-KBL-0009: RoyalParkOverrideEnd
#
  PeiServicesTablePointerLib|MdePkg/Library/PeiServicesTablePointerLibIdt/PeiServicesTablePointerLibIdt.inf
  PeiServicesLib|MdePkg/Library/PeiServicesLib/PeiServicesLib.inf
  DxeServicesLib|MdePkg/Library/DxeServicesLib/DxeServicesLib.inf
  DxeServicesTableLib|MdePkg/Library/DxeServicesTableLib/DxeServicesTableLib.inf
  UefiCpuLib|UefiCpuPkg/Library/BaseUefiCpuLib/BaseUefiCpuLib.inf

  #
  # Framework
  #
!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  S3BootScriptLib|MdeModulePkg/Library/PiDxeS3BootScriptLib/DxeS3BootScriptLib.inf
!else
  S3BootScriptLib|MdePkg/Library/BaseS3BootScriptLibNull/BaseS3BootScriptLibNull.inf
!endif
  S3IoLib|MdePkg/Library/BaseS3IoLib/BaseS3IoLib.inf
  S3PciLib|MdePkg/Library/BaseS3PciLib/BaseS3PciLib.inf

  #
  # Generic Modules
  #
!if gPlatformModuleTokenSpaceGuid.PcdUsbEnable == TRUE
  UefiUsbLib|MdePkg/Library/UefiUsbLib/UefiUsbLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdScsiEnable == TRUE
  UefiScsiLib|MdePkg/Library/UefiScsiLib/UefiScsiLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdNetworkEnable == TRUE
  NetLib|MdeModulePkg/Library/DxeNetLib/DxeNetLib.inf
  IpIoLib|MdeModulePkg/Library/DxeIpIoLib/DxeIpIoLib.inf
  UdpIoLib|MdeModulePkg/Library/DxeUdpIoLib/DxeUdpIoLib.inf
  TcpIoLib|MdeModulePkg/Library/DxeTcpIoLib/DxeTcpIoLib.inf
  DpcLib|MdeModulePkg/Library/DxeDpcLib/DxeDpcLib.inf
!endif

  OemHookStatusCodeLib|MdeModulePkg/Library/OemHookStatusCodeLibNull/OemHookStatusCodeLibNull.inf
  CapsuleLib|MdeModulePkg/Library/DxeCapsuleLibNull/DxeCapsuleLibNull.inf

  LogoLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeLogoLib/DxeLogoLib.inf # AdvancedFeaturesContent
  UefiBootManagerLib|$(PLATFORM_PACKAGE)/Override/MdeModulePkg/Library/UefiBootManagerLib/UefiBootManagerLib.inf  #RPPO-KBL-0038
  SynchronizationLib|MdePkg/Library/BaseSynchronizationLib/BaseSynchronizationLib.inf
  SecurityManagementLib|MdeModulePkg/Library/DxeSecurityManagementLib/DxeSecurityManagementLib.inf
  SmmCorePlatformHookLib|MdeModulePkg/Library/SmmCorePlatformHookLibNull/SmmCorePlatformHookLibNull.inf
  IoApicLib|PcAtChipsetPkg/Library/BaseIoApicLib/BaseIoApicLib.inf

#
# AdvancedFeaturesBegin
#
!if gPlatformModuleTokenSpaceGuid.PcdPlatformCmosAccessSupport == TRUE
  CmosAccessLib|BpCommonPkg/Library/CmosAccessLib/CmosAccessLib.inf
!else
  CmosAccessLibNull|$(PLATFORM_PACKAGE)/Override/BpCommonPkg/Library/CmosAccessLibNull/CmosAccessLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  PostCodeLib|MdePkg/Library/BasePostCodeLibPort80/BasePostCodeLibPort80.inf
!else
  PostCodeLib|$(CLIENT_COMMON_PACKAGE)/Library/BasePostCodeLibPort80Ex/BasePostCodeLibPort80Ex.inf
!endif
  BeepLib|$(PLATFORM_PACKAGE)/Library/BeepLib/BeepLib.inf # AdvancedFeaturesContent

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf
!else
  DebugPrintErrorLevelLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseDebugPrintErrorLevelLibCmosPcd/BaseDebugPrintErrorLevelLibCmosPcd.inf
  SerialPortParameterLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseSerialPortParameterLibCmos/BaseSerialPortParameterLibCmos.inf
  Usb3DebugPortParameterLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseUsb3DebugPortParameterLibCmos/BaseUsb3DebugPortParameterLibCmos.inf
  DebugPropertyLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseDebugPropertyLibCmosPcd/BaseDebugPropertyLibCmosPcd.inf
!endif
  CustomizedDisplayLib|MdeModulePkg/Library/CustomizedDisplayLib/CustomizedDisplayLib.inf

  #
  # CPU
  #
  MtrrLib|UefiCpuPkg/Library/MtrrLib/MtrrLib.inf
  LocalApicLib|UefiCpuPkg/Library/BaseXApicX2ApicLib/BaseXApicX2ApicLib.inf
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  SmmCpuFeaturesLib|UefiCpuPkg/Library/SmmCpuFeaturesLib/SmmCpuFeaturesLib.inf
!else
  SmmCpuFeaturesLib|$(PLATFORM_PACKAGE)/Override/IA32FamilyCpuPkg/Library/SmmCpuFeaturesLib/SmmCpuFeaturesLib.inf
!endif
  #
  # PCH
  #
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  SmmPchLib|$(PLATFORM_PACKAGE)/Library/SmmPchLib/SmmPchLib.inf
  BaseFlashDecodeLib|$(PLATFORM_PACKAGE)/Library/BaseFlashDecodeLib/BaseFlashDecodeLib.inf
  SmmIoLib|$(PLATFORM_PACKAGE)/Library/SmmIo/SmmIoLib.inf
  #I2cDriverLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseI2cDriverLib/BaseI2cDriverLib.inf
!endif

  #
  # Platform
  #
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/DxeAcpiTimerLib.inf
!else
  TimerLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseAcpiTimerLib/BaseAcpiTimerLib.inf
  BasePlatformTimerLib|$(PLATFORM_PACKAGE)/Library/BasePlatformTimerLib/BasePlatformTimerLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  PlatformBootManagerLib|$(PLATFORM_PACKAGE)/Library/DxePlatformBootManagerLib/DxePlatformBootManagerLib.inf
!else
  PlatformBootManagerLib|$(PLATFORM_PACKAGE)/Library/DxePlatformBootManagerLib/DxePlatformBootManagerHiiFreeLib.inf
!endif
  I2cAccessLib|$(PLATFORM_PACKAGE)/Library/PeiI2cAccessLib/PeiI2cAccessLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdGpioExpanderEnable == TRUE
  GpioExpanderLib|$(PLATFORM_PACKAGE)/Library/BaseGpioExpanderLib/BaseGpioExpanderLib.inf
!else
  GpioExpanderLib|$(PLATFORM_PACKAGE)/Library/BaseGpioExpanderLibNull/BaseGpioExpanderLibNull.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdSkipFspTempRamInitAndExit == TRUE
  CacheAsRamLib|KabylakeFspPkg/Library/BaseCacheAsRamLib/BaseCacheAsRamLib.inf # AdvancedFeaturesContent
!else
  CacheAsRamLib|IntelFsp2Pkg/Library/BaseCacheAsRamLibNull/BaseCacheAsRamLibNull.inf
!endif
!endif
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  PlatformSecLib|$(PLATFORM_SI_PACKAGE)/SampleCode/Library/PlatformSecLib/PlatformSecLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdPlatformCmosAccessSupport == TRUE
  PlatformCmosAccessLib|$(PLATFORM_PACKAGE)/Library/PlatformCmosAccessLib/PlatformCmosAccessLib.inf
!else
  PlatformCmosAccessLibNull|BpCommonPkg/Library/PlatformCmosAccessLibNull/PlatformCmosAccessLibNull.inf
!endif # PcdPlatformCmosAccessSupport
  PlatformPostCodeMapLib|$(CLIENT_COMMON_PACKAGE)/Library/BasePlatformPostCodeMapLib/BasePlatformPostCodeMapLib.inf
  PlatformBeepMapLib|$(CLIENT_COMMON_PACKAGE)/Library/BasePlatformBeepMapLib/BasePlatformBeepMapLib.inf
  BaseAmtWrapperLib|$(PLATFORM_PACKAGE)/Library/BaseAmtWrapperLib/BaseAmtWrapperLib.inf
!endif # PcdMinTreeEnable
  PlatformHookLib|$(PLATFORM_PACKAGE)/Library/BasePlatformHookLib/BasePlatformHookLib.inf
#
# AdvancedFeaturesBegin
#
  HidI2cPlatformSupportLib|$(PLATFORM_PACKAGE)/Library/DxeHidI2cPlatformSupportLib/DxeHidI2cPlatformSupportLib.inf
  TbtCommonLib|$(PLATFORM_PACKAGE)/Library/TbtCommonLib/TbtCommonLib.inf
  DxeTbtSecurityLib|$(PLATFORM_PACKAGE)/Features/Tbt/Library/DxeTbtSecurityLib/DxeTbtSecurityLib.inf
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  DxeInstallOptionRomLib|$(PLATFORM_PACKAGE)/Library/DxeInstallOptionRomLib/DxeInstallOptionRomLib.inf
!else
  DxeInstallOptionRomLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeInstallOptionRomLibNull/DxeInstallOptionRomLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#

  #
  # Misc
  #
!if $(TARGET) == RELEASE
!if (gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable == TRUE) AND (gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE)
  DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
!else
  DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
!endif
!else
  DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
!endif

  PerformanceLib|MdePkg/Library/BasePerformanceLibNull/BasePerformanceLibNull.inf
  PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
#
# AdvancedFeaturesBegin
#
  TpmCommLib|SecurityPkg/Library/TpmCommLib/TpmCommLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  Tpm12DeviceLib|SecurityPkg/Library/Tpm12DeviceLibDTpm/Tpm12DeviceLibDTpm.inf
  Tpm12CommandLib|SecurityPkg/Library/Tpm12CommandLib/Tpm12CommandLib.inf
!endif
  Tpm2CommandLib|SecurityPkg/Library/Tpm2CommandLib/Tpm2CommandLib.inf
  TpmMeasurementLib|SecurityPkg/Library/DxeTpmMeasurementLib/DxeTpmMeasurementLib.inf
#
# AdvancedFeaturesEnd
#
  DebugAgentLib|MdeModulePkg/Library/DebugAgentLibNull/DebugAgentLibNull.inf

  #
  # Opal
  #
!if gPlatformModuleTokenSpaceGuid.PcdOpalPasswordEnable == TRUE
!if (gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE) OR (gPlatformModuleTokenSpaceGuid.PcdNvmeEnable == TRUE)
  TcgStorageCoreLib|SecurityPkg/Library/TcgStorageCoreLib/TcgStorageCoreLib.inf
  TcgStorageOpalLib|SecurityPkg/Library/TcgStorageOpalLib/TcgStorageOpalLib.inf
  OpalPasswordSupportLib|SecurityPkg/Library/OpalPasswordSupportLib/OpalPasswordSupportLib.inf
!endif
!endif

  #
  # CryptLib
  #
#!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  IntrinsicLib|CryptoPkg/Library/IntrinsicLib/IntrinsicLib.inf
  OpensslLib|CryptoPkg/Library/OpensslLib/OpensslLib.inf
#!endif

#
# AdvancedFeaturesBegin
#
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  TraceHubHookLib|$(PLATFORM_SI_PACKAGE)/Pch/Library/PeiDxeSmmTraceHubLib/PeiDxeSmmTraceHubLib.inf
!else
  TraceHubHookLib|BpCommonPkg/Library/TraceHubHookLibNull/TraceHubHookLibNull.inf
!endif
  ThunkLib|$(CLIENT_COMMON_PACKAGE)/Library/PeiDxeSmmThunkLib/PeiDxeSmmThunkLib.inf
  BootGuardRevocationLib|$(PLATFORM_PACKAGE)/Library/BootGuardRevocationLib/BootGuardRevocationLib.inf
  DTSHookLib|$(PLATFORM_PACKAGE)/Library/DTSHookLib/Smm/DTSHookLib.inf
#
# AdvancedFeaturesEnd
#


!if gPlatformModuleTokenSpaceGuid.PcdUefiShellBuildSource == TRUE
  ShellCommandLib|ShellPkg/Library/UefiShellCommandLib/UefiShellCommandLib.inf
  HandleParsingLib|ShellPkg/Library/UefiHandleParsingLib/UefiHandleParsingLib.inf
  BcfgCommandLib|ShellPkg/Library/UefiShellBcfgCommandLib/UefiShellBcfgCommandLib.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  PlatformInitLib|$(PLATFORM_PACKAGE)/Library/PlatformInitLib/PlatformInitLib.inf # AdvancedFeaturesContent
  FspPolicyInitLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/PeiFspPolicyInitLib/PeiFspPolicyInitLib.inf
  FspCommonLib|IntelFsp2Pkg/Library/BaseFspCommonLib/BaseFspCommonLib.inf
  FspWrapperApiLib|IntelFsp2WrapperPkg/Library/BaseFspWrapperApiLib/BaseFspWrapperApiLib.inf
  FspWrapperApiTestLib|IntelFsp2WrapperPkg/Library/PeiFspWrapperApiTestLib/PeiFspWrapperApiTestLib.inf
  FspWrapperPlatformLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/BaseFspWrapperPlatformLib/BaseFspWrapperPlatformLib.inf
  FspWrapperHobProcessLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/PeiFspWrapperHobProcessLib/PeiFspWrapperHobProcessLib.inf
  PlatformSecLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/SecFspWrapperPlatformSecLib/SecFspWrapperPlatformSecLib.inf
!endif

  DimmInfoLib|$(PLATFORM_PACKAGE)/Setup/DimmInfoLib.inf  # AdvancedFeaturesContent
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  ConfigBlockLib|ClientSiliconPkg/Library/BaseConfigBlockLib/BaseConfigBlockLib.inf
!else
  ConfigBlockLib|$(PLATFORM_SI_PACKAGE)/Library/BaseConfigBlockLib/BaseConfigBlockLib.inf
!endif

  RngLib|MdePkg/Library/BaseRngLib/BaseRngLib.inf

!if gPlatformModuleTokenSpaceGuid.PcdSmiVariableEnable == TRUE
  LegacyInterruptSupportLib|BpCommonPkg/Csm/Library/LegacyInterruptSupportLib/LegacyInterruptSupportLib.inf
!endif

#
# Silicon Init Package
#
!include $(PLATFORM_SI_PACKAGE)/SiPkgCommonLib.dsc

[LibraryClasses.IA32]
  #
  # PEI phase common
  #
!if gPlatformModuleTokenSpaceGuid.PcdOptimizationEnable == TRUE
  BaseMemoryLib|MdePkg/Library/BaseMemoryLibOptPei/BaseMemoryLibOptPei.inf
!endif
  S3BootScriptLib|MdePkg/Library/BaseS3BootScriptLibNull/BaseS3BootScriptLibNull.inf
  PcdLib|MdePkg/Library/PeiPcdLib/PeiPcdLib.inf
  HobLib|MdePkg/Library/PeiHobLib/PeiHobLib.inf
  MemoryAllocationLib|MdePkg/Library/PeiMemoryAllocationLib/PeiMemoryAllocationLib.inf
  ReportStatusCodeLib|MdeModulePkg/Library/PeiReportStatusCodeLib/PeiReportStatusCodeLib.inf
  ExtractGuidedSectionLib|MdePkg/Library/PeiExtractGuidedSectionLib/PeiExtractGuidedSectionLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BaseCryptLib|CryptoPkg/Library/BaseCryptLib/PeiCryptLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
  Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
  HashLib|SecurityPkg/Library/HashLibBaseCryptoRouter/HashLibBaseCryptoRouterPei.inf
!endif
#
# AdvancedFeaturesBegin
#
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibPei.inf
!else
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
!endif
  RamDebugLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseRamDebugLib/BaseRamDebugLib.inf
#
# AdvancedFeaturesEnd
#
  LockBoxLib|MdeModulePkg/Library/SmmLockBoxLib/SmmLockBoxPeiLib.inf
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  MultiPlatSupportLib|$(PLATFORM_PACKAGE)/Library/PeiMultiPlatSupportLib/PeiMultiPlatSupportLibOptSize.inf
!else
  MultiPlatSupportLib|$(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Library/PeiMultiPlatSupportLib/PeiMultiPlatSupportLibOptSize.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformanceLib|$(CLIENT_COMMON_PACKAGE)/Library/PeiFpdtPerformanceLib/PeiFpdtPerformanceLib.inf
!else
  PerformanceLib|MdeModulePkg/Library/PeiPerformanceLib/PeiPerformanceLib.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/BaseAcpiTimerLib.inf
!else
  TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/PeiTscTimerLib.inf
  PcdValueUpdateLib|$(PLATFORM_PACKAGE)/Library/PeiPcdValueUpdateLib/PeiPcdValueUpdateLib.inf
!endif

  PeiPolicyInitLib|$(PLATFORM_PACKAGE)/Library/PeiPolicyInitLib/PeiPolicyInitLib.inf
  PeiPolicyBoardConfigLib|$(PLATFORM_PACKAGE)/Library/PeiPolicyBoardConfigLib/PeiPolicyBoardConfigLib.inf # AdvancedFeaturesContent
  PeiPolicyUpdateLib|$(PLATFORM_PACKAGE)/Library/PeiPolicyUpdateLib/PeiPolicyUpdateLib.inf



  PeiPolicyDebugLib|$(PLATFORM_PACKAGE)/Library/PeiPolicyDebugLib/PeiPolicyDebugLib.inf    # AdvancedFeaturesContent
  PeiPlatformHookLib|$(PLATFORM_PACKAGE)/Library/PeiPlatformHookLib/PeiPlatformHooklib.inf
  PeiOverClockLib|$(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/PeiOverClockLib.inf # AdvancedFeaturesContent
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  PeiSwbpeLib|$(PLATFORM_PACKAGE)/Library/PeiSwbpeLib/PeiSwbpeLib.inf
  PeiPlatformRecoveryLib|$(PLATFORM_PACKAGE)/Library/PeiPlatformRecoveryLib/PeiPlatformRecoveryLib.inf
  SetupDataCacheLib|$(PLATFORM_PACKAGE)/Library/PeiSetupDataCacheLib/PeiSetupDataCacheLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdPeiWriteVariableEnable == TRUE
  PeiReadWriteVariableLib|$(PLATFORM_PACKAGE)/Library/PeiReadWriteVariableLib/PeiReadWriteVariableLib.inf
!else
  PeiReadWriteVariableLib|$(PLATFORM_PACKAGE)/Library/PeiReadWriteVariableLibNull/PeiReadWriteVariableLibNull.inf
!endif
  PeiWdtAppLib|$(PLATFORM_PACKAGE)/Library/PeiWdtAppLib/PeiWdtAppLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdTbtEnable == TRUE
  PeiTbtInitLib|$(PLATFORM_PACKAGE)/Library/PeiTbtInitLib/PeiTbtInitLib.inf
!else
  PeiTbtInitLib|$(PLATFORM_PACKAGE)/Library/PeiTbtInitLibNull/PeiTbtInitLibNull.inf
!endif
  BiosIdLib|BpCommonPkg/Library/BiosIdLib/PeiBiosIdLib.inf
!endif #PcdMinTreeEnable
  BoardConfigLib|$(PLATFORM_PACKAGE)/Board/Library/PeiBoardConfigLib/PeiBoardConfigLib.inf

#
# AdvancedFeaturesBegin
#
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibSvenTx/BaseTraceHubDebugLibSvenTx.inf
!else
  TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibSvenTx/PeiTraceHubDebugLibSvenTx.inf
!endif
!else
  TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibNull/TraceHubDebugLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  FspWrapperPlatformResetLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/PeiFspWrapperPlatformResetLib/PeiFspWrapperPlatformResetLib.inf
!endif
#
# Silicon Init Package
#
!include $(PLATFORM_SI_PACKAGE)/SiPkgPeiLib.dsc

[LibraryClasses.IA32.SEC]
  DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf # AdvancedFeaturesContent
  ReportStatusCodeLib|MdePkg/Library/BaseReportStatusCodeLibNull/BaseReportStatusCodeLibNull.inf
  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/SecPeiCpuExceptionHandlerLib.inf

[LibraryClasses.IA32.PEI_CORE]
#
# AdvancedFeaturesBegin
#
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibPei.inf
!else
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#
  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/SecPeiCpuExceptionHandlerLib.inf

[LibraryClasses.IA32.PEIM]
!if $(TARGET) == DEBUG
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  SerialPortLib|MdeModulePkg/Library/BaseSerialPortLib16550/BaseSerialPortLib16550.inf
!else
  SerialPortLib|$(PLATFORM_PACKAGE)/Library/BaseSerialPortLib/BaseSerialPortLib$(TRACEHUB).inf
!endif
  DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!else
#
# This is for reducing NATIVE DEBUG binary size, replacing some library routines with PPI.
#
  DebugLib|$(CLIENT_COMMON_PACKAGE)/Library/PeiDebugLibDebugService/PeiDebugLibDebugService.inf
!endif
!endif
  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/SecPeiCpuExceptionHandlerLib.inf
!if $(TARGET) == RELEASE
!if (gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable == TRUE) AND (gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE)
  DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
!else
  DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
!endif
!endif
[LibraryClasses.X64]
  #
  # DXE phase common
  #
!if gPlatformModuleTokenSpaceGuid.PcdOptimizationEnable == TRUE
  BaseMemoryLib|MdePkg/Library/BaseMemoryLibOptDxe/BaseMemoryLibOptDxe.inf
!endif
  HobLib|MdePkg/Library/DxeHobLib/DxeHobLib.inf
  PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  MemoryAllocationLib|MdePkg/Library/UefiMemoryAllocationLib/UefiMemoryAllocationLib.inf
  ReportStatusCodeLib|MdeModulePkg/Library/DxeReportStatusCodeLib/DxeReportStatusCodeLib.inf
  ExtractGuidedSectionLib|MdePkg/Library/DxeExtractGuidedSectionLib/DxeExtractGuidedSectionLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformanceLib|MdeModulePkg/Library/DxePerformanceLib/DxePerformanceLib.inf
  TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
!endif
  DxePolicyBoardConfigLib|$(PLATFORM_PACKAGE)/Library/DxePolicyBoardConfigLib/DxePolicyBoardConfigLib.inf # AdvancedFeaturesContent
  DxePolicyUpdateLib|$(PLATFORM_PACKAGE)/Library/DxePolicyUpdateLib/DxePolicyUpdateLib.inf # AdvancedFeaturesContent


!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibTcg2/Tpm2DeviceLibTcg2.inf
  HashLib|SecurityPkg/Library/HashLibBaseCryptoRouter/HashLibBaseCryptoRouterDxe.inf
  Tcg2PhysicalPresenceLib|SecurityPkg/Library/DxeTcg2PhysicalPresenceLib/DxeTcg2PhysicalPresenceLib.inf
  Tcg2PpVendorLib|SecurityPkg/Library/Tcg2PpVendorLibNull/Tcg2PpVendorLibNull.inf
  TpmMeasurementLib|SecurityPkg/Library/DxeTpmMeasurementLib/DxeTpmMeasurementLib.inf
  TcgPhysicalPresenceLib|SecurityPkg/Library/DxeTcgPhysicalPresenceLib/DxeTcgPhysicalPresenceLib.inf
  TcgPpVendorLib|SecurityPkg/Library/TcgPpVendorLibNull/TcgPpVendorLibNull.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BaseCryptLib|CryptoPkg/Library/BaseCryptLib/BaseCryptLib.inf
!endif
#
# AdvancedFeaturesBegin
#
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibDxe.inf
!else
  Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibNull.inf
!endif
  RamDebugLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseRamDebugLib/BaseRamDebugLib.inf
#
# AdvancedFeaturesEnd
#
  LockBoxLib|MdeModulePkg/Library/SmmLockBoxLib/SmmLockBoxDxeLib.inf
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  SpiFlashLib|$(PLATFORM_PACKAGE)/Flash/Library/DxeSpiFlashCommonLib/DxeSpiFlashLib.inf
  SpiFlashCommonLib|$(PLATFORM_PACKAGE)/Flash/Library/DxeSpiFlashCommonLib/DxeSpiFlashCommonLib.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  DebugAgentLib|SourceLevelDebugPkg/Library/DebugAgent/DxeDebugAgentLib.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  LegacyBiosPlatformLib|$(PLATFORM_PACKAGE)/Override/ClientCommonPkg/Library/BaseLegacyBiosPlatformLib/BaseLegacyBiosPlatformLib.inf  # RPPO-KBL-0080
!endif
  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/DxeCpuExceptionHandlerLib.inf

#
# AdvancedFeaturesBegin
#
  DxeOverClockLib|$(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/DxeOverClockLib.inf
  BiosIdLib|BpCommonPkg/Library/BiosIdLib/DxeBiosIdLib.inf
  BaseFlashDeviceLib|$(PLATFORM_PACKAGE)/Library/BaseFlashDeviceLib/BaseFlashDeviceLib.inf
  DxeOpromPatchLib|$(PLATFORM_PACKAGE)/Library/DxeOpromPatchLib/DxeOpromPatchLib.inf
  DxeSmmInternalGraphicDeviceLib|$(PLATFORM_PACKAGE)/Library/DxeSmmInternalGraphicDeviceLib/DxeSmmInternalGraphicDeviceLib.inf
  KeyboardLedsLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeKeyboardLedsLib/DxeKeyboardLedsLib.inf
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibSvenTx/DxeTraceHubDebugLibSvenTx.inf
!else
  TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibNull/TraceHubDebugLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  FspWrapperPlatformResetLib|$(PLATFORM_PACKAGE)/FspWrapper/Library/DxeFspWrapperPlatformResetLib/DxeFspWrapperPlatformResetLib.inf
!endif

#
# Silicon Init Package
#
!include $(PLATFORM_SI_PACKAGE)/SiPkgDxeLib.dsc



#
# AdvancedFeaturesBegin
#
  DxeDumpMemMapLib|$(PLATFORM_PACKAGE)/Library/DxeDumpMemMapLib/DxeDumpMemMapLib.inf
!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  DxeSmbiosProcessorLib|$(PLATFORM_PACKAGE)/Override/ClientCommonPkg/Library/DxeSmbiosProcessorLib/DxeSmbiosProcessorLib.inf
!else
  DxeSmbiosProcessorLib|$(CLIENT_COMMON_PACKAGE)/Library/DxeSmbiosProcessorLibNull/DxeSmbiosProcessorLibNull.inf
!endif
#
# AdvancedFeaturesEnd
#

[LibraryClasses.IA32.PEIM]
  Tcg2PhysicalPresenceLib|SecurityPkg/Library/PeiTcg2PhysicalPresenceLib/PeiTcg2PhysicalPresenceLib.inf

[LibraryClasses.X64.PEIM]
  DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
  PlatformHookLib|MdeModulePkg/Library/BasePlatformHookLibNull/BasePlatformHookLibNull.inf
  PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  PerformanceLib|MdePkg/Library/BasePerformanceLibNull/BasePerformanceLibNull.inf
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  DebugAgentLib|SourceLevelDebugPkg/Library/DebugAgent/SecPeiDebugAgentLib.inf
  HobLib|MdePkg/Library/PeiHobLib/PeiHobLib.inf
  MemoryAllocationLib|MdePkg/Library/PeiMemoryAllocationLib/PeiMemoryAllocationLib.inf
!endif
  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/SecPeiCpuExceptionHandlerLib.inf
!if $(TARGET) == DEBUG
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  SerialPortLib|MdeModulePkg/Library/BaseSerialPortLib16550/BaseSerialPortLib16550.inf
!else
  SerialPortLib|$(PLATFORM_PACKAGE)/Library/BaseSerialPortLib/BaseSerialPortLib$(TRACEHUB).inf
!endif
!else
  SerialPortLib|MdePkg/Library/BaseSerialPortLibNull/BaseSerialPortLibNull.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/BaseAcpiTimerLib.inf
!else
  TimerLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseAcpiTimerLib/BaseAcpiTimerLib.inf
!endif

[LibraryClasses.X64.DXE_CORE]
  HobLib|MdePkg/Library/DxeCoreHobLib/DxeCoreHobLib.inf
  MemoryAllocationLib|MdeModulePkg/Library/DxeCoreMemoryAllocationLib/DxeCoreMemoryAllocationLib.inf
  PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf

!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformanceLib|$(PLATFORM_PACKAGE)/Override/ClientCommonPkg/Library/DxeCoreFpdtPerformanceLib/DxeCoreFpdtPerformanceLib.inf  # RPPO-KBL-0045
!else
  PerformanceLib|MdeModulePkg/Library/DxeCorePerformanceLib/DxeCorePerformanceLib.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/DxeAcpiTimerLib.inf
!else
  TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
!endif

[LibraryClasses.X64.DXE_SMM_DRIVER]
  SmmServicesTableLib|MdePkg/Library/SmmServicesTableLib/SmmServicesTableLib.inf
  ReportStatusCodeLib|MdeModulePkg/Library/SmmReportStatusCodeLib/SmmReportStatusCodeLib.inf
  MemoryAllocationLib|MdePkg/Library/SmmMemoryAllocationLib/SmmMemoryAllocationLib.inf
  LockBoxLib|MdeModulePkg/Library/SmmLockBoxLib/SmmLockBoxSmmLib.inf
  SmmConfidentialMemLib|$(PLATFORM_PACKAGE)/Library/SmmConfidentialMemLib/SmmConfidentialMemLib.inf  # AdvancedFeaturesContent
    SmmMemLib|$(PLATFORM_PACKAGE)/Override/MdePkg/Library/SmmMemLib/SmmMemLib.inf  # RPPO-KBL-0090: RoyalParkOverrideContent
  DxeSmmScriptLib|$(PLATFORM_PACKAGE)/Library/DxeSmmScriptLib/DxeSmmScriptLib.inf # AdvancedFeaturesContent
!if gSiPkgTokenSpaceGuid.PcdBiosGuardEnable == TRUE
  SpiFlashCommonLib|$(PLATFORM_PACKAGE)/Flash/Library/SmmSpiFlashCommonLib/SmmSpiFlashCommonLibBiosGuard.inf
!else
  SpiFlashCommonLib|$(PLATFORM_PACKAGE)/Flash/Library/SmmSpiFlashCommonLib/SmmSpiFlashCommonLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformanceLib|MdeModulePkg/Library/SmmPerformanceLib/SmmPerformanceLib.inf
  TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
!else
  PerformanceLib|MdePkg/Library/BasePerformanceLibNull/BasePerformanceLibNull.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BaseCryptLib|CryptoPkg/Library/BaseCryptLib/SmmCryptLib.inf
!endif

  SmmCpuPlatformHookLib|UefiCpuPkg/Library/SmmCpuPlatformHookLibNull/SmmCpuPlatformHookLibNull.inf
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  DebugAgentLib|SourceLevelDebugPkg/Library/DebugAgent/SmmDebugAgentLib.inf
!endif

#
# AdvancedFeaturesBegin
#
  SmmStmConfTableLib|$(CLIENT_COMMON_PACKAGE)/Library/SmmStmConfTableLibNull/SmmStmConfTableLibNull.inf
DxeSmmAcpiCustomLib|$(PLATFORM_PACKAGE)/Library/DxeSmmAcpiCustomLib/DxeSmmAcpiCustomLib.inf
#
# AdvancedFeaturesEnd
#

  CpuExceptionHandlerLib|UefiCpuPkg/Library/CpuExceptionHandlerLib/SmmCpuExceptionHandlerLib.inf
  Tcg2PhysicalPresenceLib|SecurityPkg/Library/SmmTcg2PhysicalPresenceLib/SmmTcg2PhysicalPresenceLib.inf

[LibraryClasses.X64.SMM_CORE]
  HobLib|MdePkg/Library/DxeHobLib/DxeHobLib.inf
  MemoryAllocationLib|MdeModulePkg/Library/PiSmmCoreMemoryAllocationLib/PiSmmCoreMemoryAllocationLib.inf
  SmmServicesTableLib|MdeModulePkg/Library/PiSmmCoreSmmServicesTableLib/PiSmmCoreSmmServicesTableLib.inf
  ReportStatusCodeLib|MdeModulePkg/Library/SmmReportStatusCodeLib/SmmReportStatusCodeLib.inf
    SmmMemLib|$(PLATFORM_PACKAGE)/Override/MdePkg/Library/SmmMemLib/SmmMemLib.inf  # RPPO-KBL-0090: RoyalParkOverrideContent
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformanceLib|$(CLIENT_COMMON_PACKAGE)/Library/SmmCoreFpdtPerformanceLib/SmmCoreFpdtPerformanceLib.inf
  TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
!else
  PerformanceLib|MdePkg/Library/BasePerformanceLibNull/BasePerformanceLibNull.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BaseCryptLib|CryptoPkg/Library/BaseCryptLib/SmmCryptLib.inf
!endif

[LibraryClasses.X64.DXE_RUNTIME_DRIVER]
  ReportStatusCodeLib|MdeModulePkg/Library/RuntimeDxeReportStatusCodeLib/RuntimeDxeReportStatusCodeLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BaseCryptLib|CryptoPkg/Library/BaseCryptLib/RuntimeCryptLib.inf
!endif
  ResetSystemLib|$(PLATFORM_SI_PACKAGE)/Pch/Library/DxeRuntimeResetSystemLib/DxeRuntimeResetSystemLib.inf


[LibraryClasses.X64.UEFI_DRIVER]
  PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf

[LibraryClasses.X64.UEFI_APPLICATION]
  PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  ShellLib|ShellPkg/Library/UefiShellLib/UefiShellLib.inf
  FileHandleLib|MdePkg/Library/UefiFileHandleLib/UefiFileHandleLib.inf
  SortLib|MdeModulePkg/Library/UefiSortLib/UefiSortLib.inf

################################################################################
#
# Pcd Section - list of all EDK II PCD Entries defined by this Platform
#
################################################################################
[PcdsFeatureFlag.common]

gPlatformModuleTokenSpaceGuid.PcdEnableSecureErase|TRUE
gPlatformModuleTokenSpaceGuid.PcdBdsDispatchAdditionalOprom|TRUE
gPlatformModuleTokenSpaceGuid.PcdUseHeciInCapsuleUpdate|TRUE
gEfiMdeModulePkgTokenSpaceGuid.PcdBrowserGrayOutTextStatement|TRUE


!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  gPlatformModuleTokenSpaceGuid.PcdAmtEnable|TRUE
!else
  gPlatformModuleTokenSpaceGuid.PcdAmtEnable|FALSE
!endif
!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdSupportUpdateCapsuleReset|TRUE
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdSupportUpdateCapsuleReset|FALSE
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdFrameworkCompatibilitySupport|TRUE
  gUefiCpuPkgTokenSpaceGuid.PcdCpuSmmEnableBspElection|FALSE
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreImageLoaderSearchTeSectionFirst|FALSE
!if $(TARGET) == RELEASE
  gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseSerial|FALSE
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseSerial|FALSE
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdStatusCodeUseMemory|FALSE
#
# AdvancedFeaturesBegin
#
!if (gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE) AND ($(TARGET) == DEBUG)
  gEfiUsb3DebugPortTokenSpaceGuid.PcdStatusCodeUseUsb3Serial|TRUE
!else
  gEfiUsb3DebugPortTokenSpaceGuid.PcdStatusCodeUseUsb3Serial|FALSE
!endif


!if gPlatformModuleTokenSpaceGuid.PcdMpTableEnable == TRUE
  gClientCommonModuleTokenSpaceGuid.PcdMpTableSupport|TRUE
!else
  gClientCommonModuleTokenSpaceGuid.PcdMpTableSupport|FALSE
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdVariableInfoEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdVariableCollectStatistics|TRUE
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdVariableCollectStatistics|FALSE
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSmmProfileEnable == TRUE
  gUefiCpuPkgTokenSpaceGuid.PcdCpuSmmProfileEnable|TRUE
!else
  gUefiCpuPkgTokenSpaceGuid.PcdCpuSmmProfileEnable|FALSE
!endif


!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdInstallAcpiSdtProtocol|TRUE
!endif

[PcdsFeatureFlag.X64]
# Optimze Driver init time in FastBoot Mode
# If set PcdPs2KbdExtendedVerification to False, we can save 380 ms for Ps2KeyboardDxe driver initialize time
  gClientCommonModuleTokenSpaceGuid.PcdPs2KbdExtendedVerification|FALSE # AdvancedFeaturesContent

!if gPlatformModuleTokenSpaceGuid.PcdDataHubEnable == TRUE
  gEfiIntelFrameworkModulePkgTokenSpaceGuid.PcdStatusCodeUseDataHub|TRUE
!else
  gEfiIntelFrameworkModulePkgTokenSpaceGuid.PcdStatusCodeUseDataHub|FALSE   # AdvancedFeaturesContent
!endif

[PcdsFixedAtBuild.common]
  gEfiMdePkgTokenSpaceGuid.PcdPciExpressBaseAddress|0xE0000000
  gSiPkgTokenSpaceGuid.PcdPciExpressRegionLength|0x10000000
  gSiPkgTokenSpaceGuid.PcdTemporaryRamBase|0xFEF80000
  gSiPkgTokenSpaceGuid.PcdTemporaryRamSize|0x00040000
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  gIntelFsp2PkgTokenSpaceGuid.PcdTemporaryRamBase|0xFEF00000
  gIntelFsp2PkgTokenSpaceGuid.PcdTemporaryRamSize|0x00040000
!if gSiPkgTokenSpaceGuid.PcdSsaFlagEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdEvLoaderEnable == TRUE
  gIntelFsp2PkgTokenSpaceGuid.PcdFspTemporaryRamSize        | 0x00030000
!else
  gIntelFsp2PkgTokenSpaceGuid.PcdFspTemporaryRamSize        | 0x00026000
!endif
!else
  gIntelFsp2PkgTokenSpaceGuid.PcdFspTemporaryRamSize        | 0x00026000
!endif
!endif
  gSiPkgTokenSpaceGuid.PcdPeiTemporaryRamStackSize|0x20000
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdMaxVariableSize|0x10000
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdMaxVariableSize|0x5000
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdHwErrStorageSize|0x00000800
  gEfiMdeModulePkgTokenSpaceGuid.PcdMaxHardwareErrorVariableSize|0x400
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreMaxFvSupported|9
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreMaxFvSupported|11
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreMaxPeimPerFv|64
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreMaxPeimPerFv|60
!endif


  gEfiMdeModulePkgTokenSpaceGuid.PcdSrIovSupport|FALSE
  gEfiMdeModulePkgTokenSpaceGuid.PcdAriSupport|FALSE
  gEfiMdeModulePkgTokenSpaceGuid.PcdPeiCoreMaxPpiSupported|128
  gUefiCpuPkgTokenSpaceGuid.PcdCpuSmmApSyncTimeout|10000
!if $(TARGET) == RELEASE
!if (gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable == TRUE) AND (gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE)
  gEfiMdePkgTokenSpaceGuid.PcdDebugPropertyMask|0x27
  gEfiMdePkgTokenSpaceGuid.PcdReportStatusCodePropertyMask|0x07
!else
  gEfiMdePkgTokenSpaceGuid.PcdDebugPropertyMask|0x0
  gEfiMdePkgTokenSpaceGuid.PcdReportStatusCodePropertyMask|0x3
!endif
!else
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  gEfiMdePkgTokenSpaceGuid.PcdDebugPropertyMask|0x1F
  gEfiMdeModulePkgTokenSpaceGuid.PcdSerialUseHardwareFlowControl|TRUE
!else
  gEfiMdePkgTokenSpaceGuid.PcdDebugPropertyMask|0x2F
  gEfiMdeModulePkgTokenSpaceGuid.PcdSerialUseHardwareFlowControl|FALSE
!endif
  gEfiMdePkgTokenSpaceGuid.PcdReportStatusCodePropertyMask|0x07
!endif
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  gEfiMdePkgTokenSpaceGuid.PcdPerformanceLibraryPropertyMask|0x1
  gEfiMdeModulePkgTokenSpaceGuid.PcdMaxPeiPerformanceLogEntries|140
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdLoadModuleAtFixAddressEnable|$(TOP_MEMORY_ADDRESS)
  gEfiMdeModulePkgTokenSpaceGuid.PcdBrowserSubtitleTextColor|0x0
  gEfiMdeModulePkgTokenSpaceGuid.PcdBrowserFieldTextColor|0x01
  gUefiCpuPkgTokenSpaceGuid.PcdCpuSmmStackSize|0x20000
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  ## Pcd for OptionRom.
  #  Image verification policy settings:
  #  ALWAYS_EXECUTE                         0x00000000
  #  NEVER_EXECUTE                          0x00000001
  #  ALLOW_EXECUTE_ON_SECURITY_VIOLATION    0x00000002
  #  DEFER_EXECUTE_ON_SECURITY_VIOLATION    0x00000003
  #  DENY_EXECUTE_ON_SECURITY_VIOLATION     0x00000004
  #  QUERY_USER_ON_SECURITY_VIOLATION       0x00000005
  gEfiSecurityPkgTokenSpaceGuid.PcdOptionRomImageVerificationPolicy | 0x00000004
!endif

!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdSourceDebugUseUsb == TRUE
  gEfiSourceLevelDebugPkgTokenSpaceGuid.PcdDebugLoadImageMethod|2
!endif
!endif


## The PCD is used to specify if TrEEPlatform module support TXT provision. # AdvancedFeaturesContent
  gClientCommonModuleTokenSpaceGuid.PcdTpm2TxtProvisionSupport|TRUE # AdvancedFeaturesContent

gEfiMdeModulePkgTokenSpaceGuid.PcdReclaimVariableSpaceAtEndOfDxe|TRUE

#
# 8MB Default
#
gSiPkgTokenSpaceGuid.PcdTsegSize|0x800000

#
# 16MB TSEG in Debug build only.
#
!if $(TARGET) == DEBUG
  gSiPkgTokenSpaceGuid.PcdTsegSize|0x1000000
!endif



!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPciBusNumber|0x0
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPciDeviceNumber|0x1F
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPciFunctionNumber|0x2
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPciEnableRegisterOffset|0x44
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoBarEnableMask|0x80
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPciBarRegisterOffset|0x40
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPortBaseAddress|0x1800
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiPm1TmrOffset|0x08
gPcAtChipsetPkgTokenSpaceGuid.PcdAcpiIoPortBaseAddressMask|0xFFFC
!endif

gPlatformModuleTokenSpaceGuid.PcdPlatformEfiAcpiReclaimMemorySize|0x65
gPlatformModuleTokenSpaceGuid.PcdPlatformEfiAcpiNvsMemorySize|0x30


!if $(TARGET) == RELEASE
gPlatformModuleTokenSpaceGuid.PcdPlatformEfiReservedMemorySize|0x402
!else
gPlatformModuleTokenSpaceGuid.PcdPlatformEfiReservedMemorySize|0x188B
!endif


gPlatformModuleTokenSpaceGuid.PcdPlatformEfiRtDataMemorySize|0x4b
!if $(TARGET) == RELEASE
gPlatformModuleTokenSpaceGuid.PcdPlatformEfiRtCodeMemorySize|0x25
!else
gPlatformModuleTokenSpaceGuid.PcdPlatformEfiRtCodeMemorySize|0x80
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
gIntelFsp2WrapperTokenSpaceGuid.PcdFsptBaseAddress|0xFFFCD000
gIntelFsp2WrapperTokenSpaceGuid.PcdFspmBaseAddress|0xFFF20000
!endif

## Specifies max supported number of Logical Processors.
# @Prompt Configure max supported number of Logical Processorss
gUefiCpuPkgTokenSpaceGuid.PcdCpuMaxLogicalProcessorNumber|16

## Specifies the size of the microcode Region.
# @Prompt Microcode Region size.
gUefiCpuPkgTokenSpaceGuid.PcdCpuMicrocodePatchRegionSize|0

## Specifies timeout value in microseconds for the BSP to detect all APs for the first time.
# @Prompt Timeout for the BSP to detect all APs for the first time.
gUefiCpuPkgTokenSpaceGuid.PcdCpuApInitTimeOutInMicroSeconds|1000

#
# AdvancedFeaturesBegin
#
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  gEfiBpCommonPkgTokenSpaceGuid.PcdTraceHubDebugLibMaster|0x20
  gEfiBpCommonPkgTokenSpaceGuid.PcdTraceHubDebugLibChannel|0xE
!endif # gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
!if $(TARGET) != RELEASE
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUseSerialPortPlatform|TRUE
!else
!if (gClientCommonModuleTokenSpaceGuid.PcdCatalogDebugEnable == TRUE) AND (gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE)
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUseTraceHub|TRUE
!endif
!endif # $(TARGET) != RELEASE
!if gPlatformModuleTokenSpaceGuid.PcdPostCodeStatusCodeEnable == TRUE
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUsePostCode|TRUE
!else
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUsePostCode|FALSE
!endif # gPlatformModuleTokenSpaceGuid.PcdPostCodeStatusCodeEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdBeepStatusCodeEnable == TRUE
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUseBeep|TRUE
!else
  gEfiBpCommonPkgTokenSpaceGuid.PcdStatusCodeUseBeep|FALSE
!endif # gPlatformModuleTokenSpaceGuid.PcdBeepStatusCodeEnable == TRUE

gClientCommonModuleTokenSpaceGuid.PcdSmbiosDefaultMaxSpeed|8300
#
# AdvancedFeaturesEnd
#

#
# The PCDs are used to control the Windows SMM Security Mitigations Table - Protection Flags
#
# BIT0: If set, expresses that for all synchronous SMM entries,SMM will validate that input and output buffers lie entirely within the expected fixed memory regions.
# BIT1: If set, expresses that for all synchronous SMM entries, SMM will validate that input and output pointers embedded within the fixed communication buffer only refer to address ranges \
#       that lie entirely within the expected fixed memory regions.
# BIT2: Firmware setting this bit is an indication that it will not allow reconfiguration of system resources via non-architectural mechanisms.
# BIT3-31: Reserved
#
gPlatformModuleTokenSpaceGuid.PcdWsmtProtectionFlags|0x07

## This PCD defines initial setting of TCG2 Persistent Firmware Management Flags
# PCD can be configured for different settings in different scenarios
# Default setting is TCG2_BIOS_TPM_MANAGEMENT_FLAG_DEFAULT | TCG2_BIOS_STORAGE_MANAGEMENT_FLAG_DEFAULT
# @Prompt Initial setting of TCG2 Persistent Firmware Management Flags
# Enabled PPI for PPRequiredForTurnOff, PPRequiredForChangeEPS, PPRequiredForChangePCRs, PPRequiredForEnable_BlockSIDFunc, PPRequiredForDisable_BlockSIDFunc
  gEfiSecurityPkgTokenSpaceGuid.PcdTcg2PhysicalPresenceFlags|0x300E0

# Disabling 64 bit Smbios Entrypoint Structure and populated tables
# Bit0 is to enable 32 bit and Bit1 is to enable 64 bit Smbios tables
!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdSmbiosEntryPointProvideMethod|0x01
!endif

[PcdsFixedAtBuild.IA32]
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdVpdBaseAddress|0x0
  gIntelFsp2PkgTokenSpaceGuid.PcdGlobalDataPointerAddress|0xFED00148
  gPlatformModuleTokenSpaceGuid.PcdPeiPhaseStackTop|0xA0000
  gIntelFsp2WrapperTokenSpaceGuid.PcdPeiMinMemSize|0x3800000
!endif # gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE

[PcdsFixedAtBuild.X64]
  # Change PcdBootManagerMenuFile to point to UiApp                                                                                                        # AdvancedFeaturesContent
  gEfiMdeModulePkgTokenSpaceGuid.PcdBootManagerMenuFile|{ 0x21, 0xaa, 0x2c, 0x46, 0x14, 0x76, 0x03, 0x45, 0x83, 0x6e, 0x8a, 0xb6, 0xf4, 0x66, 0x23, 0x31 } # AdvancedFeaturesContent
  gPcAtChipsetPkgTokenSpaceGuid.Pcd8259LegacyModeMask|0x0eB8

!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdExtFpdtBootRecordPadSize|0x1000
!endif

  # Default platform supported RFC 4646 languages: (American) English
  gEfiMdePkgTokenSpaceGuid.PcdUefiVariableDefaultPlatformLangCodes|"en-US"

  gPlatformModuleTokenSpaceGuid.PcdCpuSmmProcTraceEnable|FALSE

#
# AdvancedFeaturesBegin
#
!if $(TARGET) == DEBUG
  gClientCommonModuleTokenSpaceGuid.PcdS3AcpiReservedMemorySize|0x300000
!else
  gClientCommonModuleTokenSpaceGuid.PcdS3AcpiReservedMemorySize|0x200000
!endif
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  gClientCommonModuleTokenSpaceGuid.PcdHighPmmMemorySize|0x9600000
  gClientCommonModuleTokenSpaceGuid.PcdEndOpromShadowAddress|0xE7FFF
  gClientCommonModuleTokenSpaceGuid.PcdLegacyBiosCacheLegacyRegion|FALSE
  gClientCommonModuleTokenSpaceGuid.PcdEbdaReservedMemorySize|0x17000
!endif

#
# AdvancedFeaturesEnd
#

[PcdsPatchableInModule.common]
  gEfiMdeModulePkgTokenSpaceGuid.PcdSmbiosVersion|0x0300

  gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046

!if $(TARGET) == DEBUG
  gSiPkgTokenSpaceGuid.PcdSerialIoUartDebugEnable|1
!endif



[PcdsDynamicHii.common.DEFAULT]
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1Implemented|L"PNP0501_0_VV"|gEfiSioVariableGuid|0x0|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2Implemented|L"PNP0510_1_VV"|gEfiSioVariableGuid|0x0|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1ComBase1|L"PNP0501_0_VV"|gEfiSioVariableGuid|0x1|0x3F8
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComBase1|L"PNP0510_1_VV"|gEfiSioVariableGuid|0x1|0x2F8
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComBase2|L"PNP0510_1_VV"|gEfiSioVariableGuid|0x3|0x7E8
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1ComIrq1|L"PNP0501_0_VV"|gEfiSioVariableGuid|0x5|0x4
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComIrq1|L"PNP0510_1_VV"|gEfiSioVariableGuid|0x5|0x3
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComDma1|L"PNP0510_1_VV"|gEfiSioVariableGuid|0x7|0x3
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1Enable|L"PNP0501_0_NV"|gEfiSioVariableGuid|0x0|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2Enable|L"PNP0510_1_NV"|gEfiSioVariableGuid|0x0|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1ComPrsId|L"PNP0501_0_NV"|gEfiSioVariableGuid|0x1|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComPrsId|L"PNP0510_1_NV"|gEfiSioVariableGuid|0x1|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom1ComMode|L"PNP0501_0_NV"|gEfiSioVariableGuid|0x2|0
  gClientCommonModuleTokenSpaceGuid.PcdSmscLpc100xCom2ComMode|L"PNP0510_1_NV"|gEfiSioVariableGuid|0x2|0
  gClientCommonModuleTokenSpaceGuid.PcdPlatformMemoryCheck|L"MemoryCheck"|gClientCommonModuleTokenSpaceGuid|0x0|0
  gClientCommonModuleTokenSpaceGuid.PcdFastBootEnable|L"Setup"|gSetupVariableGuid|0x1|0
  gClientCommonModuleTokenSpaceGuid.PcdComPortAttributes0IsEnabled|L"ComAttributes"|gSetupVariableGuid|0x16|0
!endif
  gEfiMdePkgTokenSpaceGuid.PcdDefaultTerminalType|L"ComAttributes"|gSetupVariableGuid|0x13|0
  gPlatformModuleTokenSpaceGuid.PcdBdsDispatchExternalOprom|L"PciBusSetup"|gSetupVariableGuid|0x0|0

[PcdsDynamicHii.X64.DEFAULT]
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  gEfiMdePkgTokenSpaceGuid.PcdPlatformBootTimeOut|L"Timeout"|gEfiGlobalVariableGuid|0x0|1 # Variable: L"Timeout"
!else
  gEfiMdePkgTokenSpaceGuid.PcdPlatformBootTimeOut|L"Timeout"|gEfiGlobalVariableGuid|0x0|5 # Variable: L"Timeout"
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdSetupConOutColumn|L"ConOutConfigColumn"|gClientCommonModuleTokenSpaceGuid|0x0|100 # AdvancedFeaturesContent
  gEfiMdeModulePkgTokenSpaceGuid.PcdSetupConOutRow|L"ConOutConfigRow"|gClientCommonModuleTokenSpaceGuid|0x0|31        # AdvancedFeaturesContent
  gPlatformModuleTokenSpaceGuid.PcdBootState|L"BootState"|gBootStateGuid|0x0|TRUE                                     # AdvancedFeaturesContent
  gEfiMdePkgTokenSpaceGuid.PcdHardwareErrorRecordLevel|L"HwErrRecSupport"|gEfiGlobalVariableGuid|0x0|1 # Variable: L"HwErrRecSupport"

  gPlatformModuleTokenSpaceGuid.PcdCpuSmmMsrSaveStateEnable|L"CpuSmm"|gCpuSmmGuid|0x0|0
  gPlatformModuleTokenSpaceGuid.PcdCpuSmmCodeAccessCheckEnable|L"CpuSmm"|gCpuSmmGuid|0x1|1
  gPlatformModuleTokenSpaceGuid.PcdCpuSmmUseDelayIndication|L"CpuSmm"|gCpuSmmGuid|0x2|1
  gPlatformModuleTokenSpaceGuid.PcdCpuSmmUseBlockIndication|L"CpuSmm"|gCpuSmmGuid|0x3|1
  gPlatformModuleTokenSpaceGuid.PcdCpuSmmUseSmmEnableIndication|L"CpuSmm"|gCpuSmmGuid|0x4|1

[PcdsDynamicDefault]
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  gIntelFsp2WrapperTokenSpaceGuid.PcdFspsBaseAddress|0xFFCF02B0
!endif

[PcdsDynamicDefault.common.DEFAULT]
!if gPlatformModuleTokenSpaceGuid.PcdS4Enable == FALSE
  gEfiMdeModulePkgTokenSpaceGuid.PcdResetOnMemoryTypeInformationChange|FALSE
!else
  gEfiMdeModulePkgTokenSpaceGuid.PcdResetOnMemoryTypeInformationChange|TRUE
!endif
  gEfiMdeModulePkgTokenSpaceGuid.PcdConOutColumn|0x0
  gEfiMdeModulePkgTokenSpaceGuid.PcdConOutRow|0x0
  gEfiMdeModulePkgTokenSpaceGuid.PcdAtaSmartEnable|TRUE
  gEfiMdeModulePkgTokenSpaceGuid.PcdConInConnectOnDemand|FALSE
  #
  #  Set video to native resolution as Windows 8 WHCK requirement.
  #
  gEfiMdeModulePkgTokenSpaceGuid.PcdVideoHorizontalResolution|0x0
  gEfiMdeModulePkgTokenSpaceGuid.PcdVideoVerticalResolution|0x0

  ## Specifies the AP wait loop state during POST phase.
  #  The value is defined as below.
  #  1: Place AP in the Hlt-Loop state.
  #  2: Place AP in the Mwait-Loop state.
  #  3: Place AP in the Run-Loop state.
  # @Prompt The AP wait loop state.
  gUefiCpuPkgTokenSpaceGuid.PcdCpuApLoopMode|2


#
# AdvancedFeaturesBegin
#
!if $(TARGET) == DEBUG
  gClientCommonModuleTokenSpaceGuid.PcdWdtTimeoutBetweenPeiDxe|120
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable
  ## Put Ptt guid here: e.g. { 0xf9c6a62f, 0xc60f, 0x4b44, { 0xa6, 0x29, 0xed, 0x3d, 0x40, 0xae, 0xfa, 0x5f } }
  ## TPM1.2 { 0x8b01e5b6, 0x4f19, 0x46e8, { 0xab, 0x93, 0x1c, 0x53, 0x67, 0x1b, 0x90, 0xcc } }
  ## TPM2.0Dtpm { 0x286bf25a, 0xc2c3, 0x408c, { 0xb3, 0xb4, 0x25, 0xe6, 0x75, 0x8b, 0x73, 0x17 } }
  ## TPM2.0Ptt { 0x72cd3a7b, 0xfea5, 0x4f5e, { 0x91, 0x65, 0x4d, 0xd1, 0x21, 0x87, 0xbb, 0x13 } }
  ## TPM2.0PttPTP { 0x93d66f66, 0x55da, 0x4f03, { 0x9b, 0x5f, 0x32, 0xcf, 0x9e, 0x54, 0x3b, 0x3a } }

  #gEfiSecurityPkgTokenSpaceGuid.PcdTpmInstanceGuid|{0xb6, 0xe5, 0x01, 0x8b, 0x19, 0x4f, 0xe8, 0x46, 0xab, 0x93, 0x1c, 0x53, 0x67, 0x1b, 0x90, 0xcc}
  #gEfiSecurityPkgTokenSpaceGuid.PcdTpmInstanceGuid|{0x7b, 0x3a, 0xcd, 0x72, 0xA5, 0xFE, 0x5e, 0x4f, 0x91, 0x65, 0x4d, 0xd1, 0x21, 0x87, 0xbb, 0x13}
  #gEfiSecurityPkgTokenSpaceGuid.PcdTpmInstanceGuid|{0x66, 0x6f, 0xd6, 0x93, 0xda, 0x55, 0x03, 0x4f, 0x9b, 0x5f, 0x32, 0xcf, 0x9e, 0x54, 0x3b, 0x3a}
  gEfiSecurityPkgTokenSpaceGuid.PcdTpmInstanceGuid|{0x5a, 0xf2, 0x6b, 0x28, 0xc3, 0xc2, 0x8c, 0x40, 0xb3, 0xb4, 0x25, 0xe6, 0x75, 0x8b, 0x73, 0x17}

  gEfiSecurityPkgTokenSpaceGuid.PcdTcg2HashAlgorithmBitmap|0xFFFFFFFF
  gEfiSecurityPkgTokenSpaceGuid.PcdTpm2HashMask|0x0000001F

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  gClientCommonModuleTokenSpaceGuid.PcdTpm2HierarchyChangeAuthPlatform|1
  gClientCommonModuleTokenSpaceGuid.PcdTpm2HierarchyControlPlatform|1
  gClientCommonModuleTokenSpaceGuid.PcdTpm2HierarchyControlEndorsement|1
  gClientCommonModuleTokenSpaceGuid.PcdTpm2HierarchyControlOwner|1
  gClientCommonModuleTokenSpaceGuid.PcdTpm2ChangeEps|0
  gClientCommonModuleTokenSpaceGuid.PcdTpm2ChangePps|0
  gClientCommonModuleTokenSpaceGuid.PcdTpm2Clear|0
!endif

  gEfiSecurityPkgTokenSpaceGuid.PcdTpm2InitializationPolicy|1
  gEfiSecurityPkgTokenSpaceGuid.PcdTpm2SelfTestPolicy|0
  gEfiSecurityPkgTokenSpaceGuid.PcdTpm2ScrtmPolicy|1
!endif
!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  gEfiSecurityPkgTokenSpaceGuid.PcdTpmInitializationPolicy|1
  gEfiSecurityPkgTokenSpaceGuid.PcdTpmScrtmPolicy|1
!endif

#
# AdvancedFeaturesBegin
#
  gClientCommonModuleTokenSpaceGuid.PcdPostIbbVerificationEnable|TRUE

!if gPlatformModuleTokenSpaceGuid.PcdAcpiDebugFeatureEnable == TRUE
  gEfiBpCommonPkgTokenSpaceGuid.PcdAcpiDebugEnable|TRUE
!else
  gEfiBpCommonPkgTokenSpaceGuid.PcdAcpiDebugEnable|FALSE
!endif
#
# AdvancedFeaturesEnd
#

[PcdsDynamicExDefault.common.DEFAULT]
  gEfiMdeModulePkgTokenSpaceGuid.PcdS3BootScriptTablePrivateDataPtr|0x0

[Components.IA32]

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE
  UefiCpuPkg/SecCore/SecCore.inf {
    <LibraryClasses>
      TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/BaseTscTimerLib.inf
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
      TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibSvenTx/BaseTraceHubDebugLibSvenTx.inf
      RngLib|MdePkg/Library/BaseRngLib/BaseRngLib.inf
  }
!else
  #
  # FSP wrapper SEC Core
  #
  UefiCpuPkg/SecCore/SecCore.inf {
    <LibraryClasses>
      TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/BaseAcpiTimerLib.inf
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
  SourceLevelDebugPkg/DebugAgentPei/DebugAgentPei.inf {
    <LibraryClasses>
      DebugAgentLib|SourceLevelDebugPkg/Library/DebugAgent/SecPeiDebugAgentLib.inf
  }
!endif


  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Core/Pei/PeiMain.inf {  # RPPO-KBL-0091: RoyalParkOverrideContent
    <PcdsFixedAtBuild>
      gEfiUsbDebugPortTokenSpaceGuid.PcdEhciHostWaitTimeout|50000
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
!if $(TARGET) == DEBUG
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
    <BuildOptions>
      MSFT:*_*_IA32_CC_FLAGS       = /O1ib2 /GL
!endif
!endif
  }

  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitPei/PlatformInitPreMem.inf {
    <LibraryClasses>
      CpuPolicyLibPreMem|$(PLATFORM_SI_PACKAGE)/Cpu/Library/PeiCpuPolicyLibPreMem/PeiCpuPolicyLibPreMem.inf
      Tpm12CommandLib|SecurityPkg/Library/Tpm12CommandLib/Tpm12CommandLib.inf # AdvancedFeaturesContent
      Tpm12DeviceLib|SecurityPkg/Library/Tpm12DeviceLibDTpm/Tpm12DeviceLibDTpm.inf # AdvancedFeaturesContent
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2DeviceLibDTpm.inf
  }
  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitPei/PlatformInit.inf {
    <LibraryClasses>
      CpuPolicyLib|$(PLATFORM_SI_PACKAGE)/Cpu/Library/PeiCpuPolicyLib/PeiCpuPolicyLib.inf
      Tpm12CommandLib|SecurityPkg/Library/Tpm12CommandLib/Tpm12CommandLib.inf # AdvancedFeaturesContent
      Tpm12DeviceLib|SecurityPkg/Library/Tpm12DeviceLibDTpm/Tpm12DeviceLibDTpm.inf # AdvancedFeaturesContent
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2DeviceLibDTpm.inf
  }

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == FALSE
  $(PLATFORM_FEATURES_PATH)/MultiFv/ReportFvRecoveryPei/ReportFvRecoveryPei.inf {
    <LibraryClasses>
      DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  }
!endif

  MdeModulePkg/Universal/PCD/Pei/Pcd.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
      DebugLib|MdePkg/Library/BaseDebugLibNull/BaseDebugLibNull.inf
!endif
  }
  MdeModulePkg/Universal/ReportStatusCodeRouter/Pei/ReportStatusCodeRouterPei.inf
#
# AdvancedFeaturesBegin
#
  BpCommonPkg/Universal/PlatformStatusCodeHandler/Pei/PlatformStatusCodeHandlerPei.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/ReportStatusCodeTraceHubPei/ReportStatusCodeTraceHubPei.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdCpuIoPpiEnable == TRUE
  UefiCpuPkg/CpuIoPei/CpuIoPei.inf
!endif

  MdeModulePkg/Universal/FaultTolerantWritePei/FaultTolerantWritePei.inf

!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  MdeModulePkg/Universal/Variable/Pei/VariablePei.inf
!else
  MdeModulePkg/Universal/Variable/Pei/VariablePei.inf
!endif

  MdeModulePkg/Universal/PcatSingleSegmentPciCfg2Pei/PcatSingleSegmentPciCfg2Pei.inf

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/CapsulePei/CapsulePei.inf
!endif


  MdeModulePkg/Core/DxeIplPeim/DxeIpl.inf {
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdLzmaEnable == TRUE
      NULL|MdeModulePkg/Library/LzmaCustomDecompressLib/LzmaCustomDecompressLib.inf
!endif
  }

!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/ClientCommonPkg/Universal/SignedSectionPei/SignedSectionPei.inf {  # RPPO-KBL-0067: RoyalParkOverrideContent
    <LibraryClasses>
      NULL|$(CLIENT_COMMON_PACKAGE)/Library/PeiSignedSectionVerificationLib/PeiSignedSectionVerificationLib.inf
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  UefiCpuPkg/Universal/Acpi/S3Resume2Pei/S3Resume2Pei.inf
  UefiCpuPkg/PiSmmCommunication/PiSmmCommunicationPei.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  SecurityPkg/Tcg/PhysicalPresencePei/PhysicalPresencePei.inf

!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/Tcg2Config/Tcg2ConfigPei.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2DeviceLibDTpm.inf
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf
      BootGuardEventLogLib|$(PLATFORM_PACKAGE)/Library/PeiBootGuardEventLogLib/PeiBootGuardEventLogLib.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
  }
  SecurityPkg/Tcg/Tcg2Pei/Tcg2Pei.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
  }
#
# RPPO-KBL-0056: RoyalParkOverrideBegin
#
  $(PLATFORM_PACKAGE)/Override/ClientCommonPkg/Universal/Tcg2PlatformPei/Tcg2PlatformPei.inf  {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterPei.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf
  }
#
# RPPO-KBL-0056: RoyalParkOverrideEnd
#
!endif

  $(CLIENT_COMMON_PACKAGE)/Override/SecurityPkg/Tcg/TcgPei/TcgPei.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdTpmEnable


!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Amt/AmtStatusCodePei/AmtStatusCodePei.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdOverclockEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/PeiOverClock.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdPeiDisplayEnable == TRUE
!endif # PcdPeiDisplayEnable

!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/Acpi/FirmwarePerformanceDataTablePei/FirmwarePerformancePei.inf {
    <LibraryClasses>
      TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/PeiTscTimerLib.inf
  }
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Universal/FpdtPei/FpdtPei.inf    # RPPO-KBL-0045
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
#
# CpuMp PEIM for MpService PPI
#
  $(PLATFORM_SI_PACKAGE)/Override/UefiCpuPkg/CpuMpPei/CpuMpPei.inf      # SICO-KBL-0002
!endif

#
# Silicon Init Package
#
!include $(PLATFORM_SI_PACKAGE)/SiPkgPei.dsc

$(PLATFORM_PACKAGE)/BiosInfo/BiosInfo.inf   # AdvancedFeaturesContent
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Universal/BiosInfoChecker/BiosInfoChecker.inf  # RPPO-SKL-0031: RoyalParkOverrideContent
!endif

#
# AdvancedFeaturesBegin
#

#
# This is for reducing NATIVE DEBUG binary size, replacing some library routines with PPI.
#
!if $(TARGET) == DEBUG
$(CLIENT_COMMON_PACKAGE)/Universal/DebugServicePei/DebugServicePei.inf {
  <LibraryClasses>
    PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
    DebugLib|MdeModulePkg/Library/PeiDxeDebugLibReportStatusCode/PeiDxeDebugLibReportStatusCode.inf
}
!endif
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  IntelFsp2WrapperPkg/FspmWrapperPeim/FspmWrapperPeim.inf
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
  $(PLATFORM_PACKAGE)/FspWrapper/FspWrapperExtractGuidedPeim/FspWrapperExtractGuidedPeim.inf
!endif
  IntelFsp2WrapperPkg/FspsWrapperPeim/FspsWrapperPeim.inf
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/FspWrapper/FspWrapperPeim/FspWrapperPeim.inf
!endif
!endif

!include $(PLATFORM_PACKAGE)/Board/PeiBoardInit.dsc

[Components.X64]

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
UefiCpuPkg/CpuDxe/CpuDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/SecureErase/SecureEraseDxe/SecureEraseDxe.inf
!endif


  #
  # Generic EDKII Driver
  #
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Core/Dxe/DxeMain.inf {
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046
      gEfiMdeModulePkgTokenSpaceGuid.PcdPropertiesTableEnable|FALSE
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
      NULL|$(CLIENT_COMMON_PACKAGE)/Library/DxeSignedSectionVerificationLib/DxeSignedSectionVerificationLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdDxeCrc32SectionEnable == TRUE
      NULL|MdeModulePkg/Library/DxeCrc32GuidedSectionExtractLib/DxeCrc32GuidedSectionExtractLib.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdLzmaEnable == TRUE
      NULL|MdeModulePkg/Library/LzmaCustomDecompressLib/LzmaCustomDecompressLib.inf
!endif
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }


  MdeModulePkg/Core/RuntimeDxe/RuntimeDxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/CapsulePei/CapsuleX64.inf {
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdUsb3SerialStatusCodeEnable == TRUE
      HobLib|MdePkg/Library/PeiHobLib/PeiHobLib.inf
      MemoryAllocationLib|MdePkg/Library/PeiMemoryAllocationLib/PeiMemoryAllocationLib.inf
      Usb3DebugPortLib|BpCommonPkg/Library/Usb3DebugPortLib/Usb3DebugPortLibPei.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
      TraceHubDebugLib|BpCommonPkg/Library/TraceHubDebugLibSvenTx/PeiTraceHubDebugLibSvenTx.inf
!endif
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == TRUE
      PeiMeLib|$(PLATFORM_SI_PACKAGE)/Me/Library/PeiMeLib/PeiMeLib.inf
      ResetSystemLib|$(PLATFORM_SI_PACKAGE)/Pch/Library/PeiResetSystemLib/PeiResetSystemLib.inf
!endif
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdScsiEnable == TRUE
  MdeModulePkg/Bus/Scsi/ScsiBusDxe/ScsiBusDxe.inf
  MdeModulePkg/Bus/Scsi/ScsiDiskDxe/ScsiDiskDxe.inf
!endif


!if gPlatformModuleTokenSpaceGuid.PcdUsbEnable == TRUE
  MdeModulePkg/Bus/Pci/EhciDxe/EhciDxe.inf
  MdeModulePkg/Bus/Pci/UhciDxe/UhciDxe.inf
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Bus/Usb/UsbBusDxe/UsbBusDxe.inf
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Bus/Pci/XhciDxe/XhciDxe.inf
!if gClientCommonModuleTokenSpaceGuid.PcdKeyboardLedSyncEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Override/MdeModulePkg/Bus/Usb/UsbKbDxe/UsbKbDxe.inf
!else
  MdeModulePkg/Bus/Usb/UsbKbDxe/UsbKbDxe.inf
!endif
  MdeModulePkg/Bus/Usb/UsbMassStorageDxe/UsbMassStorageDxe.inf
  MdeModulePkg/Bus/Usb/UsbMouseDxe/UsbMouseDxe.inf

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
# @todo : Add Legacy USB source back
!endif
!endif # gPlatformModuleTokenSpaceGuid.PcdUsbEnable

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/AmiInternalOnly/AmiLegacyBiosHook/AmiLegacyBiosHook.inf
!endif

  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/SecurityStubDxe/SecurityStubDxe.inf {  # RPPO-KBL-0079
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
      NULL|SecurityPkg/Library/DxeImageVerificationLib/DxeImageVerificationLib.inf
!else
      NULL|SecurityPkg/Library/DxeImageVerificationLib/DxeImageVerificationLib.inf
!endif
!endif
!if gPlatformModuleTokenSpaceGuid.PcdUserIdentificationEnable == TRUE
      NULL|$(PLATFORM_PACKAGE)/Override/SecurityPkg/Library/DxeDeferImageLoadLib/DxeDeferImageLoadLib.inf # RPPO-SKL-0030
!endif
!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
      NULL|SecurityPkg/Library/DxeTpmMeasureBootLib/DxeTpmMeasureBootLib.inf
!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
      NULL|SecurityPkg/Library/DxeTpm2MeasureBootLib/DxeTpm2MeasureBootLib.inf
!endif
!endif
  }

  $(CLIENT_COMMON_PACKAGE)/Universal/IsvtCheckpointDxe/IsvtCheckpointDxe.inf # AdvancedFeaturesContent
  MdeModulePkg/Universal/DriverHealthManagerDxe/DriverHealthManagerDxe.inf

  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/BdsDxe/BdsDxe.inf { # RPPO-KBL-0064: RoyalParkOverrideContent
    <LibraryClasses>
!if $(TARGET) == DEBUG
!endif
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
      NULL|IntelFrameworkModulePkg/Library/LegacyBootManagerLib/LegacyBootManagerLib.inf
!endif
  }

!if gPlatformModuleTokenSpaceGuid.PcdSetupEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  MdeModulePkg/Application/UiApp/UiApp.inf
  MdeModulePkg/Application/BootManagerMenuApp/BootManagerMenuApp.inf
!else
  $(PLATFORM_FEATURES_PATH)/UiApp/UiApp.inf {
    <LibraryClasses>
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
      NULL|IntelFrameworkModulePkg/Library/LegacyBootManagerLib/LegacyBootManagerLib.inf
!endif
  }
  MdeModulePkg/Application/BootManagerMenuApp/BootManagerMenuApp.inf {
    <LibraryClasses>
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
      NULL|IntelFrameworkModulePkg/Library/LegacyBootManagerLib/LegacyBootManagerLib.inf
!endif
  }
!endif #PcdMinTreeEnable
#
# AdvancedFeaturesBegin
#
!if gPlatformModuleTokenSpaceGuid.PcdUserAuthenticationEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Universal/UserAuthentication/UserAuthenticationDxe.inf #RPPO-KBL-0085: RoyalParkOverrideContent
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Universal/UserAuthentication/UserAuthenticationSmm.inf #RPPO-KBL-0085: RoyalParkOverrideContent
!endif
#
# AdvancedFeaturesEnd
#
!endif #PcdSetupEnable

#
# AdvancedFeaturesBegin
#
$(PLATFORM_FEATURES_PATH)/SdMmc/SdControllerDxe/MmcHostDxe.inf
$(PLATFORM_FEATURES_PATH)/SdMmc/SdMediaDeviceDxe/MmcMediaDeviceDxe.inf
#
# AdvancedFeaturesEnd
#
!if gPlatformModuleTokenSpaceGuid.PcdTerminalEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == FALSE
  $(CLIENT_COMMON_PACKAGE)/Universal/SpcrAcpiDxe/SpcrAcpiDxe.inf
!endif
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
  IntelFsp2WrapperPkg/FspWrapperNotifyDxe/FspWrapperNotifyDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
      SerialPortLib|MdeModulePkg/Library/BaseSerialPortLib16550/BaseSerialPortLib16550.inf
      DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf
!else
      SerialPortLib|$(PLATFORM_PACKAGE)/Library/BaseSerialPortLib/BaseSerialPortLib$(TRACEHUB).inf
      DebugPrintErrorLevelLib|$(CLIENT_COMMON_PACKAGE)/Library/BaseDebugPrintErrorLevelLibCmosPcd/BaseDebugPrintErrorLevelLibCmosPcd.inf
!endif
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Flash/SpiFvbService/SpiFvbServiceDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSmmVariableEnable == TRUE
  $(PLATFORM_PACKAGE)/Flash/SpiFvbService/SpiFvbServiceSmm.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
!if gPlatformModuleTokenSpaceGuid.PcdFspWrapperEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
      SerialPortLib|$(PLATFORM_PACKAGE)/Library/BaseSerialPortLib/BaseSerialPortLib$(TRACEHUB).inf
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
      DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf
!endif
!endif
!endif
  }
!endif # gSiPkgTokenSpaceGuid.PcdSmmVariableEnable

  #
  # Thunk drivers that convert the protocols between Framework and UEFI to provide the compatibility.
  #
!if gPlatformModuleTokenSpaceGuid.PcdEbcEnable == TRUE
  MdeModulePkg/Universal/EbcDxe/EbcDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSmmVariableEnable == TRUE
  MdeModulePkg/Universal/FaultTolerantWriteDxe/FaultTolerantWriteSmm.inf
  MdeModulePkg/Universal/Variable/RuntimeDxe/VariableSmmRuntimeDxe.inf {
    <LibraryClasses>
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == FALSE
      TpmMeasurementLib|MdeModulePkg/Library/TpmMeasurementLibNull/TpmMeasurementLibNull.inf
!endif
  }
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/Variable/RuntimeDxe/VariableSmm.inf {  #RPPO-KBL-0089: RoyalParkOverrideContent
    <LibraryClasses>
      VarCheckLib|MdeModulePkg/Library/VarCheckLib/VarCheckLib.inf
      NULL|MdeModulePkg/Library/VarCheckUefiLib/VarCheckUefiLib.inf
      NULL|MdeModulePkg/Library/VarCheckHiiLib/VarCheckHiiLib.inf
      NULL|$(PLATFORM_PACKAGE)/Library/PlatformVarCheckLib/PlatformVarCheckLib.inf # AdvancedFeaturesContent
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      AuthVariableLib|SecurityPkg/Library/AuthVariableLib/AuthVariableLib.inf
!else
      PlatformSecureLib|SecurityPkg/Library/PlatformSecureLibNull/PlatformSecureLibNull.inf
      AuthVariableLib|MdeModulePkg/Library/AuthVariableLibNull/AuthVariableLibNull.inf
!endif
  }
!else
  MdeModulePkg/Universal/Variable/RuntimeDxe/VariableSmm.inf {
    <LibraryClasses>
      VarCheckLib|MdeModulePkg/Library/VarCheckLib/VarCheckLib.inf
      NULL|MdeModulePkg/Library/VarCheckUefiLib/VarCheckUefiLib.inf
      NULL|MdeModulePkg/Library/VarCheckHiiLib/VarCheckHiiLib.inf
      NULL|$(PLATFORM_PACKAGE)/Library/PlatformVarCheckLib/PlatformVarCheckLib.inf # AdvancedFeaturesContent
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      AuthVariableLib|SecurityPkg/Library/AuthVariableLib/AuthVariableLib.inf
!else
      PlatformSecureLib|SecurityPkg/Library/PlatformSecureLibNull/PlatformSecureLibNull.inf
      AuthVariableLib|MdeModulePkg/Library/AuthVariableLibNull/AuthVariableLibNull.inf
!endif
  }
!endif # gSiPkgTokenSpaceGuid.PcdMinTreeEnable

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  MdeModulePkg/Universal/FaultTolerantWriteDxe/FaultTolerantWriteDxe.inf
!endif
!else
  MdeModulePkg/Universal/FaultTolerantWriteDxe/FaultTolerantWriteDxe.inf

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/Variable/RuntimeDxe/VariableRuntimeDxe.inf {  #RPPO-KBL-0089: RoyalParkOverrideContent
    <LibraryClasses>
      VarCheckLib|MdeModulePkg/Library/VarCheckLib/VarCheckLib.inf
      NULL|MdeModulePkg/Library/VarCheckUefiLib/VarCheckUefiLib.inf
      NULL|MdeModulePkg/Library/VarCheckHiiLib/VarCheckHiiLib.inf
      NULL|$(PLATFORM_PACKAGE)/Library/PlatformVarCheckLib/PlatformVarCheckLib.inf
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      AuthVariableLib|SecurityPkg/Library/AuthVariableLib/AuthVariableLib.inf
!else
      PlatformSecureLib|SecurityPkg/Library/PlatformSecureLibNull/PlatformSecureLibNull.inf
      AuthVariableLib|MdeModulePkg/Library/AuthVariableLibNull/AuthVariableLibNull.inf
      TpmMeasurementLib|MdeModulePkg/Library/TpmMeasurementLibNull/TpmMeasurementLibNull.inf
!endif
  }
!else
  MdeModulePkg/Universal/Variable/RuntimeDxe/VariableRuntimeDxe.inf {
    <LibraryClasses>
      VarCheckLib|MdeModulePkg/Library/VarCheckLib/VarCheckLib.inf
      NULL|MdeModulePkg/Library/VarCheckUefiLib/VarCheckUefiLib.inf
      NULL|MdeModulePkg/Library/VarCheckHiiLib/VarCheckHiiLib.inf
      NULL|$(PLATFORM_PACKAGE)/Library/PlatformVarCheckLib/PlatformVarCheckLib.inf
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      AuthVariableLib|SecurityPkg/Library/AuthVariableLib/AuthVariableLib.inf
!else
      PlatformSecureLib|SecurityPkg/Library/PlatformSecureLibNull/PlatformSecureLibNull.inf
      AuthVariableLib|MdeModulePkg/Library/AuthVariableLibNull/AuthVariableLibNull.inf
      TpmMeasurementLib|MdeModulePkg/Library/TpmMeasurementLibNull/TpmMeasurementLibNull.inf
!endif
  }
!endif # gSiPkgTokenSpaceGuid.PcdMinTreeEnable

!endif # gSiPkgTokenSpaceGuid.PcdSmmVariableEnable

!if gPlatformModuleTokenSpaceGuid.PcdSecureBootEnable == TRUE
 $(PLATFORM_PACKAGE)/Override/SecurityPkg/VariableAuthenticated/SecureBootConfigDxe/SecureBootConfigDxe.inf {
    <LibraryClasses>
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
    <BuildOptions>
      #
      # Specify GUID gEfiIfrBootMaintenanceGuid, to install Secure Boot Configuration menu
      # into Boot Maintenance Manager menu
      #
      *_*_*_VFR_FLAGS   = -g b2dedc91-d59f-48d2-898a-12490c74a4e0
  }
!endif

  $(PLATFORM_FEATURES_PATH)/Wfu/EsrtDxe/EsrtDxe.inf # AdvancedFeaturesContent
  MdeModulePkg/Universal/WatchdogTimerDxe/WatchdogTimer.inf
  MdeModulePkg/Universal/MonotonicCounterRuntimeDxe/MonotonicCounterRuntimeDxe.inf
  MdeModulePkg/Universal/CapsuleRuntimeDxe/CapsuleRuntimeDxe.inf
!if gPlatformModuleTokenSpaceGuid.PcdConSplitterEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  MdeModulePkg/Universal/Console/ConPlatformDxe/ConPlatformDxe.inf
!else
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/Console/ConPlatformDxe/ConPlatformDxe.inf # RPPO-KBL-0050
!endif
  MdeModulePkg/Universal/Console/ConSplitterDxe/ConSplitterDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif
  MdeModulePkg/Universal/DevicePathDxe/DevicePathDxe.inf {
    <PcdsFeatureFlag>
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
      gEfiMdeModulePkgTokenSpaceGuid.PcdDevicePathSupportDevicePathToText|TRUE
!endif
  }
!if gPlatformModuleTokenSpaceGuid.PcdGraphicsConsoleEnable == TRUE
  MdeModulePkg/Universal/Console/GraphicsConsoleDxe/GraphicsConsoleDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif
!if gPlatformModuleTokenSpaceGuid.PcdTerminalEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Override/MdeModulePkg/Universal/Console/TerminalDxe/TerminalDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdFatEnable == TRUE
  MdeModulePkg/Universal/Disk/DiskIoDxe/DiskIoDxe.inf
  MdeModulePkg/Universal/Disk/PartitionDxe/PartitionDxe.inf
!endif

  PcAtChipsetPkg/PcatRealTimeClockRuntimeDxe/PcatRealTimeClockRuntimeDxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdSetupEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/HiiDatabaseDxe/HiiDatabaseDxe.inf # RPPO-SKL-0001
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/SetupBrowserDxe/SetupBrowserDxe.inf # RPPO-SKL-0015

  MdeModulePkg/Universal/DisplayEngineDxe/DisplayEngineDxe.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdSetupEnable

!if gPlatformModuleTokenSpaceGuid.PcdUnicodeCollectionEnable == TRUE
  MdeModulePkg/Universal/Disk/UnicodeCollation/EnglishDxe/EnglishDxe.inf
!endif
  MdeModulePkg/Universal/PCD/Dxe/Pcd.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  }

!if gPlatformModuleTokenSpaceGuid.PcdUserIdentificationEnable == TRUE
  SecurityPkg/UserIdentification/UserIdentifyManagerDxe/UserIdentifyManagerDxe.inf
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/UserIdentification/UserProfileManagerDxe/UserProfileManagerDxe.inf # RPPO-SKL-0030
  SecurityPkg/UserIdentification/PwdCredentialProviderDxe/PwdCredentialProviderDxe.inf
  SecurityPkg/UserIdentification/UsbCredentialProviderDxe/UsbCredentialProviderDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdNetworkEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdNetworkIscsiEnable == TRUE
!if gPlatformModuleTokenSpaceGuid.PcdNetworkIp6Enable == TRUE
  NetworkPkg/IScsiDxe/IScsiDxe.inf
!else
  MdeModulePkg/Universal/Network/IScsiDxe/IScsiDxe.inf
!endif
!endif

!if gPlatformModuleTokenSpaceGuid.PcdNetworkVlanEnable == TRUE
  MdeModulePkg/Universal/Network/VlanConfigDxe/VlanConfigDxe.inf
!endif
  MdeModulePkg/Universal/Network/SnpDxe/SnpDxe.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdNetworkEnable

  MdeModulePkg/Universal/ReportStatusCodeRouter/RuntimeDxe/ReportStatusCodeRouterRuntimeDxe.inf
  MdeModulePkg/Universal/ReportStatusCodeRouter/Smm/ReportStatusCodeRouterSmm.inf

#
# AdvancedFeaturesBegin
#
  BpCommonPkg/Universal/PlatformStatusCodeHandler/RuntimeDxe/PlatformStatusCodeHandlerRuntimeDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/ReportStatusCodeTraceHubDxe/ReportStatusCodeTraceHubDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif

  BpCommonPkg/Universal/PlatformStatusCodeHandler/Smm/PlatformStatusCodeHandlerSmm.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!if gSiPkgTokenSpaceGuid.PcdTraceHubEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/ReportStatusCodeTraceHubSmm/ReportStatusCodeTraceHubSmm.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif
#
# AdvancedFeaturesEnd
#


  MdeModulePkg/Universal/Acpi/FirmwarePerformanceDataTableDxe/FirmwarePerformanceDxe.inf {
    <LibraryClasses>
      !if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
        TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/DxeAcpiTimerLib.inf
      !else
        TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
      !endif
  }
  MdeModulePkg/Universal/Acpi/FirmwarePerformanceDataTableSmm/FirmwarePerformanceSmm.inf {
    <LibraryClasses>
      !if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
        TimerLib|PcAtChipsetPkg/Library/AcpiTimerLib/DxeAcpiTimerLib.inf
      !else
        TimerLib|$(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/Library/TscAcpiTimerLib/DxeTscTimerLib.inf
      !endif
  }

  MdeModulePkg/Universal/Acpi/BootGraphicsResourceTableDxe/BootGraphicsResourceTableDxe.inf
  MdeModulePkg/Bus/Pci/PciSioSerialDxe/PciSioSerialDxe.inf

#
# AdvancedFeaturesBegin
#
  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Bus/Isa/IsaIoDxe/IsaIoDxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdTerminalEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdSourceDebugEnable == FALSE
  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Bus/Isa/IsaSerialDxe/IsaSerialDxe.inf
!endif
!endif

 $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Bus/Isa/Ps2KeyboardDxe/Ps2keyboardDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
      !if $(TARGET) == DEBUG
        DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
      !endif
  }

!if gPlatformModuleTokenSpaceGuid.PcdMouseEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Bus/Isa/Ps2MouseDxe/Ps2MouseDxe.inf
!endif
#
# AdvancedFeaturesEnd
#

  MdeModulePkg/Universal/SmmCommunicationBufferDxe/SmmCommunicationBufferDxe.inf

!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
  MdeModulePkg/Bus/Ata/AtaBusDxe/AtaBusDxe.inf {
    <LibraryClasses>
      DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80000000
  }
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Bus/Ata/AtaAtapiPassThru/AtaAtapiPassThru.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
      DebugPrintErrorLevelLib|MdePkg/Library/BaseDebugPrintErrorLevelLib/BaseDebugPrintErrorLevelLib.inf
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80000000
  }
!if gPlatformModuleTokenSpaceGuid.PcdHddPasswordEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Universal/HddPassword/Dxe/HddPasswordDxe.inf { # RPPO-KBL-0088: RoyalParkOverrideContent
    <BuildOptions>
      #
      # Specify GUID gEfiIfrBootMaintenanceGuid, to install HddPassword Configuration menu
      # into Boot Maintenance Manager menu
      #
      *_*_*_VFR_FLAGS   = -g b2dedc91-d59f-48d2-898a-12490c74a4e0
  }
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Universal/HddPassword/Smm/HddPasswordSmm.inf { # RPPO-KBL-0088: RoyalParkOverrideContent
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif # gPlatformModuleTokenSpaceGuid.PcdHddPasswordEnable

!if gPlatformModuleTokenSpaceGuid.PcdIntelRaidEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Csm/IntelRaidAtaAtapiPassThru/IntelRaidAtaAtapiPassThru.inf
  $(CLIENT_COMMON_PACKAGE)/Csm/IntelRaidBiosThunk/IntelRaidBiosThunk.inf
!endif
!endif
!endif # gSiPkgTokenSpaceGuid.PcdAtaEnable

!if (gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE) OR (gPlatformModuleTokenSpaceGuid.PcdNvmeEnable == TRUE)
!if gPlatformModuleTokenSpaceGuid.PcdOpalPasswordEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/Opal/OpalPasswordDxe/OpalPasswordDxe.inf
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/Opal/OpalPasswordSmm/OpalPasswordSmm.inf # RPPO-KBL-0072
!endif
!endif

!if gPlatformModuleTokenSpaceGuid.PcdIntelRaidEnable == TRUE
  #
  # DiskInfo protocol driver for the INTEL UEFI RAID Driver
  #
  $(PLATFORM_FEATURES_PATH)/Sata/IntelUefiRaidDiskInfo/IntelUefiRaidDiskInfo.inf
!endif

  $(CLIENT_COMMON_PACKAGE)/Universal/SetTimerPeriodDxe/SetTimerPeriodDxe.inf # AdvancedFeaturesContent

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  MdeModulePkg/Bus/Pci/PciBusDxe/PciBusDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!else
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Bus/Pci/PciBusDxe/PciBusDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif # gSiPkgTokenSpaceGuid.PcdMinTreeEnable

!if gPlatformModuleTokenSpaceGuid.PcdDataHubEnable == TRUE
  IntelFrameworkModulePkg/Universal/DataHubDxe/DataHubDxe.inf {
    <PcdsFixedAtBuild>
      gEfiMdePkgTokenSpaceGuid.PcdMaximumLinkedListLength|0
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdDataHubEnable == TRUE
  IntelFrameworkModulePkg/Universal/StatusCode/DatahubStatusCodeHandlerDxe/DatahubStatusCodeHandlerDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Csm/BiosThunk/VideoDxe/VideoDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Csm/LegacyBiosDxe/LegacyBiosDxe.inf {
    <LibraryClasses>
      BaseMemoryLib|MdePkg/Library/BaseMemoryLibSse2/BaseMemoryLibSse2.inf
  }
!endif # gSiPkgTokenSpaceGuid.PcdSiCsmEnable

#
# I2C Stack:Start
#
!if gPlatformModuleTokenSpaceGuid.PcdPiI2cStackEnable == TRUE
  MdeModulePkg/Bus/I2c/I2cDxe/I2cDxe.inf
  $(PLATFORM_FEATURES_PATH)/I2c/I2cPlatformDxe/I2cPlatformDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdI2cTouchDriverEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/I2c/I2cTouchPanelDxe/I2cTouchPanelDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdVirtualKeyboardEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Universal/VirtualKeyboardDxe/VirtualKeyboardDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif
#
# I2C Stack:End
#

!if gPlatformModuleTokenSpaceGuid.PcdTouchInputFilterEnabled == TRUE
  $(PLATFORM_FEATURES_PATH)/Touch/TouchInputFilter/TouchInputFilterDriver.inf
!endif

  PcAtChipsetPkg/8259InterruptControllerDxe/8259.inf

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  $(PLATFORM_PACKAGE)/Csm/Board/Default/IrqBoardInfo.inf
  $(PLATFORM_PACKAGE)/Csm/Board/Rvp/IrqBoardInfoRvp.inf
  $(PLATFORM_PACKAGE)/Csm/Board/RvpM/IrqBoardInfoRvpM.inf
  $(PLATFORM_PACKAGE)/Csm/Board/RvpDt/IrqBoardInfoRvpDt.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Csm/IrqTableInfo/IrqTableInfo.inf
!endif


!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  MdeModulePkg/Universal/Acpi/AcpiTableDxe/AcpiTableDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSimpleBootFlagEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/SimpleBootFlagDxe/SimpleBootFlag.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  MdeModulePkg/Universal/Acpi/S3SaveStateDxe/S3SaveStateDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
  MdeModulePkg/Universal/Acpi/SmmS3SaveState/SmmS3SaveState.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
#
# Add a DXE driver to create the AcpiGlobalVariable variable.
# It should be dispatched before AcpiS3SaveDxe driver.
# This driver is dependent on platform implementation and for being compatible with other platforms.
# If MpService does set the AcpiGlobalVariable, then do not include this driver.
#
  $(PLATFORM_PACKAGE)/Acpi/AcpiGlobalVariable/AcpiGlobalVariable.inf

  $(CLIENT_COMMON_PACKAGE)/Override/IntelFrameworkModulePkg/Universal/Acpi/AcpiS3SaveDxe/AcpiS3SaveDxe.inf  {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
  MdeModulePkg/Universal/Acpi/BootScriptExecutorDxe/BootScriptExecutorDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif
!if gPlatformModuleTokenSpaceGuid.PcdMemoryTestEnable == TRUE
  MdeModulePkg/Universal/MemoryTest/GenericMemoryTestDxe/GenericMemoryTestDxe.inf
!else
  MdeModulePkg/Universal/MemoryTest/NullMemoryTestDxe/NullMemoryTestDxe.inf
!endif
  MdeModulePkg/Universal/Metronome/Metronome.inf
#
# AdvancedFeaturesBegin
#
  $(PLATFORM_FEATURES_PATH)/FastBoot/FastBootHandlerDxe/FastBootHandlerDxe.inf
  $(PLATFORM_FEATURES_PATH)/MultiFv/DecompressFvMain2Dxe/DecompressFvMain2Dxe.inf
#
# AdvancedFeaturesEnd
#
#
# GraphicsOutputDxe and BltLib are required when IntelGopDriver is removed in Mintree.
#
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Console/GraphicsOutputDxe/GraphicsOutputDxe.inf { # RPPO-KBL-0074: RoyalParkOverrideContent
    <LibraryClasses>
      BltLib|$(PLATFORM_PACKAGE)/Override/MdeModulePkg/Library/FrameBufferBltLib/FrameBufferBltLib.inf
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  MdeModulePkg/Universal/SmbiosDxe/SmbiosDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
   IntelFrameworkModulePkg/Csm/BiosThunk/BlockIoDxe/BlockIoDxe.inf
!endif

  UefiCpuPkg/CpuIo2Dxe/CpuIo2Dxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdNetworkEnable == TRUE
  #
  # UEFI network modules
  #
  MdeModulePkg/Universal/Network/DpcDxe/DpcDxe.inf
  MdeModulePkg/Universal/Network/MnpDxe/MnpDxe.inf
  MdeModulePkg/Universal/Network/ArpDxe/ArpDxe.inf
  MdeModulePkg/Universal/Network/Dhcp4Dxe/Dhcp4Dxe.inf
  MdeModulePkg/Universal/Network/Ip4Dxe/Ip4Dxe.inf
  MdeModulePkg/Universal/Network/Mtftp4Dxe/Mtftp4Dxe.inf
  MdeModulePkg/Universal/Network/Tcp4Dxe/Tcp4Dxe.inf {
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80000000
  }
  MdeModulePkg/Universal/Network/Udp4Dxe/Udp4Dxe.inf

!if gPlatformModuleTokenSpaceGuid.PcdNetworkIp6Enable == TRUE
  NetworkPkg/Ip6Dxe/Ip6Dxe.inf
  NetworkPkg/Dhcp6Dxe/Dhcp6Dxe.inf
  NetworkPkg/IpSecDxe/IpSecDxe.inf
  NetworkPkg/TcpDxe/TcpDxe.inf
  NetworkPkg/Udp6Dxe/Udp6Dxe.inf
  NetworkPkg/Mtftp6Dxe/Mtftp6Dxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdNetworkIp6Enable == TRUE
  NetworkPkg/UefiPxeBcDxe/UefiPxeBcDxe.inf
!else
  MdeModulePkg/Universal/Network/UefiPxeBcDxe/UefiPxeBcDxe.inf
!endif
!endif # gPlatformModuleTokenSpaceGuid.PcdNetworkEnable

#
# AdvancedFeaturesBegin
#
  $(PLATFORM_PACKAGE)/Platform/PlatformInfo/Dxe/PlatformInfoDxe.inf
  $(PLATFORM_FEATURES_PATH)/SdMmc/PlatformEmmcDxe/PlatformEmmcDxe.inf
  $(PLATFORM_FEATURES_PATH)/FastBoot/FastBootSetupDxe/FastBootSetupDxe.inf
#
# AdvancedFeaturesEnd
#


!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Smbios/SmbiosMiscDxe/SmbiosMiscDxe.inf
  $(PLATFORM_FEATURES_PATH)/Me/MeSmbiosDxe/MeSmbiosDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Platform/PlatformSetup/Dxe/PlatformSetup.inf
!endif

  MdeModulePkg/Core/PiSmmCore/PiSmmIpl.inf
  MdeModulePkg/Core/PiSmmCore/PiSmmCore.inf {
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == TRUE
  UefiCpuPkg/PiSmmCpuDxeSmm/PiSmmCpuDxeSmm.inf {
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!else
  $(PLATFORM_PACKAGE)/Override/UefiCpuPkg/PiSmmCpuDxeSmm/PiSmmCpuDxeSmm.inf {
    <PcdsPatchableInModule>
      gEfiMdePkgTokenSpaceGuid.PcdDebugPrintErrorLevel|0x80080046
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif

  UefiCpuPkg/CpuIo2Smm/CpuIo2Smm.inf


  $(PLATFORM_PACKAGE)/PlatformInit/PolicyInitDxe/PolicyInitDxe.inf
  $(PLATFORM_PACKAGE)/PlatformInit/PlatformInitDxe/PlatformInitDxe.inf

#
# Silicon Init Package
#
!include $(PLATFORM_SI_PACKAGE)/SiPkgDxe.dsc

!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  $(PLATFORM_PACKAGE)/Platform/SmramSaveInfoHandlerSmm/SmramSaveInfoHandlerSmm.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdTxtEnable == TRUE
# $(PLATFORM_FEATURES_PATH)/Txt/TxtOneTouchDxe/TxtOneTouchDxe.inf
!endif


!if gSiPkgTokenSpaceGuid.PcdUseHpetTimer == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Override/PcAtChipsetPkg/HpetTimerDxe/HpetTimerDxe.inf
!else
  PcAtChipsetPkg/HpetTimerDxe/HpetTimerDxe.inf
!endif
!endif

#  need customized IncompatiblePciDeviceSupportDxe for the platform, below is a sample template
#  MdeModulePkg/Bus/Pci/IncompatiblePciDeviceSupportDxe/IncompatiblePciDeviceSupportDxe.inf

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Platform/PciPlatform/Dxe/PciPlatform.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(PLATFORM_PACKAGE)/Csm/CsmPlatformLoader/CsmPlatformLoader.inf
  $(PLATFORM_PACKAGE)/Csm/LegacyBiosPlatformDxe/LegacyBiosPlatform.inf
!endif

#
# AdvancedFeaturesBegin
#
  $(PLATFORM_FEATURES_PATH)/Hsti/HstiIbvPlatformDxe/HstiIbvPlatformDxe.inf {
    <LibraryClasses>
      HstiLib|$(PLATFORM_SI_PACKAGE)/Override/MdePkg/Library/DxeHstiLib/DxeHstiLib.inf  # SICO-KBL-0003
  }

  $(PLATFORM_FEATURES_PATH)/Hsti/HstiResultDxe/HstiResultDxe.inf
#
# AdvancedFeaturesEnd
#

!if gPlatformModuleTokenSpaceGuid.PcdTpmEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/TcgConfigDxe/TcgConfigDxe.inf {
    <BuildOptions>
      #
      # specify GUID gEfiIfrNotInTPVPageGuid, this page will not
      # be showed in TPV page.
      #
      *_*_*_VFR_FLAGS   = -g 1947c034-062f-44c0-bcc4-19927afe9ea4
  }

!if gPlatformModuleTokenSpaceGuid.PcdTpm2Enable == TRUE
  SecurityPkg/Tcg/MemoryOverwriteControl/TcgMor.inf
  SecurityPkg/Tcg/MemoryOverwriteRequestControlLock/TcgMorLockSmm.inf
  SecurityPkg/Tcg/Tcg2Dxe/Tcg2Dxe.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterDxe.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha1/HashInstanceLibSha1.inf
      NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/Tcg2Smm/Tcg2Smm.inf # RPPO-KBL-0073: RoyalParkOverrideContent
# use platform Tcg2ConfigDxe when porting
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/Tcg2Config/Tcg2ConfigDxe.inf {
    <LibraryClasses>
      Tpm2DeviceLib|SecurityPkg/Library/Tpm2DeviceLibRouter/Tpm2DeviceLibRouterDxe.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf

    <BuildOptions>
      #
      # specify GUID gEfiIfrNotInTPVPageGuid, this page will not
      # be showed in TPV page.
      #
      *_*_*_VFR_FLAGS   = -g 1947c034-062f-44c0-bcc4-19927afe9ea4
  }
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Universal/TrEEPlatformDxe/TrEEPlatformDxe.inf  { # RPPO-KBL-0082
    <LibraryClasses>
      PlatformSecureLib|$(PLATFORM_PACKAGE)/Library/PlatformSecureLibTest/PlatformSecureLibTest.inf
      NULL|SecurityPkg/Library/Tpm2DeviceLibDTpm/Tpm2InstanceLibDTpm.inf
      NULL|$(PLATFORM_PACKAGE)/Library/Tpm2DeviceLibPtp/Tpm2InstanceLibPtt.inf
  }

  $(PLATFORM_PACKAGE)/Override/MdeModulePkg/Universal/SmbiosMeasurementDxe/SmbiosMeasurementDxe.inf # RPPO-KBL-0069

  $(CLIENT_COMMON_PACKAGE)/Override/SecurityPkg/Tcg/TcgDxe/TcgDxe.inf {
    !if $(TARGET) == DEBUG
      <LibraryClasses>
        DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
    !endif
  }
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/TcgSmm/TcgSmm.inf # RPPO-KBL-0073: RoyalParkOverrideContent
!else
  SecurityPkg/Tcg/MemoryOverwriteControl/TcgMor.inf
  SecurityPkg/Tcg/TcgDxe/TcgDxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/BasePcdLibNull/BasePcdLibNull.inf
  }
  $(PLATFORM_PACKAGE)/Override/SecurityPkg/Tcg/TcgSmm/TcgSmm.inf # RPPO-KBL-0073: RoyalParkOverrideContent
!endif # gPlatformModuleTokenSpaceGuid.PcdTpm2Enable

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Csm/TcgLegacy/TcgLegacy.inf                # RPPO-KBL-0043
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Csm/TcgLegacy/TcgLegacyInstallInt1A.inf    # RPPO-KBL-0043
  $(PLATFORM_PACKAGE)/Override/BpCommonPkg/Csm/TcgLegacy/TcgLegacy16.inf              # RPPO-KBL-0043
!endif
  # module to update variable according to TPM HW state, the code could be in TcgDxe driver but better to be separated
  $(PLATFORM_FEATURES_PATH)/Tcg/TcgSetupDxe/TcgSetupDxe.inf
!endif # gPlatformModuleTokenSpaceGuid.PcdTpmEnable


!if gPlatformModuleTokenSpaceGuid.PcdSaveMemoryConfigEnable == TRUE
  $(PLATFORM_PACKAGE)/Platform/SaveMemoryConfig/Dxe/SaveMemoryConfig.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSavePegConfigEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Platform/SavePegConfig/Dxe/SavePegConfig.inf
!endif
!endif

!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  $(PLATFORM_PACKAGE)/Acpi/AcpiTables/AcpiPlatform.inf
  $(PLATFORM_FEATURES_PATH)/Acpi/AcpiTables/AcpiFeatures.inf # AdvancedFeaturesContent
!if gPlatformModuleTokenSpaceGuid.PcdAcpiDebugFeatureEnable == TRUE
  BpCommonPkg/Universal/AcpiDebug/AcpiDebugDxe.inf {
    <LibraryClasses>
!if $(TARGET) == DEBUG
      DebugLib|MdePkg/Library/BaseDebugLibSerialPort/BaseDebugLibSerialPort.inf
!endif
  }
!endif
!endif

  $(PLATFORM_FEATURES_PATH)/Me/MeUlvCheckDxe/MeUlvCheckDxe.inf # AdvancedFeaturesContent

!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  $(PLATFORM_PACKAGE)/Acpi/AcpiSmm/AcpiSmm.inf
  #
  # AdvancedFeaturesBegin
  #
  $(PLATFORM_PACKAGE)/Platform/SmmPlatform/Smm/SmmPlatform.inf {
     <BuildOptions>
       *_*_X64_CC_FLAGS      = -DDOCK_ENABLE
  }
  $(PLATFORM_FEATURES_PATH)/Pep/Smm/PepBccdSmm.inf
  #
  # AdvancedFeaturesEnd
  #
!endif

!if gPlatformModuleTokenSpaceGuid.PcdSmmProfileEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Universal/SmmProfileSmi/SmmProfileSmi.inf
!endif

#
# AdvancedFeaturesBegin
#
#
# AcpiTables
#
!if gSiPkgTokenSpaceGuid.PcdAcpiEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Dptf/AcpiTables/DptfAcpiTables.inf
  $(PLATFORM_FEATURES_PATH)/Dptf/AcpiTables/Sds/DptfAcpiTablesSds.inf
  $(PLATFORM_FEATURES_PATH)/Dptf/Dxe/Dptf.inf
!endif
#
# AdvancedFeaturesEnd
#

  # ROYAL_PARK_PORTING - Porting Required
  $(PLATFORM_PACKAGE)/Binaries/Microcode/MicrocodeUpdates.inf

!if gPlatformModuleTokenSpaceGuid.PcdCapsuleEnable == TRUE
  # capsule related drivers and Application.
  BpCommonPkg/Applications/CapsuleApp/CapsuleApp.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdPciHotplugEnable == TRUE
  $(PLATFORM_PACKAGE)/Platform/PciHotPlug/PciHotPlug.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUsbTypeCEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/UsbTypeC/UsbTypeCDxe/UsbTypeCDxe.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdTbtEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Tbt/TbtSmm/TbtSmm.inf
  $(PLATFORM_FEATURES_PATH)/Tbt/TbtDxe/TbtDxe.inf
!endif

#
# AdvancedFeaturesBegin
#
!if gSiPkgTokenSpaceGuid.PcdAtaEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Sata/SataController/SataController.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif

  $(PLATFORM_FEATURES_PATH)/Wdt/WdtAppDxe/WdtAppDxe.inf
#
# AdvancedFeaturesEnd
#

!if gSiPkgTokenSpaceGuid.PcdOverclockEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverClockInit/DxeOverClock.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverclockInterface.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverclockInterfaceACPI.inf
  $(PLATFORM_FEATURES_PATH)/OverClocking/OverclockInterface/OverClockSmiHandler.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdSmbiosEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Smbios/FirmwareVersionInfoDxe/FirmwareVersionInfoDxe.inf
  $(PLATFORM_FEATURES_PATH)/Smbios/SystemSlotInfoDxe/SystemSlotInfoDxe.inf
!endif

  $(PLATFORM_FEATURES_PATH)/Icc/IccPlatformDxe/IccPlatformDxe.inf # AdvancedFeaturesContent

!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
  BpCommonPkg/Csm/LegacyInterruptHookDxe/LegacyInterruptHook.inf
!if gPlatformModuleTokenSpaceGuid.PcdSmiVariableEnable == TRUE
  BpCommonPkg/Csm/LegacyBiosReverseThunkDxe/LegacyBiosReverseThunk.inf
  $(CLIENT_COMMON_PACKAGE)/Override/BpCommonPkg/Universal/VariableSmi/VariableSmiSmm.inf
  $(CLIENT_COMMON_PACKAGE)/Override/BpCommonPkg/Csm/VariableSmiInt15Dxe/VariableSmiInt15Dxe.inf
  $(CLIENT_COMMON_PACKAGE)/Override/BpCommonPkg/Universal/VariableSmi/VariableSmiExportHii.inf
!endif
!if gPlatformModuleTokenSpaceGuid.PcdIgdIntHookEnable == TRUE
  $(PLATFORM_PACKAGE)/Csm/GfxInt15/GfxInt15Legacy.inf
!endif
!endif

!if gSiPkgTokenSpaceGuid.PcdAmtEnable == TRUE
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable != FALSE
  $(PLATFORM_FEATURES_PATH)/Amt/AmtInt16/AmtInt16.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AmtInt16/AmtInt16Csm.inf
!endif
  $(PLATFORM_FEATURES_PATH)/Amt/AmtPetAlertDxe/AmtPetAlertDxe.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AmtSetupDxe/AmtSetupDxe.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AsfTable/AsfTable.inf
  $(PLATFORM_FEATURES_PATH)/Amt/AmtWrapperDxe/AmtWrapperDxe.inf {
    <LibraryClasses>
!if gSiPkgTokenSpaceGuid.PcdSiCsmEnable == TRUE
      NULL|IntelFrameworkModulePkg/Library/LegacyBootManagerLib/LegacyBootManagerLib.inf
!endif
  }
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Sio/NationalPC8374LDxe/NationalPC8374L.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
  $(CLIENT_COMMON_PACKAGE)/Sio/SmscLpc100xDxe/LpcSmsc100x.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Sio/HitachiH8s2113Dxe/HitachiH8s2113Dxe.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
  $(CLIENT_COMMON_PACKAGE)/Sio/WinbondWpcn381uDxe/WinbondWpcn381u.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }

!if gPlatformModuleTokenSpaceGuid.PcdEmbeddedEnable == TRUE
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Sio/NuvotonNct6776fDxe/NuvotonNct6776f.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
  $(PLATFORM_PACKAGE)/Override/$(CLIENT_COMMON_PACKAGE)/Sio/Nct6776fHwMonDxe/Nct6776fHwMon.inf {
    <LibraryClasses>
      PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif

!endif

!if gPlatformModuleTokenSpaceGuid.PcdBootTimeEnable == TRUE
  $(CLIENT_COMMON_PACKAGE)/Responsiveness/BootTime/BootTimeDxe.inf
!endif

# Do not comment this, because we need it at prebuild.
  #ACP Setup
!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
  $(PLATFORM_PACKAGE)/Setup/Setup.inf {
  <LibraryClasses>
     NULL|SecurityPkg/Library/HashInstanceLibSha256/HashInstanceLibSha256.inf
!if gPlatformModuleTokenSpaceGuid.PcdAcpiDebugFeatureEnable == TRUE
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DACPI_DEBUG_FLAG
      *_*_X64_VFRPP_FLAGS   = -DACPI_DEBUG_FLAG
      *_*_X64_APP_FLAGS     = -DACPI_DEBUG_FLAG
      *_*_X64_PP_FLAGS      = -DACPI_DEBUG_FLAG
!endif
!if gPlatformModuleTokenSpaceGuid.PcdHpetEnable == TRUE
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DHPET_SUPPORT
      *_*_X64_VFRPP_FLAGS   = -DHPET_SUPPORT
      *_*_X64_APP_FLAGS     = -DHPET_SUPPORT
      *_*_X64_PP_FLAGS      = -DHPET_SUPPORT
!endif
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_VFRPP_FLAGS   = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_APP_FLAGS     = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_PP_FLAGS      = -DRTCWakeup_SUPPORT_FLAG
!if gPlatformModuleTokenSpaceGuid.PcdVirtualKeyboardEnable == TRUE
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DVIRTUAL_KEYBOARD_ENABLE_FLAG
      *_*_X64_VFRPP_FLAGS   = -DVIRTUAL_KEYBOARD_ENABLE_FLAG
      *_*_X64_APP_FLAGS     = -DVIRTUAL_KEYBOARD_ENABLE_FLAG
      *_*_X64_PP_FLAGS      = -DVIRTUAL_KEYBOARD_ENABLE_FLAG
!endif
  }
!else
  $(PLATFORM_PACKAGE)/Setup/SetupDummy.inf {
!if gPlatformModuleTokenSpaceGuid.PcdHpetEnable == TRUE
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DHPET_SUPPORT
      *_*_X64_VFRPP_FLAGS   = -DHPET_SUPPORT
      *_*_X64_APP_FLAGS     = -DHPET_SUPPORT
      *_*_X64_PP_FLAGS      = -DHPET_SUPPORT
!endif
    <BuildOptions>
      *_*_X64_CC_FLAGS      = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_VFRPP_FLAGS   = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_APP_FLAGS     = -DRTCWakeup_SUPPORT_FLAG
      *_*_X64_PP_FLAGS      = -DRTCWakeup_SUPPORT_FLAG
  }
!endif

  #
  # Performance Application
  #
!if gPlatformModuleTokenSpaceGuid.PcdPerformanceEnable == TRUE
  PerformancePkg/Dp_App/Dp.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdMinTreeEnable == FALSE
!if gPlatformModuleTokenSpaceGuid.PcdEcEnable == TRUE
  $(PLATFORM_PACKAGE)/EC/EC.inf
!endif
!endif


!if gPlatformModuleTokenSpaceGuid.PcdGopOverrideDriverEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Gop/GopOverrideDriver/GopOverrideDriver.inf
!endif

!if gPlatformModuleTokenSpaceGuid.PcdIntelGopEnable == TRUE
  $(PLATFORM_PACKAGE)/GopDebugDxe/GopDebugDxe.inf
!endif

!if gSiPkgTokenSpaceGuid.PcdS3Enable == TRUE
  MdeModulePkg/Universal/LockBox/SmmLockBox/SmmLockBox.inf
  UefiCpuPkg/PiSmmCommunication/PiSmmCommunicationSmm.inf
!endif

MdeModulePkg/Universal/Variable/EmuRuntimeDxe/EmuVariableRuntimeDxe.inf

$(PLATFORM_FEATURES_PATH)/Acpi/AcpiTables/SsdtIrmt/IrmtAcpiTables.inf  # AdvancedFeaturesContent


!if gPlatformModuleTokenSpaceGuid.PcdCryptoEnable == TRUE
  BpCommonPkg/Universal/HashDxeCrypto/HashDxeCrypto.inf # AdvancedFeaturesContent
  SecurityPkg/RandomNumberGenerator/RngDxe/RngDxe.inf {
    <LibraryClasses>
      RngLib|MdePkg/Library/BaseRngLib/BaseRngLib.inf
  }
!endif

  MdeModulePkg/Application/MemoryProfileInfo/MemoryProfileInfo.inf

!if gPlatformModuleTokenSpaceGuid.PcdUefiShellBuildSource == TRUE
  ShellPkg/Application/Shell/Shell.inf {
    <LibraryClasses>
      NULL|ShellPkg/Library/UefiShellLevel2CommandsLib/UefiShellLevel2CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellLevel1CommandsLib/UefiShellLevel1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellLevel3CommandsLib/UefiShellLevel3CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellDriver1CommandsLib/UefiShellDriver1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellInstall1CommandsLib/UefiShellInstall1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellDebug1CommandsLib/UefiShellDebug1CommandsLib.inf
      NULL|ShellPkg/Library/UefiShellNetwork1CommandsLib/UefiShellNetwork1CommandsLib.inf
      NULL|ShellPkg/Library/UefiDpLib/UefiDpLib.inf

    <PcdsFixedAtBuild>
      gEfiShellPkgTokenSpaceGuid.PcdShellLibAutoInitialize|FALSE
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdUsbFnEnable == TRUE
#
# UsbDeviceMode XDCI
#
  $(PLATFORM_FEATURES_PATH)/Usb/UsbDeviceDxe/UsbDeviceDxe.inf {
  <LibraryClasses>
    PcdLib|MdePkg/Library/DxePcdLib/DxePcdLib.inf
  }
!endif

!if gPlatformModuleTokenSpaceGuid.PcdRstOneClickEnable == TRUE
  $(PLATFORM_FEATURES_PATH)/Rst/RstOneClickEnable/RstOneClickEnable.inf
!endif

!include $(PLATFORM_PACKAGE)/Board/DxeBoardInit.dsc  # AdvancedFeaturesContent

!include $(PLATFORM_SI_PACKAGE)/SiPkgBuildOption.dsc
!include $(PLATFORM_PACKAGE)/PlatformPkgBuildOption.dsc

$(PLATFORM_PACKAGE)/Platform/SmmConfidentialMem/SmmConfidentialMem.inf  # AdvancedFeaturesContent