# @file
# 
# @copyright
#  INTEL CONFIDENTIAL
#  Copyright 2016 Intel Corporation.
#
#  The source code contained or described herein and all documents related to the
#  source code ("Material") are owned by Intel Corporation or its suppliers or
#  licensors. Title to the Material remains with Intel Corporation or its suppliers
#  and licensors. The Material may contain trade secrets and proprietary and
#  confidential information of Intel Corporation and its suppliers and licensors,
#  and is protected by worldwide copyright and trade secret laws and treaty
#  provisions. No part of the Material may be used, copied, reproduced, modified,
#  published, uploaded, posted, transmitted, distributed, or disclosed in any way
#  without Intel's prior express written permission.
#
#  No license under any patent, copyright, trade secret or other intellectual
#  property right is granted to or conferred upon you by disclosure or delivery
#  of the Materials, either expressly, by implication, inducement, estoppel or
#  otherwise. Any license under such intellectual property rights must be
#  express and approved by Intel in writing.
#
#  Unless otherwise agreed by Intel in writing, you may not remove or alter
#  this notice or any other notice embedded in Materials by Intel or
#  Intel's suppliers or licensors in any way.
#
#  This file contains a 'Sample Driver' and is licensed as such under the terms
#  of your license agreement with Intel or your vendor. This file may be modified
#  by the user, subject to the additional terms of the license agreement.
#
# @par Specification Reference:
#

if [ "$0" != "$PLATFORM_PACKAGE/postbuild.sh" ]; then
  echo "!!! ERROR !!! This postbuild.sh must run under workspace root using $PLATFORM_PACKAGE/postbuild.sh !!!"
  exit 1
fi

grep D1E59F50-E8C3-4545-BF61-11F002233C97 $BUILD_DIR/FV/FVRECOVERY.inf > /dev/null
if [ $? -eq 0 ]; then
  CMD=`winepath -w $WORKSPACE/$CLIENT_COMMON_PACKAGE/Tools/Stafixup/Stafixup.exe`
  CMD+=" D1E59F50-E8C3-4545-BF61-11F002233C97 "
  CMD+=`winepath -w $WORKSPACE/$BUILD_DIR/FV/CLIENTBIOS.fd`
  CMD+=" "
  CMD+=`winepath -w $WORKSPACE/$PLATFORM_PACKAGE/Apfixup.txt`
  CMD+=" 0x20018"
  wine $CMD
  ret=$?
  if [ $ret -ne 0 ]; then
    exit $ret
  fi
fi

#
# Run FCE tool to write default setup variable to FD image
#
mv $BUILD_DIR/FV/CLIENTBIOS.fd $BUILD_DIR/FV/ClientBios.NoSetup.fd
cat $BUILD_DIR/FV/SETUP_DATA.Fv $BUILD_DIR/FV/ClientBios.NoSetup.fd > $BUILD_DIR/FV/CLIENT_SETUP.NoSetup.fd
# UQI 0006 005C 0078 0030 0034 0039 0046 is for PlatId question prompt (STR_PLATID_PROMPT) UQI string value.
# First 0006 is the length of string; Next six byte values are mapped to STR_PLATID_PROMPT string value (\x049F) defined in $PLATFORM_PACKAGE/Setup/UqiList.uni.
CMD=$(winepath -w $WORKSPACE/$BP_COMMON_PACKAGE/Tools/FCE/FCE.exe)
CMD+=" read -i "
CMD+=$(winepath -w $BUILD_DIR/FV/CLIENT_SETUP.NoSetup.fd)
CMD+=" 0006 005C 0078 0030 0034 0039 0046 > "
CMD+=$(winepath -w $BUILD_DIR/FV/ClientBios.fd.config)
$WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh $CMD
ret=$?
if [ $ret -ne 0 ]; then
  exit $ret
fi

CMD=$(winepath -w $WORKSPACE/$BP_COMMON_PACKAGE/Tools/FCE/FCE.exe)
CMD+=" update -i "
CMD+=$(winepath -w $BUILD_DIR/FV/CLIENT_SETUP.NoSetup.fd)
CMD+=" -s "
CMD+=$(winepath -w $BUILD_DIR/FV/ClientBios.fd.config)
CMD+=" -o "
CMD+=$(winepath -w $BUILD_DIR/FV/CLIENT_SETUP.fd)
CMD+=" -g B73FE497-B92E-416e-8326-45AD0D270091 -a"
$WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh $CMD
ret=$?
if [ $ret -ne 0 ]; then
  exit $ret
fi

Split -f $BUILD_DIR/FV/CLIENT_SETUP.fd -s 0x100000
ret=$?
if [ $ret -ne 0 ]; then
  exit $ret
fi

mv -f $BUILD_DIR/FV/CLIENT_SETUP.fd2 $BUILD_DIR/FV/ClientBios_POST.fd
rm $BUILD_DIR/FV/CLIENT_SETUP.fd1
rm $BUILD_DIR/FV/CLIENT_SETUP.fd
rm $BUILD_DIR/FV/CLIENT_SETUP.NoSetup.fd
rm $BUILD_DIR/FV/ClientBios.NoSetup.fd
cp -f $BUILD_DIR/FV/ClientBios_POST.fd $BUILD_DIR/FV/CLIENTBIOS.fd
if [ "$FSP_WRAPPER_BUILD" = "TRUE" ]; then
  if [ ! -d "$WORKSPACE/RomImages" ]; then
    mkdir -p $WORKSPACE/RomImages
  fi
  cp -f $BUILD_DIR/FV/CLIENTBIOS.fd $WORKSPACE/RomImages/KABYLAKEFSPWRAPPER.fd
fi

#@todo: Add Rvp7/8/10/11/16/SdlBrk
echo
echo --- Analyze ASL runtime behavior using acpiexec ---
cd $BUILD_X64
if [ ! -d "AslAnalyze" ]; then
  mkdir -p AslAnalyze
fi
if [ ! -d "AslAnalyze/Sds" ]; then
  mkdir -p AslAnalyze/Sds
fi
if [ ! -d "AslAnalyze/Rvp3" ]; then
  mkdir -p AslAnalyze/Rvp3
fi

cd AslAnalyze
find ../ -name '*.aml' -exec cp -f '{}' . \;
cd Rvp3
mv -f ../*Rvp3*.aml .
mv -f ../Dptf.aml .
cd ../Sds
mv -f ../*Sds*.aml .
cd ..

echo q | acpiexec -di *.aml Rvp3/*.aml > $WORKSPACE/AslAnalyzeRvp3.log
echo q | acpiexec -di *.aml Sds/*.aml > $WORKSPACE/AslAnalyzeSds.log

echo --- ASL analysis completed ---
echo
cd $WORKSPACE

#
# ---run TXTSX tool to generate FIT table---
#
    if [ -f "$PLATFORM_PACKAGE/Tools/ToolScripts/FitGen/postbuildFitGen.sh" ]; then
      ./$PLATFORM_PACKAGE/Tools/ToolScripts/FitGen/postbuildFitGen.sh
    fi
    if [ -f "$PLATFORM_PACKAGE/Tools/ToolScripts/BpmGen/postbuildBpmGen.bat" ]; then
      #export WINPWD=`winepath -w $WORKSPACE`
      $WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh `winepath -w $PLATFORM_PACKAGE/Tools/ToolScripts/BpmGen/postbuildBpmGen.bat`
      ret=$?
      #unset WINPWD
      if [ $ret -ne 0 ]; then
        exit $ret
      fi
      # Fix case differences if any
      if [ -f "$WORKSPACE/$BUILD_DIR/FV/ClientBios.fd" ]; then
        rm -f $WORKSPACE/$BUILD_DIR/FV/CLIENTBIOS.fd
        mv -f $WORKSPACE/$BUILD_DIR/FV/ClientBios.fd $WORKSPACE/$BUILD_DIR/FV/CLIENTBIOS.fd
      fi
    fi

#
# create RecoveryFvMain image (FVMAIN_COMPACT_RECOVERY.Fv) with emulation variable driver
#
cd $BUILD_DIR/FV
cp -f FVMAIN_COMPACT.Fv FVMAIN_COMPACT_RECOVERY.Fv


#
# Seems to only be useful for Capsule
#

# FMMT=`winepath -w $WORKSPACE/$BP_COMMON_PACKAGE/Tools/FMMT/FMMT.exe`
# 
# CMD="$FMMT"
# CMD+=" -d FVMAIN_COMPACT_RECOVERY.Fv FV1 VariableSmmRuntimeDxe FVMAIN_COMPACT_RECOVERY.Fv"
# $WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh $CMD
# ret=$?
# if [ $ret -ne 0 ]; then
#   exit $ret
# fi
# 
# CMD="$FMMT"
# CMD+=" -d FVMAIN_COMPACT_RECOVERY.Fv FV1 VariableSmm FVMAIN_COMPACT_RECOVERY.Fv"
# $WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh $CMD
# ret=$?
# if [ $ret -ne 0 ]; then
#   exit $ret
# fi
# 
# CMD="$FMMT"
# CMD+="-a FVMAIN_COMPACT_RECOVERY.Fv FV1 Ffs\02B01AD5-7E59-43e8-A6D8-238180613A5AEmuVariableRuntimeDxe\02B01AD5-7E59-43e8-A6D8-238180613A5A.ffs FVMAIN_COMPACT_RECOVERY.Fv"
# $WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh $CMD
# ret=$?
# if [ $ret -ne 0 ]; then
#   exit $ret
# fi

cd $WORKSPACE

if [ -f "$PLATFORM_PACKAGE/InternalOnly/ToolScripts/KeyEnroll/MsEnrollRestricted.bat" ]; then
  $WORKSPACE/$PLATFORM_PACKAGE/WineCmdWrapper.sh `winepath -w $PLATFORM_PACKAGE/InternalOnly/ToolScripts/KeyEnroll/MsEnrollRestricted.bat` `winepath -w $WORKSPACE/$BUILD_DIR`
  ret=$?
  if [ $ret -ne 0 ]; then
    exit $ret
  fi
fi

if [ -d $BUILD_X64/$PLATFORM_SI_PACKAGE/Pch ]; then
  $PLATFORM_PACKAGE/Tools/RomImage/SetupRomDirs.sh
  #@todo: BuildBGUP.bat
fi
