/** @file
  Internal header of the Setup Component.

  Macros defined here are used to specify VFR FormId or QuestionId in VFR and SD files.
  When VFR files are updated, new macros may be required to specify new FormId or QuestionId.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2010 - 2018 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#define MAIN_MAIN                                 4096
#define ADVANCED_MAIN                             4097
#define BOOT_MAIN                                 4098
#ifndef MINTREE_FLAG
#define BBS_ORDER_FORM                            4099
#define PCI_FORM_ID                               4104
#define WHEA_SETUP_KEY                            4105
#endif

#define ACPI_FORM_ID                              4106
#define SETUP_VOLATILE_DATA_ID                    4107
#define CPU_FEATURES_ID                           4108
#ifndef MINTREE_FLAG
#define CPU_FORM_ID                               4109
#define POWER_CONFIG_FORM_ID                      4110
#define CPU_POWER_CONFIG_FORM_ID                  4111
#define VID_OPTIONS_FORM_ID                       4112
#define CPU_TURBO_OPTIONS_FORM_ID                 4113
#define CPU_LOCK_OPTIONS_FORM_ID                  4114
#define PERFORMANCE_MENU_CONFIG_FORM_ID           4115
#define PROCESSOR_CONFIG_FORM_ID                  4116
#define KEY_RatioLimit1                           4117
#define KEY_RatioLimit2                           4118
#define KEY_RatioLimit3                           4119
#define KEY_RatioLimit4                           4120
//
// KEY_RatioLimit5, KEY_RatioLimit6, KEY_RatioLimit7, KEY_RatioLimit8 are located below, values 4257-4260
//
#define KEY_XeVoltage                             4121
#define OVERCLOCK_KEY                             4122
#define GT_CONFIG_FORM_ID                         4123
#define MEMORY_CONFIG_FORM_ID                     4124
#define KEY_MEMINFO                               4125
#define KEY_MEMINFO1                              4126
#define KEY_MEMINFO2                              4127
#define KEY_MEMINFO3                              4128
#define KEY_MEMINFO4                              4129
#define KEY_MEMINFO5                              4130
#define KEY_MEMINFO6                              4131
#define KEY_MEMINFO7                              4132
#define KEY_MEMINFO8                              4133
#define KEY_MEMINFO9                              4134
#define KEY_MEMINFO10                             4135
#define MEMORY_FORM_ID                            4136
#define NB_FORM_ID                                4137
#define IGFX_FORM_ID                              4138
#define COMMON_NB_OPTIONS_FORM_ID                 4139
#define PEG_FORM_ID                               4140
#define IGFX_LCD_FORM_ID                          4141
#define GT_POWER_CONFIG_FORM_ID                   4142
#define SB_FORM_ID                                4143
#define PCIE_DEVICE_OPTIONS_FORM_ID               4144
#define USB_OPTIONS_FORM_ID                       4145
#define SATA_DEVICE_OPTIONS_FORM_ID               4146
#define PCH_SATA_SFMS_OPTIONS_FORM_ID             4147
#define PCH_PCIE_LANE_EQ_FORM_ID                  4400
#define PCH_PCIERP1_OPTIONS_FORM_ID               4148
#define PCH_PCIERP2_OPTIONS_FORM_ID               4149
#define PCH_PCIERP3_OPTIONS_FORM_ID               4150
#define PCH_PCIERP4_OPTIONS_FORM_ID               4151
#define PCH_PCIERP5_OPTIONS_FORM_ID               4152
#define PCH_PCIERP6_OPTIONS_FORM_ID               4153
#define PCH_PCIERP7_OPTIONS_FORM_ID               4154
#define PCH_PCIERP8_OPTIONS_FORM_ID               4155
#define PCH_PCIERP9_OPTIONS_FORM_ID               5101
#define PCH_PCIERP10_OPTIONS_FORM_ID              5102
#define PCH_PCIERP11_OPTIONS_FORM_ID              5103
#define PCH_PCIERP12_OPTIONS_FORM_ID              5104
#define PCH_PCIERP13_OPTIONS_FORM_ID              5105
#define PCH_PCIERP14_OPTIONS_FORM_ID              5106
#define PCH_PCIERP15_OPTIONS_FORM_ID              5107
#define PCH_PCIERP16_OPTIONS_FORM_ID              5108
#define PCH_PCIERP17_OPTIONS_FORM_ID              5109
#define PCH_PCIERP18_OPTIONS_FORM_ID              5110
#define PCH_PCIERP19_OPTIONS_FORM_ID              5111
#define PCH_PCIERP20_OPTIONS_FORM_ID              5112
#define PCH_PCIERP21_OPTIONS_FORM_ID              5120
#define PCH_PCIERP22_OPTIONS_FORM_ID              5121
#define PCH_PCIERP23_OPTIONS_FORM_ID              5122
#define PCH_PCIERP24_OPTIONS_FORM_ID              5123
#define PCH_HDAUDIO_OPTIONS_FORM_ID               4156
#define PCH_HDAUDIO_ADVANCED_OPTIONS_FORM_ID      4159
#define PCH_HDAUDIO_FEATURES_FORM_ID              4160
#define SECURITY_OPTIONS_FORM_ID                  4157
#define ME_FORM_ID                                4158
#define ME_PTT_CONFIGURATION_FORM_ID              4161
#define ME_DEBUG_CONFIGURATION_FORM_ID            4162
#define ME_FW_UPGRADE_FORM_ID                     4163
#define KEY_FWU1                                  4164
#define KEY_FWU2                                  4165
#endif

#define THERMAL_CONFIG_FORM_ID                    4166
#define CPU_THERMAL_CONFIG_FORM_ID                4167
#define MEMORY_THERMAL_CONFIG_FORM_ID             4168
#define PLATFORM_THERMAL_CONFIG_FORM_ID           4169
#ifndef MINTREE_FLAG
#define POLICY_FORM_ID                            4170
#define KEY_TPM_GOTO                              4171
#define TPM_CONFIG_FORM_ID                        4172
#define KEY_TPM_ENABLE                            4173
#define KEY_TPM_DISABLE                           4174
#define KEY_TPM_ACTIVATE                          4175
#define KEY_TPM_DEACTIVATE                        4176
#define KEY_TPM_FORCE_CLEAR                       4177
#define KEY_TPM_MOR_ENABLE                        4178
#define KEY_TPM_MOR_DISABLE                       4179
#define USB_MASS_DEV_NUM_KEY                      4181
#define USB_SUPPORT_KEY                           4182
#define USB_CONFIG_FORM_ID                        4183
#define FDC_V_DATA_KEY                            4186
#define FDC_NV_DATA_KEY                           4187
#define COMA_V_DATA_KEY                           4188
#define COMA_NV_DATA_KEY                          4189
#define COMB_V_DATA_KEY                           4190
#define COMB_NV_DATA_KEY                          4191
#define LPT_V_DATA_KEY                            4192
#define LPT_NV_DATA_KEY                           4193
#define SIO_FORM_ID                               4194
#define SIO_FLOPPY_FORM_ID                        4195
#define SIO_SERIAL0_FORM_ID                       4196
#define SIO_SERIAL1_FORM_ID                       4197
#define SIO_PARALLEL_FORM_ID                      4198
#define NAT_FDC_V_DATA_KEY                        4199
#define NAT_FDC_NV_DATA_KEY                       4200
#define NAT_COMA_V_DATA_KEY                       4201
#define NAT_COMA_NV_DATA_KEY                      4202
#define NAT_LPT_V_DATA_KEY                        4203
#define NAT_LPT_NV_DATA_KEY                       4204
#define NAT_SIO_FORM_ID                           4205
#define NAT_FLOPPY_FORM_ID                        4206
#define NAT_SERIAL1_FORM_ID                       4207
#define NAT_PARALLEL_FORM_ID                      4208
#define WPCN381U_FDC_V_DATA_KEY                   4209
#define WPCN381U_FDC_NV_DATA_KEY                  4210
#define WPCN381U_COMA_V_DATA_KEY                  4211
#define WPCN381U_COMA_NV_DATA_KEY                 4212
#define WPCN381U_COMB_V_DATA_KEY                  4213
#define WPCN381U_COMB_NV_DATA_KEY                 4214
#define WPCN381U_LPT_V_DATA_KEY                   4215
#define WPCN381U_LPT_NV_DATA_KEY                  4216
#define WPCN381U_SIO_FORM_ID                      4217
#define WPCN381U_FLOPPY_FORM_ID                   4218
#define WPCN381U_SIO_SERIAL0_FORM_ID              4219
#define WPCN381U_SIO_SERIAL1_FORM_ID              4220
#define WPCN381U_PARALLEL_FORM_ID                 4221
#define HHM_FORM_ID                               4222
#define INTERNAL_TEMP_KEY                         4224
#define REMOTE_TEMP_KEY                           4225
#define FAN_1_KEY                                 4226
#define FAN_2_KEY                                 4227
#define FAN_3_KEY                                 4228
#define VOLT_1_5V_KEY                             4229
#define VOLT_3_3V_KEY                             4230
#define VOLT_5V_KEY                               4231
#define VOLT_12V_KEY                              4232
#define VOLT_CORE_KEY                             4233
#define CPU_FAN_KEY                               4236
#define PCH_DTS_TEMP_KEY                          4243
#define TS_ON_DIMM0_TEMP_KEY                      4245
#define TS_ON_DIMM1_TEMP_KEY                      4246
#define HDC_CONFIG_FORM_ID                        4256
#define KEY_RatioLimit5                           4257
#define KEY_RatioLimit6                           4258
#define KEY_RatioLimit7                           4259
#define KEY_RatioLimit8                           4260
#define KEY_VrPowerDeliveryChange                 4261

// ICC-related
// NOTE: in most keys, exact value doesn't matter. However, for some ICC keys,
// BIT0 distinguishes between CLOCK2- and CLOCK3-related options
#define ICC_SETUP_DATA_VAR                        5000
#define ICC_FORM_ID                               5001
#define KEY_ICC_STRINGS                           5002
#define KEY_ICC_PROFILE                           5003
#define KEY_ICC_LOCK                              5004
#define KEY_ICC_ADV_OPTIONS                       5005
#define KEY_ICC_SHOW_PROFILE                      5006
#define KEY_ICC_SHOW_CLOCK2                       5021
#define KEY_ICC_SHOW_CLOCK3                       5031
#define KEY_ICC_SHOW_FREQ2                        5022
#define KEY_ICC_SHOW_FREQ3                        5032
#define KEY_ICC_SHOW_SPREAD2                      5023
#define KEY_ICC_SHOW_SPREAD3                      5033
#define KEY_ICC_FREQ2                             5024
#define KEY_ICC_FREQ3                             5034
#define KEY_ICC_SPREAD2                           5025
#define KEY_ICC_SPREAD3                           5035
#define KEY_ICC_RATIO2                            5026
#define KEY_ICC_RATIO3                            5036

#define DEBUG_INTERFACE_FORM_ID                   4319
#define KEY_CpuRatioLimit                         4321
#define BOOTTIME_SETUP_KEY                        4322
#define KEY_TPM_SUPPORT                           4323
#define MEM_TRAINING_FORM_ID                      4324
#define MEM_TURNAROUNDTIMING_FORM_ID              4326
#define MEM_THERMMGT_FORM_ID                      4328
#define CPU_CTDP_OPTIONS_FORM_ID                  4329
#define CPU_CTDP_CUSTOM_OPTIONS_FORM_ID           4330
#define CSM_FORM_ID                               4334
#define SATA_DEVICE_KEY                           4335

#define RTD3_FORM_ID                              4339
#define AMT_FORM_ID                               4340
#define CIRA_CONFIGURATION_FORM_ID                4341
#define ASF_CONFIGURATION_FORM_ID                 4342
#define SECURE_ERASE_FORM_ID                      4351
#define MEBX_OEM_FLAGS_FORM_ID                    4343
#define MEBX_RESOLUTION_FORM_ID                   4344

#define GEN3_RP_PRESET_FORM_ID                    4345
#define GEN3_EP_PRESET_FORM_ID                    4346
#define GEN3_EP_HINT_FORM_ID                      4347
#endif
#define DPTF_FORM_ID                              4348
#ifndef MINTREE_FLAG
#define SERIAL_IO_OPTIONS_FORM_ID                 4349
#define ISCT_FORM_ID                              4350
#define RING_CONFIG_FORM_ID                       4353
#define UNCORE_CONFIG_FORM_ID                     4354
#define VCC_CONFIG_FORM_ID                        4355

#define GEN3_RX_CTLE_CONTROL_FORM_ID              4356
#define DRAM_POWER_METER_FORM_ID                  4357
#define MEMORY_THERMAL_REPORTING_FORM_ID          4358
#define MEMORY_RAPL_FORM_ID                       4359

#define ME_FEATURES_ID                            4360

#define KEY_TPM2_GOTO                             4362
#endif

#define SECURE_BOOT_VARIABLE_KEY                  4363
#ifndef MINTREE_FLAG
#define KEY_MEMINFO11                             4364
#define KEY_MEMINFO12                             4365
#define KEY_MEMINFO13                             4366
#define CPU_SMM_FEATURE_ID                        4367
#define CPU_SMM_CONFIG_FORM_ID                    4368
#define CPU_PL3_OPTIONS_FORM_ID                   4369
#define IGFX_IUER_FORM_ID                         4370

#define PCH_SERIAL_IO_DMA_FORM_ID                 4371
#define PCH_SERIAL_IO_I2C0_FORM_ID                4372
#define PCH_SERIAL_IO_I2C1_FORM_ID                4373
#define PCH_SERIAL_IO_SPI0_FORM_ID                4374
#define PCH_SERIAL_IO_SPI1_FORM_ID                4375
#define PCH_SERIAL_IO_UART0_FORM_ID               4376
#define PCH_SERIAL_IO_UART1_FORM_ID               4377
#define PCH_SERIAL_IO_SDIO_FORM_ID                4378
#define TBT_FORM_ID                               4379
#define KEY_RING_MAX_OC_RATIO_LIMIT               4380
#endif

#define KEY_LOW_POWER_S0_IDLE                     4381
#ifndef MINTREE_FLAG
#define TBT_COMPILE_TYPE                          1

#define KEY_CPU_OVER_CLOCKING                     4382
#define KEY_TPV_GFX_OVER_CLOCKING                 4383
#define KEY_MEMINFO14                             4385
#define KEY_MEMINFO15                             4386
#define KEY_TPM_DEVICE_SELECT                     4387
#define KEY_TCG2_CONFIGURATION                    4388 // TCG2 implementation
#endif

#define PLATFORM_SETTINGS_FORM_ID                 4389
#ifndef MINTREE_FLAG
#define DMI_GEN3_RP_PRESET_FORM_ID                4390
#define DMI_GEN3_EP_PRESET_FORM_ID                4391
#define DMI_GEN3_EP_HINT_FORM_ID                  4392
#define DMI_GEN3_RX_CTLE_CONTROL_FORM_ID          4393
#endif

#define PEP_FORM_ID                               4394
#ifndef MINTREE_FLAG
#define KEY_MEMINFO_PROFILE                       4395
#define KEY_CSM_STATE                             4396
#define KEY_MEMINFO16                             4397

#ifdef UP_SERVER_FLAG
#define MEMORY_TSOD_FORM_ID                       4417
#endif

#define GOP_FORM_ID                               5089
#define LFP_CONFIG_FORM_ID                        5090
#define DEVICE1_EFP1_FORM_ID                      5091
#define DEVICE2_EFP2_FORM_ID                      5092
#define DEVICE3_EFP3_FORM_ID                      5093
#define KEY_TBT_SUPPORT                           5094
#define KEY_MULTICONTROLLER_SUPPORT               5124
#define TBT_OSSELECT_FORM_ID                      5125
#define KEY_TBT_OS_SELECTOR                       5126
#define KEY_TBT_OS_CHANGE                         5127
#define KEY_TBT_HOSTROUTER                        5095
#define KEY_TBT_PCIE_SUPPORT                      5096
#define KEY_TBT_SELECTOR_SDS                      5097
#define KEY_TBT_SELECTOR_RVP3                     5098
#define KEY_TBT_SELECTOR_RVP7                     5113
#define KEY_TBT_NATIVE_OS_HOTPLUG                 5114
#define TBT_SECURITY_LEVEL_KEY                    5115
#define KEY_TBT_SELECTOR_DT_HALO                  5116
#define KEY_TBT_BOOT_ON                           5117
#define KEY_TBT_USB_ON                            5118
#define KEY_TBT_DETACHABLE_GFX_SUPPORT            5119
// SkyCam
#define SKYCAM_CIO2_OPTIONS_FORM_ID               5043
// Storage and Communication Subsystem (SCS)
#define SCS_OPTIONS_FORM_ID                       5044
// Integrated Sensor Hub (ISH)
#define ISH_OPTIONS_FORM_ID                       5046

//#ifdef PCH_PO_FLAG
// PCH POWERON option menu
#define PCH_PWRON_OPTIONS_FORM_ID                 5045
//#endif

// PCH TraceHub Options Menu
#define PCH_TRACE_HUB_OPTIONS_FORM_ID             5053

#define KEY_EpochChange                           5100
#define KEY_SgxEpoch1                             5099
#define KEY_SgxChange                             5068

// PCH Thermal Throttling Options Menu
#define PCH_THERMAL_THROTTLING_OPTIONS_FORM_ID    5054

// CPU VR Config
#define CPU_VR_OPTIONS_FORM_ID                    5047
#define CPU_SA_VR_OPTIONS_FORM_ID                 5048
#define CPU_IA_VR_OPTIONS_FORM_ID                 5049
#define CPU_ACOUSTIC_NOISE_FORM_ID                5050
#define CPU_GTUS_VR_OPTIONS_FORM_ID               5051
#define CPU_GTS_VR_OPTIONS_FORM_ID                5052

#define CPU_SETUP_VOLATILE_DATA_ID                5053
#define THERMAL_SENSOR_1_KEY                      5054
#define THERMAL_SENSOR_2_KEY                      5055
#define THERMAL_SENSOR_3_KEY                      5056
#define THERMAL_SENSOR_4_KEY                      5057
#define THERMAL_SENSOR_5_KEY                      5058
#define THERMAL_SENSOR_6_KEY                      5059
#define THERMAL_SENSOR_7_KEY                      5060
#define THERMAL_SENSOR_8_KEY                      5061

#define THERMAL_THERMISTOR_1_KEY                  5062
#define THERMAL_THERMISTOR_2_KEY                  5063
#define THERMAL_THERMISTOR_3_KEY                  5064
#define THERMAL_THERMISTOR_4_KEY                  5065
#define THERMAL_THERMISTOR_5_KEY                  5066
#define THERMAL_THERMISTOR_6_KEY                  5067

// PCH FW-Configuration Menu
#define MNG_STATE_KEY                             5069
#define NFC_STATE_KEY                             5070
#endif

// Platform Information Menu
#define STM_REV_KEY                               5072
#ifndef MINTREE_FLAG
// Intel RealSense Camera settings
#define REALSENSE_3D_CAMERA_SETTINGS_FORM_ID      5073
// End

// For SIO NCT6776F.
#define NCT_HWMON_FORM_ID                         5400
#define NCT_HWMON_CPU_TEMP_KEY                    5401
#define NCT_HWMON_CPU_FAN_KEY                     5402
#define NCT_HWMON_SYS_TEMP_KEY                    5403
#define NCT_HWMON_SYS_FAN_KEY                     5404
#define NCT_HWMON_AUX_TEMP_KEY                    5405
#define NCT_HWMON_AUX_FAN_KEY                     5406
#define NCT_HWMON_CPU_VCORE_KEY                   5407
#define NCT_HWMON_3VCC_KEY                        5408
#define NCT_HWMON_AVCC_KEY                        5409
#define NCT_HWMON_VIN0_KEY                        5410
#define NCT_HWMON_VIN1_KEY                        5411
#define NCT_HWMON_VIN2_KEY                        5412
#define NCT_HWMON_VIN3_KEY                        5413
// End of SIO NCT6776F.
#endif

#define PLL_TRIM_CONFIG_FORM_ID                   5414
#ifndef MINTREE_FLAG
#define KEY_RING_MIN_OC_RATIO_LIMIT               5200
#define KEY_CORE_MAX_OC_RATIO_LIMIT               5201
#endif

#define KEY_TBT_VTD_SECURITY_ID                   5420
#ifndef MINTREE_FLAG
#define KEY_WIFI_POWER_LIMIT                      5421
#endif

#ifndef AUTO_ID
#define AUTO_ID(x) x
#endif
