#!/bin/bash

# @file
# 
# @copyright
#  Copyright (c) 2016 Intel Corporation. All rights reserved
#  This software and associated documentation (if any) is furnished
#  under a license and may only be used or copied in accordance
#  with the terms of the license. Except as permitted by the
#  license, no part of this software or documentation may be
#  reproduced, stored in a retrieval system, or transmitted in any
#  form or by any means without the express written consent of
#  Intel Corporation.
#  This file contains a 'Sample Driver' and is licensed as such
#  under the terms of your license agreement with Intel or your
#  vendor. This file may be modified by the user, subject to
#  the additional terms of the license agreement.
# 
# @par Specification Reference:
#

#
# Prepare Skylake tree for building on UNIX.  This only needs to be run once.
#

function ConvertLineEndings {
  sed s/$'\r'$// < $1 > line-ending-conversion-temp.txt
  cat line-ending-conversion-temp.txt > $1
  rm -f line-ending-conversion-temp.txt
}

function PrepScript {
  ConvertLineEndings $1
  chmod +x $1
}

PrepScript ../edksetup.sh
ConvertLineEndings ../BaseTools/BuildEnv
PrepScript ./buildKbl.sh
PrepScript ./prebuild.sh
PrepScript ./pribuild.sh
PrepScript ./postbuild.sh
PrepScript ./FixAceGcc.py
PrepScript ./Tools/RomImage/SetupRomDirs.sh
PrepScript ./Tools/RomImage/BuildRomImages/BuildRomImages.py
PrepScript ./Tools/ToolScripts/SignFv/SignFvPlatform
PrepScript ./Tools/ToolScripts/FitGen/postbuildFitGen.sh
PrepScript ./GenNvsTableInternalOnly.sh
PrepScript ./WineCmdWrapper.sh
for f in ../BaseTools/BinWrappers/PosixLike/*; do
  PrepScript $f
done
cd ../BaseTools
make
cd ../KabylakePlatSamplePkg
