/** @file
  Create the AcpiGlobalVariable variable for other modules usage
  to maintain the platform compatibility.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include "AcpiGlobalVariable.h"


/**
  Allocate MemoryType below 4G memory address.

  @param[in]  MemoryType   Indicate the memory type to be allocated.
  @param[in]  Size         Size of memory to allocate.
  @param[out] Buffer       Allocated address for output.

  @retval     EFI_SUCCESS  Memory successfully allocated.
  @retval     Other        Other errors occur.
**/
EFI_STATUS
AllocateMemoryBelow4G (
  IN   EFI_MEMORY_TYPE MemoryType,
  IN   UINTN           Size,
  OUT  VOID            **Buffer
  )
{
  UINTN                 Pages;
  EFI_PHYSICAL_ADDRESS  Address;
  EFI_STATUS            Status;

  Pages = EFI_SIZE_TO_PAGES (Size);

  Address = 0xffffffff;
  Status  = gBS->AllocatePages (
                   AllocateMaxAddress,
                   MemoryType,
                   Pages,
                   &Address
                   );
  if (Status != EFI_SUCCESS) {
    return Status;
  }

  *Buffer = (VOID *) (UINTN) Address;

  if (Address != 0) {
    return EFI_SUCCESS;
  } else {
    return EFI_OUT_OF_RESOURCES;
  }
}


/**
  Driver entry point.

  @param[in] ImageHandle  Handle of driver image.
  @param[in] SystemTable  Pointer to system table.

  @retval    EFI_SUCCESS  Entrypoint successfully executed.
  @retval    Others       Fail to execute entrypoint.
**/
EFI_STATUS
EFIAPI
AcpiGlobalVariableEntryPoint (
  IN EFI_HANDLE                         ImageHandle,
  IN EFI_SYSTEM_TABLE                   *SystemTable
  )
{
  EFI_STATUS                            Status;
  ACPI_VARIABLE_SET_COMPATIBILITY       *AcpiVariableSet;
  UINTN                                 AcpiVariableSetAddr;

  DEBUG ((DEBUG_INFO, "AcpiGlobalVariableEntryPoint Start\n"));

  Status = AllocateMemoryBelow4G (EfiACPIMemoryNVS, sizeof (ACPI_VARIABLE_SET_COMPATIBILITY), &AcpiVariableSet);
  ASSERT_EFI_ERROR (Status);

  AcpiVariableSetAddr = (UINTN) AcpiVariableSet;
  Status = gRT->SetVariable (
                  ACPI_GLOBAL_VARIABLE,
                  &gEfiAcpiVariableCompatiblityGuid,
                  EFI_VARIABLE_BOOTSERVICE_ACCESS | EFI_VARIABLE_NON_VOLATILE,
                  sizeof (UINTN),
                  &AcpiVariableSetAddr
                  );
  ASSERT_EFI_ERROR(Status);

  return EFI_SUCCESS;
}
