/** @file
  Esrt driver definitions.

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2012 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _DXE_ESRT_H_
#define _DXE_ESRT_H_

#include <PiDxe.h>
#include <Library/DebugLib.h>
#include <Library/UefiDriverEntryPoint.h>
#include <Library/BaseLib.h>
#include <Library/UefiLib.h>
#include <Library/DevicePathLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/UefiRuntimeServicesTableLib.h>
#include <Library/PcdLib.h>
#include <Guid/SystemResourceTable.h>
extern EFI_GUID gEfiSystemResourceTableGuid;
#include <Protocol/Esrt.h>

#include <PlatformInfo.h>

extern EFI_GUID gSysFwSklSdsGuid;
extern EFI_GUID gSysFwRvp3Guid;
extern EFI_GUID gSysFwRvp8Guid;
extern EFI_GUID gDevFwGuid;
extern EFI_GUID gDevFwEInkGuid;
extern EFI_GUID gFwEntryVariableGuid;

EFI_STATUS
EFIAPI
EsrtPopulateTable (
  VOID
  );

EFI_STATUS
EFIAPI
EsrtUpdateTableEntryByGuid(
    IN EFI_GUID FwEntryGuid,
    IN EFI_SYSTEM_RESOURCE_ENTRY *FwEntry
);

EFI_STATUS
EFIAPI
EsrtGetFwEntryByGuid(
    IN EFI_GUID FwEntryGuid,
    OUT EFI_SYSTEM_RESOURCE_ENTRY *FwEntry
);

#endif
