/*++
  This file contains a 'Sample Driver' and is licensed as such
  under the terms of your license agreement with Intel or your
  vendor.  This file may be modified by the user, subject to
  the additional terms of the license agreement
--*/
/** @file
  Register the INT1A 16bit wrapper binary.

Copyright (c) 1999 - 2011, Intel Corporation. All rights reserved.<BR>
This software and associated documentation (if any) is furnished
under a license and may only be used or copied in accordance
with the terms of the license. Except as permitted by such
license, no part of this software or documentation may be
reproduced, stored in a retrieval system, or transmitted in any
form or by any means without the express written consent of
Intel Corporation.

**/

#include <PiDxe.h>

#include <Library/DebugLib.h>
#include <Library/UefiDriverEntryPoint.h>
#include <Library/UefiBootServicesTableLib.h>
#include <Library/BaseLib.h>
#include <Library/DxeServicesLib.h>

#include <Protocol/LegacyInterruptHandler.h>
#include <Protocol/TcgLegacyInt1AReady.h>

EFI_GUID  mInt1ATcgFile = { 0xce20499f, 0x952, 0x4093, { 0xba, 0x8b, 0xce, 0x6a, 0xf3, 0x4, 0x5e, 0x55}};

EFI_LEGACY_INTERRUPT_HANDLER_PROTOCOL mInterruptHandler = {
  0x1A,
  NULL,
  0
};

/**
  Initialize TcgLegacyInstallInt1A. 

  @param ImageHandle   Pointer to the loaded image protocol for this driver
  @param SystemTable   Pointer to the EFI System Table

  @retval EFI_SUCCESS  The driver initializes correctly.
 
**/
EFI_STATUS
EFIAPI
TcgLegacyInstallInt1A (
  IN    EFI_HANDLE                  ImageHandle,
  IN    EFI_SYSTEM_TABLE            *SystemTable
  )
{
  EFI_STATUS                        Status;
  EFI_HANDLE                        Handle;
  TCG_LEGACY_INT1A_READY_PROTOCOL   *Int1AReady;

  Status = gBS->LocateProtocol (&gTcgLegacyInt1AReadyProtocolGuid, NULL, (VOID **) &Int1AReady);
  ASSERT_EFI_ERROR (Status);

  DEBUG ((EFI_D_ERROR, "Load TCG Int1A binary code ...\n"));
  Status = GetSectionFromFv (&mInt1ATcgFile, EFI_SECTION_RAW, 0, (VOID **) &mInterruptHandler.Handler, &mInterruptHandler.Length);
  ASSERT_EFI_ERROR (Status);
  ASSERT (*(UINT32 *) mInterruptHandler.Handler == SIGNATURE_32 ('$', 'F', 'I', 'X'));

  //
  // Update the SMI Command value
  //
  ASSERT (((UINT8 *) mInterruptHandler.Handler)[mInterruptHandler.Length-1] == '$');
  ((UINT8 *) mInterruptHandler.Handler)[mInterruptHandler.Length-1] = Int1AReady->SwSmiInputValue;


  Handle = NULL;
  Status = gBS->InstallMultipleProtocolInterfaces (
                  &Handle,
                  &gEfiLegacyInterruptHandlerProtocolGuid,  &mInterruptHandler,
                  NULL
                  );
  ASSERT_EFI_ERROR (Status);
  return EFI_SUCCESS;
}

