//
// This file contains 'Framework Code' and is licensed as such
// under the terms of your license agreement with Intel or your
// vendor.  This file may not be modified, except as allowed by
// additional terms of your license agreement.
//
/** @file
  CmosAccessLib implementation.

Copyright (c) 2016, Intel Corporation. All rights reserved.<BR>
This software and associated documentation (if any) is furnished
under a license and may only be used or copied in accordance
with the terms of the license. Except as permitted by such
license, no part of this software or documentation may be
reproduced, stored in a retrieval system, or transmitted in any
form or by any means without the express written consent of
Intel Corporation.

**/

#include <Base.h>

/**
  Return the entry for the specified address in entries returned
  from platform.

  @param [in] Address  The CMOS address to find.

  @return A pointer to CMOS_ENTRY for the specified address,
          or NULL if not found.
**/
CMOS_ENTRY *
CmosAccessLibLocateEntry (
  IN UINT8      Address
  )
{
  return NULL;
}

/**
  Test the attributes of the Entry and return ValueIfSet if test passes
  or !ValueIfSet if test fails. It returns DefaultValue if the Entry is
  NULL.

  @param [in] Address      The CMOS address.
  @param [in] Attributes   The attributes to test.
  @param [in] ValueIfSet   The value to return if test passes.
  @param [in] DefaultValue The value to return if Entry is NULL.
  @param [in] Entry        Pointer to entry.

  @retval ValueIfSet   If test passes.
  @retval !ValueIfSet  If test fails.
  @retval DefaultValue If the Entry is NULL.
**/
BOOLEAN
CmosAccessLibCheckAttribute (
  IN UINT8      Address,
  IN UINT8      Attributes,
  IN BOOLEAN    ValueIfSet,
  IN BOOLEAN    DefaultValue,
  IN CMOS_ENTRY *Entry        OPTIONAL
  )
{
  return DefaultValue;
}

/**
  Check if the CMOS address needs Checksum calculation.

  @param [in] Address CMOS address to be checked 
  @param [in] Entry   Pointer to entry.

  @retval TRUE       CMOS address needs Checksum calculation.
  @retval FALSE      CMOS address doesn't need Checksum calculation.
**/
BOOLEAN
CmosAccessLibNeedChecksum (
  IN UINT8       Address,
  IN CMOS_ENTRY  *Entry OPTIONAL
  )
{
  return FALSE;
}


/**
  Check if the CMOS address needs to fill default data.

  @param [in] Address CMOS address to be checked 
  @param [in] Entry   Pointer to entry.

  @retval TRUE       CMOS address need to fill default data.
  @retval FALSE      CMOS address doesn't need to fill default data.
**/
BOOLEAN
CmosAccessLibNeedFillDefault (
  IN UINT8       Address,
  IN CMOS_ENTRY  *Entry OPTIONAL
  )
{
  return FALSE;
}

/**
  Check if the CMOS address is accessible.

  @param [in] Address CMOS address to be checked.
  @param [in] Entry   Pointer to entry.

  @retval TRUE       CMOS address is accessible.
  @retval FALSE      CMOS address isn't accessible.
**/
BOOLEAN
CmosAccessLibIsAccessible (
  IN UINT8       Address,
  IN CMOS_ENTRY  *Entry OPTIONAL
  )
{
  return FALSE;
}

/**
  Return the CMOS location to store checksum.

  @param [out] Location Return the CMOS location to store the checksum.
**/
VOID
CmosAccessLibGetChecksumLocation (
  OUT CMOS_CHECKSUM_LOCATION_INFO *Location
  )
{
  return;
}

/**
  Calculate the sum of CMOS values who need checksum calculation.

  @param [in] Location The CMOS location to store the checksum.

  @return The sum.
**/
UINT16
CmosAccessLibCalculateSum (
  IN CMOS_CHECKSUM_LOCATION_INFO *Location
  )
{
  return (UINT16) 0;
}

/**
  Return the checksum value stored in CMOS.

  @param [in] Location The CMOS location to store the checksum.

  @return The checksum value.
**/
UINT16
CmosAccessLibReadChecksum (
  IN CMOS_CHECKSUM_LOCATION_INFO *Location
  ) 
{
  return (UINT16) 0;
}
 

/**
  Write the Checksum to appropriate address.

  @param [in] Location The CMOS location to store the checksum.
  @param [in] Checksum The checksum value.
**/
VOID
CmosAccessLibWriteChecksum (
  CMOS_CHECKSUM_LOCATION_INFO *Location,
  IN UINT16                   Checksum
  )
{
  return;
}

/**
  Read a byte value from a CMOS address.

  @param [in] Address   Location to read from CMOS

  @return The byte value read from the CMOS address.
**/
UINT8
EFIAPI
CmosRead8 (
  IN  UINT8 Address
  )
{
  return (UINT8) 0;
}

/**
  Write a byte value to a CMOS address.

  It's an internal function that doesn't update the checksum.

  @param [in] Address Location to write to CMOS.
  @param [in] Data    The byte value write to the CMOS address.
**/
VOID
CmosAccessLibICmosWrite8 (
  IN UINT8 Address,
  IN UINT8 Data
  )
{
  return;
}

/**
  Write a byte value to a CMOS address.

  @param [in] Address Location to write to CMOS.
  @param [in] Data    The byte value write to the CMOS address.
**/
VOID
EFIAPI
CmosWrite8 (
  IN UINT8 Address,
  IN UINT8 Data
  )
{
  return;
}

/**
  Read a word value from a CMOS address.

  @param [in] Address   Location to read from CMOS

  @return The word value read from the CMOS address.
**/
UINT16
EFIAPI
CmosRead16 (
  IN  UINT8  Address
  )
{
  return (UINT16) 0;
}

/**
  Write a word value to a CMOS address.

  @param [in] Address Location to write to CMOS.
  @param [in] Data    The word value write to the CMOS address.
**/
VOID
EFIAPI
CmosWrite16 (
  IN UINT8  Address,
  IN UINT16 Data
  )
{
  return;
}

/**
  Read a dword value from a CMOS address.

  @param [in] Address   Location to read from CMOS

  @return The dword value read from the CMOS address.
**/
UINT32
EFIAPI
CmosRead32 (
  IN  UINT8  Address
  )
{
  return (UINT32) 0;
}

/**
  Write a dword value to a CMOS address.

  @param [in] Address Location to write to CMOS.
  @param [in] Data    The dword value write to the CMOS address.
**/
VOID
EFIAPI
CmosWrite32 (
  IN UINT8  Address,
  IN UINT32 Data
  )
{
  return;
}


/**
  Initialize the CMOS.
  
  It initialize the CMOS area when Force is TRUE or the checksum is incorrect.

  @param[in]  Force  TRUE indicating initializing the CMOS area without checking the checksum.

  @retval TRUE  The CMOS is initialized to default value.
  @retval FALSE The CMOS isn't initialized to default value.
**/
BOOLEAN
EFIAPI
CmosInit ( 
  IN  BOOLEAN     Force
  )
{
  return TRUE;
}
