/** @file
This file contains doxygen commands definitions for creating
Platform override documentation

@copyright
Copyright (c) 2016 - 2019 Intel Corporation. All rights reserved
This software and associated documentation (if any) is furnished
under a license and may only be used or copied in accordance
with the terms of the license. Except as permitted by such
license, no part of this software or documentation may be
reproduced, stored in a retrieval system, or transmitted in any
form or by any means without the express written consent of
Intel Corporation.
This file contains an 'Sample Driver' and is
licensed for Intel CPUs and chipsets under the terms of your
license agreement with Intel or your vendor.  This file may
be modified by the user, subject to additional terms of the
license agreement
**/

/**
 @page royalparkplatformoverride

Royal Park Platform Override tags (RPPO-SKL-xxxx for Kabylake) document issues that a Platform team has resolved with an override of Royal Park.

The Active RPPO table lists every issue which is currently resolved with an override. It is a catalog of all such existing overrides.

The Retired RPPO table lists issues which previously required such overrides. It is purely historical as these overrides have all been deleted (are no longer needed).
<BR>
<CENTER>
<STRONG>Active RPPO-SKLs</STRONG>
<BR>in KabylakePlatSamplePkg/Override
</CENTER>

<table border="1" style="width:1200px">
<tr>
  <th>Tag</th>
  <th>Client HSD</th>
  <th>BP HSD</th>
  <th>Status / Planned EOL</th>
  <th>Description</th>
</tr>
  <tr> <td>RPPO-SKL-0002</td> <td>1205700453</td> <td></td>  <td></td>              <td>ASSERT if use third-party AHCI whose port number exceed 3.</td> </tr>
  <tr> <td>RPPO-SKL-0003</td> <td>1205953088</td> <td></td>  <td></td>              <td>AhciMode.c spend 10ms on each un-plugged port.</td> </tr>
  <tr> <td>RPPO-SKL-0004</td> <td>1206090050</td> <td></td>  <td></td>              <td>Marvell 9182 AHCI controller can't drive up in native UEFI mode.</td> </tr>
  <tr> <td>RPPO-SKL-0005</td> <td>1206114854</td> <td></td>  <td></td>              <td>DxeTscTimerLib function in ClientCommonPkg returns undefined value if called before DxeTscTimerLibConstructor is called.</td> </tr>
  <tr> <td>RPPO-SKL-0006</td> <td>1205664159</td> <td></td>  <td></td>              <td>AHCI Mode Only - Add Opal Password support in BIOS.</td> </tr>
  <tr> <td>RPPO-SKL-0007</td> <td>1206121337</td> <td></td>  <td></td>              <td>When Base EC is added into Capsule build the installation takes longer time than expected and Base EC is not upgraded.</td> </tr>
  <tr> <td>RPPO-SKL-0008</td> <td>1603966832</td> <td></td>  <td></td>              <td>SKL BIOS : "UEFI MISC device" not listed in BIOS/BBS menu after configuring RAID in RVP 8/10 Boards.</td> </tr>
  <tr> <td>RPPO-SKL-0009</td> <td></td>           <td></td>  <td></td>              <td>SKL BIOS : "Fix S3 performance measurement error.</td> </tr>
  <tr> <td>RPPO-SKL-0010</td> <td>1603981075</td> <td></td>  <td></td>              <td>IBV: RoyalPark potential issue feedback.</td> </tr>
  <tr> <td>RPPO-SKL-0011</td> <td>1205519623</td> <td></td>  <td></td>              <td>SIB's device may not work when x4 slot do not have device.</td> </tr>
  <tr> <td>RPPO-SKL-0012</td> <td>1206407602</td> <td></td>  <td></td>              <td>MOR bit update locking - Win10 VSM requirement.</td> </tr>
  <tr> <td>RPPO-SKL-0013</td> <td></td>           <td></td>  <td></td>              <td>Rsvd</td> </tr>
  <tr> <td>RPPO-SKL-0014</td> <td>1603984895</td> <td></td>  <td></td>              <td>SHA 256 support for the Crypto Agile Event log format.</td> </tr>
  <tr> <td>RPPO-SKL-0015</td> <td>1206352998</td> <td></td>  <td></td>              <td>NEWCENTURY_STS SMI causes hang in SKL Bios</td> </tr>
  <tr> <td>RPPO-SKL-0016</td> <td>1504008289</td> <td></td>  <td></td>              <td>Update BootScriptLib to prevent the security hole for SMM boot script between EndOfDxe and S3Callback.</td> </tr>
  <tr> <td>RPPO-SKL-0017</td> <td>1206248357</td> <td></td>  <td></td>              <td>CPU family adaption</td> </tr>
  <tr> <td>RPPO-SKL-0018</td> <td>4833405</td>    <td></td>  <td></td>              <td>Merge PiSmm CPU driver</td> </tr>
  <tr> <td>RPPO-SKL-0019</td> <td>3864878</td>    <td></td>  <td></td>              <td>SINIT: STM - add support for MSR-based CPU save state map</td> </tr>
  <tr> <td>RPPO-SKL-0020</td> <td>2278657</td>    <td></td>  <td></td>              <td>Add support for Intel(R) Processor Trace debug in SMM mode</td> </tr>
  <tr> <td>RPPO-SKL-0021</td> <td>1205652919</td> <td></td>  <td></td>              <td>Add SKL Desktop (CPUID: 0x506E0) CPUID checks</td> </tr>
  <tr> <td>RPPO-SKL-0022</td> <td>1205666125</td> <td></td>  <td></td>              <td>Fix KW scan issues in SKL Platform Pkg</td> </tr>
  <tr> <td>RPPO-SKL-0023</td> <td>1205662123</td> <td></td>  <td></td>              <td>Add option to enable/disable IED memory on SKL CRB Platforms</td> </tr>
  <tr> <td>RPPO-SKL-0024</td> <td>1504002308</td> <td></td>  <td></td>              <td>System hangs in CpuInitDxe if BIOS reports 4G-8G as system memory.</td> </tr>
  <tr> <td>RPPO-SKL-0025</td> <td>1504017093</td> <td></td>  <td></td>              <td>TBT BIOS: TBT on boot/USB on boot BIOS configuration should orthogonal to each other.</td> </tr>
  <tr> <td>RPPO-SKL-0026</td> <td>1404331317</td> <td></td>  <td></td>              <td>HSTI optimization platform driver is not present in SKL/KBL causing 600+ ms of extra post time</td> </tr>
  <tr> <td>RPPO-SKL-0027</td> <td>1404144519</td> <td></td>  <td></td>              <td>SKL BIOS: Add TPM2 provisioning support</td> </tr>
  <tr> <td>RPPO-SKL-0028</td> <td>1206609504</td> <td></td>  <td></td>              <td>Fix for Debug level setup option is no longer working after DebugConfigData changed to UEFI </td> </tr>
  <tr> <td>RPPO-SKL-0029</td> <td>1205572150</td> <td></td>  <td></td>              <td>Enhance efivarstore variables on being able to modify variable attributes.</td> </tr>
  <tr> <td>RPPO-SKL-0030</td> <td>1206750288</td> <td></td>  <td></td>              <td>L"Boot%04x" (lower case) is used everywhere in Intel Source(both in Platform RC Code & Royal Park code).</td> </tr>
  <tr> <td>RPPO-SKL-0031</td> <td>1504060917</td> <td></td>  <td></td>              <td>Move all interface files of Hsti to ClientSiliconPkg.</td> </tr>
  <tr> <td>RPPO-SKL-0032</td> <td>1206618408</td> <td></td>  <td></td>              <td>Implement Initial draft of FSP 2.0 "FSP Wrapper utilizes FSP2.0 functionality"</td> </tr>
  <tr> <td>RPPO-SKL-0034</td> <td>1207216224</td> <td></td>  <td></td>              <td>Unable to retrieve disk information Shell with external sata pci-e card.</td> </tr>
  <tr> <td>RPPO-KBL-0035</td> <td>1207231279</td> <td></td>  <td></td>              <td>Fix Gcc build error and align 2016 kabylake with BP_1.3.1.0</td> </tr>
  <tr> <td>RPPO-KBL-0036</td> <td>1206912046</td> <td></td>  <td></td>              <td>Consume SMBIOS Processor and Cache Info HOBs. Update to 2016 Kabylake stream from future update to RoyalPark.</td> </tr>
  <tr> <td>RPPO-KBL-0037</td> <td></td>           <td></td>  <td></td>              <td>Kabylake should use Gccbase.lds linkscripts</td> </tr>
  <tr> <td>RPPO-KBL-0038</td> <td>1207163253</td> <td></td>  <td></td>              <td>System boots to EFI after flashing new SPI image</td> </tr>
  <tr> <td>RPPO-KBL-0040</td> <td>1404582488</td> <td></td>  <td></td>              <td>TPM2_Startup return status does not reflect response code status</td> </tr>
  <tr> <td>RPPO-KBL-0041</td> <td>1304226421</td> <td></td>  <td></td>              <td>Intel Test Menu - PTT: Suppress TPM commands does not work and BIOS still sends TPM commands</td> </tr>
  <tr> <td>RPPO-KBL-0042</td> <td>1604055835</td> <td></td>  <td></td>              <td>[HLK]: WHCK:- TPM 2.0 UEFI Preboot Interface Test fails with "PCRExtendPerf Test"</td> </tr>
  <tr> <td>RPPO-KBL-0043</td> <td>1206371435</td> <td></td>  <td></td>              <td>Add GCC Support to Kabylake BIOS</td> </tr>
  <tr> <td>RPPO-KBL-0045</td> <td></td>           <td></td>  <td></td>              <td>1504005677:Enabling Performance measurement for FSP Binary - Publish FSP performance records through FPDT. Other tags used SIPO-KBL-0001, FSCO-0001</td> </tr>
  <tr> <td>RPPO-KBL-0046</td> <td>1604101044</td> <td></td>  <td></td>              <td>[1604101044] [Beta Req]KBL_Sx:  RVP7 [Corporate] SUT hang at PC 0036 while running reboot & hybrid S5 cycle[debug]</td> </tr>
  <tr> <td>RPPO-KBL-0047</td> <td>1604122881</td> <td></td>  <td></td>              <td>[1604122881] [KBL] KBL CPU Family Class to be added for PiSmmCpuDxeSmm module.</td> </tr>
  <tr> <td>RPPO-KBL-0048</td> <td>1504198634</td> <td></td>  <td></td>              <td>[1504198634] [KBL] [Adding UINT8 Revision field in all setup variable.</td> </tr>
  <tr> <td>RPPO-KBL-0049</td> <td>1207907806</td> <td></td>  <td></td>              <td>[1207907806] PCI ROM Priority under PCI Subsystem Settings in BIOS Setup doesn't work as expected with CSM always On.</td> </tr>
  <tr> <td>RPPO-KBL-0050</td> <td>1304163615</td> <td></td>  <td></td>              <td>[1304163615] KeyboardLock boot option is not working, during SOL session.</td> </tr>
  <tr> <td>RPPO-KBL-0051</td> <td>1804229434</td> <td></td>  <td></td>              <td>[OPAL] Not possible to skip password prompt by hitting Esc during platform boot</td> </tr>
  <tr> <td>RPPO-KBL-0052</td> <td>1304313839</td> <td></td>  <td></td>              <td>Platform hang in BIOS in s4/s5 when USB Device Tree is plugged to the rootport"</td> </tr>
  <tr> <td>RPPO-KBL-0053</td> <td>1404875981</td> <td></td>  <td></td>              <td>Feedback to RP impl for Pyrite Drive: ComId for Block SID authentication command</td> </tr>
  <tr> <td>RPPO-KBL-0054</td> <td>1404876007</td> <td></td>  <td></td>              <td>Feedback to RP impl for Pyrite Drive: GlobalLockingRangeKey is not supported by Pyrite</td> </tr>
  <tr> <td>RPPO-KBL-0055</td> <td>1604123893</td> <td></td>  <td></td>              <td>[1604123893] [KBL] Adding support for booting usb 3.1 gen2 device connected to XHCI 3.1 controller.</td> </tr>
  <tr> <td>RPPO-KBL-0056</td> <td>1304424795</td> <td></td>  <td></td>              <td>SKL BIOS: BIOS may leave TPM uninitialized on wake from S3. Impact: PlatformAuth will be default and PCRs can be compromised.</td> </tr>
  <tr> <td>RPPO-KBL-0057</td> <td>1504217444</td> <td></td>  <td></td>              <td>[1504217444] [KBL] Fix building error for enabling the "deprecated function Interface remove" flag.</td> </tr>
  <tr> <td>RPPO-KBL-0061</td> <td>1208430499</td> <td></td>  <td></td>              <td>Using wrong variable when attempting to check return value in SetupBrowserDxe/Expression.c</td> </tr>
  <tr> <td>RPPO-KBL-0063</td> <td>1208430499</td> <td></td>  <td></td>              <td>Support NX protections for Device Guard</td> </tr>
  <tr> <td>RPPO-KBL-0064</td> <td>1207743319</td> <td></td>  <td></td>              <td>Executing 'Continue' from BIOS screen fails on first attempt when triggered from Windows</td> </tr>
  <tr> <td>RPPO-KBL-0066</td> <td>1604162289</td> <td></td>  <td></td>              <td>KBL_Sx: System hang on postcode 009b with CATERROR during Reboot cycle. Requirment is to have 120 ms between XHCI HC resets.Requested to remove duplicate Resets.</td> </tr>
  <tr> <td>RPPO-KBL-0067</td> <td>1804339738</td> <td></td>  <td></td>              <td>[PCH BIOS CI] All platforms hang at PC 0055 after resume from S3.</td> </tr>
  <tr> <td>RPPO-KBL-0068</td> <td>1405234460</td> <td></td>  <td></td>              <td>Align with BP 1330 SecurityPkg and add Platform Overrides</td> </tr>
  <tr> <td>RPPO-KBL-0069</td> <td>1208882263</td> <td></td>  <td></td>              <td>ME HFSTS resgisters change based on power source and causes inconsistent TPM measurements.</td> </tr>
  <tr> <td>RPPO-KBL-0070</td> <td>1405287213</td> <td></td>  <td></td>              <td>PCR[1] value varies through every boot.</td> </tr>
  <tr> <td>RPPO-KBL-0072</td> <td>1604217500</td> <td></td>  <td></td>              <td>Bug check "CRITICAL PROCESS DIED"  observed after S3 exit in Pleasant Star ES1 & ES2  samples with only Opal2.0 BIOS Password enabled</td> </tr>
  <tr> <td>RPPO-KBL-0073</td> <td>1304649862</td> <td></td>  <td></td>              <td>PPI: GetPhysicalPresenceConfirmationStatus() is affecting GetPhysicalPresenceRequest()</td> </tr>
  <tr> <td>RPPO-KBL-0074</td> <td>1504343796</td> <td></td>  <td></td>              <td>[MinTree] Use Pei VBT table in OpRegion and eliminate Dxe GOP/VBT.</td> </tr>
  <tr> <td>RPPO-KBL-0076</td> <td>1209282496</td> <td></td>  <td></td>              <td>[1209282496] [BETA] KBX-BIOS:With PTT Enabled BIOS-Current TPM Device showing Unknown in TCG 2 Configuration Page</td> </tr>
  <tr> <td>RPPO-KBL-0078</td> <td></td>           <td></td>  <td></td>              <td>Fixed wrong variable used for debug message</td> </tr>
  <tr> <td>RPPO-KBL-0079</td> <td>1405619853</td> <td></td>  <td></td>              <td>[1405619853] Client BIOS launches 3rd party video OROM prior to gEfiEndofDxeEventGroupGuid event</td> </tr>
  <tr> <td>RPPO-KBL-0080</td> <td>1604281266</td> <td></td>  <td></td>              <td>[1604281266] KBL-R BIOS: System hangs at PC00A7 when CSM Control option set as "Always ON" in BIOS with Storage device (SSD/HDD/NGFF) connected.</td> </tr>
  <tr> <td>RPPO-KBL-0081</td> <td>1504458578</td> <td></td>  <td></td>              <td>[1504458578] Platform Klocwork issues in Weekly_85_00_95</td> </tr>
  <tr> <td>RPPO-KBL-0082</td> <td>1209705059</td> <td></td>  <td></td>              <td>[1209705059] [2017 KBL HaT]  Recommendation for TrEEPlatform</td> </tr>
  <tr> <td>RPPO-KBL-0083</td> <td>1604334659</td> <td></td>  <td></td>              <td>Bios Conf Tool Verification Failed for TPM devices</td> </tr>
  <tr> <td>RPPO-KBL-0084</td> <td>220512590</td>  <td></td>  <td></td>              <td>Preserve descriptors across call to PciGetBusRange</td> </tr>
  <tr> <td>RPPO-KBL-0085</td> <td>1209709218</td> <td></td>  <td></td>              <td>Strong Admin Password solution back ported from BP1410 to BP1342</td> </tr>
  <tr> <td>RPPO-KBL-0086</td> <td>1504621871</td> <td></td>  <td></td>              <td>SMBIOS Type 7 "Maximum Cache Size 2" and "Installed Cache Size 2"  are not equal to  is not equal to the corresponding field</td> </tr>
  <tr> <td>RPPO-KBL-0087</td> <td>1504665005</td> <td></td>  <td>BP 1.5.1.0</td>    <td>Core Device connection behavior is changed after defer Pci Expansion Rom enabled.</td> </tr>
  <tr> <td>RPPO-KBL-0088</td> <td>1604441125</td> <td></td>  <td></td>              <td>Sporadically SUT is not Booting to OS[HDD Lost] when User & Master password is enabled for Primary HDD when SATA mode set to RST Premium Mode</td> </tr>
  <tr> <td>RPPO-KBL-0089</td> <td>2201077367</td> <td></td>  <td></td>              <td>Avoid AuthVariable Timestamp Zeroing on APPEND_WRITE</td> </tr>
  <tr> <td>RPPO-KBL-0090</td> <td>2201838984</td> <td></td>  <td></td>              <td>Untested Memory Not Covered by SMM Protection</td> </tr>
  <tr> <td>RPPO-KBL-0091</td> <td>2201882860</td> <td></td>  <td></td>              <td>[KBL] FV Alignment in EDK2 Chain-of-Trust Bypass</td> </tr>
  <tr> <td>RPPO-KBL-0093</td> <td>2201839018</td> <td></td>  <td></td>              <td>[KBL] Potential TianoCompress overflow issues</td> </tr>
  <tr> <td>RPPO-KBL-0094</td> <td>1605318959</td> <td></td>  <td>BP 1.5.1.0</td>    <td>KBL-YR[AML]: [Security] Few Self Certification Tests are failing.</td> </tr>
  <tr> <td>RPPO-KBL-0095</td> <td>1605826442</td> <td></td>  <td>BP 1.5.1.0</td>    <td>AML-7W [BIOS][Regression]:BIOS skipping bootable USB Thumb drive</td> </tr>
  <tr> <td>RPPO-KBL-0096</td> <td>1606210485</td> <td></td>  <td>BP 1.5.1.0</td>    <td>KBL_R - Security : Unable to retreive UEFI variables via dmpstore command.</td> </tr>
  <tr> <td>RPPO-KBL-0097</td> <td>1605318959</td> <td>1375760</td> <td>BP 1.5.2.0</td> <td>[KBL] Meet the UEFI spec to pass the SCT test case "VariableServicesTest". </td> </tr>
  <tr> <td>RPPO-KBL-0098</td> <td>1605318959</td> <td>1375762</td> <td>EDK201903</td> <td>[KBL] Meet the UEFI spec to pass the SCT test case "DevicePathProcotols". </td> </tr>
  <tr> <td>RPPO-KBL-0099</td> <td></td> <td></td> <td></td>    <td>PLATFORM</td>  <td>Added SmmConfidentialMemLib.</td> </tr>
  </table>

<BR>
<CENTER>
<STRONG>Retired RPPOs</STRONG>
<BR>formerly in KabylakePlatSamplePkg/Override
</CENTER>

<table border="1" style="width:1200px">
<tr>
  <th>Tag</th>
  <th>Client HSD</th>
  <th>BP HSD</th>
  <th>Status / Planned EOL</th>
  <th>Description</th>
</tr>
  <tr> <td>RPPO-SKL-xxxx</td> <td></td>        <td></td>        <td></td>           <td></td> </tr>
  <tr> <td>RPPO-SKL-0001</td> <td>1205572150</td> <td></td>  <td></td>              <td>Blue Box Error Observed While Saving Restored Default Settings</td> </tr>
  <tr> <td>RPPO-SKL-0026</td> <td>1206666622</td> <td></td>  <td></td>              <td>Add ability to delay/skip HDD unlock in HddPasswordDxe module. Required for SecureErase using HDD password supplied thru WSMAN command. (Retired because of RPCO-0047)</td> </tr>
  <tr> <td>RPPO-SKL-0033</td> <td>1504083754</td> <td></td>  <td></td>              <td>Override FCE tools in KBL stream to resolve long delay during build process</td> </tr>
  <tr> <td>RPPO-KBL-0044</td> <td>1304182149</td> <td></td>  <td></td>              <td>[OPAL BIOS MENU] Toshiba NVMe Pyrite drive not listed in Opal BIOS Menu. (Retired because of RPPO-KBL-0051)</td> </tr>
  <tr> <td>RPPO-KBL-0058</td> <td>1208355757</td> <td></td>  <td></td>              <td>Build fails when setting gSiPkgTokenSpaceGuid.PcdSourceDebugEnable to TRUE</td> </tr>
  <tr> <td>RPPO-KBL-0060</td> <td>1504265129</td> <td></td>  <td></td>              <td>Replace InternalIsAddressInSmram with SmmIsBufferOutsideSmmValid in ClientCommonPkg</td> </tr>
  <tr> <td>RPPO-KBL-0062</td> <td>1208479218</td> <td></td>  <td>BP 1.3.4.0</td>    <td>Deprecate ClientCommonPkg BaseCmosAccessLib instance</td> </tr>
  <tr> <td>RPPO-KBL-0065</td> <td>1208702997</td> <td></td>  <td>BP 1.3.4.0</td>    <td>Remove macro RELEASE_MODE_DEBUG() and macro RELEASE_MODE_DIAGNOSTICS() usage. Remove the override when ClientCommonPkg version is updated.</td> </tr>
  <tr> <td>RPPO-KBL-0039</td> <td>1404582487</td> <td></td>  <td>BP 1.3.4.0</td>    <td>Should Zero out TPM Cmd/Rsp Buffer for TPM2 CommandLibs. Issue is fixed with BP core update</td> </tr>
  <tr> <td>RPPO-KBL-0071</td> <td>1405287213</td> <td></td>  <td>BP 1.3.4.1</td>    <td>[1405320712]S3_MEMORY_VARIABLE_NAME variable is used instead of ACPI_GLOBAL_VARIABLE variable which causes security issue.</td> </tr>
  <tr> <td>RPPO-KBL-0077</td> <td>1304650909</td> <td></td>  <td>BP 1.3.4.1</td>    <td>[1304650909] OS state not restored after 1st resume from S4</td> </tr>
  <tr> <td>RPPO-KBL-0075</td> <td>1304656872</td> <td></td>  <td>BP 1.3.4.1</td>    <td>KBL: At the first time of entering correct "Master Password", an error of "mismatch error" is received.</td> </tr>
  <tr> <td>RPPO-KBL-0077</td> <td>1209649441</td> <td></td>  <td>BP 1.3.4.2</td>    <td>[1209649441] RS2 HLK Requirement for Security: NoPPIClear must be set to TRUE or PPRequiredForClear must be set to FALSE</td> </tr>
</table>

**/


