/**@file

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2010 - 2016 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <SioSmsc1007Setup.h>
#include <SetupPrivate.h>
#include <SioSetup.h>

VOID
InitSioStrings (
  EFI_HII_HANDLE  HiiHandle,
  UINT16          Class
  )
{
  EFI_STATUS    Status;
  EFI_GUID      SioGuid = SIO_VAR_GUID;
  UINTN         Size;
  COMA_V_DATA   ComaData;
  COMB_V_DATA   CombData;

//------------------------------------
  Status = EFI_SUCCESS;
  if(Class == ADVANCED_FORM_SET_CLASS){
    Size = sizeof (COMA_V_DATA);
    ZeroMem (&ComaData, Size);
    Status = gRT->GetVariable (
                    L"PNP0501_0_VV",
                    &SioGuid,
                    NULL,
                    &Size,
                    &ComaData
                    );
    if (!EFI_ERROR (Status) && ComaData.ComImplemented != 0) {
      InitString (
        HiiHandle,
        STRING_TOKEN(STR_SERIAL0_CONFIG_VALUE),
        L"IO=%Xh; IRQ=%d;",
        ComaData.ComBase1,
        ComaData.ComIrq1
        );
    }
    Size = sizeof (COMB_V_DATA);
    ZeroMem (&CombData, Size);
    Status = gRT->GetVariable (
                    L"PNP0510_1_VV",
                    &SioGuid,
                    NULL,
                    &Size,
                    &CombData
                    );
    if (!EFI_ERROR (Status) && CombData.ComImplemented != 0) {
      InitString (
        HiiHandle,
        STRING_TOKEN(STR_SERIAL1_CONFIG_VALUE),
        L"IO=%Xh;%Xh;IRQ=%d;DMA=%d;",
        CombData.ComBase1,
        CombData.ComBase2,
        CombData.ComIrq1,
        CombData.ComDma1
        );
   }
  }
}
