/** @file
  This file contains HD Audio NHLT Configuration BLOBs

 @copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2017 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

//
// DMIC Configuration BLOBs
//
// DMIC Config 2 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo16BitFormatConfig[] =
{
  0x00000000, 0xffffff10, 0xffff1010, 0xffff0101, 0xffff1100, 0x00000003, 0x00000003, 0x00300003, 0x00300003, 0x00000003, 0x0000c001, 0x04000900, 0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b,
  0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3, 0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929,
  0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c, 0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6,
  0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1, 0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784,
  0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f, 0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25,
  0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc, 0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90,
  0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127, 0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265,
  0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e, 0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301,
  0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a, 0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507,
  0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3, 0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402,
  0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42, 0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8,
  0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1, 0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1,
  0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855, 0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703,
  0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a, 0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833,
  0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a, 0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605,
  0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad, 0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e,
  0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691, 0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4,
  0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df, 0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8, 0x0000c001, 0x04000900,
  0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b, 0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3,
  0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929, 0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c,
  0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6, 0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1,
  0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784, 0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f,
  0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25, 0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc,
  0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90, 0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127,
  0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265, 0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e,
  0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301, 0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a,
  0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507, 0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3,
  0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402, 0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42,
  0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8, 0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1,
  0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1, 0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855,
  0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703, 0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a,
  0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833, 0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a,
  0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605, 0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad,
  0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e, 0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691,
  0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4, 0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df,
  0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8
};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 DmicStereo16BitFormatConfigSize = sizeof (DmicStereo16BitFormatConfig);

// DMIC Config 2 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo32BitFormatConfig[] =
{
  0x00000000, 0xffffff10, 0xffff1010, 0xffff0101, 0xffff1100, 0x00000003, 0x00000003, 0x00380003, 0x00380003, 0x00000003, 0x0000c001, 0x04000900, 0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b,
  0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3, 0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929,
  0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c, 0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6,
  0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1, 0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784,
  0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f, 0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25,
  0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc, 0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90,
  0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127, 0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265,
  0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e, 0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301,
  0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a, 0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507,
  0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3, 0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402,
  0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42, 0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8,
  0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1, 0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1,
  0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855, 0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703,
  0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a, 0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833,
  0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a, 0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605,
  0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad, 0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e,
  0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691, 0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4,
  0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df, 0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8, 0x0000c001, 0x04000900,
  0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b, 0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3,
  0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929, 0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c,
  0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6, 0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1,
  0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784, 0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f,
  0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25, 0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc,
  0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90, 0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127,
  0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265, 0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e,
  0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301, 0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a,
  0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507, 0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3,
  0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402, 0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42,
  0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8, 0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1,
  0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1, 0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855,
  0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703, 0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a,
  0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833, 0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a,
  0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605, 0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad,
  0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e, 0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691,
  0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4, 0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df,
  0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8
};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 DmicStereo32BitFormatConfigSize = sizeof (DmicStereo32BitFormatConfig);

// DMIC Config 4 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad16BitFormatConfig[] =
{
  0x00000000, 0xffffff10, 0xffff1010, 0xffff0101, 0xffff1100, 0x00000003, 0x00000003, 0x00320003, 0x00320003, 0x00000003, 0x0000c001, 0x04000900, 0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b,
  0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3, 0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929,
  0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c, 0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6,
  0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1, 0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784,
  0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f, 0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25,
  0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc, 0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90,
  0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127, 0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265,
  0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e, 0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301,
  0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a, 0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507,
  0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3, 0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402,
  0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42, 0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8,
  0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1, 0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1,
  0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855, 0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703,
  0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a, 0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833,
  0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a, 0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605,
  0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad, 0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e,
  0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691, 0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4,
  0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df, 0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8, 0x0000c001, 0x04000900,
  0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b, 0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3,
  0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929, 0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c,
  0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6, 0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1,
  0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784, 0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f,
  0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25, 0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc,
  0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90, 0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127,
  0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265, 0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e,
  0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301, 0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a,
  0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507, 0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3,
  0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402, 0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42,
  0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8, 0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1,
  0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1, 0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855,
  0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703, 0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a,
  0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833, 0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a,
  0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605, 0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad,
  0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e, 0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691,
  0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4, 0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df,
  0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8
};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 DmicQuad16BitFormatConfigSize = sizeof (DmicQuad16BitFormatConfig);

// DMIC Config 4 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad32BitFormatConfig[] =
{
  0x00000000, 0xffffff10, 0xffff1010, 0xffff0101, 0xffff1100, 0x00000003, 0x00000003, 0x003a0003, 0x003a0003, 0x00000003, 0x0000c001, 0x04000900, 0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b,
  0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3, 0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929,
  0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c, 0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6,
  0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1, 0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784,
  0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f, 0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25,
  0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc, 0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90,
  0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127, 0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265,
  0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e, 0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301,
  0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a, 0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507,
  0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3, 0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402,
  0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42, 0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8,
  0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1, 0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1,
  0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855, 0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703,
  0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a, 0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833,
  0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a, 0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605,
  0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad, 0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e,
  0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691, 0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4,
  0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df, 0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8, 0x0000c001, 0x04000900,
  0x00000000, 0x00000803, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000402a0, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000e03b6, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000008, 0x000fffae, 0x000fff12, 0x000ffdfb, 0x000ffc61, 0x000ffa5b, 0x000ff82c, 0x000ff643, 0x000ff523, 0x000ff547, 0x000ff6f8, 0x000ffa29, 0x000ffe68, 0x000002e2, 0x0000068f, 0x00000875, 0x000007ef, 0x000004f3,
  0x00000028, 0x000ffad3, 0x000ff68a, 0x000ff4c1, 0x000ff651, 0x000ffb22, 0x00000211, 0x00000929, 0x00000e2c, 0x00000f3e, 0x00000b8e, 0x000003bb, 0x000ff9cb, 0x000ff0b0, 0x000feb71, 0x000fec2e, 0x000ff356, 0x000fff53, 0x00000cce, 0x0000179c,
  0x00001bf8, 0x000017d1, 0x00000b9d, 0x000ffa79, 0x000fe96d, 0x000fddf8, 0x000fdc53, 0x000fe5f6, 0x000ff8d5, 0x00000fbb, 0x000023a7, 0x00002def, 0x00002a6a, 0x00001905, 0x000ffe24, 0x000fe199, 0x000fcc68, 0x000fc5f7, 0x000fd18a, 0x000fece1,
  0x00001079, 0x00003199, 0x00004578, 0x000044bc, 0x00002e15, 0x0000071b, 0x000fdb08, 0x000fb784, 0x000fa877, 0x000fb41a, 0x000fd897, 0x00000c10, 0x00003f3b, 0x000061e1, 0x000067f6, 0x00004db0, 0x00001940, 0x000fd981, 0x000fa1ca, 0x000f841f,
  0x000f8b6b, 0x000fb7a8, 0x000ffd3a, 0x000047e6, 0x000080ac, 0x000094cf, 0x00007beb, 0x00003b25, 0x000fe44a, 0x000f90fe, 0x000f5b2e, 0x000f5512, 0x000f832c, 0x000fda2d, 0x000041a3, 0x00009ad1, 0x0000c9c2, 0x0000bdf2, 0x000077e2, 0x000009bc,
  0x000f92ab, 0x000f360f, 0x000f110c, 0x000f318c, 0x000f9165, 0x00001750, 0x00009d91, 0x0000fc90, 0x0001166e, 0x0000e025, 0x00006589, 0x000fc6c7, 0x000f2fea, 0x000eccac, 0x000ebbfa, 0x000f06a9, 0x000f9c25, 0x0000562c, 0x000102a9, 0x00017127,
  0x0001802c, 0x000126dd, 0x0000782b, 0x000f9ea6, 0x000ed1f0, 0x000e4885, 0x000e298b, 0x000e8265, 0x000f42a4, 0x00003f71, 0x00013d8c, 0x0001ff57, 0x0002537a, 0x0002209e, 0x00016b73, 0x000055ce, 0x000f1749, 0x000df142, 0x000d212b, 0x000cd43e,
  0x000d1f22, 0x000dfb0f, 0x000f488e, 0x0000d6d5, 0x00026dc5, 0x0003d844, 0x0004ecd5, 0x00059301, 0x0005c4ed, 0x00058d6f, 0x00050385, 0x0004448d, 0x00036e82, 0x00029b5d, 0x0001de2d, 0x00014211, 0x0000cac9, 0x0000765b, 0x00003f38, 0x00001e4a,
  0x00000c93, 0x0000043b, 0x000000f9, 0x000fffd6, 0x00000217, 0x0000025b, 0x00000383, 0x00000507, 0x000006e2, 0x00000916, 0x00000ba1, 0x00000e7b, 0x0000119a, 0x000014ec, 0x00001859, 0x00001bc7, 0x00001f15, 0x0000221d, 0x000024ba, 0x000026c3,
  0x00002810, 0x0000287e, 0x000027ec, 0x00002640, 0x0000236c, 0x00001f6a, 0x00001a40, 0x00001402, 0x00000cd3, 0x000004e2, 0x000ffc6b, 0x000ff3b7, 0x000feb17, 0x000fe2e2, 0x000fdb73, 0x000fd526, 0x000fd04f, 0x000fcd3a, 0x000fcc27, 0x000fcd42,
  0x000fd0a5, 0x000fd64f, 0x000fde28, 0x000fe7fd, 0x000ff382, 0x0000004f, 0x00000deb, 0x00001bc8, 0x0000294e, 0x000035dd, 0x000040d8, 0x000049a7, 0x00004fc4, 0x000052be, 0x00005242, 0x00004e1e, 0x0000464a, 0x00003ae5, 0x00002c3b, 0x00001ac1,
  0x00000714, 0x000ff1f4, 0x000fdc3b, 0x000fc6d6, 0x000fb2c0, 0x000fa0ec, 0x000f9247, 0x000f87a1, 0x000f81ad, 0x000f80ec, 0x000f85b1, 0x000f900d, 0x000f9fda, 0x000fb4aa, 0x000fcdda, 0x000fea84, 0x00000996, 0x000029d1, 0x000049e0, 0x00006855,
  0x000083cf, 0x00009af4, 0x0000ac91, 0x0000b79e, 0x0000bb55, 0x0000b732, 0x0000ab0b, 0x00009703, 0x00007b9f, 0x000059b2, 0x00003267, 0x00000729, 0x000fd9a4, 0x000faba8, 0x000f7f24, 0x000f5602, 0x000f3223, 0x000f153c, 0x000f00cf, 0x000ef60a,
  0x000ef5c9, 0x000f0079, 0x000f161e, 0x000f3645, 0x000f600d, 0x000f9225, 0x000fcade, 0x00000833, 0x000047e1, 0x00008777, 0x0000c473, 0x0000fc56, 0x00012cc0, 0x00015388, 0x00016ed4, 0x00017d2b, 0x00017d87, 0x00016f60, 0x000152b9, 0x0001281a,
  0x0000f095, 0x0000adbd, 0x00006196, 0x00000e87, 0x000fb747, 0x000f5ec0, 0x000f07fc, 0x000eb605, 0x000e6bcb, 0x000e2c0f, 0x000df944, 0x000dd57e, 0x000dc25f, 0x000dc10a, 0x000dd21a, 0x000df59c, 0x000e2b14, 0x000e717c, 0x000ec755, 0x000f2aad,
  0x000f993a, 0x00001064, 0x00008d63, 0x00010d4f, 0x00018d3f, 0x00020a57, 0x000281e5, 0x0002f16e, 0x000356c1, 0x0003b005, 0x0003fbc3, 0x000438ea, 0x000466d2, 0x0004853f, 0x00049457, 0x000494a1, 0x000486f4, 0x00046c73, 0x0004467a, 0x00041691,
  0x0003de61, 0x00039fa1, 0x00035c0b, 0x0003154e, 0x0002cd02, 0x000284a2, 0x00023d80, 0x0001f8c4, 0x0001b763, 0x00017a21, 0x00014192, 0x00010e16, 0x0000dfe3, 0x0000b706, 0x00009368, 0x000074d3, 0x00005af9, 0x0000457c, 0x000033ef, 0x000025df,
  0x00001ad6, 0x00001262, 0x00000c13, 0x00000783, 0x00000457, 0x000002d8
};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 DmicQuad32BitFormatConfigSize = sizeof (DmicQuad32BitFormatConfig);

// DMIC Config 1 channel, 16 bits
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicMono16BitFormatConfig[] =
{
  0x00000000,
  0xfffffff0,0xfffffff0,0xfffffff0,0xfffffff0,
  3,
  3,
  0x00300003,
  0x00300003,
  0x3,
  0x0, 0x09001303, 0x0, 0x0301, 0, 0, 0, 0,
  0x10, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x10, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e,
  0x0, 0x09001303, 0x0, 0x0301, 0, 0, 0, 0,
  0x10, 0x402a0, 0, 0, 0, 0, 0, 0,
  0x10, 0xe03ae, 0, 0, 0, 0, 0, 0,
  0x00008, 0xfffae, 0xfff12, 0xffdfb, 0xffc61, 0xffa5a, 0xff82b, 0xff641, 0xff520, 0xff544, 0xff6f4, 0xffa25, 0xffe65,
  0x002e0, 0x0068f, 0x00876, 0x007f1, 0x004f5, 0x0002a, 0xffad4, 0xff68a, 0xff4bf, 0xff64f, 0xffb20,
  0x0020f, 0x00929, 0x00e2d, 0x00f40, 0x00b92, 0x003bf, 0xff9cd, 0xff0b0, 0xfeb6e, 0xfec2a, 0xff351,
  0xfff4f, 0x00ccd, 0x0179d, 0x01bfc, 0x017d7, 0x00ba3, 0xffa7e, 0xfe96f, 0xfddf5, 0xfdc4d, 0xfe5ee,
  0xff8ce, 0x00fb7, 0x023a8, 0x02df5, 0x02a74, 0x01910, 0xffe2c, 0xfe19c, 0xfcc64, 0xfc5ee, 0xfd17e,
  0xfecd4, 0x01071, 0x03198, 0x0457e, 0x044c9, 0x02e24, 0x00728, 0xfdb0e, 0xfb781, 0xfa86b, 0xfb408,
  0xfd884, 0x00c02, 0x03f37, 0x061e8, 0x06807, 0x04dc5, 0x01954, 0xfd98c, 0xfa1c8, 0xf840f, 0xf8b52,
  0xfb78c, 0xffd23, 0x047db, 0x080b1, 0x094e3, 0x07c08, 0x03b41, 0xfe45e, 0xf9101, 0xf5b1e, 0xf54f4,
  0xf8307, 0xfda0b, 0x0418f, 0x09ad0, 0x0c9d6, 0x0be16, 0x0780b, 0x009dd, 0xf92ba, 0xf3606, 0xf10ed,
  0xf315e, 0xf9135, 0x0172c, 0x09d83, 0x0fc9e, 0x11695, 0x0e05b, 0x065bf, 0xfc6ed, 0xf2ff4, 0xecc96,
  0xebbc9, 0xf0668, 0xf9be7, 0x05601, 0x1029e, 0x17140, 0x18065, 0x12728, 0x07874, 0xf9edb, 0xed202,
  0xe486c, 0xe294d, 0xe820f, 0xf424a, 0x03f29, 0x13d68, 0x1ff61, 0x253b2, 0x220fa, 0x16be1, 0x05638,
  0xf1798, 0xdf165, 0xd211a, 0xcd3f9, 0xd1eb5, 0xdfa89, 0xf4802, 0x0d656, 0x26d63, 0x3d808, 0x4ecc3,
  0x59315, 0x5c520, 0x58db6, 0x503d6, 0x444dd, 0x36ecb, 0x29b9a, 0x1de5d, 0x14234, 0x0cae0, 0x07669,
  0x03f40, 0x01e4e, 0x00c95, 0x0043b, 0x000f9,0xff961, 0x00823, 0x0084f, 0x00a39, 0x00d21, 0x010a8, 0x0149a, 0x018cc, 0x01d15, 0x0214d, 0x02543, 0x028c8, 0x02baa,
  0x02db8, 0x02ec6, 0x02eac, 0x02d4c, 0x02a90, 0x02672, 0x020f9, 0x01a3b, 0x0125c, 0x00994, 0x00025,
  0xff662, 0xfeca3, 0xfe34c, 0xfdabe, 0xfd364, 0xfcd94, 0xfc9a4, 0xfc7dd, 0xfc86b, 0xfcb6e, 0xfd0e6,
  0xfd8bb, 0xfe2b9, 0xfee8f, 0xffbd5, 0x00a0c, 0x018a3, 0x026fc, 0x03474, 0x04065, 0x04a36, 0x0515a,
  0x0555a, 0x055df, 0x052b2, 0x04bc3, 0x0412c, 0x03332, 0x02242, 0x00ef3, 0xff9fb, 0xfe430, 0xfce78,
  0xfb9c6, 0xfa70f, 0xf973a, 0xf8b1e, 0xf836e, 0xf80b7, 0xf8355, 0xf8b6e, 0xf98ea, 0xfab78, 0xfc288,
  0xfdd52, 0xffadf, 0x01a0a, 0x03992, 0x05823, 0x07465, 0x08d0c, 0x0a0e3, 0x0aedc, 0x0b61f, 0x0b614,
  0x0ae6b, 0x09f23, 0x0888d, 0x06b4c, 0x04850, 0x020d3, 0xff647, 0xfca4f, 0xf9eae, 0xf7533, 0xf4fa8,
  0xf2fc0, 0xf1702, 0xf06ba, 0xeffe6, 0xf032d, 0xf10d3, 0xf28b4, 0xf4a42, 0xf7486, 0xfa62a, 0xfdd81,
  0x01896, 0x0553d, 0x09128, 0x0c9fe, 0x0fd6f, 0x1294e, 0x14ba5, 0x162cb, 0x16d75, 0x16ac4, 0x15a52,
  0x13c38, 0x1110d, 0x0d9e9, 0x09856, 0x04e4a, 0xffe17, 0xfaa51, 0xf55c4, 0xf0350, 0xeb5d6, 0xe7020,
  0xe34c8, 0xe0620, 0xde61c, 0xdd64b, 0xdd7bd, 0xdeb03, 0xe102a, 0xe46b5, 0xe8dab, 0xee397, 0xf4699,
  0xfb479, 0x02ab3, 0x0a691, 0x1253c, 0x1a3d9, 0x21f98, 0x295cc, 0x30400, 0x36803, 0x3bff8, 0x40a63,
  0x44628, 0x4729b, 0x48f76, 0x49cd2, 0x49b35, 0x48b71, 0x46ea5, 0x44632, 0x413a6, 0x3d8b3, 0x3971b,
  0x350a6, 0x30716, 0x2bc15, 0x27131, 0x227cb, 0x1e11d, 0x19e2a, 0x15fc1, 0x1267c, 0x0f2c0, 0x0c4c2,
  0x09c8b, 0x079fb, 0x05cd2, 0x044b2, 0x0312d, 0x021c5, 0x015f4, 0x0135e
};

GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 DmicMono16BitFormatConfigSize = sizeof (DmicMono16BitFormatConfig);

//
// I2S Configuration BLOBs
// Audio Format and Configuration details
//
// Frequency: 48kHz, PCM resolution: 24 bits
// TDM slots: 4
// Codec: Realtek ALC298, mode: slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk298Render4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff32, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0x83d00437, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00000001, 0x00000fff};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sRtk298Render4ch48kHz24bitFormatConfigSize = sizeof (I2sRtk298Render4ch48kHz24bitFormatConfig);

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk298Capture4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0x83d00437, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00000001, 0x00000fff};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sRtk298Capture4ch48kHz24bitFormatConfigSize = sizeof (I2sRtk298Capture4ch48kHz24bitFormatConfig);

// Audio Format: 48kHz, 2channels, master clock
// Codec: Realtek ALC286S
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk286S2ch48kHzFormatConfig[] = { 0, 0xffffff10, 0xffffff32, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x83d00437, 0xc0700000, 0x0, 0x2990000, 0xf, 0xf, 0x4002, 0x0, 0x7070f00, 0x20, 0x1, 0xfff };
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sRtk286S2ch48kHzFormatConfigSize = sizeof (I2sRtk286S2ch48kHzFormatConfig);

// Audio Format: 48kHz, 4 channels
// Codec: ADI SSM4567
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sAdi4ch48kHzFormatConfig[] = { 0, 0xffffff10, 0xffffff32, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0x83d00437, 0xc0700000, 0x0, 0x2010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0, 0 };
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sAdi4ch48kHzFormatConfigSize = sizeof (I2sAdi4ch48kHzFormatConfig);

// Audio Format: 24bit, 48kHz, Master
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2s48kHz24bitMasterFormatConfig[] = { 0, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0x81d00937, 0xc0700000, 0x0, 0x02990000, 0x3, 0x3, 0x4002, 0x0, 0x7070f00, 0x20, 1, 0xFFF};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2s48kHz24bitMasterFormatConfigSize = sizeof (I2s48kHz24bitMasterFormatConfig);

// Audio Format: 24bit, 48kHz, Slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2s48kHz24bitSlaveFormatConfig[] = { 0, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0x81d00037, 0xd3700000, 0x0, 0x02000000, 0x3, 0x3, 0x4002, 0x0, 0x7070f00, 0x00, 1, 0xFFF};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2s48kHz24bitSlaveFormatConfigSize = sizeof (I2s48kHz24bitSlaveFormatConfig);

// Audio Format: PCM 16bit, 8kHz, Master
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sPcm8kHz16bitMasterFormatConfig[] = { 0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0x80c0953f, 0xc0400000, 0x0, 0x02010004, 0x1, 0x1, 0x4002, 0x4, 0x7020000, 0x20, 1, 0xFFF};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sPcm8kHz16bitMasterFormatConfigSize = sizeof (I2sPcm8kHz16bitMasterFormatConfig);

// Audio Format: PCM 16bit, 8kHz, Slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sPcm8kHz16bitSlaveFormatConfig[] = { 0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0xfffffff0, 0x80c0003f, 0xd3400000, 0x0, 0x02000004, 0x1, 0x1, 0x4002, 0x0, 0x7020000, 0x00, 1, 0xFFF};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 I2sPcm8kHz16bitSlaveFormatConfigSize = sizeof (I2sPcm8kHz16bitSlaveFormatConfig);

//
// BlueTooth Configuration BLOBs
//
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 BtFormatConfig[] =
{
  0x0, 0xfffffff0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
  0x0, 0x80c0003f, 0xd3400000, 0x0, 0x02000005, 0x01, 0x01, 0x4002,
  0x0, 0x07020000, 0x0, 0x01, 0x0
};
GLOBAL_REMOVE_IF_UNREFERENCED CONST UINT32 BtFormatConfigSize = sizeof (BtFormatConfig);
