/** @file
  CloverFalls (CVF) Driver
  This ASL file will support the CVF companion die interfaced with TGL RVP over SPI.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/
External(\SB.PC00.HCID, MethodObj)
include("GpioAcpiDefinesVer2.h")

Scope(\_SB.PC00.SPI1) {

  Device(SPFD) { //CVF SPI Fucntional Device
    //
    //This object is used to supply OSPM with the devices PNP ID or ACPI ID.
    //
    Name(_HID,"INTC1058")

    //
    //This optional object is used to supply OSPM with a devices Plug and Play-Compatible Device ID.
    //Use _CID objects when a device has no other defined hardware standard method to report its
    //compatible IDs
    //Name(_CID,"SPI3000")
    //

    //
    //Dos Device name
    //This object is used to associate a logical name (for example, COM1) with a device.
    //This name can be used by applications to connect to the device.
    //
    Name(_DDN, "Intel SPI OED Device")

    Method (_CRS, 0, Serialized) {
      Name (SBUF, ResourceTemplate () {
        //
        //Interrupt to Host
        //
        GpioIo (Shared, PullDefault, 0, 0, IoRestrictionInputOnly,  "\\_SB.GPI0",,, HIRQ) {GPIO_VER2_LP_DRIVER_GPP_H15}
        //
        //To reset CVF
        //
        GpioIo(Exclusive, PullDefault, 0, 0, IoRestrictionOutputOnly, "\\_SB.GPI0",,,HRST) { GPIO_VER2_LP_DRIVER_GPP_H13}
        GpioIo(Exclusive, PullDefault, 0, 0, IoRestrictionOutputOnly, "\\_SB.GPI0",,,WKCF) { GPIO_VER2_LP_DRIVER_GPP_C2}
        GpioInt (Edge, ActiveLow, Shared, PullDefault, 0x0000, "\\_SB.GPI0", 0x00, ResourceConsumer, GIN0 ) {  GPIO_VER2_LP_DRIVER_GPP_H15}
        //
        //SPI Slave for 1MHz
        //
        SPISerialBus(0x00,PolarityLow,FourWireMode,8,ControllerInitiated,1000000,ClockPolarityHigh,ClockPhaseSecond,"\\_SB.PC00.SPI1",,,SPI1)
      })
      Return(SBUF)
    }

    Device(CVFD) {
      Name(_HID,"INTC1059")
      Name(_DDN, "Intel CVF Device")

      Method(SID,1, Serialized) {
        Return(HCID(1))
      }

    } // End of CVF Device

  } // End of Device(SPD)

} // End of Scope (\_SB.PCI0.SPI1)

