/** @file
  Intel ACPI Reference Code for _DSM WiFi Feature Enabling Implementation

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
  **/
//--------------------------------------------------
//  Intel Proprietary WiFi Feature Enabling Solution
//--------------------------------------------------
//
// _DSM (Device Specific Method)
//
// This optional object is a control method that enables devices to provide device specific control
// functions that are consumed by the device driver.
//
// Arguments: (4)
//   Arg0 - A Buffer containing a UUID
//   Arg1 - An Integer containing the Revision ID
//   Arg2 - An Integer containing the Function Index
//   Arg3 - A Package that contains function-specific arguments
// Return Value:
//   If Function Index = 0, a Buffer containing a function index bit-field which has set of supported function indexes.
//   Otherwise, the return feature value based on set of supported function type which depends on the UUID and revision ID.
//
Method(_DSM, 0x4, Serialized, 0, {IntObj, BuffObj}, {BuffObj, IntObj, IntObj, PkgObj})
{
  If(LEqual(Arg0, ToUUID("F21202BF-8F78-4DC6-A5B3-1F738E285ADE"))) {
    //
    // Function 0 : Query Function/Get supported functions (based on revision)
    //              For Revision 0,
    //              -- Return value would contain one bit for each function index. Starting with zero.
    //              -- Bit 0 indicates whether there is support for any functions other than function 0 for the specified UUID and Revision ID.
    //              -- If set to zero, no functions are supported.
    //
    If(LEqual(Arg2, Zero)) {
      // Revision 0
      If(LEqual(Arg1, Zero)){ // The current revision is 0
        //
        // Below are functions defined.
        // Bit0    - Indicates whether its support for any other functions
        // Bit1    - Disable SRD Active Channels
        // Bit2    - Supported Indonesia 5.15-5.35 GHz Band
        // Bit3    - Ultra High Band support
        // Bit31:4 - Reserved for future options
        Return(Buffer(){0x0F})
      } Else {
        Return(Buffer(){0}) // No supported functions.
      }
    }

    //
    // Function 1 : Disable SRD Active Channels
    // 00 - ETSI 5.8GHz SRD Active Scan
    // 01 - ETSI 5.8GHz SRD Passive Scan
    // 02 - ETSI 5.8GHz SRD Disabled
    //
    If(LEqual(Arg2, One)) {
      Store(\ACSD, Local0) // Switched Antenna Diversity Selection
      Return(Local0)
    }

    //
    // Function 2 : Supported Indonesia 5.15-5.35 GHz Band
    // 00 - Set 5.115-5.35GHz to Disable in Indonesia
    // 01 - Set 5.115-5.35GHz to Enable (Passive) in Indonesia
    // 02 - Reserved
    //
    If(LEqual(Arg2, 2)) {
       Store(\I5BS,Local0) // Supported Indonesia 5.15-5.35 GHz Band
       Return(Local0)  // Return Set 5.115-5.35GHz to Disable in Indonesia
    }

    //
    // Function 3 : Ulta High Band Support
    // 00 - Set UHB Disable [Default]
    // 01 - Set UHB Enabled All
    // Bit 31:01 - Reserved
    //
    If(LEqual(Arg2, 3)) {
       Store(\UHBS,Local0) // UHB support
       Return(Local0)
    }

    // no other supported functions, but normal return.
    Return(0)
  } Else {
    Return(Buffer(){0}) // Guid mismatch
  }
}
