/** @file
  Intel ACPI Sample Code for discrete connectivity modules (WWAN)

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/
Method(_RST, 0, NotSerialized) {
  Name(L850, 0)


  If(LEqual(VDID, 0x73608086))
  {
    Store(1, L850)
  }

  // Drive BB RESET Pin low
  \_SB.SGOV(\WBRS, \PBRS)
  Sleep(200) // Safe 200ms
  Notify(PCIE_ROOT_PORT.PXSX, 1)

  // De-Assert PERST
  \_SB.SGOV(\PRST, And(Not(\WPRP), 1))

  // Drive BB RESET Pin high
  \_SB.SGOV(\WBRS, And(Not(\PBRS), 1))

  If(LEqual(L850, 1))
  {
    Sleep(200)
  }

  Store(0, Local0)
  While(LEqual(PCIE_ROOT_PORT.LASX, 0)) {
    If(Lgreater(Local0, 20))    // Wait for 300ms
    {
      Break
    }
    Sleep(16)
    Increment(Local0)
  }
  Sleep(10)
  Notify(PCIE_ROOT_PORT.PXSX, 1)
  }

PowerResource(MRST, 5, 0)
{
  // Define the PowerResource for the WWAN device
  // PowerResource expects to have _STA, _ON and _OFF Method per ACPI Spec. Not having one of them will cause BSOD

  //
  // Method _STA: Dummy _STA() to comply with ACPI Spec
  //
  Method(_STA, 0, Serialized) {
    return(1)
  }

  //
  // Method _ON: Dummy _ON() to comply with ACPI Spec
  //
  Method(_ON, 0, Serialized) {
  }

  //
  // Method _OFF: Dummy _OFF() to comply with ACPI Spec
  //
  Method(_OFF, 0, Serialized) {
  }

  //
  // Method _RST(): executes a WWAN device power-cycle reset using FULL_CARD_POWER_OFF# and RESET# signals
  //
  Method(_RST, 0, Serialized) {
    // 1. Acquire _PRR Mutex and save result to check for acquire Mutex
    Store (Acquire (\WWMT, 0xFFFF), Local0)
    // 2. Check for _PRR Mutex acquired
    If (LEqual (Local0, Zero))
    {
      ADBG ("Start WWAN PR _RST")
      // 3. Trigger L2/L3 ready entry flow in rootport
      DL23()
      // 4. Assert RESET GPIO.
      \_SB.SGOV(\WBRS, \PBRS)
      // 5. Disable SRC Clock
      SPCO(\WCLK, 0)              // SCLK : 2
      // 6. Sleep for 10 ms.
      Sleep(10)
      // 7. Assert FULL_CARD_POWER_OFF# GPIO.
      \_SB.SGOV(\WFCP, And(Not(\PFCP), 1))
      // 8. Sleep for 10 ms.
      Sleep(10)
      // 9. Disable ModPHY Power Gating
      \_SB.PSD0(SLOT)
      // 10. Enable SRC Clock
      SPCO(\WCLK, 1) // SCLK : 2
      // 11. De-assert FULL_CARD_POWER_OFF# GPIO.
      \_SB.SGOV(\WFCP, \PFCP)
      // 12. De-assert RESET GPIO.
      \_SB.SGOV(\WBRS, And(Not(\PBRS), 1))
      // 13. De-assert PERST GPIO.
      \_SB.SGOV(\PRST, And(Not(\WPRP), 1))
      // 14. Trigger L2/L3 ready exit flow in rootport - transition link to Detect
      L23D()
      // 15. Release _PRR mutex
      Release(\WWMT)
    }
  }
} // End MRST
