/** @file


 @copyright
  INTEL CONFIDENTIAL
  Copyright 2016 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _TIGERLAKE_CONFIG_PATCH_TABLE_H_
#define _TIGERLAKE_CONFIG_PATCH_TABLE_H_

#include <Library/SetupInitLib.h>
#include <SetupVariable.h>
#include <Protocol/RetimerCapsuleUpdate.h>

CONFIG_PATCH_TABLE  mTigerlakeHDdr4RvpSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(SETUP_DATA, TbtLegacyModeSupport),                   OFFSET_OF(SETUP_DATA, TbtLegacyModeSupport),                    0 },
  { SIZE_OF_FIELD(SETUP_DATA, AuxOriOverrideSupport),                  OFFSET_OF(SETUP_DATA, AuxOriOverrideSupport),                   1 },
  { SIZE_OF_FIELD(SETUP_DATA, HebcValueSupport),                       OFFSET_OF(SETUP_DATA, HebcValueSupport),                        1 },
  { SIZE_OF_FIELD(SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C0]), OFFSET_OF (SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C0]), SERIAL_IO_I2C_TOUCHPAD },
  { SIZE_OF_FIELD(SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C1]), OFFSET_OF (SETUP_DATA, PchI2cSensorDevicePort[SERIAL_IO_I2C1]), SERIAL_IO_I2C_TOUCHPANEL },
  { SIZE_OF_FIELD(SETUP_DATA, PchSpiSensorDevicePort[SERIAL_IO_SPI1]), OFFSET_OF (SETUP_DATA, PchSpiSensorDevicePort[SERIAL_IO_SPI1]), SERIAL_IO_SPI_FINGERPRINT },
  { SIZE_OF_FIELD(SETUP_DATA, AcpiDebug),                 OFFSET_OF(SETUP_DATA, AcpiDebug),               1 },
  { SIZE_OF_FIELD(SETUP_DATA, PepGfx),                            OFFSET_OF(SETUP_DATA, PepGfx),                            0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepIpu),                            OFFSET_OF(SETUP_DATA, PepIpu),                            0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepPeg0),                           OFFSET_OF(SETUP_DATA, PepPeg0),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepPcieStorage),                    OFFSET_OF(SETUP_DATA, PepPcieStorage),                    0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepUart),                           OFFSET_OF(SETUP_DATA, PepUart),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c0),                           OFFSET_OF(SETUP_DATA, PepI2c0),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c1),                           OFFSET_OF(SETUP_DATA, PepI2c1),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c2),                           OFFSET_OF(SETUP_DATA, PepI2c2),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c3),                           OFFSET_OF(SETUP_DATA, PepI2c3),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c4),                           OFFSET_OF(SETUP_DATA, PepI2c4),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepI2c5),                           OFFSET_OF(SETUP_DATA, PepI2c5),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepSpi),                            OFFSET_OF(SETUP_DATA, PepSpi),                            0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepXhci),                           OFFSET_OF(SETUP_DATA, PepXhci),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepAudio),                          OFFSET_OF(SETUP_DATA, PepAudio),                          0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepCsme),                           OFFSET_OF(SETUP_DATA, PepCsme),                           0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepGbe),                            OFFSET_OF(SETUP_DATA, PepGbe),                            0 },
  { SIZE_OF_FIELD(SETUP_DATA, PepTcss),                           OFFSET_OF(SETUP_DATA, PepTcss),                           0 }
};

CONFIG_PATCH_TABLE  mTigerlakeHDdr4RvpPchSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, PxDevSlp[0]),                        OFFSET_OF(PCH_SETUP, PxDevSlp[0]),                        1 },
  { SIZE_OF_FIELD(PCH_SETUP, PxDevSlp[1]),                        OFFSET_OF(PCH_SETUP, PxDevSlp[1]),                        1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI0]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI0]),     0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI1]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI1]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI2]),     OFFSET_OF(PCH_SETUP, PchSerialIoSpi[SERIAL_IO_SPI2]),     0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART0]),   OFFSET_OF(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART0]),   0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART1]),   OFFSET_OF(PCH_SETUP, PchSerialIoUart[SERIAL_IO_UART1]),   0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchUartHwFlowCtrl[2]),               OFFSET_OF(PCH_SETUP, PchUartHwFlowCtrl[2]),               0 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C2]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C2]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C3]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C3]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C4]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C4]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C5]),     OFFSET_OF(PCH_SETUP, PchSerialIoI2c[SERIAL_IO_I2C5]),     1 },
  { SIZE_OF_FIELD(PCH_SETUP, PchHdAudioI2sCodecSelect),           OFFSET_OF(PCH_SETUP, PchHdAudioI2sCodecSelect),           2 }
};

CONFIG_PATCH_TABLE  mTigerlakeHDdr4RvpSaSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(SA_SETUP, SkipCdClockInit),                      OFFSET_OF(SA_SETUP, SkipCdClockInit),                     1 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[0]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[0]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[1]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[1]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[2]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[2]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, PcieRootPortPMCE[3]),                  OFFSET_OF(SA_SETUP, PcieRootPortPMCE[3]),                 0 },
  { SIZE_OF_FIELD(SA_SETUP, CpuTraceHubMode),                      OFFSET_OF(SA_SETUP, CpuTraceHubMode),                     2 },
  { SIZE_OF_FIELD(SA_SETUP, DpInSetupFormSupport),                 OFFSET_OF(SA_SETUP, DpInSetupFormSupport),                1 },
  { SIZE_OF_FIELD(SA_SETUP, SaGv),                                 OFFSET_OF(SA_SETUP, SaGv),                                0 }
};

CONFIG_PATCH_TABLE  mTigerlakeHDdr4RvpCpuSetupConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(CPU_SETUP, TurboMode),                           OFFSET_OF(CPU_SETUP, TurboMode),                          0 }
};

CONFIG_PATCH_STRUCTURE mTigerlakeHDdr4RvpConfigPatchStruct[] = {
  { L"Setup",    &gSetupVariableGuid,    sizeof(SETUP_DATA), mTigerlakeHDdr4RvpSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeHDdr4RvpSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"SaSetup",  &gSaSetupVariableGuid,  sizeof(SA_SETUP),   mTigerlakeHDdr4RvpSaSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeHDdr4RvpSaSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"CpuSetup", &gCpuSetupVariableGuid, sizeof(CPU_SETUP),  mTigerlakeHDdr4RvpCpuSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeHDdr4RvpCpuSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeHDdr4RvpPchSetupConfigPatchTable, SIZE_OF_TABLE(mTigerlakeHDdr4RvpPchSetupConfigPatchTable, CONFIG_PATCH_TABLE) },
  { L"MeSetup",  &gMeSetupVariableGuid,  sizeof(ME_SETUP),   NULL, 0 }
};


/**
  Patch Table to support IOTG Skew
**/
CONFIG_PATCH_TABLE  mTigerlakeEmbeddedConfigPatchTable[] = {
//{-Type------------------Size-------------------------------------------Offset------------------------------------Data-------------},
  { SIZE_OF_FIELD(PCH_SETUP, IehMode),  OFFSET_OF(PCH_SETUP, IehMode),   1 },
  { SIZE_OF_FIELD(PCH_SETUP, EnableTcoTimer),  OFFSET_OF(PCH_SETUP, EnableTcoTimer),   1 }
};

CONFIG_PATCH_STRUCTURE mTigerlakeEmbeddedConfigPatchStruct[] = {
  { L"PchSetup", &gPchSetupVariableGuid, sizeof(PCH_SETUP),  mTigerlakeEmbeddedConfigPatchTable, SIZE_OF_TABLE(mTigerlakeEmbeddedConfigPatchTable, CONFIG_PATCH_TABLE) }
};

#endif // _TIGERLAKE_CONFIG_PATCH_TABLE_H_
