/** @file
 Source code for the board SA configuration Pcd init functions in Pre-Memory init phase.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include "BoardSaConfigPreMem.h"
#include <Library/CpuPlatformLib.h>
#include <Pins/GpioPinsVer2H.h>
#include <PlatformBoardId.h>
#include <Library/PreSiliconEnvDetectLib.h>
#include <PlatformBoardConfig.h>

/**
  MRC configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglHSaMiscConfigInit (
  VOID
  )
{
  PcdSet8S (PcdSaMiscUserBd, 1);
  PcdSet16S (PcdSaDdrFreqLimit, 0);

  return;
}

/**
  Board Memory Init related configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglHMrcConfigInit (
  VOID
  )
{
  BOOLEAN ExternalSpdPresent;
  // SPD is the same size for all boards
  //PcdSet16S (PcdMrcSpdDataSize, sizeof (mLpddr4Ddp8Gb200bSpd));
  if (IsSimicsEnvironment()) {
    // Simics will use DDR4 boards that have external SPD on UDIMM/SO-DIMM
    ExternalSpdPresent = TRUE;
  } else {
    // ExternalSpdPresent = PcdGetBool (PcdSpdPresent);
    ExternalSpdPresent = TRUE;
  }

  // Check for external SPD presence on LPDDR4 boards
  if (ExternalSpdPresent){
    PcdSet8S (PcdMrcSpdAddressTable0, 0xA0);
    PcdSet8S (PcdMrcSpdAddressTable1, 0xA2);
    PcdSet8S (PcdMrcSpdAddressTable2, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable3, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable4, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable5, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable6, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable7, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable8, 0xA4);
    PcdSet8S (PcdMrcSpdAddressTable9, 0xA6);
    PcdSet8S (PcdMrcSpdAddressTable10, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable11, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable12, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable13, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable14, 0x0);
    PcdSet8S (PcdMrcSpdAddressTable15, 0x0);
  } else {
    PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp8Gb200bSpd);
    PcdSet8S (PcdMrcSpdAddressTable0, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable1, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable2, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable3, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable4, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable5, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable6, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable7, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable8, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable9, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable10, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable11, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable12, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable13, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable14, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable15, 0x00);
  }

  // Setting the default DQ Byte Map. It may be overriden to board specific settings below.
  PcdSet32S (PcdMrcDqByteMap, (UINTN) DqByteMapTglH);
  PcdSet16S (PcdMrcDqByteMapSize, sizeof (DqByteMapTglH));

  // ICL uses the same RCOMP resistors for all DDR types
  PcdSet32S (PcdMrcRcompResistor, (UINTN) TglHRcompResistorZero);

  // Use default RCOMP target values for all boards
  PcdSet32S (PcdMrcRcompTarget, (UINTN) RcompTargetTglH);

  // Use default Interleaving mode of DQ/DQS pins values for all boards
  PcdSetBoolS (PcdMrcDqPinsInterleavedControl, TRUE);
  PcdSetBoolS (PcdMrcDqPinsInterleaved, TRUE);

  // SPD is the same size for all boards
  PcdSet16S (PcdMrcSpdDataSize, sizeof (mLpddr4Ddp8Gb200bSpd));
  // DqsMapCpu2Dram is the same size for all boards
  PcdSet16S (PcdMrcDqsMapCpu2DramSize, sizeof (DqsMapCpu2DramTglHLp4Type4Rvp));
  // DqMapCpu2Dram is the same size for all boards
  //PcdSet16S (PcdMrcDqMapCpu2DramSize, sizeof (DqMapCpu2DramTglULp4Type4));

  //
  // CA Vref routing: board-dependent
  // 0 - VREF_CA goes to both CH_A and CH_B (LPDDR3/DDR3L)
  // 1 - VREF_CA to CH_A, VREF_DQ_A to CH_B (should not be used)
  // 2 - VREF_CA to CH_A, VREF_DQ_B to CH_B (DDR4)
  //
  // Set it to 2 for all our DDR4 boards; it is ignored for LPDDR4
  //
  PcdSet8S (PcdMrcCaVrefConfig, 2);

  return;
}

/**
  Board SA related GPIO configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglHSaGpioConfigInit (
  VOID
  )
{
  //
  // Assigning default values to PCIE RTD3 GPIOs
  //

  //
  // Configure CPU M.2 SSD GPIO PCDs
  //
  PcdSet32S(PcdPcieSsd2PwrEnableGpioNo, GPIO_VER2_H_GPP_H17);
  PcdSet32S(PcdPcieSsd2RstGpioNo, GPIO_VER2_H_GPP_I9);
  PcdSetBoolS(PcdPcieSsd2PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
  PcdSetBoolS(PcdPcieSsd2RstGpioPolarity, PIN_GPIO_ACTIVE_LOW);

  //
  // For PEG Slot A
  //
  PcdSet32S (PcdPegSlotAWakeGpioPin, GPIO_VER2_H_GPP_H15);
  PcdSet32S (PcdPegSlotAPwrEnableGpioNo, GPIO_VER2_H_GPP_F18);
  PcdSet32S (PcdPegSlotARstGpioNo, GPIO_VER2_H_GPP_H13);
  PcdSetBoolS (PcdPegSlotAPwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
  PcdSetBoolS (PcdPegSlotARstGpioPolarity, PIN_GPIO_ACTIVE_LOW);

  //
  // For PEG Slot B
  //
  PcdSet32S (PcdPegSlotBWakeGpioPin, GPIO_VER2_H_GPP_K5);
  PcdSet32S (PcdPegSlotBPwrEnableGpioNo, GPIO_VER2_H_GPP_K3);
  PcdSet32S (PcdPegSlotBRstGpioNo, GPIO_VER2_H_GPP_K4);
  PcdSetBoolS (PcdPegSlotBPwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
  PcdSetBoolS (PcdPegSlotBRstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);

  //
  // For PEG Slot C
  //
  PcdSet32S (PcdPegSlotCWakeGpioPin, GPIO_VER2_H_GPP_K1);
  PcdSet32S (PcdPegSlotCPwrEnableGpioNo, GPIO_VER2_H_GPP_H12);
  PcdSet32S (PcdPegSlotCRstGpioNo, GPIO_VER2_H_GPP_K0);
  PcdSetBoolS (PcdPegSlotCPwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
  PcdSetBoolS (PcdPegSlotCRstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);

  //
  // PCIE RTD3 GPIO
  //
  PcdSet8S(PcdPcie0GpioSupport, PchGpio);
  PcdSet8S(PcdPcie0HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie0HoldRstGpioNo, GPIO_VER2_H_GPP_I9);
  PcdSetBoolS(PcdPcie0HoldRstActive, FALSE);
  PcdSet8S(PcdPcie0PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie0PwrEnableGpioNo, GPIO_VER2_H_GPP_H17);
  PcdSetBoolS(PcdPcie0PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie1GpioSupport, PchGpio);
  PcdSet8S(PcdPcie1HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie1HoldRstGpioNo, GPIO_VER2_H_GPP_H13);
  PcdSetBoolS(PcdPcie1HoldRstActive, FALSE);
  PcdSet8S(PcdPcie1PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie1PwrEnableGpioNo, GPIO_VER2_H_GPP_F18);
  PcdSetBoolS(PcdPcie1PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie2GpioSupport, NotSupported);
  PcdSet8S(PcdPcie2HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie2HoldRstGpioNo, 0);
  PcdSetBoolS(PcdPcie2HoldRstActive, FALSE);
  PcdSet8S(PcdPcie2PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie2PwrEnableGpioNo, 0);
  PcdSetBoolS(PcdPcie2PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie3GpioSupport, NotSupported);
  PcdSet8S(PcdPcie3HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie3HoldRstGpioNo, 0);
  PcdSetBoolS(PcdPcie3HoldRstActive, FALSE);
  PcdSet8S(PcdPcie3PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie3PwrEnableGpioNo, 0);
  PcdSetBoolS(PcdPcie3PwrEnableActive, FALSE);
  return;
}

/**
  SA Display DDI configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval     VOID
**/
VOID
TglHSaDisplayConfigInit (
  VOID
  )
{

  UINT16    BoardId;
  BoardId = PcdGet16(PcdBoardId);

  switch (BoardId) {
    case BoardIdTglHDdr4SODimmErb:
    case BoardIdTglHDdr4SODimm:
    case BoardIdTglHDdr4SODimmOcErb:
    case BoardIdTglHDdr4SODimmOc:
      PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglHDdr4RowDisplayDdiConfig);
      PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglHDdr4RowDisplayDdiConfig));
      break;
    case BoardIdTglHDdr5SODimmErb:
    case BoardIdTglHDdr5SODimm:
    case BoardIdTglHLp5Erb:
      PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglHDdr5RowDisplayDdiConfig);
      PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglHDdr5RowDisplayDdiConfig));
      break;
    default:
      break;
  }
  return;
}

/**
  Board USB related configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglHSaUsbConfigInit (
  VOID
  )
{
  PcdSet8S (PcdCpuUsb30PortEnable, 0x0F);

  return;
}
