/** @file
  PCH USB OverCurrent Port mapping tables

@copyright
 Copyright (c) 2019 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.
  This file contains an 'Intel Peripheral Driver' and is
  licensed for Intel CPUs and chipsets under the terms of your
  license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the
  license agreement.
**/

#include "PchUsbOcMappingTable.h"

USB_OC_MAP_TABLE mTglHUsb2OverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  0,              // Port 0
  3,              // Port 1
  0,              // Port 2
  1,              // Port 3
  2,              // Port 4
  USB_OC_SKIP,    // Port 5
  USB_OC_SKIP,    // Port 6
  USB_OC_SKIP,    // Port 7
  USB_OC_SKIP,    // Port 8
  USB_OC_SKIP,    // Port 9
  USB_OC_SKIP,    // Port 10
  4,              // Port 11
  4,              // Port 12
  USB_OC_SKIP     // Port 13
);

USB_OC_MAP_TABLE mTglHUsb2VwOverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  0,              // Port 0
  3,              // Port 1
  0,              // Port 2
  1,              // Port 3
  2,              // Port 4
  USB_OC_SKIP,    // Port 5
  USB_OC_SKIP,    // Port 6
  8,              // Port 7
  9,              // Port 8
  10,             // Port 9
  11,             // Port 10
  4,              // Port 11
  4,              // Port 12
  USB_OC_SKIP     // Port 13
);

USB_OC_MAP_TABLE mTglHUsb3OverCurrentMappingTable = USB_OC_MAP_TABLE_INIT (
  0,              // Port 0
  3,              // Port 1
  0,              // Port 2
  1,              // Port 3
  2,              // Port 4
  USB_OC_SKIP,    // Port 5
  USB_OC_SKIP,    // Port 6
  USB_OC_SKIP,    // Port 7
  USB_OC_SKIP,    // Port 8
  USB_OC_SKIP     // Port 9
);
