/** @file

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <PiPei.h>
#include <Library/PcdLib.h>
#include <Library/DebugLib.h>
#include <Library/EcMiscLib.h>
#include <PlatformBoardType.h>
#include <Library/PeiDxeBoardIdsLib.h>
#include <PlatformBoardId.h>
#include <PlatformBoardConfig.h>
#include <Library/BoardConfigLib.h>
#include <Pins/GpioPinsVer2H.h>
BOOLEAN
IsTglH (
  VOID
  )
{
  UINT16          BoardId;
  BoardId = PcdGet16 (PcdBoardId);
  if (BoardId == 0) {
    DEBUG ((DEBUG_INFO, "Let's get Board information first ...\n"));
    GetBoardConfig ();
    BoardId = PcdGet16 (PcdBoardId);
  }
  switch (BoardId) {
    case BoardIdTglHDdr4SODimm:
      DEBUG ((DEBUG_INFO, "Tigerlake H Board detected\n"));
      PcdSet32S (PcdBoardRetimerForcePwrGpio, (UINTN) GPIO_VER2_H_GPP_F3);
      return TRUE;
    default:
      return FALSE;
  }
}

EFI_STATUS
EFIAPI
TglHBoardDetect (
  VOID
  )
{
  UINT16          SkuId;
  SkuId      = 0;

  if (LibPcdGetSku () != 0) {
    return EFI_SUCCESS;
  }

  DEBUG ((DEBUG_INFO, "TigerLake H Board Detection Callback\n"));

  if (IsTglH ()) {
    SkuId =  SkuIdTglH;
    LibPcdSetSku (SkuId);
    DEBUG ((DEBUG_INFO, "SKU_ID: 0x%x\n", LibPcdGetSku()));
  }
  return EFI_SUCCESS;
}
