/** @file

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <PiPei.h>
#include <Library/DebugLib.h>
#include <Library/PcdLib.h>

#include <Library/SiliconInitLib.h>
#include <Library/PreSiliconEnvDetectLib.h>
#include <Library/BoardConfigLib.h>

#include "GpioTableTglHPostMem.h"
#include <Pins/GpioPinsVer1H.h>
#include <Library/PeiServicesLib.h>
#include <Library/GpioLib.h>
#include <PlatformBoardId.h>
#include <PlatformBoardConfig.h>
#include <UsbTypeC.h>

/**
  Tigerlake H boards configuration init function for PEI post memory phase.

  @retval EFI_SUCCESS             The function completed successfully.
**/
EFI_STATUS
EFIAPI
TglHGpioTableInit (
  VOID
  )
{
  EFI_STATUS    Status = EFI_SUCCESS;
  //
  // GPIO Table Init, Update PostMem GPIO table to PcdBoardGpioTable
  //
  ConfigureGpioTabletoPCD (mGpioTableTglHDdr4SODimm, POST_MEM);
  return Status;
}

/**
  Touch panel GPIO init function for PEI post memory phase.
**/
VOID
TglHTouchPanelGpioInit (
  VOID
  )
{
  DEBUG ((DEBUG_INFO, "TouchPanelGpioInit()\n"));
  //PcdSet32S (PcdBoardGpioTableTouchPanel, 0);
}

/**
  HDA VerbTable init function for PEI post memory phase.
**/
VOID
TglHHdaVerbTableInit (
  VOID
  )
{
  HDAUDIO_VERB_TABLE *VerbTable;
  HDAUDIO_VERB_TABLE *VerbTable2;

  VerbTable  = NULL;
  VerbTable2 = NULL;

  DEBUG ((DEBUG_INFO, "HDA: Init default verb tables (Realtek ALC700 and ALC701)\n"));
  VerbTable = &HdaVerbTableAlc711;

  PcdSet32S (PcdHdaVerbTable, (UINT32) VerbTable);
  PcdSet32S (PcdHdaVerbTable2, (UINT32) VerbTable2);

  PcdSet32S (PcdDisplayAudioHdaVerbTable, (UINT32) &HdaVerbTableDisplayAudio);

  // TGL POR Codecs - Realtek ALC700, ALC701, ALC274 (external - connected via HDA header)
  PcdSet32S (PcdCommonHdaVerbTable1, (UINT32) &HdaVerbTableAlc711);

  PcdSet32S (PcdCommonHdaVerbTable2, (UINT32) &HdaVerbTableAlc701);

  PcdSet32S (PcdCommonHdaVerbTable3, (UINT32) &HdaVerbTableAlc274);

  return;
}

/**
  Misc. init function for PEI post memory phase.
**/
VOID
TglHBoardMiscInit (
  VOID
  )
{
  PcdSet8S (PcdSataPortsEnable0, 0x1);
  PcdSetBoolS (PcdSataLedEnable, FALSE);
  PcdSetBoolS (PcdVrAlertEnable, FALSE);
  PcdSetBoolS (PcdPchThermalHotEnable, FALSE);
  PcdSetBoolS (PcdMemoryThermalSensorGpioCPmsyncEnable, FALSE);
  PcdSetBoolS (PcdMemoryThermalSensorGpioDPmsyncEnable, FALSE);

  //
  // For PCIe Slot1 - x4 Connector
  //
  PcdSet32S (PcdPcieSlot1WakeGpioPin, GPIO_VER2_H_GPP_E4);
  PcdSet32S (PcdPcieSlot1PwrEnableGpioNo, GPIO_VER2_H_GPP_H18);
  PcdSet32S (PcdPcieSlot1HoldRstGpioNo, GPIO_VER2_H_GPP_F23);
  PcdSetBoolS (PcdPcieSlot1PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_LOW);
  PcdSetBoolS (PcdPcieSlot1HoldRstGpioPolarity, PIN_GPIO_ACTIVE_LOW);
  PcdSet8S (PcdPcieSlot1RootPort, 21);

  //
  // For PCIe Slot2 - (x4 Connector for TGL-H)
  //
  PcdSet32S (PcdPcieSlot2WakeGpioPin, GPIO_VER2_H_GPP_E2);
  PcdSet32S (PcdPchPCIeSlot2PwrEnableGpioNo, GPIO_VER2_H_GPP_H14);
  PcdSet32S (PcdPchPCIeSlot2RstGpioNo, GPIO_VER2_H_GPP_E6);
  PcdSetBoolS (PcdPchPCIeSlot2PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_LOW);
  PcdSetBoolS (PcdPchPCIeSlot2RstGpioPolarity, PIN_GPIO_ACTIVE_LOW);
  PcdSet8S (PcdPcieSlot2RootPort, 1);

  //
  // PCH M.2 SSD X4 Slot1
  //
  PcdSet32S (PcdPchSsd1PwrEnableGpioNo, GPIO_VER2_H_GPP_B16);  // PCH M.2 SSD power enable gpio pin
  PcdSet32S (PcdPchSsd1RstGpioNo, GPIO_VER2_H_GPP_C14);  // PCH M.2 SSD reset gpio pin
  PcdSetBoolS (PcdPchSsd1PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // PCH M.2 SSD power enable gpio pin polarity
  PcdSetBoolS (PcdPchSsd1RstGpioPolarity, PIN_GPIO_ACTIVE_LOW);  // PCH M.2 SSD reset gpio pin polarity

  //
  // PCH M.2 SSD X4 Slot2
  //
  PcdSet32S (PcdPchSsd2PwrEnableGpioNo, GPIO_VER2_H_GPP_B15);  // PCH M.2 SSD power enable gpio pin
  PcdSet32S (PcdPchSsd2RstGpioNo, GPIO_VER2_H_GPP_H23);  // PCH M.2 SSD reset gpio pin
  PcdSetBoolS (PcdPchSsd2PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // PCH M.2 SSD power enable gpio pin polarity
  PcdSetBoolS (PcdPchSsd2RstGpioPolarity, PIN_GPIO_ACTIVE_LOW);  // PCH M.2 SSD reset gpio pin polarity

  //
  // SATA
  //
  PcdSet32S (PcdPchSataPortPwrEnableGpioNo, GPIO_VER2_H_GPP_F4);  // Sata port power pin
  PcdSetBoolS (PcdPchSataPortPwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Sata port power pin polarity

  //
  // Touch Pad and Panels 0 & 1
  //
  PcdSet32S (PcdTouchpadIrqGpio, GPIO_VER2_H_GPP_R12);  // Touch Pad Interrupt Pin
  PcdSetBoolS (PcdTouchpadIrqGpioPolarity, PIN_GPIO_ACTIVE_LOW);  // Touch Pad Interrupt pin polarity

  PcdSet32S (PcdTouchpanelIrqGpio, GPIO_VER2_H_GPP_J9);  // Touch 0 Interrupt Pin
  PcdSet32S (PcdTouchpanelPwrEnableGpio, GPIO_VER2_H_GPP_B18);  // Touch 0 power enable pin
  PcdSet32S (PcdTouchpanelRstGpio, GPIO_VER2_H_GPP_J8);  // Touch 0 reset pin
  PcdSetBoolS (PcdTouchpanelIrqGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 0 Interrupt Pin polarity
  PcdSetBoolS (PcdTouchpanelPwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 0 power enable pin polarity
  PcdSetBoolS (PcdTouchpanelRstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 0 reset pin polarity

  PcdSet32S (PcdTouchpanel1IrqGpio, GPIO_VER2_H_GPP_R10);  // Touch 1 Interrupt Pin
  PcdSet32S (PcdTouchpanel1PwrEnableGpio, GPIO_VER2_H_GPP_B14);  // Touch 1 power enable pin
  PcdSet32S (PcdTouchpanel1RstGpio, GPIO_VER2_H_GPP_D12);  // Touch 1 reset pin
  PcdSetBoolS (PcdTouchpanel1IrqGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 1 Interrupt Pin polarity
  PcdSetBoolS (PcdTouchpanel1PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 1 power enable pin polarity
  PcdSetBoolS (PcdTouchpanel1RstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);  // Touch 1 reset pin polarity

  //
  // WLAN
  //
  PcdSet32S (PcdWlanWakeGpio, GPIO_VER2_H_GPP_H5);  // WiFi wake pin
  PcdSet8S (PcdWlanRootPortNumber, 8);

  return;
}

/**
  Tbt init function for PEI post memory phase.
**/
VOID
TglHBoardTbtInit ( //@todo: need to add correct support for USB for TGL-H
  VOID
  )
{
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort0, USB_OC_SKIP);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort1, USB_OC_SKIP);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort2, USB_OC_SKIP);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort3, USB_OC_SKIP);

  //
  // Clear ALL port setting by default.
  //
  PcdSet8S (PcdCpuUsb30PortEnable, 0);

  PcdSet8S (PcdCpuUsb30OverCurrentPinPort0, 0);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort1, 1);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort2, 2);
  PcdSet8S (PcdCpuUsb30OverCurrentPinPort3, 3);

  PcdSet8S (PcdCpuUsb30PortEnable, 0x0F);
  PcdSet8S (PcdITbtRootPortNumber, 4);
}

/**
   Security GPIO init function for PEI post memory phase.
**/
VOID
TglHBoardSecurityInit (
  VOID
  )
{
  GPIO_PAD  GpioPad;
  UINT32    GpioIrqNumber;

  GpioPad = (GPIO_PAD) GPIO_VER2_H_GPP_B0;
  GpioGetPadIoApicIrqNumber (GpioPad, &GpioIrqNumber);

  DEBUG ((DEBUG_INFO, "TPM Interrupt Number: %d\n", GpioIrqNumber));
  PcdSet32S (PcdTpm2CurrentIrqNum, GpioIrqNumber);
}

/**
  Board Specific Init for PEI post memory phase.
**/
VOID
PeiTglHBoardSpecificInitPostMemNull (
  VOID
  )
{
}

/**
  Board's PCD function hook init function for PEI post memory phase.
**/
VOID
TglHBoardFunctionInit (
  VOID
)
{
  PcdSet32S (PcdFuncPeiBoardSpecificInitPostMem, (UINTN) PeiTglHBoardSpecificInitPostMemNull);
}

/**
  PMC-PD solution enable init lib
**/
VOID
TglHBoardPmcPdInit (
  VOID
  )
{
  PcdSetBoolS (PcdBoardPmcPdEnable, 1);
}

/**
  TypeC init function for before silicon init.
**/
VOID
TglHBoardTypeCPortMapping (
  VOID
  )
{
  //
  //   Board             Type C port     CPU Port    PCH Port    Split support
  //   TGL H DDR4             1            0            7            Yes
  //                          2            1            8            Yes
  //                          3            2            9            Yes
  //                          4            3           10            Yes
  PcdSetBoolS (PcdUsbTypeCSupport, TRUE);
  // Number of ports supported
  PcdSet8S (PcdTypeCPortsSupported, 4);
  // Type C port 1 mapping
  PcdSet8S (PcdUsbTypeCPort1, 0);
  PcdSet8S (PcdUsbTypeCPort1Pch, 7);
  PcdSet8S (PcdUsbCPort1Properties, (5 << 3 | USB_TYPEC_TBT << 1 | SPLIT_SUPPORTED));
  // Type C port 2 mapping
  PcdSet8S (PcdUsbTypeCPort2, 1);
  PcdSet8S (PcdUsbTypeCPort2Pch, 8);
  PcdSet8S (PcdUsbCPort2Properties, (5 << 3 | USB_TYPEC_TBT << 1 | SPLIT_SUPPORTED));
  // Type C port 3 mapping
  PcdSet8S (PcdUsbTypeCPort3, 2);
  PcdSet8S (PcdUsbTypeCPort3Pch, 9);
  PcdSet8S (PcdUsbCPort3Properties, (9 << 3 | USB_TYPEC_TBT << 1 | SPLIT_SUPPORTED));
  // Type C port 4 mapping
  PcdSet8S (PcdUsbTypeCPort4, 3);
  PcdSet8S (PcdUsbTypeCPort4Pch, 10);
  PcdSet8S (PcdUsbCPort4Properties, (9 << 3 | USB_TYPEC_TBT << 1 | SPLIT_SUPPORTED));
}

/**
  Configure GPIO, TouchPanel, HDA, PMC, TBT etc.

  @retval  EFI_SUCCESS   Operation success.
**/
EFI_STATUS
EFIAPI
TglHBoardInitBeforeSiliconInit (
  VOID
  )
{
  TglHGpioTableInit ();
  TglHTouchPanelGpioInit ();
  TglHHdaVerbTableInit ();
  TglHBoardMiscInit ();
  TglHBoardTbtInit ();
  TglHBoardFunctionInit();
  TglHBoardSecurityInit ();
  TglHBoardPmcPdInit ();
  TglHBoardTypeCPortMapping ();
  GpioInit (PcdGetPtr (PcdBoardGpioTable));
  ///
  /// Do Late PCH init
  ///
  LateSiliconInit ();

  return EFI_SUCCESS;
}

VOID
TglHBoardSpecificGpioInitPostMem (
  VOID
  )
{
  //
  // Update OEM table ID
  //
  PcdSet64S (PcdXhciAcpiTableSignature, SIGNATURE_64 ('x', 'h', '_', 't', 'h', 'd', 'd', '4'));

  //
  //Modify Preferred_PM_Profile field based on Board SKU's. Default is set to Mobile
  //
  PcdSet8S (PcdPreferredPmProfile, EFI_ACPI_2_0_PM_PROFILE_MOBILE);
  if (PcdGet8 (PcdPlatformFlavor) == FlavorUpServer) {
    PcdSet8S (PcdPreferredPmProfile, EFI_ACPI_2_0_PM_PROFILE_ENTERPRISE_SERVER);
  }

  //
  // Assign FingerPrint, Gnss, Bluetooth & TouchPanel relative GPIO.
  //
  PcdSet32S (PcdFingerPrintIrqGpio,   GPIO_VER2_H_GPP_I8);        // Finger Print Sensor Interrupt Pin
  PcdSet32S (PcdTouchpadIrqGpio,      GPIO_VER2_H_GPP_R12);       // Force Pad Interrupt Pin GPIO_VER2_H_GPP_J9
  PcdSet32S (PcdTouchpanelIrqGpio,    GPIO_VER2_H_GPP_J9);        // Touch Interrupt Pin
  PcdSet32S (PcdTouchpanel1IrqGpio,   GPIO_VER2_H_GPP_R10);       // Touch Interrupt Pin
  PcdSet32S (PcdHdaI2sCodecIrqGpio,   GPIO_VER2_H_GPP_C12);       // Audio I2S Codec IRQ Pin
  PcdSet8S  (PcdHdaI2sCodecI2cBusNumber,    0);                   // Audio I2S Codec conntected to I2C0
  PcdSet8S  (PcdBleUsbPortNumber,           2);                   // Bluetooth USB Port
  //
  // Configure GPIOs for BT modules - UART or USB
  //
  PcdSet32S (PcdBtRfKillGpio, GPIO_VER2_H_GPP_B3); // Bluetooth RF-KILL# pin
  if (PcdGet8 (PcdDiscreteBtModule) == 2) {          // Only for BT Over UART Selection
    PcdSet32S (PcdBtIrqGpio, GPIO_VER2_H_GPP_C2);  // Bluetooth IRQ Pin
  }

  PcdSet64S (PcdBoardRtd3TableSignature, SIGNATURE_64 ('T', 'g', 'l', 'H', '_', 'R', 'v', 'p'));
}

VOID
TglHInitCommonPlatformPcdPostMem (
  VOID
  )
{
  PcdSet32S (PcdEcSmiGpio, GPIO_VER2_H_GPP_E3);
  PcdSet32S (PcdEcLowPowerExitGpio, GPIO_VER2_H_GPP_B23);
  PcdSetBoolS (PcdPssReadSN, TRUE);
  PcdSet8S (PcdPssI2cSlaveAddress, 0x6E);
  PcdSet8S (PcdPssI2cBusNumber, 0x00);
  PcdSetBoolS (PcdSpdAddressOverride, FALSE);

  //
  // Battery Present
  // Real & Virtual battery needs to be supported in all except Desktop
  //
  PcdSet8S  (PcdBatteryPresent, BOARD_REAL_BATTERY_SUPPORTED);
  PcdSet8S (PcdRealBattery1Control, 1);
  PcdSet8S (PcdRealBattery2Control, 2);

  //
  // Sky Camera Sensor
  //
  PcdSetBoolS (PcdMipiCamSensor, FALSE);

  //
  // H8S2113 SIO
  //
  PcdSetBoolS (PcdH8S2113SIO, FALSE);

  //
  // NCT6776F COM, SIO & HWMON
  //
  PcdSetBoolS (PcdNCT6776FCOM, FALSE);
  PcdSetBoolS (PcdNCT6776FSIO, FALSE);
  PcdSetBoolS (PcdNCT6776FHWMON, FALSE);
  //
  // ZPODD
  //
  PcdSet8S (PcdZPoddConfig, 0);
  //
  // SMC Runtime Sci Pin
  // EC will use eSpi interface to generate SCI
  //
  PcdSet32S (PcdSmcRuntimeSciPin, (UINT32) GPIO_VER2_H_GPP_A11);
  //
  // Convertable Dock Support
  // Not supported only for S & H SKU's
  PcdSetBoolS (PcdConvertableDockSupport, TRUE);
  //
  // Ec Hotkey F3, F4, F5, F6, F7 and F8 Support
  //
  PcdSet8S (PcdEcHotKeyF3Support, TRUE);
  PcdSet8S (PcdEcHotKeyF4Support, TRUE);
  PcdSet8S (PcdEcHotKeyF5Support, TRUE);
  PcdSet8S (PcdEcHotKeyF6Support, TRUE);
  PcdSet8S (PcdEcHotKeyF7Support, TRUE);
  PcdSet8S (PcdEcHotKeyF8Support, TRUE);

  //
  // Virtual Button Volume Up & Done Support
  // Virtual Button Home Button Support
  // Virtual Button Rotation Lock Support
  //
  PcdSetBoolS (PcdVirtualButtonVolumeUpSupport, TRUE);
  PcdSetBoolS (PcdVirtualButtonVolumeDownSupport, TRUE);
  PcdSetBoolS (PcdVirtualButtonHomeButtonSupport, TRUE);
  PcdSetBoolS (PcdVirtualButtonRotationLockSupport, TRUE);
  //
  // Slate Mode Switch Support
  //
  PcdSetBoolS (PcdSlateModeSwitchSupport, TRUE);
  //
  // Virtual Gpio Button Support
  //
  PcdSetBoolS (PcdVirtualGpioButtonSupport, TRUE);
  //
  // Ac Dc Auto Switch Support
  //
  PcdSetBoolS (PcdAcDcAutoSwitchSupport, FALSE);

  //
  // Pm Power Button Gpio Pin
  //
  PcdSet32S (PcdPmPowerButtonGpioPin, GPIO_VER2_H_GPD3);
  //
  // Acpi Enable All Button Support
  //
  PcdSetBoolS (PcdAcpiEnableAllButtonSupport, TRUE);
  //
  // Acpi Hid Driver Button Support
  //
  PcdSetBoolS (PcdAcpiHidDriverButtonSupport, TRUE);
}

/**
  Board init for PEI after Silicon initialized

  @retval  EFI_SUCCESS   Operation success.
**/EFI_STATUS
EFIAPI
TglHBoardInitAfterSiliconInit (
  VOID
  )
{
  DEBUG ((DEBUG_INFO, "TglHBoardInitAfterSiliconInit \n"));
  TglHBoardSpecificGpioInitPostMem ();
  TglHInitCommonPlatformPcdPostMem ();
  return EFI_SUCCESS;
}
