/** @file
 Source code for the board SA configuration Pcd init functions in Pre-Memory init phase.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include "BoardSaConfigPreMem.h"
#include <Library/CpuPlatformLib.h>
#include <Pins/GpioPinsVer2Lp.h>
#include <PlatformBoardId.h>
#include <Library/PreSiliconEnvDetectLib.h>
#include <PlatformBoardConfig.h>
#include <Library/PcdLib.h>

/**
  MRC configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglUSaMiscConfigInit (
  VOID
  )
{
  PcdSet8S (PcdSaMiscUserBd, 5);
  PcdSet16S (PcdSaDdrFreqLimit, 0);

  return;
}

/**
  Board Memory Init related configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglUMrcConfigInit (
  VOID
  )
{
  UINT16    BoardId;
  UINT16    BomId;
  BOOLEAN   ExternalSpdPresent;

  BoardId = PcdGet16(PcdBoardId);
  BomId   = PcdGet16(PcdBoardBomId);

  if (IsSimicsEnvironment()) {
    // Simics will use DDR4 boards that have external SPD on UDIMM/SO-DIMM
    ExternalSpdPresent = TRUE;
  } else {
    ExternalSpdPresent = PcdGetBool (PcdSpdPresent);
  }

  // Check for external SPD presence on LPDDR4 boards
  if (ExternalSpdPresent){
    switch (BoardId) {
      case BoardIdTglUDdr4:
        PcdSet8S (PcdMrcSpdAddressTable0, 0xA0);
        PcdSet8S (PcdMrcSpdAddressTable1, 0xA2);
        PcdSet8S (PcdMrcSpdAddressTable2, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable3, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable4, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable5, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable6, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable7, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable8, 0xA4);
        PcdSet8S (PcdMrcSpdAddressTable9, 0xA6);
        PcdSet8S (PcdMrcSpdAddressTable10, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable11, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable12, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable13, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable14, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable15, 0x0);
        if (BomId == BomIdTglUDdr4TInterposer) {
          PcdSet8S (PcdMrcSpdAddressTable0, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable1, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable2, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable3, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable4, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable5, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable6, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable7, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable8, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable9, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable10, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable11, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable12, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable13, 0x0);
          PcdSet8S (PcdMrcSpdAddressTable14, 0xA8);
          PcdSet8S (PcdMrcSpdAddressTable15, 0x0);
        }
        break;

      case BoardIdTglULp4Type4:
      case BoardIdTglULp5Type4:
      case BoardIdTglULp4Exs:
        PcdSet8S (PcdMrcSpdAddressTable0, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable1, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable2, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable3, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable4, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable5, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable6, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable7, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable8, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable9, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable10, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable11, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable12, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable13, 0x0);
        PcdSet8S (PcdMrcSpdAddressTable14, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable15, 0x0);
        break;
      case BoardIdTglULp4Aep:
      case BoardIdTglULp4Dg1Aep:
      case BoardIdTglULp4Gcs:
        // Assume SPD comes from external EEPROM
        PcdSet8S (PcdMrcSpdAddressTable0, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable1, 0x00);
        PcdSet8S (PcdMrcSpdAddressTable2, 0xA8);
        PcdSet8S (PcdMrcSpdAddressTable3, 0x00);
        break;
      default:
        break;
    }
  } else {
    // Use internal SPD table if external is not present
    PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp8Gb200bSpd);
    PcdSet8S (PcdMrcSpdAddressTable0, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable1, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable2, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable3, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable4, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable5, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable6, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable7, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable8, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable9, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable10, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable11, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable12, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable13, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable14, 0x00);
    PcdSet8S (PcdMrcSpdAddressTable15, 0x00);
  }

  // Setting the default DQ Byte Map. It may be overriden to board specific settings below.
  PcdSet32S (PcdMrcDqByteMap, (UINTN) DqByteMapTglU);
  PcdSet16S (PcdMrcDqByteMapSize, sizeof (DqByteMapTglU));

  // ICL uses the same RCOMP resistors for all DDR types
  PcdSet32S (PcdMrcRcompResistor, (UINTN) TglURcompResistorZero);

  // Use default RCOMP target values for all boards
  PcdSet32S (PcdMrcRcompTarget, (UINTN) RcompTargetTglU);

  // Default is NIL
  PcdSetBoolS (PcdMrcDqPinsInterleavedControl, TRUE);
  PcdSetBoolS (PcdMrcDqPinsInterleaved, FALSE);

  // SPD is the same size for all boards
  PcdSet16S (PcdMrcSpdDataSize, sizeof (mLpddr4Ddp8Gb200bSpd));
  // DqsMapCpu2Dram is the same size for all boards
  PcdSet16S (PcdMrcDqsMapCpu2DramSize, sizeof (DqsMapCpu2DramTglULp4Type4Rvp));
  // DqMapCpu2Dram is the same size for all boards
  //PcdSet16S (PcdMrcDqMapCpu2DramSize, sizeof (DqMapCpu2DramTglULp4Type4));

  switch (BoardId) {
    case BoardIdTglULp4Type4:
    case BoardIdTglULp4Exs:
      PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramTglULp4Type4Rvp);
      PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp16Gb200b1rSpd);
      break;
    case BoardIdTglULp5Type4:
      PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramTglULp5Type4Rvp);
      PcdSet32S (PcdMrcDqMapCpu2Dram, (UINTN) DqMapCpu2DramTglULp5Type4);
      PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr5xQdp12Gb496bSpd);
      PcdSet8 (PcdMrcSafeMode, 1);
      PcdSet8 (PcdMrcSafeConfig, 1);
      break;
    case BoardIdTglULp4Aep:
      PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramBoardIdTglULp4Aep);
      PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4xDdp16Gb200bSpd);
      break;
    case BoardIdTglULp4Dg1Aep:
      PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramBoardIdTglULp4Dg1Aep);
      //PcdSet32S (PcdMrcDqMapCpu2Dram, (UINTN) DqMapCpu2DramBoardIdTglULp4Dg1Aep);
      PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp16Gb200b1r4267Spd);
      break;
    case BoardIdTglULp4Gcs:
      PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramBoardIdTglULp4Gcs);
      PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp16Gb200b1r4200Spd);
      break;
    case BoardIdTglUDdr4:
      PcdSet8 (PcdMrcSaGv, 5);
      PcdSet8 (PcdMrcDCC, 1);
      if (BomId == BomIdTglUDdr4TInterposer) {
        PcdSet32S (PcdMrcDqsMapCpu2Dram, (UINTN) DqsMapCpu2DramTglUDdr4Interposer);
        PcdSet32S (PcdMrcSpdData, (UINT32)(VOID *) &mLpddr4Ddp16Gb200b1rSpd);
      }
      break;
  }
  //
  // CA Vref routing: board-dependent
  // 0 - VREF_CA goes to both CH_A and CH_B (LPDDR3/DDR3L)
  // 1 - VREF_CA to CH_A, VREF_DQ_A to CH_B (should not be used)
  // 2 - VREF_CA to CH_A, VREF_DQ_B to CH_B (DDR4)
  //
  // Set it to 2 for all our DDR4 boards; it is ignored for LPDDR4
  //
  PcdSet8S (PcdMrcCaVrefConfig, 2);

  return;
}

/**
  Board SA related GPIO configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglUSaGpioConfigInit (
  VOID
  )
{
  UINT16    BoardId;
  BoardId = PcdGet16(PcdBoardId);
  //
  // Assigning default values to PCIE RTD3 GPIOs
  //
  switch (BoardId) {
    case BoardIdTglUDdr4:
    case BoardIdTglULp4Type4:
    case BoardIdTglULp4Exs:
    case BoardIdTglULp4Aep:
    case BoardIdTglULp4Dg1Aep:
    case BoardIdTglULp4Gcs:
      PcdSetBoolS(PcdPcieSlot1HoldRstGpioPolarity, PIN_GPIO_ACTIVE_LOW);
      PcdSetBoolS(PcdPcieSsd2RstGpioPolarity, PIN_GPIO_ACTIVE_LOW);
      break;
    case BoardIdTglULp5Type4:
      PcdSetBoolS(PcdPcieSlot1HoldRstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
      PcdSetBoolS(PcdPcieSsd2RstGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
      break;
    default:
      break;
  }

  switch (BoardId) {
    case BoardIdTglUDdr4:
    case BoardIdTglULp4Type4:
    case BoardIdTglULp4Exs:
    case BoardIdTglULp5Type4:
    case BoardIdTglULp4Aep:
    case BoardIdTglULp4Dg1Aep:
    case BoardIdTglULp4Gcs:
      PcdSet8S(PcdRootPortIndex, 4);
      PcdSet8S(PcdPcieSlot1GpioSupport, PchGpio);
      PcdSet8S(PcdPcieSlot1HoldRstExpanderNo, 0);
      PcdSet32S(PcdPcieSlot1HoldRstGpioNo, GPIO_VER2_LP_GPP_C13);
      PcdSet8S(PcdPcieSlot1PwrEnableExpanderNo, 0);
      PcdSet32S(PcdPcieSlot1PwrEnableGpioNo, GPIO_VER2_LP_GPP_A14);
      PcdSetBoolS(PcdPcieSlot1PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_LOW);

      //
      // Configure CPU M.2 SSD GPIO PCDs
      //
      PcdSet32S(PcdPcieSsd2PwrEnableGpioNo, GPIO_VER2_LP_GPP_D16);
      PcdSet32S(PcdPcieSsd2RstGpioNo, GPIO_VER2_LP_GPP_A11);
      PcdSetBoolS(PcdPcieSsd2PwrEnableGpioPolarity, PIN_GPIO_ACTIVE_HIGH);
      break;
  }

  //
  // PEG PCIE RTD3 GPIO
  //
  PcdSet8S(PcdPcie0GpioSupport, PchGpio);
  PcdSet8S(PcdPcie0HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie0HoldRstGpioNo, GPIO_VER2_LP_GPP_C13);
  PcdSetBoolS(PcdPcie0HoldRstActive, FALSE);
  PcdSet8S(PcdPcie0PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie0PwrEnableGpioNo, GPIO_VER2_LP_GPP_A14);
  PcdSetBoolS(PcdPcie0PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie1GpioSupport, NotSupported);
  PcdSet8S(PcdPcie1HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie1HoldRstGpioNo, 0);
  PcdSetBoolS(PcdPcie1HoldRstActive, FALSE);
  PcdSet8S(PcdPcie1PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie1PwrEnableGpioNo, 0);
  PcdSetBoolS(PcdPcie1PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie2GpioSupport, NotSupported);
  PcdSet8S(PcdPcie2HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie2HoldRstGpioNo, 0);
  PcdSetBoolS(PcdPcie2HoldRstActive, FALSE);
  PcdSet8S(PcdPcie2PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie2PwrEnableGpioNo, 0);
  PcdSetBoolS(PcdPcie2PwrEnableActive, FALSE);

  PcdSet8S(PcdPcie3GpioSupport, NotSupported);
  PcdSet8S(PcdPcie3HoldRstExpanderNo, 0);
  PcdSet32S(PcdPcie3HoldRstGpioNo, 0);
  PcdSetBoolS(PcdPcie3HoldRstActive, FALSE);
  PcdSet8S(PcdPcie3PwrEnableExpanderNo, 0);
  PcdSet32S(PcdPcie3PwrEnableGpioNo, 0);
  PcdSetBoolS(PcdPcie3PwrEnableActive, FALSE);
  return;
}

/**
  SA Display DDI configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval     VOID
**/
VOID
TglUSaDisplayConfigInit (
  VOID
  )
{
  UINT16    BoardId;
  UINT16    BomId;

  BoardId = PcdGet16(PcdBoardId);
  BomId = PcdGet16(PcdBoardBomId);

  switch (BoardId) {
    case BoardIdTglUDdr4:
      if (BomId == BomIdTglUDdr4DualEdp) {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUDualEdpDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUDualEdpDisplayDdiConfig));
      } else {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUDdr4RowDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUDdr4RowDisplayDdiConfig));
      }
      break;
    case BoardIdTglULp4Aep:
    case BoardIdTglULp4Gcs:
      PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUAepLp4xRowDisplayDdiConfig);
      PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUAepLp4xRowDisplayDdiConfig));
      break;
    case BoardIdTglULp4Dg1Aep:
      PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUDg1Lp4xRowDisplayDdiConfig);
      PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUDg1Lp4xRowDisplayDdiConfig));
      break;
    case BoardIdTglULp4Type4:
    case BoardIdTglULp4Exs:
      if (BomId == BomIdTglULpDdr4DualEdp) {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUDualEdpDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUDualEdpDisplayDdiConfig));
      } else {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglULpDdr4RowDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglULpDdr4RowDisplayDdiConfig));
      }
      break;
    case BoardIdTglULp5Type4:
      if (BomId == BomIdTglULpDdr5DualEdp) {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglUDualEdpDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglUDualEdpDisplayDdiConfig));
      } else if (BomId == BomIdTglULpDdr5MipiOnDdiA) {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglULpDdr5MipiDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglULpDdr5MipiDisplayDdiConfig));
      } else {
        PcdSet32S (PcdSaDisplayConfigTable, (UINTN) mTglULpDdr5RowDisplayDdiConfig);
        PcdSet16S (PcdSaDisplayConfigTableSize, sizeof (mTglULpDdr5RowDisplayDdiConfig));
      }
      break;
    default:
      break;
  }
  return;
}

/**
  Board USB related configuration init function for PEI pre-memory phase.

  @param[in]  VOID

  @retval VOID
**/
VOID
TglUSaUsbConfigInit (
  VOID
  )
{
  PcdSet8S (PcdCpuUsb30PortEnable, 0x0F);

  return;
}
