/** @file
  DXE Multi-Board Initilialization Library

@copyright
  INTEL CONFIDENTIAL
  Copyright 2018 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include <Uefi.h>
#include <Library/BaseLib.h>
#include <Library/DebugLib.h>
#include <Library/MultiBoardInitSupportLib.h>
#include <PlatformBoardId.h>

EFI_STATUS
EFIAPI
TglYBoardInitAfterPciEnumeration (
  VOID
  );

EFI_STATUS
EFIAPI
TglYBoardInitReadyToBoot (
  VOID
  );

EFI_STATUS
EFIAPI
TglYBoardInitEndOfFirmware (
  VOID
  );

BOARD_NOTIFICATION_INIT_FUNC mTglYBoardDxeInitFunc = {
  TglYBoardInitAfterPciEnumeration,
  TglYBoardInitReadyToBoot,
  TglYBoardInitEndOfFirmware
};

/**
  The constructor determines which board init functions should be registered.

  @param  ImageHandle   The firmware allocated handle for the EFI image.
  @param  SystemTable   A pointer to the EFI System Table.

  @retval EFI_SUCCESS   The constructor always returns EFI_SUCCESS.

**/
EFI_STATUS
EFIAPI
DxeTglYMultiBoardInitLibConstructor (
  IN EFI_HANDLE        ImageHandle,
  IN EFI_SYSTEM_TABLE  *SystemTable
  )
{
  if (LibPcdGetSku () == SkuIdTglY){
    DEBUG ((DEBUG_INFO, "SKU_ID: 0x%x\n", LibPcdGetSku()));
    return RegisterBoardNotificationInit (&mTglYBoardDxeInitFunc);
  }
  return EFI_SUCCESS;
}
