/** @file
  Declares the interface for TbtNvmDrvHr class.
  This class represents TBT HR abstraction.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:

**/
#ifndef TBT_NVM_DRV_HR_
#define TBT_NVM_DRV_HR_

#include <Protocol/PciIo.h>
#include "TbtNvmDrvUtils.h"


typedef struct _TBT_HR TBT_HR;

typedef struct _TBT_HR_IMPL TBT_HR_IMPL;

typedef
TBT_STATUS
(*WRITE_CIO_DEV_REG) (
  IN TBT_HR   *This,
  IN UINT16   RegNum,
  IN UINT8    Length,
  IN UINT32*  Data
  );

typedef
TBT_STATUS
(*READ_CIO_DEV_REG) (
  IN TBT_HR   *This,
  IN UINT16   RegNum,
  OUT UINT32  *Data
  );

typedef
VOID
(*TBT_HR_DTOR) (
  IN TBT_HR   *This
  );

typedef
TBT_STATUS
(*FORCE_PWR_HR) (
  IN EFI_PCI_IO_PROTOCOL *PciIoProto,
  IN BOOLEAN             Enable
  );

TBT_HR*
TbtNvmDrvHrCtor (
  IN PCIE_BDF     PcieBdf,
  IN FORCE_PWR_HR ForcePwrFunc OPTIONAL
  );

struct _TBT_HR {
  TBT_HR_IMPL       *Impl;
  WRITE_CIO_DEV_REG WriteCioDevReg;
  READ_CIO_DEV_REG  ReadCioDevReg;
  TBT_HR_DTOR       Dtor;
};

#endif /* TBT_NVM_DRV_HR_ */
