/** @file
  Driver responsibilities:
  -- Implement UEFI interface to the program.
  -- Execute common NVM update flow.
  -- Delete all the acquired resources.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:

**/

#ifndef TBT_NVM_DRV_MAIN_
#define TBT_NVM_DRV_MAIN_


#include "TcI2cmDrvUtils.h"
#include "TcI2cmDrvDevice.h"

/**
  Sends IECS command and waits for completion.

  @param[in]  DevCom  Pointer to the device interface.
  @param[in]  Cmd     IECS CMD to send.

  @retval  TBT_STATUS_SUCCESS                Command was successefully send.
  @retval  TBT_STATUS_NON_RECOVERABLE_ERROR  A device error has accured.
  @retval  TBT_STATUS_RETRY                  LC reported error, the command might be retried.
**/
TBT_STATUS
TbtNvmDrvSendCmd (
  IN TARGET_DEVICE *DevCom,
  IN UINT32        Cmd
  );

#endif /* TBT_NVM_DRV_MAIN_ */
