/** @file
  This used to configure the TBT NVM update driver for retimers.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:

**/

#ifndef TBT_NVM_DRV_LOADER_
#define TBT_NVM_DRV_LOADER_

#include <Uefi.h>

#include "TcI2cmDrvRetimerThruHr.h"

/**
  The following should be defined for the driver to be functional
    Retimer guid
    Connection type
      if Connection type is I2C:
        Target bus number of I2C controller and slave addresse
      Else if it is thru TBT:
        yfl bdf
        port num
        retimer index
*/

/* Target device GUID */
CONST EFI_GUID TBT_RETIMER_GUID = { 0xeed54281, 0x1c11, 0x4358,{ 0xbf, 0x5a, 0xf6, 0x49, 0x95, 0xfb, 0xf1, 0x1b } };

/* TBT DMA bdf through which the update to the target retimer should be performed */
CONST PCIE_BDF TBT_DMA_BDF = {0x0, 0xd, 0x2};

/* Which DN port is connected to the target retimer's path */
CONST DN_PORT TBT_DN_PORT = PORT_PA;

/* Target retimer's index on the path */
CONST RETIMER_INDEX TBT_RETIMER_INDEX = FIRST_RETIMER;

/* Target retimer's slave address on I2C */
CONST UINT8 TBT_RETIMER_SLAVE_ADDR = 0x57; //0x55 - 0x57

/* Target bus number of I2C controller */
CONST UINT8 I2C_BUS_NUMBER = 0x0;

#endif // TBT_NVM_DRV_LOADER_
