/** @file
  This is file contain Opregion definition for DG1.
  Software SCI interface between system BIOS, ASL code, and Graphics drivers.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

  @par Specification Reference:
  - OpRegion / Software SCI SPEC
**/
#ifndef _DG1_OPREGION_H_
#define _DG1_OPREGION_H_

/**
  OpRegion structures:
  Sub-structures define the different parts of the OpRegion followed by the
  main structure representing the entire OpRegion.

  @note These structures are packed to 1 byte offsets because the exact
  data location is required by the supporting design specification due to
  the fact that the data is used by ASL and Graphics driver code compiled
  separately.
**/
#pragma pack(1)
///
/// OpRegion Mailbox 0 Header structure. The OpRegion Header is used to
/// identify a block of memory as the graphics driver OpRegion.
/// Offset 0x0, Size 0x100
///
typedef struct {
  CHAR8  SIGN[0x10];    ///< Offset 0x00 OpRegion Signature
  UINT32 SIZE;          ///< Offset 0x10 OpRegion Size
  UINT32 OVER;          ///< Offset 0x14 OpRegion Structure Version
  UINT8  SVER[0x20];    ///< Offset 0x18 System BIOS Build Version
  UINT8  VVER[0x10];    ///< Offset 0x38 Video BIOS Build Version
  UINT8  GVER[0x10];    ///< Offset 0x48 Graphic Driver Build Version
  UINT32 MBOX;          ///< Offset 0x58 Supported Mailboxes
  UINT32 DMOD;          ///< Offset 0x5C Driver Model
  UINT32 PCON;          ///< Offset 0x60 Platform Configuration
  CHAR16 DVER[0x10];    ///< Offset 0x64 GOP Version
  UINT8  RM01[0x7C];    ///< Offset 0x84 Reserved Must be zero
} DG1_OPREGION_HEADER;

///
/// OpRegion Mailbox 1 - Public ACPI Methods
/// Offset 0x100, Size 0x100
///
typedef struct {
  UINT8  RSVD[0x100];    ///< Offset 0x100 - 0x1FF  BIOS does not uses this section of OpRegion
} DG1_OPREGION_MBOX1;

///
/// OpRegion Mailbox 2 - Software SCI Interface
/// Offset 0x200, Size 0x100
///
typedef struct {
  UINT8  UNUSED[0x100];   ///< Offset 0x200 - 0x2FF  Obselete in DG1
} DG1_OPREGION_MBOX2;

///
/// OpRegion Mailbox 3 - BIOS/Driver Notification - ASLE Support
/// Offset 0x300, Size 0x100
///
typedef struct {
  UINT8  RSVD[0xC6];    ///< Offset 0x300 - 0x3C5  BIOS does not uses this section of OpRegion
  UINT8  VRSR;          ///< Offset 0x3C6 VRAM SR supported by driver.
  UINT8  RM32[0x39];    ///< Offset 0x3C7 - 0x3FF  Reserved Must be zero.
} DG1_OPREGION_MBOX3;

///
/// OpRegion Mailbox 4 - VBT Video BIOS Table
/// Offset 0x400, Size 0x1800
///
typedef struct {
  UINT8  RVBT[0x1800];  ///< Offset 0x400 - 0x1BFF Raw VBT Data
} DG1_OPREGION_MBOX4;

///
/// OpRegion Mailbox 5 - BIOS/Driver Notification - Data storage BIOS to Driver data sync
/// Offset 0x1C00, Size 0x400
///
typedef struct {
  UINT8  RSVD[0x400];    ///< Offset 0x1C00 - 0x1FFF  BIOS does not uses this section of OPRegion
} DG1_OPREGION_MBOX5;

///
/// DG1 OpRegion Structure
///
typedef struct {
  DG1_OPREGION_HEADER Header; ///< OpRegion header (Offset 0x0, Size 0x100)
  DG1_OPREGION_MBOX1  MBox1;  ///< Mailbox 1: Public ACPI Methods (Offset 0x100, Size 0x100)
  DG1_OPREGION_MBOX2  Mbox2;  ///< Mailbox 2: Obselete in DG1
  DG1_OPREGION_MBOX3  MBox3;  ///< Mailbox 3: BIOS to Driver Notification (Offset 0x300, Size 0x100)
  DG1_OPREGION_MBOX4  MBox4;  ///< Mailbox 4: Video BIOS Table (VBT) (Offset 0x400, Size 0x1800)
  DG1_OPREGION_MBOX5  MBox5;  ///< Mailbox 5: BIOS to Driver Notification Extension (Offset 0x1C00, Size 0x400)
} DG1_OPREGION_STRUCTURE;
#pragma pack()

///
/// DG1 OpRegion Protocol
///
typedef struct {
  DG1_OPREGION_STRUCTURE  *OpRegion; ///< DG1 Operation Region Structure
} DG1_OPREGION_PROTOCOL;

#define R_SA_DG1_ASLS_OFFSET       0x00FC  ///< ASL Storage
#define CONFIG_DATA_OFFSET         0x1A    ///< OpRegion start offset from the base of OpRom
#define ROM_SIZE_OFFSET            0x02    ///< ROM image size offset from the base of OpRom
#define DG1_DEVICE_ID              0x4905  ///< Native Device Id for DG1 card in motherboard down configuration

/**
  Check if the device id is DG1

  @param[in] UINT16      DeviceId

  @retval    BOOLEAN     TRUE if DG1 DeviceId , FALSE otherwise.

**/
BOOLEAN
IsDg1Device (
  IN UINT16  DeviceId
  );
#endif
