/** @file
  This file contains HD Audio NHLT Configuration BLOBs

@copyright
  INTEL CONFIDENTIAL
  Copyright 2015 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

//
// TGL NHLT Configuration BLOBs
//

#include "NhltEndpoints.h"

//
// DMIC Configuration BLOBs
//
// DMIC Config 2 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo16BitFormatConfig[] =
{
  0x00000001, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000003, 0x00000003, 0x00300003, 0x00300003, 0x00000003, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19,
  0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572,
  0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103,
  0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008,
  0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223,
  0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC,
  0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76,
  0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF,
  0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E,
  0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB,
  0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF,
  0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367,
  0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367,
  0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF,
  0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB,
  0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E,
  0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF,
  0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76,
  0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 2 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicStereo32BitFormatConfig[] =
{
  0x00000001, 0xFFFFFF10, 0xFFFFFF10, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000003, 0x00000003, 0x00380003, 0x00380003, 0x00000003, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19,
  0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572,
  0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103,
  0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008,
  0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223,
  0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC,
  0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76,
  0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF,
  0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E,
  0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB,
  0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF,
  0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367,
  0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367,
  0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF,
  0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB,
  0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E,
  0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF,
  0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76,
  0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 4 channels, 16 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad16BitFormatConfig[] =
{
  0x00000001, 0xFFFF3210, 0xFFFF3210, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000003, 0x00000003, 0x00320003, 0x00320003, 0x00000003, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19,
  0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572,
  0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103,
  0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008,
  0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223,
  0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC,
  0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76,
  0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF,
  0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E,
  0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB,
  0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF,
  0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367,
  0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367,
  0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF,
  0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB,
  0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E,
  0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF,
  0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76,
  0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 4 channels, 32 bits, 2.4Mhz BCLK
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicQuad32BitFormatConfig[] =
{
  0x00000001, 0xFFFF3210, 0xFFFF3210, 0xFFFFFFFF, 0xFFFFFFFF, 0x00000003, 0x00000003, 0x003A0003, 0x003A0003, 0x00000003, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19,
  0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C, 0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572,
  0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4, 0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103,
  0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5, 0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008,
  0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82, 0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223,
  0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102, 0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC,
  0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8, 0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76,
  0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567, 0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF,
  0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975, 0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E,
  0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42, 0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB,
  0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3, 0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF,
  0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799, 0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367,
  0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687, 0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367,
  0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5, 0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF,
  0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8, 0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB,
  0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F, 0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E,
  0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD, 0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF,
  0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2, 0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76,
  0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A, 0xB9C00018, 0xBA00001B, 0x0000C001, 0x0B001803, 0x00000000, 0x00000E03, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000091, 0x00010076, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000091, 0x000501E8, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x40000049, 0x40400181, 0x4080036D, 0x40C00453, 0x41000278, 0x414FFF19, 0x418FFDED, 0x41C00037, 0x42000245, 0x4240008C,
  0x428FFD9B, 0x42CFFE9D, 0x4300026C, 0x43400267, 0x438FFDB1, 0x43CFFC25, 0x4400016F, 0x44400521, 0x448FFFF3, 0x44CFF9C4, 0x450FFDF9, 0x454006BF, 0x4580048E, 0x45CFF973, 0x460FF896, 0x46400572, 0x46800A69, 0x46CFFCCF, 0x470FF2D1, 0x474FFFA4,
  0x47800F25, 0x47C004FC, 0x480FF013, 0x484FF593, 0x48800F33, 0x48C01068, 0x490FF375, 0x494FE999, 0x498007A2, 0x49C01B90, 0x4A0FFF65, 0x4A4FE0C2, 0x4A8FF799, 0x4AC02092, 0x4B0012C4, 0x4B4FE103, 0x4B8FE22C, 0x4BC019F2, 0x4C0028A3, 0x4C4FEEF5,
  0x4C8FCE29, 0x4CC00484, 0x4D003840, 0x4D400B2C, 0x4D8FC55E, 0x4DCFE2E9, 0x4E0037F5, 0x4E402FF8, 0x4E8FD092, 0x4ECFBDE1, 0x4F0020DD, 0x4F405218, 0x4F8FF44F, 0x4FCFA2B2, 0x500FF04D, 0x50406008, 0x50802D78, 0x50CFA580, 0x510FB354, 0x51404A82,
  0x518069A2, 0x51CFD000, 0x520F7EF5, 0x52400B5C, 0x52808ECF, 0x52C02152, 0x530F70DC, 0x534FAD96, 0x53807F06, 0x53C082C7, 0x540FA30A, 0x544F538D, 0x548028C1, 0x54C0C814, 0x55001B21, 0x554F3223, 0x558F9741, 0x55C0B6F2, 0x5600B687, 0x564F8102,
  0x568F0843, 0x56C02534, 0x57011C19, 0x5740507E, 0x578EEE24, 0x57CF2CFD, 0x5800C91C, 0x58414771, 0x588FC601, 0x58CE79BA, 0x590F6E6B, 0x59415EBE, 0x59817000, 0x59CF5B76, 0x5A0DF777, 0x5A4F51AC, 0x5A81CF09, 0x5AC23653, 0x5B0FCE37, 0x5B4D3DA8,
  0x5B8D65B8, 0x5BC050EF, 0x5C038E37, 0x5C44E2B2, 0x5C8411A5, 0x5CC259A3, 0x5D00F248, 0x5D403F0E, 0x5D800839, 0x8000001B, 0x80400018, 0x8080000A, 0x80CFFFD7, 0x810FFF67, 0x814FFEA2, 0x818FFD76, 0x81CFFBDD, 0x820FF9E2, 0x824FF7A8, 0x828FF567,
  0x82CFF36C, 0x830FF20B, 0x834FF197, 0x838FF24A, 0x83CFF43B, 0x840FF751, 0x844FFB3F, 0x848FFF88, 0x84C00392, 0x850006C0, 0x8540088B, 0x858008A2, 0x85C006FD, 0x860003E9, 0x864FFFFC, 0x868FFBFF, 0x86CFF8C8, 0x870FF70F, 0x874FF745, 0x878FF975,
  0x87CFFD3D, 0x880001DA, 0x8840064C, 0x8880098F, 0x88C00AD0, 0x890009A4, 0x89400627, 0x898000FF, 0x89CFFB43, 0x8A0FF63C, 0x8A4FF326, 0x8A8FF2DD, 0x8ACFF5A5, 0x8B0FFB11, 0x8B40020C, 0x8B80090E, 0x8BC00E72, 0x8C0010D3, 0x8C400F69, 0x8C800A42,
  0x8CC0024F, 0x8D0FF93E, 0x8D4FF120, 0x8D8FEBF1, 0x8DCFEB25, 0x8E0FEF3D, 0x8E4FF79D, 0x8E800296, 0x8EC00DBD, 0x8F00166D, 0x8F401A67, 0x8F80185F, 0x8FC01061, 0x900003E4, 0x904FF58F, 0x908FE8AB, 0x90CFE066, 0x910FDF12, 0x914FE583, 0x918FF2C3,
  0x91C00427, 0x920015D6, 0x92402399, 0x928029D9, 0x92C02684, 0x930019AA, 0x934005A6, 0x938FEEB6, 0x93CFDA21, 0x940FCD09, 0x944FCB2C, 0x948FD5E8, 0x94CFEBB1, 0x95000838, 0x95402531, 0x95803BAF, 0x95C045B6, 0x96003FC0, 0x964029C6, 0x96800799,
  0x96CFE04C, 0x970FBCDB, 0x974FA63A, 0x978FA339, 0x97CFB6AF, 0x980FDE6D, 0x98401333, 0x988049D5, 0x98C0755A, 0x990089C4, 0x99407EED, 0x998052D5, 0x99C00AE7, 0x9A0FB3CC, 0x9A4F5FB8, 0x9A8F2367, 0x9ACF1259, 0x9B0F3AEA, 0x9B4FA313, 0x9B804687,
  0x9BC1168B, 0x9C01FBBC, 0x9C42D96F, 0x9C839233, 0x9CC40C98, 0x9D04376B, 0x9D440C98, 0x9D839233, 0x9DC2D96F, 0x9E01FBBC, 0x9E41168B, 0x9E804687, 0x9ECFA313, 0x9F0F3AEA, 0x9F4F1259, 0x9F8F2367, 0x9FCF5FB8, 0xA00FB3CC, 0xA0400AE7, 0xA08052D5,
  0xA0C07EED, 0xA10089C4, 0xA140755A, 0xA18049D5, 0xA1C01333, 0xA20FDE6D, 0xA24FB6AF, 0xA28FA339, 0xA2CFA63A, 0xA30FBCDB, 0xA34FE04C, 0xA3800799, 0xA3C029C6, 0xA4003FC0, 0xA44045B6, 0xA4803BAF, 0xA4C02531, 0xA5000838, 0xA54FEBB1, 0xA58FD5E8,
  0xA5CFCB2C, 0xA60FCD09, 0xA64FDA21, 0xA68FEEB6, 0xA6C005A6, 0xA70019AA, 0xA7402684, 0xA78029D9, 0xA7C02399, 0xA80015D6, 0xA8400427, 0xA88FF2C3, 0xA8CFE583, 0xA90FDF12, 0xA94FE066, 0xA98FE8AB, 0xA9CFF58F, 0xAA0003E4, 0xAA401061, 0xAA80185F,
  0xAAC01A67, 0xAB00166D, 0xAB400DBD, 0xAB800296, 0xABCFF79D, 0xAC0FEF3D, 0xAC4FEB25, 0xAC8FEBF1, 0xACCFF120, 0xAD0FF93E, 0xAD40024F, 0xAD800A42, 0xADC00F69, 0xAE0010D3, 0xAE400E72, 0xAE80090E, 0xAEC0020C, 0xAF0FFB11, 0xAF4FF5A5, 0xAF8FF2DD,
  0xAFCFF326, 0xB00FF63C, 0xB04FFB43, 0xB08000FF, 0xB0C00627, 0xB10009A4, 0xB1400AD0, 0xB180098F, 0xB1C0064C, 0xB20001DA, 0xB24FFD3D, 0xB28FF975, 0xB2CFF745, 0xB30FF70F, 0xB34FF8C8, 0xB38FFBFF, 0xB3CFFFFC, 0xB40003E9, 0xB44006FD, 0xB48008A2,
  0xB4C0088B, 0xB50006C0, 0xB5400392, 0xB58FFF88, 0xB5CFFB3F, 0xB60FF751, 0xB64FF43B, 0xB68FF24A, 0xB6CFF197, 0xB70FF20B, 0xB74FF36C, 0xB78FF567, 0xB7CFF7A8, 0xB80FF9E2, 0xB84FFBDD, 0xB88FFD76, 0xB8CFFEA2, 0xB90FFF67, 0xB94FFFD7, 0xB980000A,
  0xB9C00018, 0xBA00001B
};

// DMIC Config 1 channel, 16 bits
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicMono16BitFormatConfig[] =
{

  0x00000001, 0xffffff10, 0xffffff10, 0xffffffff, 0xffffffff, 0x00000003, 0x00000003, 0x00300003,
  0x00300003, 0x00000003, 0x00000000, 0x0b001800, 0x00000000, 0x00000e01, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000010, 0x00010079, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000010, 0x000501e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x000fffd4, 0x000ffee7, 0x000ffd12, 0x000ffb92, 0x000ffc6c, 0x000fffa9,
  0x00000221, 0x0000010b, 0x000ffe44, 0x000ffe47, 0x0000015c, 0x0000027f, 0x000fff53, 0x000ffce5,
  0x000fffd7, 0x000003b1, 0x00000153, 0x000ffbce, 0x000ffcd4, 0x000003ea, 0x00000519, 0x000ffd04,
  0x000ff8ef, 0x00000137, 0x000008b3, 0x0000014c, 0x000ff629, 0x000ffb63, 0x00000a13, 0x00000884,
  0x000ff6ee, 0x000ff358, 0x00000693, 0x00001085, 0x000ffd67, 0x000fec4c, 0x000ffd14, 0x00001597,
  0x000009bc, 0x000fea5f, 0x000fee89, 0x0000132f, 0x00001940, 0x000ff1de, 0x000fdfa1, 0x00000672,
  0x00002614, 0x000003e8, 0x000fd6bf, 0x000fefa0, 0x000028ee, 0x00001e01, 0x000fdb8a, 0x000fd462,
  0x00001b7f, 0x000037ec, 0x000ff20f, 0x000fbead, 0x000ffc49, 0x00004658, 0x00001884, 0x000fba58,
  0x000fd0ec, 0x00003e58, 0x0000460b, 0x000fd10a, 0x000fa559, 0x000016ea, 0x0000688b, 0x000006aa,
  0x000f90e8, 0x000fd6a7, 0x00006b1d, 0x00004dd9, 0x000fa4cc, 0x000f8f3d, 0x00003e52, 0x00008d6d,
  0x000feac8, 0x000f60f3, 0x000fe248, 0x0000a10d, 0x0000563b, 0x000f7034, 0x000f7174, 0x000068a7,
  0x0000bea5, 0x000fd454, 0x000f22bc, 0x000fdc59, 0x0000e0d6, 0x00007d86, 0x000f3edd, 0x000f2a48,
  0x000078a7, 0x00011abe, 0x000ff80d, 0x000ec922, 0x000f799a, 0x00011364, 0x00011a10, 0x000f615a,
  0x000e760a, 0x000fd673, 0x00019c53, 0x0001264c, 0x000eede9, 0x000dfe9c, 0x000fc93a, 0x00021da1,
  0x0001f685, 0x000f4883, 0x000d078e, 0x000db72e, 0x0000dbc9, 0x0003e4f1, 0x0004df89, 0x0003dad7,
  0x00022438, 0x0000d573, 0x000035d1, 0x000006cc, 0x0000001b, 0x00000018, 0x0000000a, 0x000fffd7,
  0x000fff67, 0x000ffea2, 0x000ffd76, 0x000ffbdd, 0x000ff9e2, 0x000ff7a8, 0x000ff567, 0x000ff36c,
  0x000ff20b, 0x000ff197, 0x000ff24a, 0x000ff43b, 0x000ff751, 0x000ffb3f, 0x000fff88, 0x00000392,
  0x000006c0, 0x0000088b, 0x000008a2, 0x000006fd, 0x000003e9, 0x000ffffc, 0x000ffbff, 0x000ff8c8,
  0x000ff70f, 0x000ff745, 0x000ff975, 0x000ffd3d, 0x000001da, 0x0000064c, 0x0000098f, 0x00000ad0,
  0x000009a4, 0x00000627, 0x000000ff, 0x000ffb43, 0x000ff63c, 0x000ff326, 0x000ff2dd, 0x000ff5a5,
  0x000ffb11, 0x0000020c, 0x0000090e, 0x00000e72, 0x000010d3, 0x00000f69, 0x00000a42, 0x0000024f,
  0x000ff93e, 0x000ff120, 0x000febf1, 0x000feb25, 0x000fef3d, 0x000ff79d, 0x00000296, 0x00000dbd,
  0x0000166d, 0x00001a67, 0x0000185f, 0x00001061, 0x000003e4, 0x000ff58f, 0x000fe8ab, 0x000fe066,
  0x000fdf12, 0x000fe583, 0x000ff2c3, 0x00000427, 0x000015d6, 0x00002399, 0x000029d9, 0x00002684,
  0x000019aa, 0x000005a6, 0x000feeb6, 0x000fda21, 0x000fcd09, 0x000fcb2c, 0x000fd5e8, 0x000febb1,
  0x00000838, 0x00002531, 0x00003baf, 0x000045b6, 0x00003fc0, 0x000029c6, 0x00000799, 0x000fe04c,
  0x000fbcdb, 0x000fa63a, 0x000fa339, 0x000fb6af, 0x000fde6d, 0x00001333, 0x000049d5, 0x0000755a,
  0x000089c4, 0x00007eed, 0x000052d5, 0x00000ae7, 0x000fb3cc, 0x000f5fb8, 0x000f2367, 0x000f1259,
  0x000f3aea, 0x000fa313, 0x00004687, 0x0001168b, 0x0001fbbc, 0x0002d96f, 0x00039233, 0x00040c98,
  0x0004376b, 0x00040c98, 0x00039233, 0x0002d96f, 0x0001fbbc, 0x0001168b, 0x00004687, 0x000fa313,
  0x000f3aea, 0x000f1259, 0x000f2367, 0x000f5fb8, 0x000fb3cc, 0x00000ae7, 0x000052d5, 0x00007eed,
  0x000089c4, 0x0000755a, 0x000049d5, 0x00001333, 0x000fde6d, 0x000fb6af, 0x000fa339, 0x000fa63a,
  0x000fbcdb, 0x000fe04c, 0x00000799, 0x000029c6, 0x00003fc0, 0x000045b6, 0x00003baf, 0x00002531,
  0x00000838, 0x000febb1, 0x000fd5e8, 0x000fcb2c, 0x000fcd09, 0x000fda21, 0x000feeb6, 0x000005a6,
  0x000019aa, 0x00002684, 0x000029d9, 0x00002399, 0x000015d6, 0x00000427, 0x000ff2c3, 0x000fe583,
  0x000fdf12, 0x000fe066, 0x000fe8ab, 0x000ff58f, 0x000003e4, 0x00001061, 0x0000185f, 0x00001a67,
  0x0000166d, 0x00000dbd, 0x00000296, 0x000ff79d, 0x000fef3d, 0x000feb25, 0x000febf1, 0x000ff120,
  0x000ff93e, 0x0000024f, 0x00000a42, 0x00000f69, 0x000010d3, 0x00000e72, 0x0000090e, 0x0000020c,
  0x000ffb11, 0x000ff5a5, 0x000ff2dd, 0x000ff326, 0x000ff63c, 0x000ffb43, 0x000000ff, 0x00000627,
  0x000009a4, 0x00000ad0, 0x0000098f, 0x0000064c, 0x000001da, 0x000ffd3d, 0x000ff975, 0x000ff745,
  0x000ff70f, 0x000ff8c8, 0x000ffbff, 0x000ffffc, 0x000003e9, 0x000006fd, 0x000008a2, 0x0000088b,
  0x000006c0, 0x00000392, 0x000fff88, 0x000ffb3f, 0x000ff751, 0x000ff43b, 0x000ff24a, 0x000ff197,
  0x000ff20b, 0x000ff36c, 0x000ff567, 0x000ff7a8, 0x000ff9e2, 0x000ffbdd, 0x000ffd76, 0x000ffea2,
  0x000fff67, 0x000fffd7, 0x0000000a, 0x00000018, 0x0000001b, 0x00000000, 0x0b001800, 0x00000000,
  0x00000e00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0x00010079, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0x000501e8, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000fffd4, 0x000ffee7, 0x000ffd12,
  0x000ffb92, 0x000ffc6c, 0x000fffa9, 0x00000221, 0x0000010b, 0x000ffe44, 0x000ffe47, 0x0000015c,
  0x0000027f, 0x000fff53, 0x000ffce5, 0x000fffd7, 0x000003b1, 0x00000153, 0x000ffbce, 0x000ffcd4,
  0x000003ea, 0x00000519, 0x000ffd04, 0x000ff8ef, 0x00000137, 0x000008b3, 0x0000014c, 0x000ff629,
  0x000ffb63, 0x00000a13, 0x00000884, 0x000ff6ee, 0x000ff358, 0x00000693, 0x00001085, 0x000ffd67,
  0x000fec4c, 0x000ffd14, 0x00001597, 0x000009bc, 0x000fea5f, 0x000fee89, 0x0000132f, 0x00001940,
  0x000ff1de, 0x000fdfa1, 0x00000672, 0x00002614, 0x000003e8, 0x000fd6bf, 0x000fefa0, 0x000028ee,
  0x00001e01, 0x000fdb8a, 0x000fd462, 0x00001b7f, 0x000037ec, 0x000ff20f, 0x000fbead, 0x000ffc49,
  0x00004658, 0x00001884, 0x000fba58, 0x000fd0ec, 0x00003e58, 0x0000460b, 0x000fd10a, 0x000fa559,
  0x000016ea, 0x0000688b, 0x000006aa, 0x000f90e8, 0x000fd6a7, 0x00006b1d, 0x00004dd9, 0x000fa4cc,
  0x000f8f3d, 0x00003e52, 0x00008d6d, 0x000feac8, 0x000f60f3, 0x000fe248, 0x0000a10d, 0x0000563b,
  0x000f7034, 0x000f7174, 0x000068a7, 0x0000bea5, 0x000fd454, 0x000f22bc, 0x000fdc59, 0x0000e0d6,
  0x00007d86, 0x000f3edd, 0x000f2a48, 0x000078a7, 0x00011abe, 0x000ff80d, 0x000ec922, 0x000f799a,
  0x00011364, 0x00011a10, 0x000f615a, 0x000e760a, 0x000fd673, 0x00019c53, 0x0001264c, 0x000eede9,
  0x000dfe9c, 0x000fc93a, 0x00021da1, 0x0001f685, 0x000f4883, 0x000d078e, 0x000db72e, 0x0000dbc9,
  0x0003e4f1, 0x0004df89, 0x0003dad7, 0x00022438, 0x0000d573, 0x000035d1, 0x000006cc, 0x0000001b,
  0x00000018, 0x0000000a, 0x000fffd7, 0x000fff67, 0x000ffea2, 0x000ffd76, 0x000ffbdd, 0x000ff9e2,
  0x000ff7a8, 0x000ff567, 0x000ff36c, 0x000ff20b, 0x000ff197, 0x000ff24a, 0x000ff43b, 0x000ff751,
  0x000ffb3f, 0x000fff88, 0x00000392, 0x000006c0, 0x0000088b, 0x000008a2, 0x000006fd, 0x000003e9,
  0x000ffffc, 0x000ffbff, 0x000ff8c8, 0x000ff70f, 0x000ff745, 0x000ff975, 0x000ffd3d, 0x000001da,
  0x0000064c, 0x0000098f, 0x00000ad0, 0x000009a4, 0x00000627, 0x000000ff, 0x000ffb43, 0x000ff63c,
  0x000ff326, 0x000ff2dd, 0x000ff5a5, 0x000ffb11, 0x0000020c, 0x0000090e, 0x00000e72, 0x000010d3,
  0x00000f69, 0x00000a42, 0x0000024f, 0x000ff93e, 0x000ff120, 0x000febf1, 0x000feb25, 0x000fef3d,
  0x000ff79d, 0x00000296, 0x00000dbd, 0x0000166d, 0x00001a67, 0x0000185f, 0x00001061, 0x000003e4,
  0x000ff58f, 0x000fe8ab, 0x000fe066, 0x000fdf12, 0x000fe583, 0x000ff2c3, 0x00000427, 0x000015d6,
  0x00002399, 0x000029d9, 0x00002684, 0x000019aa, 0x000005a6, 0x000feeb6, 0x000fda21, 0x000fcd09,
  0x000fcb2c, 0x000fd5e8, 0x000febb1, 0x00000838, 0x00002531, 0x00003baf, 0x000045b6, 0x00003fc0,
  0x000029c6, 0x00000799, 0x000fe04c, 0x000fbcdb, 0x000fa63a, 0x000fa339, 0x000fb6af, 0x000fde6d,
  0x00001333, 0x000049d5, 0x0000755a, 0x000089c4, 0x00007eed, 0x000052d5, 0x00000ae7, 0x000fb3cc,
  0x000f5fb8, 0x000f2367, 0x000f1259, 0x000f3aea, 0x000fa313, 0x00004687, 0x0001168b, 0x0001fbbc,
  0x0002d96f, 0x00039233, 0x00040c98, 0x0004376b, 0x00040c98, 0x00039233, 0x0002d96f, 0x0001fbbc,
  0x0001168b, 0x00004687, 0x000fa313, 0x000f3aea, 0x000f1259, 0x000f2367, 0x000f5fb8, 0x000fb3cc,
  0x00000ae7, 0x000052d5, 0x00007eed, 0x000089c4, 0x0000755a, 0x000049d5, 0x00001333, 0x000fde6d,
  0x000fb6af, 0x000fa339, 0x000fa63a, 0x000fbcdb, 0x000fe04c, 0x00000799, 0x000029c6, 0x00003fc0,
  0x000045b6, 0x00003baf, 0x00002531, 0x00000838, 0x000febb1, 0x000fd5e8, 0x000fcb2c, 0x000fcd09,
  0x000fda21, 0x000feeb6, 0x000005a6, 0x000019aa, 0x00002684, 0x000029d9, 0x00002399, 0x000015d6,
  0x00000427, 0x000ff2c3, 0x000fe583, 0x000fdf12, 0x000fe066, 0x000fe8ab, 0x000ff58f, 0x000003e4,
  0x00001061, 0x0000185f, 0x00001a67, 0x0000166d, 0x00000dbd, 0x00000296, 0x000ff79d, 0x000fef3d,
  0x000feb25, 0x000febf1, 0x000ff120, 0x000ff93e, 0x0000024f, 0x00000a42, 0x00000f69, 0x000010d3,
  0x00000e72, 0x0000090e, 0x0000020c, 0x000ffb11, 0x000ff5a5, 0x000ff2dd, 0x000ff326, 0x000ff63c,
  0x000ffb43, 0x000000ff, 0x00000627, 0x000009a4, 0x00000ad0, 0x0000098f, 0x0000064c, 0x000001da,
  0x000ffd3d, 0x000ff975, 0x000ff745, 0x000ff70f, 0x000ff8c8, 0x000ffbff, 0x000ffffc, 0x000003e9,
  0x000006fd, 0x000008a2, 0x0000088b, 0x000006c0, 0x00000392, 0x000fff88, 0x000ffb3f, 0x000ff751,
  0x000ff43b, 0x000ff24a, 0x000ff197, 0x000ff20b, 0x000ff36c, 0x000ff567, 0x000ff7a8, 0x000ff9e2,
  0x000ffbdd, 0x000ffd76, 0x000ffea2, 0x000fff67, 0x000fffd7, 0x0000000a, 0x00000018, 0x0000001b
};

// DMIC Config 1 channel, 32 bits
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 DmicMono32BitFormatConfig[] =
{
  0x00000001, 0xffffff10, 0xffffff10, 0xffffffff, 0xffffffff, 0x00000003, 0x00000003, 0x00380003,
  0x00380003, 0x00000003, 0x00000000, 0x0b001800, 0x00000000, 0x00000e01, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000010, 0x00010079, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x00000010, 0x000501e8, 0x00000000, 0x00000000, 0x00000000, 0x00000000,
  0x00000000, 0x00000000, 0x000fffd4, 0x000ffee7, 0x000ffd12, 0x000ffb92, 0x000ffc6c, 0x000fffa9,
  0x00000221, 0x0000010b, 0x000ffe44, 0x000ffe47, 0x0000015c, 0x0000027f, 0x000fff53, 0x000ffce5,
  0x000fffd7, 0x000003b1, 0x00000153, 0x000ffbce, 0x000ffcd4, 0x000003ea, 0x00000519, 0x000ffd04,
  0x000ff8ef, 0x00000137, 0x000008b3, 0x0000014c, 0x000ff629, 0x000ffb63, 0x00000a13, 0x00000884,
  0x000ff6ee, 0x000ff358, 0x00000693, 0x00001085, 0x000ffd67, 0x000fec4c, 0x000ffd14, 0x00001597,
  0x000009bc, 0x000fea5f, 0x000fee89, 0x0000132f, 0x00001940, 0x000ff1de, 0x000fdfa1, 0x00000672,
  0x00002614, 0x000003e8, 0x000fd6bf, 0x000fefa0, 0x000028ee, 0x00001e01, 0x000fdb8a, 0x000fd462,
  0x00001b7f, 0x000037ec, 0x000ff20f, 0x000fbead, 0x000ffc49, 0x00004658, 0x00001884, 0x000fba58,
  0x000fd0ec, 0x00003e58, 0x0000460b, 0x000fd10a, 0x000fa559, 0x000016ea, 0x0000688b, 0x000006aa,
  0x000f90e8, 0x000fd6a7, 0x00006b1d, 0x00004dd9, 0x000fa4cc, 0x000f8f3d, 0x00003e52, 0x00008d6d,
  0x000feac8, 0x000f60f3, 0x000fe248, 0x0000a10d, 0x0000563b, 0x000f7034, 0x000f7174, 0x000068a7,
  0x0000bea5, 0x000fd454, 0x000f22bc, 0x000fdc59, 0x0000e0d6, 0x00007d86, 0x000f3edd, 0x000f2a48,
  0x000078a7, 0x00011abe, 0x000ff80d, 0x000ec922, 0x000f799a, 0x00011364, 0x00011a10, 0x000f615a,
  0x000e760a, 0x000fd673, 0x00019c53, 0x0001264c, 0x000eede9, 0x000dfe9c, 0x000fc93a, 0x00021da1,
  0x0001f685, 0x000f4883, 0x000d078e, 0x000db72e, 0x0000dbc9, 0x0003e4f1, 0x0004df89, 0x0003dad7,
  0x00022438, 0x0000d573, 0x000035d1, 0x000006cc, 0x0000001b, 0x00000018, 0x0000000a, 0x000fffd7,
  0x000fff67, 0x000ffea2, 0x000ffd76, 0x000ffbdd, 0x000ff9e2, 0x000ff7a8, 0x000ff567, 0x000ff36c,
  0x000ff20b, 0x000ff197, 0x000ff24a, 0x000ff43b, 0x000ff751, 0x000ffb3f, 0x000fff88, 0x00000392,
  0x000006c0, 0x0000088b, 0x000008a2, 0x000006fd, 0x000003e9, 0x000ffffc, 0x000ffbff, 0x000ff8c8,
  0x000ff70f, 0x000ff745, 0x000ff975, 0x000ffd3d, 0x000001da, 0x0000064c, 0x0000098f, 0x00000ad0,
  0x000009a4, 0x00000627, 0x000000ff, 0x000ffb43, 0x000ff63c, 0x000ff326, 0x000ff2dd, 0x000ff5a5,
  0x000ffb11, 0x0000020c, 0x0000090e, 0x00000e72, 0x000010d3, 0x00000f69, 0x00000a42, 0x0000024f,
  0x000ff93e, 0x000ff120, 0x000febf1, 0x000feb25, 0x000fef3d, 0x000ff79d, 0x00000296, 0x00000dbd,
  0x0000166d, 0x00001a67, 0x0000185f, 0x00001061, 0x000003e4, 0x000ff58f, 0x000fe8ab, 0x000fe066,
  0x000fdf12, 0x000fe583, 0x000ff2c3, 0x00000427, 0x000015d6, 0x00002399, 0x000029d9, 0x00002684,
  0x000019aa, 0x000005a6, 0x000feeb6, 0x000fda21, 0x000fcd09, 0x000fcb2c, 0x000fd5e8, 0x000febb1,
  0x00000838, 0x00002531, 0x00003baf, 0x000045b6, 0x00003fc0, 0x000029c6, 0x00000799, 0x000fe04c,
  0x000fbcdb, 0x000fa63a, 0x000fa339, 0x000fb6af, 0x000fde6d, 0x00001333, 0x000049d5, 0x0000755a,
  0x000089c4, 0x00007eed, 0x000052d5, 0x00000ae7, 0x000fb3cc, 0x000f5fb8, 0x000f2367, 0x000f1259,
  0x000f3aea, 0x000fa313, 0x00004687, 0x0001168b, 0x0001fbbc, 0x0002d96f, 0x00039233, 0x00040c98,
  0x0004376b, 0x00040c98, 0x00039233, 0x0002d96f, 0x0001fbbc, 0x0001168b, 0x00004687, 0x000fa313,
  0x000f3aea, 0x000f1259, 0x000f2367, 0x000f5fb8, 0x000fb3cc, 0x00000ae7, 0x000052d5, 0x00007eed,
  0x000089c4, 0x0000755a, 0x000049d5, 0x00001333, 0x000fde6d, 0x000fb6af, 0x000fa339, 0x000fa63a,
  0x000fbcdb, 0x000fe04c, 0x00000799, 0x000029c6, 0x00003fc0, 0x000045b6, 0x00003baf, 0x00002531,
  0x00000838, 0x000febb1, 0x000fd5e8, 0x000fcb2c, 0x000fcd09, 0x000fda21, 0x000feeb6, 0x000005a6,
  0x000019aa, 0x00002684, 0x000029d9, 0x00002399, 0x000015d6, 0x00000427, 0x000ff2c3, 0x000fe583,
  0x000fdf12, 0x000fe066, 0x000fe8ab, 0x000ff58f, 0x000003e4, 0x00001061, 0x0000185f, 0x00001a67,
  0x0000166d, 0x00000dbd, 0x00000296, 0x000ff79d, 0x000fef3d, 0x000feb25, 0x000febf1, 0x000ff120,
  0x000ff93e, 0x0000024f, 0x00000a42, 0x00000f69, 0x000010d3, 0x00000e72, 0x0000090e, 0x0000020c,
  0x000ffb11, 0x000ff5a5, 0x000ff2dd, 0x000ff326, 0x000ff63c, 0x000ffb43, 0x000000ff, 0x00000627,
  0x000009a4, 0x00000ad0, 0x0000098f, 0x0000064c, 0x000001da, 0x000ffd3d, 0x000ff975, 0x000ff745,
  0x000ff70f, 0x000ff8c8, 0x000ffbff, 0x000ffffc, 0x000003e9, 0x000006fd, 0x000008a2, 0x0000088b,
  0x000006c0, 0x00000392, 0x000fff88, 0x000ffb3f, 0x000ff751, 0x000ff43b, 0x000ff24a, 0x000ff197,
  0x000ff20b, 0x000ff36c, 0x000ff567, 0x000ff7a8, 0x000ff9e2, 0x000ffbdd, 0x000ffd76, 0x000ffea2,
  0x000fff67, 0x000fffd7, 0x0000000a, 0x00000018, 0x0000001b, 0x00000000, 0x0b001800, 0x00000000,
  0x00000e00, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0x00010079, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000010, 0x000501e8, 0x00000000,
  0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x000fffd4, 0x000ffee7, 0x000ffd12,
  0x000ffb92, 0x000ffc6c, 0x000fffa9, 0x00000221, 0x0000010b, 0x000ffe44, 0x000ffe47, 0x0000015c,
  0x0000027f, 0x000fff53, 0x000ffce5, 0x000fffd7, 0x000003b1, 0x00000153, 0x000ffbce, 0x000ffcd4,
  0x000003ea, 0x00000519, 0x000ffd04, 0x000ff8ef, 0x00000137, 0x000008b3, 0x0000014c, 0x000ff629,
  0x000ffb63, 0x00000a13, 0x00000884, 0x000ff6ee, 0x000ff358, 0x00000693, 0x00001085, 0x000ffd67,
  0x000fec4c, 0x000ffd14, 0x00001597, 0x000009bc, 0x000fea5f, 0x000fee89, 0x0000132f, 0x00001940,
  0x000ff1de, 0x000fdfa1, 0x00000672, 0x00002614, 0x000003e8, 0x000fd6bf, 0x000fefa0, 0x000028ee,
  0x00001e01, 0x000fdb8a, 0x000fd462, 0x00001b7f, 0x000037ec, 0x000ff20f, 0x000fbead, 0x000ffc49,
  0x00004658, 0x00001884, 0x000fba58, 0x000fd0ec, 0x00003e58, 0x0000460b, 0x000fd10a, 0x000fa559,
  0x000016ea, 0x0000688b, 0x000006aa, 0x000f90e8, 0x000fd6a7, 0x00006b1d, 0x00004dd9, 0x000fa4cc,
  0x000f8f3d, 0x00003e52, 0x00008d6d, 0x000feac8, 0x000f60f3, 0x000fe248, 0x0000a10d, 0x0000563b,
  0x000f7034, 0x000f7174, 0x000068a7, 0x0000bea5, 0x000fd454, 0x000f22bc, 0x000fdc59, 0x0000e0d6,
  0x00007d86, 0x000f3edd, 0x000f2a48, 0x000078a7, 0x00011abe, 0x000ff80d, 0x000ec922, 0x000f799a,
  0x00011364, 0x00011a10, 0x000f615a, 0x000e760a, 0x000fd673, 0x00019c53, 0x0001264c, 0x000eede9,
  0x000dfe9c, 0x000fc93a, 0x00021da1, 0x0001f685, 0x000f4883, 0x000d078e, 0x000db72e, 0x0000dbc9,
  0x0003e4f1, 0x0004df89, 0x0003dad7, 0x00022438, 0x0000d573, 0x000035d1, 0x000006cc, 0x0000001b,
  0x00000018, 0x0000000a, 0x000fffd7, 0x000fff67, 0x000ffea2, 0x000ffd76, 0x000ffbdd, 0x000ff9e2,
  0x000ff7a8, 0x000ff567, 0x000ff36c, 0x000ff20b, 0x000ff197, 0x000ff24a, 0x000ff43b, 0x000ff751,
  0x000ffb3f, 0x000fff88, 0x00000392, 0x000006c0, 0x0000088b, 0x000008a2, 0x000006fd, 0x000003e9,
  0x000ffffc, 0x000ffbff, 0x000ff8c8, 0x000ff70f, 0x000ff745, 0x000ff975, 0x000ffd3d, 0x000001da,
  0x0000064c, 0x0000098f, 0x00000ad0, 0x000009a4, 0x00000627, 0x000000ff, 0x000ffb43, 0x000ff63c,
  0x000ff326, 0x000ff2dd, 0x000ff5a5, 0x000ffb11, 0x0000020c, 0x0000090e, 0x00000e72, 0x000010d3,
  0x00000f69, 0x00000a42, 0x0000024f, 0x000ff93e, 0x000ff120, 0x000febf1, 0x000feb25, 0x000fef3d,
  0x000ff79d, 0x00000296, 0x00000dbd, 0x0000166d, 0x00001a67, 0x0000185f, 0x00001061, 0x000003e4,
  0x000ff58f, 0x000fe8ab, 0x000fe066, 0x000fdf12, 0x000fe583, 0x000ff2c3, 0x00000427, 0x000015d6,
  0x00002399, 0x000029d9, 0x00002684, 0x000019aa, 0x000005a6, 0x000feeb6, 0x000fda21, 0x000fcd09,
  0x000fcb2c, 0x000fd5e8, 0x000febb1, 0x00000838, 0x00002531, 0x00003baf, 0x000045b6, 0x00003fc0,
  0x000029c6, 0x00000799, 0x000fe04c, 0x000fbcdb, 0x000fa63a, 0x000fa339, 0x000fb6af, 0x000fde6d,
  0x00001333, 0x000049d5, 0x0000755a, 0x000089c4, 0x00007eed, 0x000052d5, 0x00000ae7, 0x000fb3cc,
  0x000f5fb8, 0x000f2367, 0x000f1259, 0x000f3aea, 0x000fa313, 0x00004687, 0x0001168b, 0x0001fbbc,
  0x0002d96f, 0x00039233, 0x00040c98, 0x0004376b, 0x00040c98, 0x00039233, 0x0002d96f, 0x0001fbbc,
  0x0001168b, 0x00004687, 0x000fa313, 0x000f3aea, 0x000f1259, 0x000f2367, 0x000f5fb8, 0x000fb3cc,
  0x00000ae7, 0x000052d5, 0x00007eed, 0x000089c4, 0x0000755a, 0x000049d5, 0x00001333, 0x000fde6d,
  0x000fb6af, 0x000fa339, 0x000fa63a, 0x000fbcdb, 0x000fe04c, 0x00000799, 0x000029c6, 0x00003fc0,
  0x000045b6, 0x00003baf, 0x00002531, 0x00000838, 0x000febb1, 0x000fd5e8, 0x000fcb2c, 0x000fcd09,
  0x000fda21, 0x000feeb6, 0x000005a6, 0x000019aa, 0x00002684, 0x000029d9, 0x00002399, 0x000015d6,
  0x00000427, 0x000ff2c3, 0x000fe583, 0x000fdf12, 0x000fe066, 0x000fe8ab, 0x000ff58f, 0x000003e4,
  0x00001061, 0x0000185f, 0x00001a67, 0x0000166d, 0x00000dbd, 0x00000296, 0x000ff79d, 0x000fef3d,
  0x000feb25, 0x000febf1, 0x000ff120, 0x000ff93e, 0x0000024f, 0x00000a42, 0x00000f69, 0x000010d3,
  0x00000e72, 0x0000090e, 0x0000020c, 0x000ffb11, 0x000ff5a5, 0x000ff2dd, 0x000ff326, 0x000ff63c,
  0x000ffb43, 0x000000ff, 0x00000627, 0x000009a4, 0x00000ad0, 0x0000098f, 0x0000064c, 0x000001da,
  0x000ffd3d, 0x000ff975, 0x000ff745, 0x000ff70f, 0x000ff8c8, 0x000ffbff, 0x000ffffc, 0x000003e9,
  0x000006fd, 0x000008a2, 0x0000088b, 0x000006c0, 0x00000392, 0x000fff88, 0x000ffb3f, 0x000ff751,
  0x000ff43b, 0x000ff24a, 0x000ff197, 0x000ff20b, 0x000ff36c, 0x000ff567, 0x000ff7a8, 0x000ff9e2,
  0x000ffbdd, 0x000ffd76, 0x000ffea2, 0x000fff67, 0x000fffd7, 0x0000000a, 0x00000018, 0x0000001b
};

//
// I2S/SSP Configuration BLOBs
// Audio Format and Configuration details
//
// Frequency: 48kHz, PCM resolution: 24 bits
// TDM slots: 4
// Codec: Realtek ALC274, mode: slave
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk274Render4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff32, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0xffff3210, 0x83d00737, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00020001, 0x00000002};

GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 I2sRtk274Capture4ch48kHz24bitFormatConfig[]  = {0x0, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0xffffff10, 0x83d00737, 0xc0700000, 0x0, 0x02010004, 0xf, 0xf, 0x4002, 0x4, 0x7070f00, 0x20, 0x00020001, 0x00000002};

//
// BlueTooth Configuration BLOBs
//
GLOBAL_REMOVE_IF_UNREFERENCED
CONST UINT32 BtFormatConfig[] =
{
  0x0, 0xfffffff0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0,
  0x0, 0x80c0003f, 0xd3400000, 0x0, 0x02000005, 0x01, 0x01, 0x4002,
  0x0, 0x07020000, 0x0, 0x01, 0x0
};

HDA_NHLT_FORMAT_CONFIG mHdaNhltFormatConfigs[V_HDA_FORMAT_MAX] =
{
  {B_HDA_DMIC_2CH_48KHZ_16BIT_FORMAT,               &Ch2_48kHz16bitFormat, sizeof(DmicStereo16BitFormatConfig),               DmicStereo16BitFormatConfig},
  {B_HDA_DMIC_2CH_48KHZ_32BIT_FORMAT,               &Ch2_48kHz32bitFormat, sizeof(DmicStereo32BitFormatConfig),               DmicStereo32BitFormatConfig},
  {B_HDA_DMIC_4CH_48KHZ_16BIT_FORMAT,               &Ch4_48kHz16bitFormat, sizeof(DmicQuad16BitFormatConfig),                 DmicQuad16BitFormatConfig},
  {B_HDA_DMIC_4CH_48KHZ_32BIT_FORMAT,               &Ch4_48kHz32bitFormat, sizeof(DmicQuad32BitFormatConfig),                 DmicQuad32BitFormatConfig},
  {B_HDA_DMIC_1CH_48KHZ_16BIT_FORMAT,               &Ch1_48kHz16bitFormat, sizeof(DmicMono16BitFormatConfig),                 DmicMono16BitFormatConfig},
  {B_HDA_DMIC_1CH_48KHZ_32BIT_FORMAT,               &Ch1_48kHz32bitFormat, sizeof(DmicMono32BitFormatConfig),                 DmicMono32BitFormatConfig},
  {B_HDA_BT_NARROWBAND_FORMAT,                      &NarrowbandFormat,     sizeof(BtFormatConfig),                            BtFormatConfig},
  {B_HDA_BT_WIDEBAND_FORMAT,                        &WidebandFormat,       sizeof(BtFormatConfig),                            BtFormatConfig},
  {B_HDA_BT_A2DP_FORMAT,                            &A2dpFormat,           sizeof(BtFormatConfig),                            BtFormatConfig},
  {B_HDA_I2S_RTK274_RENDER_4CH_48KHZ_24BIT_FORMAT,  &Ch2_48kHz24bitFormat, sizeof(I2sRtk274Render4ch48kHz24bitFormatConfig),  I2sRtk274Render4ch48kHz24bitFormatConfig},
  {B_HDA_I2S_RTK274_CAPTURE_4CH_48KHZ_24BIT_FORMAT, &Ch2_48kHz24bitFormat, sizeof(I2sRtk274Capture4ch48kHz24bitFormatConfig), I2sRtk274Capture4ch48kHz24bitFormatConfig}
};
