/** @file
Do Platform Stage System Agent initialization.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2013 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains a 'Sample Driver' and is licensed as such under the terms
  of your license agreement with Intel or your vendor. This file may be modified
  by the user, subject to the additional terms of the license agreement.

@par Specification Reference:
**/

#include "PeiSaPolicyUpdate.h"
#include "MemoryConfig.h"
#include <Library/CpuPlatformLib.h>
#include <Library/HobLib.h>
#include <Library/SiPolicyLib.h>
#include <Library/BaseMemoryLib.h>
#include <Library/MemoryAllocationLib.h>
#include <Library/PeiSaPolicyLib.h>
#include <IpuPreMemConfig.h>
#include <Library/GpioLib.h>
#include <Library/MeFwStsLib.h>
#include <Library/VtdInfoLib.h>
#include <Library/CpuPcieInfoFruLib.h>
#include <Guid/AcpiVariable.h>
#include <Guid/MemoryTypeInformation.h>
#include <Guid/MemoryOverwriteControl.h>
#include <Guid/S3MemoryVariable.h>
#include <DpInPreMemConfig.h>
#include <PlatformDpInPcdConfig.h>
#if FixedPcdGet8(PcdFspModeSelection) == 1
#include <FspmUpd.h>
#else
#include <Ppi/FspmArchConfigPpi.h>
#endif
#include <CpuRegs.h>
#include <TcssPeiPreMemConfig.h>
#include <TwoLmConfig.h>
#include <TelemetryPeiConfig.h>
#include <Setup.h>
#include <Platform.h>
#include <PlatformBoardConfig.h>
#include <PolicyUpdateMacro.h>
#include <HostBridgeConfig.h>
#include <CpuDmiPreMemConfig.h>
///
///

///
/// Memory Reserved should be between 125% to 150% of the Current required memory
/// otherwise BdsMisc.c would do a reset to make it 125% to avoid s4 resume issues.
///
GLOBAL_REMOVE_IF_UNREFERENCED EFI_MEMORY_TYPE_INFORMATION mDefaultMemoryTypeInformation[] = {
  { EfiACPIReclaimMemory,   FixedPcdGet32 (PcdPlatformEfiAcpiReclaimMemorySize) },  // ASL
  { EfiACPIMemoryNVS,       FixedPcdGet32 (PcdPlatformEfiAcpiNvsMemorySize) },      // ACPI NVS (including S3 related)
  { EfiReservedMemoryType,  FixedPcdGet32 (PcdPlatformEfiReservedMemorySize) },     // BIOS Reserved (including S3 related)
  { EfiRuntimeServicesData, FixedPcdGet32 (PcdPlatformEfiRtDataMemorySize) },       // Runtime Service Data
  { EfiRuntimeServicesCode, FixedPcdGet32 (PcdPlatformEfiRtCodeMemorySize) },       // Runtime Service Code
  { EfiMaxMemoryType, 0 }
};

/**
  UpdatePeiSaPolicyPreMem performs SA PEI Policy initialization

  @retval EFI_SUCCESS              The policy is installed and initialized.
**/
EFI_STATUS
EFIAPI
UpdatePeiSaPolicyPreMem (
  VOID
  )
{
  EFI_STATUS                      Status;
  EFI_STATUS                      Status2;
  EFI_STATUS                      Status3;
  UINTN                           Lane;
  EFI_PEI_READ_ONLY_VARIABLE2_PPI *VariableServices;
  SI_SETUP                        SiSetup;
  SETUP_DATA                      SetupData;
  SA_SETUP                        SaSetup;
  CPU_SETUP                       CpuSetup;
  UINTN                           VariableSize;
  SA_MEMORY_RCOMP                 *RcompData;
  WDT_PPI                         *gWdtPei;
  UINT8                           WdtTimeout;
  UINTN                           Bundle;
  UINT32                          RoundedBclkFreq;
  UINT8                           Index;
  S3_MEMORY_VARIABLE              S3MemVariable;
  UINTN                           DataSize;
  EFI_MEMORY_TYPE_INFORMATION     MemoryData[EfiMaxMemoryType + 1];
  EFI_BOOT_MODE                   BootMode;
  UINT8                           MorControl;
  PCH_SETUP                       PchSetup;
  UINT16                          MmioSize;
  UINT32                          TraceHubTotalMemSize;
  UINT8                           IgdDvmt50PreAlloc;
  UINT64                          PlatformMemorySize;
  UINT16                          GtVoltageOverride;
  UINT16                          GtExtraTurboVoltage;
  VOID                            *MemorySavedData;
  VOID                            *NullSpdPtr;
#if FixedPcdGetBool(PcdHgEnable) == 1
  HYBRID_GRAPHICS_CONFIG          *HgGpioData;
#endif
#if FixedPcdGetBool(PcdFspWrapperEnable) == 1
  UINT32                          PciexBarReg;
#endif
#if FixedPcdGet8(PcdFspModeSelection) == 1
  VOID                            *FspmUpd;
  VOID                            *MemorySpdPtr000;
  VOID                            *MemorySpdPtr010;
  VOID                            *MemorySpdPtr020;
  VOID                            *MemorySpdPtr030;
  VOID                            *MemorySpdPtr100;
  VOID                            *MemorySpdPtr110;
  VOID                            *MemorySpdPtr120;
  VOID                            *MemorySpdPtr130;
#else
  SI_PREMEM_POLICY_PPI            *SiPreMemPolicyPpi;
  GRAPHICS_PEI_PREMEM_CONFIG      *GtPreMemConfig;
  MEMORY_CONFIGURATION            *MemConfig;
  PCIE_PEI_PREMEM_CONFIG          *PciePeiPreMemConfig;
#if FixedPcdGetBool(PcdIpuEnable) == 1
  IPU_PREMEM_CONFIG               *IpuPreMemPolicy;
#endif
  OVERCLOCKING_PREMEM_CONFIG      *OcPreMemConfig;
  SA_MISC_PEI_PREMEM_CONFIG       *MiscPeiPreMemConfig;
  MEMORY_CONFIG_NO_CRC            *MemConfigNoCrc;
#ifndef CPU_CFL
  TCSS_PEI_PREMEM_CONFIG          *TcssPeiPreMemConfig;
  TWOLM_PREMEM_CONFIG             *TwoLmPreMemConfig;
#endif
  DPIN_PREMEM_CONFIG              *DpInPeiPreMemConfig;
  CPU_TRACE_HUB_PREMEM_CONFIG     *CpuTraceHubPreMemConfig;
  VTD_CONFIG                      *Vtd;
  CPU_DMI_PREMEM_CONFIG           *CpuDmiPreMemConfig;
  TELEMETRY_PEI_PREMEM_CONFIG     *TelemetryPreMemConfig;
  HOST_BRIDGE_PREMEM_CONFIG       *HostBridgePreMemConfig;
  EFI_PEI_PPI_DESCRIPTOR          *FspmArchConfigPpiDesc;
  FSPM_ARCH_CONFIG_PPI            *FspmArchConfigPpi;
#endif
  UINT16                          AdjustedMmioSize;
  UINT8                           SaDisplayConfigTable[16] = {0};
  EFI_BOOT_MODE                   SysBootMode;
///
///
  DPIN_PORT_MAP_DATA              *DpInExtPortMapPcdDataPtr;

  DEBUG ((DEBUG_INFO, "Update PeiSaPolicyUpdate Pre-Mem Start\n"));
  SysBootMode          = 0;
  RcompData            = NULL;
  PlatformMemorySize   = 0;
  TraceHubTotalMemSize = 0;
#if FixedPcdGetBool(PcdHgEnable) == 1
  HgGpioData           = NULL;
#endif
#if FixedPcdGet8(PcdFspModeSelection) == 1
  FspmUpd              = NULL;
  MemorySpdPtr000      = NULL;
  MemorySpdPtr010      = NULL;
  MemorySpdPtr020      = NULL;
  MemorySpdPtr030      = NULL;
  MemorySpdPtr100      = NULL;
  MemorySpdPtr110      = NULL;
  MemorySpdPtr120      = NULL;
  MemorySpdPtr130      = NULL;
#else
  SiPreMemPolicyPpi    = NULL;
  GtPreMemConfig       = NULL;
  MemConfig            = NULL;
#if FixedPcdGetBool(PcdIpuEnable) == 1
  IpuPreMemPolicy      = NULL;
#endif
  MemConfigNoCrc       = NULL;
  PciePeiPreMemConfig  = NULL;
  OcPreMemConfig       = NULL;
#ifndef CPU_CFL
  TcssPeiPreMemConfig  = NULL;
  TwoLmPreMemConfig    = NULL;
#endif
  MiscPeiPreMemConfig  = NULL;
  CpuTraceHubPreMemConfig = NULL;
  DpInPeiPreMemConfig  = NULL;;
  TelemetryPreMemConfig = NULL;
  HostBridgePreMemConfig = NULL;
  FspmArchConfigPpi    = NULL;
#endif
  DpInExtPortMapPcdDataPtr = NULL;

  AdjustedMmioSize = PcdGet16 (PcdSaMiscMmioSizeAdjustment);

#if FixedPcdGet8(PcdFspModeSelection) == 1
  FspmUpd = (FSPM_UPD *) PcdGet32 (PcdFspmUpdDataAddress);
  ASSERT (FspmUpd != NULL);
#else
  Status = PeiServicesLocatePpi (&gSiPreMemPolicyPpiGuid, 0, NULL, (VOID **) &SiPreMemPolicyPpi);
  ASSERT_EFI_ERROR (Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gHostBridgePeiPreMemConfigGuid, (VOID *) &HostBridgePreMemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gSaMiscPeiPreMemConfigGuid, (VOID *) &MiscPeiPreMemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gGraphicsPeiPreMemConfigGuid, (VOID *) &GtPreMemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gMemoryConfigGuid, (VOID *) &MemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gCpuPciePeiPreMemConfigGuid, (VOID *) &PciePeiPreMemConfig);
  ASSERT_EFI_ERROR(Status);
#if FixedPcdGetBool(PcdHgEnable) == 1
  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gHybridGraphicsConfigGuid, (VOID *) &HgGpioData);
  ASSERT_EFI_ERROR(Status);
#endif
#if FixedPcdGetBool(PcdIpuEnable) == 1
  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gIpuPreMemConfigGuid, (VOID *) &IpuPreMemPolicy);
  ASSERT_EFI_ERROR (Status);
#endif
  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gMemoryConfigNoCrcGuid, (VOID *) &MemConfigNoCrc);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock ((VOID *) SiPreMemPolicyPpi, &gCpuTraceHubPreMemConfigGuid, (VOID *) &CpuTraceHubPreMemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gOverclockingPreMemConfigGuid, (VOID *) &OcPreMemConfig);
  ASSERT_EFI_ERROR(Status);

#ifndef CPU_CFL
  Status = GetConfigBlock ((VOID *)SiPreMemPolicyPpi, &gTcssPeiPreMemConfigGuid, (VOID *) &TcssPeiPreMemConfig);
  ASSERT_EFI_ERROR(Status);

  Status = GetConfigBlock ((VOID *)SiPreMemPolicyPpi, &gTwoLmPreMemConfigGuid, (VOID *) &TwoLmPreMemConfig);
  ASSERT_EFI_ERROR(Status);
#endif
  Status = GetConfigBlock ((VOID *)SiPreMemPolicyPpi, &gTelemetryPeiPreMemConfigGuid, (VOID *) &TelemetryPreMemConfig);
  ASSERT_EFI_ERROR(Status);
  Status = GetConfigBlock((VOID *) SiPreMemPolicyPpi, &gVtdConfigGuid, (VOID *)&Vtd);
  ASSERT_EFI_ERROR(Status);
  Status = GetConfigBlock ((VOID *)SiPreMemPolicyPpi, &gDpInPreMemConfigGuid, (VOID *) &DpInPeiPreMemConfig);
  ASSERT_EFI_ERROR(Status);

  CpuDmiPreMemConfig = NULL;
  Status = GetConfigBlock ((VOID *) SiPreMemPolicyPpi, &gCpuDmiPreMemConfigGuid, (VOID *)&CpuDmiPreMemConfig);
  ASSERT_EFI_ERROR (Status);
#endif
  DpInExtPortMapPcdDataPtr = PcdGetPtr(PcdBoardDpInPortMapData);

#if FixedPcdGet8(PcdFspModeSelection) == 0
  RcompData = MemConfigNoCrc->RcompData;
#endif

  //
  // Locate system configuration variable
  //
  Status = PeiServicesLocatePpi(
             &gEfiPeiReadOnlyVariable2PpiGuid, // GUID
             0,                                // INSTANCE
             NULL,                             // EFI_PEI_PPI_DESCRIPTOR
             (VOID **) &VariableServices       // PPI
             );
  ASSERT_EFI_ERROR(Status);

  Status = PeiServicesGetBootMode (&BootMode);
  ASSERT_EFI_ERROR (Status);

  //
  // Initialize S3 Data variable (S3DataPtr)
  //
  VariableSize = 0;
  MemorySavedData = NULL;
  Status = VariableServices->GetVariable (
                               VariableServices,
                               L"MemoryConfig",
                               &gMemoryConfigVariableGuid,
                               NULL,
                               &VariableSize,
                               MemorySavedData
                               );
  if (Status == EFI_BUFFER_TOO_SMALL) {
    MemorySavedData = AllocateZeroPool (VariableSize);
    ASSERT (MemorySavedData != NULL);

    Status = VariableServices->GetVariable (
                                 VariableServices,
                                 L"MemoryConfig",
                                 &gMemoryConfigVariableGuid,
                                 NULL,
                                 &VariableSize,
                                 MemorySavedData
                                 );
    if (EFI_ERROR (Status)) {
      DEBUG ((DEBUG_ERROR, "Fail to retrieve Variable: MemoryConfig, Status = %r\n", Status));
      ASSERT_EFI_ERROR (Status);
    }
  }
#if FixedPcdGet8(PcdFspModeSelection) == 0
  FspmArchConfigPpi = (FSPM_ARCH_CONFIG_PPI *) AllocateZeroPool (sizeof (FSPM_ARCH_CONFIG_PPI));
  if (FspmArchConfigPpi == NULL) {
    ASSERT (FALSE);
    return EFI_OUT_OF_RESOURCES;
  }
  FspmArchConfigPpi->Revision     = 1;
  FspmArchConfigPpi->NvsBufferPtr = MemorySavedData;
  MiscPeiPreMemConfig->S3DataPtr  = MemorySavedData;

  FspmArchConfigPpiDesc = (EFI_PEI_PPI_DESCRIPTOR *) AllocateZeroPool (sizeof (EFI_PEI_PPI_DESCRIPTOR));
  if (FspmArchConfigPpiDesc == NULL) {
    ASSERT (FALSE);
    return EFI_OUT_OF_RESOURCES;
  }
  FspmArchConfigPpiDesc->Flags = EFI_PEI_PPI_DESCRIPTOR_PPI | EFI_PEI_PPI_DESCRIPTOR_TERMINATE_LIST;
  FspmArchConfigPpiDesc->Guid  = &gFspmArchConfigPpiGuid;
  FspmArchConfigPpiDesc->Ppi   = FspmArchConfigPpi;

  //
  // Install FSP-M Arch Config PPI
  //
  Status = PeiServicesInstallPpi (FspmArchConfigPpiDesc);
  ASSERT_EFI_ERROR (Status);

#else
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmArchUpd.NvsBufferPtr, MiscPeiPreMemConfig->S3DataPtr, MemorySavedData);
#endif




  //
  // Get S3 Memory Variable
  //
  VariableSize = sizeof (S3_MEMORY_VARIABLE);
  Status = VariableServices->GetVariable(
                               VariableServices,
                               S3_MEMORY_VARIABLE_NAME,
                               &gS3MemoryVariableGuid,
                               NULL,
                               &VariableSize,
                               &S3MemVariable
                               );
  if (Status == EFI_SUCCESS) {
#if FixedPcdGet8(PcdFspModeSelection) == 0
    MiscPeiPreMemConfig->AcpiReservedMemoryBase = S3MemVariable.AcpiReservedMemoryBase;
    MiscPeiPreMemConfig->AcpiReservedMemorySize = S3MemVariable.AcpiReservedMemorySize;
    MiscPeiPreMemConfig->SystemMemoryLength     = S3MemVariable.SystemMemoryLength;
#endif
  }

  VariableSize = sizeof (MorControl);
  Status = VariableServices->GetVariable(
                               VariableServices,
                               MEMORY_OVERWRITE_REQUEST_VARIABLE_NAME,
                               &gEfiMemoryOverwriteControlDataGuid,
                               NULL,
                               &VariableSize,
                               &MorControl
                               );
  if (EFI_ERROR (Status)) {
    MorControl = 0;
  }

  //
  // Get System configuration variables
  //
  VariableSize = sizeof (SI_SETUP);
  Status = VariableServices->GetVariable (
                               VariableServices,
                               L"SiSetup",
                               &gSiSetupVariableGuid,
                               NULL,
                               &VariableSize,
                               &SiSetup
                               );

  VariableSize = sizeof (SETUP_DATA);
  Status = VariableServices->GetVariable (
                               VariableServices,
                               PLATFORM_SETUP_VARIABLE_NAME,
                               &gSetupVariableGuid,
                               NULL,
                               &VariableSize,
                               &SetupData
                               );
  ASSERT_EFI_ERROR(Status);

  VariableSize = sizeof (SA_SETUP);
  Status2 = VariableServices->GetVariable (
                                VariableServices,
                                L"SaSetup",
                                &gSaSetupVariableGuid,
                                NULL,
                                &VariableSize,
                                &SaSetup
                                );
  ASSERT_EFI_ERROR(Status2);

  VariableSize = sizeof (CPU_SETUP);
  Status3 = VariableServices->GetVariable (
                                VariableServices,
                                L"CpuSetup",
                                &gCpuSetupVariableGuid,
                                NULL,
                                &VariableSize,
                                &CpuSetup
                                );
  ASSERT_EFI_ERROR(Status3);

  VariableSize = sizeof (PCH_SETUP);
  VariableServices->GetVariable (
                      VariableServices,
                      L"PchSetup",
                      &gPchSetupVariableGuid,
                      NULL,
                      &VariableSize,
                      &PchSetup
                      );

  //
  // Adjust MMIO size for TBT
  //
  for (Index = 0; Index < ITBT_ROOT_PORTS_SUPPORTED; Index++) {
    if (SetupData.ITbtRootPort[Index] == 1) {
      AdjustedMmioSize += SetupData.ITbtPcieMemRsvd[Index];
    }
  }
  PcdSet16S (PcdSaMiscMmioSizeAdjustment, AdjustedMmioSize);

  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.UserBd,     MiscPeiPreMemConfig->UserBd,      0); // It's a CRB mobile board by default (btCRBMB)
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CridEnable, MiscPeiPreMemConfig->CridEnable,  SaSetup.CridEnable);

#if (FixedPcdGetBool(PcdFspWrapperEnable) == 1) && (FixedPcdGet8(PcdFspModeSelection) == 0)
  MiscPeiPreMemConfig->TxtImplemented = 0;
#endif

  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuCrashLogDevice, TelemetryPreMemConfig->CpuCrashLogDevice, SaSetup.CpuCrashLogDevice);

  if (PcdGet32 (PcdMrcRcompTarget)) {
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.RcompTarget, (VOID *)RcompData->RcompTarget, (VOID *)(UINTN)PcdGet32 (PcdMrcRcompTarget), sizeof (UINT16) * MRC_MAX_RCOMP_TARGETS);
  }

  if (PcdGetBool (PcdMrcDqPinsInterleavedControl)) {
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DqPinsInterleaved, MemConfig->DqPinsInterleaved, PcdGetBool (PcdMrcDqPinsInterleaved));
  }

  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[0], MiscPeiPreMemConfig->SpdAddressTable[0], PcdGet8 (PcdMrcSpdAddressTable0));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[1], MiscPeiPreMemConfig->SpdAddressTable[1], PcdGet8 (PcdMrcSpdAddressTable1));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[2], MiscPeiPreMemConfig->SpdAddressTable[2], PcdGet8 (PcdMrcSpdAddressTable2));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[3], MiscPeiPreMemConfig->SpdAddressTable[3], PcdGet8 (PcdMrcSpdAddressTable3));

  NullSpdPtr = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (NullSpdPtr != NULL);

#if FixedPcdGet8(PcdFspModeSelection) == 1
  MemorySpdPtr000 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr000 != NULL);
  MemorySpdPtr010 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr010 != NULL);
  MemorySpdPtr020 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr020 != NULL);
  MemorySpdPtr030 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr030 != NULL);
  MemorySpdPtr100 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr100 != NULL);
  MemorySpdPtr110 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr110 != NULL);
  MemorySpdPtr120 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr120 != NULL);
  MemorySpdPtr130 = AllocateZeroPool (SPD_DATA_SIZE);
  ASSERT (MemorySpdPtr130 != NULL);
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr000 = (UINT32) MemorySpdPtr000;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr010 = (UINT32) MemorySpdPtr010;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr020 = (UINT32) MemorySpdPtr020;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr030 = (UINT32) MemorySpdPtr030;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr100 = (UINT32) MemorySpdPtr100;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr110 = (UINT32) MemorySpdPtr110;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr120 = (UINT32) MemorySpdPtr120;
  ((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr130 = (UINT32) MemorySpdPtr130;
#endif
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[4], MiscPeiPreMemConfig->SpdAddressTable[4], PcdGet8 (PcdMrcSpdAddressTable4));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[5], MiscPeiPreMemConfig->SpdAddressTable[5], PcdGet8 (PcdMrcSpdAddressTable5));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[6], MiscPeiPreMemConfig->SpdAddressTable[6], PcdGet8 (PcdMrcSpdAddressTable6));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[7], MiscPeiPreMemConfig->SpdAddressTable[7], PcdGet8 (PcdMrcSpdAddressTable7));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[8], MiscPeiPreMemConfig->SpdAddressTable[8], PcdGet8 (PcdMrcSpdAddressTable8));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[9], MiscPeiPreMemConfig->SpdAddressTable[9], PcdGet8 (PcdMrcSpdAddressTable9));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[10], MiscPeiPreMemConfig->SpdAddressTable[10], PcdGet8 (PcdMrcSpdAddressTable10));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[11], MiscPeiPreMemConfig->SpdAddressTable[11], PcdGet8 (PcdMrcSpdAddressTable11));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[12], MiscPeiPreMemConfig->SpdAddressTable[12], PcdGet8 (PcdMrcSpdAddressTable12));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[13], MiscPeiPreMemConfig->SpdAddressTable[13], PcdGet8 (PcdMrcSpdAddressTable13));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[14], MiscPeiPreMemConfig->SpdAddressTable[14], PcdGet8 (PcdMrcSpdAddressTable14));
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdAddressTable[15], MiscPeiPreMemConfig->SpdAddressTable[15], PcdGet8 (PcdMrcSpdAddressTable15));
  if (PcdGet32 (PcdMrcRcompResistor)) {
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RcompResistor, RcompData->RcompResistor, (UINT8) PcdGet32 (PcdMrcRcompResistor));
  }
  if (PcdGet32 (PcdMrcDqsMapCpu2Dram)) {
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.DqsMapCpu2DramMc0Ch0, (VOID *)MemConfigNoCrc->DqDqsMap->DqsMapCpu2Dram, (VOID *)(UINTN)PcdGet32 (PcdMrcDqsMapCpu2Dram), sizeof (UINT8) * MEM_CFG_MAX_CONTROLLERS * MEM_CFG_MAX_CHANNELS * MEM_CFG_NUM_BYTES_MAPPED);
  }
  if (PcdGet32 (PcdMrcDqMapCpu2Dram)) {
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.DqMapCpu2DramMc0Ch0, (VOID *)MemConfigNoCrc->DqDqsMap->DqMapCpu2Dram, (VOID *)(UINTN)PcdGet32 (PcdMrcDqMapCpu2Dram), sizeof (UINT8) * MEM_CFG_MAX_CONTROLLERS * MEM_CFG_MAX_CHANNELS * MEM_CFG_NUM_BYTES_MAPPED * 8);
  }
  if (PcdGetBool (PcdSpdPresent)) {
    // Clear SPD data so it can be filled in by the MRC init code
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr000, (VOID *) MemConfigNoCrc->SpdData->SpdData[0][0][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr010, (VOID *) MemConfigNoCrc->SpdData->SpdData[0][1][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr020, (VOID *) MemConfigNoCrc->SpdData->SpdData[0][2][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr030, (VOID *) MemConfigNoCrc->SpdData->SpdData[0][3][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr100, (VOID *) MemConfigNoCrc->SpdData->SpdData[1][0][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr110, (VOID *) MemConfigNoCrc->SpdData->SpdData[1][1][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr120, (VOID *) MemConfigNoCrc->SpdData->SpdData[1][2][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
    COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr130, (VOID *) MemConfigNoCrc->SpdData->SpdData[1][3][0], (VOID *)(UINT32) NullSpdPtr, SPD_DATA_SIZE);
  } else {
    if (PcdGet32 (PcdMrcSpdData)) {
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr000, (VOID *)MemConfigNoCrc->SpdData->SpdData[0][0][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr010, (VOID *)MemConfigNoCrc->SpdData->SpdData[0][1][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr020, (VOID *)MemConfigNoCrc->SpdData->SpdData[0][2][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr030, (VOID *)MemConfigNoCrc->SpdData->SpdData[0][3][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr100, (VOID *)MemConfigNoCrc->SpdData->SpdData[1][0][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr110, (VOID *)MemConfigNoCrc->SpdData->SpdData[1][1][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr120, (VOID *)MemConfigNoCrc->SpdData->SpdData[1][2][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
      COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.MemorySpdPtr130, (VOID *)MemConfigNoCrc->SpdData->SpdData[1][3][0], (VOID *)(UINTN)PcdGet32 (PcdMrcSpdData), SPD_DATA_SIZE);
    }
  }

  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc0Ch0, MemConfig->DisableDimmChannel[0][0], SaSetup.DisableDimmMc0Ch0);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc0Ch1, MemConfig->DisableDimmChannel[0][1], SaSetup.DisableDimmMc0Ch1);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc0Ch2, MemConfig->DisableDimmChannel[0][2], SaSetup.DisableDimmMc0Ch2);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc0Ch3, MemConfig->DisableDimmChannel[0][3], SaSetup.DisableDimmMc0Ch3);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc1Ch0, MemConfig->DisableDimmChannel[1][0], SaSetup.DisableDimmMc1Ch0);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc1Ch1, MemConfig->DisableDimmChannel[1][1], SaSetup.DisableDimmMc1Ch1);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc1Ch2, MemConfig->DisableDimmChannel[1][2], SaSetup.DisableDimmMc1Ch2);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisableDimmMc1Ch3, MemConfig->DisableDimmChannel[1][3], SaSetup.DisableDimmMc1Ch3);
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GearRatio,         MemConfig->GearRatio,                SaSetup.GearRatio);

  COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.SaGvGear, (VOID *) MemConfig->SaGvGear, (VOID *) SaSetup.SaGvGear, (MEM_MAX_SAGV_POINTS * sizeof(SaSetup.SaGvGear[0])) );
  COPY_POLICY ((VOID *)((FSPM_UPD *) FspmUpd)->FspmConfig.SaGvFreq, (VOID *) MemConfig->SaGvFreq, (VOID *) SaSetup.SaGvFreq, (MEM_MAX_SAGV_POINTS * sizeof(SaSetup.SaGvFreq[0])) );



  if (!EFI_ERROR(Status2)) {
    //
    // Get the Platform Configuration from SetupData
    //
#if FixedPcdGet8(PcdFspModeSelection) == 0
    HostBridgePreMemConfig->MchBar   = (UINTN) PcdGet64 (PcdMchBaseAddress);
    HostBridgePreMemConfig->DmiBar   = (UINTN) PcdGet64 (PcdDmiBaseAddress);
    HostBridgePreMemConfig->EpBar    = (UINTN) PcdGet64 (PcdEpBaseAddress);
    HostBridgePreMemConfig->EdramBar = (UINTN) PcdGet64 (PcdEdramBaseAddress);
    MiscPeiPreMemConfig->SmbusBar = (UINTN) PcdGet16 (PcdSmbusBaseAddress);
#endif
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TsegSize,           MiscPeiPreMemConfig->TsegSize,           PcdGet32 (PcdTsegSize));
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.UserBd,             MiscPeiPreMemConfig->UserBd,             PcdGet8 (PcdSaMiscUserBd));
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MmioSizeAdjustment, HostBridgePreMemConfig->MmioSizeAdjustment, PcdGet16 (PcdSaMiscMmioSizeAdjustment));
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EnableAbove4GBMmio, HostBridgePreMemConfig->EnableAbove4GBMmio, SaSetup.EnableAbove4GBMmio);
    //
    // For 2LM Sku, DSM is still required but only needs to be 4MB
    //
    if (SaSetup.DismSize != 0) {
      IgdDvmt50PreAlloc = 0xF0; // 4 MB
    } else {
      IgdDvmt50PreAlloc = SaSetup.IgdDvmt50PreAlloc;
    }

    //
    // Initialize the Graphics configuration
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IgdDvmt50PreAlloc,          GtPreMemConfig->IgdDvmt50PreAlloc,             IgdDvmt50PreAlloc);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.InternalGfx,                GtPreMemConfig->InternalGraphics,              SaSetup.InternalGraphics);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PrimaryDisplay,             GtPreMemConfig->PrimaryDisplay,                SaSetup.PrimaryDisplay);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ApertureSize,               GtPreMemConfig->ApertureSize,                  SaSetup.ApertureSize);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GttSize,                    GtPreMemConfig->GttSize,                       SaSetup.GTTSize);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GmAdr64,                    GtPreMemConfig->GmAdr64,                       (UINTN)PcdGet64(PcdGmAdrAddress));

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GttMmAdr,                   GtPreMemConfig->GttMmAdr,                      (UINTN)PcdGet64(PcdGttMmAddress));
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PsmiRegionSize,             GtPreMemConfig->PsmiRegionSize,                SaSetup.GtPsmiRegionSize);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DismSize,                   GtPreMemConfig->DismSize,                      SaSetup.DismSize);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtClosEnable,               GtPreMemConfig->GtClosEnable,                  SaSetup.GtClosEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DfdRestoreEnable,           GtPreMemConfig->DfdRestoreEnable,              SaSetup.DfdRestoreEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtPsmiSupport,              GtPreMemConfig->GtPsmiSupport,                 SaSetup.GtPsmiSupport);

    //
    // Display DDI Initialization ( default Native GPIO as per board during AUTO case)
    //
    CopyMem (SaDisplayConfigTable, (VOID *) (UINTN) PcdGet32 (PcdSaDisplayConfigTable), (UINTN)PcdGet16 (PcdSaDisplayConfigTableSize));
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortAConfig,          GtPreMemConfig->DdiConfiguration.DdiPortAConfig,       SaDisplayConfigTable[0]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortBConfig,          GtPreMemConfig->DdiConfiguration.DdiPortBConfig,       SaDisplayConfigTable[1]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortAHpd,             GtPreMemConfig->DdiConfiguration.DdiPortAHpd,          SaDisplayConfigTable[2]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortBHpd,             GtPreMemConfig->DdiConfiguration.DdiPortBHpd,          SaDisplayConfigTable[3]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortCHpd,             GtPreMemConfig->DdiConfiguration.DdiPortCHpd,          SaDisplayConfigTable[4]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort1Hpd,             GtPreMemConfig->DdiConfiguration.DdiPort1Hpd,          SaDisplayConfigTable[5]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort2Hpd,             GtPreMemConfig->DdiConfiguration.DdiPort2Hpd,          SaDisplayConfigTable[6]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort3Hpd,             GtPreMemConfig->DdiConfiguration.DdiPort3Hpd,          SaDisplayConfigTable[7]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort4Hpd,             GtPreMemConfig->DdiConfiguration.DdiPort4Hpd,          SaDisplayConfigTable[8]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortADdc,             GtPreMemConfig->DdiConfiguration.DdiPortADdc,          SaDisplayConfigTable[9]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortBDdc,             GtPreMemConfig->DdiConfiguration.DdiPortBDdc,          SaDisplayConfigTable[10]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPortCDdc,             GtPreMemConfig->DdiConfiguration.DdiPortCDdc,          SaDisplayConfigTable[11]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort1Ddc,             GtPreMemConfig->DdiConfiguration.DdiPort1Ddc,          SaDisplayConfigTable[12]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort2Ddc,             GtPreMemConfig->DdiConfiguration.DdiPort2Ddc,          SaDisplayConfigTable[13]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort3Ddc,             GtPreMemConfig->DdiConfiguration.DdiPort3Ddc,          SaDisplayConfigTable[14]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdiPort4Ddc,             GtPreMemConfig->DdiConfiguration.DdiPort4Ddc,          SaDisplayConfigTable[15]);

#if FixedPcdGet8(PcdFspModeSelection) == 0
    if (GtPreMemConfig->DdiConfiguration.DdiPortAConfig == DdiPortMipiDsi) {
      SaSetup.VbtSelect = VBT_SELECT_MIPI;
    }
#endif
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.InitPcieAspmAfterOprom,     PciePeiPreMemConfig->InitPcieAspmAfterOprom,   SaSetup.InitAspmAfterOprom);

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiDeEmphasis,              CpuDmiPreMemConfig->DmiDeEmphasis,            SaSetup.DmiDeEmphasis);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiGen3ProgramStaticEq,     CpuDmiPreMemConfig->DmiGen3ProgramStaticEq,   SaSetup.DmiGen3ProgramStaticEq);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiAspm,                    CpuDmiPreMemConfig->DmiAspm,                  SaSetup.DmiAspm);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiAspmCtrl,                CpuDmiPreMemConfig->DmiAspmCtrl,              SaSetup.DmiAspmCtrl);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiAspmL1ExitLatency,       CpuDmiPreMemConfig->DmiAspmL1ExitLatency,     SaSetup.DmiAspmL1ExitLatency);
    for (Lane = 0; Lane < SA_DMI_MAX_LANE; Lane++) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiGen3RootPortPreset[Lane],     CpuDmiPreMemConfig->DmiGen3RootPortPreset[Lane],                SaSetup.DmiGen3RootPortPreset[Lane]);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiGen3EndPointPreset[Lane],     CpuDmiPreMemConfig->DmiGen3EndPointPreset[Lane],                SaSetup.DmiGen3EndPointPreset[Lane]);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiGen3EndPointHint[Lane],       CpuDmiPreMemConfig->DmiGen3EndPointHint[Lane],                  SaSetup.DmiGen3EndPointHint[Lane]);
    }
    for (Bundle = 0; Bundle < SA_DMI_MAX_BUNDLE; Bundle++) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmiGen3RxCtlePeaking[Bundle], CpuDmiPreMemConfig->DmiGen3RxCtlePeaking[Bundle], SaSetup.DmiGen3RxCtlePeaking[Bundle]);
    }

    //
    // External Graphics card scan option.
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SkipExtGfxScan,           MiscPeiPreMemConfig->SkipExtGfxScan,           SaSetup.SkipExtGfxScan);

      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WrcFeatureEnable, MiscPeiPreMemConfig->WrcFeatureEnable, SaSetup.WrcFeatureEnable);

#if FixedPcdGetBool(PcdHgEnable) == 1
    //
    // SaRtd3Pcie GPIO configuration
    //
    if (SaSetup.PcieCardSelect != 2) {
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.RootPortIndex,        HgGpioData->RootPortIndex,                         PcdGet8 (PcdRootPortIndex));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.HgSlot,               HgGpioData->HgSlot,                                SaSetup.HgSlot);
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[0],  HgGpioData->CpuPcie0Rtd3Gpio.HoldRst.ExpanderNo,   PcdGet8 (PcdPcie0HoldRstExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[1],  HgGpioData->CpuPcie0Rtd3Gpio.HoldRst.Active,       PcdGetBool (PcdPcie0HoldRstActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[4],  HgGpioData->CpuPcie0Rtd3Gpio.HoldRst.GpioNo,       PcdGet32 (PcdPcie0HoldRstGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[8],  HgGpioData->CpuPcie0Rtd3Gpio.PwrEnable.ExpanderNo, PcdGet8 (PcdPcie0PwrEnableExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[9],  HgGpioData->CpuPcie0Rtd3Gpio.PwrEnable.Active,     PcdGetBool (PcdPcie0PwrEnableActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[12], HgGpioData->CpuPcie0Rtd3Gpio.PwrEnable.GpioNo,     PcdGet32 (PcdPcie0PwrEnableGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[20], HgGpioData->CpuPcie0Rtd3Gpio.GpioSupport,          PcdGet8 (PcdPcie0GpioSupport));

      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[0],  HgGpioData->CpuPcie1Rtd3Gpio.HoldRst.ExpanderNo,   PcdGet8(PcdPcie1HoldRstExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[1],  HgGpioData->CpuPcie1Rtd3Gpio.HoldRst.Active,       PcdGetBool(PcdPcie1HoldRstActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[4],  HgGpioData->CpuPcie1Rtd3Gpio.HoldRst.GpioNo,       PcdGet32(PcdPcie1HoldRstGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[8],  HgGpioData->CpuPcie1Rtd3Gpio.PwrEnable.ExpanderNo, PcdGet8(PcdPcie1PwrEnableExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[9],  HgGpioData->CpuPcie1Rtd3Gpio.PwrEnable.Active,     PcdGetBool(PcdPcie1PwrEnableActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[12], HgGpioData->CpuPcie1Rtd3Gpio.PwrEnable.GpioNo,     PcdGet32(PcdPcie1PwrEnableGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie1Rtd3Gpio[20], HgGpioData->CpuPcie1Rtd3Gpio.GpioSupport,          PcdGet8(PcdPcie1GpioSupport));

      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[0],  HgGpioData->CpuPcie2Rtd3Gpio.HoldRst.ExpanderNo,   PcdGet8(PcdPcie2HoldRstExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[1],  HgGpioData->CpuPcie2Rtd3Gpio.HoldRst.Active,       PcdGetBool(PcdPcie2HoldRstActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[4],  HgGpioData->CpuPcie2Rtd3Gpio.HoldRst.GpioNo,       PcdGet32(PcdPcie2HoldRstGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[8],  HgGpioData->CpuPcie2Rtd3Gpio.PwrEnable.ExpanderNo, PcdGet8(PcdPcie2PwrEnableExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[9],  HgGpioData->CpuPcie2Rtd3Gpio.PwrEnable.Active,     PcdGetBool(PcdPcie2PwrEnableActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[12], HgGpioData->CpuPcie2Rtd3Gpio.PwrEnable.GpioNo,     PcdGet32(PcdPcie2PwrEnableGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie2Rtd3Gpio[20], HgGpioData->CpuPcie2Rtd3Gpio.GpioSupport,          PcdGet8(PcdPcie2GpioSupport));

      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[0],  HgGpioData->CpuPcie3Rtd3Gpio.HoldRst.ExpanderNo,   PcdGet8(PcdPcie3HoldRstExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[1],  HgGpioData->CpuPcie3Rtd3Gpio.HoldRst.Active,       PcdGetBool(PcdPcie3HoldRstActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[4],  HgGpioData->CpuPcie3Rtd3Gpio.HoldRst.GpioNo,       PcdGet32(PcdPcie3HoldRstGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[8],  HgGpioData->CpuPcie3Rtd3Gpio.PwrEnable.ExpanderNo, PcdGet8(PcdPcie3PwrEnableExpanderNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[9],  HgGpioData->CpuPcie3Rtd3Gpio.PwrEnable.Active,     PcdGetBool(PcdPcie3PwrEnableActive));
      UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[12], HgGpioData->CpuPcie3Rtd3Gpio.PwrEnable.GpioNo,     PcdGet32(PcdPcie3PwrEnableGpioNo));
      UPDATE_POLICY (*(UINT8  *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie3Rtd3Gpio[20], HgGpioData->CpuPcie3Rtd3Gpio.GpioSupport,          PcdGet8(PcdPcie3GpioSupport));
    }

    ///
    /// For Elk-Creek card, invert the Power enable signal
    ///
    if (SaSetup.PcieCardSelect == 0) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuPcie0Rtd3Gpio[9],  HgGpioData->CpuPcie0Rtd3Gpio.PwrEnable.Active, !(HgGpioData->CpuPcie0Rtd3Gpio.PwrEnable.Active));
    }
    //
    // Initialize the Hybrid Graphics Configuration
    //
    if (SaSetup.PrimaryDisplay == 4) {
      ///
      /// In Hybrid Gfx mode PCIe needs to be always enabled and IGFX must be set as Primary Display.
      ///
#if FixedPcdGet8(PcdFspModeSelection) == 0
      HgGpioData->HgMode = 2;  //HgModeMuxless
      HgGpioData->HgSubSystemId = 0x2112;
      GtPreMemConfig->PrimaryDisplay = 0;
#endif
    } else if ((SaSetup.PrimaryDisplay == 1) || (SaSetup.PrimaryDisplay == 2) || (SaSetup.PrimaryDisplay == 3)) {
      ///
      /// In PEG or PCI or Auto mode set Hybrid Gfx mode as dGPU
      ///
#if FixedPcdGetBool(PcdFspModeSelection) == 0
      HgGpioData->HgMode = 3;  //HgModeDgpu
      HgGpioData->HgSubSystemId = 0x2212;
#endif
    } else if (SaSetup.PrimaryDisplay == 0) {
      ///
      /// In IGFX only mode mode set Hybrid Gfx mode as Disabled
      ///
#if FixedPcdGetBool(PcdFspModeSelection) == 0
      HgGpioData->HgMode = 0;  //HgModeDisabled
      HgGpioData->HgSubSystemId = 0x2212;
#endif
    }

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.HgDelayAfterPwrEn,     HgGpioData->HgDelayAfterPwrEn,     SaSetup.DelayAfterPwrEn);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.HgDelayAfterHoldReset, HgGpioData->HgDelayAfterHoldReset, SaSetup.DelayAfterHoldReset);
#endif

    ///
    /// Initialize the VTD Configuration
    ///
    if (SaSetup.EnableVtd == 0) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdDisable,   Vtd->VtdDisable,   1);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.X2ApicOptOut, Vtd->X2ApicOptOut, 1);
      for (Index = 0; Index < GetMaxVtdEngineNumber(); Index++) {
        UPDATE_POLICY(((FSPM_UPD *)FspmUpd)->FspmConfig.VtdBaseAddress[Index], Vtd->BaseAddress[Index], 0);
      }
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PreBootDmaMask, Vtd->PreBootDmaMask, 0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmaBufferSize, Vtd->DmaBufferSize, 0);
    } else {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdDisable,   Vtd->VtdDisable,   0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.X2ApicOptOut, Vtd->X2ApicOptOut, SaSetup.X2ApicOptOut);
      for (Index = 0; Index < GetMaxVtdEngineNumber(); Index++) {
        UPDATE_POLICY(((FSPM_UPD *)FspmUpd)->FspmConfig.VtdBaseAddress[Index], Vtd->BaseAddress[Index], GetVtdBaseAddress (Index));
      }
      if ((SetupData.ControlIommu) != 0) {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PreBootDmaMask, Vtd->PreBootDmaMask, 1);
      } else {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PreBootDmaMask, Vtd->PreBootDmaMask, 0);
      }
      PeiServicesGetBootMode (&SysBootMode);
      if (SysBootMode == BOOT_ON_S3_RESUME) {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmaBufferSize, Vtd->DmaBufferSize, PcdGet32 (PcdVTdPeiDmaBufferSizeS3));
      } else {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmaBufferSize, Vtd->DmaBufferSize, PcdGet32 (PcdVTdPeiDmaBufferSize));
      }
    }
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DmaControlGuarantee, Vtd->DmaControlGuarantee, SaSetup.DmaControlGuarantee);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdIgdEnable, Vtd->VtdIgdEnable, SaSetup.VtdIgdEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdIpuEnable, Vtd->VtdIpuEnable, SaSetup.VtdIpuEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdIopEnable, Vtd->VtdIopEnable, SaSetup.VtdIopEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VtdItbtEnable, Vtd->VtdItbtEnable, SaSetup.VtdItbtEnable);


#if FixedPcdGetBool(PcdIpuEnable) == 1
    //
    // Initialize IPU PreMem Configuration
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaIpuEnable,           IpuPreMemPolicy->IpuEnable,           SaSetup.SaIpuEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaIpuImrConfiguration, IpuPreMemPolicy->IpuImrConfiguration, SaSetup.SaIpuImrConfiguration);

    if (SetupData.MipiCam_Link0 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link0_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link0_DriverData_LinkUsed],  SetupData.MipiCam_Link0_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link0_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link0_DriverData_LinkUsed],  SetupData.MipiCam_Link0_DriverData_CsiSpeed);
    }
    if (SetupData.MipiCam_Link1 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link1_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link1_DriverData_LinkUsed],  SetupData.MipiCam_Link1_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link1_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link1_DriverData_LinkUsed],  SetupData.MipiCam_Link1_DriverData_CsiSpeed);
    }
    if (SetupData.MipiCam_Link2 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link2_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link2_DriverData_LinkUsed],  SetupData.MipiCam_Link2_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link2_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link2_DriverData_LinkUsed],  SetupData.MipiCam_Link2_DriverData_CsiSpeed);
    }
    if (SetupData.MipiCam_Link3 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link3_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link3_DriverData_LinkUsed],  SetupData.MipiCam_Link3_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link3_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link3_DriverData_LinkUsed],  SetupData.MipiCam_Link3_DriverData_CsiSpeed);
    }
    if (SetupData.MipiCam_Link4 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link4_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link4_DriverData_LinkUsed],  SetupData.MipiCam_Link4_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link4_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link4_DriverData_LinkUsed],  SetupData.MipiCam_Link4_DriverData_CsiSpeed);
    }
    if (SetupData.MipiCam_Link5 == 1) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IpuLaneUsed[SetupData.MipiCam_Link5_DriverData_LinkUsed],\
                        IpuPreMemPolicy->LaneUsed[SetupData.MipiCam_Link5_DriverData_LinkUsed],  SetupData.MipiCam_Link5_DriverData_LaneUsed);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CsiSpeed[SetupData.MipiCam_Link5_DriverData_LinkUsed],\
                        IpuPreMemPolicy->CsiSpeed[SetupData.MipiCam_Link5_DriverData_LinkUsed],  SetupData.MipiCam_Link5_DriverData_CsiSpeed);
    }

#endif
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.HobBufferSize,         MemConfig->HobBufferSize,      SaSetup.HobBufferSize);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EccSupport,            MemConfig->EccSupport,         SaSetup.EccSupport);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaGv,                  MemConfig->SaGv,               SaSetup.SaGv);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EpgEnable,             MemConfig->EpgEnable,          SaSetup.EpgEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Idd3n,                 MemConfig->Idd3n,              SaSetup.Idd3n);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Idd3p,                 MemConfig->Idd3p,              SaSetup.Idd3p);

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SpdProfileSelected,    MemConfig->SpdProfileSelected, (CpuSetup.OverclockingSupport == 0) ? 0 : SaSetup.SpdProfileSelected);

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ibecc,              MemConfig->Ibecc,              SaSetup.Ibecc);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IbeccParity,        MemConfig->IbeccParity,        SaSetup.IbeccParity);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IbeccOperationMode, MemConfig->IbeccOperationMode, SaSetup.IbeccOperationMode);
    for (Index = 0; Index < MAX_IBECC_REGIONS; Index ++) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IbeccProtectedRegionEnable[Index], MemConfig->IbeccProtectedRegionEnable[Index], SaSetup.IbeccProtectedRegionEnable[Index]);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IbeccProtectedRegionBase[Index],   MemConfig->IbeccProtectedRegionBase[Index],   SaSetup.IbeccProtectedRegionBase[Index]);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.IbeccProtectedRegionMask[Index],   MemConfig->IbeccProtectedRegionMask[Index],   SaSetup.IbeccProtectedRegionMask[Index]);
    }

    //
    // If user custom profile is selected, we will send the setup values to the MRC.
    // The setup values will be the current memory settings plus user override values.
    // If any other profile is selected or a WDT timeout has occured, we zero out
    // the settings just to be safe.
    //
    gWdtPei = NULL;
    Status = PeiServicesLocatePpi(
               &gWdtPpiGuid,
               0,
               NULL,
               (VOID **) &gWdtPei
               );
    if (gWdtPei != NULL) {
      WdtTimeout = gWdtPei->CheckStatus();
    } else {
      WdtTimeout = FALSE;
    }

    if ((SaSetup.SpdProfileSelected == UserDefined) && (WdtTimeout == FALSE)) {
      //
      // If USER custom profile is selected, we will start the WDT.
      //
      if (gWdtPei != NULL) {
        Status = gWdtPei->ReloadAndStart(WDT_TIMEOUT);
      }

      //
      // Read DDR RefClk setting selected in Bios setup, 0 for 133MHz and 1 for 100MHz.
      //
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VddVoltage,   MemConfig->VddVoltage,          SaSetup.MemoryVoltage); // Vddq in [mV], 0 = platform default.
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RefClk,       MemConfig->RefClk,              SaSetup.DdrRefClk);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ratio,        MemConfig->Ratio,               SaSetup.DdrRatio);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tCL,          MemConfig->tCL,                 SaSetup.tCL);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tCWL,         MemConfig->tCWL,                SaSetup.tCWL);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tFAW,         MemConfig->tFAW,                SaSetup.tFAW);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRAS,         MemConfig->tRAS,                SaSetup.tRAS);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRCDtRP,      MemConfig->tRCDtRP,             SaSetup.tRCDtRP);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tREFI,        MemConfig->tREFI,               SaSetup.tREFI);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRFC,         MemConfig->tRFC,                SaSetup.tRFC);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRRD,         MemConfig->tRRD,                SaSetup.tRRD);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRTP,         MemConfig->tRTP,                SaSetup.tRTP);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tWR,          MemConfig->tWR,                 SaSetup.tWR);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tWTR,         MemConfig->tWTR,                SaSetup.tWTR);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NModeSupport, MemConfig->NModeSupport,        SaSetup.NModeSupport);
    } else {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.VddVoltage,   MemConfig->VddVoltage,          0); // Use platform default as the safe value.
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ratio,        MemConfig->Ratio,               0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tCL,          MemConfig->tCL,                 0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tCWL,         MemConfig->tCWL,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tFAW,         MemConfig->tFAW,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRAS,         MemConfig->tRAS,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRCDtRP,      MemConfig->tRCDtRP,             0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tREFI,        MemConfig->tREFI,               0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRFC,         MemConfig->tRFC,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRRD,         MemConfig->tRRD,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tRTP,         MemConfig->tRTP,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tWR,          MemConfig->tWR,                 0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.tWTR,         MemConfig->tWTR,                0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NModeSupport, MemConfig->NModeSupport,        0);
    }
    UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.CmdMirror,        MemConfig->CmdMirror,        0x00); // BitMask where bits [3:0] are controller 0 Channel [3:0] and [7:4] are Controller 1 Channel [3:0].  0 = No Command Mirror and 1 = Command Mirror.
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RemapEnable,      MemConfig->RemapEnable,      SaSetup.RemapEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MrcFastBoot,      MemConfig->MrcFastBoot,      SaSetup.MrcFastBoot);

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PowerDownMode,            MemConfig->PowerDownMode,         SaSetup.PowerDownMode);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PwdwnIdleCounter,         MemConfig->PwdwnIdleCounter,      SaSetup.PwdwnIdleCounter);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DisPgCloseIdleTimeout,    MemConfig->DisPgCloseIdleTimeout, SaSetup.DisPgCloseIdleTimeout);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ScramblerSupport,         MemConfig->ScramblerSupport,      SaSetup.ScramblerSupport);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TrainTrace,               MemConfig->TrainTrace,            SaSetup.TrainTrace);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RmtPerTask,               MemConfig->RmtPerTask,            SaSetup.RmtPerTask);
    DEBUG_CODE (
      DEBUG_CONFIG_DATA DebugConfigData;

      VariableSize = sizeof (DEBUG_CONFIG_DATA);
      Status = VariableServices->GetVariable (
                                   VariableServices,
                                   L"DebugConfigData",
                                   &gDebugConfigVariableGuid,
                                   NULL,
                                   &VariableSize,
                                   &DebugConfigData
                                   );
      ASSERT_EFI_ERROR (Status);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SerialDebugMrcLevel, MemConfigNoCrc->SerialDebugLevel, DebugConfigData.SerialDebugMrcLevel);
    );
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ECT,                   MemConfig->ECT,                 SaSetup.ECT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PDA,                   MemConfig->PDA,                 SaSetup.PDA);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SOT,                   MemConfig->SOT,                 SaSetup.SOT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ERDMPRTC2D,            MemConfig->ERDMPRTC2D,          SaSetup.ERDMPRTC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDMPRT,                MemConfig->RDMPRT,              SaSetup.RDMPRT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RCVET,                 MemConfig->RCVET,               SaSetup.RCVET);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.JWRL,                  MemConfig->JWRL,                SaSetup.JWRL);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EWRTC2D,               MemConfig->EWRTC2D,             SaSetup.EWRTC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ERDTC2D,               MemConfig->ERDTC2D,             SaSetup.ERDTC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRTC1D,                MemConfig->WRTC1D,              SaSetup.WRTC1D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRVC1D,                MemConfig->WRVC1D,              SaSetup.WRVC1D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDTC1D,                MemConfig->RDTC1D,              SaSetup.RDTC1D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DIMMODTT,              MemConfig->DIMMODTT,            SaSetup.DIMMODTT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DIMMRONT,              MemConfig->DIMMRONT,            SaSetup.DIMMRONT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRSRT,                 MemConfig->WRSRT,               SaSetup.WRSRT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDODTT,                MemConfig->RDODTT,              SaSetup.RDODTT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDEQT,                 MemConfig->RDEQT,               SaSetup.RDEQT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRDSEQT,               MemConfig->WRDSEQT,             SaSetup.WRDSEQT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TXTCO,                 MemConfig->TXTCO,               SaSetup.TXTCO);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TXTCODQS,              MemConfig->TXTCODQS,            SaSetup.TXTCODQS);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CMDDRUD,               MemConfig->CMDDRUD,             SaSetup.CMDDRUD);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DIMMODTCA,             MemConfig->DIMMODTCA,           SaSetup.DIMMODTCA);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDAPT,                 MemConfig->RDAPT,               SaSetup.RDAPT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRTC2D,                MemConfig->WRTC2D,              SaSetup.WRTC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDTC2D,                MemConfig->RDTC2D,              SaSetup.RDTC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRVC2D,                MemConfig->WRVC2D,              SaSetup.WRVC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RDVC2D,                MemConfig->RDVC2D,              SaSetup.RDVC2D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CMDVC,                 MemConfig->CMDVC,               SaSetup.CMDVC);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.LCT,                   MemConfig->LCT,                 SaSetup.LCT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RTL,                   MemConfig->RTL,                 SaSetup.RTL);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TAT,                   MemConfig->TAT,                 SaSetup.TAT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RCVENC1D,              MemConfig->RCVENC1D,            SaSetup.RCVENC1D);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RMT,                   MemConfig->RMT,                 SaSetup.RMT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RMTBIT,                MemConfig->RMTBIT,              SaSetup.RMTBIT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MEMTST,                MemConfig->MEMTST,              SaSetup.MEMTST);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ALIASCHK,              MemConfig->ALIASCHK,            SaSetup.ALIASCHK);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RMC,                   MemConfig->RMC,                 SaSetup.RMC);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.WRDSUDT,               MemConfig->WRDSUDT,             SaSetup.WRDSUDT);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DCC,                   MemConfig->DCC,                 SaSetup.DCC);

    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MrcSafeConfig,         MemConfig->MrcSafeConfig,       SaSetup.MrcSafeConfig);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SafeMode,              MemConfig->SafeMode,            SaSetup.SafeMode);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaGv,                  MemConfig->SaGv,                SaSetup.SaGv);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ddr4OneDpc,            MemConfig->Ddr4OneDpc,          SaSetup.Ddr4OneDpc);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.LpDdrDqDqsReTraining,  MemConfig->LpDqsOscEn,          SaSetup.LpDdrDqDqsReTraining);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ExitOnFailure,         MemConfig->ExitOnFailure,       SaSetup.ExitOnFailure);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NewFeatureEnable1,     MemConfig->NewFeatureEnable1,   SaSetup.NewFeatureEnable1);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NewFeatureEnable2,     MemConfig->NewFeatureEnable2,   SaSetup.NewFeatureEnable2);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ChHashOverride,        MemConfig->ChHashOverride,      SaSetup.ChHashOverride);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ChHashEnable,          MemConfig->ChHashEnable,        SaSetup.ChHashEnable);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ChHashMask,            MemConfig->ChHashMask,          SaSetup.ChHashMask);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ChHashInterleaveBit,   MemConfig->ChHashInterleaveBit, SaSetup.ChHashInterleaveBit);

    UPDATE_POLICY (*(UINT32 *)&((FSPM_UPD *) FspmUpd)->FspmConfig.Lp5CccConfig, MemConfig->Lp5CccConfig,     SaSetup.Lp5CccConfig);
    //
    // Thermal Options
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EnablePwrDn,        MemConfig->EnablePwrDn,        SaSetup.EnablePwrDn);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.EnablePwrDnLpddr,   MemConfig->EnablePwrDnLpddr,   SaSetup.EnablePwrDnLpddr);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Refresh2X,          MemConfig->Refresh2X,          SaSetup.Refresh2X);


    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SrefCfgEna,               MemConfig->SrefCfgEna,            SaSetup.SrefCfgEna);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ThrtCkeMinDefeat,         MemConfig->ThrtCkeMinDefeat,      SaSetup.ThrtCkeMinDefeat);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ThrtCkeMinTmr,            MemConfig->ThrtCkeMinTmr,         SaSetup.ThrtCkeMinTmr);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.ThrtCkeMinDefeatLpddr,    MemConfig->ThrtCkeMinDefeatLpddr, SaSetup.ThrtCkeMinDefeatLpddr);

#if FixedPcdGet8(PcdFspModeSelection) == 0
    MemConfig->ThrtCkeMinTmrLpddr = SaSetup.ThrtCkeMinTmrLpddr;
#endif

#if FixedPcdGet8(PcdFspModeSelection) == 0
    MemConfig->RetrainOnFastFail = SaSetup.RetrainOnFastFail;
#endif

    //
    // Setup BCLK value is in 10kHz units. Convert to Hertz for MRC to use. We need to round
    // the BCLK value to the nearest coarse BCLK freq.
    //
    RoundedBclkFreq = SaSetup.BclkFrequency * 10000;
    if (RoundedBclkFreq > BCLK_MAX) {
      RoundedBclkFreq = BCLK_MAX;
    } else if (RoundedBclkFreq < BCLK_100) {
      RoundedBclkFreq = BCLK_100;
    }

    if ((RoundedBclkFreq % BCLK_GRANULARITY) != 0) {
      RoundedBclkFreq += (BCLK_GRANULARITY - (RoundedBclkFreq % BCLK_GRANULARITY));
    }
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.BClkFrequency, MemConfig->BClkFrequency, RoundedBclkFreq);

    //
    // BCLK RFI value is in 10kHz units. Convert to Hertz for MRC to use.
    //
    for (Index = 0; Index < MAX_BCLK_RFI_POINTS; Index++) {
      RoundedBclkFreq = CpuSetup.BclkRfi10KhzFreq[Index] * 10000;
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.BclkRfiFreq[Index], MemConfig->BclkRfiFreq[Index], RoundedBclkFreq);
    }
    //
    // DDR Frequency Limit (0 = Auto)
    // The values must match the definitions in IcelakeSiliconPkg\SystemAgent\MemoryInit\Include\MrcInterface.h
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DdrFreqLimit, MemConfig->DdrFreqLimit, SaSetup.DdrFreqLimit);

    //
    // Update MemTestOnWarmBoot variable. Default is run BaseMemoryTest on warm boot.
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MemTestOnWarmBoot, MemConfigNoCrc->MemTestOnWarmBoot, SaSetup.MemTestOnWarmBoot);

    //
    // Update CleanMemory variable from Memory overwrite request value. Ignore if we are performing capsule update.
    //
    if ((BootMode != BOOT_ON_FLASH_UPDATE) && (BootMode != BOOT_ON_S3_RESUME)) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CleanMemory, MemConfigNoCrc->CleanMemory, (BOOLEAN)(MorControl & MOR_CLEAR_MEMORY_BIT_MASK));
    }

    //
    // Based on BIOS setup to determine maximum top of memory size below 4G, and reserved for MMIO
    //
    switch (SaSetup.MaxTolud) {
      case MAX_TOLUD_DYNAMIC:
        MmioSize = 0x0;
        break;
      case MAX_TOLUD_1G:
        MmioSize = 0xC00;
        break;
      case MAX_TOLUD_1_25G:
        MmioSize = 0xB00;
        break;
      case MAX_TOLUD_1_5G:
        MmioSize = 0xA00;
        break;
      case MAX_TOLUD_1_75G:
        MmioSize = 0x900;
        break;
      case MAX_TOLUD_2G:
        MmioSize = 0x800;
        break;
      case MAX_TOLUD_2_25G:
        MmioSize = 0x700;
        break;
      case MAX_TOLUD_2_5G:
        MmioSize = 0x600;
        break;
      case MAX_TOLUD_2_75G:
        MmioSize = 0x500;
        break;
      default:
      case MAX_TOLUD_3G:
        MmioSize = 0x400;
        break;
      case MAX_TOLUD_3_25G:
        MmioSize = 0x300;
        break;
      case MAX_TOLUD_3_5G:
        MmioSize = 0x200;
        break;
    }
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MmioSize, HostBridgePreMemConfig->MmioSize, MmioSize);
#ifndef CPU_CFL
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuTraceHubMode,        CpuTraceHubPreMemConfig->TraceHub.EnableMode,         SaSetup.CpuTraceHubMode);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuTraceHubMemReg0Size, CpuTraceHubPreMemConfig->TraceHub.MemReg0Size, SaSetup.CpuTraceHubMemReg0Size);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuTraceHubMemReg1Size, CpuTraceHubPreMemConfig->TraceHub.MemReg1Size, SaSetup.CpuTraceHubMemReg1Size);
    //
    // When DCD bit is set, the CPU Trace Hub Mem Buffer Size 1 is hidden,
    // the expectation is MSC1BAR and MSC1SIZE should 0x0.
    //
    if (IsCpuDebugDisabled ()) {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.CpuTraceHubMemReg1Size, CpuTraceHubPreMemConfig->TraceHub.MemReg1Size, 0);
    }
#endif
  }

#if FixedPcdGet8(PcdFspModeSelection) == 0
  //
  // mutiplied by 2 for adding aligned memory (overhead) for natural alignment.
  // please refer to InternalAllocateAlignedPages (), the overhead will be free when creating memory map, it won't waste
  //
  TraceHubTotalMemSize = 2 * TraceHubCalculateTotalBufferSize (
                               SiSetup.PlatformDebugConsent,
                               SaSetup.CpuTraceHubMode,
                               SaSetup.CpuTraceHubMemReg0Size,
                               SaSetup.CpuTraceHubMemReg1Size,
                               PchSetup.PchTraceHubMode,
                               PchSetup.PchTraceHubMemReg0Size,
                               PchSetup.PchTraceHubMemReg1Size
                               );
#endif

  DataSize = sizeof (MemoryData);
  Status = VariableServices->GetVariable (
                               VariableServices,
                               EFI_MEMORY_TYPE_INFORMATION_VARIABLE_NAME,
                               &gEfiMemoryTypeInformationGuid,
                               NULL,
                               &DataSize,
                               &MemoryData
                               );
  ///
  /// Accumulate maximum amount of memory needed
  ///
#if FixedPcdGet8(PcdFspModeSelection) == 1
  PlatformMemorySize = ((FSPM_UPD *) FspmUpd)->FspmConfig.PlatformMemorySize;
#else
  PlatformMemorySize = MemConfigNoCrc->PlatformMemorySize;
#endif
  if (EFI_ERROR (Status)) {
    if (BootMode == BOOT_IN_RECOVERY_MODE) {
      PlatformMemorySize = PEI_RECOVERY_MIN_MEMORY_SIZE;
    } else {
      ///
      /// Use default value to avoid memory fragment. Plus tracehub memory if required.
      /// OS boot/installation fails if there is not enough continuous memory available
      ///
      PlatformMemorySize = PEI_MIN_MEMORY_SIZE + TraceHubTotalMemSize;
      DataSize = sizeof (mDefaultMemoryTypeInformation);
      CopyMem (MemoryData, mDefaultMemoryTypeInformation, DataSize);
    }
  } else {
    ///
    /// Start with at least PEI_MIN_MEMORY_SIZE of memory for the DXE Core and the DXE Stack
    ///
    PlatformMemorySize = PEI_MIN_MEMORY_SIZE + TraceHubTotalMemSize;
  }
  UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PlatformMemorySize, MemConfigNoCrc->PlatformMemorySize, PlatformMemorySize);

  if (BootMode != BOOT_IN_RECOVERY_MODE) {
    for (Index = 0; Index < DataSize / sizeof (EFI_MEMORY_TYPE_INFORMATION); Index++) {
      PlatformMemorySize += MemoryData[Index].NumberOfPages * EFI_PAGE_SIZE;
    }
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PlatformMemorySize, MemConfigNoCrc->PlatformMemorySize, PlatformMemorySize);
    //
    // Initialize the Overclocking Configuration
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.OcSupport, OcPreMemConfig->OcSupport, CpuSetup.OverclockingSupport);

#if FixedPcdGet8(PcdFspModeSelection) == 1
    if (((FSPM_UPD *) FspmUpd)->FspmConfig.OcSupport && (WdtTimeout == FALSE)) {
#else
    if (OcPreMemConfig->OcSupport && (WdtTimeout == FALSE)) {
#endif
      //
      // SA Domain
      //
      if (SaSetup.UncoreVoltageOffsetPrefix == 1) {
        //
        // Offset is negative, need to convert
        //
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaVoltageOffset, OcPreMemConfig->SaVoltageOffset, (INT16)(~SaSetup.UncoreVoltageOffset + 1));
      } else {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaVoltageOffset, OcPreMemConfig->SaVoltageOffset, SaSetup.UncoreVoltageOffset);
      }

      //
      // GT Domain
      //
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtMaxOcRatio , OcPreMemConfig->GtMaxOcRatio,  SaSetup.GtMaxOcRatio);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageMode, OcPreMemConfig->GtVoltageMode, SaSetup.GtVoltageMode);

#if FixedPcdGet8(PcdFspModeSelection) == 1
      if (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageMode == OC_LIB_OFFSET_ADAPTIVE) {
#else
      if (OcPreMemConfig->GtVoltageMode == OC_LIB_OFFSET_ADAPTIVE) {
#endif
        GtVoltageOverride   = 0;
        GtExtraTurboVoltage = SaSetup.GtExtraTurboVoltage;
#if FixedPcdGet8(PcdFspModeSelection) == 1
      } else if (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageMode == OC_LIB_OFFSET_OVERRIDE) {
#else
      } else if (OcPreMemConfig->GtVoltageMode == OC_LIB_OFFSET_OVERRIDE) {
#endif
        GtVoltageOverride   = SaSetup.GtVoltageOverride;
        GtExtraTurboVoltage = 0;
      } else {
        GtVoltageOverride   = 0;
        GtExtraTurboVoltage = 0;
      }
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageOverride,   OcPreMemConfig->GtVoltageOverride,   GtVoltageOverride);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtExtraTurboVoltage, OcPreMemConfig->GtExtraTurboVoltage, GtExtraTurboVoltage);

      if (SaSetup.GtVoltageOffsetPrefix == 1) {
        //
        // Offset is negative, need to convert
        //
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageOffset, OcPreMemConfig->GtVoltageOffset, (INT16)(~SaSetup.GtVoltageOffset + 1));
      } else {
        UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageOffset, OcPreMemConfig->GtVoltageOffset, SaSetup.GtVoltageOffset);
      }
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RealtimeMemoryTiming, OcPreMemConfig->RealtimeMemoryTiming, SaSetup.RealtimeMemoryTiming);
    } else {
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.OcSupport,            OcPreMemConfig->OcSupport,            0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtMaxOcRatio,         OcPreMemConfig->GtMaxOcRatio,         0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageMode,        OcPreMemConfig->GtVoltageMode,        0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageOverride,    OcPreMemConfig->GtVoltageOverride,    0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtExtraTurboVoltage,  OcPreMemConfig->GtExtraTurboVoltage,  0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.GtVoltageOffset,      OcPreMemConfig->GtVoltageOffset,      0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SaVoltageOffset,      OcPreMemConfig->SaVoltageOffset,      0);
      UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.RealtimeMemoryTiming, OcPreMemConfig->RealtimeMemoryTiming, 0);
    }

#ifndef CPU_CFL
    ///
    /// TCSS DEVEN bits from setup to policy
    ///
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssItbtPcie0En,      TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssItbtPcie0En,   SaSetup.TcssItbtPcie0En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssItbtPcie1En,      TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssItbtPcie1En,   SaSetup.TcssItbtPcie1En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssItbtPcie2En,      TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssItbtPcie2En,   SaSetup.TcssItbtPcie2En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssItbtPcie3En,      TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssItbtPcie3En,   SaSetup.TcssItbtPcie3En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssXhciEn,           TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssXhciEn,        SaSetup.TcssXhciEn);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssXdciEn,           TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssXdciEn,        SaSetup.TcssXdciEn);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssDma0En,           TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssDma0En,        SaSetup.TcssDma0En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TcssDma1En,           TcssPeiPreMemConfig->DevEnConfig.TcssDevEnBit.TcssDma1En,        SaSetup.TcssDma1En);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.PcieMultipleSegmentEnabled, TcssPeiPreMemConfig->MiscConfig.PcieMultipleSegmentEnabled, SaSetup.PcieMultipleSegmentEnabled);

    ///
    ///

    //
    // 2LM
    //
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MemBootMode,          TwoLmPreMemConfig->MemBootMode,   SaSetup.MemBootMode);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Peg3Aspm,             TwoLmPreMemConfig->Peg3Aspm,      SaSetup.PegAspm[3]);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.BzmSupport,           TwoLmPreMemConfig->BzmSupport,    SaSetup.BzmSupport);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DpmemSupport,         TwoLmPreMemConfig->DpmemSupport,  SaSetup.DpmemSupport);
    UPDATE_POLICY (((FSPM_UPD *)FspmUpd)->FspmConfig.MfvcWrrArb,            TwoLmPreMemConfig->MfvcWrrArb,    SaSetup.MfvcWrrArb);
    for (Index = 0; Index < MFVC_VC_ARB_TABLE_INDEX; Index++) {
      UPDATE_POLICY (((FSPM_UPD *)FspmUpd)->FspmConfig.VcId_7_0[Index], TwoLmPreMemConfig->VcId_7_0[Index], SaSetup.VcId_7_0[Index]);
    }
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SetHwParameters,                TwoLmPreMemConfig->SetHwParameters,                SaSetup.SetHwParameters);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ltr_L1D2_ThVal,                 TwoLmPreMemConfig->Ltr_L1D2_ThVal,                 SaSetup.Ltr_L1D2_ThVal);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.Ltr_L1D2_ThScale,               TwoLmPreMemConfig->Ltr_L1D2_ThScale,               SaSetup.Ltr_L1D2_ThScale);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.SysPwrState,                    TwoLmPreMemConfig->SysPwrState,                    SaSetup.SysPwrState);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MediaDeathNotification,         TwoLmPreMemConfig->MediaDeathNotification,         SaSetup.MediaDeathNotification);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.HealthLogNotification,          TwoLmPreMemConfig->HealthLogNotification,          SaSetup.HealthLogNotification);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TempBelowThrottleNotification,  TwoLmPreMemConfig->TempBelowThrottleNotification,  SaSetup.TempBelowThrottleNotification);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.TempAboveThrottleNotification,  TwoLmPreMemConfig->TempAboveThrottleNotification,  SaSetup.TempAboveThrottleNotification);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.MissingCommitBitNotification,   TwoLmPreMemConfig->MissingCommitBitNotification,   SaSetup.MissingCommitBitNotification);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NVMeHoldDisableBit,             TwoLmPreMemConfig->NVMeHoldDisableBit,             SaSetup.NVMeHoldDisableBit);
#endif

    ///
    /// DPIN External Gfx Enable from setup to policy
    ///
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DpInExternalEn,         DpInPeiPreMemConfig->DpInExternalEn,         SaSetup.DpInExternalEn);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.NumberOfDpInPort,       DpInPeiPreMemConfig->NumberOfDpInPort,       DpInExtPortMapPcdDataPtr->NumberOfDpInPort);
    UPDATE_POLICY (((FSPM_UPD *) FspmUpd)->FspmConfig.DpInPortConnectMap,     DpInPeiPreMemConfig->DpInPortConnectMap,     DpInExtPortMapPcdDataPtr->DpInPortConnectMap);
#if FixedPcdGetBool(PcdFspWrapperEnable) == 1
    //
    // Because of the current design of FSP, the PCIEXBAR is an input argument from Wrapper to FSP for
    // supporting Dynamic PCD for PcdPciExpressBaseAddress and PcdPciExpressRegionLength in FSP, so we
    // need to update PCIEXBAR and PcdPciExpressRegionLength to 512MB when PcieMultipleSegmentEnabled is
    // enabled prior to FspmWrapperPeim, then FSP will sync FSP's PcdPciExpressRegionLength and
    // PcdPciExpressBaseAddress with PCIEXBAR in FSPM.
    //
    // If there is no iTBT PCIe RP enabled and PcieMultipleSegmentEnabled still enabled
    // The MMIO resource of Segment1 will be wasted.
    //
    if (SaSetup.PcieMultipleSegmentEnabled) {
      PciexBarReg = PciSegmentRead32 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_PCIEXBAR));
      PciexBarReg = ((PciexBarReg & ~(B_SA_PCIEXBAR_LENGTH_MASK)) | (V_SA_PCIEXBAR_LENGTH_512MB << N_SA_PCIEXBAR_LENGTH_OFFSET));
      PciSegmentWrite32 (PCI_SEGMENT_LIB_ADDRESS (SA_SEG_NUM, SA_MC_BUS, SA_MC_DEV, SA_MC_FUN, R_SA_PCIEXBAR), PciexBarReg);
      PcdSet32S (PcdPciExpressRegionLength, SIZE_512MB);
    }
#endif

    ///
    /// Build the GUID'd HOB for DXE
    ///
    BuildGuidDataHob (
      &gEfiMemoryTypeInformationGuid,
      MemoryData,
      DataSize
      );
  }

  return EFI_SUCCESS;
}
