/** @file
  Intel Platform Telememtry Data Table (PTDT) related definitions.

  Copyright (c) 2019, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution.  The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.

**/

#ifndef __PLATFORM_TELEMETRY_DATA_TABLE_H__
#define __PLATFORM_TELEMETRY_DATA_TABLE_H__


#pragma pack(1)

///
/// "PTDT" Platform Telemetry data Table
///
#define EFI_ACPI_PLATFORM_TELEMETRY_DATA_TABLE_SIGNATURE  SIGNATURE_32('P', 'T', 'D', 'T')

#define EFI_ACPI_PLATFORM_TELEMETRY_DATA_TABLE_VERSION  0x1

typedef struct {
  UINT16            RecordType;   // Platform Telemetry Record Type.
  UINT16            RecordLength; // The length of ther version data record.
  UINT8             Revision;     // Revision of this Firmware Version Data Record.  For spec 0.3d, the value is fixed to 1.
} EFI_ACPI_PLATFORM_TELEMETRY_RECORD_HEADER;


typedef struct {
  EFI_ACPI_PLATFORM_TELEMETRY_RECORD_HEADER Header;                   // Common header
  UINT8                                     Reserved[3];
  UINT64                                    VersionValue;             // 64-bit version value
  EFI_GUID                                  EsrtId;                   // If this version record is produced by
                                                                      // a component in the ESRT, this value will be
                                                                      // the same as the ESRT GUID. If not updatable,
                                                                      // then EsrtId would be 0.
  EFI_GUID                                  ComponentID;              // Component ID
  CHAR16                                    ComponentStr[1];           // NULL terminiated unicode string
} EFI_ACPI_TELEMETRY_VERSION_DATA_RECORD_STRUCTURE;


typedef struct {
  EFI_ACPI_PLATFORM_TELEMETRY_RECORD_HEADER Header;                   // Common header
  UINT16                                    Reserved;
  UINT8                                     AmHealthy;                // is the device healthy?
                                                                      // 0 = healthy, 1 = not healthy
                                                                      // 2 = unknown health (treated as healthy)
  EFI_GUID                                  DeviceSignature;          // The GUIDed record type that follows
  UINT32                                    DeviceSpecificDataOffset; // Offset to the Device-specific Data from the start of this Data Record.
} EFI_ACPI_TELEMETRY_HEALTH_DATA_RECORD_STRUCTURE;

typedef struct {
  EFI_TIME               LastUpdateTime;
  EFI_GUID               EsrtId;
} EFI_ACPI_LAST_UPDATE_DATA;

//
// SAS Gen2, chapter 2.5.4  Motherboard firmware health record
//
typedef struct {
  UINT8                                            Revision;                 // Motherboard Revision, 1 - Revision of this device-specific record
  UINT64                                           MeanBootTime;             // Average time in nanoseconds elapsed just prior to loading the OS boot loader.
  UINT64                                           CurrentBootTime;          // Time in nanoseconds elapsed just prior to loading the OS boot loader.
  UINT16                                           NumberOfBootsSinceUpdate; // Number of completed (reached READY_TO_BOOT) boots since the last successful firmware update.
} EFI_ACPI_MOTHERBOARD_HEALTH_DATA;

#pragma pack()

#endif
