/** @file
 * //TODO: modify this
  Telemetry API Lib for Firmware Information Version.

  Copyright (c) 2018, Intel Corporation. All rights reserved.<BR>
  This program and the accompanying materials
  are licensed and made available under the terms and conditions of the BSD License
  which accompanies this distribution. The full text of the license may be found at
  http://opensource.org/licenses/bsd-license.php

  THE PROGRAM IS DISTRIBUTED UNDER THE BSD LICENSE ON AN "AS IS" BASIS,
  WITHOUT WARRANTIES OR REPRESENTATIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED.
**/
#ifndef _TELEMETRY_LIB_H_
#define _TELEMETRY_LIB_H_

#include <Protocol/AdapterInformation.h>
#include <Telemetry/Include/Protocol/TelemetryAdapterInformation.h>

#pragma pack(1)
///
/// These structures is for saving the temprory AIP Telemetry Version data and string.
///
typedef struct {
  UINT64       Version;         // 64-bit version value
  EFI_GUID     ComponentID;     // Unique component ID
  CHAR16       *ComponentName;  // Component Name
} TELEMETRY_VERSION_RECORD_DATA;
#pragma pack()


/**
  Create the adapter information block for Version Info from arrays.

  @param[in] *Data       Pointer to an array of TELEMETRY_VERSION_RECORD_DATA.
  @param[in] Count       Telemetry record counts.
  @param[out] *Block     Pointer to an block of Adapter Information Data.
  @param[out] *BlockSize Pointer to Data block size.

  @retval EFI_SUCCESS          - if the data is successfully reported.
  @retval EFI_OUT_OF_RESOURCES - if not able to get resources.
**/
EFI_STATUS
EFIAPI
CreateTelemetryFviBlock (
  IN TELEMETRY_VERSION_RECORD_DATA    *Data,
  IN UINTN                            Count,
  OUT EFI_AIP_TELEMETRY_VERSION_DATA  **Block,
  OUT UINTN                           *BlockSize
  );

#endif
