
/** @file
  JslMsr.h

  @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _JSLMSR_h
#define _JSLMSR_h
#include <Base.h>
/**
  GLM matches SKL behavior of behaving exactly like MC0_STATUS     WRMSR uCode generates #GP on non-zero writes.     SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE     GLM i1958673 (Microserver MCA Enhancements): Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_P5_CR_MC_TYPE 0x00000001

/**
  OS or BIOS can program to the maximum line size in the system. CPUID will return the maximum line size of the processor and the system for the purposes of Monitor and MWait.  Software can use this information to pad data appropriately to avoid cross-cluster hot-spots.
**/
#define JSL_MSR_IA32_CR_MONITOR_FILTER_SIZE 0x00000006

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FilterMaximumLineSize : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               OS or BIOS can program to the maximum line size
                               in the system. CPUID will return the maximum
                               line size of the processor and the system for
                               the purposes of Monitor and MWait. Software can
                               use this information to pad data appropriately
                               to avoid cross-cluster hot-spots
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 PatchRevId : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               used by micro-code to maintain per-core patch
                               signature
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_MONITOR_FILTER_SIZE_REGISTER;
/**
  MSR ucode updates TSC_OFFSET SCP
**/
#define JSL_MSR_IA32_CR_TIME_STAMP_COUNTER 0x00000010

/**
  Indicates the platform the porcessor is intended for and is also used for selecting the correct patch to apply from among those available in BIOS. Accessible by BIOS as an MSR.
**/
#define JSL_MSR_P_CR_PLATFORM_ID 0x00000017

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 32;

                            /* Bits[31:0], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 18;

                            /* Bits[49:32], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 PlatformId : 3;

                            /* Bits[52:50], Access Type=RW, default=0x00000000*/

                            /*
                               This field is loaded from fuses. The field gives
                               information concerning the intended platform for
                               the processor.
                            */
    UINT32 Reserved53 : 11;

                            /* Bits[63:53], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_P_CR_PLATFORM_ID_REGISTER;

/**
  Register used to implement the APICBASE MSR. Contains the base address for all the APIC registers along with certain APIC control and state bits.
**/
#define JSL_MSR_X86_CR_APICBASE 0x0000001B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 8;

                            /* Bits[7:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Bsp : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               Bit used to indicate that the processor is the
                               bootstrap processor. RESET event microcode sets
                               this bit after performing the MP Init protocol,
                               for the processor that won bus arbitration.
                               Please see the MP Init Protocol for details.
                               This bit is also used by INIT event microcode to
                               figure out whether to jump to the reset vector
                               or wait for a SIPI.
                            */
    UINT32 Reserved9 : 1;

                            /* Bits[9:9], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 ExtendedModeEnable : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Apen : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000001*/

                            /*
                               APIC enable bit. If bit is 0, then the onchip
                               APIC is disabled. If the bit is 1, then APIC is
                               enabled.
                            */
    UINT32 ApicBase0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x000FEE00*/

                            /*
                               Bits 41:12 of the physical APIC register base
                               address. WRMSR ucode will GP fault on writes of
                               1 to 35:32 for PA32 parts
                            */
    UINT32 ApicBase1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Bits 41:12 of the physical APIC register base
                               address. WRMSR ucode will GP fault on writes of
                               1 to 35:32 for PA32 parts
                            */
    UINT32 Reserved42 : 22;

                            /* Bits[63:42], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_APICBASE_REGISTER;
/**
  TXT
**/
#define JSL_MSR_VIRT_CR_ACM_CPU_KEY_HASH_0 0x00000020
/**
  TXT
**/
#define JSL_MSR_VIRT_CR_ACM_CPU_KEY_HASH_1 0x00000021
/**
  TXT
**/
#define JSL_MSR_VIRT_CR_ACM_CPU_KEY_HASH_2 0x00000022
/**
  TXT
**/
#define JSL_MSR_VIRT_CR_ACM_CPU_KEY_HASH_3 0x00000023
/**
  MSR read by Sandra and HotCPU test. Added to prevent these benchmarks from crashing. See NHM-B b2425276
**/
#define JSL_MSR_UCODE_CR_POWERON 0x0000002A

/**
  Enhanced MCA Core error injection control
**/
#define JSL_MSR_VIRT_CR_THREAD_SMI_ERR_INJ_CONTROL 0x0000002B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* No thread scope machine check banks on TNT */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_THREAD_SMI_ERR_INJ_CONTROL_REGISTER;

/**
  Enhanced MCA Core error injection control
**/
#define JSL_MSR_VIRT_CR_CORE_SMI_ERR_INJ_CONTROL 0x0000002C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mc0 : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* SMI Requested by bus mca bank write 1 only */
    UINT32 Mc1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* SMI Requested by l2 mca bank write 1 only */
    UINT32 Mc2 : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* SMI Requested by fec mca bank write 1 only */
    UINT32 Mc3 : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* SMI Requested by mec mca bank write 1 only */
    UINT32 Rsvd4 : 4;

                            /* Bits[7:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_CORE_SMI_ERR_INJ_CONTROL_REGISTER;

/**
  Enhanced MCA Uncore error injection control
**/
#define JSL_MSR_VIRT_CR_UNCORE_SMI_ERR_INJ_CONTROL 0x0000002D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 4;

                            /* Bits[3:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Allbanks : 28;

                            /* Bits[31:4], Access Type=RW, default=0x00000000*/

                            /*
                               Core Interface HSD 1706537587: No reserved bit
                               checks based on number of uncore banks
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_UNCORE_SMI_ERR_INJ_CONTROL_REGISTER;

/**
  MSR used to enable/disable TPR messages. See NHM-B bug 2425138.
**/
#define JSL_MSR_UCODE_CR_PIC_MSG_CONTROL 0x0000002E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 10;

                            /* Bits[9:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TprMsgOff : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000001*/

                            /*
                               Prevents all TPR / IntPrioUpd messages from
                               being generated, incl. those generated from APIC
                               ID/LogID/DFR writes and Enable changes. This bit
                               maps to
                               ML3_CR_PIC_THREAD_CONFIG[ALL_TPR_MSG_OFF] on
                               Core and
                               BUS_CR_PIC_THREAD_CONFIG[ALL_TPR_MSG_OFF] on
                               TNT. (It used to map to
                               BUS_CR_PIC_THREAD_CONFIG[TPR_MSG_OFF] on GLM).
                               WRMSR ucode only allows clearing this bit. Any
                               attempt to set it (if already clear) will be
                               ignored. See NHM B0 b2425138 e612669, TNT
                               1706598817
                            */
    UINT32 Rsvd11 : 5;

                            /* Bits[15:11], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_PIC_MSG_CONTROL_REGISTER;

/**
  DCU_TEST_CTL MSR. Ucode mirrors the appropriate split lock disable bit and this entry is used only to generate the proper address defines
**/
#define JSL_MSR_UCODE_CR_MEMORY_CONTROL 0x00000033

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 29;

                            /* Bits[28:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SplitLockDisable : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, enable #AC exception on split lock
                               uops. If clear to 0, enables split locks if
                               SUPPRESS_LOCK_ENABLE is not set. Added on TNT to
                               match Core functionality. This is mapped by
                               ucode to bit 29 of UCODE_CR_MEMORY_CTL MSR
                               (0x033). See TNT 1404301546.
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SuppressLockEnable : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               NHM i386303: Add a defeature for split locks.
                               Mapped by ucode to MEC_CR_MODES_AND_DEFEATURES.S
                               UPPRESS_LOCK_ENABLE. SE i200557/ SKL i5312160 /
                               GLM b4942321: uCode will not allow
                               SUPPRESS_LOCK_ENABLE to be set through the
                               MEMORY_CONTROL MSR on a thread where SE has been
                               activated.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_MEMORY_CONTROL_REGISTER;

/**
  SLM PerfMon:Number of times SMI was entered.
**/
#define JSL_MSR_SCP_CR_SMI_COUNT 0x00000034

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SmmEntryCount : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000000*/

                            /* NUMBER OF TIMES SMM WAS ENTERED */
    UINT32 SmmSavedVmexitRefreshCount : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               This holds the VMEXIT_REFRESH_COUNT across an
                               SMM.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_SMI_COUNT_REGISTER;

/**
  determine the current count of enabled Cores and Threads. The Core Count and ThreadCount fields reflect the enabled cores and threads based on the factory-configured core
**/
#define JSL_MSR_UCODE_CR_CORE_THREAD_COUNT 0x00000035

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThreadCount : 16;

                            /* Bits[15:0], Access Type=RO, default=0x00000000*/

                            /*
                               The Thread Count reflects the enabled threads
                               based on the factory-configured
                            */
    UINT32 CoreCount : 16;

                            /* Bits[31:16], Access Type=RO, default=0x00000000*/

                            /*
                               The Core Count reflects the enabled cores based
                               on the above thread count and
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_CORE_THREAD_COUNT_REGISTER;

/**
  General SW visible Features MSR. This SCP is preserved across warm reset.
**/
#define JSL_MSR_IA32_CR_FEATURE_CONTROL_MSR 0x0000003A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               locks this MSR from being written. Once this bit
                               is set, WRMSR ucode will GP on writes
                            */
    UINT32 EnableVmxonInSmxOperation : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Enables VMXON when the secure environment is
                               active.
                            */
    UINT32 EnableVmxonOutsideSmxOperation : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Enables VMXON when no secure environment is
                               active. GLM has no vmx disable fuse, so this bit
                               is always writeable
                            */
    UINT32 Rsvd3 : 5;

                            /* Bits[7:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SenterParameterControl : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /*
                               Controls which corresponding parameter bits in
                               EDX[6:0] can be set with execution of SENTER.
                               The corresponding EDX bits are the opposite
                               polarity (disables) of the enables bits for this
                               field. WRMSR ucode only allows a write of all 1s
                               if SENTER_ENABLE is 1. WRMSR will GP if SMX is
                               fuse disabled.
                            */
    UINT32 SenterEnable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* Enables SENTER when set to 1. */
    UINT32 CStateSmi : 1;

                            /* Bits[16:16], Access Type=Rsvd0, default=None*/

                            /*
                               When set causes Monitor to be retained and
                               Monitor/MWAIT instrucitons to be converted to
                               PAUSE instructions during SMI execution. Used
                               for Cstate/SMI interaction under power
                               management. C-state SMI is not supported for
                               GLM, so WRMSR will GP.
                            */
    UINT32 LeWr : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               CNL 1206939047, GLP e1404572161: Used by BIOS to
                               opt-in to post boot updates of Launch enclave
                               provider
                            */
    UINT32 SeEnable : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               SKL i1349784:Enables SE when set to 1. For GLM,
                               WRMSR will GP if SE is fuse disabled.
                            */
    UINT32 Rsvd19 : 2;

                            /* Bits[20:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 FzmEnable : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               2LM - FZM. WRMSR will fault if FZM is fuse
                               disabled.
                            */
    UINT32 Rsvd22 : 10;

                            /* Bits[31:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RtitInit : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               RTIT INIT tracker bit- When set it means RTIT
                               MSRs are in reset state, When cleared it implies
                               that RTIT is not in reset state. ucode sets this
                               bit on cold reset, and is restored on warm
                               reset. MSR ucode clears this bit on WRMSR to any
                               RTIT MSR
                            */
    UINT32 Spare6333 : 31;

                            /* Bits[63:33], Access Type=RW, default=0x00000000*/

                            /*
                               These are extra scp bits preserved across warm
                               reset
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FEATURE_CONTROL_MSR_REGISTER;
/**
  Used to save TSC offset. SLT name:SCP_CR_TSC_OFFSET. Made an architectural MSR by Silvermont i1214561.
**/
#define JSL_MSR_IA32_CR_TSC_OFFSET 0x0000003B

/**
  TNT 1706705457
**/
#define JSL_MSR_IA32_CR_SPEC_CTRL 0x00000048

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ibrs : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Stp : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Ssbd : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Spare : 5;

                            /* Bits[7:3], Access Type=RW, default=0x00000000*/

                            /*  */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_SPEC_CTRL_REGISTER;

/**
  TNT 1706705457
**/
#define JSL_MSR_IA32_CR_PRED_CMD 0x00000049

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ibpb : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*  */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PRED_CMD_REGISTER;

/**
  GLP HSDES 1202197475: package-scoped MSR. Only bits 0/1 are actual storage. An entire byte is reserved for port_in/out granularity. Protected Processor Inventory Number Enable Control (R/W). The reset value is 0. It will not survive warm reset.
**/
#define JSL_MSR_FUNNYIO_CR_SCP_PPIN_CTL 0x0000004E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates if PPIN_CTL is locked. 0 - Not
                               locked (SW free to write to PPIN_CTL). 1 -
                               Locked (SW can no longer write to PPIN_CTL).
                            */
    UINT32 Enable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Indication to SW about presence of PPIN, 0 -
                               PPIN not present. Read of PPIN MSR would #GP. 1
                               - PPIN present. Read of PPIN MSR by SW allowed
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SCP_PPIN_CTL_REGISTER;
/**
  MSR for PPIN feature. Access to MSR_PPIN is permitted only if MSR_PPIN_CTL[1:0]=10b
**/
#define JSL_MSR_CORE_INTERFACE_CR_UNIQUE_ID 0x0000004F

/**
  Enhanced MCA Control - SLM D0 e3430879 / GLM i1958673: Microserver MCA Enhancements. Mapped by ucode into MSR 0x052. No ERROR_CLOAKING fuse for TNT
**/
#define JSL_MSR_FUNNYIO_CR_SCP_SMM_MCA_CONTROL 0x00000052

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CerrRdStatusInSmmOnly : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Only read valid correctable errors status when
                               in SMM. Otherwise read 0 if V=1 and UC=0
                            */
    UINT32 UcnaRdStatusInSmmOnly : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Added UCNA on TNT */
    UINT32 DualSignalSmi : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Enable SMI when MCA is set. This feature is part
                               of Enhanced MCA Gen 1 that enables the silicon
                               to issue SMI to the local cores along with
                               MCError. The silicon manages timing of SMI/MCE
                               so that the SMI handler is invoked early in
                               Int18 process.
                            */
    UINT32 Rsvd3 : 5;

                            /* Bits[7:3], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SCP_SMM_MCA_CONTROL_REGISTER;

/**
  determine the current count of enabled Cores and Threads. The Core Count and ThreadCount fields reflect the enabled cores and threads based on the factory-configured core
**/
#define JSL_MSR_VIRT_CR_THD_LOGICAL_ID 0x00000053

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogicalId : 6;

                            /* Bits[5:0], Access Type=RO, default=0x00000000*/

                            /*
                               TNT b1706673284: this field contains
                               WHOAM.AGENT_ID * 4 + WHOAMI.LPID. So for the
                               module 0 this will return 0, 1, 2 and 3 for the
                               C0, C1, C2 and C3 respectively and so on.
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_THD_LOGICAL_ID_REGISTER;

/**
  SMM Write only server MSR
**/
#define JSL_MSR_VIRT_CR_SMM_CLEAR_SMI 0x00000057

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ClearSmi : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When set, this clears the CSMI and MSMI pending
                               bits in the BUS. Write value of 0 is ignored.
                            */
    UINT32 MsmiToMceDisable : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When set, this disables MSMI_TO_MCE Morphing.
                               Note that this field name is more accurate than
                               the Core family name, which is "MSMI_TO_MCE_EN".
                               Write value of 0 is ignored.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SMM_CLEAR_SMI_REGISTER;

/**
  Server only SMM MSR
**/
#define JSL_MSR_VIRT_CR_SMM_CFG_OPTIONS_SRVR 0x00000058

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SmmWfsCtl : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Clear SMI pending on WFS */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SMM_CFG_OPTIONS_SRVR_REGISTER;

/**

**/
#define JSL_MSR_PCU_CR_THERM_EVENT_FFM 0x0000005E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnableFfm : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 FfmSmiSignaled : 1;

                            /* Bits[1:1], Access Type=RWOC, default=0x00000000*/

                            /*  */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PCU_CR_THERM_EVENT_FFM_REGISTER;

/**
  This MSR reads/writes CBO_CR_CBO_COH_CONFIG[0]. SKX b305692.
**/
#define JSL_MSR_VIRT_CR_MCA_ON_NONNEM_CACHABLEMMIO_EN 0x00000061

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McaNonnemCacheableMmioEnlock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This bit when set enables MCA on nonnem
                               cacheable MMIO.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_MCA_ON_NONNEM_CACHABLEMMIO_EN_REGISTER;
/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_TO_PDR 0x00000070
/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_GP_REG 0x00000071
/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_SEG_REG_1 0x00000072
/**
  fill description here
**/
#define JSL_MSR_IA32_CR_PROBE_PL_REG 0x00000073
/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_MMX2_REG 0x00000074
/**
  This is special creg for Probe Mode, used for issuing LT Special Cycles to the chipset in RED unlocked part
**/
#define JSL_MSR_UCODE_CR_PROBE_LT_SPC_CYC 0x00000076

/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_CHANGE_PG 0x00000077

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 31;

                            /* Bits[30:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pg : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* Paging:Enables paging. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PROBE_CHANGE_PG_REGISTER;
/**
  writing to this write-only MSR the address of the Patch causes a patch loading (no CR).
**/
#define JSL_MSR_UCODE_CR_PATCH_MATCH_REG 0x00000079

/**
  implementation simply ignores the wrmsr (XuCode would intercept it
**/
#define JSL_MSR_UCODE_CR_FEATURE_ACTIVATION_REG 0x0000007A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Se : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Secure Enclaves Feature Activation */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_FEATURE_ACTIVATION_REG_REGISTER;

/**
  relevant information located in the SECS and EPCM that is not accessible using EDBGRD
**/
#define JSL_MSR_XU_CR_SE_RDINFO_CMD 0x0000007D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Command : 12;

                            /* Bits[11:0], Access Type=Rsvd0, default=0x00000000*/

                            /* Command Code */
    UINT32 EpcPage0 : 20;

                            /* Bits[31:12], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Bits [63:12] of the platform physical address of
                               the EPC page
                            */
    UINT32 EpcPage1 : 32;

                            /* Bits[63:32], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Bits [63:12] of the platform physical address of
                               the EPC page
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_XU_CR_SE_RDINFO_CMD_REGISTER;
/**
  Emulated by XuCode
**/
#define JSL_MSR_XU_CR_EINIT_FAIL_CNTR 0x0000007E

/**
  GLP e1404625920: Holds state for MSR 0x80 which is the core specific AET NPK MMIO address. This MSR could have been package scope since BIOS only writes 1 value and locks it acorss cores. But wasting thread scope storage for compatibility with Core.
**/
#define JSL_MSR_C6_SCP_CR_NPK_STH_ACPIBAR_BASE 0x00000080

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Lock bit - if set then this MSR cannot be re-
                               written anymore. Lock bit has to be set in order
                               for the AET packets to be directed to NPK MMIO
                            */
    UINT32 Rsvd1 : 17;

                            /* Bits[17:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BarAddress0 : 14;

                            /* Bits[31:18], Access Type=RW, default=0x00000000*/

                            /* AET target address in NPK MMIO space */
    UINT32 BarAddress1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* AET target address in NPK MMIO space */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_C6_SCP_CR_NPK_STH_ACPIBAR_BASE_REGISTER;

/**
  FZM Range Index register to R/W Domain Index
**/
#define JSL_MSR_IA32_CR_FZM_RANGE_INDEX 0x00000082

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DomainIndex : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the Index of domain or special encoding
                               CONFIG = 64
                            */
    UINT32 DomainHandle0 : 24;

                            /* Bits[31:8], Access Type=RW, default=0x00000000*/

                            /* Holds the Domain Handle */
    UINT32 DomainHandle1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Holds the Domain Handle */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FZM_RANGE_INDEX_REGISTER;

/**
  FZM Domain ConfigValue Read Only
**/
#define JSL_MSR_VIRT_CR_FZM_DOMAIN_CONFIG 0x00000083

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DomainIndex : 8;

                            /* Bits[7:0], Access Type=RO, default=0x00000000*/

                            /*
                               Holds the Index of domain or special encoding
                               CONFIG = 64
                            */
    UINT32 DomainHandle0 : 24;

                            /* Bits[31:8], Access Type=RO, default=0x00000000*/

                            /* Holds the Domain Handle */
    UINT32 DomainHandle1 : 32;

                            /* Bits[63:32], Access Type=RO, default=0x00000000*/

                            /* Holds the Domain Handle */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_FZM_DOMAIN_CONFIG_REGISTER;
/**
  FZM Domain Start Address - Read Only
**/
#define JSL_MSR_VIRT_CR_FZM_RANGE_STARTADDR 0x00000084
/**
  FZM Domain End Address - Read Only
**/
#define JSL_MSR_VIRT_CR_FZM_RANGE_ENDADDR 0x00000085

/**
  FZM Domain Write Status - Read Only
**/
#define JSL_MSR_VIRT_CR_FZM_RANGE_WRITESTATUS 0x00000086

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WriteStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               Read the write status of the specified domain in
                               Index MSR
                            */
    UINT32 ReadStatus : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               Read the read status of the specified domain in
                               Index MSR
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_FZM_RANGE_WRITESTATUS_REGISTER;

/**
  Patch Sign ID MSR. Mapped to h32 of a SCP
**/
#define JSL_MSR_UCODE_CR_PATCH_SIGN_ID 0x0000008B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 32;

                            /* Bits[31:0], Access Type=Rsvd0, default=None*/

                            /* Not used */
    UINT32 PatchSignId : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* patch signature ID. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_PATCH_SIGN_ID_REGISTER;
/**
  New Xucode MSR for CNL 1206939047, GLP e1404572161
**/
#define JSL_MSR_UCODE_CR_SGXSETLEKEY0 0x0000008C
/**
  New Xucode MSR for CNL 1206939047, GLP e1404572161
**/
#define JSL_MSR_UCODE_CR_SGXSETLEKEY1 0x0000008D
/**
  New Xucode MSR for CNL 1206939047, GLP e1404572161
**/
#define JSL_MSR_UCODE_CR_SGXSETLEKEY2 0x0000008E
/**
  New Xucode MSR for CNL 1206939047, GLP e1404572161
**/
#define JSL_MSR_UCODE_CR_SGXSETLEKEY3 0x0000008F
/**
  reserved for xucode --> cause pppe exit
**/
#define JSL_MSR_UCODE_CR_SGX_RESERVED0 0x00000090
/**
  reserved for xucode --> cause pppe exit
**/
#define JSL_MSR_UCODE_CR_SGX_RESERVED1 0x00000091

/**
  This MSR is writeable only in SMM mode, else uCode generates #GP.
**/
#define JSL_MSR_SCP_CR_LT_MSEG_BASE_ADDRESS 0x0000009B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Valid : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Set if the MSEG is valid. */
    UINT32 CstateSmiOptin : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved for SLM. C-state SMI VMX opt in. Can
                               only be set by WRMSR if
                               IA32_CR_FEATURE_CONTROL_MSR.C_STATE_SMI and LOCK
                            */
    UINT32 Vmxoffctrl : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Controls SMI unmasking during VMXOFF. See HSW
                               i1195158. Reserved for GLM. Because GLM does not
                               support TXT, on a non-TXT part, the CPU can be
                               in VMX operation, outside SMM, with SMIs blocked
                               only if the STM has not yet torn itself down.
                               VMXOFF can be executed successfully only in VMX
                               operation, outside SMM, and if there is no
                               active STM.Thus, on a non-TXT part, if VMXOFF
                               can be executed successfully SMIs are not
                               blocked. If SMIs are not blocked when VMXOFF is
                               executed, whether VMXOFF is configured to
                               unblock SMIs or not is irrelevant.
                            */
    UINT32 RsvdL3 : 9;

                            /* Bits[11:3], Access Type=RW, default=0x00000000*/

                            /* Reserved to 0 */
    UINT32 MsegBasePageFrameAdr : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* MSEG base page fram address */
    UINT32 VmexitRefreshCount : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               These bits hold a count of how many VMEXIT
                               transitions until we need to refresh both of the
                               Host keys.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_LT_MSEG_BASE_ADDRESS_REGISTER;

/**
  SMM Protected Mode Base MSR: the C6 MSR leaf depends on this address being the first C6 address with MSR access
**/
#define JSL_MSR_C6_SCP_CR_SMM_PROT_MODE_BASE 0x0000009D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Enable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Protected mode SMM entry enabled */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SmmsegPa : 24;

                            /* Bits[31:8], Access Type=RW, default=0x00000000*/

                            /*
                               Physical address of SMMSEG. Note big core
                               register definitions have a range of 31:12 but
                               enforce 31:8 directly in ucode. Atom changes the
                               mask directly in XML to avoid special ucode
                               handling.
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_C6_SCP_CR_SMM_PROT_MODE_BASE_REGISTER;

/**
  SLM e3430273:Read only MSR. WRMSR will always #GP. RDMSR will GP if not in SMM mode else read the SCP_CR_SMBASE
**/
#define JSL_MSR_VIRT_CR_SMBASE 0x0000009E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Register which contains the current SMM base
                               value for the processor. The RESET event handler
                               should set it to 0x00030000, which is the
                               default value. When RSM executes, it reads the
                               SMM base slot value in SMM memory and loads it
                               into this register
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SMBASE_REGISTER;

/**
  MCHECK Error Code
**/
#define JSL_MSR_FUNNYIO_CR_SCP_MCHECK_ERR_CODE 0x000000A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* Survives warm reset. Set to 0 on cold reset. */
    UINT32 Rsvd16 : 15;

                            /* Bits[30:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PatchloadPartialSuccessIndication : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               SNC 1304186372 / TNT 1706554670: Added thread
                               scope indication to match SNC
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SCP_MCHECK_ERR_CODE_REGISTER;
/**
  Package registration ID 0
**/
#define JSL_MSR_CORE_INTERFACE_CR_SGX_PRID0 0x000000A1
/**
  Package registration ID 1
**/
#define JSL_MSR_CORE_INTERFACE_CR_SGX_PRID1 0x000000A2

/**

**/
#define JSL_MSR_VIRT_CR_SGX_RAS 0x000000A3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Optin : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               BIOS opt-in to SGX and opt-out of advanced RAS
                               features
                            */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SGX_RAS_REGISTER;

/**
  FIT BIOS and ACM error type and code
**/
#define JSL_MSR_UCODE_CR_FIT_BIOS_ERROR 0x000000A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorCode : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* error code optype */
    UINT32 EntryType : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* entry type optype */
    UINT32 FitPatchEntry : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* indication whether patch entry exists in FIT */
    UINT32 BiosUse0 : 15;

                            /* Bits[31:17], Access Type=RW, default=0x00000000*/

                            /*
                               Per Sai / Hisham (8/22/2017): BIOS secretly uses
                               this MSR to log errors during POST indication
                               whether patch entry exists in FIT. So don't do
                               reserved bit checks
                            */
    UINT32 BiosUse1 : 31;

                            /* Bits[62:32], Access Type=RW, default=0x00000000*/

                            /*
                               Per Sai / Hisham (8/22/2017): BIOS secretly uses
                               this MSR to log errors during POST indication
                               whether patch entry exists in FIT. So don't do
                               reserved bit checks
                            */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* Lock bit - set when FIT error is written to FSCP */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_FIT_BIOS_ERROR_REGISTER;

/**
  There was a decision to fuse off PL (aka MPX) in CNL and ICL, but not to remove it.  There is a new request from ISAs to add an option for BIOS to enable PL even if it's fused off
**/
#define JSL_MSR_UCODE_CR_MPX_FUSE_OVERRIDE 0x000000A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MpxEnabled : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* BIOS will set this to 1 to enable Point Lookout */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_MPX_FUSE_OVERRIDE_REGISTER;
/**
  vMSRs for power mgmt
**/
#define JSL_MSR_VIRT_CR_VMSR_U2P_0_SRVR 0x000000B0
/**
  vMSRs for power mgmt
**/
#define JSL_MSR_VIRT_CR_VMSR_U2P_1_SRVR 0x000000B1
/**
  vMSRs for power mgmt
**/
#define JSL_MSR_VIRT_CR_VMSR_U2P_2_SRVR 0x000000B2
/**
  vMSRs for power mgmt
**/
#define JSL_MSR_VIRT_CR_VMSR_U2P_3_SRVR 0x000000B3

/**
  General purpose counter 0. This was changed to a global creg on GLM for the sake of PEBS PDIR. BUS1 needs to also support reads of the local address (BUS1_CR_PMC0) for the sake of the RDPMC macro instruction.
**/
#define JSL_MSR_IA32_CR_PMC0 0x000000C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter0Lo : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               Lower 6 bits of 48-bit general counter 0. Only
                               lower 6 bits are duplicated in ARR1 for PEBS
                               PDIR.
                            */
    UINT32 GpCounter0Hi0 : 26;

                            /* Bits[31:6], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 0. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 GpCounter0Hi1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 0. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. SLT b1409493: no longer do WRMSR rsvd
                               check for bits 63:48 of PERFCTR0/1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PMC0_REGISTER;

/**
  General purpose counter 1
**/
#define JSL_MSR_IA32_CR_PMC1 0x000000C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter1Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 1. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 GpCounter1Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 1. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. SLT b1409493: no longer do WRMSR rsvd
                               check for bits 63:48 of PERFCTR0/1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PMC1_REGISTER;

/**
  General purpose counter 2
**/
#define JSL_MSR_IA32_CR_PMC2 0x000000C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter2Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 2. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 GpCounter2Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 2. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. SLT b1409493: no longer do WRMSR rsvd
                               check for bits 63:48 of PERFCTR0/1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PMC2_REGISTER;

/**
  General purpose counter 3
**/
#define JSL_MSR_IA32_CR_PMC3 0x000000C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter3Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 1. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 GpCounter3Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit general counter 1. BNL i310740: WRMSR
                               ucode sign-extends from 31 to 47:32
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. SLT b1409493: no longer do WRMSR rsvd
                               check for bits 63:48 of PERFCTR0/1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PMC3_REGISTER;

/**
  [p]PUNIT_MSR: This contains information about platforms frequency capabilities that the CPU reports.[/p]
  [p][b]MSR_Name[/b]: PLATFORM_INFO  [b]MSR_Addr[/b]: 0x0CE[/p]
**/
#define JSL_MSR_P_CR_PLATFORM_INFO 0x000000CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MaxNonTurboLimRatio : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               The Maximum Non-Turbo clock ratio multiplier
                               describes the highest clock frequency in 100MHz
                               units that IA cores are manufactured to run at
                               without hitting thermal or power constraints.
                               This clock frequency also defines the level that
                               the core timestamp counter runs at
                            */
    UINT32 SmmSaveCap : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000001*/

                            /* Save/Restore x87 state in SMM Reserved */
    UINT32 Rsvd17 : 6;

                            /* Bits[22:17], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PpinCap : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               When set to 1, indicates that Protected
                               Processor Inventory Number (PPIN) capability can
                               be enabled for privileged system inventory agent
                               to read PPIN from MSR_PPIN. When set to 0, PPIN
                               capability is not supported. An attempt to
                               access MSR_PPIN_CTL or MSR_PPIN will cause #GP.
                            */
    UINT32 OcvoltOvrdEn : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               If set, indicates the part supports voltage
                               overrides as part of general overclocking and
                               voltage control features
                            */
    UINT32 FivrRfiTuningAvail : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* FIVR_RFI_TUNING_AVAIL */
    UINT32 Dcu16kModeAvail : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* If set, indicates the part supports 16K DCU mode */
    UINT32 SamplePart : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates that this part is a non-production /
                               sample part
                            */
    UINT32 PrgTurboRatioEn : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000001*/

                            /*
                               If set, the FREQ_LIMIT_RATIOS register is
                               programmable by software. If clear, this
                               register is not writable
                            */
    UINT32 PrgTdpLimitEn : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000001*/

                            /*
                               If set, PL1 power limits are programmable. If
                               clear, the PL1 power limit may not be programmed
                               by software
                            */
    UINT32 PrgTjOffsetEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000001*/

                            /*
                               If set, enables programmable Tj offset in the
                               TEMPERATURE_TARGET.TJ_MAX_TCC_OFFSET field.
                            */
    UINT32 CpuidFaultingEn : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000001*/

                            /* CPUID Faulting */
    UINT32 LpmSupport : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether or not P-states below the
                               maximally efficient P-state are allowed. All
                               products support LPM.
                            */
    UINT32 ConfigTdpLevels : 2;

                            /* Bits[34:33], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates the number of configurable TDP levels
                               are supported. If set to zero, configurable TDP
                               is not supported as a feature
                            */
    UINT32 PfatEnable : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               If set, this field indicates that PFAT is
                               enabled
                            */
    UINT32 Peg2dmidisEn : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 TimedMwaitEnable : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /*
                               If set, this field indicates that the core Timed
                               WAIT feature is supported.
                            */
    UINT32 AsaEn : 1;

                            /* Bits[38:38], Access Type=RW, default=0x00000001*/

                            /*
                               ASA Enable. 0 = ASA is disabled 1 = ASA is
                               enabled
                            */
    UINT32 Rsvd39 : 1;

                            /* Bits[39:39], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MaxEfficiencyRatio : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               Maximum Efficienty Ratio. This is given in units
                               of 100 MHz.
                            */
    UINT32 MinOperatingRatio : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000001*/

                            /*
                               Mimumum supported clock multiplier for IA cores,
                               described in units of 100MHz. This is the lower
                               bound on what software may program into its
                               P-state request for IA cores
                            */
    UINT32 PushpatchEn : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 EdramEnable : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates to BIOS that memory-side ACPI tables
                               can be used
                            */
    UINT32 Sxp2lmEnable : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates to BIOS that the FME_ACTIVATE MSR can
                               be setup Indicates to BIOS that the FZM
                               functionality can be enabled
                            */
    UINT32 SmmSupovrStateLockEnable : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000001*/

                            /*
                               Indicates to BIOS that the SMM_SUPOVR_STATE_LOCK
                               MSR can be setup. This bit is unconditionally
                               set for SoCs that support SNC
                            */
    UINT32 TioEnable : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /* TIO_ENABLE */
    UINT32 Rsvd61 : 2;

                            /* Bits[62:61], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ConfigTdpExt : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000001*/

                            /*
                               Indication that the platform supports extended
                               tdp levels.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_P_CR_PLATFORM_INFO_REGISTER;

/**
  TNT 1706698097: Core Capabilities Register. This MSR is read only; uCode generates #GP on any write.
**/
#define JSL_MSR_IA32_CR_CORE_CAPABILITIES 0x000000CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 StlbQos : 1;

                            /* Bits[0:0], Access Type=Rsvd0, default=None*/

                            /*
                               when set to 1, processor support STLB QOS (0 for
                               TNT)
                            */
    UINT32 Rar : 1;

                            /* Bits[1:1], Access Type=Rsvd0, default=None*/

                            /*
                               when set to 1, processor supports remote action
                               request (0 for TNT)
                            */
    UINT32 Fusa : 1;

                            /* Bits[2:2], Access Type=Rsvd0, default=None*/

                            /* FuSa supported (0 for TNT) */
    UINT32 RsmOnCpl0OnlySupported : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /*
                               TNT 1409043838 / DMT 1706776190: Devil's Gate
                               Rock (RSM on CPL3 enforcement)
                            */
    UINT32 Rsvd4 : 1;

                            /* Bits[4:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SplitLockDisSupported : 1;

                            /* Bits[5:5], Access Type=RO, default=0x00000001*/

                            /*
                               TNT 1706839313 / 1404301546: Split lock disable
                               supported
                            */
    UINT32 SnpFilterQosSupported : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               TNT 1706839313: For TNT this is 1 only for a
                               server part with LLC_QOS and L2_QOS enabled
                            */
    UINT32 Rsvd7 : 1;

                            /* Bits[7:7], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_CORE_CAPABILITIES_REGISTER;

/**
  OS control for UMWAIT latency
**/
#define JSL_MSR_IA32_CR_UMWAIT_CONTROL 0x000000E1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ForceC01SleepState : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* See the name */
    UINT32 Reserved1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 OsDeadline : 30;

                            /* Bits[31:2], Access Type=RW, default=0x00000000*/

                            /*
                               A non-zero value means that a valid deadline
                               limit has been specified.
                            */
    UINT32 ReservedForEhalt32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               This field is reserved for a copy of EHALT
                               CLPU_CR_CORE_CLOCK_MODULATION.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_UMWAIT_CONTROL_REGISTER;

/**
  Power Management - C-states configuration. Note the presence of the LOCK bit (15):When set, locks bits 15-0 of this register for further writes, until the next reset occurs.
**/
#define JSL_MSR_SCP_CR_CST_CONFIG_CONTROL 0x000000E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PackLim : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               Limits the resolved package Cstate to be less
                               than or equal to the encoded state. 0000 - no
                               Limit; 0001 - C1; 0010 - C3; 0011 - C6; 0100 -
                               C7; 0101 - C7S; 0110 - C8; 0111 - C9; 1000 -
                               C10; others - reserved; This field will also
                               indirectly impact the possible module Cstate. A
                               limit of C1 means that the module cannot leave
                               C0, as C1 is a core-only Cstate. C3 and C6, will
                               restrict the possible module Cstate to that
                               respective value. If the state is unlimited or
                               C7 and deeper, then the module can enter C7. The
                               states C8, C9, and C10 and synonyms for S0i1,
                               S0i2, and S0i3, respectively.
                            */
    UINT32 MaxCoreCState : 4;

                            /* Bits[7:4], Access Type=RW, default=0x00000000*/

                            /*
                               BXT HSDES 101397712 (new for GLM/BXT): The
                               possible values are: 0000 - reserved; 0001 - C1;
                               0010 - C3, 0011 - C6.
                            */
    UINT32 Rsvd8 : 2;

                            /* Bits[9:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IoMwaitRedirection : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               When set, will map IO_read instructions sent to
                               IO registers PMG_IO_BASE_ADDR.PMB0+0/1/2 to
                               MWAIT(C2,3,4) instructions; Applies to deepc4
                               too.
                            */
    UINT32 Rsvd11 : 4;

                            /* Bits[14:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CstCfgLock : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               When set, locks bits 15-0 of this register for
                               further writes, until the next reset occurs.
                            */
    UINT32 Rsvd16 : 9;

                            /* Bits[24:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 C3StateAutoDemotionEnable : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               When set, ucode will conditionally demote C6/C7
                               requests to C3 based on PCU's auto-demote
                               information
                            */
    UINT32 C1StateAutoDemotionEnable : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /*
                               When set, ucode will conditionally demote
                               C3/C6/C7 requests to C1 based on PCU's auto-
                               demote information
                            */
    UINT32 Enc3undemotion : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* Enable Un-Demotion from Demoted C3 */
    UINT32 Enc1undemotion : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* Enable Un-Demotion from Demoted C1 */
    UINT32 Enpkgcautodemotion : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               Enable Package Cstate autodemotion. It enables
                               use of history of past pkg cstate depth and
                               residence, as a factor in determining cstate
                               depth
                            */
    UINT32 Enpkgcundemotion : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               Enable Package Cstate undemotion. Its the enable
                               to consider cases where demotion was the
                               incorrect desicion in determining cstate depth.
                            */
    UINT32 TimedMwaitEnable : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               When set, enables Timed MWAIT feature. MWAIT
                               would #GP on attempts to do setup MWAIT timer if
                               this bit is not set (HSW B-step e4244601)
                            */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_CST_CONFIG_CONTROL_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_SCP_CR_PMG_IO_CAPTURE_BASE 0x000000E4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lvl2b : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               micro-code will compare IO-read zone to this
                               base address to determine if an MWAIT(C2/3/4)
                               needs to be issued instead of the IO-read.
                               Should be programmed to the chipset Plevel_2 IO
                               address
                            */
    UINT32 CstRange : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /*
                               The IO-port block size in which IO-redirection
                               will be executed (0-127). Should be programmed
                               based on the number of LVLx registers existing
                               in the chipset. Reduced to 3 bits on GLM to
                               match Core.
                            */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Spare : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 FdpData : 16;

                            /* Bits[63:48], Access Type=RW, default=0x00000000*/

                            /*
                               Used to save FDP in bits [63:48] for non-
                               canonical address in FXSAVE/FXRSTOR ; 16 bits
                               are stored in [63:48] in this SCP same as the
                               original bit slices.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PMG_IO_CAPTURE_BASE_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_PMG_CR_PST_MCNT 0x000000E7
/**
  fill description here
**/
#define JSL_MSR_PMG_CR_PST_ACNT 0x000000E8

/**
  Read-only register containing MTRR feature identification for the processor. Should be used in conjunction with the CPUID[EDX] bit 12 to determine MTRR capabilities. This MSR is read only; uCode generates #GP on any write.
**/
#define JSL_MSR_UCODE_CR_MTRRCAP 0x000000FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vcnt : 8;

                            /* Bits[7:0], Access Type=RO, default=0x0000000A*/

                            /* Number of variable range registers - 10 for GLM. */
    UINT32 Fix : 1;

                            /* Bits[8:8], Access Type=Rsvd1, default=0x00000001*/

                            /* Fixed range registers supported if set. */
    UINT32 Reserved9 : 1;

                            /* Bits[9:9], Access Type=Rsvd0, default=0x00000000*/

                            /* (RC) */
    UINT32 Write : 1;

                            /* Bits[10:10], Access Type=Rsvd1, default=0x00000001*/

                            /* Write-Combining memory type supported if set. */
    UINT32 Smrr : 1;

                            /* Bits[11:11], Access Type=Rsvd1, default=0x00000001*/

                            /* SMRR:No SMRR fuse for SLM, so this is always 1. */
    UINT32 Prmrr : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /*
                               PRMRRs are supported:On GLM, reports 1 if PRMRR
                               is fuse enabled
                            */
    UINT32 Smrr2 : 1;

                            /* Bits[13:13], Access Type=RO, default=0x00000000*/

                            /* SMRR2 is supported on TNT. */
    UINT32 SmrrLock : 1;

                            /* Bits[14:14], Access Type=Rsvd1, default=0x00000001*/

                            /*
                               GLP 1706546645: Black Point: SMRR lock bit is
                               supported on GLP
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_MTRRCAP_REGISTER;

/**
  which contain the privilege level of the currently executing process    (CPL). Micro-code must update this register any time the privilege
**/
#define JSL_MSR_BNL_CR_CPL 0x00000101

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Cpl : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /* CPL of the current execution */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved to 0 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_CPL_REGISTER;

/**
  Software override for each C-state in Power Aware Interrupt Routing feature.
**/
#define JSL_MSR_VIRTUAL_MSR_CR_PAIR_WEIGHT_OVERRIDE 0x00000102

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Cc1Weight : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Weight override for Core C1 state */
    UINT32 C0xWeight : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /*
                               Weight override for any core with one thread in
                               C0 and the other in any deeper C-state
                            */
    UINT32 C00Weight : 3;

                            /* Bits[8:6], Access Type=RW, default=0x00000000*/

                            /*
                               Weight override for any core with both threads
                               in C0
                            */
    UINT32 Cc3Weight : 3;

                            /* Bits[11:9], Access Type=RW, default=0x00000000*/

                            /* Weight override value for Core C3 state */
    UINT32 Cc6Weight : 3;

                            /* Bits[14:12], Access Type=RW, default=0x00000000*/

                            /* Weight override value for Core C6 state */
    UINT32 Rsvd15 : 16;

                            /* Bits[30:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 OverrideEnable : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               When software writes 1 to this field, the CPU
                               reads the other fields in this register and
                               updates the PAIR weights internally
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRTUAL_MSR_CR_PAIR_WEIGHT_OVERRIDE_REGISTER;

/**
  Pair package level thread participation. Per BXT i1012209455, PAIR MSRs will exist without storage or functionality on BXT/DNV. WRMSRs will be silently dropped, RDMSRs return 0s. This matches SKL behavior if PAIR is fuse disabled.
**/
#define JSL_MSR_VIRTUAL_MSR_CR_PAIR_PKG_THREAD_PARTICIPATION 0x00000103

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 C0t0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C0t1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C1t0 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C1t1 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C2t0 : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C2t1 : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C3t0 : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 C3t1 : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRTUAL_MSR_CR_PAIR_PKG_THREAD_PARTICIPATION_REGISTER;

/**
  Register to specify a thread's inclusion or exclusion in Power Aware Interrupt Routing algorithm at a package level. Per BXT i1012209455, PAIR MSRs will exist without storage or functionality on BXT/DNV. WRMSRs will be silently dropped, RDMSRs return 0s. This matches SKL behavior if PAIR is fuse disabled.
**/
#define JSL_MSR_VIRTUAL_MSR_CR_PAIR_THREAD_PARTICIPATION 0x00000104

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PairExcl : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               0 - thread is included in PAIR redirection. 1 -
                               thread is excluded from PAIR redirection.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRTUAL_MSR_CR_PAIR_THREAD_PARTICIPATION_REGISTER;

/**
  TNT 1706705457
**/
#define JSL_MSR_IA32_CR_ARCH_CAPABILITIES 0x0000010A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NoRdcl : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               When this is set, it indicates No rogue data
                               cache line concerns.
                            */
    UINT32 IbrsAllTheTime : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               When this is set, it indicates that the IBRS All
                               the time is the suggested protection model.
                            */
    UINT32 Rsba : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               RSB Alternate. Alternative branch predictors may
                               be used by RET instructions when the RSB is
                               empty. RSB stuffing or retpoline sequence for
                               RETs may be needed. Useful for VM migration
                               pools and guests using retpoline.
                            */
    UINT32 NoL1dfovr : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /* No need to flush DL1 on something something ... */
    UINT32 NoSsbdNeeded : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /*
                               The memory disambiguation disable is not
                               required on this part.
                            */
    UINT32 NoMbs : 1;

                            /* Bits[5:5], Access Type=RO, default=0x00000000*/

                            /*
                               This bit should get set to indicate that MBS
                               does not apply to Atom.
                            */
    UINT32 IfuPschangeVulnNo : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               This indicates that this vulnerability does not
                               apply to Atom.
                            */
    UINT32 Rsvd7 : 1;

                            /* Bits[7:7], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_ARCH_CAPABILITIES_REGISTER;

/**
  Duplicate MSR with DL1 flush functionality to match Core
**/
#define JSL_MSR_UCODE_CR_WBINVAL_DL1 0x0000010B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 WbinvalDl1 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               TNT 1406955792: Add a bit for BIOS to flush
                               DL1->L2.
                            */
    UINT32 Rsvd1 : 15;

                            /* Bits[15:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_WBINVAL_DL1_REGISTER;

/**
  send to Sleep MSR
**/
#define JSL_MSR_VIRT_CR_PFAT_GT_SLEEP_CMDSTS 0x00000118

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MailboxInternalPcodeKeepGtRc6 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               MAILBOX_INTERNAL_PCODE_KEEP_GT_RC6_DISABLE (0x0)
                               or MAILBOX_INTERNAL_PCODE_KEEP_GT_RC6_ENABLE
                               (0x1)
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_PFAT_GT_SLEEP_CMDSTS_REGISTER;

/**
  Misc power controls. TNT: Only bit left is WBINVAL_DL1. So write only MSR. Originally added for S0i2 on STW. used for eHALT enables on SLM i1214710.
**/
#define JSL_MSR_UCODE_CR_POWER_MISC 0x00000120

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 WbinvalDl1 : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               GLM e3655575: Add a bit for BIOS to flush
                               DL1->L2.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_POWER_MISC_REGISTER;

/**
  GLM i1958937: Emulate PM_TMR in ucode for BXT
**/
#define JSL_MSR_SCP_CR_EMULATE_PM_TMR 0x00000121

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PmTmrBlkBase : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* base IO port address of the PM_TMR */
    UINT32 PmTmrBlkValid : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates that the MSR has actaully been
                               programmed by BIOS, and thus enables ucode
                               emulation of the PM_TMR
                            */
    UINT32 Rsvd17 : 3;

                            /* Bits[19:17], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RspDelayLoopCount : 12;

                            /* Bits[31:20], Access Type=RW, default=0x00000000*/

                            /*
                               Number of PAUSE-like delay loops that should be
                               completed before returning the response. This
                               will allow for better timing emulation of ACPI
                               timer response, which was causing issues in BIOS
                            */
    UINT32 Multiplier : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Constant programmed by BIOS to translate CTC to
                               target freqency (14.31818/4). For BXT crystal
                               freq of 19.2 this constant is expected to be
                               0x2fba2e25
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_EMULATE_PM_TMR_REGISTER;

/**
  TNT 1409030799: BIOS MSR to program maximum number of LQ entries guaranteed per core. On writes, exactly one bit must be set, and the bit index indicates the number of entries. If more than 1 bit is set, or no bits are set, the MSR is ignored
**/
#define JSL_MSR_VIRT_CR_L2Q_WATERMARK 0x00000124

// typedef union {
//   ///
//   /// Individual bit fields
//   ///
//   struct {
//     UINT32 Rsvd0 : 1;

//                             /* Bits[0:0], Access Type=RO, default=None*/

//                             /* Reserved */
//     UINT32 9Entries : 1;

//                             /* Bits[1:1], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 9 LQ entries out of 12 */
//     UINT32 6Entries : 1;

//                             /* Bits[2:2], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 6 LQ entries out of 12 */
//     UINT32 3Entries : 1;

//                             /* Bits[3:3], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 3 LQ entries out of 12 */
//     UINT32 Rsvd4 : 4;

//                             /* Bits[7:4], Access Type=RO, default=None*/

//                             /* Reserved */

//   } Bits;

//   UINT32 Uint32;
//   UINT64 Uint64;

// } JSL_MSR_VIRT_CR_L2Q_WATERMARK_REGISTER;

/**
  TNT 1409030799: BIOS MSR to program maximum number of XQ entries guaranteed per core. On writes, exactly one bit must be set, and the bit index indicates the number of entries. If more than 1 bit is set, or no bits are set, the MSR is ignored.
**/
#define JSL_MSR_VIRT_CR_XQ_WATERMARK 0x00000125

// typedef union {
//   ///
//   /// Individual bit fields
//   ///
//   struct {
//     UINT32 Rsvd0 : 2;

//                             /* Bits[1:0], Access Type=RO, default=None*/

//                             /* Reserved */
//     UINT32 26Entries : 1;

//                             /* Bits[2:2], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 26 XQ entries out of 32 */
//     UINT32 23Entries : 1;

//                             /* Bits[3:3], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 23 XQ entries out of 32 */
//     UINT32 20Entries : 1;

//                             /* Bits[4:4], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 20 XQ entries out of 32 */
//     UINT32 17Entries : 1;

//                             /* Bits[5:5], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 17 XQ entries out of 32 */
//     UINT32 14Entries : 1;

//                             /* Bits[6:6], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 14 XQ entries out of 32 */
//     UINT32 11Entries : 1;

//                             /* Bits[7:7], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 11 XQ entries out of 32 */
//     UINT32 8Entries : 1;

//                             /* Bits[8:8], Access Type=RW, default=0x00000000*/

//                             /* A core gets max 8 XQ entries out of 32 */
//     UINT32 Rsvd9 : 7;

//                             /* Bits[15:9], Access Type=RO, default=None*/

//                             /* Reserved */

//   } Bits;

//   UINT32 Uint32;
//   UINT64 Uint64;

// } JSL_MSR_VIRT_CR_XQ_WATERMARK_REGISTER;

/**
  This RO MSR will be used to read the Ubox CPUBUSNO/CPUBUSNO1/CPUBUSNO_VALID CSRs
**/
#define JSL_MSR_VIRT_CR_CPU_BUSNUMBER 0x00000128

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Cpubusno0 : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Bus Number 0. */
    UINT32 Cpubusno1 : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* Bus Number 1. */
    UINT32 Cpubusno2 : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /* Bus Number 2. */
    UINT32 Cpubusno3 : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /* Bus Number 3. */
    UINT32 Cpubusno4 : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /* Bus Number 4. */
    UINT32 Cpubusno5 : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /* Bus Number 5. */
    UINT32 Rsvd48 : 15;

                            /* Bits[62:48], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               Set when the CSR is written with valid bus
                               numbers.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_CPU_BUSNUMBER_REGISTER;

/**

**/
#define JSL_MSR_CORE_INTERFACE_CR_MMCFG_RULE_CFG 0x00000129

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RuleEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable for this MMCFG interleave decoder. */
    UINT32 Length : 3;

                            /* Bits[3:1], Access Type=RW, default=0x00000004*/

                            /*
                               This field document the max bus number supported
                               by the interleave decoder. The following
                               configurations are supported: 3'b110 :
                               MaxBusNumber = 63 (ie. 64MB MMCFG range) 3'b101
                               : MaxBusNumber = 127 (ie 128MB MMCFG range)
                               3'b100 : MaxBusNumber = 256 (ie 256MB MMCFG
                               range) 3'b010 : MaxBusNumber = 512 (ie 512MB
                               MMCFG range) 3'b001 : MaxBusNumber = 1048 (ie 1G
                               MMCFG range) 3'b000 : MaxBusNumber = 2048 (ie 2G
                               MMCFG range) Minimum granularity of MMCFG range
                               will be 64MB
                            */
    UINT32 Rsvd4 : 2;

                            /* Bits[5:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidTargets : 8;

                            /* Bits[13:6], Access Type=RW, default=0x000000FF*/

                            /*
                               Marks the valid targets. Request to an invalid
                               target will result in an ABORT
                            */
    UINT32 Rsvd14 : 12;

                            /* Bits[25:14], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BaseAddress0 : 6;

                            /* Bits[31:26], Access Type=RW, default=0x00000000*/

                            /*
                               Marks the valid targets. Request to an invalid
                               target will result in an ABORT
                            */
    UINT32 BaseAddress1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               Marks the valid targets. Request to an invalid
                               target will result in an ABORT
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_MMCFG_RULE_CFG_REGISTER;
/**

**/
#define JSL_MSR_CORE_INTERFACE_CR_MMCFG_RULE_TARGET_LIST 0x0000012A
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_0 0x00000130
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_1 0x00000131
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_2 0x00000132
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_3 0x00000133
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_4 0x00000134
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_5 0x00000135
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_6 0x00000136
/**
  Anchor Cove MSR for reading boot policy information from the PCH. 8 new RDMSR range (addr 0x130-0x137), which read 64b each. Base addr is 0xFED58000 and reads are consecutive.
**/
#define JSL_MSR_VIRT_CR_ANC_BOOT_POLICY_7 0x00000137
/**
  Anchor Cove MSR to indicate that the initial boot block is complete, and to re-enable events. Write-only and accessible via the ACM.
**/
#define JSL_MSR_VIRT_CR_ANC_FORCE_BOOT_POLICY_ENFORCED 0x00000138

/**
  SLM e3430087:Write only MSR. On TNT, this is simply based on ANCHOR_COVE fuse (not SECURE_BOOT_CAPABILITY_ENABLE)
**/
#define JSL_MSR_VIRT_CR_ANC_INITIAL_BOOT_BLOCK_COMPLETE 0x00000139

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BiosRdyForMiscEvents : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               Writes of 0 and 1 are allowed. Note that on GLM,
                               WMRSR ignored writes of 0, and a write of 1 set
                               CPU_BIOS_RDY_FOR_MISC_INTERRUPTS in SEC
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_ANC_INITIAL_BOOT_BLOCK_COMPLETE_REGISTER;

/**
  An MSR for communicating basic policy information from the Anchor Cove ACM to early BIOS. Things like executing in NEM, thread protection enabled etc., will be communicated.
**/
#define JSL_MSR_VIRT_CR_ANC_SACM_INFO 0x0000013A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SacmData : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Anchor Cove boot policy information populated by
                               the AnC StartupACM
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AnchorCoveEnFuse : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000000*/

                            /*
                               Read-only bit to reflect the Anchor Cove enable
                               fuse
                            */
    UINT32 Pbe : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000000*/

                            /*
                               Read-only bit to reflect the PCH Protect BIOS
                               Environment bit
                            */
    UINT32 LtSxEnFuse : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000000*/

                            /* Read-only bit to reflect the LT-SX enable fuse */
    UINT32 NoResetSecretsProt : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000000*/

                            /*
                               Read-only bit to reflect no reset secrets
                               protection
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_ANC_SACM_INFO_REGISTER;

/**
  Set WSM i387670. MSR only accessible if AES is fuse enabled.
**/
#define JSL_MSR_UCODE_CR_FEATURE_CONFIG 0x0000013C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AesniLock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This is the LOCK bit for the AESNI MSR. Mapped
                               by ucode to ID_CR_DEBUG_DEFEATURE[0]
                            */
    UINT32 AesniDisable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               This is the DISABLE bit for the AESNI MSR.
                               Mapped by ucode to ID_CR_DEBUG_DEFEATURE[1].
                               WRMSR will GP if the lock bit is set.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_FEATURE_CONFIG_REGISTER;

/**
  Miscellaneous enables for thread specific features
**/
#define JSL_MSR_UCODE_CR_FEATURE_ENABLES 0x00000140

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CpuidGpOnCplGt0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Causes CPUID to #GP if CPL greater than 0 and
                               not in SMM.
                            */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_FEATURE_ENABLES_REGISTER;

/**
  GLP 1706546645: Black Point. SMM-only MSR which allows locking of various states while in SMM mode
**/
#define JSL_MSR_VIRT_CR_SMM_SUPOVR_STATE_LOCK 0x00000141

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PagingStates : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               When set, prevents changing various paging state
                               bits (CR0,CR3,CR4,EFER), and prevents task
                               switches
                            */
    UINT32 Smbase : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* When set, prevents RSM(SMI) from updating SMBASE */
    UINT32 Ia32SmmMonitorCtlMsr : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               When set, prevents WRMSR to IA32_SMM_MONITOR_CTL
                               (aka MSEG) MSR
                            */
    UINT32 Rsvd3 : 5;

                            /* Bits[7:3], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SMM_SUPOVR_STATE_LOCK_REGISTER;

/**
  MSR to manage consolidated clock ratio-based overclocking and voltage override.
**/
#define JSL_MSR_UCODE_CR_OVERCLOCKING_MAILBOX 0x00000150

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Overclocking read/write data. Software will
                               write this control to manipulate the
                               voltage/frequency curve and maximum overclocking
                               ratio (frequency) supported for a particular
                               domain. 7:0 Max OC Ratio. 19:8 Voltage Target,
                               U12.2.10V 20:20 Voltage target mode. 1=override,
                               0=PCU Adaptive 31:21 Voltage offset, S11.0.10V,
                               +/-500mV
                            */
    UINT32 Command : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Overclocking Mailbox Command: 0x10 (read), 0x11
                               (write). Commands in 0x1 to 0xf range are read-
                               only capabilities. Commands in 0x10 and up are
                               read/write.
                            */
    UINT32 Param1 : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               Parameter 1 contains the Domain ID (IA=0, GT=1,
                               CLR=2, Uncore=3)
                            */
    UINT32 Param2 : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000000*/

                            /*
                               Parameter 2 is currently not implemented or
                               supported in Haswell hardware. Reserved for
                               furture use, and should only be programmed to 0.
                               If set, COMMAND will be interpreted as 'Illegal
                               OC Mailbox command'. SNC: This is now supported
                               : b1304634937
                            */
    UINT32 Rsvd56 : 7;

                            /* Bits[62:56], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RunBusy : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               Writes without Run/Busy indicator set are
                               dropped on the floor
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_OVERCLOCKING_MAILBOX_REGISTER;

/**
  BIOS Done MSR for CNL i1351547. This replaces MSR 0x120 POWER_MISC[ENABLE_IA_UNTRUSTED_MODE]
**/
#define JSL_MSR_UCODE_CR_BIOS_DONE 0x00000151

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnableIaUntrusted : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This replaces MSR 0x120
                               POWER_MISC[ENABLE_IA_UNTRUSTED_MODE]. Cleared
                               only by reset (cold/warm). A change from 0->1
                               will increment BIOS_DONE_COUNTER in the SoC.
                               Writes to the bit will be ignored if the EAX[0]
                               is 0
                            */
    UINT32 SocBiosDone : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               Returns 1 if all available threads set their
                               ENABLE_IA_UNTRUSTED. Writes will be silently
                               dropped
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_BIOS_DONE_REGISTER;

/**
  SMM MSR that read-combines THREAD_SMI_ERR_SRC_SET_AND_STATUS for rdmsr and writes THREAD_SMI_ERR_SRCRESET for wrmsr
**/
#define JSL_MSR_VIRT_CR_THREAD_SMI_ERR_SRC 0x00000158

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* No thread scope machine check banks on TNT */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_THREAD_SMI_ERR_SRC_REGISTER;

/**
  Special uncore usage msr, work in PFAT or in SMM BIOS flash
**/
#define JSL_MSR_FUNNYIO_CR_SPCL_UNCORE_USAGE 0x0000015B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Sets or clear various DMIDIS bits */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SPCL_UNCORE_USAGE_REGISTER;
/**
  Registers used by probe mode software to communicate architectural state between the probe mode software and the processor. The MSRs are only visible in probe mode.
**/
#define JSL_MSR_BNL_CR_PDR_LOW 0x00000160
/**
  Registers used by probe mode software to communicate architectural state between the probe mode software and the processor. The MSRs are only visible in probe mode.
**/
#define JSL_MSR_BNL_CR_PDR_HIGH 0x00000161
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_2 0x00000162
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_3 0x00000163
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_4 0x00000164
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_5 0x00000165
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_6 0x00000166
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_7 0x00000167
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_8 0x00000168
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_9 0x00000169
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_10 0x0000016A
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_11 0x0000016B
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_12 0x0000016C
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_13 0x0000016D
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_14 0x0000016E
/**
  64 bit scratchpad registers used by event handlers which must return to the micro-code which caused the event to preserve the lower 64 bits of data in registers used by the event handler. They can also be used to save return EventUIP values when event handlers can themselves generate events. In addition, they are used in some cases as generic storage space by micro-code and during probe mode
**/
#define JSL_MSR_SCP_CR_IECRUD_REGISTER_15 0x0000016F

/**
  Register which contains the current SMM revision ID for the processor. See PPro Developer-s Manual, Vol. 3 for more information on using this register.
**/
#define JSL_MSR_X86_CR_SMREVID 0x00000170

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SmmRevisionIdentifier : 16;

                            /* Bits[15:0], Access Type=RO, default=0x00000000*/

                            /* SMM Revision identifier */
    UINT32 IoInstructionRestart : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000000*/

                            /*
                               Set to indicate IO instruction restart is
                               supported
                            */
    UINT32 SmbaseRelocation : 1;

                            /* Bits[17:17], Access Type=RO, default=0x00000000*/

                            /*
                               Set to indicate SMRAM base address relocation is
                               supported
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_SMREVID_REGISTER;

/**
  Register which contains the current SMM base value for the processor. The RESET event handler should set it to 0x00030000, which is the default value. When RSM executes, it reads the SMM base slot value in SMM memory and loads it into this register. The INIT event handler should not change the value of this register.
**/
#define JSL_MSR_SCP_CR_SMBASE 0x00000171

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Base : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Register which contains the current SMM base
                               value for the processor. The RESET event handler
                               should set it to 0x00030000, which is the
                               default value. When RSM executes, it reads the
                               SMM base slot value in SMM memory and loads it
                               into this register
                            */
    UINT32 PatchSignId : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Returns the micro-code update signature, after
                               the execution of a CPUID instruction with EAX
                               set to 1
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_SMBASE_REGISTER;
/**
  Used to program PPPE redirections.
**/
#define JSL_MSR_SCP_CR_PROBE_MODE_PPPE_REDIRECTION 0x00000172

/**
  No RSVD bit checks on upper bits. See NHM i354994. Register used by the ""Fast System Call"" facility (SYSENTER/SYSEXIT). Contains the OS copy of the Target ring 0 CS selector value.
**/
#define JSL_MSR_SCP_CR_SYSENTER_CS_MSR 0x00000174

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* need to define them */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               No GP fault on upper 32 bits to match legacy and
                               competition behavior. Ignored on writes. Could
                               be made available as a spare if all readers mask
                               h32.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_SYSENTER_CS_MSR_REGISTER;
/**
  Register used by the ""Fast System Call"" facility (SYSENTER/SYSEXIT). Contains the OS copy of the Target ring 0 ESP value. This CREG is a normal read/write MSR/bit.
**/
#define JSL_MSR_SCP_CR_SYSENTER_ESP_MSR 0x00000175
/**
  "Register used by the ""Fast System Call"" facility (SYSENTER/SYSEXIT). Contains the OS copy of the Target ring 0 entry point EIP value." This CREG is a normal read/write MSR/bit.
**/
#define JSL_MSR_SCP_CR_SYSENTER_EIP_MSR 0x00000176

/**
  Register that contains the poison and (not on Atom) viral bit valid / invalid state
**/
#define JSL_MSR_MEC_CR_MCG_CONTAIN 0x00000178

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pe : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Poison Enable - when set to '1' then the
                               Enhanced Containment Mode feature should be
                               enabled , when '0' then the behavior should be
                               legacy behavior. This bit is preserved on warm
                               reset and reset by ucode on cold reset.
                            */
    UINT32 RsvdEnableViral1 : 1;

                            /* Bits[1:1], Access Type=Rsvd0, default=None*/

                            /*
                               Viral Enable - when set to '1' then the Viral
                               Support should be enabled , when '0' (default)
                               then the behavior should be legacy behavior.
                               Viral is not supported on Atom
                            */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MEC_CR_MCG_CONTAIN_REGISTER;

/**
  MCA Capability Control Register. This MSR is read only; uCode generates #GP on any write.
**/
#define JSL_MSR_X86_CR_MCG_CAP 0x00000179

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NumberOfHardwareReportingBanksAvailable : 8;

                            /* Bits[7:0], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates the number of error-reporting banks
                               available on this processor
                            */
    UINT32 ImcgCtlIsPresent : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that this processor implements the
                               IA32_MCG_CTL MSR. Atom (SLT->GLM) does not
                               implement this register
                            */
    UINT32 ExtendedMachineCheckMsrsSupported : 1;

                            /* Bits[9:9], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that this processor implements the
                               extended machine check state registers found
                               starting at MSR address 180H. Atom (SLT->GLM)
                               does not implement these registers
                            */
    UINT32 McbCmciP : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /*
                               Correct MC Error counting / signalling is
                               supported. GLM i1958673: Report the disable from
                               an uncore SCP.
                            */
    UINT32 McgYellowGreen : 1;

                            /* Bits[11:11], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates that this processor implements
                               "yellow/green" health reporting. This is was
                               approved by CART for processors that have
                               erratic bit issues. Supported by Atom (SLT+).
                               MSR ucode always reports 1.
                            */
    UINT32 Rsvd12 : 4;

                            /* Bits[15:12], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 NumberOfExtendedMachineCheckRegisters : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates the number of extended machine check
                               state registers present on this processor
                            */
    UINT32 McgSerP : 1;

                            /* Bits[24:24], Access Type=RO, default=0x00000000*/

                            /* Software Error Recovery support is present */
    UINT32 McgEmcP : 1;

                            /* Bits[25:25], Access Type=RO, default=0x00000000*/

                            /* Enhanced Machine Check Capability */
    UINT32 McgElogP : 1;

                            /* Bits[26:26], Access Type=RO, default=0x00000000*/

                            /* Extended Error Logging */
    UINT32 McgLmceP : 1;

                            /* Bits[27:27], Access Type=RO, default=0x00000000*/

                            /* Local Machine Check Exception */
    UINT32 Rsvd28 : 4;

                            /* Bits[31:28], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MCG_CAP_REGISTER;

/**
  STW b2632460:Allow non-zero writes.
**/
#define JSL_MSR_X86_CR_MCG_STATUS 0x0000017A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ripv : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Restart IP valid. */
    UINT32 Eipv : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Error IP valid. */
    UINT32 Mcip : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Machine Check In Progress. */
    UINT32 Rsvd3 : 5;

                            /* Bits[7:3], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MCG_STATUS_REGISTER;

/**
  SMM MSR that read-combines [CORE|MODULE]_SMI_ERR_SRC_SET_AND_STATUS for rdmsr and writes [CORE|MODULE]_SMI_ERR_SRCRESET for wrmsr
**/
#define JSL_MSR_VIRT_CR_CORE_SMI_ERR_SRC 0x0000017C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mc0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* SMI Requested by bus mca bank write 1 only */
    UINT32 Mc1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* SMI Requested by l2 mca bank write 1 only */
    UINT32 Mc2 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* SMI Requested by fec mca bank write 1 only */
    UINT32 Mc3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* SMI Requested by mec mca bank write 1 only */
    UINT32 Rsvd4 : 4;

                            /* Bits[7:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_CORE_SMI_ERR_SRC_REGISTER;

/**
  Enhanced MCA Capabilities register
**/
#define JSL_MSR_UCODE_CR_SMM_MCA_CAP 0x0000017D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BankSupport : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000000*/

                            /*
                               ENHANCED_MCA only. One bit per bank. If bit is
                               set, then the corresponding bank supports
                               enhanced MCA.
                            */
    UINT32 Rsvd32 : 22;

                            /* Bits[53:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SmmProtMode : 1;

                            /* Bits[54:54], Access Type=RO, default=0x00000001*/

                            /* Set if SMM Protected Mode is supported. */
    UINT32 ErrorSpoofing : 1;

                            /* Bits[55:55], Access Type=RO, default=0x00000000*/

                            /*
                               Set if Error Spoofing and Enhanced MCA are
                               supported
                            */
    UINT32 TargetedSmi : 1;

                            /* Bits[56:56], Access Type=RO, default=0x00000001*/

                            /*
                               Set to 1 if the thread supports targeted SMI and
                               the SMM_ENABLE register (MSR 4E1h) is supported.
                            */
    UINT32 SmmCpuSvrstr : 1;

                            /* Bits[57:57], Access Type=RO, default=0x00000000*/

                            /*
                               Set to 1 if the SAVE/RESTORE feature is
                               supported and the SMM_FEATURE_CONTROL register
                               (MSR 4E0h) is supported.
                            */
    UINT32 SmmCodeAccessChk : 1;

                            /* Bits[58:58], Access Type=RO, default=0x00000001*/

                            /*
                               Set to 1 if the SMM code access check feature is
                               supported and the SMM_FEATURE_CONTROL register
                               (MSR 4E0h) is supported.
                            */
    UINT32 LongFlowIndication : 1;

                            /* Bits[59:59], Access Type=RO, default=0x00000001*/

                            /* Set to indicate SMM long flow indicator support */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_SMM_MCA_CAP_REGISTER;

/**
  SMM MSR that reads UNCORE_SMI_ERR_SRC_STATUS for rdmsr and writes UNCORE_SMI_ERR_SRC_RESET for wrmsr
**/
#define JSL_MSR_VIRT_CR_UNCORE_SMI_ERR_SRC 0x0000017E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 4;

                            /* Bits[3:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Allbanks : 28;

                            /* Bits[31:4], Access Type=RW, default=0x00000000*/

                            /*
                               Core Interface HSD 1706537587: No reserved bit
                               checks based on number of uncore banks
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_UNCORE_SMI_ERR_SRC_REGISTER;

/**
  A non-architectural, package-scoped MSR intended for use by BIOS. The bit will be saved and restored in C7+ states. The reset value for the bit is 0. It will not survive warm reset.
**/
#define JSL_MSR_FUNNYIO_CR_SCP_ERROR_CONTROL 0x0000017F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 4;

                            /* Bits[3:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciDisable : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When set will disable CMCI signalling: Rdmsr to
                               MCG_CAP will have bit 10 cleared to 0. Wrmsr to
                               MCi_MISC2 registers will clear bits[31:0] in all
                               modes.
                            */
    UINT32 Rsvd5 : 2;

                            /* Bits[6:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 LlcEwbDowngrade : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               For LLC EWB errors, allows EWB errors to be
                               downgraded to UCNA errors.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SCP_ERROR_CONTROL_REGISTER;

/**
  perf event selector for general counter 0
**/
#define JSL_MSR_IA32_CR_PERFEVTSEL0 0x00000186

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Selects the event to be monitored */
    UINT32 EventMask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event selected in the
                               event select field. For example, for some cache
                               events, the mask is used as a MESI-protocol
                               qualifier of cache states
                            */
    UINT32 UserModeFlag : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege levels 1, 2
                               or 3. This flag can be used in conjunction with
                               the OS flag.
                            */
    UINT32 OsModeFlag : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege level 0.
                               This flag can be used in conjunction with the
                               USR flag.
                            */
    UINT32 EdgeDetectFlag : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enables (when set) edge detection of events. The
                               processor counts the number of deasserted to
                               asserted transitions of any condition that can
                               be expressed by the other fields. The mechanism
                               is limited in that it does not permit back-to-
                               back assertions to be distinguished. This
                               mechanism allows software to measure not only
                               the fraction of time spent in a particular
                               state, but also the average length of time spent
                               in such a state (for example, the time spent
                               waiting for an interrupt to be serviced).
                            */
    UINT32 PinControlFlag : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor toggles the PMi pins and
                               increments the counter when performance-
                               monitoring events occur; when clear, the
                               processor toggles the PMi pins when the counter
                               overflows. The toggling of a pin is defined as
                               assertion of the pin for a single bus clock
                               followed by deassertion.
                            */
    UINT32 IntApicEnableFlag : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor generates an exception
                               through its local APIC on counter overflow for
                               this counter's thread.
                            */
    UINT32 MythreadAllthread : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 EnableFlag : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               When set, performance counting is enabled in the
                               performance-monitoring counter; when clear, the
                               counter is disabled.
                            */
    UINT32 InvertFlag : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Inverts the result of the counter-mask
                               comparison when set, so that both greater than
                               equal to and less than comparisons can be made.
                            */
    UINT32 CountMask : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               When nonzero, the processor compares this mask
                               to the number of events counted during a single
                               cycle. If the event count is greater than or
                               equal to this threshold, the counter is
                               incremented by one. Otherwise the counter is not
                               incremented. This mask enables counting cycles
                               in which multiple occurrences happen (for
                               example, two or more instructions retired per
                               clock).
                            */
    UINT32 Rsvd32 : 2;

                            /* Bits[33:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AdaptiveRecord : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Adaptive record. */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERFEVTSEL0_REGISTER;

/**
  perf event selector for general counter 1
**/
#define JSL_MSR_IA32_CR_PERFEVTSEL1 0x00000187

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Selects the event to be monitored */
    UINT32 EventMask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event selected in the
                               event select field. For example, for some cache
                               events, the mask is used as a MESI-protocol
                               qualifier of cache states
                            */
    UINT32 UserModeFlag : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege levels 1, 2
                               or 3. This flag can be used in conjunction with
                               the OS flag.
                            */
    UINT32 OsModeFlag : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege level 0.
                               This flag can be used in conjunction with the
                               USR flag.
                            */
    UINT32 EdgeDetectFlag : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enables (when set) edge detection of events. The
                               processor counts the number of deasserted to
                               asserted transitions of any condition that can
                               be expressed by the other fields. The mechanism
                               is limited in that it does not permit back-to-
                               back assertions to be distinguished. This
                               mechanism allows software to measure not only
                               the fraction of time spent in a particular
                               state, but also the average length of time spent
                               in such a state (for example, the time spent
                               waiting for an interrupt to be serviced).
                            */
    UINT32 PinControlFlag : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor toggles the PMi pins and
                               increments the counter when performance-
                               monitoring events occur; when clear, the
                               processor toggles the PMi pins when the counter
                               overflows. The toggling of a pin is defined as
                               assertion of the pin for a single bus clock
                               followed by deassertion.
                            */
    UINT32 IntApicEnableFlag : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor generates an exception
                               through its local APIC on counter overflow for
                               this counter's thread.
                            */
    UINT32 MythreadAllthread : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 EnableFlag : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               When set, performance counting is enabled in the
                               performance-monitoring counter; when clear, the
                               counter is disabled.
                            */
    UINT32 InvertFlag : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Inverts the result of the counter-mask
                               comparison when set, so that both greater than
                               equal to and less than comparisons can be made.
                            */
    UINT32 CountMask : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               When nonzero, the processor compares this mask
                               to the number of events counted during a single
                               cycle. If the event count is greater than or
                               equal to this threshold, the counter is
                               incremented by one. Otherwise the counter is not
                               incremented. This mask enables counting cycles
                               in which multiple occurrences happen (for
                               example, two or more instructions retired per
                               clock).
                            */
    UINT32 Rsvd32 : 2;

                            /* Bits[33:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AdaptiveRecord : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Adaptive record. */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERFEVTSEL1_REGISTER;

/**
  perf event selector for general counter 2
**/
#define JSL_MSR_IA32_CR_PERFEVTSEL2 0x00000188

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Selects the event to be monitored */
    UINT32 EventMask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event selected in the
                               event select field. For example, for some cache
                               events, the mask is used as a MESI-protocol
                               qualifier of cache states
                            */
    UINT32 UserModeFlag : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege levels 1, 2
                               or 3. This flag can be used in conjunction with
                               the OS flag.
                            */
    UINT32 OsModeFlag : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege level 0.
                               This flag can be used in conjunction with the
                               USR flag.
                            */
    UINT32 EdgeDetectFlag : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enables (when set) edge detection of events. The
                               processor counts the number of deasserted to
                               asserted transitions of any condition that can
                               be expressed by the other fields. The mechanism
                               is limited in that it does not permit back-to-
                               back assertions to be distinguished. This
                               mechanism allows software to measure not only
                               the fraction of time spent in a particular
                               state, but also the average length of time spent
                               in such a state (for example, the time spent
                               waiting for an interrupt to be serviced).
                            */
    UINT32 PinControlFlag : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor toggles the PMi pins and
                               increments the counter when performance-
                               monitoring events occur; when clear, the
                               processor toggles the PMi pins when the counter
                               overflows. The toggling of a pin is defined as
                               assertion of the pin for a single bus clock
                               followed by deassertion.
                            */
    UINT32 IntApicEnableFlag : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor generates an exception
                               through its local APIC on counter overflow for
                               this counter's thread.
                            */
    UINT32 MythreadAllthread : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 EnableFlag : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               When set, performance counting is enabled in the
                               performance-monitoring counter; when clear, the
                               counter is disabled.
                            */
    UINT32 InvertFlag : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Inverts the result of the counter-mask
                               comparison when set, so that both greater than
                               equal to and less than comparisons can be made.
                            */
    UINT32 CountMask : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               When nonzero, the processor compares this mask
                               to the number of events counted during a single
                               cycle. If the event count is greater than or
                               equal to this threshold, the counter is
                               incremented by one. Otherwise the counter is not
                               incremented. This mask enables counting cycles
                               in which multiple occurrences happen (for
                               example, two or more instructions retired per
                               clock).
                            */
    UINT32 Rsvd32 : 2;

                            /* Bits[33:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AdaptiveRecord : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Adaptive record. */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERFEVTSEL2_REGISTER;

/**
  perf event selector for general counter 3
**/
#define JSL_MSR_IA32_CR_PERFEVTSEL3 0x00000189

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Selects the event to be monitored */
    UINT32 EventMask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event selected in the
                               event select field. For example, for some cache
                               events, the mask is used as a MESI-protocol
                               qualifier of cache states
                            */
    UINT32 UserModeFlag : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege levels 1, 2
                               or 3. This flag can be used in conjunction with
                               the OS flag.
                            */
    UINT32 OsModeFlag : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies that events are counted only when the
                               processor is operating at privilege level 0.
                               This flag can be used in conjunction with the
                               USR flag.
                            */
    UINT32 EdgeDetectFlag : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enables (when set) edge detection of events. The
                               processor counts the number of deasserted to
                               asserted transitions of any condition that can
                               be expressed by the other fields. The mechanism
                               is limited in that it does not permit back-to-
                               back assertions to be distinguished. This
                               mechanism allows software to measure not only
                               the fraction of time spent in a particular
                               state, but also the average length of time spent
                               in such a state (for example, the time spent
                               waiting for an interrupt to be serviced).
                            */
    UINT32 PinControlFlag : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor toggles the PMi pins and
                               increments the counter when performance-
                               monitoring events occur; when clear, the
                               processor toggles the PMi pins when the counter
                               overflows. The toggling of a pin is defined as
                               assertion of the pin for a single bus clock
                               followed by deassertion.
                            */
    UINT32 IntApicEnableFlag : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor generates an exception
                               through its local APIC on counter overflow for
                               this counter's thread.
                            */
    UINT32 MythreadAllthread : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 EnableFlag : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               When set, performance counting is enabled in the
                               performance-monitoring counter; when clear, the
                               counter is disabled.
                            */
    UINT32 InvertFlag : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Inverts the result of the counter-mask
                               comparison when set, so that both greater than
                               equal to and less than comparisons can be made.
                            */
    UINT32 CountMask : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               When nonzero, the processor compares this mask
                               to the number of events counted during a single
                               cycle. If the event count is greater than or
                               equal to this threshold, the counter is
                               incremented by one. Otherwise the counter is not
                               incremented. This mask enables counting cycles
                               in which multiple occurrences happen (for
                               example, two or more instructions retired per
                               clock).
                            */
    UINT32 Rsvd32 : 2;

                            /* Bits[33:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AdaptiveRecord : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Adaptive record. */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERFEVTSEL3_REGISTER;

/**
  The Flexible Boot register is written by BIOS in order to modify the maximum non-turbo ratio on the next reset. The DP/MP systems use this FLEX_RATIO in this register to configure the maximum common boot ratio for all physical processors in the system. The value in the FLEX_RATIO take effect on the next reset based on the value of FLEX_EN.
**/
#define JSL_MSR_CORE_INTERFACE_CR_FLEX_RATIO 0x00000194

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 OcExtraVoltage : 8;

                            /* Bits[7:0], Access Type=RWS, default=0x00000000*/

                            /*
                               Extra voltage to be used for Over Clocking. The
                               voltage is defined in units of 1/256 Volts.
                            */
    UINT32 FlexRatio : 8;

                            /* Bits[15:8], Access Type=RWS, default=0x00000000*/

                            /*
                               Desired Flex ratio. When enabled, the value in
                               this field will set the maximum non-turbo ratio
                               available. If this value is greater than the
                               maximum ratio set by hardware, this field is
                               ignored.
                            */
    UINT32 Enable : 1;

                            /* Bits[16:16], Access Type=RWS, default=0x00000000*/

                            /*
                               Flex Ratio Enabled. When set to 1, indicates
                               that the value programmed in FLEX_RATIO field
                               will be used to override the maximum non-turbo
                               ratio on next reboot. When this bit is cleared,
                               all write to FLEX_RATIO field will be ignored.
                               However there will be no GP-fault# generated.
                            */
    UINT32 OcBins : 3;

                            /* Bits[19:17], Access Type=RO, default=0x00000000*/

                            /*
                               This field indicates the maximum number of bins
                               by which the part can be overclocked
                            */
    UINT32 OcLock : 1;

                            /* Bits[20:20], Access Type=RW1S, default=0x00000000*/

                            /*
                               Once set to 1, the overclocking bitfields become
                               locked from further writes are ignored. A reset
                               is required to clear the lock. Note: System BIOS
                               must set this bit to lock down overclocking
                               limits.
                            */
    UINT32 Rsvd21 : 11;

                            /* Bits[31:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_FLEX_RATIO_REGISTER;

/**
  Performance Status MSR. On Core family, this msr register contains the FIVR DAC target and core pll ratio. There is not the same FIVR internal regulation present inside GLM like HSW/BDW. On GLM, this does reflect the Voltage target given to an external VR (SVID or PMIC) or Internal VR called DSLDO (digital synthesized LDO). For DNV, the internal DSLDO is not intended to be used as all cores share a common external Voltage rail coming from a PMIC or SVID controller.
**/
#define JSL_MSR_VIRT_CR_PERF_STATUS 0x00000198

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pllratio : 8;

                            /* Bits[15:8], Access Type=RO, default=0x00000008*/

                            /*
                               Current performance State Value bits 15:8.Ratio
                               of the core pll
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CoreVoltage : 16;

                            /* Bits[47:32], Access Type=RO, default=0x00000000*/

                            /*
                               Voltage in 3.13 format. On TNT/SNC, pcode gives
                               this is the desired format, so no conversion
                               needed
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_PERF_STATUS_REGISTER;

/**
  Performance Control MSR. SW makes request for a new Performance state (P-State) by writing this MSR.
**/
#define JSL_MSR_C6_SCP_CR_PERF_CTL 0x00000199

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 VReq : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Voltage request - Not used = legacy. SLM
                               comment:Requested Vcc as encoded by VID table.
                               Is checked against MAX_VID, specified by fuses
                               and truncated to MAX_VID if higher.
                            */
    UINT32 PReq : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved15 : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=None*/

                            /* Match SKL, and dont do #GP checks. Why? */
    UINT32 Pqosofst : 6;

                            /* Bits[21:16], Access Type=RW, default=0x00000000*/

                            /*
                               P/H P-State QoS offset. Match SKL and do #GP
                               checks
                            */
    UINT32 Rsvd22 : 10;

                            /* Bits[31:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TurboDisable : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* written by OS software for per core */
    UINT32 Rsvd33 : 31;

                            /* Bits[63:33], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_C6_SCP_CR_PERF_CTL_REGISTER;

/**
  [p]PUNIT_MSR: Interface for SW controlled clock modulation. Mechanism is implemented in GLM using Ehalt.[/p]
  [p][b]MSR_Name[/b]: IA32_CLOCK_MODULATION  [b]MSR_Addr[/b]: 0x19A[/p]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_P_CR_THREAD_T_REQ 0x0000019A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TStateReq : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the clock modulation duty cycle (in
                               6.45% increments). This field is only active
                               when the clock modulation enable flag is set
                               (THROTTLE_ACTIVE).
                            */
    UINT32 ThrottleActive : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Enables on-demand software controlled clock
                               modulation.
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_P_CR_THREAD_T_REQ_REGISTER;

/**
  [p]PUNIT_MSR: CPU Core thermal interrupt control register.  This register is used to configure core or package level notifications of important thermal events.  These interrupts may be routed directly to this local core's APIC Thermal LVT or optional modes may be configured that allow the thermal interrupt notification to be routed to a master core for processing (fore more details on locking thermal interrupts, see the MISC_PWR_MGMT MSR definition).[/p]
  [p][b]MSR_Name[/b]: THERM_INTERRUPT  [b]MSR_Addr[/b]: 0x19B[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_THERM_INTERRUPT 0x0000019B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HighTempIntEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable the
                               generation of an interrupt on the transition
                               from a temperature below the thermal monitor
                               activation temperature to a temperature equal to
                               or greater than it. This interrupt will be sent
                               on any rising edge of the Thermal Monitor Status
                               bit of this core.
                            */
    UINT32 LowTempIntEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable the
                               generation of an interrupt on the transition
                               from a temperature above or equal to the thermal
                               monitor activation temperature to a temperature
                               below it. This interrupt will be sent on any
                               falling edge of the Thermal Monitor Status bit
                               of this core.
                            */
    UINT32 ProchotIntEnable : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable a thermal
                               interrupt delivery upon detection of PROCHOT#
                               input assertion or deassertion event.
                            */
    UINT32 Reserved3 : 1;

                            /* Bits[3:3], Access Type=RSV, default=0x00000000*/

                            /* reserved */
    UINT32 OutOfSpecIntEnable : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable thermal
                               interrupt delivery upon observation that the
                               processor is operating out of its thermal
                               specification. This interrupt is designed as an
                               early warning of thermal runaway in the silicon
                               and shutdown is recommended.
                            */
    UINT32 Reserved5 : 3;

                            /* Bits[7:5], Access Type=RSV, default=0x00000000*/

                            /* reserved */
    UINT32 Threshold1RelTemp : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies temperature Threshold 1 value as as a
                               negative offset from the reference maximum
                               junction temperature (defined in
                               TEMPERATURE_TARGET.REF_TEMP). This temperature
                               threshold is compared against the corresponding
                               Thermal Status Relative Temperature reading for
                               this core.
                            */
    UINT32 Threshold1IntEnable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Threshold 1 Interrupt Enable is used to enable
                               thermal interrupt notifcation to software upon
                               any rising or falling detection of core
                               temperature crossing the Threshold 1
                               temperature.
                            */
    UINT32 Threshold2RelTemp : 7;

                            /* Bits[22:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies temperature Threshold 2 value as as a
                               negative offset from the reference maximum
                               junction temperature (defined in
                               TEMPERATURE_TARGET.REF_TEMP). This temperature
                               threshold is compared against the corresponding
                               Thermal Status Relative Temperature reading for
                               this core.
                            */
    UINT32 Threshold2IntEnable : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Threshold 2 Interrupt Enable is used to enable
                               thermal interrupt notifcation to software upon
                               any rising or falling detection of core
                               temperature crossing the Threshold 2
                               temperature.
                            */
    UINT32 SparePwrLimitEnable : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               [b]NOT USED[/b]. Reserved for Power Limit
                               Notification Enable.
                            */
    UINT32 Reserved25 : 7;

                            /* Bits[31:25], Access Type=RSV, default=0x00000000*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_THERM_INTERRUPT_REGISTER;

/**
  [p]PUNIT_MSR: CPU Core thermal and power status register.  This register is typically used to inspect the thermal status of a specific core, as well as to discover the sources of core thermal interrupt events.[/p]
  [p][b]MSR_Name[/b]: THERM_STATUS  [b]MSR_Addr[/b]: 0x19C[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_THERM_STATUS 0x0000019C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThermalMonitorStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               This bit indicates that the Thermal Monitor has
                               tripped and is currently thermally throttling
                               this core. If software has programmed a thermal
                               monitor control temperature below the
                               manufacturing default of this processor, this
                               flag will assert when the software programmed
                               constraint has been exceeded.
                            */
    UINT32 ThermalMonitorLog : 1;

                            /* Bits[1:1], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the core has seen
                               a rising edge on the Thermal Monitor Status bit
                               since the last time this bit was cleared by
                               software.
                            */
    UINT32 ProchotStatus : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that the external PROCHOT#
                               pin is currently being asserted. This will only
                               assert when the processor is configured in Bi-
                               directional PROCHOT# mode (when PROCHOT# is
                               configured as an input)
                            */
    UINT32 ProchotLog : 1;

                            /* Bits[3:3], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the PROCHOT#
                               status bit has asserted or deasserted since the
                               last time this bit was cleared by software.
                            */
    UINT32 OutOfSpecStatus : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /*
                               When set, this event indicates that the
                               processor has observed a critical thermal
                               excursion. It is intended as an early warning of
                               thermal runaway in the silicon and shutdown is
                               recommended.
                            */
    UINT32 OutOfSpecLog : 1;

                            /* Bits[5:5], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that a Critical
                               Thermal Event was detected since the last time
                               this bit was cleared by software.
                            */
    UINT32 Threshold1Status : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               [p]Indicates whether the actual temperature is
                               currently higher than or equal to the value set
                               in Thermal Threshold 1.[/p] [list] [*] 0 =
                               Current temperature is below threshold 1 [*] 1 =
                               Current temperature at or above threshold 1
                               [/list]
                            */
    UINT32 Threshold1Log : 1;

                            /* Bits[7:7], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising or
                               falling edge of the thermal threshold 1 status
                               indicator. This flag remains asserted until
                               software clears it
                            */
    UINT32 Threshold2Status : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /*
                               [p]Indicates whether the actual temperature is
                               currently higher than or equal to the value set
                               in Thermal Threshold 2.[/p] [list] [*] 0 =
                               Current temperature is below threshold 2 [*] 1 =
                               Current temperature at or above threshold 2
                               [/list]
                            */
    UINT32 Threshold2Log : 1;

                            /* Bits[9:9], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising or
                               falling edge of the thermal threshold 2 status
                               indicator. This flag remains asserted until
                               software clears it
                            */
    UINT32 PowerLimitationStatus : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /*
                               The power limit status flag asserts at any time
                               that the domain is performance limited due to
                               power constraints. Performance limitation due to
                               power limits is measured as observing the
                               resolved domain level frequency below the
                               software requested frequency, even within the
                               Turbo operating region. The RAPL PL1 and PL2
                               power limits are the only sources of this power
                               constraint.
                            */
    UINT32 PowerLimitationLog : 1;

                            /* Bits[11:11], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising edge of
                               the Power Limitation Status indicator. This flag
                               remains asserted until software clears it
                            */
    UINT32 CurrentLimitStatus : 1;

                            /* Bits[12:12], Access Type=ROFW, default=0x00000000*/

                            /*
                               RO - If set (1), indicates an electrical current
                               limit (e.g. Electrical Design Point/IccMax) is
                               being exceeded and is adversely impacting energy
                               efficiency optimizations
                            */
    UINT32 CurrentLimitLog : 1;

                            /* Bits[13:13], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               R/WC0 - If set (1), an electrical current limit
                               has been exceeded that has adversely impacted
                               energy efficiency optimizations since the last
                               clearing of this bit or a reset. This bit is
                               sticky, software may clear this bit by writing a
                               zero (0).
                            */
    UINT32 CrossDomainLimitStatus : 1;

                            /* Bits[14:14], Access Type=ROFW, default=0x00000000*/

                            /*
                               RO - If set (1), indicates another hardware
                               domain (e.g. processor graphics) is currently
                               limiting energy efficiency optimizations in the
                               processor core domain.
                            */
    UINT32 CrossDomainLimitLog : 1;

                            /* Bits[15:15], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               R/WC0 - If set (1), indicates another hardware
                               domain (e.g. processor graphics) has limited
                               energy efficiency optimizations in the processor
                               core domain since the last clearing of this bit
                               or a reset. This bit is sticky, software may
                               clear this bit by writing a zero (0).
                            */
    UINT32 Temperature : 7;

                            /* Bits[22:16], Access Type=RO, default=0x00000000*/

                            /*
                               Current temperature of the domain, reported as a
                               negative offset from the reference maximum
                               junction temperature. E.g., a reading of 10 with
                               a reference temperature of 90'C implies this
                               domain is currently operating at 80'C. The
                               reference temperature may be discovered in
                               TEMPERATURE_TARGET.REF_TEMP
                            */
    UINT32 Reserved23 : 4;

                            /* Bits[26:23], Access Type=RSV, default=0x00000000*/

                            /* reserved */
    UINT32 Resolution : 4;

                            /* Bits[30:27], Access Type=RO, default=0x00000001*/

                            /*
                               Supported resolution in degrees Celsius.
                               Hardcoded to 1'C.
                            */
    UINT32 Valid : 1;

                            /* Bits[31:31], Access Type=RO, default=0x00000000*/

                            /*
                               Valid flag indicating the validity of the
                               current temperature readout. [list] [*] 0 =
                               Invalid [*] 1 = Valid [/list]
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_THERM_STATUS_REGISTER;

/**
  return 0x0 on reads to MSR_THERM2_CTL MSR (called CLOCK_GEYSIII_THERM on Merom). Functionality associated with this MSR does not exist since NHM. Can't get rid of this MSR since this is an architectural MSR
**/
#define JSL_MSR_UCODE_CR_MSR_THERM2_CTL 0x0000019D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=Rsvd0, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_MSR_THERM2_CTL_REGISTER;

/**
  This is the fully-populated spec for MISC_ENABLES. TNT: No need to skip reserved bit checks for XuCode due to proto removal.
**/
#define JSL_MSR_IA32_CR_MISC_ENABLES 0x000001A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FastStrings : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable fast strings. Thread Scope */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ThermalMonitorEnable : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Changed to package scope on GLM. Ucode picks up
                               this value from PCU_CR_FIRM_CONFIG. Global TM
                               EN. This is a union of bits 3, 13 (ENABLE_TT2)
                               and 36 (ENABLE_EMTTM). A value = 0 (default)
                               indicates disabled, and a value = 1 indicates
                               enabled. (p4 compatible). Activation is possible
                               only if FB_THERM_THROT_DIS_FUSE is '0'".
                            */
    UINT32 Rsvd4 : 3;

                            /* Bits[6:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EmonAvailable : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Always 1 on TNT. Indicates that perfmon MSRs are
                               always available and read/write.
                            */
    UINT32 Rsvd8 : 3;

                            /* Bits[10:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BtsUnavailable : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=None*/

                            /*
                               Core Scope. If set the processor does not
                               support Branch Trace Stores. WRMSR ucode
                               prevents setting this bit.
                            */
    UINT32 PebsUnavailable : 1;

                            /* Bits[12:12], Access Type=Rsvd0, default=None*/

                            /*
                               Core Scope. Based Sampling debug feature. RDMSR
                               ucode returns !EMON_AVAILABLE. Written value is
                               ignored.
                            */
    UINT32 Rsvd13 : 3;

                            /* Bits[15:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnableGv3 : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Package scope on GLM. Ucode gets this from
                               PCU_CR_FIRM_CONFIG. Geyserville3 Enable (R/W).
                               Setting this bit enables the Geyserville3
                               mechanism. The software can set the processor
                               operating point by writing the proper VID and
                               frequency ratio into the CLK_GEYSIII_CONTROL
                               register. Default value is 0 (disabled). This
                               bit is affected by fuse settings, and can be set
                               to 1 only if FB_GV3_DISABLE_FUSE is '0 . This
                               bit is write protected by the GV_SEL_LOCK bit.
                            */
    UINT32 Rsvd17 : 1;

                            /* Bits[17:17], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnableMonitorFsm : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Thread Scope. Reset ucode sets this bit. Sw
                               Enables MONITOR/MWAIT FSM in BLS
                            */
    UINT32 Rsvd19 : 3;

                            /* Bits[21:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 BootNt4 : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Thread Scope. Setting this bit causes CPUID to
                               pretend leaves 4 and 5 don't exist and that the
                               max defined leaf is 3.
                            */
    UINT32 DisableEchoingTprMessages : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               MSR ucode maps this to
                               BUS_CR_PIC_THREAD_CONFIG[TPR_MESSAGE_DISABLE].
                               See TNT 1706598817
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 6;

                            /* Bits[37:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TurboDisable : 1;

                            /* Bits[38:38], Access Type=RW, default=0x00000000*/

                            /*
                               Package scope. Ucode gets this from
                               PCU_CR_FIRM_CONFIG. Disable Turbo capability.
                            */
    UINT32 Rsvd39 : 25;

                            /* Bits[63:39], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_MISC_ENABLES_REGISTER;

/**
  Temperature margin in PECI temperature counts from the thermal profile specification.  Platform fan control SW is expected to read therm_margin value to control fan or blower speed.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_MARGIN 0x000001A1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThermMargin : 16;

                            /* Bits[15:0], Access Type=RO, default=0x00000000*/

                            /*
                               Temperature margin in PECI temperature counts
                               from the thermal profile specification.
                               THERM_MARGIN is in 2's complement format (8.8
                               format where MSB equals 1 Sign bit + 7 bits of
                               integer temperature value and the LSB equals 8
                               precison bits of temperature value). A value of
                               zero indicates the hottest CPU die temperature
                               is on the thermal profile line. A negative value
                               indicates gap to the thermal profile that
                               platform SW should increase cooling capacity. A
                               sustained negative value should be avoided as it
                               may impact part reliability.
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_MARGIN_REGISTER;

/**
  [p]This register contains information about the fan speed control target temperature as well as details on the reference temperature for IA core DTS relative temperature reading.[/p]
  [p][b]MSR_Name[/b]: TEMPERATURE_TARGET  [b]MSR_Addr[/b]: 0x1A2[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_TEMPERATURE_TARGET 0x000001A2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TccOffsetTimeWindow : 7;

                            /* Bits[6:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Describes the RATL averaging time window:
                               TCC_OFFSET_TIME_WINDOW = TIME_UNIT * (1 + (x /
                               4)) * 2^y where: x = TCC_OFFSET_TIME_WINDOW
                               [6:5] y = TCC_OFFSET_TIME_WINDOW [4:0] TIME_UNIT
                               is defined by package_POWER_SKU_UNIT MSR
                            */
    UINT32 TccOffsetClamp : 1;

                            /* Bits[7:7], Access Type=RW_L, default=0x00000000*/

                            /*
                               When enabled will allow throttling below P1
                               TCC_Offset clamp bit: 1: allow going below P1;
                               0: not allow going below P1. When
                               TCC_OFFSET_TIME_WINDOW is set to zero, clamping
                               bit is ignored.
                            */
    UINT32 FanTempTargetOffset : 8;

                            /* Bits[15:8], Access Type=RO, default=0x00000000*/

                            /*
                               Fan Temperature Target Offset a.k.a. TControl
                               indicates the relative offset from the the
                               Thermal Monitor Trip Temperature at which fans
                               should be engaged.
                            */
    UINT32 RefTemp : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000000*/

                            /*
                               Tjmax a.k.a. Thermal Monitor activation
                               temperature or Prochot Temperature. This is the
                               maximum junction temperature at which thermal
                               throttling aka thermal monitor is activated.
                               This temperature is the maximum temperature at
                               which the silicon is capable of operating at.
                               All IA core digital thermal sensor readings are
                               reported as a relative nagative offset from this
                               reference temperature, such that a readon of
                               zero implies the cores are running at this
                               temperature.
                            */
    UINT32 TjMaxTccOffset : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field allows platform software to configure
                               the temperature at which thermal monitor engages
                               to be lower than the manufacturing configured
                               maximum constraint. This field is programmed in
                               1'C units. E.g., if the default silicon
                               configured maximum temperature is 100'C and this
                               field is configured to 10, then the silicon will
                               engage thermal throttling algorithms at 90'C
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Locked : 1;

                            /* Bits[31:31], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, this entire register becomes read-
                               only.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_TEMPERATURE_TARGET_REGISTER;

/**
  Mixed scope MSR that holds prefetch disable bits. Bits in this MSR map to 2 different cregs. This was added on GLM for the cQOS issue. SLM i1214941: Added prefetcher disable MSR for Avoton B0. See NHM issue 386311 and ECO 466960 for details of when it was added to Core
**/
#define JSL_MSR_UCODE_CR_MISC_FEATURE_CONTROL 0x000001A4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MlcStreamerPrefetchDisable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Module scope: WMRSR maps this to
                               EBL_CR_DEBUG_CTL1_PREF_UCODE_DISABLE
                            */
    UINT32 MlcSpatialPrefetchDisable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Doesn't exist on TNT - no state. Won't GP to
                               match SNC
                            */
    UINT32 DcuStreamerPrefetchDisable : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Core scope: On TNT,
                               MEC_CR_MODES_AND_DEFEATURES[DISABLE_NLP] - Turn
                               off the nlp prefetcher. Prior to TNT, this was
                               mapped to a unified disable bit
                               MEC_CR_MODES_AND_DEFEATURES[DISABLE_PREFETCHER]
                            */
    UINT32 DcuIpPrefetchDisable : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Core scope: Mapped to
                               MEC_CR_MODES_AND_DEFEATURES[DISABLE_IPP].
                               Disable IPP by ignoring IPP pf request and
                               preventing logic toggles related to dcipp
                            */
    UINT32 DcuNextPagePrefetchDisable : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Core scope: Mapped to
                               MEC_CR_MODES_AND_DEFEATURES[DISABLE_NPP]. Stop
                               NPP from any entry allocation and making NPP
                               prefetch requests
                            */
    UINT32 Rsvd5 : 6;

                            /* Bits[10:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DisableThreeStrikeCnt : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               New on GLM E0/GLP. Module scope: Prevent the
                               Three Strike Counter from incrementing
                            */
    UINT32 Rsvd12 : 4;

                            /* Bits[15:12], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_MISC_FEATURE_CONTROL_REGISTER;

/**
  Uncore PerfMon Register 0
**/
#define JSL_MSR_SLM_CR_OFFCORE_RESP0 0x000001A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TrueDemandCacheLoad : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* DRd that is not tagged homeless. */
    UINT32 DemandRfo : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* ItoM or RFO that is not tagged homeless. */
    UINT32 DemandCodeRead : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* CRd or CRd_UC */
    UINT32 CoreModifiedWriteback : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* WBMtoI or WBMtoE */
    UINT32 HwPrefetchMlcLoad : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               L2 prefetcher requests triggered by reads from
                               MEC (except those triggered by I-side)
                            */
    UINT32 HwPrefetchMlcRfo : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* L2 prefetcher requests triggered by RFOs */
    UINT32 HwPrefetchMlcCode : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               L2 prefetcher requests triggered by I-side
                               requests
                            */
    UINT32 HwPrefetchLlcLoad : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by DRd (RSVD for
                               TNT)
                            */
    UINT32 HwPrefetchLlcRfo : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by RFO (RSVD for
                               TNT)
                            */
    UINT32 HwPrefetchLlcCode : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by CRd (RSVD for
                               TNT)
                            */
    UINT32 L1Prefetch : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Covers PFRFO, PFNEAR, PFMED, PFFAR, PFHW, PFNTA,
                               PFNPP, PFIPP including the Homeless versions.
                            */
    UINT32 AllStreamingStore : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* WCiL or WCiLF */
    UINT32 CoreNonModifiedWb : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* WBEFtoI or WBEFtoE */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Other : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Includes CLFlush, CLFlushOPT, CLDemote, CLWB,
                               Enqueue SetMonitor, PortIn, IntA, Lock,
                               SplitLock, Unlock, SpCyc, ClrMonitor, PortOut,
                               IntPriUp, IntLog, IntPhy, EOI, RdCurr, WbStoI,
                               LLCWBInv, LLCInv, NOP, PCOMMIT
                            */
    UINT32 AnyResp : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Match on any response */
    UINT32 SupplierNone : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Supplier: None, DATA_PRE [6:3] = 0 */
    UINT32 LlcHitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, M-state, DATA_PRE [6:3] = 2 */
    UINT32 LlcHitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, E-state, DATA_PRE [6:3] = 4 */
    UINT32 LlcHitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, S-state, DATA_PRE [6:3] = 6 */
    UINT32 LlcHitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, F-state, DATA_PRE [6:3] = 8 */
    UINT32 FarMemLocal : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* Supplier: Far Memory, Local, DATA_PRE [6:3] = 1 */
    UINT32 FarMemRemote0Hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 0-hop, DATA_PRE [6:3]
                               = 3
                            */
    UINT32 FarMemRemote1Hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 1-hop, DATA_PRE [6:3]
                               = 5
                            */
    UINT32 FarMemRemote2PlusHop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 2+ hop, DATA_PRE [6:3]
                               = 7
                            */
    UINT32 NearMemLocal : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* Supplier: Near Memory, Local DATA_PRE [6:3] = E */
    UINT32 NearMemRemote0Hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 0-hop, DATA_PRE [6:3]
                               = B
                            */
    UINT32 NearMemRemote1Hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 1-hop, DATA_PRE [6:3]
                               = D
                            */
    UINT32 NearMemRemote2PlusHop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 2+ hop, DATA_PRE
                               [6:3] = F
                            */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: SPL-hit, DATA_PRE 2:0] = 6 */
    UINT32 SnoopNone : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: None, DATA_PRE 2:0] = 0 */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Not needed, DATA_PRE 2:0] = 1 */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Miss, DATA_PRE 2:0] = 2 */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Hit No Fwd, DATA_PRE 2:0] = 3 */
    UINT32 HitEfWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Hit EF w/Fwd, DATA_PRE 2:0] = 4 */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: HitM, DATA_PRE 2:0] = 5 */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: HitM, DATA_PRE 2:0] = 5 */
    UINT32 GoErr : 1;

                            /* Bits[38:38], Access Type=RW, default=0x00000000*/

                            /* GO-ERR, RspData[3:0] = 0100 */
    UINT32 GoNoGo : 1;

                            /* Bits[39:39], Access Type=RW, default=0x00000000*/

                            /* GO-NoGO, RspData[3:0] = 0111 */
    UINT32 Reserved40 : 4;

                            /* Bits[43:40], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 UcLoad : 1;

                            /* Bits[44:44], Access Type=RW, default=0x00000000*/

                            /* PRd or UCRdF */
    UINT32 UcStore : 1;

                            /* Bits[45:45], Access Type=RW, default=0x00000000*/

                            /* WiL */
    UINT32 PartialStreamingStores : 1;

                            /* Bits[46:46], Access Type=RW, default=0x00000000*/

                            /* WCiL */
    UINT32 FullStreamingStores : 1;

                            /* Bits[47:47], Access Type=RW, default=0x00000000*/

                            /* WCiLF */
    UINT32 L1ModifiedWb : 1;

                            /* Bits[48:48], Access Type=RW, default=0x00000000*/

                            /* EVICTION EXTTYPE from MEC */
    UINT32 L2ModifiedWb : 1;

                            /* Bits[49:49], Access Type=RW, default=0x00000000*/

                            /* WBMtoI or WBMtoE */
    UINT32 Psmi : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000000*/

                            /* MemPushWr_NS (PSMI only) */
    UINT32 Itom : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /* ItoM */
    UINT32 Reserved52 : 11;

                            /* Bits[62:52], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 OutstandingReq : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* Average latency outstanding requests. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SLM_CR_OFFCORE_RESP0_REGISTER;

/**
  Uncore PerfMon Register 1
**/
#define JSL_MSR_SLM_CR_OFFCORE_RESP1 0x000001A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TrueDemandCacheLoad : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* DRd that is not tagged homeless. */
    UINT32 DemandRfo : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* ItoM or RFO that is not tagged homeless. */
    UINT32 DemandCodeRead : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* CRd or CRd_UC */
    UINT32 CoreModifiedWriteback : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* WBMtoI or WBMtoE */
    UINT32 HwPrefetchMlcLoad : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               L2 prefetcher requests triggered by reads from
                               MEC (except those triggered by I-side)
                            */
    UINT32 HwPrefetchMlcRfo : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* L2 prefetcher requests triggered by RFOs */
    UINT32 HwPrefetchMlcCode : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               L2 prefetcher requests triggered by I-side
                               requests
                            */
    UINT32 HwPrefetchLlcLoad : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by DRd (RSVD for
                               TNT)
                            */
    UINT32 HwPrefetchLlcRfo : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by RFO (RSVD for
                               TNT)
                            */
    UINT32 HwPrefetchLlcCode : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               LLC prefetch requests triggered by CRd (RSVD for
                               TNT)
                            */
    UINT32 L1Prefetch : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Covers PFRFO, PFNEAR, PFMED, PFFAR, PFHW, PFNTA,
                               PFNPP, PFIPP including the Homeless versions.
                            */
    UINT32 AllStreamingStore : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* WCiL or WCiLF */
    UINT32 CoreNonModifiedWb : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* WBEFtoI or WBEFtoE */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Other : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Includes CLFlush, CLFlushOPT, CLDemote, CLWB,
                               Enqueue SetMonitor, PortIn, IntA, Lock,
                               SplitLock, Unlock, SpCyc, ClrMonitor, PortOut,
                               IntPriUp, IntLog, IntPhy, EOI, RdCurr, WbStoI,
                               LLCWBInv, LLCInv, NOP, PCOMMIT
                            */
    UINT32 AnyResp : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Match on any response */
    UINT32 SupplierNone : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Supplier: None, DATA_PRE [6:3] = 0 */
    UINT32 LlcHitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, M-state, DATA_PRE [6:3] = 2 */
    UINT32 LlcHitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, E-state, DATA_PRE [6:3] = 4 */
    UINT32 LlcHitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, S-state, DATA_PRE [6:3] = 6 */
    UINT32 LlcHitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* Supplier: LLC/L3, F-state, DATA_PRE [6:3] = 8 */
    UINT32 FarMemLocal : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* Supplier: Far Memory, Local, DATA_PRE [6:3] = 1 */
    UINT32 FarMemRemote0Hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 0-hop, DATA_PRE [6:3]
                               = 3
                            */
    UINT32 FarMemRemote1Hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 1-hop, DATA_PRE [6:3]
                               = 5
                            */
    UINT32 FarMemRemote2PlusHop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Far Memory, Rem 2+ hop, DATA_PRE [6:3]
                               = 7
                            */
    UINT32 NearMemLocal : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* Supplier: Near Memory, Local DATA_PRE [6:3] = E */
    UINT32 NearMemRemote0Hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 0-hop, DATA_PRE [6:3]
                               = B
                            */
    UINT32 NearMemRemote1Hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 1-hop, DATA_PRE [6:3]
                               = D
                            */
    UINT32 NearMemRemote2PlusHop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               Supplier: Near Memory, Rem 2+ hop, DATA_PRE
                               [6:3] = F
                            */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: SPL-hit, DATA_PRE 2:0] = 6 */
    UINT32 SnoopNone : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: None, DATA_PRE 2:0] = 0 */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Not needed, DATA_PRE 2:0] = 1 */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Miss, DATA_PRE 2:0] = 2 */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Hit No Fwd, DATA_PRE 2:0] = 3 */
    UINT32 HitEfWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: Hit EF w/Fwd, DATA_PRE 2:0] = 4 */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: HitM, DATA_PRE 2:0] = 5 */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Snoop Info: HitM, DATA_PRE 2:0] = 5 */
    UINT32 GoErr : 1;

                            /* Bits[38:38], Access Type=RW, default=0x00000000*/

                            /* GO-ERR, RspData[3:0] = 0100 */
    UINT32 GoNoGo : 1;

                            /* Bits[39:39], Access Type=RW, default=0x00000000*/

                            /* GO-NoGO, RspData[3:0] = 0111 */
    UINT32 Reserved40 : 4;

                            /* Bits[43:40], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 UcLoad : 1;

                            /* Bits[44:44], Access Type=RW, default=0x00000000*/

                            /* PRd or UCRdF */
    UINT32 UcStore : 1;

                            /* Bits[45:45], Access Type=RW, default=0x00000000*/

                            /* WiL */
    UINT32 PartialStreamingStores : 1;

                            /* Bits[46:46], Access Type=RW, default=0x00000000*/

                            /* WCiL */
    UINT32 FullStreamingStores : 1;

                            /* Bits[47:47], Access Type=RW, default=0x00000000*/

                            /* WCiLF */
    UINT32 L1ModifiedWb : 1;

                            /* Bits[48:48], Access Type=RW, default=0x00000000*/

                            /* EVICTION EXTTYPE from MEC */
    UINT32 L2ModifiedWb : 1;

                            /* Bits[49:49], Access Type=RW, default=0x00000000*/

                            /* WBMtoI or WBMtoE */
    UINT32 Psmi : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000000*/

                            /* MemPushWr_NS (PSMI only) */
    UINT32 Itom : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /* ItoM */
    UINT32 Reserved52 : 12;

                            /* Bits[63:52], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SLM_CR_OFFCORE_RESP1_REGISTER;

/**
  MSR for thread specific defeature. No functionality on GLM. Only added for compatiblity. Returns 0s on reads, drops writes.
**/
#define JSL_MSR_VIRT_CR_THREAD_SW_DEFEATURE 0x000001A8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 XinitDisable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* When this bit set:READ_XINIT_AS_NON_INIT */
    UINT32 XmodifiedDisable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit set:READ_XMODIFIED_AS_MODIFIED.
                               There is SCP storage for this on GLM, but no
                               functionality
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_THREAD_SW_DEFEATURE_REGISTER;

/**
  Legacy Miscellaneous Power Management Features.
**/
#define JSL_MSR_VIRT_CR_MISC_PWR_MGMT 0x000001AA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SinglePctlEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Single_PCTL:When set (1) will cause PST commands
                               (writes to IA32_PERF_CTL) from any cores to set
                               the P-state target (no coordination). This mean
                               that the last that write the P-state request, is
                               the dominant one. If not set this mean that
                               coordination between all the thread requests
                               will be initiated and the resolved result will
                               dominant. Default = 0 (disabled). Indicates the
                               number of error-reporting banks available on
                               this processor. TNT 1706691677: Remove
                               SINGLE_PCTL_EN support for server. This WRMSR
                               will fault for server if attempted to be set
                            */
    UINT32 Rsvd1 : 5;

                            /* Bits[5:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnableHwp : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit will cause the HWP Base feature
                               bit to report as present; clearing will report
                               as non-present
                            */
    UINT32 EnableHwpInterrupt : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit will cause the HWP Interrupt
                               feature bit to report as present; clearing will
                               report as non-present
                            */
    UINT32 EnableOutOfBandAutonomous : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit will cause the HWP Autonomous
                               feature bit to report as present; clearing will
                               report as non-present.
                            */
    UINT32 Rsvd9 : 3;

                            /* Bits[11:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnableHwpEpp : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit will enable the HWP EPP
                               feature.
                            */
    UINT32 Lock : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               Set this bit will lock this MSR until the next
                               reset
                            */
    UINT32 Rsvd14 : 4;

                            /* Bits[17:14], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PlatPstateControl : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Server only bit, added per Dell request for OEM
                               control of HWP, customers would like SMM
                               control. Legacy (PERF_CTL) and HW P-states need
                               to be hidden from OS in SMM mode
                            */
    UINT32 Rsvd19 : 3;

                            /* Bits[21:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 LockThermInt : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Lock_Therm_Int - Ties thermal interrupts from
                               both cores. If set then thermal interrupt on one
                               core is routed to all cores.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_MISC_PWR_MGMT_REGISTER;

/**
  [p]PUNIT_MSR: In conjunction with FREQ_LIMIT_CORES, this MSR allows an end-user to limit the number of turbo bins
  for different numbers of active cores (cores not in C6).[/p]
  [p]Each field in FREQ_LIMIT_RATIOS specifies a frequency limit for the specified number of active cores
  in the corresponding field in FREQ_LIMIT_CORES.[/p]
  [p]Example: RATIO_LIMIT_0 is 0x20, CORE_COUNT_0 is 0x3; RATIO_LIMIT_1 is 0x16 and CORE_COUNT_1 is 0x5;
  RATIO_LIMIT_3 is 0x10, CORE_COUNT_3 is 0xFF;
  The frequency limit of <=3 active cores is 32, the limit for 4-5 active cores is 22,
  and the limit for 6 or more active cores is 16[/p]
  [p]Ratio limits must monotonically decrease in ascending bin order, core count must monotonically increase in ascending bin order,
  and the last valid FREQ_LIMIT_CORE field must be >= number of potentially active cores (just set to 0xFF)[/p]
  [p]Values of '0' are ignored.[/p]
  [p][b]MSR_Name[/b]: FREQ_LIMIT_RATIOS  [b]MSR_Addr[/b]: 0x1AD[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_FREQ_LIMIT_RATIOS 0x000001AD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RatioLimit0 : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_0
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit1 : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_1
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit2 : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_2
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit3 : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_3
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit4 : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_4
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit5 : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_5
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit6 : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_6
                               in FREQ_LIMIT_CORES.
                            */
    UINT32 RatioLimit7 : 8;

                            /* Bits[63:56], Access Type=RW, default=0x00000000*/

                            /*
                               The frequency limit corresponding to the maximum
                               number of active cores specified in CORE_COUNT_7
                               in FREQ_LIMIT_CORES.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_FREQ_LIMIT_RATIOS_REGISTER;

/**
  [p]PUNIT_MSR: In conjunction with FREQ_LIMIT_RATIOS, this MSR allows an end-user to limit the number of turbo bins
  for different numbers of active cores (cores not in C6).[/p]
  [p]Each field in FREQ_LIMIT_RATIOS specifies a frequency limit for the specified number of active cores
  in the corresponding field in FREQ_LIMIT_CORES.[/p]
  [p]Example: RATIO_LIMIT_0 is 0x20, CORE_COUNT_0 is 0x3; RATIO_LIMIT_1 is 0x16 and CORE_COUNT_1 is 0x5;
  RATIO_LIMIT_3 is 0x10, CORE_COUNT_3 is 0xFF;
  The frequency limit of <=3 active cores is 32, the limit for 4-5 active cores is 22,
  and the limit for 6 or more active cores is 16[/p]
  [p]Ratio limits must monotonically decrease in ascending bin order, core count must monotonically increase in ascending bin order,
  and the last valid FREQ_LIMIT_CORE field must be >= number of potentially active cores (just set to 0xFF)[/p]
  [p]Values of '0' are ignored.[/p]
  [p][b]MSR_Name[/b]: FREQ_LIMIT_CORES  [b]MSR_Addr[/b]: 0x1AE[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_FREQ_LIMIT_CORES 0x000001AE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CoreCount0 : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_0 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount1 : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_1 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount2 : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_2 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount3 : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_3 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount4 : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_4 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount5 : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_5 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount6 : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_6 in FREQ_LIMIT_RATIOS
                            */
    UINT32 CoreCount7 : 8;

                            /* Bits[63:56], Access Type=RW, default=0x00000000*/

                            /*
                               The number of maximum active cores corresponding
                               to the frequency limit specified in
                               RATIO_LIMIT_7 in FREQ_LIMIT_RATIOS
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_FREQ_LIMIT_CORES_REGISTER;

/**
  Not a real register. This define exists to create the MSR routine that will be used to control the energy-efficient P-State performance policy. The bits will be redirected to a corresponding field in THREAD_P_REQ. This MSR will #GP unless POWER_CTL[PWR_PERF_PLTFRM_OVR] is set.
**/
#define JSL_MSR_UCODE_CR_ENERGY_PERFORMANCE_BIAS 0x000001B0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnergyPolicy : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               If enabled via POWER_CTL, overrides the energy-
                               efficient P-State performance policy field in
                               THREAD_P_REQ
                            */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_ENERGY_PERFORMANCE_BIAS_REGISTER;

/**
  [p]PUNIT_MSR: Package level thermal and power status register.  This register is typically used to inspect the thermal status of the entire package, as well as to discover the sources of package level thermal interrupt events.[/p]
  [p][b]MSR_Name[/b]: THERM_STATUS  [b]MSR_Addr[/b]: 0x19C[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_STATUS 0x000001B1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ThermalMonitorStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               This bit indicates that the Thermal Monitor has
                               tripped and is currently thermally throttling at
                               least one domain in the package. If software has
                               programmed a thermal monitor control temperature
                               below the manufacturing default of this
                               processor, this flag will assert when the
                               software programmed constraint has been
                               exceeded.
                            */
    UINT32 ThermalMonitorLog : 1;

                            /* Bits[1:1], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the package has
                               seen a rising edge on the Thermal Monitor Status
                               bit since the last time this bit was cleared by
                               software.
                            */
    UINT32 ProchotStatus : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Status bit indicating that the external PROCHOT#
                               pin is currently being asserted. This will only
                               assert when the processor is configured in Bi-
                               directional PROCHOT# mode (when PROCHOT# is
                               configured as an input)
                            */
    UINT32 ProchotLog : 1;

                            /* Bits[3:3], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that the PROCHOT#
                               status bit has asserted or deasserted since the
                               last time this bit was cleared by software.
                            */
    UINT32 OutOfSpecStatus : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /*
                               When set, this event indicates that the
                               processor has observed a critical thermal
                               excursion. It is intended as an early warning of
                               thermal runaway in the silicon and shutdown is
                               recommended.
                            */
    UINT32 OutOfSpecLog : 1;

                            /* Bits[5:5], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit indicating that a Critical
                               Thermal Event was detected since the last time
                               this bit was cleared by software.
                            */
    UINT32 Threshold1Status : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /*
                               [p]Indicates whether the actual temperature is
                               currently higher than or equal to the value set
                               in Thermal Threshold 1.[/p] [list] [*] 0 =
                               Current temperature is below threshold 1 [*] 1 =
                               Current temperature at or above threshold 1
                               [/list]
                            */
    UINT32 Threshold1Log : 1;

                            /* Bits[7:7], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising or
                               falling edge of the thermal threshold 1 status
                               indicator. This flag remains asserted until
                               software clears it
                            */
    UINT32 Threshold2Status : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /*
                               [p]Indicates whether the actual temperature is
                               currently higher than or equal to the value set
                               in Thermal Threshold 2.[/p] [list] [*] 0 =
                               Current temperature is below threshold 2 [*] 1 =
                               Current temperature at or above threshold 2
                               [/list]
                            */
    UINT32 Threshold2Log : 1;

                            /* Bits[9:9], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising or
                               falling edge of the thermal threshold 2 status
                               indicator. This flag remains asserted until
                               software clears it
                            */
    UINT32 PowerLimitationStatus : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /*
                               The power limit status flag asserts at any time
                               that the domain is performance limited due to
                               power constraints. Performance limitation due to
                               power limits is measured as observing the
                               resolved domain level frequency below the
                               software requested frequency, even within the
                               Turbo operating region. The RAPL PL1 and PL2
                               power limits are the only sources of this power
                               constraint.
                            */
    UINT32 PowerLimitationLog : 1;

                            /* Bits[11:11], Access Type=RW_0C, default=0x00000000*/

                            /*
                               Sticky log bit that asserts on a rising edge of
                               the Power Limitation Status indicator. This flag
                               remains asserted until software clears it
                            */
    UINT32 PmaxStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /*  */
    UINT32 PmaxLog : 1;

                            /* Bits[13:13], Access Type=RW_0C_FW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd14 : 2;

                            /* Bits[15:14], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Temperature : 7;

                            /* Bits[22:16], Access Type=RO, default=0x00000000*/

                            /*
                               Current maximum temperature across all sensors
                               in the package, reported as a negative offset
                               from the reference maximum junction temperature.
                               E.g., a reading of 10 with a reference
                               temperature of 90'C implies this domain is
                               currently operating at 80'C. The reference
                               temperature may be discovered in
                               TEMPERATURE_TARGET.REF_TEMP
                            */
    UINT32 Reserved23 : 3;

                            /* Bits[25:23], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 HwFeedbackNotificationLog : 1;

                            /* Bits[26:26], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Sticky bit that indicates whether a HW Feedback
                               change has occurred (e.g. due to power/thermal
                               limits) since the last clearing of this bit or
                               reset. Software may clear this bit by writing a
                               zero (0).
                            */
    UINT32 Resolution : 4;

                            /* Bits[30:27], Access Type=RO, default=0x00000001*/

                            /*
                               Supported resolution in degrees Celsius.
                               Hardcoded to 1'C.
                            */
    UINT32 Valid : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               Valid flag indicating the validity of the
                               current temperature readout. [list] [*] 0 =
                               Invalid [*] 1 = Valid [/list]
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_STATUS_REGISTER;

/**
  [p]PUNIT_MSR: Package thermal interrupt control register.  This register is used to configure package level notifications of important thermal events.
  These interrupts are routed directly to core APIC Thermal LVT's and are handled locally by the core that has unmasked the LVT.[/p]
  [p][b]MSR_Name[/b]: THERM_INTERRUPT  [b]MSR_Addr[/b]: 0x19B[/p]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_INTERRUPT 0x000001B2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HighTempIntEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable the
                               generation of an interrupt on the transition
                               from a temperature below the thermal monitor
                               activation temperature to a temperature equal to
                               or greater than it. This interrupt will be sent
                               on any rising edge of the Thermal Monitor Status
                               bit of this virtual maximum temperature.
                            */
    UINT32 LowTempIntEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable the
                               generation of an interrupt on the transition
                               from a temperature above or equal to the thermal
                               monitor activation temperature to a temperature
                               below it. This interrupt will be sent on any
                               falling edge of the Thermal Monitor Status bit
                               of the virtual maximum package temperature.
                            */
    UINT32 ProchotIntEnable : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable a thermal
                               interrupt delivery upon detection of PROCHOT#
                               input assertion or deassertion event.
                            */
    UINT32 PmaxIntEnable : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Pmax Int Enable */
    UINT32 OutOfSpecIntEnable : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               This bit allows software to enable thermal
                               interrupt delivery upon observation that the
                               processor is operating out of its thermal
                               specification. This interrupt is designed as an
                               early warning of thermal runaway in the silicon
                               and shutdown is recommended.
                            */
    UINT32 Reserved5 : 3;

                            /* Bits[7:5], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Threshold1RelTemp : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies temperature Threshold 1 value as as a
                               negative offset from the reference maximum
                               junction temperature (defined in
                               TEMPERATURE_TARGET.REF_TEMP). This temperature
                               threshold is compared against the corresponding
                               Thermal Status Relative Temperature reading for
                               the virtual maximum package temperature.
                            */
    UINT32 Threshold1IntEnable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Threshold 1 Interrupt Enable is used to enable
                               thermal interrupt notifcation to software upon
                               any rising or falling detection of the virtual
                               package max temperature crossing the Threshold 1
                               temperature.
                            */
    UINT32 Threshold2RelTemp : 7;

                            /* Bits[22:16], Access Type=RW, default=0x00000000*/

                            /*
                               Specifies temperature Threshold 2 value as as a
                               negative offset from the reference maximum
                               junction temperature (defined in
                               TEMPERATURE_TARGET.REF_TEMP). This temperature
                               threshold is compared against the corresponding
                               Thermal Status Relative Temperature reading for
                               the virtual maximum package temperature.
                            */
    UINT32 Threshold2IntEnable : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Threshold 2 Interrupt Enable is used to enable
                               thermal interrupt notifcation to software upon
                               any rising or falling detection of the virtual
                               package max temperature crossing the Threshold 2
                               temperature.
                            */
    UINT32 PowerIntEnable : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set a thermal interrupt will be
                               sent upon detection of a rising edge assertion
                               of the Power Limit Status bit in the Package
                               Thermal and Power Status register.
                            */
    UINT32 HwFeedbackNotificationEnable : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Enables the gneration of an interrupt when a HW
                               Feedack change occurs (e.g. due to thermal/power
                               limits).
                            */
    UINT32 Reserved26 : 6;

                            /* Bits[31:26], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_THERM_INTERRUPT_REGISTER;

/**
  TNT 1305422551: Current Logical Processor PM Meta Data and CTC data
**/
#define JSL_MSR_IA32_CR_HW_GET_LP_PM_META_DATA 0x000001C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LpId : 7;

                            /* Bits[6:0], Access Type=RO, default=0x00000000*/

                            /* Logical processor reset value */
    UINT32 Rsvd7 : 25;

                            /* Bits[31:7], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 AbsoluteTimeUponRead : 24;

                            /* Bits[55:32], Access Type=RO, default=0x00000000*/

                            /*
                               Based on the CTC counter in ~100 usec. (CTC /
                               2^8) granularity (wraparound every 27minutes)
                            */
    UINT32 Rsvd56 : 8;

                            /* Bits[63:56], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_HW_GET_LP_PM_META_DATA_REGISTER;

/**

**/
#define JSL_MSR_CORE_INTERFACE_CR_IA32_HW_SET_LP_PM_META_DATA 0x000001C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SetPmMetaData0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Deliver the LP PM Meta Data into the H/W. OS
                               reads previously saved logical processor LP PM
                               Meta Data and communicates it to the Processor,
                               default value 0
                            */
    UINT32 SetPmMetaData1 : 24;

                            /* Bits[55:32], Access Type=RW, default=0x00000000*/

                            /*
                               Deliver the LP PM Meta Data into the H/W. OS
                               reads previously saved logical processor LP PM
                               Meta Data and communicates it to the Processor,
                               default value 0
                            */
    UINT32 OsScenario : 4;

                            /* Bits[59:56], Access Type=RW, default=0x00000000*/

                            /*
                               Read/Write, Reset=0, Migration= 1, Event
                               Signaling=2. OS hint to the H/W about the OS
                               Scenario where the LP PM Meta Data was sampled
                            */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_IA32_HW_SET_LP_PM_META_DATA_REGISTER;

/**
  Not a real register. This define exists to create the MSR routine that will be used to return the status of debug resources. These bits used to exist in MISC_ENABLES but they were moved to this new MSR (CART: 7/13/06:NHM i355197).
**/
#define JSL_MSR_SLM_CR_DEBUG_RESOURCE_STATUS 0x000001C6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DebugDrxAvailable : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /*
                               RTL wires inverted
                               ICECTLPMR[PRESERVE_DEBUG_RESOURCES] here.
                            */
    UINT32 DebugAvailable : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000001*/

                            /*
                               RTL wires inverted
                               ICECTLPMR[PRESERVE_LBR_RESOURCES] here.
                            */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SLM_CR_DEBUG_RESOURCE_STATUS_REGISTER;

/**
  LBR filter configuration
**/
#define JSL_MSR_ARR_CR_LBR_FILTER_SELECT 0x000001C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CplEq0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT RING 0 BRANCHES */
    UINT32 CplNeq0 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT NON-RING 0 BRANCHES */
    UINT32 Jcc : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT TAKEN CONDITIONAL BRANCHES */
    UINT32 NearRelCall : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT NEAR RELATIVE CALLS */
    UINT32 NearIndirectCall : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT NEAR INDIRECT CALLS */
    UINT32 NearRet : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT NEAR RETURNS */
    UINT32 NearIndirectJmp : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               FILTER OUT UNCONDITIONAL NEAR INDIRECT JUMPS NOT
                               INCLUDING CALLS AND RETURNS
                            */
    UINT32 NearRelJmp : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               FILTER OUT UNCONDITIONAL NEAR RELATIVE JUMPS NOT
                               INCLUDING CALLS AND RETURNS
                            */
    UINT32 FarBranch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* FILTER OUT FAR BRANCHES */
    UINT32 LbrCallStackEn : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* Enable LBR call stack */
    UINT32 Reserved10 : 22;

                            /* Bits[31:10], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_LBR_FILTER_SELECT_REGISTER;

/**
  "Contains a 5-bit pointer (0 ... 31) to the MSR in the LBR stack that contains the most recent branch, interrupt, or exception recorded.  Prior to placing a new branch record on the stack, the TOS is incremented by 1. When the TOS pointer reaches 31, it wraps around to 0."
**/
#define JSL_MSR_ARR_CR_LBR_TOS 0x000001C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TosPointer : 5;

                            /* Bits[4:0], Access Type=RW, default=0x00000000*/

                            /* Reset ucode clears the TOS */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_LBR_TOS_REGISTER;

/**
  Register used to enable various documented and undocumented debug features. See PPro Developer-s Manual, Vol. 3 for more information on the public features. .
**/
#define JSL_MSR_BNL_CR_DEBUGCTLMSR 0x000001D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lbr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               When set, this bit enables last branch
                               recording.
                            */
    UINT32 Btf : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set, taken branch traps are
                               enabled. This will cause a debug exception to be
                               posted when a taken branch occurs while TF is
                               set. It must be cleared by microcode prior to
                               signaling a Debug Exception.
                            */
    UINT32 ReservedUsedToBePb2 : 4;

                            /* Bits[5:2], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               When these bits are zero, the performance
                               monitoring/breakpoint pins are configured to
                               report performance events. When PBi is 1 and all
                               of the local and global enable bits in DR7 are
                               0, breakpoint matches to debug register DRi are
                               reported by asserting the corresponding
                               performance monitoring/breakpoint pin for one
                               bus clock.
                            */
    UINT32 Tr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               When set, this bit enables branch trace
                               messages.
                            */
    UINT32 Bts : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               When set, enables the Branch Trace Store
                               facilities to log BTMs to a memory resident BTS
                               buffer that is part of the DS save area.
                            */
    UINT32 Btint : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               Branch Trace Interrupt. When set, the BTS
                               facilities generate an interrupt when the BTS
                               buffer is full. When clear, BTMs are logged to
                               the BTS buffer in a circular fashion.
                            */
    UINT32 BtsOffOs : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               When set, BTM(special bus cycle) or BTS(storing
                               record to memory) will be skipped if CPL==0
                            */
    UINT32 BtsOffUsr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               When set, BTM(special bus cycle) or BTS(storing
                               record to memory) will be skipped if CPL)0
                               (CPL==1,2,3)
                            */
    UINT32 FreezeLbrsOnPmi : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* WHEN SET THE LBRS ARE FROZEN ON A PMI */
    UINT32 FreezePerfmonOnPmi : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               WHEN SET THE PERFMON COUNTERS ARE FROZEN ON A
                               PMI IA32 CR PERF GLOBAL CTRL LH ARE CLEARED
                            */
    UINT32 EnablePmiFromUncore : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               Dummy flop: Added to TNT for SNC Hetero
                               compatiblity. On SNC, setting this bit enables a
                               PMI for this thread the Uncore signals a PMI.
                               For PERFMON
                            */
    UINT32 FreezeWhileSmmEn : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               WHEN SET THE PERFMON COUNTERS ARE FROZEN UPON
                               ENTERING SMM, THEN UNFROZEN ON EXIT
                            */
    UINT32 Reserved15 : 17;

                            /* Bits[31:15], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_DEBUGCTLMSR_REGISTER;

/**
  VIRTUAL_MSR_NOT_SCP -  Indirect access to LBR_TOS - 'TO' address - Register which contains the destination address of the last branch taken. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_X86_CR_TOS_LBR_INFO 0x000001DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RO, default=0x00000000*/

                            /* cycles elapsed since last LBR update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mispredict : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /* branch misprediction indication */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_TOS_LBR_INFO_REGISTER;
/**
  VIRTUAL_MSR_NOT_SCP - Indirect access to LBR_TOS - 'FROM' address - Register which contains the source address of the last branch taken. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_X86_CR_TOS_LBR_FROM_LIP 0x000001DB
/**
  VIRTUAL_MSR_NOT_SCP -  Indirect access to LBR_TOS - 'TO' address - Register which contains the destination address of the last branch taken. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_X86_CR_TOS_LBR_TO_LIP 0x000001DC

/**
  Register which contains the source address of the last branch taken prior to an exception or interrupt being generated. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_SCP_CR_LER_FROM_LIP 0x000001DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Used to store FROM_LER */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* Used to store FROM_LER */
    UINT32 LipExt : 15;

                            /* Bits[62:48], Access Type=RW, default=0x00000000*/

                            /*
                               Sign extended bits of LIP for RDMSR/WRMSR.
                               Emulated by ucode. No actual flops.
                            */
    UINT32 Mispredict : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_LER_FROM_LIP_REGISTER;

/**
  Register which contains the destination address of the last branch taken prior to an exception or interrupt being generated. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_SCP_CR_LER_TO_LIP 0x000001DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Used to store FROM_LER */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* Used to store FROM_LER */
    UINT32 Time : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_LER_TO_LIP_REGISTER;

/**
  Register which contains control and status bits related to probe mode. This register is only accessible when the Processor is in probe mode. micro-code uses this register to communicate with the probe mode software.
**/
#define JSL_MSR_BNL_CR_ICECTLPMR 0x000001DF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ir : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor enters probe mode when a
                               debug exception (except INT1 as per PNW
                               i1064232/e696026) is detected prior to
                               performing the exception handler call. This bit
                               is maintained by probe mode software.
                            */
    UINT32 Reserved1 : 1;

                            /* Bits[1:1], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Pmen : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Probe Mode Enable - The Processor uses this bit
                               to enter Probe Mode and stay in Probe Mode. The
                               TAP sets this bit when it samples the PREQ#
                               signal active or on the ENTERPM (PROBEMODE=11)
                               command and resets it on the EXITPM
                               (PROBEMODE=00) command.
                            */
    UINT32 Pir : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               When set, this bit indicates that the TAP has
                               received a probe mode instruction i.e. after a
                               WrSubPIR command is executed by the TAP. Once
                               set, probe mode microcode can enable the FEC to
                               issue the instruction.
                            */
    UINT32 Pmis : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicating that a macroinstruction executed
                               in probe mode terminated with an exception.
                               Probe mode software is responsible for clearing
                               this bit.
                            */
    UINT32 Mce : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               Bit set by Machine Check microcode to indicate
                               that a machine check exception caused entry or
                               reentry into probe mode.
                            */
    UINT32 PmRedirect : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               Bit set by PM microcode in case of redirection
                               to PM. If clear, no redirection happened. If
                               set, this core redirected. NOTE THAT in SLT,
                               setting this bit would caused TAP to pend probe
                               mode init event; in SLM, we kept the behavior
                               even if not needed. TAP will not clear this pm
                               PM exit like SLT but PM exit uCode will clear it
                               (e3429723).
                            */
    UINT32 ReservedHess7 : 1;

                            /* Bits[7:7], Access Type=Rsvd0, default=0x00000000*/

                            /* INFO_MOVED_TO_PRIOR_STATES_MSR */
    UINT32 Init : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               When set, INIT microcode must enter probe mode
                               after initializing all required state but before
                               branching to the reset vector. This bit is
                               maintained by probe mode software.
                            */
    UINT32 Mcen : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               When set, machine check exceptions are
                               redirected to probe mode after performing some
                               microarchitecture state cleanup actions, but
                               before the exception handler call occurs. The
                               cleanup actions which must be performed include
                               all steps taken prior to the machine check
                               exception handler call. This bit is maintained
                               by probe mode software.
                            */
    UINT32 Smen : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor enters probe mode after
                               completing an SMI handler call. This bit is
                               maintained by probe mode software.
                            */
    UINT32 Smex : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               When set, the processor enters probe mode after
                               completing an RSM . This bit is maintained by
                               probe mode software.
                            */
    UINT32 Reserved12 : 1;

                            /* Bits[12:12], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 PreserveRtitResources : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               ITP sets this bit to prevent other software from
                               touching the RTIT resources - When this bit is
                               set, Writes to RTIT_MSRs are dropped, Reads of
                               RTIT MSRs are unimpacted, CPUID indication of
                               RTIT support is cleared, VMCS-based RTIT control
                               bits are overridden. See RTIT HAS/EAS for more
                               details
                            */
    UINT32 PreserveDebugResources : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               ITP sets this bit to prevent other software from
                               touching the debug resources including
                               (R)EFLAGS, DRx, pending debug exceptions, etc.
                               See LT probe mode POR for details.
                            */
    UINT32 PreserveLbrResources : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               ITP sets this bit to prevent other software from
                               touching the LBR resources including LBR MSRs,
                               LER MSRs and TOS. See LT probe mode POR for
                               details. Setting this bits disables RT ULBRs.
                               The 4 ULBRs are merged together with the 4 SLBRs
                               to create a unified 8entry SLBR stack (Merom)
                            */
    UINT32 ReservedUsedToBeRemainProbemodeInBnl16 : 1;

                            /* Bits[16:16], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved in Silvermont as we don't have
                               threading. BNL behavior:Probe Mode Software sets
                               this bit ('1) to request this thread to remain
                               in Probe Mode. Probe Mode exit flow checks this
                               bit immediately before making jumps based on the
                               prior_state. If this bit is set ('1), the probe
                               mode exit flow jumps to the preq flow so that
                               this thread remains in probe mode. If this bit
                               is not set ('0), the probe mode exit flow would
                               branch to various places as normal.
                            */
    UINT32 Rsvd17 : 4;

                            /* Bits[20:17], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 EnclaveInterruption : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               Enclave was interrupted to enter probe mode -
                               processor state is synthetic
                            */
    UINT32 Rsvd22 : 10;

                            /* Bits[31:22], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 Cc1EntryRedirectionControl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Cc2EntryRedirectionControl : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Cc3EntryRedirectionControl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Cc4EntryRedirectionControl : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Cc5EntryRedirectionControl : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Cc6EntryRedirectionControl : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved38 : 2;

                            /* Bits[39:38], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare : 1;

                            /* Bits[40:40], Access Type=RW, default=0x00000000*/

                            /*
                               SLM doesn't support Probe Mode redirection in
                               the middle of C6 restore, but we leave this bit
                               as a spare.
                            */
    UINT32 Getsec : 1;

                            /* Bits[41:41], Access Type=RW, default=0x00000000*/

                            /* Redirect to probe mode at the start of GETSEC */
    UINT32 PreCram : 1;

                            /* Bits[42:42], Access Type=RW, default=0x00000000*/

                            /*
                               Redirect to probe mode just before loading LT
                               CRAM
                            */
    UINT32 AcmodeEnter : 1;

                            /* Bits[43:43], Access Type=RW, default=0x00000000*/

                            /*
                               Redirect to probe mode just before launching an
                               AC-module
                            */
    UINT32 AcmodeExit : 1;

                            /* Bits[44:44], Access Type=RW, default=0x00000000*/

                            /*
                               Redirect to probe mode after exiting an AC-
                               module (end of EXITAC)
                            */
    UINT32 SexitEnd : 1;

                            /* Bits[45:45], Access Type=RW, default=0x00000000*/

                            /* Redirect to probe mode at the end of SEXIT */
    UINT32 EncluRedirectionControl : 1;

                            /* Bits[46:46], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set, ENCLU will redirect to
                               probe mode
                            */
    UINT32 Reserved47 : 7;

                            /* Bits[53:47], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Int1PmRedirectionControl : 1;

                            /* Bits[54:54], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set, then INT1 instruction will
                               redirect to probe mode prior to performing the
                               exception handler call. This bit is maintained
                               by probe mode software.. Until we implemented
                               PNW i1064232/e696026, bit 0 of this
                            */
    UINT32 StepIntoExcepInterRedirectionControl : 1;

                            /* Bits[55:55], Access Type=RW, default=0x00000000*/

                            /*
                               WHen this bit is set and ICECTLPMR.IR is set,
                               then in the exception handler, do not clear
                               EFLAGS.TF. So this give ITP to single-Step into
                               Interrupts and Exceptions (For SNB i366110)
                            */
    UINT32 ShutdownRedirectionControl : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /* SHUTDOWN redirection control */
    UINT32 VmclearRedirectionControl : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /* enabled through a microcode Patch */
    UINT32 VmexitRedirectionControl : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /*
                               VMEXIT redirection control (together with
                               SCP_CR_PROBE_MODE_4 53 bits)
                            */
    UINT32 Rsvd59 : 2;

                            /* Bits[60:59], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 StmServiceCallRedirectionControl : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 OsvVerticalVmentryRedirectionControl : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 VmlaunchRedirectionControl : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_ICECTLPMR_REGISTER;

/**
  VIRTUAL_MSR_NOT_SCP -  Indirect access to LBR_TOS - 'TO' address - Register which contains the destination address of the last branch taken. The address saved is the offset in the code segment of the branch source instruction.
**/
#define JSL_MSR_X86_CR_LER_INFO 0x000001E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* cycles elapsed since last LBR update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mispredict : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* branch misprediction indication */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_LER_INFO_REGISTER;

/**
  This RO MSR will be used to report the fuse_cpu_type bits from PCU Package Config CSR
**/
#define JSL_MSR_VIRT_CR_CPU_TYPE 0x000001E1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FuseCpuType : 4;

                            /* Bits[3:0], Access Type=RO, default=0x00000000*/

                            /* CPU Type Indication */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_CPU_TYPE_REGISTER;

/**
  GLM i1958673:Microserver MCA Enhancements. This register contains controls to enable/disable both the MB bank write capability and the MCA/CMCI signaling capability. Note that the scope and position of the bits is changed from GLP on TNT to match Core.
**/
#define JSL_MSR_FUNNYIO_CR_DEBUG_ERR_INJ_CTL 0x000001E3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McbwE : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Machine check bank write capability enable flag.
                               If this bit is set, non-zero value writes to any
                               implemented MCi_STATUS, MCi_ADDR, and MCi_MISC
                               register is allowed from both SMM and ring 0. If
                               this bit is clear, normal MC Bank access rules
                               apply (non-zero writes to these registers cause
                               #GP)
                            */
    UINT32 McaCmciSe : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               MCA/CMCI signaling enable flag. If this bit is
                               set, MCA/CMCI signaling through
                               DEBUG_ERR_INJ_CTL2 is enabled
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_DEBUG_ERR_INJ_CTL_REGISTER;

/**
  GLM i1958673:Microserver MCA Enhancements. This write-only register allows generating an MCA or CMCI from ring 0 software. It can be written only if DEBUG_ERR_INJ_CTL.MCA_CMCI_SE is set. TNT: Change bit positions to match SNX, and use uncore broadcast for CMCI
**/
#define JSL_MSR_VIRT_CR_DEBUG_ERR_INJ_CTL2 0x000001E4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McaG : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               Generate MCA. Setting this bit will cause MCA to
                               be broadcast to all threads in the system
                            */
    UINT32 CmciG : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               Generate CMCI. Setting this bit causes a CMCI to
                               be generated on all cores on the module where
                               this MSR is written
                            */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_DEBUG_ERR_INJ_CTL2_REGISTER;

/**
  Will be changed to full module scope for SLT CMP. This was mixed scope on Penryn
**/
#define JSL_MSR_PIC_CR_DEBUG_MODES 0x000001E6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnableC2uLlb : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               when this bit is set its enable sending C2U
                               LLB.(Defeature-DFD)
                            */
    UINT32 U2cLlbAsSmcNuke : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /*
                               when this bit is set, will signal SMC nuke on
                               receiving U2C LLB
                            */
    UINT32 ThrottleU2cReq : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000001*/

                            /*
                               (PSMI Chicken bit) enable Throttling of U2C req
                               to avoid TBF overflow
                            */
    UINT32 PicReqOff : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* DISABLE_NEW_PICOMB_REQUESTS_TO_THE_EBC */
    UINT32 Spare4 : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000001*/

                            /* SPARE */
    UINT32 IcrMsgOff : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 EoiSuppressCb : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 EoiNoBdcstEnable : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 DisableIntpriupdGeneration : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* >Disables TPR/IntPriUpd from being generated */
    UINT32 SvGlobalEnable : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               enables PATCH2 and PATCH3 special instructions
                               in Unlocked units only.
                            */
    UINT32 SvSenterEn : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               enables saving of internal data to SCPs during
                               SENTER (DFT DCN#15)
                            */
    UINT32 TscDeadlineCb : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* CB for TSC Deadline */
    UINT32 IdIsNotReadonly : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               when set to '1 enables SW to write to ID
                               register in APIC.
                            */
    UINT32 Available13 : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               TNT b2206264256: Use this bit to propage ECC
                               logic check result to end of BIST flow (reset
                               ucode) so that it can be copied in RAX in all
                               core in the module
                            */
    UINT32 L2CmciInternal : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               Setting this bit will not send the L2 CMCI event
                               to Tunit and complete internally instead.
                            */
    UINT32 CmciFeatureDisable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* Setting this bit will disable the CMCI LVT */
    UINT32 PeriodicSmcEn : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Enables Periodic SMC Nukes if set */
    UINT32 PeriodicSmcTscSel : 2;

                            /* Bits[18:17], Access Type=RW, default=0x00000000*/

                            /*
                               Selects Bit of TSC for Periodic SMC Nuke.
                               00:TSC[20]:1ms, 00:TSC[20]:1ms, 01:TSC[23]:10ms,
                               10:TSC[27]:100ms, 11:TSC[30]:1s
                            */
    UINT32 WatchdogSmcOtherNow : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               On ROB Timeout Cnt 011 to 100, SMC Nuke other
                               core now
                            */
    UINT32 WatchdogSmcOtherWait : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               On ROB Timeout Cnt 011 to 100, SMC Nuke other
                               core on TSC[8] Toggle
                            */
    UINT32 WatchdogSmcSameNow : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               On ROB Timeout Cnt 011 to 100, SMC Nuke same
                               core now
                            */
    UINT32 WatchdogSmcSameWait : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               On ROB Timeout Cnt 011 to 100, SMC Nuke same
                               core on TSC[8] Toggle
                            */
    UINT32 WatchdogSmcOtherRepeated : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               On ROB Timeout[2] = 1, SMC Nuke other core
                               continuously
                            */
    UINT32 PsmiAssist : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Prevents certain registers from changing and
                               prevents side-effects for PSMI Modes
                            */
    UINT32 DisableAsyncMcerr : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* Disable Asynchronous MCERR from being signalled */
    UINT32 DisableAsyncMckind : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* Disable Asynchronous MCKind from being signalled */
    UINT32 WatchdogQuick : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /*
                               Change all the above WATCHDOG settingto be on
                               ROB Timeout[1] instead of ROB Timeout[2], cut
                               timeout times in half to give a warning early to
                               the other core
                            */
    UINT32 WatchdogIgnoreBusqempty : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* Masks out bus queue empty from smc nuke logic */
    UINT32 Spare29 : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               Temp using this to Zero out bit 7 of Core Return
                               Id to make IntLog/IntPhy addr[39] rsvd0
                            */
    UINT32 DisableCtcDlSync : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               CB to disable CTC sync with URT using the sync
                               (Q) bit
                            */
    UINT32 SelfIpiOff : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               CB to disable the Self IPI feature and revert
                               Self IPI interrupt behavior
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_DEBUG_MODES_REGISTER;

/**
  Read only VLW capability MSR that reports information about the VLW messages that are supported. Added on GLM to match Core. NHM added this as part of the CSI spec
**/
#define JSL_MSR_UCODE_CR_VLW_CAPABILITY 0x000001F0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ignne : 1;

                            /* Bits[0:0], Access Type=Rsvd0, default=None*/

                            /* 0 since IGNNE VLW message is not supported */
    UINT32 A20m : 1;

                            /* Bits[1:1], Access Type=Rsvd0, default=None*/

                            /* 0 since A20M message is not supported */
    UINT32 Intr : 1;

                            /* Bits[2:2], Access Type=Rsvd1, default=0x00000001*/

                            /* 1 means INTR message is supported */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=Rsvd1, default=0x00000001*/

                            /*
                               1 means SMI message is supported. No SMM fuse on
                               TNT, so always 1
                            */
    UINT32 Init : 1;

                            /* Bits[5:5], Access Type=Rsvd1, default=0x00000001*/

                            /* 1 means INIT message is supported */
    UINT32 Nmi : 1;

                            /* Bits[6:6], Access Type=Rsvd1, default=0x00000001*/

                            /* 1 means NMI message is supported */
    UINT32 Rsvd7 : 1;

                            /* Bits[7:7], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_VLW_CAPABILITY_REGISTER;

/**
  Virtual MSR to will write data to an Crash Log configuration
**/
#define JSL_MSR_UCODE_CR_CRASHLOG_CONTROL 0x000001F1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Cddis : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               CrashDump_Disable - If set, indicates that Crash
                               Dump is disabled. Default value will come from
                               the CORE_CRASHLOG_DIS fuse.
                            */
    UINT32 CdCollectGprs : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               CrashDump_Collect_GPRs - If set, opts into
                               collecting the GPRs on a crashdump. Only
                               meaninful when CDDIS is zero.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_CRASHLOG_CONTROL_REGISTER;

/**
  SMM Range Register - Physical Base. Used to protect the System Management Mode code set up by the BIOS from attack by CPL 0 code (like OS). See Silvermont xT HAS SMRR doc. This MSR has restrictions on when it can be accessed. This MSR is discussed in the SDM
**/
#define JSL_MSR_IA32_CR_SMRR_PHYSBASE 0x000001F2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* SMRR memory type */
    UINT32 Reserved3 : 8;

                            /* Bits[10:3], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Not loaded into DTLB -
                               fractured into 4k pages and loaded into the
                               UTLB. Hence there is no need for the INC bit
                               (like the legacy MTRRs).
                            */
    UINT32 BaseField : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* SMRR Base address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_SMRR_PHYSBASE_REGISTER;

/**
  SMM Range Register - Physical Mask. Used to protect the System Management Mode code set up by the BIOS from attack by CPL 0 code (like OS). See Silvermont xT HAS SMRR doc. This MSR has restrictions on when it can be accessed. This MSR is discussed in the SDM
**/
#define JSL_MSR_IA32_CR_SMRR_PHYSMASK 0x000001F3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 10;

                            /* Bits[9:0], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved bits. */
    UINT32 Lock : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               SMRR Lock. GLP 1706546663. No RTL usage of the
                               lock bit - just a flop
                            */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               SMRR Valid - This bit serves as the valid bit
                               for SMRR
                            */
    UINT32 MaskField : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* SMRR Address Mask */
    UINT32 MaskExt : 10;

                            /* Bits[41:32], Access Type=RO, default=0x000003FF*/

                            /*
                               Implied 1s above the 32nd bit. Ignored on
                               writes. WRMSR will continue to #GP. Returning
                               the implied 1s on reads (and ignoring on writes)
                               simplifies some ucode/CTEs
                            */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_SMRR_PHYSMASK_REGISTER;

/**
  PRotected Memory Range Register - Physical Mask
**/
#define JSL_MSR_PMH_CR_PRMRR_MASK 0x000001F5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 10;

                            /* Bits[9:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Lock - This bit prevents software from
                               modifying the PRMRR
                            */
    UINT32 Vld : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Valid - This bit serves as the enable for
                               the PRMRR - the PRMRR must be LOCKed before it
                               can be enabled. This bit is not MSR writeable
                               even for XuCode any more.
                            */
    UINT32 Reserved12 : 8;

                            /* Bits[19:12], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               This is actually part of the MASK, but is
                               required to be 0 on Goldmont
                            */
    UINT32 Mask0 : 12;

                            /* Bits[31:20], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Address Mask - the mask is actually 39:12,
                               but Goldmontmont requires the base 1MB aligned
                               (i.e. 19:12 == 0). Moreover the MASK should be
                               specified such that the protected region grows
                               by power-of-two multiples of 1MB
                            */
    UINT32 Mask1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Address Mask - the mask is actually 39:12,
                               but Goldmontmont requires the base 1MB aligned
                               (i.e. 19:12 == 0). Moreover the MASK should be
                               specified such that the protected region grows
                               by power-of-two multiples of 1MB
                            */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PMH_CR_PRMRR_MASK_REGISTER;

/**
  SMM Range Register - Physical Base. Used to protect the System Management Mode code set up by the BIOS from attack by CPL 0 code (like OS). See Silvermont xT HAS SMRR doc. This MSR has restrictions on when it can be accessed. This MSR is discussed in the SDM
**/
#define JSL_MSR_IA32_CR_SMRR2_PHYSBASE 0x000001F6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* SMRR2 memory type */
    UINT32 Reserved3 : 8;

                            /* Bits[10:3], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Not loaded into DTLB -
                               fractured into 4k pages and loaded into the
                               UTLB. Hence there is no need for the INC bit
                               (like the legacy MTRRs).
                            */
    UINT32 Smrr2Base : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* SMRR2 Base address */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_SMRR2_PHYSBASE_REGISTER;

/**
  SMM Range Register - Physical Mask. Used to protect the System Management Mode code set up by the BIOS from attack by CPL 0 code (like OS). See Silvermont xT HAS SMRR2 doc. This MSR has restrictions on when it can be accessed. This MSR is discussed in the SDM
**/
#define JSL_MSR_IA32_CR_SMRR2_PHYSMASK 0x000001F7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 10;

                            /* Bits[9:0], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved bits. */
    UINT32 Lock : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               SMRR Lock. GLP 1706546663. No RTL usage of the
                               lock bit - just a flop
                            */
    UINT32 Valid : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               SMRR2 Valid - This bit serves as the valid bit
                               for SMRR2
                            */
    UINT32 Smrr2Mask : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* SMRR2 Address Mask */
    UINT32 MaskExt : 10;

                            /* Bits[41:32], Access Type=RO, default=0x000003FF*/

                            /*
                               Implied 1s above the 32nd bit. Ignored on
                               writes. WRMSR will continue to #GP. Returning
                               the implied 1s on reads (and ignoring on writes)
                               simplifies some ucode/CTEs
                            */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_SMRR2_PHYSMASK_REGISTER;

/**
  Valid PRMRR configurations
**/
#define JSL_MSR_UCODE_CR_PRMRR_VALID_CONFIG 0x000001FB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Config1m : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* 1M supported MEE size. */
    UINT32 Config2m : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /* 2M supported MEE size. */
    UINT32 Config4m : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /* 4M supported MEE size. */
    UINT32 Config8m : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /* 8M supported MEE size. */
    UINT32 Config16m : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000000*/

                            /* 16M supported MEE size. */
    UINT32 Config32m : 1;

                            /* Bits[5:5], Access Type=RO, default=0x00000000*/

                            /* 32M supported MEE size. */
    UINT32 Config64m : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000000*/

                            /* 64M supported MEE size. */
    UINT32 Config128m : 1;

                            /* Bits[7:7], Access Type=RO, default=0x00000000*/

                            /* 128M supported MEE size. */
    UINT32 Config256m : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000000*/

                            /* 256M supported MEE size. */
    UINT32 Config512m : 1;

                            /* Bits[9:9], Access Type=RO, default=0x00000000*/

                            /* 512M supported MEE size. */
    UINT32 Config1gb : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000000*/

                            /* 1GB supported MEE size. */
    UINT32 Config2gb : 1;

                            /* Bits[11:11], Access Type=RO, default=0x00000000*/

                            /* 2GB supported MEE size. */
    UINT32 Config4gb : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* 4GB supported MEE size. */
    UINT32 Config8gb : 1;

                            /* Bits[13:13], Access Type=RO, default=0x00000000*/

                            /* 8GB supported MEE size. */
    UINT32 Config16gb : 1;

                            /* Bits[14:14], Access Type=RO, default=0x00000000*/

                            /* 16GB supported MEE size. */
    UINT32 Config32gb : 1;

                            /* Bits[15:15], Access Type=RO, default=0x00000000*/

                            /* 32GB supported MEE size. */
    UINT32 Config64gb : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000000*/

                            /* 64GB supported MEE size. */
    UINT32 Config128gb : 1;

                            /* Bits[17:17], Access Type=RO, default=0x00000000*/

                            /* 128GB supported MEE size. */
    UINT32 Config256gb : 1;

                            /* Bits[18:18], Access Type=RO, default=0x00000000*/

                            /* 256GB supported MEE size. */
    UINT32 Config512gb : 1;

                            /* Bits[19:19], Access Type=RO, default=0x00000000*/

                            /* 512GB supported MEE size. */
    UINT32 Config1tb : 1;

                            /* Bits[20:20], Access Type=RO, default=0x00000000*/

                            /* 1TB supported MEE size. */
    UINT32 Rsvd21 : 11;

                            /* Bits[31:21], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_PRMRR_VALID_CONFIG_REGISTER;

/**
  Power Control Register
**/
#define JSL_MSR_P_CR_POWER_CTL 0x000001FC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnableBidirProchot : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000001*/

                            /*
                               Used to enable or disable the response to
                               PROCHOT# input. When set/enabled, platform can
                               force CPU to throttle to a lower power condition
                               such as Pn/Pm by asserting prochot#. When
                               clear/disabled (default), CPU ignores the status
                               of the prochot input signal.
                            */
    UINT32 C1eEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /*
                               Used to enable C1E behavior on every C1 entry
                               (even if MWAIT C1E substate bit was not set or
                               when using HLT). When this package-visible bit
                               is set, it will cause CPU to switch to minimum
                               GV point when all cores have entered C1.
                               Frequency will switch immediately, followed by
                               gradual voltage switching (GV3 style).
                            */
    UINT32 SapmImcC2Policy : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000001*/

                            /*
                               Enables Self Refresh entry when the CPU is in
                               package-C2 (popup) state. Should be disabled
                               only if platform traffic cannot withstand even
                               the SR exit latency while in C2.
                            */
    UINT32 FastBrkSnpEn : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VID swing rate for Other_Snp_Wake
                               events detected at the iMPH. Will override a
                               SLOW sideband wake indication primarily for PCIe
                               traffic!). 1 - Use fast VID swing rate
                            */
    UINT32 FastBrkIntEn : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VID swing rate for Other_Intp_Wake
                               events detected at the iMPH. Will override a
                               SLOW sideband wake indication (for C7 or PCIe).
                               1 - Use fast VID swing rate
                            */
    UINT32 Rsrvd5 : 1;

                            /* Bits[5:5], Access Type=RSV, default=0x00000000*/

                            /*
                               Rsrvd uCode needs to copy this bit to/from
                               POWER_CTL1_CR[5] on writes.reads
                            */
    UINT32 PholdCstPreventionInit : 11;

                            /* Bits[16:6], Access Type=RW, default=0x00000001*/

                            /*
                               Init value for the PHOLD_CST_PREVENTION_Timer.
                               Values are between 0 and 1023 in 2^21*10nS
                               resolution (matching 0 - ~21sec)
                            */
    UINT32 PholdSrDisable : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               if set to 1, CPU will also prevent the memory
                               from going to SR during the CST_PREVENTION
                               timeout;
                            */
    UINT32 PwrPerfPltfrmOvr : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               When set to 0 (default), will disable access to
                               IA32_ENERGY_PERFORMANCE_BIAS MSR 1B0h (causing a
                               GP# fault on access). CPUID.(EAX=6):ECX[3] will
                               read 0. When set to 1 will enable access to
                               IA32_ENERGY_PERFORMANCE_BIAS MSR 1B0h.
                               CPUID.(EAX=6):ECX[3] will read 1
                            */
    UINT32 EeTurboDisable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* Energy Efficient Turbo Disable */
    UINT32 RthDisable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* RTH Disable */
    UINT32 DisProchotOut : 1;

                            /* Bits[21:21], Access Type=RWS, default=0x00000001*/

                            /* Prochot output disable */
    UINT32 ProchotResponse : 1;

                            /* Bits[22:22], Access Type=RWS, default=0x00000000*/

                            /* Prochhot Configurable Response Enable */
    UINT32 ProchotLock : 1;

                            /* Bits[23:23], Access Type=RWS, default=0x00000000*/

                            /*
                               When set to 1, locks bits 0, 21, 22 and 23 of
                               this MSR. Once set, a reset is required to clear
                               this bit.
                            */
    UINT32 VrThermAlertDisable : 1;

                            /* Bits[24:24], Access Type=RWS, default=0x00000000*/

                            /*
                               When set to 1, disables the VR_THERMAL_ALERT
                               signaling.
                            */
    UINT32 DisableRingEe : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* DISABLE_RING_EE */
    UINT32 DisableSaOptimization : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* DISABLE_SA_OPTIMIZATION */
    UINT32 DisableOok : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* Energy */
    UINT32 DisableAutonomous : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               Ability to disable HWP autonomous mode to
                               achieve maximum performance or lowest power (max
                               battery)
                            */
    UINT32 Rsvd29 : 1;

                            /* Bits[29:29], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CstatePrewakeDisable : 1;

                            /* Bits[30:30], Access Type=RWS, default=0x00000000*/

                            /*
                               This bit can be used to disable core/pkg C-state
                               Prewake timers.
                            */
    UINT32 ReservedMode31 : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 PwrPerfTuningDisableSapmCtrl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates whether power perf tuning
                               algorithm controls SAPM entities
                            */
    UINT32 PwrPerfTuningEnableDynSwitching : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates whether dynamic switching is
                               enabled in power perf tuning algorithm.
                            */
    UINT32 PwrPerfTuningCfgMode : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               was PWR_PERF_TUNING_CFG_MODE, change made to
                               match CR_47 definition.
                            */
    UINT32 LtrIioDisable : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates whether Pcode should poll the IIO
                               for LTR updates.
                            */
    UINT32 PchNegDisable : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates whether latency should be
                               negotiated with PCH for PKGC.
                            */
    UINT32 Rsvd37 : 27;

                            /* Bits[63:37], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_P_CR_POWER_CTL_REGISTER;

/**
  Special Chipset Usage MSR
**/
#define JSL_MSR_FUNNYIO_CR_SPCL_CHIPSET_USAGE 0x000001FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 En : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               Enable - when set to 1 causes chipset to remove
                               write protection of host flash partition. This
                               MSR bit can be written by SMM only when BIOS
                               guard is not enabled.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SPCL_CHIPSET_USAGE_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE0 0x00000200

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE0_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK0 0x00000201

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK0_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE1 0x00000202

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE1_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK1 0x00000203

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK1_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE2 0x00000204

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE2_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK2 0x00000205

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK2_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE3 0x00000206

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE3_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK3 0x00000207

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK3_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE4 0x00000208

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE4_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK4 0x00000209

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK4_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE5 0x0000020A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE5_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK5 0x0000020B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK5_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE6 0x0000020C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE6_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK6 0x0000020D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK6_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE7 0x0000020E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE7_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK7 0x0000020F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK7_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE8 0x00000210

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE8_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK8 0x00000211

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK8_REGISTER;

/**
  Refer to Software Developer's Manual
**/
#define JSL_MSR_X86_CR_MTRRPHYSBASE9 0x00000212

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd3 : 7;

                            /* Bits[9:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Inc1gb : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 1GB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 Inc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               Base Not 2MB aligned. Masked on RDMSR, WRMSR GP
                               faults if set to 1
                            */
    UINT32 BaseField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 BaseField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSBASE9_REGISTER;

/**
  Refer to Software Developer's Manual.
**/
#define JSL_MSR_X86_CR_MTRRPHYSMASK9 0x00000213

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 11;

                            /* Bits[10:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ValidBit : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MaskField1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRPHYSMASK9_REGISTER;

/**
  Maps 512K address range from 0H-7FFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX64K_00000 0x00000250

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 0- FFFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 10000-1FFFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 20000-2FFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 30000-3FFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 40000-4FFFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 50000-5FFFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 60000-6FFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 64K addr range from 70000-7FFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX64K_00000_REGISTER;

/**
  Maps 128K address range from 80000H-9FFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX16K_80000 0x00000258

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 80000-83FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 84000-87FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 88000-8BFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 8C000-8FFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 90000-93FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 94000-97FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 98000-9BFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from 9C000-9FFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX16K_80000_REGISTER;

/**
  Maps 128K address range from A0000H-BFFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX16K_A0000 0x00000259

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from A0000-A3FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from A4000-A7FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from A8000-ABFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from AC000-AFFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from B0000-B3FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from B4000-B7FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from B8000-BBFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 16K addr range from BC000-BFFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX16K_A0000_REGISTER;

/**
  Maps 32K address range from C0000H-C7FFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_C0000 0x00000268

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C0000-C0FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C1000-C1FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C2000-C2FFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C3000-C3FFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C4000-C4FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C5000-C5FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C6000-C6FFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C7000-C7FFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_C0000_REGISTER;

/**
  Maps 32K address range from C8000H-CFFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_C8000 0x00000269

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C8000-C8FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from C9000-C9FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CA000-CAFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CB000-CBFFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CC000-CCFFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CD000-CDFFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CE000-CEFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from CF000-CFFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_C8000_REGISTER;

/**
  Maps 32K address range from D0000H-D7FFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_D0000 0x0000026A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D0000-D0FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D1000-D1FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D2000-D2FFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D3000-D3FFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D4000-D4FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D5000-D5FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D6000-D6FFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D7000-D7FFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_D0000_REGISTER;

/**
  Maps 32K address range from D8000H-DFFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_D8000 0x0000026B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D8000-D8FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from D9000-D9FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DA000-DAFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DB000-DBFFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DC000-DCFFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DD000-DDFFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DE000-DEFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from DF000-DFFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_D8000_REGISTER;

/**
  Maps 32K address range from E0000H-E7FFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_E0000 0x0000026C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E0000-E0FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E1000-E1FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E2000-E2FFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E3000-E3FFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E4000-E4FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E5000-E5FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E6000-E6FFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E7000-E7FFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_E0000_REGISTER;

/**
  Maps 32K address range from E8000H-EFFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_E8000 0x0000026D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E8000-E8FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from E9000-E9FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from EA000-EAFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from EB000-EBFFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from EC000-ECFFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from ED000-EDFFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from EE000-EEFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from EF000-EFFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_E8000_REGISTER;

/**
  Maps 32K address range from F0000H-F7FFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_F0000 0x0000026E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F0000-F0FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F1000-F1FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F2000-F2FFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F3000-F3FFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F4000-F4FFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F5000-F5FFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F6000-F6FFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F7000-F7FFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_F0000_REGISTER;

/**
  Maps 32K address range from F8000H-FFFFFH
**/
#define JSL_MSR_X86_CR_MTRRFIX4K_F8000 0x0000026F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Entry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F8000-F8FFF */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from F9000-F9FFF */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FA000-FAFFF */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FB000-FBFFFF */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FC000-FCFFF */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FD000-FDFFF */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FE000-FEFFF */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Entry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* Maps 4K addr range from FF000-FFFFF */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRFIX4K_F8000_REGISTER;

/**
  Register containing the lower 8 bytes of the MAP (Memory Attribute Palette).
**/
#define JSL_MSR_X86_CR_PAT 0x00000277

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MapEntry0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000006*/

                            /* fill description here */
    UINT32 Reserved3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry1 : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000004*/

                            /* fill description here */
    UINT32 Reserved11 : 5;

                            /* Bits[15:11], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry2 : 3;

                            /* Bits[18:16], Access Type=RW, default=0x00000007*/

                            /* fill description here */
    UINT32 Reserved19 : 5;

                            /* Bits[23:19], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry3 : 3;

                            /* Bits[26:24], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved27 : 5;

                            /* Bits[31:27], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry4 : 3;

                            /* Bits[34:32], Access Type=RW, default=0x00000006*/

                            /* fill description here */
    UINT32 Reserved35 : 5;

                            /* Bits[39:35], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry5 : 3;

                            /* Bits[42:40], Access Type=RW, default=0x00000004*/

                            /* fill description here */
    UINT32 Reserved43 : 5;

                            /* Bits[47:43], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry6 : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /* fill description here */
    UINT32 Reserved51 : 5;

                            /* Bits[55:51], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 MapEntry7 : 3;

                            /* Bits[58:56], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved59 : 5;

                            /* Bits[63:59], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_PAT_REGISTER;

/**
  Bank0 MCA Control Register2.
**/
#define JSL_MSR_BUS_CR_MCI_CTL2 0x00000280

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BUS_CR_MCI_CTL2_REGISTER;

/**
  L2 MCA Control Register2.
**/
#define JSL_MSR_L2_CR_MCI_CTL2 0x00000281

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_L2_CR_MCI_CTL2_REGISTER;

/**
  MCA Addres Control Register for CMCI. The creg is restored during C6 restore.
**/
#define JSL_MSR_IC_CR_MCI_CTL2 0x00000282

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* The Threshold Value for Corrected Error Count */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               Software sets this bit to enable the generation
                               of corrected machine check interrupts
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IC_CR_MCI_CTL2_REGISTER;

/**
  MCA Control Register 2
**/
#define JSL_MSR_AGU_CR_MCI_CTL2 0x00000283

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ignored : 15;

                            /* Bits[14:0], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Writes to these bits do not cause exceptions,
                               but are ignored. Reads will always return 0.
                               This is allowed for banks where correctable
                               errors are not supported (like DL1)
                            */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               CMCI enable for the DCU (DL1). Not used by
                               correctable errors only by a DL1 parity error
                               turning into poison
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_AGU_CR_MCI_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC04_CTL2 0x00000284

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC04_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC05_CTL2 0x00000285

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC05_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC06_CTL2 0x00000286

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC06_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC07_CTL2 0x00000287

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC07_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC08_CTL2 0x00000288

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC08_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC09_CTL2 0x00000289

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC09_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC10_CTL2 0x0000028A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC10_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC11_CTL2 0x0000028B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC11_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC12_CTL2 0x0000028C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC12_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC13_CTL2 0x0000028D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC13_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC14_CTL2 0x0000028E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC14_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC15_CTL2 0x0000028F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC15_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC16_CTL2 0x00000290

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC16_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC17_CTL2 0x00000291

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC17_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC18_CTL2 0x00000292

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC18_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC19_CTL2 0x00000293

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC19_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC20_CTL2 0x00000294

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC20_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC21_CTL2 0x00000295

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC21_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC22_CTL2 0x00000296

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC22_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC23_CTL2 0x00000297

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC23_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC24_CTL2 0x00000298

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC24_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC25_CTL2 0x00000299

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC25_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC26_CTL2 0x0000029A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC26_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC27_CTL2 0x0000029B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC27_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC28_CTL2 0x0000029C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC28_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC29_CTL2 0x0000029D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC29_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC30_CTL2 0x0000029E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC30_CTL2_REGISTER;

/**
  Virtual Creg describing the architectural format of the MCi_CTL2 register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC31_CTL2 0x0000029F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorrectedErrorCountThreshold : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /* Corrected Error Count Threshold */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* CMCI Enable */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciCtl : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* CMCI CTL */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MceCtl : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* MCE_CTL */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UNCORE_CR_MC31_CTL2_REGISTER;

/**
  rPRotected Memory Range Register - Physical Base
**/
#define JSL_MSR_PMH_CR_PRMRR_BASE 0x000002A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* Memory Type for PRMRR accesses */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR base configured. Added for compatiblity
                               with SNC
                            */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Reserved12 : 8;

                            /* Bits[19:12], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               This is actually part of the BASE, but is
                               required to be 0 on Goldmont
                            */
    UINT32 Base0 : 12;

                            /* Bits[31:20], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Base address - the base is actually 39:12,
                               but Goldmont requires the base to be 1MB aligned
                               (i.e. 19:12 == 0)
                            */
    UINT32 Base1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               PRMRR Base address - the base is actually 39:12,
                               but Goldmont requires the base to be 1MB aligned
                               (i.e. 19:12 == 0)
                            */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PMH_CR_PRMRR_BASE_REGISTER;

/**
  Just for Macro-address
**/
#define JSL_MSR_BNL_CR_BIOS_MISC 0x000002E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NemSetup : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               no physical flop, but this bit will be mirrored
                               in SCP_CR_MSR_STATE[NEM_SETUP]. BIOS sets this
                               when it is ready to fill the NEM region, and
                               then executes the requests to fill the NEM.
                            */
    UINT32 NemRun : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               no physical flop, but this bit will be mirrored
                               in SCP_CR_MSR_STATE[NEM_RUN]. BIOS sets this bit
                               when it's done filling the NEM region and ready
                               for using cache as RAM
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_BIOS_MISC_REGISTER;
/**
  Used by Intel TXT enabled BIOS to unlock memory after checking that the TPM is valid.
**/
#define JSL_MSR_VIRT_CR_LT_UNLOCK_MEMORY 0x000002E6

/**
  This MSR is used to lock processor core and uncore BAR register space.
**/
#define JSL_MSR_FUNNYIO_CR_LTCTRLSTS 0x000002E7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Configlock : 1;

                            /* Bits[0:0], Access Type=RW1S, default=0x00000000*/

                            /*
                               This bit is used for indicating 'LT Config Lock'
                               to read and write operations over the message
                               channel. Read : 0 - Lock flag is cleared, 1 -
                               Lock flag is set; Write : 0 - ignored, 1 -Set
                               the Lock flag. No functionality required to be
                               supported in CBo iMPH
                            */
    UINT32 Memlockcpu : 1;

                            /* Bits[1:1], Access Type=RO_V, default=0x00000001*/

                            /*
                               This bit is implemented in the IMPH version of
                               the register only (as RO-VFW), the NCU holds a
                               shadow of the bit. This bit is used for
                               indicating 'LT Lock of CPU access to Memory'' to
                               read operations. The bit is cleared by a write
                               of 1 to the MemLockCPUClr bit. 0 - Memory access
                               is enabled 1 - Memory is Locked
                            */
    UINT32 Memlockdev : 1;

                            /* Bits[2:2], Access Type=RO_V, default=0x00000001*/

                            /*
                               This bit is implemented in the IMPH version of
                               the register only (as RO-VFW), the NCU holds a
                               shadow of the bit. This bit is used for
                               indicating 'LT Lock of Device access to Memory''
                               to read operations. The bit is cleared by a
                               write of 1 to the MemLockDevClr bit. 0 - Memory
                               access is enabled 1 - Memory is Locked
                            */
    UINT32 SmmlockRsvd : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /* Reserved for implemention in JKT */
    UINT32 ScheckPass : 1;

                            /* Bits[4:4], Access Type=RW1S, default=0x00000000*/

                            /*
                               This bit is set once by SCHECK once it passes.
                               it is cleared by the SCHECK_PASS_clr bit.
                            */
    UINT32 Poison : 1;

                            /* Bits[5:5], Access Type=RW1S, default=0x00000000*/

                            /*
                               ucode will set this bit whenever it sends out a
                               poison cycle. cleared by PoisonClr bit.
                            */
    UINT32 Private : 1;

                            /* Bits[6:6], Access Type=RW1S, default=0x00000000*/

                            /*
                               This bit is copied in the NCU and Cbo. This bit
                               is cleared by the PrivateClr bit. Read : 0 -
                               Private flag is clearedi, 1 - Private flag is
                               set. Write : 0 - ignored, 1 -Set the Private
                               flag
                            */
    UINT32 Inacm : 1;

                            /* Bits[7:7], Access Type=RW1S, default=0x00000000*/

                            /*
                               This bit is copied in the NCU IMPH and Cbo. This
                               bit is cleared by the respective bit in
                               NcuLTCtrClr register. Read : 0 - In ACM flag is
                               cleared, 1 - In ACM flag is set. Write : 0 -
                               ignored, 1 -Set the InACM flag
                            */
    UINT32 Loc3guarddis : 1;

                            /* Bits[8:8], Access Type=RW1S, default=0x00000000*/

                            /*
                               This bit is implemented in the Cbo and has a
                               shadow in NCU. This bit is cleared by writint a
                               1 to the respective bit in NcuLTCtrClr register.
                               Read : 0 - Locality 3 Guard is Enabled 1 -
                               Locality 3 Guard is Disable Write : 0 - ignored
                               1 -Set the Loc3Guard
                            */
    UINT32 Hskinprog : 1;

                            /* Bits[9:9], Access Type=RW1S, default=0x00000000*/

                            /*
                               Indicates that the core is in the process of
                               SENTER or SEXIT handshake. This is a sticky bit
                               used by uCode as part of LT flow. No HW action
                               in NCU. This bit is cleared by writint a 1 to
                               the respective bit in NcuLTCtrClr register. Read
                               : 0 - Hand Shake not in progress 1 - Hand Shake
                               in progress Write : 0 - ignored 1 -Set the
                               HskInProg
                            */
    UINT32 Faterrdursacm : 1;

                            /* Bits[10:10], Access Type=RW1S, default=0x00000000*/

                            /*
                               FATAL_ERROR_DURING_SACM Indicates that an error
                               occurred during Startup ACM processing that
                               caused an LT-shutdown. This register is
                               preserved across warm reset, so reset uCode can
                               check this bit and skip Startup ACM processing
                               if it is set to prevent an infinite loop of
                               resets This is a sticky bit used by uCode as
                               part of LT flow. No HW action in NCU. This bit
                               is cleared by writint a 1 to the respective bit
                               in NcuLTCtrClr register. Read : 0 - No Error 1 -
                               Fatal Error During SACM Write : 0 - ignored 1
                               -Set the FatErrDurSACM
                            */
    UINT32 IlpMsegValid : 1;

                            /* Bits[11:11], Access Type=RW1S, default=0x00000000*/

                            /*
                               This is a sticky bit used by uCode as part of LT
                               flow. It is used to stash the ILP's copy of
                               FSCP_CR_VMX_MSEG_BASE[VALID]. It is used by
                               UCODE for consistency check to verify that all
                               threads select the same type of SMM handling. No
                               HW action in NCU. This bit is cleared by writing
                               a 1 to the respective bit in NcuLTCtrClr
                               register. Read : 0 - Bit is at cleared state 1 -
                               Bit is set state Write : 0 - ignored 1 -Set the
                               ILP_MSEG_VALID
                            */
    UINT32 PostSenter : 1;

                            /* Bits[12:12], Access Type=RW1S, default=0x00000000*/

                            /*
                               This is a sticky bit used by uCode as part of LT
                               flow. The POST_SENTER bit will be set between
                               SENTER and SEXIT. It is used to detect
                               spontaneous reset during secure mode. The
                               POST_SENTER bit must survive warm reset. It will
                               be checked along with the existing AC-mode check
                               in reset UCODE. No HW action in NCU. This bit is
                               cleared by writing a 1 to the respective bit in
                               NcuLTCtrClr register. Read : 0 - Bit is at
                               cleared state 1 - Bit is set state Write : 0 -
                               ignored 1 -Set the POST_SENTER bit
                            */
    UINT32 LtScp3Rsrv : 1;

                            /* Bits[13:13], Access Type=RW1S, default=0x00000000*/

                            /*
                               This is a sticky bit used by uCode as part of LT
                               flow - currently as spare bit. No HW action in
                               NCU. This bit is cleared by writing a 1 to the
                               respective bit in NcuLTCtrClr register. Read : 0
                               - Bit is at cleared state, 1 - Bit is set state.
                               Write : 0 - ignored, 1 -Set the LT_scp3_rsrv
                            */
    UINT32 Reserved14 : 2;

                            /* Bits[15:14], Access Type=RO, default=0x00000000*/

                            /* Reserved for future use. */
    UINT32 Configunloc : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /*
                               Writing a value of 0 to this bit has no effect.
                               Writing a value of 1 to this bit will clear the
                               ConfigLock flag. NOTE: The HW an assume that
                               only SW in ACM mode will write to this bit a
                               value of 1.
                            */
    UINT32 Memlockcpuclr : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /*
                               Writing 1 to this bit clears MemLockCPU bit in
                               this register. Writing 0 to this bit has no
                               effect.
                            */
    UINT32 Memlockdevclr : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /*
                               Writing 1 to this bit clears MemLockDev bit in
                               this register. Writing 0 to this bit has no
                               effect.
                            */
    UINT32 SmmlockclrReserved : 1;

                            /* Bits[19:19], Access Type=RO, default=0x00000000*/

                            /* Reserved for use by JKT with SMMLock bit. */
    UINT32 ScheckPassClr : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /*
                               0 : Ignored, 1 : Clear the SCHECK_PASS bit in
                               this register.
                            */
    UINT32 Poisonclr : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /*
                               0 : Ignored, 1 : Clear the Poison bit in this
                               register.
                            */
    UINT32 Privateclr : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /*
                               0 : Ignored, 1 : Clear the Private bit in this
                               register.
                            */
    UINT32 Inacmclr : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /* 0 : ignored, 1 : Clears the InACM flag */
    UINT32 Loc3guarddisclear : 1;

                            /* Bits[24:24], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If Loc3GuardDis=0 (including the result
                               of this write) - Ignored, else: 0 - ignored, 1 -
                               Clear the Loc3GuardDis flag
                            */
    UINT32 Hskinprogclr : 1;

                            /* Bits[25:25], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If HskInProgs=0 (including the result of
                               this write) - Ignored. else: 0 - ignored, 1 -
                               Clear the HskInProg flag
                            */
    UINT32 Faterrdursacmclr : 1;

                            /* Bits[26:26], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If FatErrDurSACM=0 (including the result
                               of this write) - Ignored. else: 0 - ignored 1 -
                               Clear the FatErrDurSACM flag
                            */
    UINT32 IlpMsegValidClr : 1;

                            /* Bits[27:27], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If ILP_MSEG_VALID=0 (including the
                               result of this write) - Ignored. else 0 -
                               ignored 1 - Clear the ILP_MSEG_VALID flag
                            */
    UINT32 PostSenterClr : 1;

                            /* Bits[28:28], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If POST_SENTER=0 (including the result
                               of this write) - Ignored. else 0 - ignored 1 -
                               Clear the POST_SENTER flag
                            */
    UINT32 LtScp3RsrvClr : 1;

                            /* Bits[29:29], Access Type=WO, default=0x00000000*/

                            /*
                               Write : If LT_scp3_rsrv=0 (including the result
                               of this write) - Ignored. else 0 - ignored 1 -
                               Clear the LT_scp3_rsrv flag
                            */
    UINT32 Ltpmonctrclr : 1;

                            /* Bits[30:30], Access Type=WO, default=0x00000000*/

                            /*
                               This bit is copied in the NCU and Cbo. This bit
                               is used for LT uCode control over the PMON
                               counters. The NCU copy of the register must be
                               cleared last to prevent race conditions with
                               clear operations of other module's counters. 0b
                               No action 1b Clear all PMON control registers
                               (including Fixed counter control)
                            */
    UINT32 Ltpmoncntclr : 1;

                            /* Bits[31:31], Access Type=WO, default=0x00000000*/

                            /*
                               This bit is copied in the NCU and Cbo. This bit
                               is used for LT uCode control over the PMON
                               counters. 0b No Action 1b Clear all PMON Counter
                               registers and Unit overflow status registers
                               (including Fixed Counter and Global Overflow
                               Status).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_LTCTRLSTS_REGISTER;

/**
  ACM Only MSR for EDRAM management
**/
#define JSL_MSR_UCODE_CR_EDRAM_ACM 0x000002E8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ForceEdramDisabled : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 EdramIsDisabled : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /* eDRAM is disabled as a result of force disable */
    UINT32 EdramExists : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd3 : 29;

                            /* Bits[31:3], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_EDRAM_ACM_REGISTER;

/**
.
**/
#define JSL_MSR_X86_CR_MTRRDEFTYPE 0x000002FF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /*
                               On prior projects diverge_archsim.pl used to
                               override the default type in archsim_msr.def to
                               WB(6). FC simulations used to set this value
                               using an API after reset ucode. This is all
                               removed on GLM, and the reset value is 0
                            */
    UINT32 ReservedType3 : 5;

                            /* Bits[7:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Reserved8 : 2;

                            /* Bits[9:8], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 FixedRangeEnable : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 MtrrEnable : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               On prior projects diverge_archsim.pl used to
                               override the enable to 1 so that the
                               archsim_msr.def reset value was 0x806. FC
                               simulations used to set this value using an API
                               after reset ucode. This is all removed on GLM,
                               and the reset value is 0.
                            */
    UINT32 Reserved12 : 20;

                            /* Bits[31:12], Access Type=Rsvd0, default=None*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_X86_CR_MTRRDEFTYPE_REGISTER;
/**
  uCode scratchpad register shared by all threads.
**/
#define JSL_MSR_FUNNYIO_CR_SCP_SE_OWNER_EPOCH_0 0x00000300
/**
  uCode scratchpad register shared by all threads.
**/
#define JSL_MSR_FUNNYIO_CR_SCP_SE_OWNER_EPOCH_1 0x00000301

/**
  uCode scratchpad register shared by all threads.
**/
#define JSL_MSR_FUNNYIO_CR_BIOS_SE_SVN 0x00000302

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PrResetSvn : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* Reset patch SVN */
    UINT32 Rsvd8 : 8;

                            /* Bits[15:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 GetsecSenterAcmSvn : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               SENTER ACM SVN. Survives warm reset. Set to 0xFF
                               by microcode on all resets.
                            */
    UINT32 GetsecScleanAcmSvn : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               SINIT ACM SVN. Survives warm reset. Set to 0xFF
                               by microcode on all resets.
                            */
    UINT32 AncAcmSvn : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Anchor Cove ACM SVN. Survives warm reset. Set to
                               0xFF by microcode on all resets.
                            */
    UINT32 Rsvd40 : 24;

                            /* Bits[63:40], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_BIOS_SE_SVN_REGISTER;
/**
  Used as a mailbox between BIOS and MCHECK.
**/
#define JSL_MSR_FUNNYIO_CR_SCP_MCHECK_BOOT_SCENARIO 0x00000304

/**
  Fixed PerfMon counter 0 - Instructions retired.
**/
#define JSL_MSR_IA32_CR_FIXED_CTR0 0x00000309

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FixedCounter0Lo : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               Lower 6 bits of 48-bit fixed counter 0. Only
                               lower 6 bits are duplicated in ARR1 for PEBS
                               PDIR.
                            */
    UINT32 FixedCounter0Hi0 : 26;

                            /* Bits[31:6], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 0 */
    UINT32 FixedCounter0Hi1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 0 */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FIXED_CTR0_REGISTER;

/**
  Fixed PerfMon counter 1 - Unhalted core cycles.
**/
#define JSL_MSR_IA32_CR_FIXED_CTR1 0x0000030A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FixedCounter1Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 1 */
    UINT32 FixedCounter1Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 1 */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FIXED_CTR1_REGISTER;

/**
  Fixed PerfMon counter 2 - Unhalted reference cycles.
**/
#define JSL_MSR_IA32_CR_FIXED_CTR2 0x0000030B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FixedCounter2Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 2 */
    UINT32 FixedCounter2Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* 48-bit fixed counter 2 */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FIXED_CTR2_REGISTER;

/**
  Enumeration of the existence of certain debug features. This MSR is read only; uCode generates #GP on any write.
**/
#define JSL_MSR_IA32_CR_PERF_CAPABILITIES 0x00000345

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LbrformatReturns00001064BitOffsetFormat : 6;

                            /* Bits[5:0], Access Type=RO, default=0x00000007*/

                            /*
                               000000 = 32-bit offset in current CS in
                               LastBranchFromIP, 32-bit offset in current CS in
                               LastBranchToIP as on P6; 000001 = 64-bit FROM
                               LIP, 64-bit TO LIP (BNL through SLM); 000010 =
                               64-bit FROM EIP, 64-bit TO EIP (Merom); 000011 =
                               64-bit FROM EIP, 64-bit TO EIP (Nehalem) +
                               Flags; 000100 = 64-bit FROM EIP, 64-bit TO EIP
                               (Haswell) + Flags + TSX; 000101 = 64-bit FROM
                               EIP, 64-bit TO EIP (Skylake) + Flags + TSX +
                               time; 000111 = 64-bit LIP record format, Flags,
                               TSX, LBR_INFO; value for GLP/TNT (TNT
                               b1706670764)
                            */
    UINT32 Pebstrap : 1;

                            /* Bits[6:6], Access Type=Rsvd1, default=0x00000001*/

                            /* fill description here */
    UINT32 PebssavearchregsReturns1GpRegistersAreSavedIntoThePebsArea : 1;

                            /* Bits[7:7], Access Type=Rsvd1, default=0x00000001*/

                            /* fill description here */
    UINT32 Pebsrecordformat : 4;

                            /* Bits[11:8], Access Type=Rsvd0, default=0x00000004*/

                            /*
                               Specifies the PEBS Record Format - 0100:
                               Adaptive PEBS Records
                            */
    UINT32 Smmfreeze : 1;

                            /* Bits[12:12], Access Type=Rsvd1, default=0x00000001*/

                            /* SLM:1= freeze perfmon in SMM */
    UINT32 Fullwidthcntrs : 1;

                            /* Bits[13:13], Access Type=Rsvd1, default=0x00000001*/

                            /* SLM:1 = full-width counter */
    UINT32 AdaptivePebsData : 1;

                            /* Bits[14:14], Access Type=Rsvd1, default=0x00000001*/

                            /* When SET, indicates support for Adaptive PEBS */
    UINT32 Reserved15 : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* PEBS metrics on SNC */
    UINT32 PebsOutputPt : 1;

                            /* Bits[16:16], Access Type=Rsvd1, default=0x00000001*/

                            /*
                               When SET, indicates support for PEBS PT output.
                               Not supported on SNC
                            */
    UINT32 Rsvd17 : 15;

                            /* Bits[31:17], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_CAPABILITIES_REGISTER;

/**
  Global Perfmon Overflow clear register. BIU HW will clear the corresponding overflow in 35:32 of PERF_GLOBAL_STATUS if there is any change in value of bits 11:0 (Each 4 bit field affects its corresponding overflow).
**/
#define JSL_MSR_IA32_CR_FIXED_CTR_CTRL 0x0000038D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FixedPerfmonCounter0Enable : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /*
                               00 Disable 01 Ring 0 (OS) 10 Ring 1,2,3 (User)
                               11 All ring levels (OS or User)
                            */
    UINT32 FixedPerfmonCounter0AnyThread : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 FixedPerfmonCounter0EnablePmiOnOverflow : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 FixedPerfmonCounter1Enable : 2;

                            /* Bits[5:4], Access Type=RW, default=0x00000000*/

                            /*
                               00 Disable 01 Ring 0 (OS) 10 Ring 1,2,3 (User)
                               11 All ring levels (OS or User)"
                            */
    UINT32 FixedPerfmonCounter1AnyThread : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 FixedPerfmonCounter1EnablePmiOnOverflow : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 FixedPerfmonCounter2Enable : 2;

                            /* Bits[9:8], Access Type=RW, default=0x00000000*/

                            /*
                               00 Disable 01 Ring 0 (OS) 10 Ring 1,2,3 (User)
                               11 All ring levels (OS or User)"
                            */
    UINT32 FixedPerfmonCounter2AnyThread : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               This bit has been deprecated. This change is in
                               convergence with core-family and is enumerated
                               in CPUID.A.EDX bit 15.
                            */
    UINT32 FixedPerfmonCounter2EnablePmiOnOverflow : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 ReservedL12 : 20;

                            /* Bits[31:12], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 AdaptiveRecordFc0 : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* This bit is for ADAPTIVE_RECORD_FC0. */
    UINT32 Reserved33 : 3;

                            /* Bits[35:33], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 AdaptiveRecordFc1 : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /* This bit is for ADAPTIVE_RECORD_FC1. */
    UINT32 Reserved37 : 3;

                            /* Bits[39:37], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 AdaptiveRecordFc2 : 1;

                            /* Bits[40:40], Access Type=RW, default=0x00000000*/

                            /* This bit is for ADAPTIVE_RECORD_FC2 */
    UINT32 Reserved41 : 23;

                            /* Bits[63:41], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_FIXED_CTR_CTRL_REGISTER;

/**
  PerfMon Global Status Register. This MSR is read only; uCode generates #GP on any write.
**/
#define JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS 0x0000038E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpPerfmonCounter0Overflow : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 GpPerfmonCounter1Overflow : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 GpPerfmonCounter2Overflow : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 GpPerfmonCounter3Overflow : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 FixedPerfmonCounter0Overflow : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 FixedPerfmonCounter1Overflow : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 FixedPerfmonCounter2Overflow : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved35 : 20;

                            /* Bits[54:35], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 RtitTopaPmi : 1;

                            /* Bits[55:55], Access Type=RO, default=0x00000000*/

                            /*
                               RTIT Table of Physical Addresses PMI. Allows S/W
                               to differentiate between legacy PMI sources.
                            */
    UINT32 Reserved56 : 2;

                            /* Bits[57:56], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 LbrsFrozen : 1;

                            /* Bits[58:58], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 CountersFrozen : 1;

                            /* Bits[59:59], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Asci : 1;

                            /* Bits[60:60], Access Type=RO, default=0x00000000*/

                            /*
                               Set if any of the perfmon counters are
                               suppressed
                            */
    UINT32 OvfUncore : 1;

                            /* Bits[61:61], Access Type=RO, default=0x00000000*/

                            /* Indicate receiving PMI from uncore */
    UINT32 PebsBufferOverflow : 1;

                            /* Bits[62:62], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 CondchgTheBitIsSetByHardwareInCaseOfAChangeToIa32MiscEnablesemonAvailable : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS_REGISTER;

/**
  Global Perfmon Enable/Disable register
**/
#define JSL_MSR_IA32_CR_PERF_GLOBAL_CTRL 0x0000038F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EnableGpPerfmonCounter0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 EnableGpPerfmonCounter1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 EnableGpPerfmonCounter2 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 EnableGpPerfmonCounter3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 EnableFixedPerfmonCounter0 : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 EnableFixedPerfmonCounter1 : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 EnableFixedPerfmonCounter2 : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved35 : 29;

                            /* Bits[63:35], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_GLOBAL_CTRL_REGISTER;

/**
  Global Perfmon Overflow clear register. This creg is write only; read value is irrelevant for the RDMSR. For some reason, this MSR is not a write only MSR. Return 0s on reads
**/
#define JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS_RESET 0x00000390

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ClearPerfmonCounter0Overflow : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 ClearPerfmonCounter1Overflow : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 ClearPerfmonCounter2Overflow : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 ClearPerfmonCounter3Overflow : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 ClearFixedPerfmonCounter0Overflow : 1;

                            /* Bits[32:32], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 ClearFixedPerfmonCounter1Overflow : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 ClearFixedPerfmonCounter2Overflow : 1;

                            /* Bits[34:34], Access Type=WO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved35 : 20;

                            /* Bits[54:35], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 ClearRtitTopaPmi : 1;

                            /* Bits[55:55], Access Type=WO, default=0x00000000*/

                            /*
                               RTIT Table of Physical Addresses PMI. Allows S/W
                               to differentiate between legacy PMI sources.
                            */
    UINT32 Reserved56 : 2;

                            /* Bits[57:56], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 ClearLbrsFrozen : 1;

                            /* Bits[58:58], Access Type=WO, default=0x00000000*/

                            /* Clears IA32_PERF_GLOBAL_STATUS[58] */
    UINT32 ClearCountersFrozen : 1;

                            /* Bits[59:59], Access Type=WO, default=0x00000000*/

                            /* Clears IA32_PERF_GLOBAL_STATUS[59] */
    UINT32 ClearAsci : 1;

                            /* Bits[60:60], Access Type=WO, default=0x00000000*/

                            /* Clear ASCI in status register */
    UINT32 ClearOvfUncore : 1;

                            /* Bits[61:61], Access Type=WO, default=0x00000000*/

                            /* Clears related bit in IA32_CR_PERF_GLOBAL_STATUS */
    UINT32 ClearPebsBufferOverflow : 1;

                            /* Bits[62:62], Access Type=WO, default=0x00000000*/

                            /* Clears related bit in IA32_CR_PERF_GLOBAL_STATUS */
    UINT32 ClrcondchgIfSetClearsTheConditionsChangedBitInTheStatusRegister : 1;

                            /* Bits[63:63], Access Type=WO, default=0x00000000*/

                            /*
                               NHM i386585/e466981 allowed bit 63 to be written
                               (i.e CONDCHG cleared) even if EMON is not
                               available. SLM did not match this behavior. GLM
                               will.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS_RESET_REGISTER;

/**
  PerfMon Arch v4 register used to enumerate the availability of PerfMon resources for use. Ucode will not read this creg, so its behavior on reads is a don't care.
**/
#define JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS_SET 0x00000391

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SetCntr0Ovflw : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[0] */
    UINT32 SetCntr1Ovflw : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[1] */
    UINT32 SetCntr2Ovflw : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[2] */
    UINT32 SetCntr3Ovflw : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[3] */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 SetFix0Ovflw : 1;

                            /* Bits[32:32], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[32] */
    UINT32 SetFix1Ovflw : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[33] */
    UINT32 SetFix2Ovflw : 1;

                            /* Bits[34:34], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[34] */
    UINT32 Reserved35 : 20;

                            /* Bits[54:35], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 SetRtitTopaPmi : 1;

                            /* Bits[55:55], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[55] */
    UINT32 Reserved56 : 2;

                            /* Bits[57:56], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved. */
    UINT32 SetLbrsFrozen : 1;

                            /* Bits[58:58], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[58] */
    UINT32 SetCountersFrozen : 1;

                            /* Bits[59:59], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[59] */
    UINT32 SetAsci : 1;

                            /* Bits[60:60], Access Type=WO, default=0x00000000*/

                            /* Set the ASCI bit */
    UINT32 SetOvfUncore : 1;

                            /* Bits[61:61], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[61] */
    UINT32 SetPebsBufferOvflw : 1;

                            /* Bits[62:62], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[62] */
    UINT32 SetCondChngd : 1;

                            /* Bits[63:63], Access Type=WO, default=0x00000000*/

                            /* Sets IA32_PERF_GLOBAL_STATUS[63] */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_GLOBAL_STATUS_SET_REGISTER;

/**
  PerfMon Arch v4 register used to enumerate the availability of PerfMon resources for use
**/
#define JSL_MSR_IA32_CR_PERF_UNAVAILABLE_STATUS 0x00000392

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ia32Pmc0Programmed : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Event_Select0[7:0]) */
    UINT32 Ia32Pmc1Programmed : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Event_Select1[7:0]) */
    UINT32 Ia32Pmc2Programmed : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Event_Select2[7:0]) */
    UINT32 Ia32Pmc3Programmed : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Event_Select3[7:0]) */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 Ia32FixedCtr0Programmed : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Fixed_Ctr_Ctrl[1:0]) */
    UINT32 Ia32FixedCtr1Programmed : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Fixed_Ctr_Ctrl[5:4]) */
    UINT32 Ia32FixedCtr2Programmed : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000000*/

                            /* BITWISE_OR(Fixed_Ctr_Ctrl[9:8]) */
    UINT32 Reserved35 : 28;

                            /* Bits[62:35], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 PmiProgrammed : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /*
                               Set if any of the Fixed or GP counters have PMI
                               Enabled
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PERF_UNAVAILABLE_STATUS_REGISTER;

/**
  Holds the status information and control the operation of the PMON Fixed Counter.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define JSL_MSR_NCEVENTS_CR_NCUPMONCTLFIX_CLIENT 0x00000394

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 20;

                            /* Bits[19:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_NCEVENTS_CR_NCUPMONCTLFIX_CLIENT_REGISTER;

/**
  PMON Fixed Counter data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define JSL_MSR_NCEVENTS_CR_NCUPMONCTRFX_CLIENT 0x00000395

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_NCEVENTS_CR_NCUPMONCTRFX_CLIENT_REGISTER;

/**
  This is MSR that shows to user configuration of uncore PMON's. In this particular case it shows the number of Cbo PMON banks
**/
#define JSL_MSR_NCEVENTS_CR_NCUPMONCONFIG_CLIENT 0x00000396

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Numofcbopmon : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000005*/

                            /*  */
    UINT32 Rsvd4 : 12;

                            /* Bits[15:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Numofidppmon : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000000*/

                            /*  */
    UINT32 Rsvd17 : 15;

                            /* Bits[31:17], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_NCEVENTS_CR_NCUPMONCONFIG_CLIENT_REGISTER;

/**
  PMON Counter 0  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERFCTR0_CLIENT 0x000003B0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERFCTR0_CLIENT_REGISTER;

/**
  PMON Counter 0  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERFCTR1_CLIENT 0x000003B1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERFCTR1_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERFEVTSEL0_CLIENT 0x000003B2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* EVSLCT */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* UNITMASK */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* ENUBP */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* EDGEDET */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* TIDFILTERENABLE */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* OVFEN */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /* INTERNAL */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* COUNTEREN */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* INVERT */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /* THRESHOLD */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERFEVTSEL0_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERFEVTSEL1_CLIENT 0x000003B3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* EVSLCT */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* UNITMASK */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* ENUBP */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* EDGEDET */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* TIDFILTERENABLE */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* OVFEN */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /* INTERNAL */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* COUNTEREN */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* INVERT */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /* THRESHOLD */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERFEVTSEL1_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERF_STATUS_CLIENT 0x000003B4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ovfcntr0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               0. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Ovfcntr1 : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               1. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERF_STATUS_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_0_CR_PERF_CTRL_CLIENT 0x000003B5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [3:1]
                               Core ID. When TID Filter Enable is clear in the
                               Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Gtid : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When this field is set (!=0) and TID Filter
                               Enable is set, only GT events will be count.
                               When this bit unset (==0) the filtering will be
                               according to threadid field.
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_0_CR_PERF_CTRL_CLIENT_REGISTER;

/**
  PMON Counter 0  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERFCTR0_CLIENT 0x000003B8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERFCTR0_CLIENT_REGISTER;

/**
  PMON Counter 0  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERFCTR1_CLIENT 0x000003B9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERFCTR1_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERFEVTSEL0_CLIENT 0x000003BA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* EVSLCT */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* UNITMASK */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* ENUBP */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* EDGEDET */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* TIDFILTERENABLE */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* OVFEN */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /* INTERNAL */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* COUNTEREN */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* INVERT */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /* THRESHOLD */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERFEVTSEL0_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERFEVTSEL1_CLIENT 0x000003BB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* EVSLCT */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* UNITMASK */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* ENUBP */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* EDGEDET */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* TIDFILTERENABLE */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* OVFEN */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /* INTERNAL */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* COUNTEREN */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* INVERT */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /* THRESHOLD */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERFEVTSEL1_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERF_STATUS_CLIENT 0x000003BC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ovfcntr0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               0. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Ovfcntr1 : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               1. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERF_STATUS_CLIENT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_MSR_UNC_ARB_1_CR_PERF_CTRL_CLIENT 0x000003BD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [3:1]
                               Core ID. When TID Filter Enable is clear in the
                               Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Gtid : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When this field is set (!=0) and TID Filter
                               Enable is set, only GT events will be count.
                               When this bit unset (==0) the filtering will be
                               according to threadid field.
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MSR_UNC_ARB_1_CR_PERF_CTRL_CLIENT_REGISTER;

/**
  Precise Event Based Sampling controlling MSR. Upper 32 is not required any more due to DCN #427718.
**/
#define JSL_MSR_IA32_CR_PEBS_ENABLE 0x000003F1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PebsEnPmc0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* When set, enables Precise Event Based Sampling */
    UINT32 PebsEnPmc1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* When set, enables Precise Event Based Sampling */
    UINT32 PebsEnPmc2 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* When set, enables Precise Event Based Sampling */
    UINT32 PebsEnPmc3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* When set, enables Precise Event Based Sampling */
    UINT32 Reserved4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 PebsEnFixed0 : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               When set, enables Precise Event Based Sampling
                               for fixed counter0
                            */
    UINT32 PebsEnFixed1 : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /*
                               When set, enables Precise Event Based Sampling
                               for fixed counter1
                            */
    UINT32 PebsEnFixed2 : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               When set, enables Precise Event Based Sampling
                               for fixed counter2
                            */
    UINT32 Reserved35 : 25;

                            /* Bits[59:35], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 PmiAfterEachRecord : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /*
                               When set, pend a perfmon interrupt after each
                               PEBS event
                            */
    UINT32 PebsOutput : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               Select PEBS output destination - 0b00 - DS save
                               area, 0b01 - Intel PT trace output, 0b1x - Rsvd
                            */
    UINT32 Reserved62 : 2;

                            /* Bits[63:62], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PEBS_ENABLE_REGISTER;

/**
  Precise Event Based Sampling data configuration MSR.
**/
#define JSL_MSR_IA32_CR_PEBS_DATA_CFG 0x000003F2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MemoryInfo : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Gprs : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Xmms : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Lbrs : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd4 : 20;

                            /* Bits[23:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 LbrEntries : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_PEBS_DATA_CFG_REGISTER;
/**
  [p]PUNIT_MSR: Currently unused residency counter.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[p]
  [p][b]MSR_Name[/b]: PC3_RCNTR  [b]MSR_Addr[/b]: 0x3F8[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC3_RCNTR 0x000003F8
/**
  [p]PUNIT_MSR: Primary Compute System (PCS) idle residency counter.  This counter increments at any time that the SOC is in the S0i1 state, with cores, graphics and camera processing system all idle.  Display, Camera Input System or other south complex IPs may be active at this time.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[p]
  [p][b]MSR_Name[/b]: PC6_RCNTR  [b]MSR_Addr[/b]: 0x3F9[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC6_RCNTR 0x000003F9
/**
  [p]PUNIT_MSR: Primary Compute System (PCS) S0i3 residency counter.  This counter increments at any time that the PCS is ready for S0i3, which includes all compute domains idle (IA cores, graphics and camera) as well as display and camera input system both off.  The SOC may remain in this state for extended periods if south complex IPs are not ready to enter S0i3.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[/p]
  [p][b]MSR_Name[/b]: PC7_RCNTR  [b]MSR_Addr[/b]: 0x3FA[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC7_RCNTR 0x000003FA
/**
  Was the core C3 residency timer. Core C3 is decprecated on TNT to match SNC. MSR will return 0s
**/
#define JSL_MSR_VIRT_CR_CORE_C3_RESIDENCY 0x000003FC
/**
  GLM i1958858: copy of the cores c-state residency timer. This entry is reserved for future use.
**/
#define JSL_MSR_C6_SCP_CR_CORE_C6_RESIDENCY 0x000003FD

/**
  Time spent in the Core CState. It is given in units compatible to P1 clock frequency Guaranteed / Maximum Core NonTurbo Frequency. This time will be updated by PCODE only after the CState exit the update of this register has lower priority than actually ensuring that the CState exit occurs.
**/
#define JSL_MSR_CORE_INTERFACE_CR_CC7_RCNTR 0x000003FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Counter1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Reserved60 : 4;

                            /* Bits[63:60], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_CC7_RCNTR_REGISTER;

/**
  MCA Control Register. MRM b1598713:Dont #GP on writing ones to the upper part of MCi_CTL because the software model always write one to the whole 64bit
**/
#define JSL_MSR_BUS_CR_MCI_CTL 0x00000400

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RobTimeoutReserved : 1;

                            /* Bits[0:0], Access Type=Rsvd0, default=0x00000000*/

                            /* uarch */
    UINT32 IdiParityError : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* uarch */
    UINT32 Reserved2 : 2;

                            /* Bits[3:2], Access Type=RW, default=0x00000000*/

                            /* uarch */
    UINT32 BgfPointerError : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* uarch */
    UINT32 Reserved5 : 1;

                            /* Bits[5:5], Access Type=Rsvd0, default=0x00000000*/

                            /* uarch - tnt no longer used */
    UINT32 GoErr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* uarch */
    UINT32 Reserved7 : 25;

                            /* Bits[31:7], Access Type=Rsvd0, default=0x00000000*/

                            /* uarch */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=Rsvd0, default=0x00000000*/

                            /* uarch */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BUS_CR_MCI_CTL_REGISTER;

/**
  MCA Status Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_BUS_CR_MCI_STATUS 0x00000401

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /* MCA COD bits; C6 Notes:Read-Write */
    UINT32 ModelSpecific3to2 : 2;

                            /* Bits[3:2], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 McacodReq : 2;

                            /* Bits[5:4], Access Type=RW, default=0x00000000*/

                            /* MCA COD req bits; C6 Notes:Read-Write */
    UINT32 ModelSpecific9to6 : 4;

                            /* Bits[9:6], Access Type=RW, default=0x00000000*/

                            /* not define */
    UINT32 McacodRob : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* MCA COD rob; C6 Notes:Read-Write */
    UINT32 McacodIdi : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* MCA COD bit1; C6 Notes:Read-Write */
    UINT32 ModelSpecific15to12 : 4;

                            /* Bits[15:12], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 IdiOpcodeOrBgfErr : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               if BGF_ERR, then 24:16 is which of the 9 bgf
                               tunnels failed. else 23:16 is IDI opcode
                            */
    UINT32 GoErrOrBgfErr : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               if BGF_ERR, then 24:16 is which of the 9 bgf
                               tunnels failed. else 24 is go err
                            */
    UINT32 ErrorType : 3;

                            /* Bits[27:25], Access Type=RW, default=0x00000000*/

                            /* error type */
    UINT32 ModelSpecific36to280 : 4;

                            /* Bits[31:28], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 ModelSpecific36to281 : 5;

                            /* Bits[36:32], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 Fw : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 ModelSpecific54to38 : 17;

                            /* Bits[54:38], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW, default=0x00000000*/

                            /* Recovery action required for UCR error */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /* Signaling an uncorrectable recoverable error */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /* XQ_ERR */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /* addrv */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /* BUS_CR_MCI_MISC is valid */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /* reserved */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               uncorrectable error (since inbound mcerr is
                               removed starting with TNT, all errors logged to
                               this creg are uncorrectable)
                            */
    UINT32 Overflow : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* overflow */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BUS_CR_MCI_STATUS_REGISTER;

/**
  MCA Address Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_BUS_CR_MCI_ADDR 0x00000402

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Bits0to350 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Bits 0 to 41 for the MCA address register */
    UINT32 Bits0to351 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* Bits 0 to 41 for the MCA address register */
    UINT32 ModelSpecific63to42 : 22;

                            /* Bits[63:42], Access Type=RW, default=0x00000000*/

                            /* not defined */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BUS_CR_MCI_ADDR_REGISTER;

/**
  Bus Bank MCA Misc.
**/
#define JSL_MSR_BUS_CR_MCI_MISC 0x00000403

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecoverableAddressLsb : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               The lowest valid recoverable address bit.
                               Indicates the position of the least significant
                               bit of the recoverable error address. For
                               example, if the processor logs bits [43:9] of
                               the address, the LSB sub-field is 0b01001 (9
                               decimal). For this example, bits [8:0] of the
                               recoverable error address in BUS_CR_MCI_ADDR
                               should be ignored.
                            */
    UINT32 AddressMode : 3;

                            /* Bits[8:6], Access Type=RW, default=0x00000000*/

                            /*
                               Address mode for the address logged in
                               BUS_CR_MCI_ADDR. The supported address modes
                               are: Segment Offset(000) Linear Address(001)
                               Physical Address(010) Memory Address(011)
                               Generic(111) Reserved(100 to 110)
                            */
    UINT32 ModelSpecific63to90 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 ModelSpecific63to91 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* not defined */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BUS_CR_MCI_MISC_REGISTER;

/**
  L2 MCA Control Register. MRM b1598713:Dont #GP on writing ones to the upper part of MCi_CTL because the software model always write one to the whole 64bit
**/
#define JSL_MSR_L2_CR_MCI_CTL 0x00000404

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enables reporting of MCA errors to Hard Error */
    UINT32 Reserved1 : 31;

                            /* Bits[31:1], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_L2_CR_MCI_CTL_REGISTER;

/**
  L2 MCA Status Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_L2_CR_MCI_STATUS 0x00000405

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               MCA code. C6 review seemed to indicate that
                               these bits are rsvd0 but in RTL these are used
                            */
    UINT32 Mcaw : 5;

                            /* Bits[20:16], Access Type=RW, default=0x00000000*/

                            /* MCA Way !! C6 Note:Should be rw */
    UINT32 EccSyndrome : 10;

                            /* Bits[30:21], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 EccSyndromeChunkId : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* assumes max of 2 chunks */
    UINT32 McacValid : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 Mcac : 2;

                            /* Bits[34:33], Access Type=RW, default=0x00000000*/

                            /*
                               MCA Core ID !!; 2'b11 denotes core 3, 2'b10
                               denotes core 2, 2'b01 denotes core 1; 2'b00
                               denotes core 0 C6 Note:Should be rw
                            */
    UINT32 Mscod : 2;

                            /* Bits[36:35], Access Type=RW, default=0x00000000*/

                            /*
                               Model Specific error code, in addition to MCA
                               code. !! C6 Note:Should be rw
                            */
    UINT32 Fw : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* undefined */
    UINT32 McErrorCount : 14;

                            /* Bits[51:38], Access Type=RW, default=0x00000000*/

                            /*
                               counting filtered correctable MCA errors !! C6
                               Note:Should be rw
                            */
    UINT32 McErrorCountOverflowBit : 1;

                            /* Bits[52:52], Access Type=RW, default=0x00000000*/

                            /*
                               counting filtered correctable MCA errors !! C6
                               Note:Should be rw
                            */
    UINT32 McGreenBit : 1;

                            /* Bits[53:53], Access Type=RW, default=0x00000001*/

                            /*
                               indicates parts health only when
                               SINGLE_MCA_LOGGING_MODE_RANGE = 00 !! C6
                               Note:Should be rw
                            */
    UINT32 McYellowBit : 1;

                            /* Bits[54:54], Access Type=RW, default=0x00000000*/

                            /* indicates parts health !! C6 Note:Should be rw */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW, default=0x00000000*/

                            /* Recovery action required for UCR error */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /* Signaling an uncorrectable recoverable error */
    UINT32 McPccBit : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /*
                               Processor Context Corruption, always 1 with an
                               uncorrectable error !! C6 Note:Should be rw
                            */
    UINT32 McAddrvBit : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /*
                               Address/State/LRU had ECC error !! C6
                               Note:Should be rw
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /* L2_CR_MCI_MISC is valid */
    UINT32 McEnBit : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /* any ECC error detected !! C6 Note:Should be rw */
    UINT32 McUcBit : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               uncorrectable ECC error detected !! C6
                               Note:Should be rw
                            */
    UINT32 McOvwrBit : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               new ECC error overwriting old ECC error !! C6
                               Note:Should be rw
                            */
    UINT32 McValidBit : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               MC is valid due to any ECC error detected !! C6
                               Note:Should be rw
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_L2_CR_MCI_STATUS_REGISTER;

/**
  L2 MCA Address Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_L2_CR_MCI_ADDR 0x00000406

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McaAddr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* MCA Address MCA Control Register */
    UINT32 McaAddr1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* MCA Address MCA Control Register */
    UINT32 ModelSpecific63to42 : 22;

                            /* Bits[63:42], Access Type=RW, default=0x00000000*/

                            /* not defined */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_L2_CR_MCI_ADDR_REGISTER;

/**
  L2 Bank MCA Misc.
**/
#define JSL_MSR_L2_CR_MCI_MISC 0x00000407

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecoverableAddressLsb : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               The lowest valid recoverable address bit.
                               Indicates the position of the least significant
                               bit of the recoverable error address. For
                               example, if the processor logs bits [43:9] of
                               the address, the LSB sub-field is 0b01001 (9
                               decimal). For this example, bits [8:0] of the
                               recoverable error address in L2_CR_MCI_ADDR
                               should be ignored.
                            */
    UINT32 AddressMode : 3;

                            /* Bits[8:6], Access Type=RW, default=0x00000000*/

                            /*
                               Address mode for the address logged in
                               L2_CR_MCI_ADDR. The supported address modes are:
                               Segment Offset(000) Linear Address(001) Physical
                               Address(010) Memory Address(011) Generic(111)
                               Reserved(100 to 110)
                            */
    UINT32 ModelSpecific63to90 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /* not defined */
    UINT32 ModelSpecific63to91 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* not defined */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_L2_CR_MCI_MISC_REGISTER;
/**
  MCA Control Register. MRM b1598713:Dont #GP on writing ones to the upper part of MCi_CTL because the software model always write one to the whole 64bit
**/
#define JSL_MSR_IC_CR_MCI_CTL 0x00000408

/**
  MCA Status Register. Only a write of all 0s is allowed by WRMSR ucode. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E.
**/
#define JSL_MSR_IC_CR_MCI_STATUS 0x00000409

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McaErrorCode : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* MCA ERROR CODE tells what kind of error */
    UINT32 ModelSpecificErrorCode : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /*
                               MODEL_SPECIFIC ERROR CODE tells us information
                               specific to this model
                            */
    UINT32 OtherInfo : 5;

                            /* Bits[36:32], Access Type=RW, default=0x00000000*/

                            /*
                               RESERVED for "other information" which we do not
                               have
                            */
    UINT32 Fw : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Firmware updated error status indicator */
    UINT32 CorrectedErrorCount : 15;

                            /* Bits[52:38], Access Type=RW, default=0x00000000*/

                            /*
                               CORRECTED_ERROR_COUNT tell us the number of
                               corrected errors
                            */
    UINT32 ThresholdBasedErrorStatus : 2;

                            /* Bits[54:53], Access Type=RW, default=0x00000000*/

                            /* Threshold Based Error Status (0 for FEC) */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW, default=0x00000000*/

                            /* AR - Action Required */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /*
                               S - Signaling an unccrrected recoverable (UCR)
                               error
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /*
                               Processor Context Corrupt - tells us processor
                               state may have been corrupted by this MCA event
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /* MCI_ADDR register holds valid data */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /* MCI_MISC register holds valid data */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /*
                               MCI_CTL register has the associated Error Enable
                               bit set
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               Uncorrected Error - signifies the error we're
                               reporting went uncorrected
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               OVER - machine check overflow, there was another
                               error already written to this reg which is still
                               in the handler (ie the VAL bit was already set
                               when this error occurred)
                            */
    UINT32 Val : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               VALid bit - tells us the information in this
                               register is for a valid error report
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IC_CR_MCI_STATUS_REGISTER;

/**
  MCA Address Register. Only a write of all 0s is allowed by WRMSR ucode. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E. The creg is restored during C6 restore.
**/
#define JSL_MSR_IC_CR_MCI_ADDR 0x0000040A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Linear Address[47:0] for I$ or ITAG and Physical
                               Address [39:0] for SNOOP ITAG PARITY ERROR
                            */
    UINT32 Address1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Linear Address[47:0] for I$ or ITAG and Physical
                               Address [39:0] for SNOOP ITAG PARITY ERROR
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=RW, default=0x00000000*/

                            /* Reserved for future use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IC_CR_MCI_ADDR_REGISTER;

/**
  MCA MISC Register for CMCI. The creg is restored during C6 restore.
**/
#define JSL_MSR_IC_CR_MCI_MISC 0x0000040B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecoverableAddressLsb : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /* Lowest valid recoverable address bit */
    UINT32 AddressMode : 3;

                            /* Bits[8:6], Access Type=RW, default=0x00000000*/

                            /* Address mode for the address logged in MCI_ADDR */
    UINT32 ModelSpecificInformation0 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /* Reserved for future use */
    UINT32 ModelSpecificInformation1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved for future use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IC_CR_MCI_MISC_REGISTER;

/**
  MCA Control Register. MRM b1598713:Dont #GP on writing ones to the upper part of MCi_CTL because the software model always write one to the whole 64bit
**/
#define JSL_MSR_MEC_CR_MCI_CTL 0x0000040C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 L1DataPerrUncorr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* enable uncorrectable cache errors */
    UINT32 L1TagPerrUncorr : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* enable uncorrectable cache errors */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=Rsvd0, default=None*/

                            /* unimplemented bits */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=Rsvd0, default=None*/

                            /* unimplemented bits */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MEC_CR_MCI_CTL_REGISTER;

/**
  MCA Status Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E.
**/
#define JSL_MSR_MEC_CR_MCI_STATUS 0x0000040D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McaErrorCode : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* machine check error code */
    UINT32 ModelSpecificErrorCode : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* model specific error code */
    UINT32 OtherInfo : 5;

                            /* Bits[36:32], Access Type=RW, default=0x00000000*/

                            /* model specific error information */
    UINT32 FmwrUpdatedErrStatus : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Firmware updated error status indicator */
    UINT32 CorrectedErrorCount : 15;

                            /* Bits[52:38], Access Type=RW, default=0x00000000*/

                            /* Corrected error count */
    UINT32 ThrshldBasedErrStatus : 2;

                            /* Bits[54:53], Access Type=RW, default=0x00000000*/

                            /* Threshold based error status */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RW, default=0x00000000*/

                            /* Recovery action requried for UCR error */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /* Signaling an UCR error */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RW, default=0x00000000*/

                            /* processor context corrupt */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RW, default=0x00000000*/

                            /* mci_address is valid */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /* mci_misc is valid */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /* error was enabled */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /* error was uncorrectable */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* bank overflowed (you missed one) */
    UINT32 Val : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* valid bit for the bank */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MEC_CR_MCI_STATUS_REGISTER;

/**
  MCA Address Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_MEC_CR_MCI_ADDR 0x0000040E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* the address in the address register */
    UINT32 Address1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* the address in the address register */
    UINT32 ModelSpecific : 22;

                            /* Bits[63:42], Access Type=RW, default=0x00000000*/

                            /* Unused bits in the address register */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MEC_CR_MCI_ADDR_REGISTER;

/**
  MCA MISC Register. WRMSR uCode generates #GP on non-zero writes. SKL i1350467: Allow WRMSR to update all bits if PPPE_ACTIVE. GLM i1958673 (Microserver MCA Enhancements):Allow WRMSR to update all bits if DEBUG_ERR_INJ_CTL.MCBW_E
**/
#define JSL_MSR_MEC_CR_MCI_MISC 0x0000040F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecoverableAddressLsb : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates position of the LSB of the recoverable
                               error address
                            */
    UINT32 AddrMode : 3;

                            /* Bits[8:6], Access Type=RW, default=0x00000000*/

                            /* Bus lock operatio got poison or go-err */
    UINT32 ModelSpecificInfo0 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /* Bus lock operatio got poison or go-err */
    UINT32 ModelSpecificInfo1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Bus lock operatio got poison or go-err */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_MEC_CR_MCI_MISC_REGISTER;
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC04_CTL 0x00000410
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC04_STATUS 0x00000411
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC04_ADDR 0x00000412
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC04_MISC 0x00000413
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC05_CTL 0x00000414
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC05_STATUS 0x00000415
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC05_ADDR 0x00000416
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC05_MISC 0x00000417
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC06_CTL 0x00000418
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC06_STATUS 0x00000419
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC06_ADDR 0x0000041A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC06_MISC 0x0000041B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC07_CTL 0x0000041C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC07_STATUS 0x0000041D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC07_ADDR 0x0000041E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC07_MISC 0x0000041F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC08_CTL 0x00000420
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC08_STATUS 0x00000421
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC08_ADDR 0x00000422
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC08_MISC 0x00000423
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC09_CTL 0x00000424
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC09_STATUS 0x00000425
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC09_ADDR 0x00000426
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC09_MISC 0x00000427
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC10_CTL 0x00000428
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC10_STATUS 0x00000429
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC10_ADDR 0x0000042A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC10_MISC 0x0000042B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC11_CTL 0x0000042C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC11_STATUS 0x0000042D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC11_ADDR 0x0000042E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC11_MISC 0x0000042F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC12_CTL 0x00000430
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC12_STATUS 0x00000431
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC12_ADDR 0x00000432
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC12_MISC 0x00000433
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC13_CTL 0x00000434
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC13_STATUS 0x00000435
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC13_ADDR 0x00000436
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC13_MISC 0x00000437
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC14_CTL 0x00000438
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC14_STATUS 0x00000439
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC14_ADDR 0x0000043A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC14_MISC 0x0000043B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC15_CTL 0x0000043C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC15_STATUS 0x0000043D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC15_ADDR 0x0000043E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC15_MISC 0x0000043F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC16_CTL 0x00000440
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC16_STATUS 0x00000441
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC16_ADDR 0x00000442
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC16_MISC 0x00000443
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC17_CTL 0x00000444
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC17_STATUS 0x00000445
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC17_ADDR 0x00000446
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC17_MISC 0x00000447
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC18_CTL 0x00000448
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC18_STATUS 0x00000449
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC18_ADDR 0x0000044A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC18_MISC 0x0000044B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC19_CTL 0x0000044C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC19_STATUS 0x0000044D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC19_ADDR 0x0000044E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC19_MISC 0x0000044F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC20_CTL 0x00000450
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC20_STATUS 0x00000451
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC20_ADDR 0x00000452
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC20_MISC 0x00000453
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC21_CTL 0x00000454
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC21_STATUS 0x00000455
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC21_ADDR 0x00000456
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC21_MISC 0x00000457
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC22_CTL 0x00000458
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC22_STATUS 0x00000459
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC22_ADDR 0x0000045A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC22_MISC 0x0000045B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC23_CTL 0x0000045C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC23_STATUS 0x0000045D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC23_ADDR 0x0000045E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC23_MISC 0x0000045F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC24_CTL 0x00000460
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC24_STATUS 0x00000461
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC24_ADDR 0x00000462
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC24_MISC 0x00000463
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC25_CTL 0x00000464
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC25_STATUS 0x00000465
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC25_ADDR 0x00000466
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC25_MISC 0x00000467
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC26_CTL 0x00000468
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC26_STATUS 0x00000469
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC26_ADDR 0x0000046A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC26_MISC 0x0000046B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC27_CTL 0x0000046C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC27_STATUS 0x0000046D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC27_ADDR 0x0000046E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC27_MISC 0x0000046F
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC28_CTL 0x00000470
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC28_STATUS 0x00000471
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC28_ADDR 0x00000472
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC28_MISC 0x00000473
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC29_CTL 0x00000474
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC29_STATUS 0x00000475
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC29_ADDR 0x00000476
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC29_MISC 0x00000477
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC30_CTL 0x00000478
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC30_STATUS 0x00000479
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC30_ADDR 0x0000047A
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC30_MISC 0x0000047B
/**
  Virtual Creg describing the architectural format of the MCi_CTL register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC31_CTL 0x0000047C
/**
  Virtual Creg describing the architectural format of the MCi_STATUS register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC31_STATUS 0x0000047D
/**
  Virtual Creg describing the architectural format of the MCi_ADDR register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC31_ADDR 0x0000047E
/**
  Virtual Creg describing the architectural format of the MCi_MISC register in each bank
**/
#define JSL_MSR_UNCORE_CR_MC31_MISC 0x0000047F

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_0 0x00000480

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 VmcsRevisionIdentifier : 32;

                            /* Bits[31:0], Access Type=Rsvd0, default=0x00000013*/

                            /* need to define them */
    UINT32 LengthOfVmcsRegion : 16;

                            /* Bits[47:32], Access Type=Rsvd0, default=0x00000500*/

                            /* VMCS Size 1.25kB */
    UINT32 PhysicalAddressRange32 : 1;

                            /* Bits[48:48], Access Type=Rsvd0, default=0x00000000*/

                            /* need to define them */
    UINT32 ParallelMonitorSupport : 1;

                            /* Bits[49:49], Access Type=Rsvd0, default=0x00000001*/

                            /* need to define them */
    UINT32 VmcsMemoryType : 4;

                            /* Bits[53:50], Access Type=Rsvd0, default=0x00000006*/

                            /* need to define them */
    UINT32 ReportsVmexitOfInsOuts : 1;

                            /* Bits[54:54], Access Type=Rsvd0, default=0x00000001*/

                            /* need to define them */
    UINT32 ExtendedVmxControls : 1;

                            /* Bits[55:55], Access Type=Rsvd0, default=0x00000001*/

                            /* Extended VMX Control MSRs are supported */
    UINT32 Reserved56 : 8;

                            /* Bits[63:56], Access Type=Rsvd0, default=0x00000000*/

                            /* need to define them */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_0_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_1 0x00000481

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsPinControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000016*/

                            /* need to define them */
    UINT32 ExternalInterruptExiting : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 HostInterruptFlag : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 InitExiting : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 NmiExiting : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SipiExiting : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 VirtualNmi : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ActivateVmxPreemptionTimer : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 PostedInterruptsProcessing : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd40 : 24;

                            /* Bits[63:40], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_1_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_2 0x00000482

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsProcessorControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x0401E172*/

                            /* need to define them */
    UINT32 Allowed1SettingsProcessorControls : 32;

                            /* Bits[63:32], Access Type=RO, default=0xFFF9FFFE*/

                            /* need to define them */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_2_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_3 0x00000483

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsVmexitControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00036DFF*/

                            /* need to define them */
    UINT32 SaveCr0AndCr4 : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveCr3 : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveDebugControls : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveSegmentRegisters : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveEspEipEflags : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SavePendingDebugExceptions : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveInterruptibilityInfo : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveActivityState : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveWorkingVmcsPointer : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 HostAddressSpaceSize : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr0AndCr4 : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr3 : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPerfGlobalControl : 1;

                            /* Bits[44:44], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSegmentRegisters : 1;

                            /* Bits[45:45], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadEspEip : 1;

                            /* Bits[46:46], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 AckIntOnExit : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveSysenterMsr : 1;

                            /* Bits[48:48], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSysenterMsr : 1;

                            /* Bits[49:49], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveGuestPat : 1;

                            /* Bits[50:50], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadHostPat : 1;

                            /* Bits[51:51], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveGuestEfer : 1;

                            /* Bits[52:52], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestEfer : 1;

                            /* Bits[53:53], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveVmxPreemptionTimer : 1;

                            /* Bits[54:54], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ClearBndcfgs : 1;

                            /* Bits[55:55], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 RtitSuppressPip : 1;

                            /* Bits[56:56], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 ClearIa32RtitCtl : 1;

                            /* Bits[57:57], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd58 : 6;

                            /* Bits[63:58], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_3_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_4 0x00000484

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsVmentryControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x000011FF*/

                            /* need to define them */
    UINT32 LoadCr0Cr4 : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr3 : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadDebugControls : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSegmentRegisters : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadEspEipEflags : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPendingDebugRegisters : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadInterruptibilityInfo : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadActivityState : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadWorkingVmcsPointer : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LongModeGuest : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EntryToSmm : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 DeactivateDualMonitor : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSysenterMsr : 1;

                            /* Bits[44:44], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPerfGlobalCtrl : 1;

                            /* Bits[45:45], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestPat : 1;

                            /* Bits[46:46], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestEfer : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadBndcfgs : 1;

                            /* Bits[48:48], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 RtitSuppressPip : 1;

                            /* Bits[49:49], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 LoadIa32RtitCtl : 1;

                            /* Bits[50:50], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_4_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_5 0x00000485

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PreemptionTimerRate : 5;

                            /* Bits[4:0], Access Type=RO, default=0x00000007*/

                            /*
                               The TSC bit with which the Preemption timer
                               counts
                            */
    UINT32 ExitsStoreEferLma : 1;

                            /* Bits[5:5], Access Type=RO, default=0x00000001*/

                            /*
                               EFER.LMA is stored into "IA-32e mode guest" on
                               exit
                            */
    UINT32 ActivityStatesSupported : 8;

                            /* Bits[13:6], Access Type=RO, default=0x00000007*/

                            /* HLT,SHUTDOWN,WFS are supported */
    UINT32 RtitPostVmxon : 1;

                            /* Bits[14:14], Access Type=RO, default=0x00000000*/

                            /* RTIT is supported post VMXON */
    UINT32 SmbaseRdmsr : 1;

                            /* Bits[15:15], Access Type=RO, default=0x00000001*/

                            /* SLM e3430273 enumerating Rdmsr of 0x9E */
    UINT32 Cr3TargetValues : 9;

                            /* Bits[24:16], Access Type=RO, default=0x00000004*/

                            /* need to define them */
    UINT32 RecommendedMaxMsrsInMsrList : 3;

                            /* Bits[27:25], Access Type=RO, default=0x00000000*/

                            /*
                               Recommended maximum number of MSRs in load/store
                               MSR lists
                            */
    UINT32 VmxoffctrlFeatureEnable : 1;

                            /* Bits[28:28], Access Type=RO, default=0x00000001*/

                            /*
                               Signals the VMXOFFCTRL is a writable bit in the
                               LT_MSEG_BASE_ADDRESS.
                            */
    UINT32 VmwriteReadOnlyFields : 1;

                            /* Bits[29:29], Access Type=RO, default=0x00000001*/

                            /*
                               The read-only restriction on certain VMCS fields
                               is removed
                            */
    UINT32 VoeZeroInstrLength : 1;

                            /* Bits[30:30], Access Type=RO, default=0x00000001*/

                            /*
                               Allow 0 as legal value for VOE Instruction
                               Length for VOE with type 4/5/6 vector
                            */
    UINT32 Reserved31 : 1;

                            /* Bits[31:31], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 MsegRevisionId : 32;

                            /* Bits[63:32], Access Type=RO, default=0x00000000*/

                            /* need to define them */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_5_REGISTER;
/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_6 0x00000486
/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_7 0x00000487
/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_8 0x00000488

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_9 0x00000489

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vme : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Pvi : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Tsd : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 De : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Pse : 1;

                            /* Bits[4:4], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Pae : 1;

                            /* Bits[5:5], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Mce : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Pge : 1;

                            /* Bits[7:7], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Pce : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Osfxsr : 1;

                            /* Bits[9:9], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Xmmexc : 1;

                            /* Bits[10:10], Access Type=RO, default=0x00000001*/

                            /*
                               Enables the exceptions for Katmia new
                               instructions.
                            */
    UINT32 Umip : 1;

                            /* Bits[11:11], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Rsvd12 : 1;

                            /* Bits[12:12], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 VmxEnable : 1;

                            /* Bits[13:13], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 SmxEnable : 1;

                            /* Bits[14:14], Access Type=RO, default=0x00000000*/

                            /* See X86_CR_CR4 */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Fsgsbase : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Rsvd17 : 1;

                            /* Bits[17:17], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Osxsave : 1;

                            /* Bits[18:18], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Smep : 1;

                            /* Bits[20:20], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Smap : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000001*/

                            /* See X86_CR_CR4 */
    UINT32 Rsvd22 : 10;

                            /* Bits[31:22], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_9_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_10 0x0000048A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HighestIndexForVmcsEncoding : 10;

                            /* Bits[9:0], Access Type=RO, default=0x0000002E*/

                            /* need to define them */
    UINT32 Rsvd10 : 6;

                            /* Bits[15:10], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_10_REGISTER;

/**
  VAPIC:LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_11 0x0000048B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsSecondaryProcessorControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 VirtualizeApicAccess : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EnableEpt : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 DescriptorTableExiting : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EnableRdtscp : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 VirtualizeX2apic : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EnableVpid : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 WbinvdExiting : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 UnrestrictedGuest : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ApicRegisterVirtualization : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 VirtualInterruptDelivery : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 PauseLoopExiting : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 RdrandExiting : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd44 : 1;

                            /* Bits[44:44], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 VmfuncEnable : 1;

                            /* Bits[45:45], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 VmcsShadowing : 1;

                            /* Bits[46:46], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 EnclEnable : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 RdseedExiting : 1;

                            /* Bits[48:48], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd49 : 1;

                            /* Bits[49:49], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Bp2 : 1;

                            /* Bits[50:50], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ConcealRtitVmx : 1;

                            /* Bits[51:51], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 XsavesXrstors : 1;

                            /* Bits[52:52], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd53 : 1;

                            /* Bits[53:53], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MbeEnable : 1;

                            /* Bits[54:54], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SppEnable : 1;

                            /* Bits[55:55], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Pt2gpa : 1;

                            /* Bits[56:56], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 UseRdtscScaling : 1;

                            /* Bits[57:57], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 UserLevelMwait : 1;

                            /* Bits[58:58], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd59 : 1;

                            /* Bits[59:59], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnableEnclv : 1;

                            /* Bits[60:60], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 EnableEpcVirtualizationExtensions : 1;

                            /* Bits[61:61], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd62 : 2;

                            /* Bits[63:62], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_11_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_12 0x0000048C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SupportsEptExecuteOnly : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd1 : 5;

                            /* Bits[5:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Supports4levelEptWalk : 1;

                            /* Bits[6:6], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd7 : 1;

                            /* Bits[7:7], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsUcEptMemtype : 1;

                            /* Bits[8:8], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd9 : 5;

                            /* Bits[13:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsWbEptMemtype : 1;

                            /* Bits[14:14], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Supports2mbEptPages : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Supports1gbEptPages : 1;

                            /* Bits[17:17], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd18 : 2;

                            /* Bits[19:18], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsInvept : 1;

                            /* Bits[20:20], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EnableEptAdBits : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 EptViolationExitSavesAdditionalState : 1;

                            /* Bits[22:22], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd23 : 2;

                            /* Bits[24:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsSingleContextInvept : 1;

                            /* Bits[25:25], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SupportsAllContextInvept : 1;

                            /* Bits[26:26], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsInvvpid : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd33 : 7;

                            /* Bits[39:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SupportsIndividualAddressInvvpid : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SupportsSingleContextInvvpid : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SupportsAllContextInvvpid : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SupportsSingleContextRetainGlobalsInvvpid : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_12_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_13 0x0000048D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsTruePinControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000016*/

                            /* need to define them */
    UINT32 ExternalInterruptExiting : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 HostInterruptFlag : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 InitExiting : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 NmiExiting : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SipiExiting : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 VirtualNmi : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ActivateVmxPreemptionTimer : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 PostedInterruptsProcessing : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd40 : 24;

                            /* Bits[63:40], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_13_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_14 0x0000048E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsTrueProcessorControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x04006172*/

                            /* need to define them */
    UINT32 Allowed1SettingsTrueProcessorControls : 32;

                            /* Bits[63:32], Access Type=RO, default=0xFFF9FFFE*/

                            /* need to define them */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_14_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_15 0x0000048F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsTrueVmexitControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00036DFB*/

                            /* need to define them */
    UINT32 SaveCr0AndCr4 : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveCr3 : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveDebugControls : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveSegmentRegisters : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveEspEipEflags : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SavePendingDebugExceptions : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveInterruptibilityInfo : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveActivityState : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveWorkingVmcsPointer : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 HostAddressSpaceSize : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr0AndCr4 : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr3 : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPerfGlobalControl : 1;

                            /* Bits[44:44], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSegmentRegisters : 1;

                            /* Bits[45:45], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadEspEip : 1;

                            /* Bits[46:46], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 AckIntOnExit : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveSysenterMsr : 1;

                            /* Bits[48:48], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSysenterMsr : 1;

                            /* Bits[49:49], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveGuestPat : 1;

                            /* Bits[50:50], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadHostPat : 1;

                            /* Bits[51:51], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveGuestEfer : 1;

                            /* Bits[52:52], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestEfer : 1;

                            /* Bits[53:53], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 SaveVmxPreemptionTimer : 1;

                            /* Bits[54:54], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 ClearBndcfgs : 1;

                            /* Bits[55:55], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 RtitSuppressPip : 1;

                            /* Bits[56:56], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 ClearIa32RtitCtl : 1;

                            /* Bits[57:57], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd58 : 6;

                            /* Bits[63:58], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_15_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_16 0x00000490

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Allowed0SettingsTrueVmentryControls : 32;

                            /* Bits[31:0], Access Type=RO, default=0x000011FB*/

                            /* need to define them */
    UINT32 LoadCr0Cr4 : 1;

                            /* Bits[32:32], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadCr3 : 1;

                            /* Bits[33:33], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadDebugControls : 1;

                            /* Bits[34:34], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSegmentRegisters : 1;

                            /* Bits[35:35], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadEspEipEflags : 1;

                            /* Bits[36:36], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPendingDebugRegisters : 1;

                            /* Bits[37:37], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadInterruptibilityInfo : 1;

                            /* Bits[38:38], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadActivityState : 1;

                            /* Bits[39:39], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadWorkingVmcsPointer : 1;

                            /* Bits[40:40], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LongModeGuest : 1;

                            /* Bits[41:41], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 EntryToSmm : 1;

                            /* Bits[42:42], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 DeactivateDualMonitor : 1;

                            /* Bits[43:43], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadSysenterMsr : 1;

                            /* Bits[44:44], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadPerfGlobalCtrl : 1;

                            /* Bits[45:45], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestPat : 1;

                            /* Bits[46:46], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadGuestEfer : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000001*/

                            /* need to define them */
    UINT32 LoadBndcfgs : 1;

                            /* Bits[48:48], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 RtitSuppressPip : 1;

                            /* Bits[49:49], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 LoadIa32RtitCtl : 1;

                            /* Bits[50:50], Access Type=RO, default=0x00000000*/

                            /* need to define them */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_16_REGISTER;

/**
  LT-VMX Capability MSR - no CR address . This MSR is read only; uCode generates #GP on any write
**/
#define JSL_MSR_VMX_CR_MSR_BASE_17 0x00000491

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 VmfuncEptpSwitchSupport : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /* VMFUNC EPTP SWITCH is supported */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VMX_CR_MSR_BASE_17_REGISTER;

/**
  This is an alias for the general purpose counter 0. It allows the full 48-bit WRMSR
**/
#define JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR0 0x000004C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter0Lo : 6;

                            /* Bits[5:0], Access Type=RW, default=0x00000000*/

                            /*
                               Lower 6 bits of 48-bit general counter 0. Only
                               lower 6 bits are duplicated in ARR1 for PEBS
                               PDIR.
                            */
    UINT32 GpCounter0Hi0 : 26;

                            /* Bits[31:6], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 0. Full
                               48-bit writes supported.
                            */
    UINT32 GpCounter0Hi1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 0. Full
                               48-bit writes supported.
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. Unlike the legacy counter (0x0c1),
                               WRMSR will gp fault on writes of 1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR0_REGISTER;

/**
  This is an alias for the PerfMon General Purpose counter 1. It allows the full 48-bit WRMSR
**/
#define JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR1 0x000004C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter1Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 1. Full
                               48-bit writes supported.
                            */
    UINT32 GpCounter1Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 1. Full
                               48-bit writes supported.
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. Unlike the legacy counter (0x0c2),
                               WRMSR will gp fault on writes of 1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR1_REGISTER;

/**
  This is an alias for the general purpose counter 2. It allows the full 48-bit WRMSR
**/
#define JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR2 0x000004C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter2Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose (GP) counter 2.
                               Full 48-bit writes supported.
                            */
    UINT32 GpCounter2Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose (GP) counter 2.
                               Full 48-bit writes supported.
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. Unlike the legacy counter (0x0c3),
                               WRMSR will gp fault on writes of 1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR2_REGISTER;

/**
  This is an alias for the PerfMon General Purpose counter 3. It allows the full 48-bit WRMSR
**/
#define JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR3 0x000004C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 GpCounter3Value0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 3. Full
                               48-bit writes supported.
                            */
    UINT32 GpCounter3Value1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               48-bit PerfMon General Purpose counter 3. Full
                               48-bit writes supported.
                            */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Reserved. Unlike the legacy counter (0x0c4),
                               WRMSR will gp fault on writes of 1.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_BNL_CR_PERFMON_GP_FULL_CTR3_REGISTER;

/**
  This CSR holds enable bits for on-chip storage of SMM and
  Code Access Check Violation features.
**/
#define JSL_MSR_CORE_INTERFACE_CR_SMM_FEATURE_CONTROL 0x000004E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               If Lock = 1, CPU will drop writes to the
                               register If Lock = 0, CPU will allow update to
                               b[2:0]
                            */
    UINT32 SmmCpuSaveEn : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               If 0, SMI/RSM will save/restore state in SMRAM
                               If 1, SMI/RSM will save/restore state from SRAM
                            */
    UINT32 SmmCodeChkEn : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               If 1, generate unrecoverable MCHK on code fetch
                               outside SMRRs If 0, do not report any errors for
                               code fetch outside SMRRs
                            */
    UINT32 Rsvd3 : 29;

                            /* Bits[31:3], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_SMM_FEATURE_CONTROL_REGISTER;

/**
  This CSR contains bit per logical processor indicating whether the logical processor is in the middle of long flow and hence will delay servicing of SMI. SMI will be serviced after the long flow completes execution.
**/
#define JSL_MSR_T_CR_SMM_DELAYED 0x000004E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DelayedCount : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This bit will be set when the logical processor
                               is in the following states Wait For SIPI SENTER
                               Sleep VMX Abort Error Shutdown Machine check in
                               WFS state This bit will only exist for logical
                               processors that exist tied to number of logical
                               processors in the system. It is undefined for
                               processors that dont exist.
                            */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_T_CR_SMM_DELAYED_REGISTER;

/**
  This CSR contains bit per logical processor indicating whether the logical processor is in state where SMIs are blocked and hence will not be able to service SMI. SMI can be serviced after the logical processor exits the state in which SMIs are blocked
**/
#define JSL_MSR_T_CR_SMM_BLOCKED 0x000004E3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BlockedCount : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This bit will be set when the logical processor
                               is in the following states Wait For SIPI SENTER
                               Sleep VMX Abort Error Shutdown Machine check in
                               WFS state This bit will only exist for logical
                               processors that exist tied to number of logical
                               processors in the system. It is undefined for
                               processors that dont exist.
                            */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_T_CR_SMM_BLOCKED_REGISTER;
/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_CORE_INTERFACE_CR_SMM_ENABLE_MATCH 0x000004E8
/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_CORE_INTERFACE_CR_SMM_ENABLE_MASK 0x000004EA

/**

**/
#define JSL_MSR_FUNNYIO_CR_IA32_SE_SVN 0x00000500

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lock : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* LOCK (SE_EVER_USED) */
    UINT32 Rsvd1 : 15;

                            /* Bits[15:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SinitSeSvn : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000000*/

                            /* SENTER (SINIT) ACM SVN */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_IA32_SE_SVN_REGISTER;

/**
  GLM i1958945: package-scoped MSR. Only bit 0 is actual storage. An entire byte is reserved to avoid the need for a semaphore when writing to it. The bit will be saved and restored in C7+ states. The reset value for the bit is 0. It will not survive warm reset.
**/
#define JSL_MSR_FUNNYIO_CR_SGX_DEBUG_MODE 0x00000503

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NpkRequest : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Setting NPK_request to 1 triggers a request to
                               clear the SGX keys as in SE HSD i200560
                            */
    UINT32 NpkActive : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               RDMSR ucode reports the value from
                               BUS_CR_SE_CTL_SET_AND_STATUS[SE_DEBUG_ALLOWED].
                               Writes to NPK_Active will update this SCP, but
                               will be ignored by the RDMSR
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_FUNNYIO_CR_SGX_DEBUG_MODE_REGISTER;

/**
  used for VMEXIT redirection control
**/
#define JSL_MSR_SCP_CR_PROBE_MODE_4 0x00000504

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Interrupt : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               VMX redirection from SW interrupt, exception, or
                               NMI
                            */
    UINT32 ExtInterrupt : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from an external interrupt */
    UINT32 TripleFault : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from a triple-fault */
    UINT32 Init : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from an INIT */
    UINT32 Sipi : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from a SIPI */
    UINT32 IoSmi : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from an I/O-caused SMI */
    UINT32 Othersmi : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* VMX redirection from a non-I/O-caused SMI */
    UINT32 PndVirtInterrupt : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               VMX redirection because of a virtual interrupt
                               pending
                            */
    UINT32 Nmip : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to NMIP. */
    UINT32 TaskSwitch : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to a task switch */
    UINT32 Cpuid : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to CPUID */
    UINT32 Getsec : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to GETSEC execution */
    UINT32 Hlt : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of HLT */
    UINT32 Invd : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of INVD */
    UINT32 Invlpg : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of INVLPG */
    UINT32 Rdpmc : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of RDPMC */
    UINT32 Rdtsc : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of RDTSC */
    UINT32 Rsm : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of RSM */
    UINT32 Vmcall : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMCALL */
    UINT32 Vmclear : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMCLEAR */
    UINT32 Vmlaunch : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMLAUNCH */
    UINT32 Vmptrld : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMPTRLD */
    UINT32 Vmptrst : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of PMPTRST */
    UINT32 Vmread : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMREAD */
    UINT32 Vmresume : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMRESUME */
    UINT32 Vmwrite : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMWRITE */
    UINT32 Vmxoff : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMXOFF */
    UINT32 Vmxon : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to execution of VMXON */
    UINT32 CrAccess : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* Reserved. */
    UINT32 DrAccess : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               VMX redirection due to a move to/from a debug
                               register.
                            */
    UINT32 Ioexit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* VMX redirection because of an I/O instruction */
    UINT32 Rdmsr : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to an MSR read */
    UINT32 Wrmsr : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to an MSR write */
    UINT32 EntryBadguest : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /*
                               VMX redirection due to bad guest state on a
                               VMENTER
                            */
    UINT32 EntryBadmsr : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               VMX redirection due to a problem in loading MSRs
                               during a VMENTER
                            */
    UINT32 Exitfault : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to a failed VMEXIT */
    UINT32 Mwait : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to MWAIT */
    UINT32 Mtf : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to MTF */
    UINT32 CorruptedVmcs : 1;

                            /* Bits[38:38], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to corrupted VMCS */
    UINT32 Monitor : 1;

                            /* Bits[39:39], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to MONITOR */
    UINT32 Pause : 1;

                            /* Bits[40:40], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to PAUSE */
    UINT32 EntryMca : 1;

                            /* Bits[41:41], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to MCA */
    UINT32 CstateSmi : 1;

                            /* Bits[42:42], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to CSTATE SMI */
    UINT32 TprBelowThreshold : 1;

                            /* Bits[43:43], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to tpr below threshold */
    UINT32 ApicAccess : 1;

                            /* Bits[44:44], Access Type=RW, default=0x00000000*/

                            /* VMX redirection due to access APIC */
    UINT32 NotUsed : 19;

                            /* Bits[63:45], Access Type=RW, default=0x00000000*/

                            /* Unused bits. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PROBE_MODE_4_REGISTER;

/**
  used for VMEXIT redirection reason status. Changed to 32 bit MSR on GLm to match SKL.
**/
#define JSL_MSR_SCP_CR_PROBE_MODE_5 0x00000505

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* need to define them */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Not used. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PROBE_MODE_5_REGISTER;
/**
  This is special creg for Probe Mode, details later
**/
#define JSL_MSR_IA32_CR_PROBE_TLB_FLUSH 0x00000508

/**
  Extended Page Table Pointer
**/
#define JSL_MSR_PMH_CR_EPTP 0x00000510

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* EPT Memory Type */
    UINT32 Reserved3 : 3;

                            /* Bits[5:3], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 EptAdEn : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* EPT A/D enable bit */
    UINT32 Reserved7 : 4;

                            /* Bits[10:7], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 EptMbe : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* EPT Mode-Based Exec Enable */
    UINT32 Pml4Addr0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page-Map Level-4 Address */
    UINT32 Pml4Addr1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* Page-Map Level-4 Address */
    UINT32 Reserved42 : 21;

                            /* Bits[62:42], Access Type=Rsvd0, default=None*/

                            /* fill description here */
    UINT32 EptEn : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* EPT enable bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PMH_CR_EPTP_REGISTER;

/**
  Controls for which PDM events LBR data will be sent along with PDM packets if PDM and corresponding event is enabled in PDM_CTRL
**/
#define JSL_MSR_SCP_CR_PDM_LBR 0x00000511

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               On hardware interrupts, send LBR data along with
                               PDM packets
                            */
    UINT32 Iret : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* On IRETs, send LBR data along with PDM packets */
    UINT32 Exception : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               On exceptions, send LBR data along with PDM
                               packets
                            */
    UINT32 Msr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               On MSR accesses, send LBR data along with PDM
                               packets
                            */
    UINT32 PowerEvent : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               On power entry/exit events, send LBR data along
                               with PDM packets
                            */
    UINT32 PortInOut : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               On port-ins/port-outs, send LBR data along with
                               PDM packets
                            */
    UINT32 Se : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               On SE events, send LBR data along with PDM
                               packets
                            */
    UINT32 Wbinvd : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               On WBINVD entry/exit, send LBR data along with
                               PDM packets
                            */
    UINT32 Reserved8 : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 CodeBreakpoint : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               On code breakpoint send LBR data along with PDM
                               packets
                            */
    UINT32 DataBreakpoint : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               On data breakpoint send LBR data along with PDM
                               packets
                            */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 Btm : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM BTM event is enabled, send LBR data along
                               with PDM packets
                            */
    UINT32 SmiNmiRsmInitSipi : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               If respective PDM event is enabled, send LBR
                               data along with PDM packets
                            */
    UINT32 MonitorMwait : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               On MONITOR/MWAIT, send LBR data along with PDM
                               packets
                            */
    UINT32 Reserved15 : 13;

                            /* Bits[27:15], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 LipDisable : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* Disable LIP reporting with PDM packet */
    UINT32 RicDisable : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               Disable Retired Instruction Count (RIC)
                               reporting with PDM packet
                            */
    UINT32 Reserved30 : 2;

                            /* Bits[31:30], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 SendNlip : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               PDM ucode tendrils set this bit to indicate that
                               NLIP should be reported (software interrupts).
                               Tendrils leave it cleared if CLIP should be
                               reported
                            */
    UINT32 SuppressLip : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /*
                               PDM ucode tendrils set this bit if LIP should be
                               suppressed within PDM trace
                            */
    UINT32 Spare : 30;

                            /* Bits[63:34], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PDM_LBR_REGISTER;

/**
  Controls which events are enabled for PDM (Probeless Debug Methodology).  When PDM is enabled, it is a debug hook which causes the processor to dump CPU or other state when certain events or instructions are executed.  This SCP specifies which events will trigger state dump when PDM is enabled.
**/
#define JSL_MSR_SCP_CR_PDM_CTRL 0x00000512

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use hardware interrupt as a
                               trigger for PDM to dump CPU state
                            */
    UINT32 Iret : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use IRET instruction as a
                               trigger for PDM to dump CPU state
                            */
    UINT32 Exception : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, exceptions are a trigger for
                               PDM to dump CPU state
                            */
    UINT32 Msr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use RD/WRMSR instructions as
                               a trigger for PDM to dump CPU state
                            */
    UINT32 PowerEvent : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, PDM packets are triggered for
                               power entry/exit flows
                            */
    UINT32 PortInOut : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use port in/out instructions
                               as a trigger for PDM to dump CPU state
                            */
    UINT32 Se : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use Enclave exit and entry as
                               a trigger for PDM to dump CPU state
                            */
    UINT32 Wbinvd : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, WBINVD entry/exit are
                               triggers for PDM to dump CPU state
                            */
    UINT32 Reserved8 : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 CodeBreakpoint : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use code-breakpoints as a
                               trigger for PDM to dump CPU state
                            */
    UINT32 DataBreakpoint : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use data-breakpoints as a
                               trigger for PDM to dump CPU state
                            */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 Btm : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use Branch Trace Messages
                               (BTM) as a trigger for PDM to dump CPU state
                            */
    UINT32 SmiNmiRsmInitSipi : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use SMI, NMI, and RSM as
                               triggers for PDM to dump CPU state
                            */
    UINT32 MonitorMwait : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               If PDM is enabled, use MONITOR and MWAIT as
                               triggers for PDM to dump CPU state
                            */
    UINT32 Reserved15 : 15;

                            /* Bits[29:15], Access Type=RW, default=0x00000000*/

                            /* RESERVED */
    UINT32 Dest : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               GLP e1404625920: This bit controls whether AET
                               data is sent out as port_outs or MMIO. If bit is
                               cleared, AET data is sent as port_outs, else if
                               DEST bit is set and MSR(0x80).LOCK bit is also
                               set AET data is sent as store_physicals, else
                               AET data is dropped
                            */
    UINT32 MasterEn : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* PDM Master Enable */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PDM_CTRL_REGISTER;

/**
  PPPE Redirection info used for Probe Mode
**/
#define JSL_MSR_SCP_CR_PROBE_MODE_PPPE_REDIRECTION_INFO 0x00000513

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_PROBE_MODE_PPPE_REDIRECTION_INFO_REGISTER;

/**
  Probe Mode saves/restores the details of the last interruptible micro-code flow. Probe Mode user can cannot change it. Intel Labs can change the contents for debug.
**/
#define JSL_MSR_SCP_CR_ICECTLPMR_PRIOR_STATE 0x00000520

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ReturnUip : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               contains the return uip used by nested flows
                               such as LTL, Probe Mode
                            */
    UINT32 Reserved15 : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 PriorStateCodesUrl : 7;

                            /* Bits[22:16], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 UseReturnUip : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Probe Mode has to return to the originating flow
                               as opposed to the next EIP.
                            */
    UINT32 Reserved24 : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_ICECTLPMR_PRIOR_STATE_REGISTER;

/**
  AET base address. programmed by probe mode software. Ucode will use it as the address where it will send all PDM messages.
**/
#define JSL_MSR_C6_SCP_CR_AET_BASE 0x00000521

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Valid : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Valid. Ucode will write PDMs only if valid is
                               set
                            */
    UINT32 Rsvd1 : 5;

                            /* Bits[5:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Address0 : 26;

                            /* Bits[31:6], Access Type=RW, default=0x00000000*/

                            /*
                               Base address for AET. CNL 1203390950 Signal #GP
                               if any of the unsupported physical address bits
                               are set
                            */
    UINT32 Address1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Base address for AET. CNL 1203390950 Signal #GP
                               if any of the unsupported physical address bits
                               are set
                            */
    UINT32 Rsvd42 : 22;

                            /* Bits[63:42], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_C6_SCP_CR_AET_BASE_REGISTER;

/**
  Holds the physical base address where RTIT packets will be written
**/
#define JSL_MSR_IA32_CR_RTIT_OUTPUT_BASE 0x00000560

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 7;

                            /* Bits[6:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 OutputBasePhysAddr0 : 25;

                            /* Bits[31:7], Access Type=RW, default=0x00000000*/

                            /* The physical base address for the RTIT output */
    UINT32 OutputBasePhysAddr1 : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /* The physical base address for the RTIT output */
    UINT32 Reserved42 : 22;

                            /* Bits[63:42], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_RTIT_OUTPUT_BASE_REGISTER;

/**
  Holds the MASK to use when calculating the final address
**/
#define JSL_MSR_IA32_CR_RTIT_OUTPUT_MASK_PTRS 0x00000561

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RsvdAs0 : 7;

                            /* Bits[6:0], Access Type=Rsvd1, default=0x0000007F*/

                            /* Reserved as 7F */
    UINT32 OutputMask : 25;

                            /* Bits[31:7], Access Type=RW, default=0x00000000*/

                            /* Mask value ANDed with RTIT write pointer offset */
    UINT32 OutputOffset : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the value added to the base address to
                               determine the write address
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_IA32_CR_RTIT_OUTPUT_MASK_PTRS_REGISTER;

/**
  This is the RTIT Control Register used to control RTIT features
**/
#define JSL_MSR_GLM_CR_RTIT_CTL 0x00000570

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TraceEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Global RTIT enable */
    UINT32 CycEn : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether RTIT CYC packets will be
                               enabled or disabled
                            */
    UINT32 Os : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether OS level COFI (CPL0) will or
                               will not be traced
                            */
    UINT32 User : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether USER level COFI (CPL123) will
                               or will not be traced
                            */
    UINT32 PwrevtEn : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* Enable Power Event Trace */
    UINT32 FupOnPtw : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* Enable FUPs on PTWRITEs */
    UINT32 Reserved6 : 1;

                            /* Bits[6:6], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 Cr3Filter : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether CR3 Filtering is enabled or
                               disabled
                            */
    UINT32 Topa : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether ToPA scheme is enabled or
                               disabled
                            */
    UINT32 MtcEn : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               Used to enable or disable the generation of
                               MiniTimeStamp (MTC) packets
                            */
    UINT32 TscEn : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               Used to enable or disable the generation of TSC
                               packets
                            */
    UINT32 DisRetc : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* Disables Return Compression */
    UINT32 PtwrEn : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               When this bit is set, PTWRITE instruction will
                               generate PTW packets, otherwise no packets ar
                               generated
                            */
    UINT32 BranchEn : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* Enable COFI-based packets */
    UINT32 MtcFreq : 4;

                            /* Bits[17:14], Access Type=RW, default=0x00000000*/

                            /*
                               Defines MTC Frequency which is based on the HW
                               Crystal Clock (CTC)
                            */
    UINT32 Reserved18 : 1;

                            /* Bits[18:18], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 CycThresh : 4;

                            /* Bits[22:19], Access Type=RW, default=0x00000000*/

                            /* CYC Packet Threshold */
    UINT32 Reserved23 : 1;

                            /* Bits[23:23], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 PsbFreq : 4;

                            /* Bits[27:24], Access Type=RW, default=0x00000000*/

                            /* Indicates the frequency of PSB packets */
    UINT32 Reserved28 : 4;

                            /* Bits[31:28], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 Addr0Cfg : 4;

                            /* Bits[35:32], Access Type=RW, default=0x00000000*/

                            /* Configures use of IA32_RTIT_ADDR0 MSR */
    UINT32 Addr1Cfg : 4;

                            /* Bits[39:36], Access Type=RW, default=0x00000000*/

                            /* Configures use of IA32_RTIT_ADDR1 MSR */
    UINT32 Reserved40 : 16;

                            /* Bits[55:40], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */
    UINT32 InjectPsbPmiOnEnable : 1;

                            /* Bits[56:56], Access Type=RW, default=0x00000000*/

                            /*
                               Allows for PSBs and PMIs pended during the PT
                               disable flow to be preserved until PT is re-
                               enabled
                            */
    UINT32 Reserved57 : 7;

                            /* Bits[63:57], Access Type=Rsvd0, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_GLM_CR_RTIT_CTL_REGISTER;

/**
  RTIT Status Register
**/
#define JSL_MSR_ARR_CR_RTIT_STATUS 0x00000571

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filteren : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               This bit is written by RTIT hardware and
                               indicates that tracing is allowed for the
                               current IP
                            */
    UINT32 Contexten : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               This bit is written by RTIT hardware and
                               indicates that tracing is allowed for the
                               current context
                            */
    UINT32 Triggeren : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               This bit is written by RTIT hardware and
                               indicates that tracing is enabled
                            */
    UINT32 Reserved3 : 1;

                            /* Bits[3:3], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 Error : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* This bit is set when HW encounters an RTIT Error */
    UINT32 Stopped : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               This bit is set when HW encounters a TraceStop
                               condition due to TraceStop IP region or ToPA
                               STOP bit. It is cleared by software
                            */
    UINT32 PendPsb : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /*
                               Set by HW/ucode when PSB threshold reached and
                               InjectPsbPmiOnEnable=1, and cleared by PSB event
                               ucode if PSB inserted (which only happens if
                               TraceEn=1). PSB pended on PT enable if PendPSB
                               AND InjectPsbPmiOnEnable
                            */
    UINT32 PendTopaPmi : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Set by CPU when ToPA PMI threshold reached and
                               PMI pended, if InjectPsbPmiOnEnable=1. Cleared
                               by SW when ToPA PMI handled.
                            */
    UINT32 Reserved8 : 24;

                            /* Bits[31:8], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 PacketByteCount : 17;

                            /* Bits[48:32], Access Type=RW, default=0x00000000*/

                            /* Count of packet bytes that have been sent out */
    UINT32 Reserved49 : 15;

                            /* Bits[63:49], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_RTIT_STATUS_REGISTER;

/**
  RTIT CR3 Match registers have the programmed CR3 value for trace filtering. The bits correspond to that defined in CR3.
**/
#define JSL_MSR_SCP_CR_RTIT_CR3_MATCH 0x00000572

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 5;

                            /* Bits[4:0], Access Type=Rsvd0, default=None*/

                            /* Reserved */
    UINT32 Cr30 : 27;

                            /* Bits[31:5], Access Type=RW, default=0x00000000*/

                            /* Matches contents of CR3[63:5] */
    UINT32 Cr31 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Matches contents of CR3[63:5] */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_RTIT_CR3_MATCH_REGISTER;

/**
  Used to configure RTIT IP filtering and Tracestop regions.  This MSR defines the base LIP for the region defined as ADDR0.
**/
#define JSL_MSR_ARR_CR_RTIT_ADDR0_A 0x00000580

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ip0Addr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the base Linear Instruction Pointer
                               (address) for the region defined as ADDR0
                            */
    UINT32 Ip0Addr1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the base Linear Instruction Pointer
                               (address) for the region defined as ADDR0
                            */
    UINT32 Ip0SignExt : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /*
                               On a creg read, bit 47 is sign extended into
                               bits 63:48. This state is not stored.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_RTIT_ADDR0_A_REGISTER;

/**
  Used to configure IP filtering and Tracestop regions.  This MSR defines the limit LIP for region defined as ADDR0.
**/
#define JSL_MSR_ARR_CR_RTIT_ADDR0_B 0x00000581

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ip0Addr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the limit Linear Instruction Pointer
                               (address) for the region defined as ADDR0
                            */
    UINT32 Ip0Addr1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the limit Linear Instruction Pointer
                               (address) for the region defined as ADDR0
                            */
    UINT32 Ip0SignExt : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /*
                               On a creg read, bit 47 is sign extended into
                               bits 63:48. This state is not stored.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_RTIT_ADDR0_B_REGISTER;

/**
  Used to configure RTIT IP filtering and Tracestop regions.  This MSR defines the base LIP for the region defined as ADDR1.
**/
#define JSL_MSR_ARR_CR_RTIT_ADDR1_A 0x00000582

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ip1Addr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the base Linear Instruction Pointer
                               (address) for the region defined as ADDR1.
                            */
    UINT32 Ip1Addr1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the base Linear Instruction Pointer
                               (address) for the region defined as ADDR1.
                            */
    UINT32 Ip1SignExt : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /*
                               On a creg read, bit 47 is sign extended into
                               bits 63:48. This state is not stored.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_RTIT_ADDR1_A_REGISTER;

/**
  Used to configure IP filtering and Tracestop regions.  This MSR defines the limit LIP for region defined as ADDR1.
**/
#define JSL_MSR_ARR_CR_RTIT_ADDR1_B 0x00000583

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ip1Addr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the limit Linear Instruction Pointer
                               (address) for the region defined as ADDR1.
                            */
    UINT32 Ip1Addr1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /*
                               Holds the limit Linear Instruction Pointer
                               (address) for the region defined as ADDR1.
                            */
    UINT32 Ip1SignExt : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /*
                               On a creg read, bit 47 is sign extended into
                               bits 63:48. This state is not stored.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_RTIT_ADDR1_B_REGISTER;
/**
  DTS BASE address register to the DS buffer management area. (See IA32 Software Developer's Manual Vol. 3 15.10.5
**/
#define JSL_MSR_IA32_CR_DS_AREA_MSR 0x00000600

/**
  [p]PUNIT_MSR: VCCGI rail configuration information, including:[/p]
  [list]
  [*]Limitation on the maximum current consumption of the primary compute power plane.[/p]
  [*]Configuration of VR light load management, such as PS0, PS1, etc support
  [/list]
  [p]Set power state amp thresholds to 0A in order to disable that power state.[/p]
  [p][b]MSR_Name / address[/b]: VR_CURRENT_CONFIG / 0x601[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_VR_CURRENT_CONFIG 0x00000601

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CurrentLimit : 13;

                            /* Bits[12:0], Access Type=RW_L, default=0x00000010*/

                            /*
                               Peak current supported by the VR on the VCCGI
                               rail when all phases are active. Assumes VR is
                               in the highest power state possible (PS0). Units
                               given in PACKAGE_POWER_SKU_UNIT.CURRENT_UNIT.
                               This field will be locked when the LOCK bit in
                               this register is written to 1b. That lock will
                               be retained until the next reset condition.
                            */
    UINT32 Reserved13 : 18;

                            /* Bits[30:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[31:31], Access Type=RW_L, default=0x00000000*/

                            /*
                               This bit will lock the CURRENT_LIMIT settings in
                               this register and will also lock this setting.
                               This means that once set to 1b the CURRENT_LIMIT
                               setting and this bit become Read Only until the
                               next Warm Reset.
                            */
    UINT32 Psi1Threshold : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Peak current supported by the VR on the VCCGI
                               rail when in single phase mode (PS1). A value of
                               0 indicates VR support 0A of current in PS1
                               which will effectively disable PS1 use. This
                               field is defined in 1A units.
                            */
    UINT32 Psi2Threshold : 10;

                            /* Bits[51:42], Access Type=RW, default=0x00000000*/

                            /*
                               Peak current supported by the VR on the VCCGI
                               rail when in single phase mode (PS2). A value of
                               0 indicates VR support 0A of current in PS2
                               which will effectively disable PS2 use. This
                               field is defined in 1A units.
                            */
    UINT32 Psi3Threshold : 10;

                            /* Bits[61:52], Access Type=RW, default=0x00000000*/

                            /*
                               Peak current supported by the VR on the VCCGI
                               rail when in single phase mode (PS3). A value of
                               0 indicates VR support 0A of current in PS3
                               which will effectively disable PS3 use. This
                               field is defined in 1A units.
                            */
    UINT32 Ps4Enable : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               Enable for PS4 on the VCCGI rail. (current is
                               regulated to ~0A and voltage goes to 0V): [list]
                               [*] 1 = PSI4 is Enabled [*] 0 = disable [/list]
                            */
    UINT32 Reserved63 : 1;

                            /* Bits[63:63], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_VR_CURRENT_CONFIG_REGISTER;

/**
  [p]PUNIT_MSR: Input voltage regulator configuration parameters. PCODE will read this register during Reset Phase 4.[/p]
  [p][b]MSR_Name[/b]: VR_MISC_CONFIG  [b]MSR_Addr[/b]: 0x603[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_VR_MISC_CONFIG 0x00000603

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DynamicLoadLineR : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000036*/

                            /*
                               The Dynamic load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 IdleLoadLineR : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000036*/

                            /*
                               The Idle load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 LeakLoadLineR : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000036*/

                            /*
                               The Leakage load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 MinVid : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               Used to constrain the CPU's minimum voltage
                               during package C6/C7 C-states. The default
                               setting of 0x00 will result in full CPU control
                               over the minimum VID. VID resolution is 10mV /
                               LSB. This is internally clipped by fuses to the
                               C6/C7 voltage.
                            */
    UINT32 IoutOffset : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Signed offset added to VR dIout readings for
                               correction. 2s-complement signed number
                               expressed as a fraction of the IccMax of the VR.
                               Format: S8.-4.11 (8bits, floating point shifted
                               by 4 points). Precision: 0.049% (1/2^11) Range:
                               +/-6.25% of IccMax of the VR. Allowable range
                               may be clipped by processor on a per-SKU basis.
                            */
    UINT32 IoutSlope : 10;

                            /* Bits[49:40], Access Type=RW, default=0x00000200*/

                            /*
                               This is a slope correction for VR dIout readings
                               for postitive/negative correction. This scalar
                               is applied to every dIout reading before it is
                               consumed by the CPU. This scalar represents a
                               1.x number in U10.1.9 format (0.0 to 2.0 scalar
                               in ~0.19% increments)
                            */
    UINT32 IdleExitRampRate : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VR ramp rate on package C-state
                               wake events. 1 == fast, 0 == slow. Note that
                               fast will only apply to the Fast Ramp Voltage in
                               VR_MISC_CONFIG2[7:0]
                            */
    UINT32 IdleEntryRampRate : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the VR ramp rate on package C-state
                               entry events. 1 == fast, 0 == slow. If Decay is
                               set, it has priority. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 IdleEntryDecayEnable : 1;

                            /* Bits[52:52], Access Type=RW, default=0x00000001*/

                            /*
                               Enables decay mode on package C-state entry.
                               Decay mode implies PS2 or deeper. When Decay is
                               enabled, it has priority over the
                               IDLE_ENTRY_RAMP_RATE. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 SlowSlewRateConfig : 2;

                            /* Bits[54:53], Access Type=RW, default=0x00000001*/

                            /*
                               Defines the desired ratio between the VR fast
                               slope and slow slope. Pcode programs the VR on
                               BIOS complition 00 - slow = fast/2 01 - slow =
                               fast/4 (default) 10 - slow = fast/8 11 - slow =
                               fast/16
                            */
    UINT32 Rsvd55 : 9;

                            /* Bits[63:55], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_VR_MISC_CONFIG_REGISTER;

/**
  Defines units for calculating SKU power, current, energy, resistance and timing parameters.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_POWER_SKU_UNIT 0x00000606

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PwrUnit : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000008*/

                            /*
                               Used to define the units of power control
                               registers such as PL1, PL2, PL3 and PL4. The
                               actual unit value is calculated by 1 W /
                               2^PWR_UNIT. The default value of 8 corresponds
                               to 3.9mW per bit.
                            */
    UINT32 Reserved4 : 4;

                            /* Bits[7:4], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 EnergyUnit : 5;

                            /* Bits[12:8], Access Type=RW, default=0x0000000E*/

                            /*
                               Used to define the units of energy reporting
                               registers such as PACKAGE_ENERGY_STATUS. The
                               actual unit value is calculated by 1 J /
                               2^ENERGY_UNIT. The default value of 14
                               corresponds to ~61uJ per bit.
                            */
    UINT32 Reserved13 : 3;

                            /* Bits[15:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 TimeUnit : 4;

                            /* Bits[19:16], Access Type=RW, default=0x0000000A*/

                            /*
                               Used for to define the time units in registers
                               such as PL1, PL2, PL3 and PL4. The actual unit
                               value is calculated by 1s / 2^TIME_UNIT. The
                               default value of 10 corresponds to 0.977ms.
                            */
    UINT32 Reserved20 : 4;

                            /* Bits[23:20], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_POWER_SKU_UNIT_REGISTER;

/**
  Control and Status register for the BIOStoPCODE mailbox. This mailbox is implemented as a means for accessing statistics and implementing BIOS-Pcode handshakes.
  This register is used in conjunction with BIOS_MAILBOX_DATA.
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_BIOS_MAILBOX_INTERFACE 0x00000607

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Command : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               This field contains the SW request command or
                               the PCODE response code depending on the setting
                               of RUN_BUSY.
                            */
    UINT32 Address : 21;

                            /* Bits[28:8], Access Type=RW, default=0x00000000*/

                            /*
                               This field is used to specify an additional
                               parameter to extend the command when needed.
                            */
    UINT32 Rsvd29 : 2;

                            /* Bits[30:29], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RunBusy : 1;

                            /* Bits[31:31], Access Type=RW_1S, default=0x00000000*/

                            /*
                               SW may write to the two mailbox registers only
                               when RUN_BUSY is clear(0). Setting RUN_BUSY to 1
                               will pend a Fast Path event to Pcode. After
                               setting this bit SW will poll this bit until it
                               is cleared. PCODE will clear RUN_BUSY after
                               updating the mailbox registers with the result
                               and error code.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_BIOS_MAILBOX_INTERFACE_REGISTER;
/**
  Data register for the BIOStoPCODE mailbox. This mailbox is implemented as a means for accessing statistics and implementing BIOS-Pcode handshakes.
  This register is used in conjunction with BIOS_MAILBOX_INTERFACE.
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_BIOS_MAILBOX_DATA 0x00000608

/**
  TNT: Match HSW e4400429 behavior: read/write THREAD_P_REQ[P_STATE_OFFSET]. Note that per BXT HSDES 1015230753, this MSR was ignored on GLM
**/
#define JSL_MSR_VIRT_CR_PST_CONFIG_CONTROL 0x00000609

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PStateOffset : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* P-state offset of Thread-P-Req */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_PST_CONFIG_CONTROL_REGISTER;

/**
  [p]PUNIT_MSR: This register describes the OS tolerated wake latency for the C3 state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]: C_STATE_LATENCY_CONTROL_0  [b]MSR_Addr[/b]: 12'h60A[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_0 0x0000060A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved. */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_0_REGISTER;

/**
  [p]PUNIT_MSR: This register describes the OS tolerated wake latency for the C6/C7s state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]:  C_STATE_LATENCY_CONTROL_1  [b]MSR_Addr[/b]: 0x60B[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_1 0x0000060B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_1_REGISTER;

/**
  [p]This register describes the OS tolerated wake latency for the C7L state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]:  C_STATE_LATENCY_CONTROL_2  [b]MSR_Addr[/b]: 12'h60C[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_2 0x0000060C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved. */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_2_REGISTER;
/**
  [p]PUNIT_MSR: Time spent in the C1E state.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[p]
  [p][b]MSR_Name[/b]: PC2_RCNTR  [b]MSR_Addr[/b]: 0x60D[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC2_RCNTR 0x0000060D

/**
  Package RAPL Power Limit allows a software agent to define power limitation for the package domain. Power limitation
  is defined in terms of average power usage (Watts) over a time window specified.
  Two power limits and associated time windows can be specified. These power limits are commonly referred to as PL1 (long time
  window) and PL2 (short time window).  Each power limit provides
  independent clamping control that would permit the processor cores to go below OS-requested state to meet the
  power limits. A lock mechanism allow the software agent to enforce power limit settings. Once the lock bit is set,
  the power limit settings are static and un-modifiable until next RESET.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_RAPL_LIMIT 0x00000610

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgPwrLim1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Sets the average power usage limit of the
                               package domain corresponding to the PL1 time
                               window. The power units of this field are
                               specified by the
                               PACKAGE_POWER_SKU_UNIT_MSR.PWR_UNIT. This power
                               limit must be configured by software before it
                               will engage. The PL1 limit is most commonly
                               associated with long time windows (1s and
                               longer), although there are no explicit
                               constraints on what software configures.
                            */
    UINT32 PkgPwrLim1En : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /*
                               Enable for Power Limit 1 (PL1). Setting this bit
                               activates the power limit and time window
                               defined for PL1.
                            */
    UINT32 PkgClmpLim1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               Clamp mode control for PL1. [list] [*] 0 = PL1
                               power control is prevented from forcing P-states
                               below the base frequency / P1 for any domain in
                               the SOC. [*] 1 = PL1 power control will take all
                               actions necessary to meet the power target, even
                               if that involves running at clock frequencies
                               below the base frequency / P1 level. [/list] In
                               order to ensure proper SOC cooling, it is
                               generally recommended that the clamp mode is
                               always enabled.
                            */
    UINT32 PkgPwrLim1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x00000000*/

                            /*
                               [p]Time window for Power Limit 1 (PL1). This
                               describes the control window of the power limit.
                               This time window is described in an RC time
                               constant format, which means that if 1s is
                               programmed, the power limit constraint really
                               applies at more like 5s. The maximal time window
                               is bounded by PACKAGE_POWER_SKU_MSR.PKG_MAX_WIN.
                               Thre is no constraint on the minimum
                               programmable time window, however at very short
                               time windows the control algorithms may not be
                               effective.[/p] [p]The bits of this field
                               describe parameters for a mathematical equation
                               for time window configuration. This field is
                               split into two sub-fields:[/p] [list] [*] x =
                               bits[6:5] [*] y = bits[4:0] [/list] [p]Time
                               window equation:[/p] [b]time_window =
                               PACKAGE_POWER_SKU_UNIT.TIME_UNIT *
                               ((1+x/4)^y)[/b]
                            */
    UINT32 Reserved24 : 8;

                            /* Bits[31:24], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 PkgPwrLim2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Sets the average power usage limit of the
                               package domain corresponding to the PL2 time
                               window. The power units of this field are
                               specified by the
                               PACKAGE_POWER_SKU_UNIT_MSR.PWR_UNIT. This power
                               limit must be configured by software before it
                               will engage. The PL2 limit is most commonly
                               associated with long time windows (1s and
                               longer), although there are no explicit
                               constraints on what software configures.
                            */
    UINT32 PkgPwrLim2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               Enable for Power Limit 2 (PL2). Setting this bit
                               activates the power limit and time window
                               defined for PL2.
                            */
    UINT32 PkgClmpLim2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               Clamp mode control for PL2. [list] [*] 0 = PL2
                               power control is prevented from forcing P-states
                               below the base frequency / P1 for any domain in
                               the SOC. [*] 1 = PL2 power control will take all
                               actions necessary to meet the power target, even
                               if that involves running at clock frequencies
                               below the base frequency / P1 level. [/list] In
                               order to ensure proper SOC cooling, it is
                               generally recommended that the clamp mode is
                               always enabled.
                            */
    UINT32 PkgPwrLim2Time : 7;

                            /* Bits[55:49], Access Type=RW_L, default=0x00000000*/

                            /*
                               [p]Time window for Power Limit 1 (PL2). This
                               describes the control window of the power limit.
                               This time window is described in an RC time
                               constant format, which means that if 1s is
                               programmed, the power limit constraint really
                               applies at more like 5s. The maximal time window
                               is bounded by PACKAGE_POWER_SKU_MSR.PKG_MAX_WIN.
                               Thre is no constraint on the minimum
                               programmable time window, however at very short
                               time windows the control algorithms may not be
                               effective.[/p] [p]The bits of this field
                               describe parameters for a mathematical equation
                               for time window configuration. This field is
                               split into two sub-fields:[/p] [list] [*] x =
                               bits[6:5] [*] y = bits[4:0] [/list] [p]Time
                               window equation:[/p] [b]time_window =
                               PACKAGE_POWER_SKU_UNIT.TIME_UNIT *
                               ((1+x/4)^y)[/b]
                            */
    UINT32 Reserved56 : 7;

                            /* Bits[62:56], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 PkgPwrLimLock : 1;

                            /* Bits[63:63], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set all settings in this register are
                               locked and are treated as Read Only. This lock
                               control is persistent until the next reset. This
                               bit will typically set by BIOS during boot time
                               or resume from Sx.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_RAPL_LIMIT_REGISTER;
/**
  [p]Reports total energy consumed across the entire SOC / Package.  The energy status is reported in units which are defined by PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT.  The counter will wrap around and continue counting from zero when it reaches its limit and therefore should be polled sufficiently frequently to avoid aliasing.  Typically, software will calculate delta energy and delta time and divide the two to estimate Watts consumed over a time window.  The value of this register is updated at approximately every 1ms.  This energy status is what is used by RAPL PL1, PL2 and PL3 control algorithms.[/p]
  [p]To calculate Watts:[/p]
  [sp][sp][b]Watts = delta(energy) / delta(time) / 2^PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/b]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_ENERGY_STATUS 0x00000611
/**
  Counts time that any core in the IA domain is performance throttled below OS request and below the base frequency (P1) because of power limits (PL1 or PL2).  Counts in time units defined by PACKAGE_POWER_SKU_UNIT_MSR.TIME_UNIT.  If software uses the TURBO_ACTIVATION_RATIO or PECI ACPI P-NOTIFY, the turbo activation ratios described by those features will may elevate the effective OS request (as calculated by this counter) to max turbo.  This register starts counting at zero from reset and continues counting forever and wraparounds may occur, so software should ensure the sample rate is sufficient to avoid aliasing.  This is an unsigned value.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_RAPL_PERF_STATUS 0x00000613

/**
  This register describes the the power SKU of the part and limits on time window and power limit configuration allowed in the RAPL PL1 and PL2 configuration registers.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PACKAGE_POWER_SKU 0x00000614

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgTdp : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000118*/

                            /*
                               The TDP package power setting allowed for the
                               SKU. The TDP setting is typical not guaranteed.
                               The default value for this field is determined
                               by fuses. The units for this value are defined
                               in PACKAGE_POWER_SKU_MSR[PWR_UNIT].
                            */
    UINT32 Reserved15 : 1;

                            /* Bits[15:15], Access Type=RO, default=0x00000000*/

                            /* Reserved */
    UINT32 PkgMinPwr : 15;

                            /* Bits[30:16], Access Type=RW, default=0x00000060*/

                            /*
                               The minimal package power setting allowed for
                               the SKU. Lower values may not be achievable by
                               run-time RAPL PL1 and PL2 control algorithms.
                            */
    UINT32 Reserved31 : 1;

                            /* Bits[31:31], Access Type=RO, default=0x00000000*/

                            /* Reserved */
    UINT32 PkgMaxPwr : 15;

                            /* Bits[46:32], Access Type=RW, default=0x00000240*/

                            /*
                               The maximal package power setting allowed for
                               the SKU. Higher values will be clamped to this
                               value. The maximum setting is typical not
                               guaranteed. The default value for this field is
                               determined by fuses. The units for this value
                               are defined in PACKAGE_POWER_SKU_MSR[PWR_UNIT].
                            */
    UINT32 Reserved47 : 1;

                            /* Bits[47:47], Access Type=RO, default=0x00000000*/

                            /* Reserved */
    UINT32 PkgMaxWin : 7;

                            /* Bits[54:48], Access Type=RW, default=0x00000012*/

                            /*
                               The maximal time window allowed to be programmed
                               for RAPL PL1 and PL2 controls for the SKU.
                               Higher values will be clamped to this value.
                               [p]The bits of this field describe parameters
                               for a mathematical equation for time window
                               configuration. This field is split into two sub-
                               fields:[/p] [list] [*] x = bits[6:5] [*] y =
                               bits[4:0] [/list] [p]Time window equation:[/p]
                               [b]time_window =
                               PACKAGE_POWER_SKU_UNIT.TIME_UNIT *
                               ((1+x/4)^y)[/b]
                            */
    UINT32 Reserved55 : 9;

                            /* Bits[63:55], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PACKAGE_POWER_SKU_REGISTER;

/**
  BDW-C0 ECO 4664533: New virtual MSR for PL3. Read/write data from/to pcode through internal mailbox.
**/
#define JSL_MSR_UCODE_CR_PL3_CONTROL 0x00000615

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PowerLimit : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               PL3 or PAppMax power level. A power reading
                               above this will be interpreted as a violation
                               (in increments of 1/8th Watt, U12.3)
                            */
    UINT32 Enable : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               0 (default)=>Algorithm Disabled; 1=> Algorithm
                               Enabled
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TimeWindow : 7;

                            /* Bits[23:17], Access Type=RW, default=0x00000000*/

                            /*
                               Duration over which duty cycle control will be
                               maintained. The time is in the tau
                               format(xxYYYYY) in milliseconds
                            */
    UINT32 DutyCycle : 7;

                            /* Bits[30:24], Access Type=RW, default=0x00000000*/

                            /*
                               Expressed in percentage(U7.0%). Clipped to a max
                               value of 100%
                            */
    UINT32 Lock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               0=> Updates to fields allowed; 1=> Interface
                               locked. Ignore any writes
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_UCODE_CR_PL3_CONTROL_REGISTER;

/**
  RAPL power limit for DDR domain. This register is written by platform software and read by pcode once per 1ms. There are actually two instances of this register: one with MSR access and one with MMIO access. There is a separate PECI/PCS command which is also analogous.
**/
#define JSL_MSR_CORE_INTERFACE_CR_DDR_RAPL_LIMIT 0x00000618

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Limit1Power : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Power Limit[0] for DDR domain. Units=Watts,
                               Format=11.3, Resolution=0.125W,
                               Range=0-2047.875W.
                            */
    UINT32 Limit1Enable : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /* Power Limit[0] enable bit for DDR domain. */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CtrlTimeWin : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x00000000*/

                            /*
                               Power Limit[0] time window Y value, for DDR
                               domain. Actual time_window for RAPL is: (1/1024
                               seconds) * (1+(x/4)) * (2^y)
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Limit2Power : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Power Limit[1] for DDR domain. Units=Watts,
                               Format=11.3, Resolution=0.125W,
                               Range=0-2047.875W.
                            */
    UINT32 Limit2Enable : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /* Power Limit[1] enable bit for DDR domain. */
    UINT32 Rsvd48 : 1;

                            /* Bits[48:48], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Limit2TimeWindowY : 5;

                            /* Bits[53:49], Access Type=RW_L, default=0x00000000*/

                            /*
                               Power Limit[1] time window Y value, for DDR
                               domain. Actual time_window for RAPL is: (1/1024
                               seconds) * (1+(x/4)) * (2^y)
                            */
    UINT32 Limit2TimeWindowX : 2;

                            /* Bits[55:54], Access Type=RW_L, default=0x00000000*/

                            /*
                               Power Limit[1] time window X value, for DDR
                               domain. Actual time_window for RAPL is: (1/1024
                               seconds) * (1+(x/4)) * (2^y)
                            */
    UINT32 Rsvd56 : 7;

                            /* Bits[62:56], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Locked : 1;

                            /* Bits[63:63], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set this entire register becomes readonly.
                               This bit will typically be set by BIOS during
                               boot.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_DDR_RAPL_LIMIT_REGISTER;
/**
  [p]Reports total energy consumed in DRAM.  The energy status is reported in units which are defined by PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT.  The counter will wrap around and continue counting from zero when it reaches its limit and therefore should be polled sufficiently frequently to avoid aliasing.  Typically, software will calculate delta energy and delta time and divide the two to estimate Watts consumed over a time window.  The value of this register is updated at approximately every 1ms.  This energy status is what is used by DDR RAPL or OLTM control algorithms if the product supports those features.[/p]
  [p]To calculate Watts:[/p]
  [sp][sp][b]Watts = delta(energy) / delta(time) / 2^PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/b]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_DDR_ENERGY_STATUS 0x00000619
/**
  Memory RAPL performance throttling counter. This counter accumulates time that any channel in the memory controller is bandwidth throttled due to memory RAPL constraints.  This counter counts total time (in PACKAGE_POWER_SKU_UNIT_MSR.TIME_UNIT units) that any channel is throttled.  If two channels are throttled, this counter increments at a 2x rate, so that for 1ms in wall clock time the counter counts 2ms.  This counter does not include throttling as a result of thermal management or MEMHOT. This register is updated at approximately 1ms intervals.  This counter is normalized to 'seconds' and is not subject to variation of actual DRAM clock speeds.  This register is readonly for software via MMIO MSR and PECI/PCS. This register starts counting at zero from reset and continues counting forever and wraparounds may occur, so software should ensure the sample rate is sufficient to avoid aliasing.  This is an unsigned value.
**/
#define JSL_MSR_CORE_INTERFACE_CR_DDR_RAPL_PERF_STATUS 0x0000061B

/**
  [p]PUNIT_MSR: MSR for DRAM power information[/p]
  [p][b]MSR_Name[/b]: DRAM_POWER_INFO  [b]MSR_Addr[/b]: 0x61C[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_DRAM_POWER_INFO 0x0000061C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DramTdp : 15;

                            /* Bits[14:0], Access Type=RO, default=0x00000118*/

                            /*
                               The Spec power alloed for DRAM. The TDP setting
                               is typical (not guaranteed).
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMinPwr : 15;

                            /* Bits[30:16], Access Type=RO, default=0x00000078*/

                            /*
                               The minimal power setting allowed for DRAM.
                               Lower values will be clamped to this value. The
                               minimum setting is typical (not guaranteed).
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxPwr : 15;

                            /* Bits[46:32], Access Type=RO, default=0x00000258*/

                            /*
                               The maximal power setting allowed for DRAM.
                               Higher values will be clamped to this value. The
                               maximum setting is typical (not guaranteed).
                            */
    UINT32 Rsvd47 : 1;

                            /* Bits[47:47], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxWin : 7;

                            /* Bits[54:48], Access Type=RO, default=0x00000028*/

                            /*
                               The maximal time window allowed for the DRAM.
                               Higher values will be clamped to this value. x =
                               PKG_MAX_WIN[54:53], y = PKG_MAX_WIN[52:48]. The
                               timing interval window is Floating Point number
                               given by 1.x * power(2,y). Initialized by pcode
                               at reset phase4 to FUSE_TURBO_TIME_WINDOW.
                            */
    UINT32 Rsvd55 : 8;

                            /* Bits[62:55], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /*
                               The Spec power alloed for DRAM. The TDP setting
                               is typical (not guaranteed).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_DRAM_POWER_INFO_REGISTER;

/**
  Time spent with LLC flushed.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define JSL_MSR_CORE_INTERFACE_CR_LLC_FLUSHED_RCNTR 0x0000061D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0 : 32;

                            /* Bits[31:0], Access Type=RO, default=0x00000000*/

                            /* Counter Value */
    UINT32 Counter1 : 28;

                            /* Bits[59:32], Access Type=RO, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_LLC_FLUSHED_RCNTR_REGISTER;

/**
  Min/Max Ratio Limits for Uncore
**/
#define JSL_MSR_CORE_INTERFACE_CR_UNCORE_RATIO_LIMIT 0x00000620

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MaxClrRatio : 7;

                            /* Bits[6:0], Access Type=RW, default=0x00000000*/

                            /* MAX_CLR_RATIO */
    UINT32 Reserved7 : 1;

                            /* Bits[7:7], Access Type=RO, default=0x00000000*/

                            /* Reserved */
    UINT32 MinClrRatio : 7;

                            /* Bits[14:8], Access Type=RW, default=0x00000000*/

                            /* MIN_CLR_RATIO */
    UINT32 Reserved15 : 17;

                            /* Bits[31:15], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_UNCORE_RATIO_LIMIT_REGISTER;

/**
  Current Uncore Ratio
**/
#define JSL_MSR_CORE_INTERFACE_CR_UNCORE_PERF_STATUS 0x00000621

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CurrentClrRatio : 7;

                            /* Bits[6:0], Access Type=RO, default=0x00000000*/

                            /* Current Uncore Ratio */
    UINT32 Rsvd7 : 9;

                            /* Bits[15:7], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 LlcRingVoltage : 16;

                            /* Bits[31:16], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates the current operating voltage in 3.13,
                               format i.e. current voltage = float([47:32] /
                               (2^13)).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_UNCORE_PERF_STATUS_REGISTER;

/**
  Gives SW ability to trigger a PMReq through Pcode to put the chipset and other devices
  off of the chipset into a low power state.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PCH_EA_CONTROL 0x00000622

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EaValue : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000001*/

                            /*
                               0x0: Tell PCH that cores are not executing 0x1:
                               Tell PCH that cores are executing/Disable
                               Feature
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PCH_EA_CONTROL_REGISTER;

/**
  Reflect the value of control when PCH has responded to request from PCH_EA_CONTROL.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PCH_EA_STATUS 0x00000623

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EaStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /*
                               Reflects back the value of control once PCH has
                               responded to control request.
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PCH_EA_STATUS_REGISTER;
/**
  Time spent in the Package CState. It is given in units compatible to P1 clock frequency Guaranteed / Maximum Core NonTurbo Frequency. This time will be updated by PCODE only after the CState exit the update of this register has lower priority than actually ensuring that the CState exit occurs.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC8_RCNTR 0x00000630
/**
  [p]PUNIT_MSR: Currently unused residency counter.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[/p]
  [p][b]MSR_Name[/b]: PC9_RCNTR  [b]MSR_Addr[/b]: 0x631[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC9_RCNTR 0x00000631
/**
  [p]PUNIT_MSR: SOC S0i3 residency counter.  This counter increments at any time that the entire SOC is in an S0i3 state.  This register does not distinguish variations on S0i3, it increments for all variations.  This residency counter may count some time during entry into and exit from S0i3.  When accessed at the core level via RDMSR, time is measured in the same units as the Maximum Non-Turbo clock frequency.  When accessed at the P-unit level, the time units are based on the crystal clock frequency.[/p]
  [p][b]MSR_Name[/b]: PC10_RCNTR  [b]MSR_Addr[/b]: 0x632[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PC10_RCNTR 0x00000632

/**
  [p]PUNIT_MSR: This register describes the OS tolerated wake latency for the C8 state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]:  C_STATE_LATENCY_CONTROL_3  [b]MSR_Addr[/b]: 0x633[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_3 0x00000633

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_3_REGISTER;

/**
  [p]PUNIT_MSR: This register describes the OS tolerated wake latency for the C9 state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]: C_STATE_LATENCY_CONTROL_4  [b]MSR_Addr[/b]: 0x634[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_4 0x00000634

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_4_REGISTER;

/**
  [p]PUNIT_MSR: This register describes the OS tolerated wake latency for the C10 state. The minimum core C-state is calculated among all IA cores in the die,
  and power management firmware maps that resolved C-state to the appropriate Interrupt Response Tolerance latency setting.
  This setting will then affect package level idle state entry decisions such that it is guaranteed that the cores will wake up in less than the tolerated latency.[/p]
  [p]Registers initialized by Pcode at reset. BIOS cannot update these MSRs prior to PCODE_INIT_DONE, and it is not recommended that BIOS ever overwrite.[/p]
  [p][b]MSR_Name[/b]:  C_STATE_LATENCY_CONTROL_5  [b]MSR_Addr[/b]: 12'h635[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_5 0x00000635

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Value : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               This scalar is multiplied by the multiplier
                               field to calculate the net latency tolerance.
                               Ex., with a MULTIPLIER of 2 and a VALUE of 20,
                               the net latency tolerance is 20 * (2^10) =
                               20480ns or 20.48us
                            */
    UINT32 Multiplier : 3;

                            /* Bits[12:10], Access Type=RW, default=0x00000000*/

                            /*
                               [p]This field indicates the unit of measurement
                               that is defined for the Value field in this
                               register. The units are 2^(5*multiplier)[/p]
                               [list] [*]000b = 1ns (2^0) [*]001b = 32ns (2^5)
                               [*]010b = 1024ns (2^10) [*]011b = 32.768us
                               (2^15) [*]100b = 1.048ms (2^20) [*]101b =
                               33.55ms (2^25) [/list]
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 Valid : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This field qualifies the validity of the Value
                               field in this register. If the valid bit is
                               zero, then it is assumed that software has no
                               constraints on wake latency (i.e., it supports
                               infinity).
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RSV, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_C_STATE_LATENCY_CONTROL_5_REGISTER;

/**
  Input voltage regulator configuration parameters.
**/
#define JSL_MSR_CORE_INTERFACE_CR_VR_MISC_CONFIG2 0x00000636

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FastRampVoltage : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               This is the maximum voltage that the CPU can
                               ramp at the fast rate to.
                            */
    UINT32 MinC8Voltage : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Used to constrain the CPU's minimum voltage
                               during package C8 C-state. The default setting
                               of 0x00 will result in full CPU control over the
                               minimum VID. VID resolution is 10mV / LSB. This
                               is internally clipped by fuses to the C8 voltage
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_VR_MISC_CONFIG2_REGISTER;

/**
  This register is used by BIOS/OS/Integrated Graphics Driver/CPM Driver to limit the power budget of the Primary Power Plane.  The overall package turbo power limitation is controlled by PACKAGE_RAPL_LIMIT.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PRIMARY_PLANE_TURBO_POWER_LIMIT 0x00000638

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 IaPpPwrLim : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               This is the power limitation on the IA cores
                               power plane. The unit of measurement is defined
                               in PACKAGE_POWER_SKU_UNIT_MSRPWR_UNIT.
                            */
    UINT32 PwrLimCtrlEn : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This bit must be set in order to limit the power
                               of the IA cores power plane. 0b IA cores power
                               plane power limitation is disabled 1b IA cores
                               power plane power limitation is enabled
                            */
    UINT32 PpClampLim : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Power Plane Clamping limitation Allow going
                               below P1. 0b PBM is limited between P1 and P0.
                               1b PBM can go below P1.
                            */
    UINT32 CtrlTimeWin : 7;

                            /* Bits[23:17], Access Type=RW, default=0x00000000*/

                            /*
                               x CTRL_TIME_WIN23:22 y CTRL_TIME_WIN21:17 The
                               timing interval window is Floating Point number
                               given by 1.x power2y. The unit of measurement is
                               defined in PACKAGE_POWER_SKU_UNIT_MSRTIME_UNIT.
                               The maximal time window is bounded by
                               PACKAGE_POWER_SKU_MSRPKG_MAX_WIN. The minimum
                               time window is 1 unit of measurement as defined
                               above.
                            */
    UINT32 Reserved24 : 7;

                            /* Bits[30:24], Access Type=RO, default=0x00000000*/

                            /* Reserved */
    UINT32 PpPwrLimLock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               When set all settings in this register are
                               locked and are treated as Read Only.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PRIMARY_PLANE_TURBO_POWER_LIMIT_REGISTER;
/**
  [p]Reports total energy consumed across all IA cores.  The energy status is reported in units which are defined by PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT.  The counter will wrap around and continue counting from zero when it reaches its limit and therefore should be polled sufficiently frequently to avoid aliasing.  Typically, software will calculate delta energy and delta time and divide the two to estimate Watts consumed over a time window.  The value of this register is updated at approximately every 1ms.[/p]
  [p]To calculate Watts:[/p]
  [sp][sp][b]Watts = delta(energy) / delta(time) / 2^PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/b]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_PRIMARY_PLANE_ENERGY_STATUS 0x00000639

/**
  The PRIMARY_PLANE_TURBO_POWER_POLICY and SECONDARY_PLANE_TURBO_POWER_POLICY are used together as hints to balance the power budget between the primary (IA core) and secondary (Graphics) power planes.   This biasing is effectively a performance biasing, and it helps Punit firmware assess where software needs performance the most
**/
#define JSL_MSR_CORE_INTERFACE_CR_PRIMARY_PLANE_TURBO_POWER_POLICY 0x0000063A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Priptp : 5;

                            /* Bits[4:0], Access Type=RW, default=0x00000000*/

                            /*
                               Performance priority Level for the IA Core
                               (primary) power plane. A higher number implies a
                               higher priority.
                            */
    UINT32 Reserved5 : 27;

                            /* Bits[31:5], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PRIMARY_PLANE_TURBO_POWER_POLICY_REGISTER;
/**
  Memory RAPL performance excursion counter.  This register can report the performance impact of power limiting.
**/
#define JSL_MSR_PCU_CR_PRIMARY_PLANE_OVERFLOW_STATUS 0x0000063B

/**
  his register is used by BIOS/OS/Integrated Graphics Driver/CPM Driver to limit the power budget of the Secondary Power Plane.  The overall package turbo power limitation is controlled by PACKAGE_RAPL_LIMIT.
**/
#define JSL_MSR_CORE_INTERFACE_CR_SECONDARY_PLANE_TURBO_POWER_LIMIT 0x00000640

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NonIaPpPwrLim : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               his is the power limitation on the NonIA cores
                               power plane. The unit of measurement is defined
                               in PACKAGE_POWER_SKU_UNIT_MSRPWR_UNIT.
                            */
    UINT32 PwrLimCtrlEn : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               This bit must be set in order to limit the power
                               of the NonIA cores power plane. 0b NonIA cores
                               power plane power limitation is disabled 1b
                               NonIA cores power plane power limitation is
                               enabled
                            */
    UINT32 PpClampLim : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /*
                               Power Plane Clamping limitation Allow going
                               below P1. 0b PBM is limited between P1 and P0.
                               1b PBM can go below P1.
                            */
    UINT32 CtrlTimeWin : 7;

                            /* Bits[23:17], Access Type=RW, default=0x00000000*/

                            /*
                               x CTRL_TIME_WIN23:22 y CTRL_TIME_WIN21:17 The
                               timing interval window is Floating Point number
                               given by 1.x power2y. The unit of measurement is
                               defined in PACKAGE_POWER_SKU_UNIT_MSRTIME_UNIT.
                               The maximal time window is bounded by
                               PACKAGE_POWER_SKU_MSRPKG_MAX_WIN. The minimum
                               time window is 1 unit of measurement as defined
                               above.
                            */
    UINT32 Reserved24 : 7;

                            /* Bits[30:24], Access Type=RSV, default=0x00000000*/

                            /* Reserved */
    UINT32 SpPwrLimLock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               When set all settings in this register are
                               locked and are treated as Read Only.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_SECONDARY_PLANE_TURBO_POWER_LIMIT_REGISTER;
/**
  [p]Reports total energy consumed across all IA cores.  The energy status is reported in units which are defined by PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT.  The counter will wrap around and continue counting from zero when it reaches its limit and therefore should be polled sufficiently frequently to avoid aliasing.  Typically, software will calculate delta energy and delta time and divide the two to estimate Watts consumed over a time window.  The value of this register is updated at approximately every 1ms.[/p]
  [p]To calculate Watts:[/p]
  [sp][sp][b]Watts = delta(energy) / delta(time) / 2^PACKAGE_POWER_SKU_UNIT_MSR.ENERGY_UNIT[/b]
  [IntelRsvd]THIS REGISTER IS DUPLICATED IN THE PCU IO SPACE, XML CHANGES MUST BE MADE IN BOTH PLACES[/IntelRsvd]
**/
#define JSL_MSR_CORE_INTERFACE_CR_SECONDARY_PLANE_ENERGY_STATUS 0x00000641

/**
  The PRIMARY_PLANE_TURBO_POWER_POLICY and SECONDARY_PLANE_TURBO_POWER_POLICY are used together as hints to balance the power budget between the primary (IA core) and secondary (Graphics) power planes.   This biasing is effectively a performance biasing, and it helps Punit firmware assess where software needs performance the most
**/
#define JSL_MSR_CORE_INTERFACE_CR_SECONDARY_PLANE_TURBO_POWER_POLICY 0x00000642

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Secptp : 5;

                            /* Bits[4:0], Access Type=RW, default=0x00000010*/

                            /*
                               Performance priority Level for the Graphics
                               (secondary) power plane. A higher number implies
                               a higher priority.
                            */
    UINT32 Reserved5 : 27;

                            /* Bits[31:5], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_SECONDARY_PLANE_TURBO_POWER_POLICY_REGISTER;

/**
  to be filled in
**/
#define JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_NOMINAL 0x00000648

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TdpRatio : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Pcode set based on SKU and factors in
                               SSKU/softbin and flex impact.
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_NOMINAL_REGISTER;

/**
  Level 1 configurable TDP settings.
**/
#define JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_LEVEL1 0x00000649

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgTdp : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               Power for this TDP level. Units defined in
                               PACKAGE_POWER_SKU_MSR[PWR_UNIT] Similar to
                               PACKAGE_POWER_SKU[PKG_TDP]
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TdpRatio : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /* TDP ratio for config tdp level 1. */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgMaxPwr : 15;

                            /* Bits[46:32], Access Type=RW, default=0x00000000*/

                            /*
                               Max pkg power setting allowed for this config
                               TDP level1. Higher values will be clamped down
                               to this value. Units defined in
                               PACKAGE_POWER_SKU_MSR[PWR_UNIT]. Similar to
                               PACKAGE_POWER_SKU[PKG_MAX_PWR].
                            */
    UINT32 Rsvd47 : 1;

                            /* Bits[47:47], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgMinPwr : 15;

                            /* Bits[62:48], Access Type=RW, default=0x00000000*/

                            /*
                               Min pkg power setting allowed for this config
                               TDP level. Lower values will be clamped up to
                               this value. Units defined in
                               PACKAGE_POWER_SKU_MSR[PWR_UNIT]. Similar to
                               PACKAGE_POWER_SKU[PKG_MIN_PWR].
                            */
    UINT32 Rsvd63 : 1;

                            /* Bits[63:63], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_LEVEL1_REGISTER;

/**
  Level 2 configurable TDP settings. On sku that does not support config tdp, these to registers will report out 0.
**/
#define JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_LEVEL2 0x0000064A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgTdp : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000000*/

                            /*
                               Power for this TDP level. Units defined in
                               PACKAGE_POWER_SKU_MSR[PWR_UNIT] Similar to
                               PACKAGE_POWER_SKU[PKG_TDP].
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TdpRatio : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /* TDP ratio for level 2. */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgMaxPwr : 15;

                            /* Bits[46:32], Access Type=RW, default=0x00000000*/

                            /*
                               Pcode reads config TDP fuses and factors in
                               flex_ratio. On sku that does not support config
                               tdp, these to registers will report out 0.
                               Owner: Kaleen Man
                            */
    UINT32 Rsvd47 : 1;

                            /* Bits[47:47], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgMinPwr : 15;

                            /* Bits[62:48], Access Type=RW, default=0x00000000*/

                            /*
                               Min pkg power setting allowed for this config
                               TDP level 2. Lower values will be clamped up to
                               this value. Units defined in
                               PACKAGE_POWER_SKU_MSR[PWR_UNIT]. Similar to
                               PACKAGE_POWER_SKU[PKG_MIN_PWR].
                            */
    UINT32 Rsvd63 : 1;

                            /* Bits[63:63], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_LEVEL2_REGISTER;

/**
  Rd/Wr register to allow platform SW to select TDP point and set lock via all three interfaces (MSR, MMIO and PECI/PCS)
**/
#define JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_CONTROL 0x0000064B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TdpLevel : 3;

                            /* Bits[2:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Config TDP level selected 0 = nominal TDP level
                               (default) 1 = Level from CONFIG_TDP_LEVEL_1 2 =
                               Level from CONFIG_TDP_LEVEL_2 3 = reserved
                            */
    UINT32 Rsvd3 : 28;

                            /* Bits[30:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 ConfigTdpLock : 1;

                            /* Bits[31:31], Access Type=RW_L, default=0x00000000*/

                            /*
                               Config TDP level select lock 0 - unlocked. 1 -
                               locked till next reset.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_CONFIG_TDP_CONTROL_REGISTER;

/**
  [p]PUNIT_MSR: Used by software to configure the P-state at which turbo activates.  This feature is functionally identical to the ACPI P-state notify supported over PECI (PCS 33).  Turbo activation starts at clock ratios above the turbo activation ratio threshold configured in this register.[/p]
  [p][b]MSR_Name[/b]: TURBO_ACTIVATION_RATIO  [b]MSR_Addr[/b]: 0x64C[/p]
**/
#define JSL_MSR_CORE_INTERFACE_CR_TURBO_ACTIVATION_RATIO 0x0000064C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MaxNonTurboRatio : 8;

                            /* Bits[7:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               The P-unit will treat any P-state request above
                               this ratio as a request for maximum turbo. Zero
                               is special encoding which disables the feature
                            */
    UINT32 Rsvd8 : 23;

                            /* Bits[30:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 TurboActivationRatioLock : 1;

                            /* Bits[31:31], Access Type=RW_L, default=0x00000000*/

                            /*
                               Write to 1b to lock the setting in this register
                               until next reset
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_TURBO_ACTIVATION_RATIO_REGISTER;
/**
  Reports the actual energy used by the platform
**/
#define JSL_MSR_CORE_INTERFACE_CR_PLATFORM_ENERGY_STATUS 0x0000064D
/**
  productivity cycles counter (HWP)
**/
#define JSL_MSR_PMG_CR_PST_PCNT 0x0000064E

/**
  Interface to allow software to determine what is causing
  resolved frequency to be clamped
  below the requested frequency. Status bits are updated by Punit firmware
  every millisecond and log bits are set upon observing the corresponding
  status bit being set.  Software may clear log bits to track performance limit
  reasons inbetween reads of this register.
**/
#define JSL_MSR_CORE_INTERFACE_CR_IA_PERF_LIMIT_REASONS 0x0000064F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ProchotStatus : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               PROCHOT# Status, RO, When set by PCODE indicates
                               that PROCHOT# has cause IA frequency clipping
                            */
    UINT32 ThermalStatus : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               Thermal Status, RO, When set by PCODE indicates
                               that Thermal event has cause IA frequency
                               clipping
                            */
    UINT32 Pl1Status : 1;

                            /* Bits[2:2], Access Type=RO, default=0x00000000*/

                            /*
                               Frequency is limited due to a package-level RAPL
                               PL1 excursion.
                            */
    UINT32 Pl2Status : 1;

                            /* Bits[3:3], Access Type=RO, default=0x00000000*/

                            /*
                               Frequency is limited due to a package-level RAPL
                               PL2 excursion.
                            */
    UINT32 RsrLimit : 1;

                            /* Bits[4:4], Access Type=ROFW, default=0x00000000*/

                            /*
                               Reliability stress Restrictor Status, RO, When
                               set by PCODE indicates that Reliability stress
                               restrictor has cause IA frequency clipping
                            */
    UINT32 Ratl : 1;

                            /* Bits[5:5], Access Type=ROFW, default=0x00000000*/

                            /*
                               Running average thermal limit Status, R0, When
                               set by PCODE indicates that Running average
                               thermal limit has cause IA frequency clipping
                            */
    UINT32 VrThermalert : 1;

                            /* Bits[6:6], Access Type=ROFW, default=0x00000000*/

                            /*
                               Hot VR (any processor VR) Status, RO, When set
                               by PCODE indicates that Hot VR (any processor
                               VR) has cause IA frequency clipping
                            */
    UINT32 VrTdc : 1;

                            /* Bits[7:7], Access Type=ROFW, default=0x00000000*/

                            /*
                               VR TDC (Thermal design current) Status, RO, When
                               set by PCODE indicates that VR TDC (Thermal
                               design current has cause IA frequency clipping
                            */
    UINT32 Other : 1;

                            /* Bits[8:8], Access Type=ROFW, default=0x00000000*/

                            /*
                               Other (IccMax, PL4, etc) Status, RO, When set by
                               PCODE indicates that other has cause reason IA
                               frequency clipping
                            */
    UINT32 SpareIa9 : 1;

                            /* Bits[9:9], Access Type=ROFW, default=0x00000000*/

                            /* Reserved */
    UINT32 PbmPl1 : 1;

                            /* Bits[10:10], Access Type=ROFW, default=0x00000000*/

                            /*
                               PBM PL1 (pkg, platform), RO, When set by PCODE
                               indicates that PBM PL1 (package or platform PL1)
                               has cause IA frequency clipping
                            */
    UINT32 PbmPl2 : 1;

                            /* Bits[11:11], Access Type=ROFW, default=0x00000000*/

                            /*
                               PBM PL2, PL3 (pkg, platform) Status, RO, When
                               set by PCODE indicates that PBM PL2 or
                               PL3(package or platform PL2 or PL3) has cause IA
                               frequency clipping
                            */
    UINT32 MaxTurboLimit : 1;

                            /* Bits[12:12], Access Type=ROFW, default=0x00000000*/

                            /*
                               Max turbo limit Status, RO, When set by PCODE
                               indicates that Max turbo limit has cause IA
                               frequency clipping
                            */
    UINT32 TurboAtten : 1;

                            /* Bits[13:13], Access Type=ROFW, default=0x00000000*/

                            /*
                               Turbo attenuation (multi core turbo) Status, RO,
                               When set by PCODE indicates that Turbo
                               attenuation (multi core turbo) has cause IA
                               frequency clipping
                            */
    UINT32 SpareIa14 : 1;

                            /* Bits[14:14], Access Type=ROFW, default=0x00000000*/

                            /* Reserved */
    UINT32 SpareIa15 : 1;

                            /* Bits[15:15], Access Type=ROFW, default=0x00000000*/

                            /* Reserved */
    UINT32 ProchotLog : 1;

                            /* Bits[16:16], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               PROCHOT# Log, RW, When set by PCODE indicates
                               that PROCHOT# has cause IA frequency clipping.
                               Software should write to this bit to clear the
                               status in this bit
                            */
    UINT32 ThermalLog : 1;

                            /* Bits[17:17], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Thermal Log, RW, When set by PCODE indicates
                               that Thermal event has cause IA frequency
                               clipping. Software should write to this bit to
                               clear the status in this bit
                            */
    UINT32 SpareIa2Log : 1;

                            /* Bits[18:18], Access Type=RW0C_FW, default=0x00000000*/

                            /* Reserved */
    UINT32 SpareIa3Log : 1;

                            /* Bits[19:19], Access Type=RW0C_FW, default=0x00000000*/

                            /* Reserved */
    UINT32 RsrLimitLog : 1;

                            /* Bits[20:20], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Reliability stress restrictor Log, RW, When set
                               by PCODE indicates that Reliability stress
                               restrictor has cause IA frequency clipping.
                               Software should write to this bit to clear the
                               status in this bit
                            */
    UINT32 RatlLog : 1;

                            /* Bits[21:21], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Running average thermal limit Log, RW, When set
                               by PCODE indicates that Running average thermal
                               limit has cause IA frequency clipping. Software
                               should write to this bit to clear the status in
                               this bit
                            */
    UINT32 VrThermalertLog : 1;

                            /* Bits[22:22], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Hot VR (any processor VR) Log, RW, When set by
                               PCODE indicates that Hot VR (any processor VR)
                               has cause IA frequency clipping. Software should
                               write to this bit to clear the status in this
                               bit
                            */
    UINT32 VrTdcLog : 1;

                            /* Bits[23:23], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               VR TDC (Thermal design current) Log, RW, When
                               set by PCODE indicates that VR TDC (Thermal
                               design current has cause IA frequency clipping.
                               Software should write to this bit to clear the
                               status in this bit
                            */
    UINT32 OtherLog : 1;

                            /* Bits[24:24], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Other (IccMax, PL4, etc) Log, RW, When set by
                               PCODE indicates that other has cause reason IA
                               frequency clipping. Software should write to
                               this bit to clear the status in this bit
                            */
    UINT32 SpareIa9Log : 1;

                            /* Bits[25:25], Access Type=RW0C_FW, default=0x00000000*/

                            /* Reserved */
    UINT32 PbmPl1Log : 1;

                            /* Bits[26:26], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               PBM PL1 (pkg, platform) Log, RW, When set by
                               PCODE indicates that PBM PL1 (package or
                               platform PL1) has cause IA frequency clipping.
                               Software should write to this bit to clear the
                               status in this bit
                            */
    UINT32 PbmPl2Log : 1;

                            /* Bits[27:27], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               PBM PL2, PL3 (pkg, platform) Log, RW, When set
                               by PCODE indicates that PBM PL2 or PL3(package
                               or platform PL2 or PL3) has cause IA frequency
                               clipping. Software should write to this bit to
                               clear the status in this bit
                            */
    UINT32 MaxTurboLimitLog : 1;

                            /* Bits[28:28], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Max turbo limit Log, RW, When set by PCODE
                               indicates that Max turbo limit has cause IA
                               frequency clipping. Software should write to
                               this bit to clear the status in this bit
                            */
    UINT32 TurboAttenLog : 1;

                            /* Bits[29:29], Access Type=RW0C_FW, default=0x00000000*/

                            /*
                               Turbo attenuation (multi core turbo) Log, RW,
                               When set by PCODE indicates that Turbo
                               attenuation (multi core turbo) has cause IA
                               frequency clipping. Software should write to
                               this bit to clear the status in this bit
                            */
    UINT32 SpareIa14Log : 1;

                            /* Bits[30:30], Access Type=RW0C_FW, default=0x00000000*/

                            /* Reserved */
    UINT32 SpareIa15Log : 1;

                            /* Bits[31:31], Access Type=RW0C_FW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_IA_PERF_LIMIT_REASONS_REGISTER;

/**
  Fast wrmsr/rdmsr control MSR. Each bit refers to one MSR and indicate if this MSR is set to use the FAST_UNCORE_MSRS mode.
**/
#define JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_CTL 0x00000657

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HwpRequest : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               HWP_REQUEST fast MSR optin bit. This is just a
                               dummy flop on TNT
                            */
    UINT32 HwSetLpPmMetaData : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               MSR 0x1C3 HW_SET_LP_PM_META_DATA fast MSR optin
                               bit. This is just a dummy flop on TNT
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_CTL_REGISTER;
/**
  Sum the cycles per number of active cores
**/
#define JSL_MSR_CORE_INTERFACE_CR_PKG_IA_C0_ANY_SUM 0x00000658
/**
  Sum the cycles of active cores
**/
#define JSL_MSR_CORE_INTERFACE_CR_PKG_IA_C0_ANY 0x00000659
/**
  Sum the cycles of active GT
**/
#define JSL_MSR_CORE_INTERFACE_CR_PKG_GT_C0_ANY 0x0000065A
/**
  Sum the cycles of overlap time between any IA cores and GT
**/
#define JSL_MSR_CORE_INTERFACE_CR_PKG_GT_AND_IA_OVERLAP 0x0000065B

/**
  Platform power limit
**/
#define JSL_MSR_CORE_INTERFACE_CR_PLATFORM_POWER_LIMIT 0x0000065C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PowerLimit1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Average Power limit value which the Platform
                               must not exceed over a time window as specified
                               by Power_Limit_1_TIME field above.
                            */
    UINT32 PowerLimit1En : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the Platform average power
                               does not exceed Power_Limit_1 value over an
                               exponential weighted moving average of the time
                               window.
                            */
    UINT32 CriticalPowerClamp1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_1 value specified below.
                            */
    UINT32 PowerLimit1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               This indicates the time window over which
                               Power_Limit_1 value should be maintained.
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PowerLimit2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Duration Power limit value which the Platform
                               must not exceed. This field is specified in the
                               units as identified by the
                               PALTFORM_POWER_SKU_UNIT (MSR606h).
                            */
    UINT32 PowerLimit2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the platform power does not
                               exceed Power_Limit_2 value.
                            */
    UINT32 CriticalPowerClamp2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_2 value specified below.
                            */
    UINT32 Rsvd49 : 14;

                            /* Bits[62:49], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /* Locks all other fields. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PLATFORM_POWER_LIMIT_REGISTER;

/**
  Fast uncore MSR - dirty bit status register. Since TNT emulates Fast MSRs, the status will always be 0
**/
#define JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_STATUS 0x0000065E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Cr0 : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* CR0 (HWP_REQUEST) Dirty bit */
    UINT32 Cr1 : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /* CR1 MSR 0x1C3 HW_SET_LP_PM_META_DATA Dirty bit */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_STATUS_REGISTER;

/**
  Fast wrmsr/rdmsr enumeration MSR. This is read-only MSR. Each bit refers to one MSR and indicate if this MSR
  is enabled to be use in FAST_UNCORE_MSRS.
**/
#define JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_CAPABILITY 0x0000065F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HwpRequest : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000001*/

                            /* HWP_REQUEST is fast MSR capable */
    UINT32 HwSetLpPmMetaData : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000001*/

                            /*
                               MSR 0x1C3 HW_SET_LP_PM_META_DATA is fast MSR
                               capable
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_FAST_UNCORE_MSRS_CAPABILITY_REGISTER;
/**
  GLM i1958858: copy of the cores c-state residency timer
**/
#define JSL_MSR_C6_SCP_CR_CORE_C1_RESIDENCY 0x00000660

/**
  Time spent in the Module CState. It is given in units compatible to P1 clock frequency Guaranteed / Maximum Core NonTurbo Frequency. This time will be updated by PCODE only after the CState exit the update of this register has lower priority than actually ensuring that the CState exit occurs.
**/
#define JSL_MSR_CORE_INTERFACE_CR_MC6_RCNTR 0x00000664

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Counter1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Reserved60 : 4;

                            /* Bits[63:60], Access Type=RO, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_MC6_RCNTR_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP00 0x00000680

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP00_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP01 0x00000681

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP01_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP02 0x00000682

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP02_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP03 0x00000683

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP03_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP04 0x00000684

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP04_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP05 0x00000685

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP05_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP06 0x00000686

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP06_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP07 0x00000687

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP07_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP08 0x00000688

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP08_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP09 0x00000689

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP09_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP10 0x0000068A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP10_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP11 0x0000068B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP11_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP12 0x0000068C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP12_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP13 0x0000068D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP13_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP14 0x0000068E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP14_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP15 0x0000068F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP15_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP16 0x00000690

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP16_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP17 0x00000691

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP17_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP18 0x00000692

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP18_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP19 0x00000693

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP19_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP20 0x00000694

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP20_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP21 0x00000695

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP21_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP22 0x00000696

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP22_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP23 0x00000697

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP23_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP24 0x00000698

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP24_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP25 0x00000699

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP25_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP26 0x0000069A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP26_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP27 0x0000069B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP27_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP28 0x0000069C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP28_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP29 0x0000069D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP29_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP30 0x0000069E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP30_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT
**/
#define JSL_MSR_VIRT_CR_LBR_CLIP31 0x0000069F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "FROM" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470).
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_CLIP31_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP00 0x000006C0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP00_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP01 0x000006C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP01_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP02 0x000006C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP02_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP03 0x000006C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP03_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP04 0x000006C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP04_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP05 0x000006C5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP05_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP06 0x000006C6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP06_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP07 0x000006C7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP07_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP08 0x000006C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP08_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP09 0x000006C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP09_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP10 0x000006CA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP10_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP11 0x000006CB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP11_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP12 0x000006CC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP12_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP13 0x000006CD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP13_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP14 0x000006CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP14_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP15 0x000006CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP15_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP16 0x000006D0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP16_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP17 0x000006D1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP17_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP18 0x000006D2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP18_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP19 0x000006D3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP19_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP20 0x000006D4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP20_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP21 0x000006D5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP21_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP22 0x000006D6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP22_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP23 0x000006D7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP23_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP24 0x000006D8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP24_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP25 0x000006D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP25_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP26 0x000006DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP26_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP27 0x000006DB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP27_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP28 0x000006DC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP28_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP29 0x000006DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP29_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP30 0x000006DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP30_REGISTER;

/**
  Virtual MSR - not an actual creg on TNT.
**/
#define JSL_MSR_VIRT_CR_LBR_BLIP31 0x000006DF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lip0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 Lip1 : 16;

                            /* Bits[47:32], Access Type=RW, default=0x00000000*/

                            /* "TO" address */
    UINT32 LipExt : 16;

                            /* Bits[63:48], Access Type=Rsvd0, default=0x00000000*/

                            /*
                               Extended bits of LIP. Ignored on writes
                               (canonical check). Forced to be canonical on
                               reads (SLM C0/AMT b3277926/e3430470)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_LBR_BLIP31_REGISTER;
/**
  Holds the value of for RDMSR/WRMSR of TSC Deadline (MSR 0x6E0).
**/
#define JSL_MSR_IA32_CR_TSC_DEADLINE 0x000006E0

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000700

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000701

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCT_0_CLIENT 0x00000702

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCT_1_CLIENT 0x00000703

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE0_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000708

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000709

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCT_0_CLIENT 0x0000070A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCT_1_CLIENT 0x0000070B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE1_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000710

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000711

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCT_0_CLIENT 0x00000712

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCT_1_CLIENT 0x00000713

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE2_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000718

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000719

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCT_0_CLIENT 0x0000071A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE3_CR_CBOPMONCT_0_CLIENT_REGISTER;
/**
  Server only residency counter select.
**/
#define JSL_MSR_C6_SCP_CR_RESIDENCY_CTR_SELECT_SRVR 0x0000071B
/**
  Server residency counter MSR
**/
#define JSL_MSR_VIRT_CR_RESIDENCY_CTR_CONFIG_SRVR 0x0000071C
/**
  Server residency counter MSR
**/
#define JSL_MSR_VIRT_CR_RESIDENCY_CTR_SRVR 0x0000071D

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000720

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000721

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCT_0_CLIENT 0x00000722

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCT_1_CLIENT 0x00000723

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE4_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000728

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000729

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCT_0_CLIENT 0x0000072A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCT_1_CLIENT 0x0000072B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE5_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000730

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000731

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCT_0_CLIENT 0x00000732

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCT_1_CLIENT 0x00000733

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE6_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000738

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000739

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCT_0_CLIENT 0x0000073A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCT_0_CLIENT_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCT_1_CLIENT 0x0000073B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_PMON_SLICE7_CR_CBOPMONCT_1_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_CR_CBOPMONCTRCTRL_0_CLIENT 0x00000768

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_CR_CBOPMONCTRCTRL_0_CLIENT_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define JSL_MSR_CBO_CR_CBOPMONCTRCTRL_1_CLIENT 0x00000769

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When TID filter
                               enable is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When, the
                               comparison that will be done is event-count >=
                               threshold. When set to , the comparison that
                               will be done is inverted from the case where
                               this bit is set to , i.e., event-count;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CBO_CR_CBOPMONCTRCTRL_1_CLIENT_REGISTER;

/**
  Part of the HWP interface fo OS usage.  This is an MSR to enable HWP and specific modes.
**/
#define JSL_MSR_CORE_INTERFACE_CR_PM_ENABLE 0x00000770

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HwpEnable : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Set (1) to enable the HWP performance control
                               interface. Only valid when the HWP Base feature
                               is present. When set, HW will disregard input
                               from the legacy performance control interface
                               (e.g. IA32_PERF_CTL). Usage is sticky, sampled
                               once at the end of reset. Once set, can only be
                               cleared via reset. Default = zero (0).
                            */
    UINT32 Reserved1 : 31;

                            /* Bits[31:1], Access Type=RO, default=0x00000000*/

                            /* Reserved, must be zero */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_PM_ENABLE_REGISTER;

/**
  static report of the enumeration values, BDX new: IA32_HWP_BASE_CAPABILITY is defined to be thread-scoped, read-only MSR, but implemented as a package-scoped MSR. Pcode initializes this register. Ucode only reads this
**/
#define JSL_MSR_CORE_INTERFACE_CR_HWP_CAPABILITIES 0x00000771

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 HighestPerformance : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Abstract value of the max non-guaranteed
                               performance level
                            */
    UINT32 GuaranteedPerformance : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000001*/

                            /*
                               Abstract value of the guaranteed performance
                               level
                            */
    UINT32 MostEfficientPerformance : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               Abstract value of the most efficient performance
                               level
                            */
    UINT32 LowestLinearPerformance : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000001*/

                            /* Abstract value of the lowest performance level */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_HWP_CAPABILITIES_REGISTER;

/**
  Used to convey the OSs performance request {Min, Max. Desired, tc} to apply across threads if requested.
**/
#define JSL_MSR_CORE_INTERFACE_CR_HWP_REQUEST_PKG 0x00000772

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MinimumPerformance : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000001*/

                            /*
                               Limits the instantaneous minimum performance
                               while in C0. HW will observe this constraint
                               unless and until an overriding condition occurs
                               (e.g. thermal). Set to zero (0) if SW does not
                               care (no limit). Default = zero (0).
                            */
    UINT32 MaximumPerformance : 8;

                            /* Bits[15:8], Access Type=RW, default=0x000000FF*/

                            /*
                               Limits the instantaneous maximum performance
                               level while in C0. Set to all ones (1s) if SW
                               does not care (no limit). Default = all ones
                               (1s).
                            */
    UINT32 DesiredPerformance : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               The requested average performance level. When
                               specified (non-zero), HW will attempt to deliver
                               this performance over the Time Window and within
                               Tolerance, in light of other constraints. A
                               value of zero (0) may be used to enable
                               Autonomous Mode when the corresponding feature
                               is present and enabled. Otherwise HW will
                               interpret Desired=0 as Desired=Guaranteed.
                               Default = zero (0).
                            */
    UINT32 EnergyPerformancePreference : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000080*/

                            /* tbd */
    UINT32 ActivityWindow : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved, used to be TIME_WINDOW, but time
                               window is not used for SKX
                            */
    UINT32 Rsvd42 : 6;

                            /* Bits[47:42], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Reserved48 : 16;

                            /* Bits[63:48], Access Type=RO, default=0x00000000*/

                            /*
                               Reserved - may be replaced by RO once HWP
                               description converges
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_HWP_REQUEST_PKG_REGISTER;

/**
  Used to control native interrupt generation (changes, excursions).
**/
#define JSL_MSR_CORE_INTERFACE_CR_HWP_INTERRUPT 0x00000773

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ChangeToGuaranteed : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               When set (1), an HWP Interrupt will be generated
                               whenever a change to the Guaranteed Performance
                               occurs. Default = interrupt disabled (0).
                            */
    UINT32 ExcursionToMinimum : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               When set (1), an HWP Interrupt will be generated
                               whenever HW is unable to meet the Minimum
                               Performance. Default = interrupt disabled (0).
                            */
    UINT32 ChangeToHighest : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               When set (1), an HWP Interrupt will be generated
                               whenever a change to the Highest Performance
                               occurs. Default = interrupt disabled (0).
                            */
    UINT32 PeciOverride : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               When set(1), an HWP interrupt will be generated
                               whenever a management controller supersedes one
                               or more of the OS control hints (min, max, EPP)
                               specified in IA32_HWP_REQUEST or
                               IA32_HWP_REQUEST_PKG
                            */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_HWP_INTERRUPT_REGISTER;

/**
  Temporary definition for usim enabling.
**/
#define JSL_MSR_PCU_CR_PECI_HWP_REQUEST_INFO 0x00000775

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MinimumPerformance : 8;

                            /* Bits[7:0], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0), Used by OS to read the
                               latest value of PECI minimum performance input
                            */
    UINT32 MaximumPerformance : 8;

                            /* Bits[15:8], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0), Used by OS to read the
                               latest value of PECI maximum performance input
                            */
    UINT32 Rsvd16 : 8;

                            /* Bits[23:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EnergyPerformancePreference : 8;

                            /* Bits[31:24], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0), Used by OS to read the
                               latest value of PECI Energy Performance
                               Preference input
                            */
    UINT32 Rsvd32 : 28;

                            /* Bits[59:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 EppPeciOverride : 1;

                            /* Bits[60:60], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0). Indicates whether PECI if
                               currently overriding the Energy Performance
                               Preference input. If set(1), PECI is overriding
                               the Energy Performance Preference input. If
                               clear(0), OS has control over Energy Performance
                               Preference input
                            */
    UINT32 Rsvd61 : 1;

                            /* Bits[61:61], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MaxPeciOverride : 1;

                            /* Bits[62:62], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0).Indicates whether PECI is
                               currently overriding the Maximum Performance
                               input. If set(1), PECI is overriding the Maximum
                               Performance input. If clear(0), OS has control
                               over Maximum Performance input
                            */
    UINT32 MinPeciOverride : 1;

                            /* Bits[63:63], Access Type=RO, default=0x00000000*/

                            /*
                               RO (default = 0x0).Indicates whether PECI is
                               currently overriding the Minimum Performance
                               input. If set(1), PECI is overriding the Minimum
                               Performance input. If clear(0), OS has control
                               over Minimum Performance input
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PCU_CR_PECI_HWP_REQUEST_INFO_REGISTER;

/**
  Indicates when a Change or Excursion has occurred :
  BDX new: Thread HWP Status register.  All values in this register are updated by Pcode and typically read or cleared by SW (ucode).
**/
#define JSL_MSR_CORE_INTERFACE_CR_HWP_STATUS 0x00000777

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ChangeToGuaranteed : 1;

                            /* Bits[0:0], Access Type=RW0C, default=0x00000000*/

                            /*
                               If set (1), a change to Guaranteed Performance
                               has occurred. SW should query
                               IA32_HWP_CURRENT_CAPABILITY to ascertain the new
                               Guaranteed Performance value. SW must clear this
                               bit by writing a zero (0).
                            */
    UINT32 ReservedForExcursionToDesired1 : 1;

                            /* Bits[1:1], Access Type=RO, default=0x00000000*/

                            /*
                               The platform describes the ACPI Performance
                               Limited Register as starting at this bit
                               location, which indicates an excursion to
                               Desired under CPPC1, In IA silicon, CPPC1 is not
                               supported. As such, reads of this bit must
                               always return zero (0).
                            */
    UINT32 ExcursionToMinimum : 1;

                            /* Bits[2:2], Access Type=RW0C, default=0x00000000*/

                            /*
                               If set (1), an excursion to Minimum Performance
                               has occurred. SW must clear this bit by writing
                               a zero (0).
                            */
    UINT32 HighestChange : 1;

                            /* Bits[3:3], Access Type=RW0C, default=0x00000000*/

                            /*
                               If set (1), a change to Highest Performance has
                               occurred. SW should query IA32_HWP_CAPABILITIES
                               to ascertain the new Highest Performance value.
                               SW must clear this bit by writing a zero (0).
                            */
    UINT32 PeciOverrideEnter : 1;

                            /* Bits[4:4], Access Type=RW0C, default=0x00000000*/

                            /*
                               If set (1), a management controller has started
                               a PECI override of one or more OS control hints
                               (min, max, EPP) specified in IA32_HWP_REQUEST or
                               IA32_HWP_REQUEST_PKG. SW must clear this bit
                            */
    UINT32 PeciOverrideExit : 1;

                            /* Bits[5:5], Access Type=RW0C, default=0x00000000*/

                            /*
                               If set (1), a management controller has stopped
                               a PECI override of all OS control hints (min,
                               max, EPP) specified in IA32_HWP_REQUEST or
                               IA32_HWP_REQUEST_PKG. SW must clear this bit by
                               writing a zero (0).
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_HWP_STATUS_REGISTER;

/**
  This MSR will write the ERRINJLCK bit of IIO, QPI, CBO, MC
**/
#define JSL_MSR_VIRT_CR_ERR_INJ_LCK_UNLOCK_CTL 0x00000790

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrInjLckUnlock : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               Bit indicates if error injection is enabled. 0 -
                               unlocked. 1 - locked (not enabled). note that
                               this field actually not used by ucode
                            */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_ERR_INJ_LCK_UNLOCK_CTL_REGISTER;

/**
  Extended MCi Status Pointer
**/
#define JSL_MSR_VIRT_CR_EXTENDED_MCG_PTR 0x00000793

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PhysMemPtr0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Physical memory pointer. Points to the memory
                               (DRAM or MMIO) containing Extended_MCi_Status
                               structure
                            */
    UINT32 PhysMemPtr1 : 30;

                            /* Bits[61:32], Access Type=RW, default=0x00000000*/

                            /*
                               Physical memory pointer. Points to the memory
                               (DRAM or MMIO) containing Extended_MCi_Status
                               structure
                            */
    UINT32 Overflow : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               Data space allowed to be read/written by ucode
                               in byte granularity
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* Valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_EXTENDED_MCG_PTR_REGISTER;

/**
  PIC Logical APIC ID register
**/
#define JSL_MSR_PIC_CR_PIC_EXTENDED_LOCAL_APIC_ID 0x00000802

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ApicId : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               THIS_FIELD_IS_HARD_WIRED_TO_THE_LOCAL_APIC_ID_ME
                               MORY_MAPPED_REGISTER_WHICH_IS_READ only unless
                               PIC_CR_DEBUG_MODES[12] is set) [24] Core ID '0
                               for primary core
                            */
    UINT32 ExtendedApicId : 12;

                            /* Bits[19:8], Access Type=RW, default=0x00000000*/

                            /*
                               THIS_FIELD_IS_HARD_WIRED_TO_THE_LOCAL_APIC_ID_ME
                               MORY_MAPPED_REGISTER_WHICH_IS_READ only unless
                               PIC_CR_DEBUG_MODES[12] is set) [24] Core ID '0
                               for primary core
                            */
    UINT32 Reserved20 : 12;

                            /* Bits[31:20], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_EXTENDED_LOCAL_APIC_ID_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LOCAL_UNIT_VERSION 0x00000803

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Version : 8;

                            /* Bits[7:0], Access Type=RO, default=0x00000014*/

                            /* fill description here */
    UINT32 Reserved8 : 8;

                            /* Bits[15:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 MaxLvtEntry : 8;

                            /* Bits[23:16], Access Type=RO, default=0x00000005*/

                            /* fill description here */
    UINT32 SupportEoiBdcstSuppression : 1;

                            /* Bits[24:24], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved25 : 7;

                            /* Bits[31:25], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LOCAL_UNIT_VERSION_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_TASK_PRIORITY 0x00000808

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PrioritySubClass : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Foo : 4;

                            /* Bits[7:4], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved8 : 24;

                            /* Bits[31:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TASK_PRIORITY_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_PROCESSOR_PRIORITY 0x0000080A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PrioritySubClass : 4;

                            /* Bits[3:0], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Foo : 4;

                            /* Bits[7:4], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved8 : 24;

                            /* Bits[31:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_PROCESSOR_PRIORITY_REGISTER;
/**
  APIC EOI Register.
**/
#define JSL_MSR_PIC_CR_EOI 0x0000080B
/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_EXTENDED_LOGICAL_DESTINATION 0x0000080D

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_SPURIOUS_INTERRUPT 0x0000080F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x000000FF*/

                            /* fill description here */
    UINT32 ApicSoftwareEnable : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved9 : 3;

                            /* Bits[11:9], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 EoiBroadcastSuppression : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved13 : 19;

                            /* Bits[31:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_SPURIOUS_INTERRUPT_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_ISR01 0x00000810

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Isr0Reserved : 16;

                            /* Bits[15:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Isr0 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Isr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_ISR01_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_ISR_DWORD_1 0x00000811

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_ISR23 0x00000812

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Isr2 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Isr3 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_ISR23_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_ISR_DWORD_3 0x00000813

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_ISR45 0x00000814

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Isr4 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Isr5 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_ISR45_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_ISR_DWORD_5 0x00000815

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_ISR67 0x00000816

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Isr6 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Isr7 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_ISR67_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_ISR_DWORD_7 0x00000817

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_TMR01 0x00000818

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tmr0Reserved : 16;

                            /* Bits[15:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Tmr0 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Tmr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TMR01_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_TMR_DWORD_1 0x00000819

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_TMR23 0x0000081A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tmr2 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Tmr3 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TMR23_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_TMR_DWORD_3 0x0000081B

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_TMR45 0x0000081C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tmr4 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Tmr5 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TMR45_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_TMR_DWORD_5 0x0000081D

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_TMR67 0x0000081E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tmr6 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Tmr7 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TMR67_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_TMR_DWORD_7 0x0000081F

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_IRR01 0x00000820

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Irr0Reserved : 16;

                            /* Bits[15:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Irr0 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Irr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_IRR01_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_IRR_DWORD_0 0x00000821

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_IRR23 0x00000822

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Irr2 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Irr3 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_IRR23_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_IRR_DWORD_2 0x00000823

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_IRR45 0x00000824

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Irr4 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Irr5 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_IRR45_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_IRR_DWORD_4 0x00000825

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_IRR67 0x00000826

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Irr6 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Irr7 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_IRR67_REGISTER;
/**
  fill description here
**/
#define JSL_MSR_UCODE_CR_IRR_DWORD_6 0x00000827

/**
  SKL only defines bits 7:4, and GP faults on all non-zero writes.
**/
#define JSL_MSR_PIC_CR_PIC_ERROR_STATUS 0x00000828

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SendChecksumError : 1;

                            /* Bits[0:0], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 ReceiveChecksumError : 1;

                            /* Bits[1:1], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 SendAcceptError : 1;

                            /* Bits[2:2], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 ReceiveAcceptError : 1;

                            /* Bits[3:3], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RedirectableIpi : 1;

                            /* Bits[4:4], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 SendIllegalVector : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 ReceiveIllegalVector : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 IllegalRegisterAddress : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved8 : 24;

                            /* Bits[31:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_ERROR_STATUS_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_CMCI 0x0000082F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_CMCI_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_INTERRUPT_COMMAND 0x00000830

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DestinationMode : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved13 : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Level : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved16 : 2;

                            /* Bits[17:16], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DestinationShorthand : 2;

                            /* Bits[19:18], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved20 : 12;

                            /* Bits[31:20], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DestinationField : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_INTERRUPT_COMMAND_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_TIMER 0x00000832

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_TIMER_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_THERM 0x00000833

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_THERM_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_PERF 0x00000834

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_PERF_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_LINT0 0x00000835

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               fill description here - Only RW for C6
                               save/restore for PSMI
                            */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_LINT0_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_LINT1 0x00000836

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_LINT1_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_LVT_ERROR 0x00000837

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryMode : 3;

                            /* Bits[10:8], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved11 : 1;

                            /* Bits[11:11], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RO, default=0x00000000*/

                            /* fill description here */
    UINT32 Polarity : 1;

                            /* Bits[13:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 RemoteIrr : 1;

                            /* Bits[14:14], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 TriggerMode : 1;

                            /* Bits[15:15], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Mask : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /* fill description here */
    UINT32 TimerMode : 2;

                            /* Bits[18:17], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved19 : 13;

                            /* Bits[31:19], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_LVT_ERROR_REGISTER;
/**
  This corresponds to the value in the Initial Count Register in the APIC.
**/
#define JSL_MSR_PIC_CR_PIC_TIMER_INITIAL_COUNT_REG 0x00000838
/**
  This corresponds to the value in the Current Count Register CCR in the APIC.
**/
#define JSL_MSR_PIC_CR_PIC_TIMER_CURRENT_COUNT_REG 0x00000839

/**
  This corresponds to the value in the Divide Config Register in the APIC.
**/
#define JSL_MSR_PIC_CR_PIC_TIMER_DIVIDE_CONFIG_REG 0x0000083E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CfgcntLo : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /*
                               This corresponds to the value in the Divide
                               Config Register in the APIC. Ucode writes take
                               precedence over hardware writes.
                            */
    UINT32 ReservedLo2 : 1;

                            /* Bits[2:2], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */
    UINT32 CfgcntHi : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               This corresponds to the value in the Divide
                               Config Register in the APIC. Ucode writes take
                               precedence over hardware writes.
                            */
    UINT32 ReservedHi4 : 28;

                            /* Bits[31:4], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_TIMER_DIVIDE_CONFIG_REG_REGISTER;

/**
  fill description here
**/
#define JSL_MSR_PIC_CR_PIC_SELF_IPI 0x0000083F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Vector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 SelfIpi : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Spare2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 DeliveryStatus : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /* fill description here */
    UINT32 Reserved13 : 19;

                            /* Bits[31:13], Access Type=Rsvd0, default=0x00000000*/

                            /* fill description here */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_PIC_CR_PIC_SELF_IPI_REGISTER;
/**
  This is the template to virtualize RDMSR access to all x2apic MSRs not defined in BUS2
**/
#define JSL_MSR_UCODE_CR_VIRTUAL_APIC 0x000008FF

/**
  Holds 2 XSAVE values:The X_FEATURE_ENABLED_MASK (see XSAVE EAS for details) and XSAVE_AREA triplet for the XMODIFIED optimization.
**/
#define JSL_MSR_SCP_CR_XFEM_AND_XRSTOR_INFO 0x00000900

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 XsaveAreaCpl : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /* The full CPL from the last XRSTOR instruction. */
    UINT32 XsaveAreaVmmHostGuest : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               The VMM Host/Guest state from the last XRSTOR
                               instruction.
                            */
    UINT32 Unused43 : 2;

                            /* Bits[4:3], Access Type=RW, default=0x00000000*/

                            /* Unused bits. */
    UINT32 XsaveAreaValid : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               The XSAVE_AREA valid bit is effectively an
                               address bit of the XSAVE_AREA. Since all
                               XSAVE_AREAs must be 64 byte aligned, setting
                               this bit forces the misalignment so compare of
                               this XSAVE_AREA and the XSAVE_AREA specified in
                               the XSAVE instruction must miscompare. The
                               miscompare will force all xmodified bits to be
                               treated as modified.
                            */
    UINT32 XsaveAreaAddress0 : 26;

                            /* Bits[31:6], Access Type=RW, default=0x00000000*/

                            /*
                               The XSAVE_AREA linear address from the last
                               XRSTOR.
                            */
    UINT32 XsaveAreaAddress1 : 24;

                            /* Bits[55:32], Access Type=RW, default=0x00000000*/

                            /*
                               The XSAVE_AREA linear address from the last
                               XRSTOR.
                            */
    UINT32 XFeatureEnabledMask : 8;

                            /* Bits[63:56], Access Type=RW, default=0x00000000*/

                            /*
                               Bits allocated for XCR0. Refer to "XFEM" virtual
                               defintion for bit defintions within this field.
                               Bit0 - X87, Bit1 - SSE, Bit2 - AVX, Bit 3 -
                               BNDREGS, Bit4 - BNDCFS
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_SCP_CR_XFEM_AND_XRSTOR_INFO_REGISTER;

/**
  Register which contains data breakpoint state for pending data breakpoints. It is cleared by the ROB when a ClearTMPDR6 flow marker is retired. It is writ- ten by the FPEH micro-code to correctly setup the match bits when an FLD m64/32real macroinstruction that enters it is also the target of a data breakpoint. The Exact Match micro-code copies this register to DR6. micro-code must ensure that this register is not written at the same time as a microinstruction which contains a ClearTMPDR6 or EvalTFBit flow marker is retiring. micro-code must also ensure that this register is not written at the same time as a microinstruction capable of hitting a data breakpoint is retiring
**/
#define JSL_MSR_ARR_CR_TMPDR6 0x00000902

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 B0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* B0 data breakpoint match bits. */
    UINT32 B1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* B1 data breakpoint match bits. */
    UINT32 B2 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* B2 data breakpoint match bits. */
    UINT32 B3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* B3 data breakpoint match bits. */
    UINT32 Reserved4 : 9;

                            /* Bits[12:4], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */
    UINT32 Bd : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               Bit used to save BD bit value to be placed in
                               DR6 when debug exception handler call occurs.
                            */
    UINT32 Bs : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               Bit used to save TF flag when EvalTFBit flow
                               marker is retired. If set when AcceptTraps flow
                               marker is retired, a singlestep trap is posted.
                            */
    UINT32 Bt : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Bit used to save the TSS Tbit. If set when
                               AcceptTraps flow marker is retired, a Tbit trap
                               is posted.
                            */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=Rsvd0, default=0x00000000*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_ARR_CR_TMPDR6_REGISTER;

/**
  - see SCP_CR_XU_MACROINSTRUCTION_ALIAS for SCP format
**/
#define JSL_MSR_XU_CR_MACROINSTRUCTION_ALIAS 0x00000903

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Scale : 2;

                            /* Bits[1:0], Access Type=RW, default=0x00000000*/

                            /* Scale:00,01,10,11 --) 1x,2x,4x,8x */
    UINT32 Reserved2 : 5;

                            /* Bits[6:2], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved bits - no checks. So if Xucode writes a
                               1, it will get back a 1.
                            */
    UINT32 Asize : 2;

                            /* Bits[8:7], Access Type=RW, default=0x00000000*/

                            /*
                               Address Size:00,01,10 --) 16-,32-,64-bit. Other
                               values reserved
                            */
    UINT32 Reserved9 : 2;

                            /* Bits[10:9], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved bits - no checks. So if Xucode writes a
                               1, it will get back a 1.
                            */
    UINT32 Osize : 2;

                            /* Bits[12:11], Access Type=RW, default=0x00000000*/

                            /*
                               Operand Size:00,01,10 --) 16-,32-,64-bit. Other
                               values resreved
                            */
    UINT32 Reserved13 : 2;

                            /* Bits[14:13], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved bits - no checks. So if Xucode writes a
                               1, it will get back a 1.
                            */
    UINT32 Segment : 3;

                            /* Bits[17:15], Access Type=RW, default=0x00000000*/

                            /*
                               Logical Segment:000,001,010,011,100,101 --)
                               ES,CS,SS,DS,FS,GS. Other values reserved
                            */
    UINT32 Reserved18 : 14;

                            /* Bits[31:18], Access Type=RW, default=0x00000000*/

                            /*
                               Reserved bits - no checks. So if Xucode writes a
                               1, it will get back a 1.
                            */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_XU_CR_MACROINSTRUCTION_ALIAS_REGISTER;

/**
  This MSR provides PPPE access to the POST_VMXON bit. No reserved bit checks currently to match SKL.
**/
#define JSL_MSR_VIRT_CR_VMX_CONTROL 0x00000904

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PostVmxon : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* POST_VMXON */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=Rsvd0, default=0x00000000*/

                            /* No reserved bit checks currently to match SKL */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=Rsvd0, default=0x00000000*/

                            /* No reserved bit checks currently to match SKL */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_VMX_CONTROL_REGISTER;
/**
  Used for VMX Pause Loop Exiting
**/
#define JSL_MSR_SCP_CR_VMX_PLE_FIRST 0x00000905
/**
  Used for VMX Pause Loop Exiting
**/
#define JSL_MSR_SCP_CR_VMX_PLE_LAST 0x00000906

/**
  XuCode MSR used to control SMM states. No reserved bit checks currently to match SKL.
**/
#define JSL_MSR_VIRT_CR_SMM_STATE 0x00000908

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 InSmm : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /* SMM state of the core */
    UINT32 Rsvd1 : 7;

                            /* Bits[7:1], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_VIRT_CR_SMM_STATE_REGISTER;
/**
  It is also used to hold the backup ESI
**/
#define JSL_MSR_SCP_CR_IO_SMI_BACKUP_RSI 0x00000909
/**
  This holds the backup ECX for IO SMIs.
**/
#define JSL_MSR_SCP_CR_IO_SMI_BACKUP_RCX 0x0000090A
/**
  fill description here
**/
#define JSL_MSR_SCP_CR_IO_SMI_BACKUP_RDI 0x0000090B
/**
  Write only MSR for Xucode to write PDM data after sending the header (via WRMSR to PDM_HEADER)
**/
#define JSL_MSR_UCODE_CR_PDM_MSG 0x0000090D

/**
  register
**/
#define JSL_MSR_CORE_INTERFACE_CR_GT_RELOAD_FLUSH 0x0000090E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BcldReq : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               This is a Write-Only cmd MSR. A write causes GT
                               to flush outstanding transactions and re-load
                               it's boot context. A Rd will GP Fault. With the
                               removal of the GT_CREG_ADDR_DIFFERENTIATOR there
                               is no need for this to be virtual
                            */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RW, default=0x00000000*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} JSL_MSR_CORE_INTERFACE_CR_GT_RELOAD_FLUSH_REGISTER;
/**
  register
**/
#define JSL_MSR_CORE_INTERFACE_CR_GT_FLUSH_BCLD_ACK 0x0000090F

/**
  GLP e1404572178: Read only XuMSR
**/
#define JSL_MSR_UCODE_CR_XU_STATUS 0x00000910

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 C6DramEnabled : 1;

                            /* Bits[0:0], Access Type=RO, default=0x00000000*/

                            /*
                               C6 DRAM enabled. Have to enumerate this for LKF
                               Mcheck to support C6DRAM on HTC
                            */
    UINT32 Rsvd1