
/** @file
  RklMsr.h

  @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _RKLMSR_h
#define _RKLMSR_h
#include <Base.h>

/**
  Register to disable split locks, which are locked instructions that split a cache line.
**/
#define RKL_MSR_MEMORY_CONTROL 0x00000033

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 29;

                            /* Bits[28:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SplitLockDisable : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, a split lock will trigger an #AC
                               fault. If clear to 0, split locks proceed
                               normally (subjected to the "SUPPRESS_SPLIT_LOCK"
                               behavior. If both this bit and
                               SUPPRESS_SPLIT_LOCK are set, then only this bit
                               will be honored (has priority).
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SuppressSplitLock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, disables split locks. If clear to
                               0, enables split locks. Setting this bit will
                               cause split locks to be non-atomic, despite the
                               lock attribute of the instruction.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MEMORY_CONTROL_REGISTER;
/**
  new MSR to flush caches
**/
#define RKL_MSR_ADR_CACHE_FLUSH 0x00000056
/**
  MSR to provision VCM key hash to CPU
**/
#define RKL_MSR_PFR_VCM_PROVISION 0x00000067

/**
  MSR to read PFR provision status
**/
#define RKL_MSR_PFR_VCM_PROVISION_STATUS 0x00000068

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Signature : 16;

                            /* Bits[15:0], Access Type=RW, default=None*/

                            /* PFR signature in CPLD */
    UINT32 PfrEnabled : 1;

                            /* Bits[16:16], Access Type=RW, default=None*/

                            /* PFR enable indication */
    UINT32 CpuProvision : 1;

                            /* Bits[17:17], Access Type=RW, default=None*/

                            /* CPU NVRAM is provisioned */
    UINT32 CpuProvisionLock : 1;

                            /* Bits[18:18], Access Type=RW, default=None*/

                            /* CPU NVRAM is locked */
    UINT32 Rsvd19 : 11;

                            /* Bits[29:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Error : 1;

                            /* Bits[30:30], Access Type=RW, default=None*/

                            /* Error indicatoin */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PFR_VCM_PROVISION_STATUS_REGISTER;

/**
  Holds the error pin status
**/
#define RKL_MSR_IIO_ERRPINSTS 0x00000069

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Err0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               State of ERROR[0] pin (the register value is
                               active high. RW1CS
                            */
    UINT32 Err1 : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               State of ERROR[1] pin (the register value is
                               active high. RW1CS
                            */
    UINT32 Err2 : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /*
                               State of ERROR[2] pin (the register value is
                               active high. RW1CS
                            */
    UINT32 Rsvd3 : 29;

                            /* Bits[31:3], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_IIO_ERRPINSTS_REGISTER;

/**
  Register to tune HL configuration
**/
#define RKL_MSR_PREF_TUNING 0x0000006C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /*
                               Number of forward hits to detector to trigger
                               fwd prefetching
                            */
    UINT32 Rsvd3 : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /*
                               Number of backward hits to detector to trigger
                               bwd prefetching
                            */
    UINT32 BlockDispatchThreshold : 5;

                            /* Bits[10:6], Access Type=RW, default=0x00000000*/

                            /*
                               When IDIDPTStateMnn1H == 0: Minimum number of
                               available SQ entries, above which OQ block
                               dispatch fires When IDIDPTStateMnn1H > 0 this
                               field is ignored and
                               DPT_BLOCK_DISPATCH_THRESHOLD is used instead
                            */
    UINT32 Rsvd11 : 5;

                            /* Bits[15:11], Access Type=RW, default=0x00000000*/

                            /*
                               No. of MLC Miss SQ entries before spatials are
                               dropped
                            */
    UINT32 DisableDemandThrottling : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Disable Demand Throttling algorithm */
    UINT32 DemandThrottlingOverride : 6;

                            /* Bits[22:17], Access Type=RW, default=0x00000008*/

                            /*
                               No. of demand hits to a detector needed to
                               override throttle state
                            */
    UINT32 DemandThrottlingThreshold : 4;

                            /* Bits[26:23], Access Type=RW, default=0x0000000A*/

                            /*
                               Threshold of demand avg value that causes thread
                               demand throttling
                            */
    UINT32 DptBlockDispatchThreshold : 5;

                            /* Bits[31:27], Access Type=RW, default=0x00000002*/

                            /*
                               When IDIDPTStateMnn1H > 0: Minimum number of
                               available SQ entries, above which OQ block
                               dispatch fires When IDIDPTStateMnn1H == 0 this
                               field is ignored and BLOCK_DISPATCH_THRESHOLD is
                               used instead
                            */
    UINT32 MlprefWindowSize : 5;

                            /* Bits[36:32], Access Type=RW, default=0x00000014*/

                            /* MLC window size (unless throttled to half size) */
    UINT32 MlprefHalfWindowThreshold : 5;

                            /* Bits[41:37], Access Type=RW, default=0x0000000F*/

                            /*
                               If number of SQ entries in UNC states is greater
                               than threshold, divide the MLC window by 2
                            */
    UINT32 MlprefBlockThreshold : 5;

                            /* Bits[46:42], Access Type=RW, default=0x0000000E*/

                            /*
                               If number of SQ entries in UNC states is greater
                               than threshold, block MLC prefetches (LLC ones
                               can still dispatch)
                            */
    UINT32 MhlLhlMinDist : 5;

                            /* Bits[51:47], Access Type=RW, default=0x00000008*/

                            /*
                               Minimal distance allowed between HLs, advance
                               LHL if below
                            */
    UINT32 MhlLhlMaxDist : 6;

                            /* Bits[57:52], Access Type=RW, default=0x0000003F*/

                            /*
                               Max distance allowed between HLs, block LHL if
                               reached.
                            */
    UINT32 FarRange : 6;

                            /* Bits[63:58], Access Type=RW, default=0x00000020*/

                            /* Far window range */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PREF_TUNING_REGISTER;

/**
  Register to tune HL configuration
**/
#define RKL_MSR_FEATURE_TUNING_1 0x0000006D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 2;

                            /* Bits[1:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Bi2ifu4FVictimsEn : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Enable BI to IFU for F-State lines */
    UINT32 Enabledbpforf : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Enable DBP for lines in F state */
    UINT32 Rsvd4 : 15;

                            /* Bits[18:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PauseLoopCnt : 2;

                            /* Bits[20:19], Access Type=RW, default=0x00000002*/

                            /*
                               Init value for pause loop counter. 00 - no
                               couting. 01 - 6 bit counter. 10 - 7 bit. 11 - 8
                               bit.
                            */
    UINT32 Rsvd21 : 6;

                            /* Bits[26:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DisableFastgo : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /*
                               Maintains SNB Legacy behavior for LFB
                               Virtualization - ignore FastGO
                            */
    UINT32 Rsvd28 : 2;

                            /* Bits[29:28], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Speci2men : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               If set, RFO's are stalled and Speculative I2M is
                               allowed
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 3;

                            /* Bits[34:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RfoTrainDisable : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /* Disable MPL training for DCU RFOs and RFOLs */
    UINT32 Rsvd36 : 15;

                            /* Bits[50:36], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DisableLlpref : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /* Disable prefetch to LLC */
    UINT32 Rsvd52 : 8;

                            /* Bits[59:52], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DptDisable : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /*
                               Forces the Dynamic Prefetch Throttling State to
                               1'b0 (default)
                            */
    UINT32 Rsvd61 : 3;

                            /* Bits[63:61], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_FEATURE_TUNING_1_REGISTER;

/**
  MSR to support runtime tuning of CR-QoS feature
**/
#define RKL_MSR_AEP_QOS 0x0000006E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Leakybktsatvalue : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000050*/

                            /* Saturation Value for 2LM Leakybkt Counter */
    UINT32 Leakybktwindowcntr : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000100*/

                            /* Time window cntr Value for 2LM LeakyBkt Cntr */
    UINT32 Threshold : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000040*/

                            /*
                               Threshold value above which 2LMDDRTThExceeded to
                               CMS is asserted
                            */
    UINT32 LowThreshold : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000010*/

                            /*
                               Low Threshold below which all distress detection
                               bits are cleared
                            */
    UINT32 Thdisable : 1;

                            /* Bits[48:48], Access Type=RW, default=0x00000000*/

                            /*
                               Bit to defeature 2LMDDRThExceeded assertion to
                               CMS
                            */
    UINT32 Rsvd49 : 15;

                            /* Bits[63:49], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_AEP_QOS_REGISTER;

/**
  MSR to indicate directory disable status
**/
#define RKL_MSR_DIR_DIS_STATUS 0x0000006F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DisDirectory : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000001*/

                            /*
                               Disable Directory. Directory should be disabled
                               for single socket configurations. Directory
                               should be enabled for all multi-socket
                               configurations
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_DIR_DIS_STATUS_REGISTER;

/**
  MKTME KEYID PARTITIONING
**/
#define RKL_MSR_MKTME_KEYID_PARTITIONING 0x00000087

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NumMktmeKids : 16;

                            /* Bits[15:0], Access Type=RW, default=None*/

                            /* Number of usable MK-TME KeyIDs */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MKTME_KEYID_PARTITIONING_REGISTER;

/**
  MSR to expose the MCHECK error code to BIOS
**/
#define RKL_MSR_SGX_MCU_ERRORCODE 0x000000A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McheckErrorCode : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* MCHECK error code from MCHECK-ucode API */
    UINT32 Rsvd16 : 15;

                            /* Bits[30:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PatchRevIdStatusPppeLoadFail : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               per thread bit to indicate partial or full
                               success
                            */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_SGX_MCU_ERRORCODE_REGISTER;
/**
  SGX PRID values
**/
#define RKL_MSR_PRID_0 0x000000A1
/**
  SGX PRID values
**/
#define RKL_MSR_PRID_1 0x000000A2

/**
  FIT BIOS and ACM error type and code
**/
#define RKL_MSR_FIT_BIOS_ERROR 0x000000A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorCode : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /* error code optype */
    UINT32 EntryType : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /* entry type optype */
    UINT32 FitPatchEntry : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* indication whether patch entry exists in FIT */
    UINT32 Rsvd17 : 15;

                            /* Bits[31:17], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* Lock bit - set when FIT error is written to FSCP */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_FIT_BIOS_ERROR_REGISTER;

/**
  Override MPX Fuse.
**/
#define RKL_MSR_MPX_FUSE_OVERRIDE 0x000000A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MpxEnabled : 1;

                            /* Bits[0:0], Access Type=RO_V, default=None*/

                            /* MPX Enable */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO_V, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO_V, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MPX_FUSE_OVERRIDE_REGISTER;

/**
  Virtual MSR to disable AVX instructions from BIOS
**/
#define RKL_MSR_BIOS_AVX_DIS 0x000000AF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AvxDis : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* disable AVX/2/3 instructions */
    UINT32 Avx3Dis : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* disable AVX3 instructions */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_BIOS_AVX_DIS_REGISTER;
/**
  vMSRs for power mgmt
**/
#define RKL_MSR_VMSR_U2P_0 0x000000B0
/**
  vMSRs for power mgmt
**/
#define RKL_MSR_VMSR_U2P_1 0x000000B1
/**
  vMSRs for power mgmt
**/
#define RKL_MSR_VMSR_U2P_2 0x000000B2
/**
  vMSRs for power mgmt
**/
#define RKL_MSR_VMSR_U2P_3 0x000000B3

/**
  This register contains read-only package-level ratio information
**/
#define RKL_MSR_PLATFORM_INFO 0x000000CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=RWS, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxNonTurboLimRatio : 8;

                            /* Bits[15:8], Access Type=RWS, default=0x00000000*/

                            /* The Maximum Non-Turbo Ratio */
    UINT32 SmmSaveCap : 1;

                            /* Bits[16:16], Access Type=RO, default=0x00000001*/

                            /*
                               When set to '1' indicates this feature exists
                               and is configured by SMM_SAVE_CONTROL
                            */
    UINT32 Rsvd17 : 6;

                            /* Bits[22:17], Access Type=RWS, default=0x00000000*/

                            /* Reserved */
    UINT32 PpinCap : 1;

                            /* Bits[23:23], Access Type=RWS, default=0x00000000*/

                            /*
                               When set to 1, indicates that this part supports
                               the Protected Processor Inventory Number (PPIN)
                               feature.
                            */
    UINT32 OcvoltOvrdAvail : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support
                               Voltage override overclocking. 1b Indicates that
                               the part supports Voltage override overclocking.
                            */
    UINT32 FivrRfiTuningAvail : 1;

                            /* Bits[25:25], Access Type=RWS, default=0x00000000*/

                            /* FIVR RFI Tuning Support */
    UINT32 Dcu16kModeAvail : 1;

                            /* Bits[26:26], Access Type=RWS, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support the
                               16K DCU mode. 1b Indicates that the part
                               supports 16K DCU mode.
                            */
    UINT32 SamplePart : 1;

                            /* Bits[27:27], Access Type=RWS, default=0x00000000*/

                            /*
                               A value of 1 indicates the processor is a
                               preproduction sample and a property of Intel, a
                               value of 0 indicates the part is intended for
                               production.
                            */
    UINT32 PrgTurboRatioEn : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000001*/

                            /*
                               Programmable Turbo Ratios per number of Active
                               Cores 0 = Programming Not Allowed 1 =
                               Programming Allowed
                            */
    UINT32 PrgTdpLimEn : 1;

                            /* Bits[29:29], Access Type=RWS, default=0x00000001*/

                            /*
                               Programmable TDP Limits for Turbo Mode. 0 =
                               Programming Not Allowed 1 = Programming Allowed
                            */
    UINT32 PrgTjOffsetEn : 1;

                            /* Bits[30:30], Access Type=RWS, default=0x00000001*/

                            /*
                               Programmable TJ Offset Enable. 0 = Programming
                               Not Allowed 1 = Programming Allowed
                            */
    UINT32 CpuidFaultingEn : 1;

                            /* Bits[31:31], Access Type=RWS, default=0x00000001*/

                            /*
                               When set to 1 indicates that the processor
                               supports raising a #GP if CPUID is executed when
                               not in SMM and the CPL > 0. When this bit is
                               set, it indicates that MISC_FEATURE_ENABLES[0]
                               can be written by a VMM.
                            */
    UINT32 LpmSupport : 1;

                            /* Bits[32:32], Access Type=RWS, default=0x00000000*/

                            /*
                               0 - Low Power Mode not Supported 1 - Low Power
                               Mode Supported
                            */
    UINT32 ConfigTdpLevels : 2;

                            /* Bits[34:33], Access Type=RWS, default=0x00000000*/

                            /*
                               Configurable TDP Levels 00 Config TDP not
                               supported 01 One additional TDP level supported
                               10 Two additional TDP levels supported 11
                               Reserved
                            */
    UINT32 PfatEnable : 1;

                            /* Bits[35:35], Access Type=RWS, default=0x00000000*/

                            /*
                               BIOS GUARD (PFAT) Enable. 0 = PFAT is disabled 1
                               = PFAT is enabled
                            */
    UINT32 Peg2dmidisEn : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000001*/

                            /*
                               0 = PEG2DMIDIS is disabled 1 = PEG2DMIDIS is
                               enabled
                            */
    UINT32 TimedMwaitEnable : 1;

                            /* Bits[37:37], Access Type=RWS, default=0x00000000*/

                            /*
                               Timed MWAIT Enable. 0 = Timed MWAIT is disabled
                               1 = Timed MWAIT is enabled
                            */
    UINT32 AsaEn : 1;

                            /* Bits[38:38], Access Type=RWS, default=0x00000001*/

                            /*
                               ASA Enable. 0 = ASA is disabled 1 = ASA is
                               enabled
                            */
    UINT32 Rsvd39 : 1;

                            /* Bits[39:39], Access Type=RWS, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxEfficiencyRatio : 8;

                            /* Bits[47:40], Access Type=RWS, default=0x00000000*/

                            /*
                               Maximum Efficienty Ratio. This is given in units
                               of 100 MHz.
                            */
    UINT32 MinOperatingRatio : 8;

                            /* Bits[55:48], Access Type=RW, default=0x00000008*/

                            /* Minimum Supported Ratio in units of 100MHz */
    UINT32 PushpatchEn : 1;

                            /* Bits[56:56], Access Type=RWS, default=0x00000000*/

                            /*
                               The value of this bit is the INVERTED value of
                               FUSE_PUSH_PATCH_DIS
                            */
    UINT32 EdramEnable : 1;

                            /* Bits[57:57], Access Type=RWS, default=0x00000000*/

                            /*
                               Indicates to BIOS that memory-side ACPI tables
                               can be used
                            */
    UINT32 Sxp2lmEnable : 1;

                            /* Bits[58:58], Access Type=RWS, default=0x00000000*/

                            /*
                               Indicates to BIOS that the FME_ACTIVATE MSR can
                               be setup Indicates to BIOS that the FZM
                               functionality can be enabled
                            */
    UINT32 SmmSupovrStateLockEnable : 1;

                            /* Bits[59:59], Access Type=RWS, default=0x00000001*/

                            /*
                               Indicates to BIOS that the SMM_SUPOVR_STATE_LOCK
                               MSR can be setup. This bit is unconditionally
                               set for SoCs that support SNC
                            */
    UINT32 TioEnable : 1;

                            /* Bits[60:60], Access Type=RWS, default=0x00000000*/

                            /*
                               Indicates to BIOS that the Trusted IO (TIO) MSRs
                               can be accessed Indicates to BIOS that the
                               Trusted IO (TIO) functionality can be enabled
                               The value of this bit is the same as FUSE_TIO
                            */
    UINT32 Rsvd61 : 3;

                            /* Bits[63:61], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PLATFORM_INFO_REGISTER;
/**
  This RO MSR will be used to read the Ubox MMCFG_RULE_CFG list
**/
#define RKL_MSR_MMCFG_RULE_CFG 0x00000129
/**
  This RO MSR will be used to read the Ubox MMCFG_RULE_TARGET_LIST
**/
#define RKL_MSR_MMCFG_RULE_TARGET_LIST 0x0000012A
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_0 0x00000130
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_1 0x00000131
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_2 0x00000132
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_3 0x00000133
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_4 0x00000134
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_5 0x00000135
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_6 0x00000136
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
**/
#define RKL_MSR_ANC_BOOT_POLICY_7 0x00000137
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_CORE_SPECIFIC_SPARE_0 0x0000013D
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_CORE_SPECIFIC_SPARE_1 0x0000013E
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_CORE_SPECIFIC_SPARE_2 0x0000013F
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_0 0x00000142
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_1 0x00000143
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_2 0x00000144
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_3 0x00000145
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_4 0x00000146
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_5 0x00000147
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_6 0x00000148
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_7 0x00000149
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_8 0x0000014A
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_9 0x0000014B
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_10 0x0000014C
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_11 0x0000014D
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_12 0x0000014E
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
**/
#define RKL_MSR_THREAD_SPECIFIC_SPARE_13 0x0000014F

/**
  SNC_CONFIG_BASE register decription
**/
#define RKL_MSR_SNC_CONFIG 0x00000152

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SncEnable : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 SncIndicationEnable : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 NumberOfClusters : 2;

                            /* Bits[3:2], Access Type=RW_V, default=0x00000000*/

                            /* Number Of Clusters */
    UINT32 Cluster1Base : 6;

                            /* Bits[9:4], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 2 Base */
    UINT32 Cluster2Base : 6;

                            /* Bits[15:10], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 3 Base */
    UINT32 Cluster3Base : 6;

                            /* Bits[21:16], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 4 Base */
    UINT32 Rsvd22 : 6;

                            /* Bits[27:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SncLock : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Due to SKL B0 freeze this late arrving bit is
                               implemented in
                               FSCP_CR_MISC_FEATURE_ENABLES[SNC_LOCK]
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_SNC_CONFIG_REGISTER;

/**
  Read-only MSR that specifies the maximum number of memory controllers on the platform capable of supporting memory persistence
**/
#define RKL_MSR_PERMEM_CONFIG_INFO 0x0000015C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ControllerCount : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               maximum number of memory controllers on the
                               platform capable of supporting memory
                               persistence
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERMEM_CONFIG_INFO_REGISTER;

/**
  Index into the list of persistent memory addresses which is accessed when the PERMEM_CTRLR_ID MSR is read/written
**/
#define RKL_MSR_PERMEM_CTRLR_INDEX 0x0000015D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ControllerIndex : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* Index into persistent memory address list */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERMEM_CTRLR_INDEX_REGISTER;

/**
  Read-only MSR that specifies the maximum number of memory controllers on the platform capable of supporting memory persistence
**/
#define RKL_MSR_PERMEM_CTRLR_ID 0x0000015E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 6;

                            /* Bits[5:0], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 ControllerIdentifier0 : 26;

                            /* Bits[31:6], Access Type=RW, default=None*/

                            /*
                               memory address that uniquely identifies a
                               persistent memory controller, whose index in
                               list is specified by PERMEM_CTRLR_INDEX
                            */
    UINT32 ControllerIdentifier1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               memory address that uniquely identifies a
                               persistent memory controller, whose index in
                               list is specified by PERMEM_CTRLR_INDEX
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERMEM_CTRLR_ID_REGISTER;

/**
  MCP Thermal reporting.
  This CSR is a mirror of MSR (1a3h) MCP_THERMAL_REPORT_1
**/
#define RKL_MSR_MCP_THERMAL_REPORT_1 0x000001A3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MarginToThrottle : 16;

                            /* Bits[15:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               Margin to Throttle represents the nomalized
                               temperature margin until throttling engages on
                               any component. It reports the minimum of the
                               temperature margins on different dies. Each
                               margin represents the current sensor temperature
                               relative to the temperature when the hotspot on
                               the die is at its Tj,max. It is reported as a
                               negative number in signed, filtered 10.6 fixed-
                               point format. Note: This is also reported via
                               PECS as the PCS index 2 function.
                            */
    UINT32 MarginToTcontrol : 16;

                            /* Bits[31:16], Access Type=RO_V, default=0x00000000*/

                            /*
                               Margin to TCONTROL reports the minimum thermal
                               margin relative to the thermal spec based on KNL
                               DTS with TCONTROL, This field is relevant only
                               for components with TCONTROL specified for
                               system fan speed control - to ensure long term
                               reliability. Margin to Tcontrol is reported in
                               signed, filtered 10.6 fixed-point format. If a
                               negative value is reported, representing a gap
                               to TCONTROL spec, the system must increase fan
                               speed. If a positive value is reported,
                               representing a margin to TCONTROL spec, the
                               system can decrease fan speed. Note: This is
                               also reported via PECS as the PCS index 10
                               function.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MCP_THERMAL_REPORT_1_REGISTER;

/**
  MCP Thermal reporting.
  This CSR is a mirror of MSR (1A4h) MCP_THERMAL_REPORT_2.
**/
#define RKL_MSR_MCP_THERMAL_REPORT_2 0x000001A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PackageAbsoluteMaxTemperature : 16;

                            /* Bits[15:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               Package Absolute Max Temperature reports the
                               hottest absolute temperature of any component in
                               the multi-chip package. This field is reported
                               in signed, absolute, filtered 10.6 fixed-point
                               format. Note: This is also reported via PECS as
                               PCS index 9 command with parameter 0x80.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO_V, default=0x00000000*/

                            /* Reserved for future use. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MCP_THERMAL_REPORT_2_REGISTER;

/**
  Offcore Response Event Select Register
**/
#define RKL_MSR_OFFCORE_RSP_0 0x000001A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               Reserved MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Spare : 3;

                            /* Bits[40:38], Access Type=RW, default=0x00000000*/

                            /* Reserved. */
    UINT32 Rsvd41 : 23;

                            /* Bits[63:41], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_OFFCORE_RSP_0_REGISTER;

/**
  Offcore Response Event Select Register
**/
#define RKL_MSR_OFFCORE_RSP_1 0x000001A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               Reserved MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Spare : 3;

                            /* Bits[40:38], Access Type=RW, default=0x00000000*/

                            /* Reserved. */
    UINT32 Rsvd41 : 23;

                            /* Bits[63:41], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_OFFCORE_RSP_1_REGISTER;

/**
  NHM creg to filter LBR writes
**/
#define RKL_MSR_LBR_SELECT 0x000001C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CplEq0 : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* filter out ring 0 branches */
    UINT32 CplNeq0 : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* filter out non-ring 0 branches */
    UINT32 Jcc : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* filter out taken conditional branches */
    UINT32 NearRelCall : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /* filter out near relative calls */
    UINT32 NearIndirectCall : 1;

                            /* Bits[4:4], Access Type=RW, default=None*/

                            /* filter out near indirect calls */
    UINT32 NearRet : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* filter out near returns */
    UINT32 NearIndirectJmp : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* filter out near unconditional indirect jumps */
    UINT32 NearRelJmp : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* filter out near unconditional relative branches */
    UINT32 FarBranch : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* filter out far branches */
    UINT32 CallStack : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* enable LBR to only collect calls */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_SELECT_REGISTER;

/**
  LBR creg that holds the TOS value
**/
#define RKL_MSR_LBR_TOS 0x000001C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tos : 5;

                            /* Bits[4:0], Access Type=RW_V, default=None*/

                            /* LBR TOS */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TOS_REGISTER;

/**
  LAST_BRANCH LBR MSR that holds non-IP information
**/
#define RKL_MSR_LAST_BRANCH_INFO 0x000001DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RO_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RO_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RO_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RO_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_BRANCH_INFO_REGISTER;

/**
  Top of LBR Stack
**/
#define RKL_MSR_LAST_BRANCH_FROM_IP 0x000001DB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=None*/

                            /* FROM LBR at Top of stack */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RO_V, default=None*/

                            /* FROM LBR at Top of stack */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_BRANCH_FROM_IP_REGISTER;

/**
  Top of LBR Stack
**/
#define RKL_MSR_LAST_BRANCH_TO_IP 0x000001DC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=None*/

                            /* TO LBR at top of stack */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RO_V, default=None*/

                            /* TO LBR at top of stack */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_BRANCH_TO_IP_REGISTER;

/**
  Last Exeception Record
**/
#define RKL_MSR_LAST_INT_FROM_IP 0x000001DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LoData : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /* low FROM addr of Last Exeception Record */
    UINT32 HiData : 25;

                            /* Bits[56:32], Access Type=RW, default=None*/

                            /* high FROM addr of Last Exeception Record */
    UINT32 CycleCount : 3;

                            /* Bits[59:57], Access Type=RO_V, default=None*/

                            /* 3 MSBs of the cycle counter */
    UINT32 CycCtrMode : 1;

                            /* Bits[60:60], Access Type=RO_V, default=None*/

                            /* cycle counter mode */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW, default=None*/

                            /* TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW, default=None*/

                            /* ROB is in TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* MBr was mispredicted */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_INT_FROM_IP_REGISTER;

/**
  Last Exeception Record
**/
#define RKL_MSR_LAST_INT_TO_IP 0x000001DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LoData : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /* low TO addr of Last Exeception Record */
    UINT32 HiData : 25;

                            /* Bits[56:32], Access Type=RW, default=None*/

                            /*
                               high TO addr of Last Exeception Record. If VAPA
                               is fuse-disabled, then bits [56:48] are also
                               part of the CYCLE_COUNT
                            */
    UINT32 CycleCount : 7;

                            /* Bits[63:57], Access Type=RW, default=None*/

                            /* Elapsed cycle counter from previous branch */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_INT_TO_IP_REGISTER;

/**
  LER MSR that holds non-IP information
**/
#define RKL_MSR_LAST_INT_INFO 0x000001E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LAST_INT_INFO_REGISTER;

/**
  Register used to enable customer specific features
**/
#define RKL_MSR_CUSTOMER_SPECIFIC_FEATURE_ENABLE 0x000001E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* RSVD */
    UINT32 UserLevelMwaitEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Enable bit for user-level mwait */
    UINT32 RsvdUpper2 : 30;

                            /* Bits[31:2], Access Type=RW, default=0x00000000*/

                            /* RSVD */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_CUSTOMER_SPECIFIC_FEATURE_ENABLE_REGISTER;

/**
  User-level Interrupts Vector
**/
#define RKL_MSR_ULI_VECTOR_INFO 0x000001E5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MatchVector : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Interrupt vector to match on to provide ULI
                               handling
                            */
    UINT32 Enable : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /* Enable bit for ULI handling */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_ULI_VECTOR_INFO_REGISTER;
/**
  User-level Interrupts Target RIP
**/
#define RKL_MSR_ULI_TARGET_RIP 0x000001E7

/**
  Valid PRMRR configurations
**/
#define RKL_MSR_PRMRR_VALID_CONFIG 0x000001FB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Config1m : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* 1M supported MEE size */
    UINT32 Config2m : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* 2M supported MEE size */
    UINT32 Rsvd2 : 3;

                            /* Bits[4:2], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Config32m : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* 32M supported MEE size */
    UINT32 Config64m : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* 64M supported MEE size */
    UINT32 Config128m : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* 128M supported MEE size */
    UINT32 Config256m : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* 256M supported MEE size */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_VALID_CONFIG_REGISTER;

/**
  IMCx_CR_MCx_CTL2 is responsible for enabling and controlling the CMCI mechanism and the correctable threshold value. (described in section 2.2.1 of the MCA HAS).
**/
#define RKL_MSR_IMC0_MC_CTL2 0x0000028D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorErrCntTh : 15;

                            /* Bits[14:0], Access Type=RWS, default=0x00000000*/

                            /* Corrected error count threshold. */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MapCmciToCsmi : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               Map Correctable Machine Check Interrupts to
                               Correctable SM Interrupts
                            */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MapMceToMsmi : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               Map Machine Check Errors to Machine check SM
                               Interrupts
                            */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_IMC0_MC_CTL2_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_1 0x000002A1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_1_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_2 0x000002A2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_2_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_3 0x000002A3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_3_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_4 0x000002A4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_4_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_5 0x000002A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_5_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_6 0x000002A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_6_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
**/
#define RKL_MSR_PRMRR_BASE_7 0x000002A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PRMRR_BASE_7_REGISTER;

/**
  Holds global control fields for the NCU PMON counters for IDP 0.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define RKL_MSR_PERF_CTL 0x000003B5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 5;

                            /* Bits[4:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [4:1]
                               Core ID. When "TID Filter Enable" is clear in
                               the Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Gtid : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               When this field is set (!=0) and TID Filter
                               Enable is set, only GT events will be count.
                               When this bit unset (==0) the filtering will be
                               according to threadid field.
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_CTL_REGISTER;

/**
  IDP 1 PMON Counter 1  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define RKL_MSR_PERF_CTR_0 0x000003B8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_CTR_0_REGISTER;

/**
  IDP 1 PMON Counter 2  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define RKL_MSR_PERF_CTR_1 0x000003B9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_CTR_1_REGISTER;

/**
  IDP 1 PMON Status register.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define RKL_MSR_PERF_STATUS 0x000003BC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Ovfcntr0 : 1;

                            /* Bits[0:0], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               0. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Ovfcntr1 : 1;

                            /* Bits[1:1], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates overflow Condition on the NCU Counter
                               1. Read 0 - counter didn't overflow 1 - couner
                               overflow occured. Write 0 - ignored
                            */
    UINT32 Rsvd2 : 30;

                            /* Bits[31:2], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_STATUS_REGISTER;

/**
  Precise Performance Monitoring (PPMON) Event Control.  This register is read-write.
**/
#define RKL_MSR_PEBS_FRONTEND 0x000003F7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /*
                               Choose which event to monitor (ie. 1: L1_IMISS,
                               2: MLC_MISS, 3: ITLB_MISS, 4: STLB_MISS, 5:
                               DSB_MISS, 6: IDQ_READ_BUBBLES)
                            */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 CriticalFilter : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When asserted, cycles occurring while IDQ is
                               empty are filtered, otherwise they are
                               monitored.
                            */
    UINT32 Rsvd5 : 3;

                            /* Bits[7:5], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 FeLatency : 12;

                            /* Bits[19:8], Access Type=RW, default=0x00000008*/

                            /*
                               Number of consecutive cycles not having less
                               than FE_THRESHOLD bubbles which must occur
                               before logging the event.
                            */
    UINT32 FeThreshold : 3;

                            /* Bits[22:20], Access Type=RW, default=0x00000000*/

                            /*
                               Number of delivery bubbles (or more) of cycles
                               to count. If number of delivery bubbles is
                               greater than or equal to this field, then count
                               it.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PEBS_FRONTEND_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_PKG_C3_RESIDENCY_COUNTER 0x000003F8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C3_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_PKG_C6_RESIDENCY_COUNTER 0x000003F9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C6_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_PKG_C7_RESIDENCY_COUNTER 0x000003FA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C7_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Core C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_CORE_C7_RESIDENCY_COUNTER 0x000003FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_CORE_C7_RESIDENCY_COUNTER_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define RKL_MSR_IMC0_MC_ADDR 0x00000436

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_IMC0_MC_ADDR_REGISTER;

/**
  The MCiMISC MSR contains additional micro-architecture specific information describing the machine check error if the MISCV flag in the MCiSTATUS register is set. It is also possible to use the Other Info field in the MCiSTATUS register for the same type of model specific error reporting
**/
#define RKL_MSR_IMC0_MC_MISC 0x00000437

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecErrLsb : 6;

                            /* Bits[5:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the LSB of the recoverable address
                               (this may differ from unit to unit). This tells
                               the OS to ignore bits from LSB-1:0
                            */
    UINT32 AddrMode : 3;

                            /* Bits[8:6], Access Type=RWS_V, default=0x00000000*/

                            /*
                               defines the type of address captured in the
                               MC5ADDR MSR. Set by hardware, Clear by
                               programming. 000: Segment Offset 001: Linear
                               Address 010: Physical (system) Address 011:
                               Memory Address 111: Generic
                            */
    UINT32 ExtraErrInfo0 : 23;

                            /* Bits[31:9], Access Type=RWS_V, default=0x00000000*/

                            /*  */
    UINT32 ExtraErrInfo1 : 32;

                            /* Bits[63:32], Access Type=RWS_V, default=0x00000000*/

                            /*  */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_IMC0_MC_MISC_REGISTER;

/**
  EDRAM 0 Machine Check Architecture Miscellaneous MSR.
**/
#define RKL_MSR_MC19_MISC 0x0000044F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorAddress : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               This field contains the address of uncorrected
                               error seen in the PCU/VCU. It is updated on an
                               uncorrectable error. To maintain e-MCA support
                               this register must be writable.
                            */
    UINT32 CorrectedErrorCount : 8;

                            /* Bits[23:16], Access Type=RWS_V, default=0x00000000*/

                            /* Corrected Error Count */
    UINT32 EnhMcaAvail0 : 8;

                            /* Bits[31:24], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */
    UINT32 EnhMcaAvail1 : 32;

                            /* Bits[63:32], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC19_MISC_REGISTER;

/**
  EDRAM 1 Machine Check Architecture Miscellaneous MSR.
**/
#define RKL_MSR_MC20_MISC 0x00000453

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorAddress : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               This field contains the address of uncorrected
                               error seen in the PCU/VCU. It is updated on an
                               uncorrectable error. To maintain e-MCA support
                               this register must be writable.
                            */
    UINT32 CorrectedErrorCount : 8;

                            /* Bits[23:16], Access Type=RWS_V, default=0x00000000*/

                            /* Corrected Error Count */
    UINT32 EnhMcaAvail0 : 8;

                            /* Bits[31:24], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */
    UINT32 EnhMcaAvail1 : 32;

                            /* Bits[63:32], Access Type=RWS_V, default=0x00000000*/

                            /* Available when enhanced MCA is in use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC20_MISC_REGISTER;

/**
  The MCiCTL MSR controls the signalling of machine check exceptions generated by the bank.
**/
#define RKL_MSR_MC25_CTL 0x00000464

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DataSpareErr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data sparing
                               errors.
                            */
    UINT32 DataScrubErr : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data scrubbing
                               errors.
                            */
    UINT32 DataWrtErr : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for data write errors */
    UINT32 DataByteEnableErr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data byte enable
                               errors
                            */
    UINT32 AddrErr : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for address errors */
    UINT32 CorrRdErr : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               Enables exception signalling for normal read
                               errors.
                            */
    UINT32 WdbParErr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WDB parity err */
    UINT32 ApppParErr : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for address path
                               parity protection err
                            */
    UINT32 Mc2lmInvalReqErr : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unrecognized
                               request to 2LM controller
                            */
    UINT32 Mc2lmDatToInvalEntErr : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for read response to
                               an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmUnexpectedReadrspErr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unexpected 2LM
                               read response
                            */
    UINT32 Mc2lmDdr4CmpErr : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDR4 completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmDdrtCmpErr : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRt completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmFifoOvflwErr : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for 2LM data or
                               completion FIFO overflow
                            */
    UINT32 VdbParErr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRT WDB parity
                               err
                            */
    UINT32 RpaParErr : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for RPA parity err */
    UINT32 WpaParErr : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WPA parity err */
    UINT32 DdrtEridUc : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Enable exception signalling for ERID UC Error */
    UINT32 DdrtIntrOverflow : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for interrupt seen
                               from FNV
                            */
    UINT32 DdrtEridFifoOverflow : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for for ERID FIFO
                               overflow error
                            */
    UINT32 DdrtFnvWrCreditError : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Write credit
                               error
                            */
    UINT32 DdrtFnvRdCreditError : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Read credi
                               error
                            */
    UINT32 DdrtSchedError : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtEridPar : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 LinkFail : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtFnvThermal : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Thermal
                               event error
                            */
    UINT32 Rsvd26 : 6;

                            /* Bits[31:26], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC25_CTL_REGISTER;

/**
  The MCiSTATUS MSR contains information related to a machine check error if its VAL (valid) flag is set.
**/
#define RKL_MSR_MC25_STATUS 0x00000465

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the machine check architecture defined
                               error code for the machine check error condition
                               detected
                            */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected
                            */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               The functions of the bits in this field are
                               implementation specific and are not part of the
                               machine check architecture.
                            */
    UINT32 CorErrCnt : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               A 15 bit counter that is incremented each time a
                               corrected (or uncorrected but ignorable) error
                               is observed by the MCA recording bank
                            */
    UINT32 CorErrStat : 2;

                            /* Bits[54:53], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are used to indicate when the number
                               of corrected errors has exceeded the safe
                               threshold to the point where an uncorrected
                               error has become more likely to happen
                               CORR_ERR_STAT does not apply to IMC and is
                               marked as reserved attribute
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /*
                               AR - Action REquired. When set it indicates that
                               SW needs to take immediate recovery action for
                               the error. When clear, SW does not need to take
                               immediate action. Similar to the S bit, the AR
                               bit has meaning only when an error is logged
                               with UC=1 and PCC=0.
                            */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /*
                               S - Signaling. When set it indicates that the
                               error was signaled with an MCERR. When clear it
                               indicates that the error was signaled via a
                               CMCI. The S bit has meaning only when an error
                               is logged with UC=1 and PCC=0.
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the state of the
                               processor might have been corrupted by the error
                               condition detected and that reliable restarting
                               of the processor may not be possible
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               indicates (when set) that the MCiADDR register
                               contains the address where the error occurred
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the MCiMISC register
                               contains additional information regarding the
                               error.
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that signaling of the
                               machine check exception for this error was
                               enabled by an associated flag bit of the MCiCTL
                               register
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error logged in this banks is an uncorrected
                               error.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               (Overflow) Indicates (when set) that a machine
                               check error occurred while the results of a
                               previous error were still in the register bank
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /* Error logged in this bank is valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC25_STATUS_REGISTER;

/**
  The MCiCTL MSR controls the signalling of machine check exceptions generated by the bank.
**/
#define RKL_MSR_MC26_CTL 0x00000468

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DataSpareErr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data sparing
                               errors.
                            */
    UINT32 DataScrubErr : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data scrubbing
                               errors.
                            */
    UINT32 DataWrtErr : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for data write errors */
    UINT32 DataByteEnableErr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data byte enable
                               errors
                            */
    UINT32 AddrErr : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for address errors */
    UINT32 CorrRdErr : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               Enables exception signalling for normal read
                               errors.
                            */
    UINT32 WdbParErr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WDB parity err */
    UINT32 ApppParErr : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for address path
                               parity protection err
                            */
    UINT32 Mc2lmInvalReqErr : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unrecognized
                               request to 2LM controller
                            */
    UINT32 Mc2lmDatToInvalEntErr : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for read response to
                               an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmUnexpectedReadrspErr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unexpected 2LM
                               read response
                            */
    UINT32 Mc2lmDdr4CmpErr : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDR4 completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmDdrtCmpErr : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRt completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmFifoOvflwErr : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for 2LM data or
                               completion FIFO overflow
                            */
    UINT32 VdbParErr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRT WDB parity
                               err
                            */
    UINT32 RpaParErr : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for RPA parity err */
    UINT32 WpaParErr : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WPA parity err */
    UINT32 DdrtEridUc : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Enable exception signalling for ERID UC Error */
    UINT32 DdrtIntrOverflow : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for interrupt seen
                               from FNV
                            */
    UINT32 DdrtEridFifoOverflow : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for for ERID FIFO
                               overflow error
                            */
    UINT32 DdrtFnvWrCreditError : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Write credit
                               error
                            */
    UINT32 DdrtFnvRdCreditError : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Read credi
                               error
                            */
    UINT32 DdrtSchedError : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtEridPar : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 LinkFail : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtFnvThermal : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Thermal
                               event error
                            */
    UINT32 Rsvd26 : 6;

                            /* Bits[31:26], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC26_CTL_REGISTER;

/**
  The MCiSTATUS MSR contains information related to a machine check error if its VAL (valid) flag is set.
**/
#define RKL_MSR_MC26_STATUS 0x00000469

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the machine check architecture defined
                               error code for the machine check error condition
                               detected
                            */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected
                            */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               The functions of the bits in this field are
                               implementation specific and are not part of the
                               machine check architecture.
                            */
    UINT32 CorErrCnt : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               A 15 bit counter that is incremented each time a
                               corrected (or uncorrected but ignorable) error
                               is observed by the MCA recording bank
                            */
    UINT32 CorErrStat : 2;

                            /* Bits[54:53], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are used to indicate when the number
                               of corrected errors has exceeded the safe
                               threshold to the point where an uncorrected
                               error has become more likely to happen
                               CORR_ERR_STAT does not apply to IMC and is
                               marked as reserved attribute
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /*
                               AR - Action REquired. When set it indicates that
                               SW needs to take immediate recovery action for
                               the error. When clear, SW does not need to take
                               immediate action. Similar to the S bit, the AR
                               bit has meaning only when an error is logged
                               with UC=1 and PCC=0.
                            */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /*
                               S - Signaling. When set it indicates that the
                               error was signaled with an MCERR. When clear it
                               indicates that the error was signaled via a
                               CMCI. The S bit has meaning only when an error
                               is logged with UC=1 and PCC=0.
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the state of the
                               processor might have been corrupted by the error
                               condition detected and that reliable restarting
                               of the processor may not be possible
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               indicates (when set) that the MCiADDR register
                               contains the address where the error occurred
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the MCiMISC register
                               contains additional information regarding the
                               error.
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that signaling of the
                               machine check exception for this error was
                               enabled by an associated flag bit of the MCiCTL
                               register
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error logged in this banks is an uncorrected
                               error.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               (Overflow) Indicates (when set) that a machine
                               check error occurred while the results of a
                               previous error were still in the register bank
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /* Error logged in this bank is valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC26_STATUS_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define RKL_MSR_MC26_ADDR 0x0000046A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC26_ADDR_REGISTER;

/**
  The MCiCTL MSR controls the signalling of machine check exceptions generated by the bank.
**/
#define RKL_MSR_MC27_CTL 0x0000046C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DataSpareErr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data sparing
                               errors.
                            */
    UINT32 DataScrubErr : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data scrubbing
                               errors.
                            */
    UINT32 DataWrtErr : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for data write errors */
    UINT32 DataByteEnableErr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data byte enable
                               errors
                            */
    UINT32 AddrErr : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for address errors */
    UINT32 CorrRdErr : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               Enables exception signalling for normal read
                               errors.
                            */
    UINT32 WdbParErr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WDB parity err */
    UINT32 ApppParErr : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for address path
                               parity protection err
                            */
    UINT32 Mc2lmInvalReqErr : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unrecognized
                               request to 2LM controller
                            */
    UINT32 Mc2lmDatToInvalEntErr : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for read response to
                               an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmUnexpectedReadrspErr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unexpected 2LM
                               read response
                            */
    UINT32 Mc2lmDdr4CmpErr : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDR4 completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmDdrtCmpErr : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRt completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmFifoOvflwErr : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for 2LM data or
                               completion FIFO overflow
                            */
    UINT32 VdbParErr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRT WDB parity
                               err
                            */
    UINT32 RpaParErr : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for RPA parity err */
    UINT32 WpaParErr : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WPA parity err */
    UINT32 DdrtEridUc : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Enable exception signalling for ERID UC Error */
    UINT32 DdrtIntrOverflow : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for interrupt seen
                               from FNV
                            */
    UINT32 DdrtEridFifoOverflow : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for for ERID FIFO
                               overflow error
                            */
    UINT32 DdrtFnvWrCreditError : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Write credit
                               error
                            */
    UINT32 DdrtFnvRdCreditError : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Read credi
                               error
                            */
    UINT32 DdrtSchedError : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtEridPar : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 LinkFail : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtFnvThermal : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Thermal
                               event error
                            */
    UINT32 Rsvd26 : 6;

                            /* Bits[31:26], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC27_CTL_REGISTER;

/**
  The MCiSTATUS MSR contains information related to a machine check error if its VAL (valid) flag is set.
**/
#define RKL_MSR_MC27_STATUS 0x0000046D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the machine check architecture defined
                               error code for the machine check error condition
                               detected
                            */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected
                            */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               The functions of the bits in this field are
                               implementation specific and are not part of the
                               machine check architecture.
                            */
    UINT32 CorErrCnt : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               A 15 bit counter that is incremented each time a
                               corrected (or uncorrected but ignorable) error
                               is observed by the MCA recording bank
                            */
    UINT32 CorErrStat : 2;

                            /* Bits[54:53], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are used to indicate when the number
                               of corrected errors has exceeded the safe
                               threshold to the point where an uncorrected
                               error has become more likely to happen
                               CORR_ERR_STAT does not apply to IMC and is
                               marked as reserved attribute
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /*
                               AR - Action REquired. When set it indicates that
                               SW needs to take immediate recovery action for
                               the error. When clear, SW does not need to take
                               immediate action. Similar to the S bit, the AR
                               bit has meaning only when an error is logged
                               with UC=1 and PCC=0.
                            */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /*
                               S - Signaling. When set it indicates that the
                               error was signaled with an MCERR. When clear it
                               indicates that the error was signaled via a
                               CMCI. The S bit has meaning only when an error
                               is logged with UC=1 and PCC=0.
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the state of the
                               processor might have been corrupted by the error
                               condition detected and that reliable restarting
                               of the processor may not be possible
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               indicates (when set) that the MCiADDR register
                               contains the address where the error occurred
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the MCiMISC register
                               contains additional information regarding the
                               error.
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that signaling of the
                               machine check exception for this error was
                               enabled by an associated flag bit of the MCiCTL
                               register
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error logged in this banks is an uncorrected
                               error.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               (Overflow) Indicates (when set) that a machine
                               check error occurred while the results of a
                               previous error were still in the register bank
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /* Error logged in this bank is valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC27_STATUS_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define RKL_MSR_MC27_ADDR 0x0000046E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_MC27_ADDR_REGISTER;

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in the middle of long flow and hence
  will delay servicing of SMI. SMI will be serviced after the long flow
  completes execution.
**/
#define RKL_MSR_SMM_DELAYED 0x000004E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 24;

                            /* Bits[23:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit will be set at the start of the events
                               listed below and cleared at the end of the
                               events. Patch load C6 entry C6 exit WBINVD Ratio
                               Change/Throttle/S1
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_SMM_DELAYED_REGISTER;

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in state where SMIs are blocked and hence
  will not be able to service SMI. SMI can be serviced after the logical
  processor exits the state in which SMIs are blocked
**/
#define RKL_MSR_SMM_BLOCKED 0x000004E3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 24;

                            /* Bits[23:0], Access Type=RW_V, default=0x00FFFFFF*/

                            /*
                               This bit will be set when the logical processor
                               is in the following states Wait For SIPI SENTER
                               Sleep VMX Abort Error Shutdown (Machine check in
                               WFS state)
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_SMM_BLOCKED_REGISTER;

/**
  Extended Page Table Pointer
**/
#define RKL_MSR_EPTP 0x00000510

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* EPT Memory Type */
    UINT32 Rsvd3 : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 EptADEnable : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* EPT A/D enable */
    UINT32 EptMbeEnable : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Enable bit for EPT Mode Based Execution
                               (required also paging is ON in guest)
                            */
    UINT32 Rsvd8 : 4;

                            /* Bits[11:8], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 Address0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page-Map Level-4/5 Address */
    UINT32 Address1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page-Map Level-4/5 Address */
    UINT32 Rsvd52 : 10;

                            /* Bits[61:52], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 Ept5l : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* Enable 5L EPT */
    UINT32 Enable : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* EPT enable bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_EPTP_REGISTER;
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_1 0x00000514
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_2 0x00000515
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_3 0x00000516
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_4 0x00000517
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_5 0x00000518
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_6 0x00000519
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_7 0x0000051A
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_8 0x0000051B
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_9 0x0000051C
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_10 0x0000051D
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_11 0x0000051E
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_PROBE_MODE_RESERVED_12 0x0000051F

/**
  Core UARCH_CTL msr
**/
#define RKL_MSR_CORE_UARCH_CTL 0x00000541

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DcuScrubEn : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* L1 scrubbing enable */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_CORE_UARCH_CTL_REGISTER;

/**
  Input voltage regulator configuration parameters.
**/
#define RKL_MSR_VR_MISC_CONFIG 0x00000603

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DynamicLoadLineR : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000036*/

                            /*
                               The Dynamic load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 IdleLoadLineR : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000036*/

                            /*
                               The Idle load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 LeakLoadLineR : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000036*/

                            /*
                               The Leakage load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 MinVid : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               Used to constrain the CPU's minimum voltage
                               during package C6/C7 C-states. The default
                               setting of 0x00 will result in full CPU control
                               over the minimum VID. VID resolution is 10mV /
                               LSB. This is internally clipped by fuses to the
                               C6/C7 voltage.
                            */
    UINT32 IoutOffset : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Signed offset added to VR dIout readings for
                               correction. 2s-complement signed number
                               expressed as a fraction of the IccMax of the VR.
                               Format: S8.-4.11 (8bits, floating point shifted
                               by 4 points). Precision: 0.049% (1/2^11) Range:
                               +/-6.25% of IccMax of the VR. Allowable range
                               may be clipped by processor on a per-SKU basis.
                            */
    UINT32 IoutSlope : 10;

                            /* Bits[49:40], Access Type=RW, default=0x00000200*/

                            /*
                               This is a slope correction for VR dIout readings
                               for postitive/negative correction. This scalar
                               is applied to every dIout reading before it is
                               consumed by the CPU. This scalar represents a
                               1.x number in U10.1.9 format (0.0 to 2.0 scalar
                               in ~0.19% increments)
                            */
    UINT32 IdleExitRampRate : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VR ramp rate on package C-state
                               wake events. 1 == fast, 0 == slow. Note that
                               fast will only apply to the Fast Ramp Voltage in
                               VR_MISC_CONFIG2[7:0]
                            */
    UINT32 IdleEntryRampRate : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the VR ramp rate on package C-state
                               entry events. 1 == fast, 0 == slow. If Decay is
                               set, it has priority. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 IdleEntryDecayEnable : 1;

                            /* Bits[52:52], Access Type=RW, default=0x00000001*/

                            /*
                               Enables decay mode on package C-state entry.
                               Decay mode implies PS2 or deeper. When Decay is
                               enabled, it has priority over the
                               IDLE_ENTRY_RAMP_RATE. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 Rsvd53 : 11;

                            /* Bits[63:53], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_VR_MISC_CONFIG_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_PKG_C2_RESIDENCY_COUNTER 0x0000060D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C2_RESIDENCY_COUNTER_REGISTER;

/**
  This register allows platform BIOS to limit the power consumption of the processor to the specified values.
**/
#define RKL_MSR_PACKAGE_POWER_LIMIT 0x00000610

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgPwrLim1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000118*/

                            /* This field indicates the power limitation #1. */
    UINT32 PkgPwrLim1En : 1;

                            /* Bits[15:15], Access Type=RO, default=0x00000001*/

                            /* Package Power Limit 1 is always enabled */
    UINT32 PkgClmpLim1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               Package Clamping limitation #1 - Allow going
                               below P1. 0b PBM is limited between P1 and P0.
                               1b PBM can go below P1.
                            */
    UINT32 PkgPwrLim1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               x = PKG_PWR_LIM_1_TIME[23:22] y =
                               PKG_PWR_LIM_1_TIME[21:17] The timing interval
                               window is Floating Point number given by 1.x *
                               power(2,y). The unit of measurement is defined
                               in PACKAGE_POWER_SKU_UNIT_MSR[TIME_UNIT]. The
                               maximal time window is bounded by
                               PACKAGE_POWER_SKU_MSR[PKG_MAX_WIN]. The minimum
                               time window is 1 unit of measurement (as defined
                               above).
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgPwrLim2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               This field indicates the power limitation #2.
                               The unit of measurement is defined in
                               PACKAGE_POWER_SKU_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 PkgPwrLim2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               This bit enables/disables PKG_PWR_LIM_2. 0b
                               Package Power Limit 2 is Disabled 1b Package
                               Power Limit 2 is Enabled
                            */
    UINT32 PkgClmpLim2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               Package Clamping limitation #2 - Allow going
                               below P1. 0b PBM is limited between P1 and P0.
                               1b PBM can go below P1.
                            */
    UINT32 PkgPwrLim2Time : 7;

                            /* Bits[55:49], Access Type=RW_L, default=0x00000000*/

                            /*
                               x = PKG_PWR_LIM_2_TIME[55:54] y =
                               PKG_PWR_LIM_2_TIME[53:49] The timing interval
                               window is Floating Point number given by 1.x *
                               power(2,y). The unit of measurement is defined
                               in PACKAGE_POWER_SKU_UNIT_MSR[TIME_UNIT]. The
                               maximal time window is bounded by
                               PACKAGE_POWER_SKU_MSR[PKG_MAX_WIN]. The minimum
                               time window is 1 unit of measurement (as defined
                               above).
                            */
    UINT32 Rsvd56 : 7;

                            /* Bits[62:56], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgPwrLimLock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /*
                               When set, all settings in this register are
                               locked and are treated as Read Only. This bit
                               will typically set by BIOS during boot time or
                               resume from Sx.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PACKAGE_POWER_LIMIT_REGISTER;

/**
  >Package energy consumed by the entire CPU (including IA, GT and uncore).  The counter will wrap around and continue counting when it reaches its limit.
  The energy status is reported in units which are defined in PACKAGE_POWER_SKU_UNIT_MSR[ENERGY_UNIT].
  The data is updated by PCODE and is Read Only for all SW
**/
#define RKL_MSR_PACKAGE_ENERGY_TIME_STATUS 0x00000612

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TotalEnergyConsumed : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Total amount of energy consumed since last
                               reset. This is a monotonic increment counter
                               with auto wrap back to zero after overflow. Unit
                               is 61uJ
                            */
    UINT32 TotalTimeElapsed : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Total time elapsed when the energy was last
                               updated. This is a monotonic increment counter
                               with auto wrap back to zero after overflow. Unit
                               is 10ns. SW calculates the delta change from
                               previous readings in order to determine the
                               power consumed. Power = delta_energy /
                               delta_time
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PACKAGE_ENERGY_TIME_STATUS_REGISTER;

/**

**/
#define RKL_MSR_DRAM_POWER_INFO 0x0000061C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DramTdp : 15;

                            /* Bits[14:0], Access Type=RO_V, default=0x00000118*/

                            /*
                               The Spec power allowed for DRAM. The TDP setting
                               is typical (not guaranteed). The units for this
                               value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMinPwr : 15;

                            /* Bits[30:16], Access Type=RO_V, default=0x00000078*/

                            /*
                               The minimal power setting allowed for DRAM.
                               Lower values will be clamped to this value. The
                               minimum setting is typical (not guaranteed). The
                               units for this value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxPwr : 15;

                            /* Bits[46:32], Access Type=RO_V, default=0x00000258*/

                            /*
                               The maximal power setting allowed for DRAM.
                               Higher values will be clamped to this value. The
                               maximum setting is typical (not guaranteed). The
                               units for this value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd47 : 1;

                            /* Bits[47:47], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxWin : 7;

                            /* Bits[54:48], Access Type=RO_V, default=0x00000028*/

                            /*
                               The maximal time window allowed for the DRAM.
                               Higher values will be clamped to this value. x =
                               PKG_MAX_WIN[54:53] y = PKG_MAX_WIN[52:48] The
                               timing interval window is Floating Point number
                               given by 1.x * power(2,y). The unit of
                               measurement is defined in
                               DRAM_POWER_INFO_UNIT_MSR[TIME_UNIT].
                            */
    UINT32 Rsvd55 : 8;

                            /* Bits[62:55], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RO_V, default=0x00000000*/

                            /* Lock bit to lock the Register */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_DRAM_POWER_INFO_REGISTER;

/**
  Time spent with LLC flushed.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define RKL_MSR_LLC_FLUSHED_RESIDENCY_COUNTER 0x0000061D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LLC_FLUSHED_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define RKL_MSR_PKG_C8_RESIDENCY_COUNTER 0x00000630

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C8_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define RKL_MSR_PKG_C9_RESIDENCY_COUNTER 0x00000631

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C9_RESIDENCY_COUNTER_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define RKL_MSR_PKG_C10_RESIDENCY_COUNTER 0x00000632

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PKG_C10_RESIDENCY_COUNTER_REGISTER;
/**
  Defined for ULT only. Does not exist on HSW/CRW.
  This MSR is used to read out the 24MHz alternative Time Stap Counter. Owner: Jay Schwartz
**/
#define RKL_MSR_COUNTER_24MHZ 0x00000637
/**
  Reports the actual energy used by the platform
**/
#define RKL_MSR_PLATFORM_ENERGY_STATUS 0x0000064D

/**
  Platform power limit
**/
#define RKL_MSR_PLATFORM_POWER_LIMIT 0x0000065C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PowerLimit1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Average Power limit value which the Platform
                               must not exceed over a time window as specified
                               by Power_Limit_1_TIME field above.
                            */
    UINT32 PowerLimit1En : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the Platform average power
                               does not exceed Power_Limit_1 value over an
                               exponential weighted moving average of the time
                               window.
                            */
    UINT32 CriticalPowerClamp1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_1 value specified below.
                            */
    UINT32 PowerLimit1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               This indicates the time window over which
                               Power_Limit_1 value should be maintained.
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PowerLimit2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Duration Power limit value which the Platform
                               must not exceed. This field is specified in the
                               units as identified by the
                               PALTFORM_POWER_SKU_UNIT (MSR606h).
                            */
    UINT32 PowerLimit2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the platform power does not
                               exceed Power_Limit_2 value.
                            */
    UINT32 CriticalPowerClamp2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_2 value specified below.
                            */
    UINT32 Rsvd49 : 14;

                            /* Bits[62:49], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /* Locks all other fields. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PLATFORM_POWER_LIMIT_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define RKL_MSR_LBR_FROM_IP_0 0x00000680

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_0_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_1 0x00000681

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_1_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_2 0x00000682

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_2_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_3 0x00000683

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_3_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_4 0x00000684

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_4_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_5 0x00000685

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_5_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_6 0x00000686

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_6_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_7 0x00000687

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_7_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_8 0x00000688

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_8_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_9 0x00000689

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_9_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_10 0x0000068A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_10_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_11 0x0000068B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_11_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_12 0x0000068C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_12_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_13 0x0000068D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_13_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_14 0x0000068E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_14_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_15 0x0000068F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_15_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define RKL_MSR_LBR_FROM_IP_16 0x00000690

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_16_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_17 0x00000691

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_17_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_18 0x00000692

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_18_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_19 0x00000693

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_19_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_20 0x00000694

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_20_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_21 0x00000695

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_21_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_22 0x00000696

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_22_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_23 0x00000697

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_23_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_24 0x00000698

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_24_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_25 0x00000699

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_25_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_26 0x0000069A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_26_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_27 0x0000069B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_27_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_28 0x0000069C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_28_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_29 0x0000069D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_29_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_30 0x0000069E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_30_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_FROM_IP_31 0x0000069F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_FROM_IP_31_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_0 0x000006C0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_0_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_1 0x000006C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_1_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_2 0x000006C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_2_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_3 0x000006C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_3_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_4 0x000006C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_4_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_5 0x000006C5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_5_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_6 0x000006C6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_6_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_7 0x000006C7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_7_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_8 0x000006C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_8_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_9 0x000006C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_9_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_10 0x000006CA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_10_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_11 0x000006CB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_11_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_12 0x000006CC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_12_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_13 0x000006CD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_13_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_14 0x000006CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_14_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_15 0x000006CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_15_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_16 0x000006D0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_16_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_17 0x000006D1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_17_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_18 0x000006D2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_18_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_19 0x000006D3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_19_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_20 0x000006D4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_20_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_21 0x000006D5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_21_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_22 0x000006D6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_22_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_23 0x000006D7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_23_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_24 0x000006D8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_24_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_25 0x000006D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_25_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_26 0x000006DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_26_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_27 0x000006DB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_27_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_28 0x000006DC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_28_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_29 0x000006DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_29_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_30 0x000006DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_30_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define RKL_MSR_LBR_TO_IP_31 0x000006DF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_LBR_TO_IP_31_REGISTER;

/**
  Global PMON
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define RKL_MSR_PERF_GLOBAL_CTRL 0x00000700

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmiselc0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc4 : 1;

                            /* Bits[4:4], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc5 : 1;

                            /* Bits[5:5], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc6 : 1;

                            /* Bits[6:6], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc7 : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc8 : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc9 : 1;

                            /* Bits[9:9], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc10 : 1;

                            /* Bits[10:10], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc11 : 1;

                            /* Bits[11:11], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc12 : 1;

                            /* Bits[12:12], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc13 : 1;

                            /* Bits[13:13], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc14 : 1;

                            /* Bits[14:14], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc15 : 1;

                            /* Bits[15:15], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc16 : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc17 : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc18 : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc19 : 1;

                            /* Bits[19:19], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc20 : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc21 : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc22 : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc23 : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc24 : 1;

                            /* Bits[24:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc25 : 1;

                            /* Bits[25:25], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc26 : 1;

                            /* Bits[26:26], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc27 : 1;

                            /* Bits[27:27], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc28 : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc29 : 1;

                            /* Bits[29:29], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc30 : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc31 : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc32 : 1;

                            /* Bits[32:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc33 : 1;

                            /* Bits[33:33], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc34 : 1;

                            /* Bits[34:34], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc35 : 1;

                            /* Bits[35:35], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc36 : 1;

                            /* Bits[36:36], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc37 : 1;

                            /* Bits[37:37], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc38 : 1;

                            /* Bits[38:38], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc39 : 1;

                            /* Bits[39:39], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc40 : 1;

                            /* Bits[40:40], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc41 : 1;

                            /* Bits[41:41], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc42 : 1;

                            /* Bits[42:42], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc43 : 1;

                            /* Bits[43:43], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc44 : 1;

                            /* Bits[44:44], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the targ 0 - Don't send event to the core
                               (default) 1 - Send event to the core
                            */
    UINT32 Rsvd45 : 14;

                            /* Bits[58:45], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Resetcntrs : 1;

                            /* Bits[59:59], Access Type=WO, default=0x00000000*/

                            /*
                               ResetCounter : This bit, when asserted, cause
                               all of the global enables for the UnCore PerfMon
                               Counters and fixed counters to be frozen. 0 : No
                               effect 1 : Reset all the perfmon counters
                            */
    UINT32 Pmiovfenubp : 1;

                            /* Bits[60:60], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the generation of uBP event when set. 0 -
                               Does not assert uBP event with the PMI Overflow.
                               1 - Assert uBP event with the PMI Overflow is
                               set.
                            */
    UINT32 Unfrzcountr : 1;

                            /* Bits[61:61], Access Type=WO, default=0x00000000*/

                            /*
                               UnfreezCounter : This bit, when asserted, cause
                               all of the global enables for the UnCore PerfMon
                               Counters and fixed counters to be unfrozen. 0 :
                               No effect 1 : Unfreeze all the perfmon counters,
                               start counting
                            */
    UINT32 Wkonpmi : 1;

                            /* Bits[62:62], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit determines whether PMI event is sent to
                               waken cores only or is broadcast to all cores
                               after waking up any sleeping core. 0 : Avoid
                               waking a core for PMI event - send event to
                               waken cores only. 1 : Wake any sleeping core and
                               send PMI event to all cores
                            */
    UINT32 Frzcountr : 1;

                            /* Bits[63:63], Access Type=WO, default=0x00000000*/

                            /*
                               FreezCounter : This bit, when asserted, cause
                               all of the global enables for the UnCore PerfMon
                               Counters and fixed counters to be frozen. 0 : No
                               effect 1 : Freeze all the perfmon counters, stop
                               counting
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_GLOBAL_CTRL_REGISTER;

/**
  This is MSR that shows to user configuration of uncore PMON's. In this particular case it shows the number of Cbo PMON banks
**/
#define RKL_MSR_PMON_CONFIG 0x00000702

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Numofcbopmon : 6;

                            /* Bits[5:0], Access Type=RWS, default=0x00000008*/

                            /*  */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PMON_CONFIG_REGISTER;

/**
  Uncore fixed counter control
**/
#define RKL_MSR_FIXED_PERF_CTR_CTRL 0x00000703

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 20;

                            /* Bits[19:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable generation of Overflow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_FIXED_PERF_CTR_CTRL_REGISTER;

/**
  Uncore fixed counter
**/
#define RKL_MSR_FIXED_PERF_CTR 0x00000704

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_FIXED_PERF_CTR_REGISTER;

/**
  Holds global control fields for the NCU PMON counters.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define RKL_MSR_PERF_UNIT_CTL 0x00000707

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [3:1]
                               Core ID. When "TID Filter Enable" is clear in
                               the Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_UNIT_CTL_REGISTER;

/**
  Ubox local PMON mask for NCDEC events
**/
#define RKL_MSR_NCU_PMON_MASK_CTL0 0x0000070B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mask : 25;

                            /* Bits[24:0], Access Type=RWS, default=0x00000000*/

                            /*
                               event mask bit per ring message decode [ 0]
                               PMON_NCDEC_MASK_NCB_Int_CBO_IIO [ 1]
                               PMON_NCDEC_MASK_NCB_Int_UBX_QPI [ 2]
                               PMON_NCDEC_MASK_NCB_P2PB_IIO [ 3]
                               PMON_NCDEC_MASK_NCB_P2PB_CBO_UBX_QPI [ 4]
                               PMON_NCDEC_MASK_NCB_VLW_IIO_CBO [ 5]
                               PMON_NCDEC_MASK_NCB_VLW_UBX_QPI [ 6]
                               PMON_NCDEC_MASK_NCB_EOI_CBO [ 7]
                               PMON_NCDEC_MASK_NCB_EOI_UBX_QPI [ 8]
                               PMON_NCDEC_MASK_NCB_EOI_IIO [ 9]
                               PMON_NCDEC_MASK_NCB_STARTREQ234 [10]
                               PMON_NCDEC_MASK_NCB_PMREQ [11]
                               PMON_NCDEC_MASK_NCB_RSVD [12]
                               PMON_NCDEC_MASK_NCS_CfgRd_Wr [13]
                               PMON_NCDEC_MASK_NCS_IORd_Wr [14]
                               PMON_NCDEC_MASK_NCS_LTRd [15]
                               PMON_NCDEC_MASK_NCS_LTWr_IIO_CBO [16]
                               PMON_NCDEC_MASK_NCS_LTWr_UBX_QPI [17]
                               PMON_NCDEC_MASK_NCS_FERR [18]
                               PMON_NCDEC_MASK_NCS_RSVD [19]
                               PMON_NCDEC_MASK_NCS_SHUTDOWN_CBO [20]
                               PMON_NCDEC_MASK_NCS_LOCKS_UNLOCK_CBO_IIO [21]
                               PMON_NCDEC_MASK_NCS_LOCKS_UNLOCK_UBX_QPI [22]
                               PMON_NCDEC_MASK_NCS_STARTREQ1_STOPREQ1234 [23]
                               PMON_NCDEC_MASK_NCS_INVD_WBINVD_CBO_IIO [24]
                               PMON_NCDEC_MASK_NCS_INVD_WBINVD_UBX_QPI
                            */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_NCU_PMON_MASK_CTL0_REGISTER;

/**
  Ubox local PMON mask for NCDEC events for subunit target
**/
#define RKL_MSR_NCU_PMON_MASK_CTL1 0x0000070C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mask : 12;

                            /* Bits[11:0], Access Type=RWS, default=0x00000000*/

                            /*
                               event mask bit per sub unit target [ 0] GLOB_INT
                               [ 1] PMREQ [ 2] RACU [ 3] NCEVENT [ 4] NCLOCK [
                               5] GLOB_LOCK [ 6] MAST_LOCK [ 7] NCS_SPEC [ 8]
                               NCB_SPEC [ 9] GLOB_EOI [10] NCEOI [11] DROP
                            */
    UINT32 AddrMask : 16;

                            /* Bits[27:12], Access Type=RWS, default=0x00000000*/

                            /* Register address mask for addr[15:0] */
    UINT32 Rsvd28 : 4;

                            /* Bits[31:28], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_NCU_PMON_MASK_CTL1_REGISTER;

/**
  Address offset match value for Ubox match/mask. Will compare bits that are not masked
**/
#define RKL_MSR_NCU_PMON_MATCH_ADDR 0x0000070D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AddrMatch : 16;

                            /* Bits[15:0], Access Type=RWS, default=0x00000000*/

                            /* Address offset to match */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_NCU_PMON_MATCH_ADDR_REGISTER;

/**
  PMON Global Status register.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define RKL_MSR_PERF_GLOBAL_STATUS 0x0000070E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Fixctrovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Fix Event. read 0 - No overflow detected 1 -
                               Event overflow event was detected (sticky) Write
                               0 - Ignore 1 - Clear this bit
                            */
    UINT32 Ncuctrovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               NCU and IMPH Event. read 0 - No overflow
                               detected 1 - Event overflow event was detected
                               (sticky) Write 0 - Ignore 1 - Clear this bit
                            */
    UINT32 Pcuovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware to indicate that an overflow
                               happened in the PCU
                            */
    UINT32 Cbo0ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 0 */
    UINT32 Cbo1ovf : 1;

                            /* Bits[4:4], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 1 */
    UINT32 Cbo2ovf : 1;

                            /* Bits[5:5], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 2 */
    UINT32 Cbo3ovf : 1;

                            /* Bits[6:6], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 3 */
    UINT32 Cbo4ovf : 1;

                            /* Bits[7:7], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 4 */
    UINT32 Cbo5ovf : 1;

                            /* Bits[8:8], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 5 */
    UINT32 Cbo6ovf : 1;

                            /* Bits[9:9], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 6 */
    UINT32 Cbo7ovf : 1;

                            /* Bits[10:10], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 7 */
    UINT32 Cbo8ovf : 1;

                            /* Bits[11:11], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 8 */
    UINT32 Cbo9ovf : 1;

                            /* Bits[12:12], Access Type=RW1C, default=0x00000000*/

                            /* Set by hardware when an overflow occurs in CBo 9 */
    UINT32 Cbo10ovf : 1;

                            /* Bits[13:13], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               10
                            */
    UINT32 Cbo11ovf : 1;

                            /* Bits[14:14], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               11
                            */
    UINT32 Cbo12ovf : 1;

                            /* Bits[15:15], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               15
                            */
    UINT32 Cbo13ovf : 1;

                            /* Bits[16:16], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               16
                            */
    UINT32 Cbo14ovf : 1;

                            /* Bits[17:17], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               17
                            */
    UINT32 Cbo15ovf : 1;

                            /* Bits[18:18], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               17
                            */
    UINT32 Cbo16ovf : 1;

                            /* Bits[19:19], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               17
                            */
    UINT32 Cbo17ovf : 1;

                            /* Bits[20:20], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               17
                            */
    UINT32 Cbo18ovf : 1;

                            /* Bits[21:21], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               18
                            */
    UINT32 Cbo19ovf : 1;

                            /* Bits[22:22], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               19
                            */
    UINT32 Cbo20ovf : 1;

                            /* Bits[23:23], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               20
                            */
    UINT32 Cbo21ovf : 1;

                            /* Bits[24:24], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               21
                            */
    UINT32 Cbo22ovf : 1;

                            /* Bits[25:25], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               22
                            */
    UINT32 Cbo23ovf : 1;

                            /* Bits[26:26], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               23
                            */
    UINT32 Cbo24ovf : 1;

                            /* Bits[27:27], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               24
                            */
    UINT32 Cbo25ovf : 1;

                            /* Bits[28:28], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               25
                            */
    UINT32 Cbo26ovf : 1;

                            /* Bits[29:29], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               26
                            */
    UINT32 Cbo27ovf : 1;

                            /* Bits[30:30], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               27
                            */
    UINT32 Cbo33to28ovf0 : 1;

                            /* Bits[31:31], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               28 to 33
                            */
    UINT32 Cbo33to28ovf1 : 5;

                            /* Bits[36:32], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in CBo
                               28 to 33
                            */
    UINT32 Rsvd37 : 2;

                            /* Bits[38:37], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Imc0ovf : 1;

                            /* Bits[39:39], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in the
                               memory controller 0
                            */
    UINT32 Imc1ovf : 1;

                            /* Bits[40:40], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in the
                               memory controller 1
                            */
    UINT32 Kti00ag0ovf : 1;

                            /* Bits[41:41], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in KTI00
                               Agent
                            */
    UINT32 Kti00ag1ovf : 1;

                            /* Bits[42:42], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in KTI00
                               Agent
                            */
    UINT32 Kti40ovf : 1;

                            /* Bits[43:43], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in KTI40
                               Agent
                            */
    UINT32 Rsvd44 : 2;

                            /* Bits[45:44], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 M3kti0ovf : 1;

                            /* Bits[46:46], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in
                               M3UPI0
                            */
    UINT32 M3kti1ovf : 1;

                            /* Bits[47:47], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when an overflow occurs in
                               M3UPI1
                            */
    UINT32 Rsvd48 : 3;

                            /* Bits[50:48], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 M2pcie0ovf : 1;

                            /* Bits[51:51], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2PCIe0
                            */
    UINT32 M2pcie1ovf : 1;

                            /* Bits[52:52], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2PCIe1
                            */
    UINT32 M2pcie2ovf : 1;

                            /* Bits[53:53], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2PCIe2
                            */
    UINT32 M2pcie3ovf : 1;

                            /* Bits[54:54], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2PCIe3
                            */
    UINT32 M2pcie4ovf : 1;

                            /* Bits[55:55], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2PCIe4
                            */
    UINT32 Iio0ovf : 1;

                            /* Bits[56:56], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in IIO0(CBDMA)
                            */
    UINT32 Iio1ovf : 1;

                            /* Bits[57:57], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in IIO1
                            */
    UINT32 Iio2ovf : 1;

                            /* Bits[58:58], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in IIO2
                            */
    UINT32 Iio3ovf : 1;

                            /* Bits[59:59], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in IIO3
                            */
    UINT32 Mcplink0ovf : 1;

                            /* Bits[60:60], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in MCPLink0
                            */
    UINT32 Mcplink1ovf : 1;

                            /* Bits[61:61], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in MCPLink1
                            */
    UINT32 M2mem0ovf : 1;

                            /* Bits[62:62], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2MEM0. Independent from iMC as they are in
                               different clock domains
                            */
    UINT32 M2mem1ovf : 1;

                            /* Bits[63:63], Access Type=RW1C, default=0x00000000*/

                            /*
                               Set by hardware when a counter overflow occurs
                               in M2MEM1. Independent from iMC as they are in
                               different clock domains
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_GLOBAL_STATUS_REGISTER;

/**

**/
#define RKL_MSR_PMON_UNIT_CTRL 0x00000710

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PMON_UNIT_CTRL_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_SEL_0 0x00000711

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=RW_V, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_SEL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_SEL_1 0x00000712

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=RW_V, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_SEL_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_SEL_2 0x00000713

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=RW_V, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_SEL_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_SEL_3 0x00000714

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=RW_V, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_SEL_3_REGISTER;
/**

**/
#define RKL_MSR_PERF_PCU_FILTER 0x00000715

/**

**/
#define RKL_MSR_PERF_UNIT_STATUS 0x00000716

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counteroverflowbitmask : 7;

                            /* Bits[6:0], Access Type=RW1C, default=0x00000000*/

                            /*
                               This bitmask that specifies which counter(or
                               counters have overflowed. If the unit has a
                               fixed counter, it's corresponding bitmask will
                               be stored at position 0.
                            */
    UINT32 Rsvd7 : 25;

                            /* Bits[31:7], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_UNIT_STATUS_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_CTR_0 0x00000717

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_CTR_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_CTR_1 0x00000718

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_CTR_2 0x00000719

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_CTR_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PCU_EVT_CTR_3 0x0000071A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PCU_EVT_CTR_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PERF_EVT_SEL_0 0x00000768

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count &lt;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_EVT_SEL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_PERF_EVT_SEL_1 0x00000769

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count &lt;
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PERF_EVT_SEL_1_REGISTER;

/**
  FIXME - update virtual MSR. Hardware Pstate requested performance and time window parameters. should i remove? need to be changed to virtual.
**/
#define RKL_MSR_HWP_REQUEST 0x00000774

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MinimumPerformance : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000001*/

                            /*
                               Used as a hint to the H/W. The OS sets the
                               minimum performance level to achieve the
                               required QOS. Excursion below this level is
                               possible due to physical or algorithmic
                               constraints. reset value is identical to
                               IA32_HWP_CAPABILITIES.LOWEST_LINEAR_PERFORMANCE
                            */
    UINT32 MaximumPerformance : 8;

                            /* Bits[15:8], Access Type=RW, default=0x000000FF*/

                            /*
                               The OS sets this field to limit the maximum
                               performance over the Activity Window that is
                               expected to be supplied by the H/W. Excursions
                               above this limit are possible due H/W
                               coordination between the IA core and other SoC's
                               components.
                            */
    UINT32 DesiredPerformance : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               RW (default = 0) When set to zero, HW autonomous
                               selection determines the performance target.
                               When set to a non-zero value, in the range of
                               Lowest Performance to Highest Performance
                               (IA32_HWP_CAPABILITIES), conveys an explicit
                               performance request hint to the hardware;
                               effectively disabling HW Autonomous selection.
                               The Desired Performance input is non-
                               constraining in terms of Performance and Energy
                               Efficiency optimizations, which are
                               independently controlled.
                            */
    UINT32 EnergyPerformancePreference : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000080*/

                            /*  */
    UINT32 ActivityWindow : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Used as a hint to the H/W. OS writes a time
                               value (100us) to this field to indicate a moving
                               utilization sensitivity window. Combined with
                               the Desired Performance input, influences the
                               rate of performance increase / decrease.
                            */
    UINT32 PackageControl : 1;

                            /* Bits[42:42], Access Type=RW, default=0x00000000*/

                            /*
                               When set causes thread IA32_HWP_REQUEST control
                               inputs to be derived from IA32_HWP_REQUEST_PKG
                            */
    UINT32 Rsvd43 : 16;

                            /* Bits[58:43], Access Type=RO, default=0x00000000*/

                            /* Reserved Bits */
    UINT32 ActivityWindowsValid : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes active windows value from this MSR
                            */
    UINT32 EppValid : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes EPP value from the the this MSR
                            */
    UINT32 DesiredValid : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Desired Performance value from the
                               the this MSR
                            */
    UINT32 MaximumValid : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Maximum Performance value from the
                               the this MSR
                            */
    UINT32 MinimumValid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Minimum Performance value from the
                               the this MSR
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_HWP_REQUEST_REGISTER;
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_0 0x00000791
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_1 0x00000792
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_2 0x00000794
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_3 0x00000795
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_4 0x00000796
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_5 0x00000797
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_6 0x00000798
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_7 0x00000799
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_8 0x0000079A
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_9 0x0000079B
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_10 0x0000079C
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_11 0x0000079D
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_12 0x0000079E
/**
  Spare Virtual MSRs in uncore Creg PLA
**/
#define RKL_MSR_UNCORE_SPARE_13 0x0000079F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_0 0x00000800
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_1 0x00000801
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_2 0x00000804
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_3 0x00000805
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_4 0x00000806
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_5 0x00000807
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_6 0x00000809
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_7 0x0000080C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_8 0x0000080E
/**
  APIC In-Service register bits
**/
#define RKL_MSR_PIC_ISR_DWORD_0 0x00000810
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_1 0x00000811
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_2 0x00000812
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_3 0x00000813
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_4 0x00000814
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_5 0x00000815
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_6 0x00000816
/**
  Register decription
**/
#define RKL_MSR_PIC_ISR_DWORD_7 0x00000817
/**
  APIC Trigger Mode register bits
**/
#define RKL_MSR_PIC_TMR_DWORD_0 0x00000818
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_1 0x00000819
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_2 0x0000081A
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_3 0x0000081B
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_4 0x0000081C
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_5 0x0000081D
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_6 0x0000081E
/**
  Register decription
**/
#define RKL_MSR_PIC_TMR_DWORD_7 0x0000081F
/**
  APIC Interrupt Request register bits
**/
#define RKL_MSR_PIC_IRR_DWORD_0 0x00000820
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_1 0x00000821
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_2 0x00000822
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_3 0x00000823
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_4 0x00000824
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_5 0x00000825
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_6 0x00000826
/**
  Register decription
**/
#define RKL_MSR_PIC_IRR_DWORD_7 0x00000827
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_9 0x00000829
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_10 0x0000082A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_11 0x0000082B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_12 0x0000082C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_13 0x0000082D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_14 0x0000082E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_15 0x00000831
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_16 0x0000083A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_17 0x0000083B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_18 0x0000083C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_19 0x0000083D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_20 0x00000840
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_21 0x00000841
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_22 0x00000842
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_23 0x00000843
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_24 0x00000844
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_25 0x00000845
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_26 0x00000846
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_27 0x00000847
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_28 0x00000848
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_29 0x00000849
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_30 0x0000084A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_31 0x0000084B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_32 0x0000084C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_33 0x0000084D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_34 0x0000084E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_35 0x0000084F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_36 0x00000850
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_37 0x00000851
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_38 0x00000852
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_39 0x00000853
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_40 0x00000854
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_41 0x00000855
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_42 0x00000856
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_43 0x00000857
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_44 0x00000858
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_45 0x00000859
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_46 0x0000085A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_47 0x0000085B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_48 0x0000085C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_49 0x0000085D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_50 0x0000085E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_51 0x0000085F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_52 0x00000860
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_53 0x00000861
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_54 0x00000862
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_55 0x00000863
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_56 0x00000864
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_57 0x00000865
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_58 0x00000866
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_59 0x00000867
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_60 0x00000868
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_61 0x00000869
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_62 0x0000086A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_63 0x0000086B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_64 0x0000086C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_65 0x0000086D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_66 0x0000086E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_67 0x0000086F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_68 0x00000870
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_69 0x00000871
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_70 0x00000872
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_71 0x00000873
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_72 0x00000874
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_73 0x00000875
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_74 0x00000876
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_75 0x00000877
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_76 0x00000878
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_77 0x00000879
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_78 0x0000087A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_79 0x0000087B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_80 0x0000087C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_81 0x0000087D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_82 0x0000087E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_83 0x0000087F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_84 0x00000880
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_85 0x00000881
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_86 0x00000882
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_87 0x00000883
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_88 0x00000884
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_89 0x00000885
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_90 0x00000886
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_91 0x00000887
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_92 0x00000888
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_93 0x00000889
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_94 0x0000088A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_95 0x0000088B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_96 0x0000088C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_97 0x0000088D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_98 0x0000088E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_99 0x0000088F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_100 0x00000890
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_101 0x00000891
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_102 0x00000892
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_103 0x00000893
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_104 0x00000894
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_105 0x00000895
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_106 0x00000896
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_107 0x00000897
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_108 0x00000898
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_109 0x00000899
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_110 0x0000089A
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_111 0x0000089B
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_112 0x0000089C
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_113 0x0000089D
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_114 0x0000089E
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_115 0x0000089F
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_116 0x000008A0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_117 0x000008A1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_118 0x000008A2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_119 0x000008A3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_120 0x000008A4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_121 0x000008A5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_122 0x000008A6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_123 0x000008A7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_124 0x000008A8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_125 0x000008A9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_126 0x000008AA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_127 0x000008AB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_128 0x000008AC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_129 0x000008AD
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_130 0x000008AE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_131 0x000008AF
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_132 0x000008B0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_133 0x000008B1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_134 0x000008B2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_135 0x000008B3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_136 0x000008B4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_137 0x000008B5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_138 0x000008B6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_139 0x000008B7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_140 0x000008B8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_141 0x000008B9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_142 0x000008BA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_143 0x000008BB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_144 0x000008BC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_145 0x000008BD
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_146 0x000008BE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_147 0x000008BF
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_148 0x000008C0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_149 0x000008C1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_150 0x000008C2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_151 0x000008C3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_152 0x000008C4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_153 0x000008C5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_154 0x000008C6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_155 0x000008C7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_156 0x000008C8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_157 0x000008C9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_158 0x000008CA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_159 0x000008CB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_160 0x000008CC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_161 0x000008CD
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_162 0x000008CE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_163 0x000008CF
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_164 0x000008D0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_165 0x000008D1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_166 0x000008D2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_167 0x000008D3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_168 0x000008D4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_169 0x000008D5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_170 0x000008D6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_171 0x000008D7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_172 0x000008D8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_173 0x000008D9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_174 0x000008DA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_175 0x000008DB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_176 0x000008DC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_177 0x000008DD
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_178 0x000008DE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_179 0x000008DF
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_180 0x000008E0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_181 0x000008E1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_182 0x000008E2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_183 0x000008E3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_184 0x000008E4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_185 0x000008E5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_186 0x000008E6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_187 0x000008E7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_188 0x000008E8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_189 0x000008E9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_190 0x000008EA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_191 0x000008EB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_192 0x000008EC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_193 0x000008ED
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_194 0x000008EE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_195 0x000008EF
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_196 0x000008F0
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_197 0x000008F1
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_198 0x000008F2
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_199 0x000008F3
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_200 0x000008F4
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_201 0x000008F5
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_202 0x000008F6
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_203 0x000008F7
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_204 0x000008F8
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_205 0x000008F9
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_206 0x000008FA
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_207 0x000008FB
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_208 0x000008FC
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_209 0x000008FD
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_210 0x000008FE
/**
  Virtual APIC MSRs that are modeled by ucode
**/
#define RKL_MSR_VIRTUAL_APIC_211 0x000008FF

/**
  Equivalent to architectural DR6 reg. 16 bit.
  (Mrm roctlregc/roctlregd/{tmpdr6lowSM306L|tmpdr6hiSM306L})
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !!!                                                                            !!!
  !!! CAUTION: Adding more bits to this creg or changing the layout of this creg !!!
  !!! will require MSR ucode changes. Talk to MSR ucode owner (rpartha on NHM) if!!!
  !!! you want to make changes to this creg                                      !!!
  !!!                                                                            !!!
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**/
#define RKL_MSR_TMPDR6 0x00000902

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 B0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B0 */
    UINT32 B1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B1 */
    UINT32 B2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B2 */
    UINT32 B3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B3 */
    UINT32 Rsvd4 : 9;

                            /* Bits[12:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Bd : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BD */
    UINT32 Bs : 1;

                            /* Bits[14:14], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6BS */
    UINT32 Bt : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BT */
    UINT32 Hled : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6HLED */
    UINT32 EnclaveInterruption : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enclave interruption indication. Cleared by HW
                               on retired EOM
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_TMPDR6_REGISTER;

/**
  Holds address bits [11:0] of a guest load/store access that hit the AVRR range
  C6NoSave Candidate
  FSCP Crunch:  12:32 Used only 12 bits out of 32
**/
#define RKL_MSR_VMX_VMENTRY_AVRR_TBIT_MAILBOX 0x00000907

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MailboxOffset : 12;

                            /* Bits[11:0], Access Type=RW, default=0x00000000*/

                            /*
                               Mailbox address bits [11:0] of a guest
                               load/store access that hit the AVRR range
                            */
    UINT32 Reserved12 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Unused */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_VMX_VMENTRY_AVRR_TBIT_MAILBOX_REGISTER;

/**
  Holds XSAVE_AREA XCompaction vector for the XMODIFIED optimization.
**/
#define RKL_MSR_XRSTOR_XCOMPACTION_VECTOR 0x00000911

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 XcompactionVector : 10;

                            /* Bits[9:0], Access Type=RW, default=0x00000000*/

                            /*
                               Bit 0 => FP Bit 1 => SSE Bit 2 => GSSE Bit 3 =>
                               PL BNDREGS Bit 4 => PL BNDCFS Bit 5 => KMASK Bit
                               6 => AVX3(15:0) Bit 7 => AVX3(31:16) Bit 8 =>
                               RTIT (reserved - actual bit in IA_XSS) Bit 9 =>
                               PKRU
                            */
    UINT32 Rsvd10 : 5;

                            /* Bits[14:10], Access Type=RW, default=0x00000000*/

                            /* Available for use */
    UINT32 XcompInUse : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /*
                               Save area for XRSTOR_INFO used XCOMPACTION, or
                               VECTOR in this MSR is valid.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Available for use */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Available for use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_XRSTOR_XCOMPACTION_VECTOR_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_1 0x00000917
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_2 0x00000918
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_3 0x00000919
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_4 0x0000091A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_5 0x0000091C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_6 0x0000091D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_7 0x0000091E
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_8 0x0000091F

/**
  The who-am-I register is used by uCode to set up the APIC ID.
  This register is initialized by the PCU according to the socket configuration using the NcuPcuWHOAMI register.
  The who-am-i register returns a thread specific identifier, however some of the fields of this registers are shared between all threads as indicated by the fields description.
**/
#define RKL_MSR_WHO_AM_I 0x00000920

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lpid : 3;

                            /* Bits[2:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               3-bit field. UBOX generates contiguous LPIDs for
                               logical procsesors within an IDI agent. CPUs
                               with fewer than 8 logical processors per IDI (eg
                               ICL, ICX) see holes in the WHOAMI space. Ucode
                               handles this as required (plug holes or live
                               with it)
                            */
    UINT32 Moduleid : 13;

                            /* Bits[15:3], Access Type=RO_V, default=0x00000000*/

                            /* Returns the Module Identification number. */
    UINT32 Packageid : 11;

                            /* Bits[26:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               Maps to the socketId straps; Can be programmed
                               (MSR)
                            */
    UINT32 Rsvd27 : 1;

                            /* Bits[27:27], Access Type=RO_V, default=0x00000000*/

                            /* Reserved */
    UINT32 Corenum : 3;

                            /* Bits[30:28], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates how many common APIC ID bits there are
                               in the socket: 000: upto 8 cores 001: upto 16
                               cores 010: upto 32 cores 011: upto 64 cores 100:
                               upto 128 cores 101: upto 256 cores 110: upto 512
                               cores 111: upto 1024 cores This field is used by
                               uCode for correctly handling the number of
                               variable bits in PID field.
                            */
    UINT32 Bsp : 1;

                            /* Bits[31:31], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates to the core uCode that this thread
                               should be made the BSP of the socket, .
                               Selection among multi-socket BSP is done by BIOS
                               SW. 0 : this thread should not be set as BSP 1 :
                               this thread should be set as BSP
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_WHO_AM_I_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_STATUS (lower 32b) and ROB1_CR_PIC_EVENT_STATUS (upper 32b)
**/
#define RKL_MSR_PPPE_EVENT_STATUS 0x00000925

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO THREAD */
    UINT32 MceSmi : 1;

                            /* Bits[18:18], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to MCE_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 CmciSmi : 1;

                            /* Bits[19:19], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to CMCI_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[20:20], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd21 : 11;

                            /* Bits[31:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Core Retirement Detector
                               (CRD) event
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for ROP event */
    UINT32 Reserved46 : 1;

                            /* Bits[46:46], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RESERVED event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT flush event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PPPE_EVENT_STATUS_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_SET (lower 32b) and ROB1_CR_PIC_EVENT_SET (upper 32b)
**/
#define RKL_MSR_PPPE_EVENT_SET 0x00000926

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Event Set : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* used to be A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Set : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Set : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Set : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Set : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /* Event Set : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Set : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Set : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Set : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Set : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Set : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Set : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Set : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Set GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Set GO THREAD */
    UINT32 MceSmi : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event set MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event set CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event set : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd21 : 11;

                            /* Bits[31:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /* Set Core Retirement Detector (CRD) pending state */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for FERR_OVERFLOW event */
    UINT32 Reserved46 : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Pending status for RESERVED event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PPPE_EVENT_SET_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_RESET (lower 32b) and ROB1_CR_PIC_EVENT_RESET (upper 32b)
**/
#define RKL_MSR_PPPE_EVENT_RESET 0x00000927

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Reset Event INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* Event Reset : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Reset : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Reset : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /*
                               Event Reset : MONITOR: Doesn't write
                               ML3_CR_PIC_EVENT_RESET_MONITOR but clears the
                               MONITOR FSM with a spcl cycle
                            */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Reset : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Reset : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Reset : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Reset : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO THREAD */
    UINT32 MceSmi : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event Reset MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event Reset CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd21 : 11;

                            /* Bits[31:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /* Clear state correctable mc */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT memory event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /*
                               Clear Core Retirement Detector (CRD) pending
                               state
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for ROP event */
    UINT32 Reserved46 : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Clear state for RESERVED event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Clear state for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Clear state for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Clear state for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PPPE_EVENT_RESET_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_9 0x00000928
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_10 0x00000929
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_11 0x0000092A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_12 0x0000092B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_13 0x0000092C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_14 0x0000092D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_15 0x0000092E
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_16 0x00000930
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_17 0x00000931
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_18 0x00000932
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_19 0x0000093B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_20 0x0000093F

/**
  Mode C - Protected Mode PagDir Pointers - 0
**/
#define RKL_MSR_PDPTR_0 0x00000940

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PDPTR_0_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
**/
#define RKL_MSR_PDPTR_1 0x00000941

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PDPTR_1_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
**/
#define RKL_MSR_PDPTR_2 0x00000942

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PDPTR_2_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
**/
#define RKL_MSR_PDPTR_3 0x00000943

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_PDPTR_3_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_21 0x00000944
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_22 0x00000945
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_23 0x00000946
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_24 0x00000947
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_25 0x00000948
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_26 0x00000949
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_27 0x0000094A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_28 0x0000094B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_29 0x0000094C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_30 0x0000094D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
**/
#define RKL_MSR_XU_RESERVED_31 0x00000967

/**
  Holds XCR0 and XSAVE Compaction Vector (used for XMODIFIED optimization check)
**/
#define RKL_MSR_XCR0 0x0000096D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 X87 : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Bit 0 => FP */
    UINT32 Sse : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /* Bit 1 => SSE */
    UINT32 Gsse : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* Bit 2 => GSSE */
    UINT32 PlBndregs : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Bit 3 => PL BNDREGS */
    UINT32 PlBndcfs : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* Bit 4 => PL BNDCFS */
    UINT32 Kmask : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /* Bit 5 => KMASK */
    UINT32 Avx3150 : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* Bit 6 => AVX3(15:0) */
    UINT32 Avx33116 : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /* Bit 7 => AVX3(31:16) */
    UINT32 RsvdIaXssRtit8 : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               Bit 8 is reserved because of use as RTIT bit in
                               IA_XSS.
                            */
    UINT32 Pkru : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /* Bit 9 => Page Protection Keys User. */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RW, default=0x00000000*/

                            /* Unused bits. */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Unused bits. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_XCR0_REGISTER;

/**

**/
#define RKL_MSR_STACK0_M2P_PMONUNITCTRL0 0x00000A40

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_M2P_CTR_0 0x00000A41

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_M2P_CTR_1 0x00000A42

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_M2P_CTR_2 0x00000A43

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_M2P_CTR_3 0x00000A44

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK0_M2P_PMONUNITSTATUS0 0x00000A45

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_PMONUNITSTATUS0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_M2P_CTR_CFG_2 0x00000A48

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_M2P_CTR_CFG_3 0x00000A49

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK0_IRP_PMONUNITCTRL0 0x00000A4A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IRP_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IRP_CTR_0 0x00000A4B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IRP_CTR_1 0x00000A4C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_M2P_CTR_CFG_0 0x00000A4D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_M2P_CTR_CFG_1 0x00000A4E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_M2P_CTR_CFG_1_REGISTER;

/**

**/
#define RKL_MSR_STACK0_IRP_PMONUNITSTATUS0 0x00000A4F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IRP_PMONUNITSTATUS0_REGISTER;

/**

**/
#define RKL_MSR_STACK0_IO_PMONUNITCTRL0 0x00000A50

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IO_CTR_0 0x00000A51

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IO_CTR_1 0x00000A52

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IO_CTR_2 0x00000A53

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK0_IO_CTR_3 0x00000A54

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK0_IO_PMONFRCNTRCLK0 0x00000A55

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_PMONFRCNTRCLK0_REGISTER;

/**

**/
#define RKL_MSR_STACK0_IO_PMONUNITSTATUS0 0x00000A57

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_PMONUNITSTATUS0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_IO_CTR_CFG_0 0x00000A58

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_IO_CTR_CFG_1 0x00000A59

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_CFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_IO_CTR_CFG_2 0x00000A5A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK0_IO_CTR_CFG_3 0x00000A5B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_IO_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK1_M2P_PMONUNITCTRL1 0x00000A60

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_M2P_CTR_0 0x00000A61

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_M2P_CTR_1 0x00000A62

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_M2P_CTR_2 0x00000A63

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_M2P_CTR_3 0x00000A64

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK1_M2P_PMONUNITSTATUS1 0x00000A65

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_PMONUNITSTATUS1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_M2P_CTR_CFG_2 0x00000A68

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_M2P_CTR_CFG_3 0x00000A69

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK1_IRP_PMONUNITCTRL1 0x00000A6A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IRP_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IRP_CTR_0 0x00000A6B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IRP_CTR_1 0x00000A6C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_M2P_CTR_CFG_0 0x00000A6D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_M2P_CTR_CFG_1 0x00000A6E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_M2P_CTR_CFG_1_REGISTER;

/**

**/
#define RKL_MSR_STACK1_IRP_PMONUNITSTATUS1 0x00000A6F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IRP_PMONUNITSTATUS1_REGISTER;

/**

**/
#define RKL_MSR_STACK1_IO_PMONUNITCTRL1 0x00000A70

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IO_CTR_0 0x00000A71

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IO_CTR_1 0x00000A72

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IO_CTR_2 0x00000A73

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK1_IO_CTR_3 0x00000A74

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK1_IO_PMONFRCNTRCLK1 0x00000A75

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_PMONFRCNTRCLK1_REGISTER;

/**

**/
#define RKL_MSR_STACK1_IO_PMONUNITSTATUS1 0x00000A77

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_PMONUNITSTATUS1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_IO_CTR_CFG_0 0x00000A78

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_IO_CTR_CFG_1 0x00000A79

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_CFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_IO_CTR_CFG_2 0x00000A7A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK1_IO_CTR_CFG_3 0x00000A7B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_IO_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK2_M2P_PMONUNITCTRL2 0x00000A80

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_PMONUNITCTRL2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_M2P_CTR_0 0x00000A81

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_M2P_CTR_1 0x00000A82

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_M2P_CTR_2 0x00000A83

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_M2P_CTR_3 0x00000A84

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK2_M2P_PMONUNITSTATUS2 0x00000A85

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_PMONUNITSTATUS2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_M2P_CTR_CFG_2 0x00000A88

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_M2P_CTR_CFG_3 0x00000A89

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK2_IRP_PMONUNITCTRL2 0x00000A8A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IRP_PMONUNITCTRL2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IRP_CTR_0 0x00000A8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IRP_CTR_1 0x00000A8C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_M2P_CTR_CFG_0 0x00000A8D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_M2P_CTR_CFG_1 0x00000A8E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_M2P_CTR_CFG_1_REGISTER;

/**

**/
#define RKL_MSR_STACK2_IRP_PMONUNITSTATUS2 0x00000A8F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IRP_PMONUNITSTATUS2_REGISTER;

/**

**/
#define RKL_MSR_STACK2_IO_PMONUNITCTRL2 0x00000A90

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_PMONUNITCTRL2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IO_CTR_0 0x00000A91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IO_CTR_1 0x00000A92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IO_CTR_2 0x00000A93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK2_IO_CTR_3 0x00000A94

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK2_IO_PMONFRCNTRCLK2 0x00000A95

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_PMONFRCNTRCLK2_REGISTER;

/**

**/
#define RKL_MSR_STACK2_IO_PMONUNITSTATUS2 0x00000A97

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_PMONUNITSTATUS2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_IO_CTR_CFG_0 0x00000A98

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_IO_CTR_CFG_1 0x00000A99

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_CFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_IO_CTR_CFG_2 0x00000A9A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK2_IO_CTR_CFG_3 0x00000A9B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_IO_CTR_CFG_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_0 0x00000AA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_0_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_1 0x00000AA1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_1_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_2 0x00000AA2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_2_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_3 0x00000AA3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_4 0x00000AA4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_4_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_5 0x00000AA5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_5_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_6 0x00000AA6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_6_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_7 0x00000AA7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_7_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_8 0x00000AA8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_8_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_9 0x00000AA9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_9_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_10 0x00000AAA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_10_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_11 0x00000AAB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_11_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_12 0x00000AAC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_12_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_13 0x00000AAD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_13_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_14 0x00000AAE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_14_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK0_TC_PMONFRCNTR_15 0x00000AAF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK0_TC_PMONFRCNTR_15_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_0 0x00000AB0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_0_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_1 0x00000AB1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_1_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_2 0x00000AB2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_2_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_3 0x00000AB3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_4 0x00000AB4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_4_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_5 0x00000AB5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_5_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_6 0x00000AB6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_6_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_7 0x00000AB7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_7_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_8 0x00000AB8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_8_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_9 0x00000AB9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_9_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_10 0x00000ABA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_10_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_11 0x00000ABB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_11_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_12 0x00000ABC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_12_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_13 0x00000ABD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_13_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_14 0x00000ABE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_14_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK1_TC_PMONFRCNTR_15 0x00000ABF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK1_TC_PMONFRCNTR_15_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_0 0x00000AC0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_0_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_1 0x00000AC1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_1_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_2 0x00000AC2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_2_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_3 0x00000AC3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_4 0x00000AC4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_4_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_5 0x00000AC5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_5_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_6 0x00000AC6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_6_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_7 0x00000AC7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_7_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_8 0x00000AC8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_8_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_9 0x00000AC9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_9_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_10 0x00000ACA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_10_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_11 0x00000ACB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_11_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_12 0x00000ACC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_12_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_13 0x00000ACD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_13_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_14 0x00000ACE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_14_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define RKL_MSR_STACK2_TC_PMONFRCNTR_15 0x00000ACF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK2_TC_PMONFRCNTR_15_REGISTER;

/**

**/
#define RKL_MSR_STACK3_M2P_PMONUNITCTRL0 0x00000AD0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_M2P_CTR_0 0x00000AD1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_M2P_CTR_1 0x00000AD2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_M2P_CTR_2 0x00000AD3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_M2P_CTR_3 0x00000AD4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK3_M2P_PMONUNITSTATUS0 0x00000AD5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_PMONUNITSTATUS0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_M2P_CTR_CFG_2 0x00000AD8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_M2P_CTR_CFG_3 0x00000AD9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK3_IRP_PMONUNITCTRL0 0x00000ADA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IRP_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IRP_CTR_0 0x00000ADB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IRP_CTR_1 0x00000ADC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_M2P_CTR_CFG_0 0x00000ADD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_M2P_CTR_CFG_1 0x00000ADE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_M2P_CTR_CFG_1_REGISTER;

/**

**/
#define RKL_MSR_STACK3_IRP_PMONUNITSTATUS0 0x00000ADF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IRP_PMONUNITSTATUS0_REGISTER;

/**

**/
#define RKL_MSR_STACK3_IO_PMONUNITCTRL0 0x00000AE0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_PMONUNITCTRL0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IO_CTR_0 0x00000AE1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IO_CTR_1 0x00000AE2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IO_CTR_2 0x00000AE3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK3_IO_CTR_3 0x00000AE4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK3_IO_PMONFRCNTRCLK0 0x00000AE5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_PMONFRCNTRCLK0_REGISTER;

/**

**/
#define RKL_MSR_STACK3_IO_PMONUNITSTATUS0 0x00000AE7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_PMONUNITSTATUS0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_IO_CTR_CFG_0 0x00000AE8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_IO_CTR_CFG_1 0x00000AE9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_CFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_IO_CTR_CFG_2 0x00000AEA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK3_IO_CTR_CFG_3 0x00000AEB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK3_IO_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK4_M2P_PMONUNITCTRL1 0x00000AF0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_M2P_CTR_0 0x00000AF1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_M2P_CTR_1 0x00000AF2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_M2P_CTR_2 0x00000AF3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_M2P_CTR_3 0x00000AF4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK4_M2P_PMONUNITSTATUS1 0x00000AF5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_PMONUNITSTATUS1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_M2P_CTR_CFG_2 0x00000AF8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_M2P_CTR_CFG_3 0x00000AF9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK4_IRP_PMONUNITCTRL1 0x00000AFA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IRP_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IRP_CTR_0 0x00000AFB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IRP_CTR_1 0x00000AFC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_M2P_CTR_CFG_0 0x00000AFD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_M2P_CTR_CFG_1 0x00000AFE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_M2P_CTR_CFG_1_REGISTER;

/**

**/
#define RKL_MSR_STACK4_IRP_PMONUNITSTATUS1 0x00000AFF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IRP_PMONUNITSTATUS1_REGISTER;

/**

**/
#define RKL_MSR_STACK4_IO_PMONUNITCTRL1 0x00000B00

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_PMONUNITCTRL1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IO_CTR_0 0x00000B01

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IO_CTR_1 0x00000B02

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IO_CTR_2 0x00000B03

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK4_IO_CTR_3 0x00000B04

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK4_IO_PMONFRCNTRCLK1 0x00000B05

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_PMONFRCNTRCLK1_REGISTER;

/**

**/
#define RKL_MSR_STACK4_IO_PMONUNITSTATUS1 0x00000B07

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_PMONUNITSTATUS1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_IO_CTR_CFG_0 0x00000B08

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_IO_CTR_CFG_1 0x00000B09

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_CFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_IO_CTR_CFG_2 0x00000B0A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK4_IO_CTR_CFG_3 0x00000B0B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK4_IO_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK5_M2P_PMONUNITCTRL2 0x00000B10

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_PMONUNITCTRL2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_M2P_CTR_0 0x00000B11

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_M2P_CTR_1 0x00000B12

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_M2P_CTR_2 0x00000B13

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_M2P_CTR_3 0x00000B14

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_3_REGISTER;

/**

**/
#define RKL_MSR_STACK5_M2P_PMONUNITSTATUS2 0x00000B15

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW1C, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW1C, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW1C, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW1C, default=0x00000000*/

                            /* counter 3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_PMONUNITSTATUS2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK5_M2P_CTR_CFG_2 0x00000B18

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_CFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK5_M2P_CTR_CFG_3 0x00000B19

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_CFG_3_REGISTER;

/**

**/
#define RKL_MSR_STACK5_IRP_PMONUNITCTRL2 0x00000B1A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW_L, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_IRP_PMONUNITCTRL2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_IRP_CTR_0 0x00000B1B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_IRP_CTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define RKL_MSR_STACK5_IRP_CTR_1 0x00000B1C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_IRP_CTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK5_M2P_CTR_CFG_0 0x00000B1D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} RKL_MSR_STACK5_M2P_CTR_CFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define RKL_MSR_STACK5_M2P_CTR_CFG_1 0x00000B1E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0