
/** @file
  TglMsr.h

  @copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/

#ifndef _TGLMSR_h
#define _TGLMSR_h
#include <Base.h>

/**
  Register to disable split locks, which are locked instructions that split a cache line.
**/
#define TGL_MSR_MEMORY_CONTROL 0x00000033

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 29;

                            /* Bits[28:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SplitLockDisable : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, a split lock will trigger an #AC
                               fault. If clear to 0, split locks proceed
                               normally (subjected to the SUPPRESS_SPLIT_LOCK
                               behavior. If both this bit and
                               SUPPRESS_SPLIT_LOCK are set, then only this bit
                               will be honored (has priority).
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SuppressSplitLock : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /*
                               If set to 1, disables split locks. If clear to
                               0, enables split locks. Setting this bit will
                               cause split locks to be non-atomic, despite the
                               lock attribute of the instruction.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MEMORY_CONTROL_REGISTER;

/**
  new MSR to flush caches
**/
#define TGL_MSR_ADR_CACHE_FLUSH_CLNT 0x00000056

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CboSlice0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* LLC slice mask */
    UINT32 CboSlice1 : 2;

                            /* Bits[33:32], Access Type=RW, default=0x00000000*/

                            /* LLC slice mask */
    UINT32 Rsvd34 : 30;

                            /* Bits[63:34], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_ADR_CACHE_FLUSH_CLNT_REGISTER;
/**
  MSR to provision VCM key hash to CPU
**/
#define TGL_MSR_PFR_VCM_PROVISION 0x00000067

/**
  MSR to read PFR provision status
**/
#define TGL_MSR_PFR_VCM_PROVISION_STATUS 0x00000068

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Signature : 16;

                            /* Bits[15:0], Access Type=RW, default=None*/

                            /* PFR signature in CPLD */
    UINT32 PfrEnabled : 1;

                            /* Bits[16:16], Access Type=RW, default=None*/

                            /* PFR enable indication */
    UINT32 CpuProvision : 1;

                            /* Bits[17:17], Access Type=RW, default=None*/

                            /* CPU NVRAM is provisioned */
    UINT32 CpuProvisionLock : 1;

                            /* Bits[18:18], Access Type=RW, default=None*/

                            /* CPU NVRAM is locked */
    UINT32 Rsvd19 : 11;

                            /* Bits[29:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Error : 1;

                            /* Bits[30:30], Access Type=RW, default=None*/

                            /* Error indicatoin */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PFR_VCM_PROVISION_STATUS_REGISTER;
/**
  MSR to read first 8 bytes of VCM hash
**/
#define TGL_MSR_PFR_VCM_HASH_1_1 0x0000006C
/**
  MSR to read first 8 bytes of VCM hash
**/
#define TGL_MSR_PFR_VCM_HASH_2_2 0x0000006D
/**
  MSR to read first 8 bytes of VCM hash
**/
#define TGL_MSR_PFR_VCM_HASH_3_3 0x0000006E
/**
  MSR to read first 8 bytes of VCM hash
**/
#define TGL_MSR_PFR_VCM_HASH_4_4 0x0000006F

/**
  MSR to expose the MCHECK error code to BIOS
**/
#define TGL_MSR_SGX_MCU_ERRORCODE 0x000000A0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McheckErrorCode : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* MCHECK error code from MCHECK-ucode API */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_SGX_MCU_ERRORCODE_REGISTER;
/**
  SGX PRID values
  " seq has 2 instances in addresses range 0xA1 to 0xA2"
**/
#define TGL_MSR_PRID_0_0 0x000000A1
/**
  SGX PRID values
  " seq has 2 instances in addresses range 0xA1 to 0xA2"
**/
#define TGL_MSR_PRID_1_1 0x000000A2

/**
  FIT BIOS and ACM error type and code
**/
#define TGL_MSR_FIT_BIOS_ERROR 0x000000A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ErrorCode : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* error code optype */
    UINT32 EntryType : 8;

                            /* Bits[15:8], Access Type=RW, default=None*/

                            /* entry type optype */
    UINT32 FitPatchEntry : 1;

                            /* Bits[16:16], Access Type=RW, default=None*/

                            /* indication whether patch entry exists in FIT */
    UINT32 Rsvd17 : 15;

                            /* Bits[31:17], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* Lock bit - set when FIT error is written to FSCP */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_FIT_BIOS_ERROR_REGISTER;

/**
  Override MPX Fuse.
**/
#define TGL_MSR_MPX_FUSE_OVERRIDE 0x000000A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MpxEnabled : 1;

                            /* Bits[0:0], Access Type=RO_V, default=None*/

                            /* MPX Enable */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO_V, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO_V, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MPX_FUSE_OVERRIDE_REGISTER;

/**
  Virtual MSR to disable AVX instructions from BIOS
**/
#define TGL_MSR_BIOS_AVX_DIS 0x000000AF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AvxDis : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* disable AVX/2/3 instructions */
    UINT32 Avx3Dis : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* disable AVX3 instructions */
    UINT32 Reserved2 : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_BIOS_AVX_DIS_REGISTER;
/**
  vMSRs for power mgmt
**/
#define TGL_MSR_VMSR_U2P_0_0 0x000000B0
/**
  vMSRs for power mgmt
**/
#define TGL_MSR_VMSR_U2P_1_1 0x000000B1
/**
  vMSRs for power mgmt
**/
#define TGL_MSR_VMSR_U2P_2_2 0x000000B2
/**
  vMSRs for power mgmt
**/
#define TGL_MSR_VMSR_U2P_3_3 0x000000B3

/**
  This register contains read-only package level ratio information
**/
#define TGL_MSR_PLATFORM_INFO 0x000000CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 8;

                            /* Bits[7:0], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxNonTurboLimRatio : 8;

                            /* Bits[15:8], Access Type=ROS_V, default=0x00000000*/

                            /* The Maximum Non-Turbo Ratio */
    UINT32 SmmSaveCap : 1;

                            /* Bits[16:16], Access Type=RO_V, default=0x00000001*/

                            /*
                               When set to '1' indicates this feature exists
                               and is configured by SMM_SAVE_CONTROL
                            */
    UINT32 RarEn : 1;

                            /* Bits[17:17], Access Type=RO_V, default=0x00000000*/

                            /* When set to '1' indicates RAR feature exists */
    UINT32 Rsvd18 : 5;

                            /* Bits[22:18], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 PpinCap : 1;

                            /* Bits[23:23], Access Type=ROS_V, default=0x00000000*/

                            /*
                               When set to 1, indicates that this part supports
                               the Protected Processor Inventory Number (PPIN)
                               feature.
                            */
    UINT32 OcvoltOvrdAvail : 1;

                            /* Bits[24:24], Access Type=RO_V, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support
                               Voltage override overclocking. 1b Indicates that
                               the part supports Voltage override overclocking.
                            */
    UINT32 FivrRfiTuningAvail : 1;

                            /* Bits[25:25], Access Type=ROS_V, default=0x00000000*/

                            /* FIVR RFI Tuning Support */
    UINT32 Dcu16kModeAvail : 1;

                            /* Bits[26:26], Access Type=ROS_V, default=0x00000000*/

                            /*
                               0b Indicates that the part does not support the
                               16K DCU mode. 1b Indicates that the part
                               supports 16K DCU mode.
                            */
    UINT32 SamplePart : 1;

                            /* Bits[27:27], Access Type=ROS_V, default=0x00000000*/

                            /*
                               A value of 1 indicates the processor is a
                               preproduction sample and a property of Intel, a
                               value of 0 indicates the part is intended for
                               production.
                            */
    UINT32 PrgTurboRatioEn : 1;

                            /* Bits[28:28], Access Type=RO_V, default=0x00000001*/

                            /*
                               Programmable Turbo Ratios per number of Active
                               Cores 0 = Programming Not Allowed 1 =
                               Programming Allowed
                            */
    UINT32 PrgTdpLimEn : 1;

                            /* Bits[29:29], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Programmable TDP Limits for Turbo Mode. 0 =
                               Programming Not Allowed 1 = Programming Allowed
                            */
    UINT32 PrgTjOffsetEn : 1;

                            /* Bits[30:30], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Programmable TJ Offset Enable. 0 = Programming
                               Not Allowed 1 = Programming Allowed
                            */
    UINT32 CpuidFaultingEn : 1;

                            /* Bits[31:31], Access Type=ROS_V, default=0x00000001*/

                            /*
                               When set to 1 indicates that the processor
                               supports raising a #GP if CPUID is executed when
                               not in SMM and the CPL > 0. When this bit is
                               set, it indicates that MISC_FEATURE_ENABLES[0]
                               can be written by a VMM.
                            */
    UINT32 LpmSupport : 1;

                            /* Bits[32:32], Access Type=ROS_V, default=0x00000000*/

                            /*
                               0 - Low Power Mode not Supported 1 - Low Power
                               Mode Supported
                            */
    UINT32 ConfigTdpLevels : 2;

                            /* Bits[34:33], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Configurable TDP Levels 00 Config TDP not
                               supported 01 One additional TDP level supported
                               10 Two additional TDP levels supported 11
                               Reserved
                            */
    UINT32 PfatEnable : 1;

                            /* Bits[35:35], Access Type=ROS_V, default=0x00000000*/

                            /*
                               BIOS GUARD (PFAT) Enable. 0 = PFAT is disabled 1
                               = PFAT is enabled
                            */
    UINT32 Peg2dmidisEn : 1;

                            /* Bits[36:36], Access Type=RO_V, default=0x00000001*/

                            /*
                               0 = PEG2DMIDIS is disabled 1 = PEG2DMIDIS is
                               enabled
                            */
    UINT32 TimedMwaitEnable : 1;

                            /* Bits[37:37], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Timed MWAIT Enable. 0 = Timed MWAIT is disabled
                               1 = Timed MWAIT is enabled
                            */
    UINT32 AsaEn : 1;

                            /* Bits[38:38], Access Type=ROS_V, default=0x00000001*/

                            /*
                               ASA Enable. 0 = ASA is disabled 1 = ASA is
                               enabled
                            */
    UINT32 Rsvd39 : 1;

                            /* Bits[39:39], Access Type=ROS_V, default=0x00000000*/

                            /* Reserved */
    UINT32 MaxEfficiencyRatio : 8;

                            /* Bits[47:40], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Maximum Efficiency Ratio. This is given in units
                               of 100 MHz.
                            */
    UINT32 MinOperatingRatio : 8;

                            /* Bits[55:48], Access Type=RO_V, default=0x00000008*/

                            /* Minimum Supported Ratio in units of 100MHz */
    UINT32 PushpatchEn : 1;

                            /* Bits[56:56], Access Type=ROS_V, default=0x00000000*/

                            /*
                               The value of this bit is the INVERTED value of
                               FUSE_PUSH_PATCH_DIS
                            */
    UINT32 EdramEnable : 1;

                            /* Bits[57:57], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that memory-side ACPI tables
                               can be used
                            */
    UINT32 Sxp2lmEnable : 1;

                            /* Bits[58:58], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that the FME_ACTIVATE MSR can
                               be setup Indicates to BIOS that the FZM
                               functionality can be enabled
                            */
    UINT32 SmmSupovrStateLockEnable : 1;

                            /* Bits[59:59], Access Type=ROS_V, default=0x00000001*/

                            /*
                               Indicates to BIOS that the SMM_SUPOVR_STATE_LOCK
                               MSR can be setup. This bit is unconditionally
                               set. [IntelRsvd]This bit is unconditionally set
                               for SoCs that support SNC[/IntelRsvd]
                            */
    UINT32 TioEnable : 1;

                            /* Bits[60:60], Access Type=ROS_V, default=0x00000000*/

                            /*
                               Indicates to BIOS that the Trusted IO (TIO) MSRs
                               can be accessed Indicates to BIOS that the
                               Trusted IO (TIO) functionality can be enabled
                               The value of this bit is the same as FUSE_TIO
                            */
    UINT32 Rsvd61 : 3;

                            /* Bits[63:61], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PLATFORM_INFO_REGISTER;

/**
  Various controls for RAR and Virtual RAR
**/
#define TGL_MSR_RAR_CONTROL 0x000000ED

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 28;

                            /* Bits[27:0], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 VrarIgnoreIf : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /*
                               When set virtual RAR event will not be masked by
                               EFLAAGS.IF
                            */
    UINT32 Rsvd29 : 1;

                            /* Bits[29:29], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RarIgnoreIf : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               When set RAR event will not be masked by
                               EFLAAGS.IF
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_RAR_CONTROL_REGISTER;

/**
  Physical address to the base of RAR action vector
**/
#define TGL_MSR_RAR_ACTION_VECTOR_BASE 0x000000EE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 6;

                            /* Bits[5:0], Access Type=RW, default=None*/

                            /*
                               Lower bits of physical address to the base of
                               RAR action vector. Must be zero to maintain
                               alignment to cacheline of 64B.
                            */
    UINT32 PhysicalAddr0 : 26;

                            /* Bits[31:6], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR action
                               vector
                            */
    UINT32 PhysicalAddr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR action
                               vector
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_RAR_ACTION_VECTOR_BASE_REGISTER;

/**
  Physical address to the base of RAR payload table
**/
#define TGL_MSR_RAR_PAYLOAD_TABLE_BASE 0x000000EF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reserved0 : 12;

                            /* Bits[11:0], Access Type=RW, default=None*/

                            /*
                               Lower bits of physical address to the base of
                               RAR action vector. Must be zero to maintain
                               alignment to 4KB page.
                            */
    UINT32 PhysicalAddr0 : 20;

                            /* Bits[31:12], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR payload
                               table
                            */
    UINT32 PhysicalAddr1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               Physical address to the base of RAR payload
                               table
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_RAR_PAYLOAD_TABLE_BASE_REGISTER;

/**
  Virtual RO MSR for RAR capabilities information.
**/
#define TGL_MSR_RAR_INFO 0x000000F0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PayloadTypeSupport : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x0000003F*/

                            /*
                               Supported payloads vector. A value of 1 inbit
                               position i indicates that payload i is supported
                            */
    UINT32 MaxPayloadIndexSupported : 32;

                            /* Bits[63:32], Access Type=RO_V, default=0x0000003F*/

                            /* Maximum supported payload index */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_RAR_INFO_REGISTER;

/**
  Control for RAR UC load timeout. Write of 0 value will disable UC load timeout. Write of non 0 value, will set a threshold for RAR UC load timeout.
**/
#define TGL_MSR_RAR_TIMER_CONFIG 0x000000F1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threshold : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               Threashold in micro seconds for RAR UC load
                               timeout
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_RAR_TIMER_CONFIG_REGISTER;

/**
  Controls Array PBIST triggered from ucode as part of FUSA.
**/
#define TGL_MSR_CORE_BIST 0x00000105

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BistArray : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               Array to apply PBIST (WRITE). Array not
                               processed (READ).
                            */
    UINT32 Bank : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Array bank of the [least significant set bit]
                               array indicated in EAX to start BIST (WRITE).
                               Array bank interrupted (READ)
                            */
    UINT32 Dword : 8;

                            /* Bits[47:40], Access Type=RW, default=0x00000000*/

                            /*
                               Array dword of the [least significant set bit]
                               array indicated in EAX to start BIST (WRITE).
                               Array dword interrupted (READ)
                            */
    UINT32 Rsvd48 : 15;

                            /* Bits[62:48], Access Type=RW, default=0x00000000*/

                            /* Reserved. */
    UINT32 CtrlResult : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               Bit to indicate if the operation cannot be
                               interrupted (WRITE). Result PASS/FAIL (READ)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CORE_BIST_REGISTER;

/**
  Controls error injections to FUSA BIST Arrays
**/
#define TGL_MSR_CORE_ARRAY_ERROR_INJECTION 0x00000106

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 BistArray : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /*
                               BIST Array to inject error. restrictions: This
                               MSR can ONLY be accessed from FUSA ACM.
                            */
    UINT32 ErrorAddr : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /*
                               Array address to inject error. restrictions:
                               This MSR can ONLY be accessed from FUSA ACM.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CORE_ARRAY_ERROR_INJECTION_REGISTER;

/**
  Specified IDI Parity Error Injection SRC Agent
**/
#define TGL_MSR_PERRINJ_AT_IP 0x00000107

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SrcAgent : 31;

                            /* Bits[30:0], Access Type=RW, default=0x00000000*/

                            /*
                               Source Agent of FUSA IDI Parity Injection.
                               restrictions: BIOS Boot SW will set and clear
                               the value.
                            */
    UINT32 Enable : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* LOCK bit to indicate the MSR has been programmed */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERRINJ_AT_IP_REGISTER;

/**
  Control Parity Error Injection
**/
#define TGL_MSR_PERRINJ_CTRL 0x00000108

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Payload : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Payload for Parity Injection */
    UINT32 GenMcerr : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               If set, then injects MCERR instead of injecting
                               parity error for MLC/Core
                            */
    UINT32 Rsvd33 : 31;

                            /* Bits[63:33], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERRINJ_CTRL_REGISTER;

/**
  Write-only virtual MSR to activate DCU flush command
**/
#define TGL_MSR_DCU_FLUSH_CMD 0x0000010B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DcuFlush : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /*  */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RW, default=None*/

                            /* reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_DCU_FLUSH_CMD_REGISTER;
/**
  This RO MSR will be used to read the Ubox MMCFG_RULE_CFG list
**/
#define TGL_MSR_MMCFG_RULE_CFG 0x00000129
/**
  This RO MSR will be used to read the Ubox MMCFG_RULE_TARGET_LIST
**/
#define TGL_MSR_MMCFG_RULE_TARGET_LIST 0x0000012A
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_0_0 0x00000130
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_1_1 0x00000131
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_2_2 0x00000132
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_3_3 0x00000133
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_4_4 0x00000134
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_5_5 0x00000135
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_6_6 0x00000136
/**
  Anchor Cove MSR for reading boot policy information from the PCH.
  8 new RDMSR range (addr 0x130-0x137), which read 64b each.
  Base addr is 0xFED58000 and reads are consecutive.
  " seq has 8 instances in addresses range 0x130 to 0x137"
**/
#define TGL_MSR_ANC_BOOT_POLICY_7_7 0x00000137
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 3 instances in addresses range 0x13D to 0x13F"
**/
#define TGL_MSR_CORE_SPECIFIC_SPARE_0_0 0x0000013D
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 3 instances in addresses range 0x13D to 0x13F"
**/
#define TGL_MSR_CORE_SPECIFIC_SPARE_1_1 0x0000013E
/**
  Spare core MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 3 instances in addresses range 0x13D to 0x13F"
**/
#define TGL_MSR_CORE_SPECIFIC_SPARE_2_2 0x0000013F
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_0_0 0x00000142
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_1_1 0x00000143
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_2_2 0x00000144
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_3_3 0x00000145
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_4_4 0x00000146
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_5_5 0x00000147
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_6_6 0x00000148
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_7_7 0x00000149
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_8_8 0x0000014A
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_9_9 0x0000014B
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_10_10 0x0000014C
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_11_11 0x0000014D
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_12_12 0x0000014E
/**
  Spare thread MSRs supported by the cregpla. Ucode (instead of the PLA) will signal #GP on access. WSM eco 653232
  " seq has 14 instances in addresses range 0x142 to 0x14F"
**/
#define TGL_MSR_THREAD_SPECIFIC_SPARE_13_13 0x0000014F

/**
  SNC_CONFIG_BASE register decription
**/
#define TGL_MSR_SNC_CONFIG 0x00000152

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 SncEnable : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 SncIndicationEnable : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* SNC Enable bit */
    UINT32 NumberOfClusters : 2;

                            /* Bits[3:2], Access Type=RW_V, default=0x00000000*/

                            /* Number Of Clusters */
    UINT32 Cluster1Base : 6;

                            /* Bits[9:4], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 2 Base */
    UINT32 Cluster2Base : 6;

                            /* Bits[15:10], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 3 Base */
    UINT32 Cluster3Base : 6;

                            /* Bits[21:16], Access Type=RW_V, default=0x00000000*/

                            /* Cluster 4 Base */
    UINT32 Rsvd22 : 6;

                            /* Bits[27:22], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 SncLock : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Due to SKL B0 freeze this late arrving bit is
                               implemented in
                               FSCP_CR_MISC_FEATURE_ENABLES[SNC_LOCK]
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_SNC_CONFIG_REGISTER;

/**
  Read-only MSR that specifies the maximum number of memory controllers on the platform capable of supporting memory persistence
**/
#define TGL_MSR_PERMEM_CONFIG_INFO 0x0000015C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ControllerCount : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               maximum number of memory controllers on the
                               platform capable of supporting memory
                               persistence
                            */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERMEM_CONFIG_INFO_REGISTER;

/**
  Index into the list of persistent memory addresses which is accessed when the PERMEM_CTRLR_ID MSR is read/written
**/
#define TGL_MSR_PERMEM_CTRLR_INDEX 0x0000015D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 ControllerIndex : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* Index into persistent memory address list */
    UINT32 Rsvd8 : 24;

                            /* Bits[31:8], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 31;

                            /* Bits[62:32], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERMEM_CTRLR_INDEX_REGISTER;

/**
  Read-only MSR that specifies the maximum number of memory controllers on the platform capable of supporting memory persistence
**/
#define TGL_MSR_PERMEM_CTRLR_ID 0x0000015E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 6;

                            /* Bits[5:0], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 ControllerIdentifier0 : 26;

                            /* Bits[31:6], Access Type=RW, default=None*/

                            /*
                               memory address that uniquely identifies a
                               persistent memory controller, whose index in
                               list is specified by PERMEM_CTRLR_INDEX
                            */
    UINT32 ControllerIdentifier1 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /*
                               memory address that uniquely identifies a
                               persistent memory controller, whose index in
                               list is specified by PERMEM_CTRLR_INDEX
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERMEM_CTRLR_ID_REGISTER;

/**
  Offcore Response Event Select Register
  " seq has 2 instances in addresses range 0x1A6 to 0x1A7"
**/
#define TGL_MSR_OFFCORE_RSP_0_0 0x000001A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               Reserved MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Rsvd38 : 26;

                            /* Bits[63:38], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_OFFCORE_RSP_0_0_REGISTER;

/**
  Offcore Response Event Select Register
  " seq has 2 instances in addresses range 0x1A6 to 0x1A7"
**/
#define TGL_MSR_OFFCORE_RSP_1_1 0x000001A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Reqtype : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /*
                               Request Type: MSR Bit 0 = Demand Data Rd = DCU
                               reads (includes partials) MSR Bit 1 = Demand RFO
                               = DCU RFOs MSR Bit 2 = Demand Ifetch = IFU
                               Fetches MSR Bit 3 = Writeback = Core modified WB
                               MSR Bit 4 = PF Data Rd = MPL Reads MSR Bit 5 =
                               PF RFO = MPL RFOs MSR Bit 6 = PF Ifetch = MPL
                               Fetches MSR Bit 7 = MLC prefetch to LLC - Load
                               (exclude LRUhints) MSR Bit 8 = MLC prefetch to
                               LLC - RFO MSR Bit 9 = MLC prefetch to LLC - Code
                               MSR Bit 10 = L1 Prefetch MSR Bit 11 = Write
                               Combining MSR Bit 12 = Core non-modified WB MSR
                               Bit 13 = LLCpref of load/code/RFO MSR Bit 14 =
                               Reserved MSR Bit 15 = Other
                            */
    UINT32 Any : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* Account for any snoop response from Uncore. */
    UINT32 NoSupplierDetails : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* No Supplier Details. */
    UINT32 L3HitMState : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /* L3 Hit M-State. */
    UINT32 L3HitEState : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /* L3 Hit E-State. */
    UINT32 L3HitSState : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /* L3 Hit S-State. */
    UINT32 L3HitFState : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /* L3 Hit F-State. */
    UINT32 L4HitLocalNode : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /* L4 Hit Local Node. */
    UINT32 L4HitRemote0hop : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 0 Hop */
    UINT32 L4HitRemote1hop : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 1 Hop */
    UINT32 L4HitRemote2hop : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /* L4 Hit 2 Hop. */
    UINT32 LlcMissLocalNode : 1;

                            /* Bits[26:26], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Local Node. */
    UINT32 LlcMissRemote0hop : 1;

                            /* Bits[27:27], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 0 Hop. */
    UINT32 LlcMissRemote1hop : 1;

                            /* Bits[28:28], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 1 Hop. */
    UINT32 LlcMissRemote2hop : 1;

                            /* Bits[29:29], Access Type=RW, default=0x00000000*/

                            /* LLC Miss Remote 2 or more Hop. */
    UINT32 SplHit : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /* SPL Hit */
    UINT32 None : 1;

                            /* Bits[31:31], Access Type=RW, default=0x00000000*/

                            /* No details as to Snoop-related info. */
    UINT32 NotNeeded : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 Miss : 1;

                            /* Bits[33:33], Access Type=RW, default=0x00000000*/

                            /* No snoop was neeeded to satisfy the request. */
    UINT32 HitNoFwd : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it Hits in at least one
                               snooped cache. Hit denotes a cache-line was
                               valid before snoop effect
                            */
    UINT32 HitWithFwd : 1;

                            /* Bits[35:35], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and data was Forwarded from a
                               remote socket.
                            */
    UINT32 Hitm : 1;

                            /* Bits[36:36], Access Type=RW, default=0x00000000*/

                            /*
                               A snoop was needed and it HitMed in local or
                               remote cache. HitM denotes a cache-line was
                               modified before snoop effect.
                            */
    UINT32 NonDram : 1;

                            /* Bits[37:37], Access Type=RW, default=0x00000000*/

                            /* Target was non-DRAM system address. */
    UINT32 Rsvd38 : 26;

                            /* Bits[63:38], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_OFFCORE_RSP_1_1_REGISTER;

/**
  NHM creg to filter LBR writes
**/
#define TGL_MSR_LBR_SELECT 0x000001C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CplEq0 : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* filter out ring 0 branches */
    UINT32 CplNeq0 : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* filter out non-ring 0 branches */
    UINT32 Jcc : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* filter out taken conditional branches */
    UINT32 NearRelCall : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /* filter out near relative calls */
    UINT32 NearIndirectCall : 1;

                            /* Bits[4:4], Access Type=RW, default=None*/

                            /* filter out near indirect calls */
    UINT32 NearRet : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* filter out near returns */
    UINT32 NearIndirectJmp : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* filter out near unconditional indirect jumps */
    UINT32 NearRelJmp : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* filter out near unconditional relative branches */
    UINT32 FarBranch : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* filter out far branches */
    UINT32 CallStack : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* enable LBR to only collect calls */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_SELECT_REGISTER;

/**
  LBR creg that holds the TOS value
**/
#define TGL_MSR_LBR_TOS 0x000001C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Tos : 5;

                            /* Bits[4:0], Access Type=RW_V, default=None*/

                            /* LBR TOS */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TOS_REGISTER;

/**
  LAST_BRANCH LBR MSR that holds non-IP information
**/
#define TGL_MSR_LAST_BRANCH_INFO 0x000001DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RO_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RO_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RO_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RO_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_BRANCH_INFO_REGISTER;

/**
  Top of LBR Stack
**/
#define TGL_MSR_LAST_BRANCH_FROM_IP 0x000001DB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=None*/

                            /* FROM LBR at Top of stack */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RO_V, default=None*/

                            /* FROM LBR at Top of stack */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_BRANCH_FROM_IP_REGISTER;

/**
  Top of LBR Stack
**/
#define TGL_MSR_LAST_BRANCH_TO_IP 0x000001DC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=None*/

                            /* TO LBR at top of stack */
    UINT32 Data1 : 16;

                            /* Bits[47:32], Access Type=RO_V, default=None*/

                            /* TO LBR at top of stack */
    UINT32 SignExt : 16;

                            /* Bits[63:48], Access Type=RO_V, default=None*/

                            /* sign extension of bit 47 */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_BRANCH_TO_IP_REGISTER;

/**
  Last Exeception Record
**/
#define TGL_MSR_LAST_INT_FROM_IP 0x000001DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LoData : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /* low FROM addr of Last Exeception Record */
    UINT32 HiData : 25;

                            /* Bits[56:32], Access Type=RW, default=None*/

                            /* high FROM addr of Last Exeception Record */
    UINT32 CycleCount : 3;

                            /* Bits[59:57], Access Type=RO_V, default=None*/

                            /* 3 MSBs of the cycle counter */
    UINT32 CycCtrMode : 1;

                            /* Bits[60:60], Access Type=RO_V, default=None*/

                            /* cycle counter mode */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW, default=None*/

                            /* TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW, default=None*/

                            /* ROB is in TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW, default=None*/

                            /* MBr was mispredicted */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_INT_FROM_IP_REGISTER;

/**
  Last Exeception Record
**/
#define TGL_MSR_LAST_INT_TO_IP 0x000001DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LoData : 32;

                            /* Bits[31:0], Access Type=RW, default=None*/

                            /* low TO addr of Last Exeception Record */
    UINT32 HiData : 25;

                            /* Bits[56:32], Access Type=RW, default=None*/

                            /*
                               high TO addr of Last Exeception Record. If VAPA
                               is fuse-disabled, then bits [56:48] are also
                               part of the CYCLE_COUNT
                            */
    UINT32 CycleCount : 7;

                            /* Bits[63:57], Access Type=RW, default=None*/

                            /* Elapsed cycle counter from previous branch */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_INT_TO_IP_REGISTER;

/**
  LER MSR that holds non-IP information
**/
#define TGL_MSR_LAST_INT_INFO 0x000001E0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LAST_INT_INFO_REGISTER;

/**
  Register used to enable customer specific features
**/
#define TGL_MSR_CUSTOMER_SPECIFIC_FEATURE_ENABLE 0x000001E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* RSVD */
    UINT32 UserLevelMwaitEnable : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Enable bit for user-level mwait */
    UINT32 RsvdUpper2 : 30;

                            /* Bits[31:2], Access Type=RW, default=None*/

                            /* RSVD */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CUSTOMER_SPECIFIC_FEATURE_ENABLE_REGISTER;

/**
  User-level Interrupts Vector
**/
#define TGL_MSR_ULI_VECTOR_INFO 0x000001E5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MatchVector : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /*
                               Interrupt vector to match on to provide ULI
                               handling
                            */
    UINT32 Enable : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* Enable bit for ULI handling */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_ULI_VECTOR_INFO_REGISTER;
/**
  User-level Interrupts Target RIP
**/
#define TGL_MSR_ULI_TARGET_RIP 0x000001E7

/**
  Valid PRMRR configurations
**/
#define TGL_MSR_PRMRR_VALID_CONFIG 0x000001FB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Config1m : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* 1M supported MEE size */
    UINT32 Config2m : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* 2M supported MEE size */
    UINT32 Rsvd2 : 3;

                            /* Bits[4:2], Access Type=RW, default=None*/

                            /* Reserved */
    UINT32 Config32m : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* 32M supported MEE size */
    UINT32 Config64m : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* 64M supported MEE size */
    UINT32 Config128m : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* 128M supported MEE size */
    UINT32 Config256m : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* 256M supported MEE size */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RW, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_VALID_CONFIG_REGISTER;

/**
  This register is used for generating corrected error interrupts.
  This is a 64 bits register. Refer to the MCA HAS for details.
  x86_architectural: true
  creg_msr_symbol: MCi_CTL2
  creg_msr_mask: 64'hFFFFFFFABFFF8000
**/
#define TGL_MSR_MCI_CTL2 0x00000298

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Correrrthrhd : 15;

                            /* Bits[14:0], Access Type=RWS, default=0x00000000*/

                            /*
                               Correctable Error Threshold (CorrErrThrhd): When
                               the correctable error count
                               (MCi_STATUS.CorrCount) transitions to being
                               equal to this threshold, a CMCI will be signaled
                               if the CorrErrCmciEn bit is set. Typically used
                               to indicate to OS that a certain amount of
                               corrected errors were observed.
                            */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Cmcien : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*
                               Corrected Error Interrupt Enable (CmciEn):
                               Enable CMCI signaling (when 1). Usage model is
                               to generate a CMCI interrupt for OS on corrected
                               or recoverable error. When the corrected error
                               threshold (CorrErrThrhd) is reached a CMCI will
                               be signaled.
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mapcmcitocsmi : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               Map Correctable Machine Check Interrupt to
                               Correctable SM Interrupt (MapCmciToCsmi): If set
                               then any correctable machine check interrupt
                               will be transformed into a correctable SM
                               interrupt so BIOS can intercept it.
                            */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mapmcetomsmi : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               Map Machine Check Errors to Machine Check SM
                               Interrupt (MapCmciToCsmi): If set then any
                               machine check error (i.e. a fatal condition
                               signalled to OS) will be transformed into a
                               machine check SM interrupt so BIOS can intercept
                               it.
                            */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MCI_CTL2_REGISTER;

/**
  IMCx_CR_MCx_CTL2 is responsible for enabling and controlling the CMCI mechanism and the correctable threshold value. (described in section 2.2.1 of the MCA HAS).
**/
#define TGL_MSR_IMC0_MC_CTL2 0x00000299

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CorErrCntTh : 15;

                            /* Bits[14:0], Access Type=RWS, default=0x00000000*/

                            /* Corrected error count threshold. */
    UINT32 Rsvd15 : 15;

                            /* Bits[29:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CmciEn : 1;

                            /* Bits[30:30], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MapCmciToCsmi : 1;

                            /* Bits[32:32], Access Type=RW, default=0x00000000*/

                            /*
                               Map Correctable Machine Check Interrupts to
                               Correctable SM Interrupts
                            */
    UINT32 Rsvd33 : 1;

                            /* Bits[33:33], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 MapMceToMsmi : 1;

                            /* Bits[34:34], Access Type=RW, default=0x00000000*/

                            /*
                               Map Machine Check Errors to Machine check SM
                               Interrupts
                            */
    UINT32 Rsvd35 : 29;

                            /* Bits[63:35], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC0_MC_CTL2_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_1_1 0x000002A1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_1_1_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_2_2 0x000002A2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_2_2_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_3_3 0x000002A3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_3_3_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_4_4 0x000002A4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_4_4_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_5_5 0x000002A5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_5_5_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_6_6 0x000002A6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_6_6_REGISTER;

/**
  Processor Reserved Memory Range Register - Physical Base Control Register
  " seq has 7 instances in addresses range 0x2A1 to 0x2A7"
**/
#define TGL_MSR_PRMRR_BASE_7_7 0x000002A7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE MemType */
    UINT32 Configured : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* PRMRR BASE Configured */
    UINT32 Rsvd4 : 8;

                            /* Bits[11:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* PRMRR Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PRMRR_BASE_7_7_REGISTER;

/**
  Uncore fixed counter control
**/
#define TGL_MSR_NCUPMONCTLFIX 0x00000394

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 20;

                            /* Bits[19:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable generation of Overflow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONCTLFIX_REGISTER;

/**
  Uncore fixed counter
**/
#define TGL_MSR_NCUPMONCTRFX 0x00000395

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONCTRFX_REGISTER;

/**
  This is MSR that shows to user configuration of uncore PMON's.
**/
#define TGL_MSR_NCUPMONCONFIG 0x00000396

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Numofcbopmon : 4;

                            /* Bits[3:0], Access Type=RWS, default=0x00000005*/

                            /*  */
    UINT32 Rsvd4 : 4;

                            /* Bits[7:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Numofidppmon : 1;

                            /* Bits[8:8], Access Type=RWS, default=0x00000000*/

                            /*  */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONCONFIG_REGISTER;

/**
  IDP 1 PMON Counter 1  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define TGL_MSR_PERFCTR0 0x000003B8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFCTR0_REGISTER;

/**
  IDP 1 PMON Counter 2  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define TGL_MSR_PERFCTR1 0x000003B9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFCTR1_REGISTER;

/**
  Controls the operation of the the PMON Counter 1 in IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_PERFEVTSEL0 0x000003BA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was. When
                               this field is zero, threshold comparison is
                               disabled and the event is passed without
                               modification (i.e. the counter will adevance by
                               the specified increment value).
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFEVTSEL0_REGISTER;

/**
  Controls the operation of the the PMON Counte 2 in IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_PERFEVTSEL1 0x000003BB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was.
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFEVTSEL1_REGISTER;

/**
  Holds global control fields for the NCU PMON counters for IDP 1.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_PERF_CTRL 0x000003BD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [3:1]
                               Core ID. When "TID Filter Enable" is clear in
                               the Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Gtid : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When this field is set (!=0) and TID Filter
                               Enable is set, only GT events will be count.
                               When this bit unset (==0) the filtering will be
                               according to threadid field.
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERF_CTRL_REGISTER;

/**
  Precise Performance Monitoring (PPMON) Event Control.  This register is read-write.
**/
#define TGL_MSR_PEBS_FRONTEND 0x000003F7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 EventId : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /*
                               Choose which event to monitor (ie. 1: L1_IMISS,
                               2: MLC_MISS, 3: ITLB_MISS, 4: STLB_MISS, 5:
                               DSB_MISS, 6: IDQ_READ_BUBBLES)
                            */
    UINT32 Rsvd3 : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 CriticalFilter : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               When asserted, cycles occurring while IDQ is
                               empty are filtered, otherwise they are
                               monitored.
                            */
    UINT32 Rsvd5 : 3;

                            /* Bits[7:5], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 FeLatency : 12;

                            /* Bits[19:8], Access Type=RW, default=0x00000008*/

                            /*
                               Number of consecutive cycles not having less
                               than FE_THRESHOLD bubbles which must occur
                               before logging the event.
                            */
    UINT32 FeThreshold : 3;

                            /* Bits[22:20], Access Type=RW, default=0x00000000*/

                            /*
                               Number of delivery bubbles (or more) of cycles
                               to count. If number of delivery bubbles is
                               greater than or equal to this field, then count
                               it.
                            */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PEBS_FRONTEND_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define TGL_MSR_PC3_RCNTR 0x000003F8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC3_RCNTR_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define TGL_MSR_PC6_RCNTR 0x000003F9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC6_RCNTR_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define TGL_MSR_PC7_RCNTR 0x000003FA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC7_RCNTR_REGISTER;

/**
  Time spent in the Core C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define TGL_MSR_CC7_RCNTR 0x000003FE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CC7_RCNTR_REGISTER;

/**
  Intel UPI MC STATUS Intel UPI Agents 0, 1, and 2 are assigned Machine Check Banks 5, 12, and 19, respectively.
**/
#define TGL_MSR_KTI_MC_ST 0x00000421

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 McacodLl : 2;

                            /* Bits[1:0], Access Type=RWS_V, default=0x00000000*/

                            /* MSCOD Bus Interconnect Error LL */
    UINT32 McacodIi : 2;

                            /* Bits[3:2], Access Type=RWS_V, default=0x00000000*/

                            /* MSCOD Bus Interconnect Error II */
    UINT32 McacodRrrr : 4;

                            /* Bits[7:4], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 McacodT : 1;

                            /* Bits[8:8], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 McacodPp : 2;

                            /* Bits[10:9], Access Type=RWS_V, default=0x00000000*/

                            /* MCACOD - Bus Int Error PPP */
    UINT32 McacodInt : 1;

                            /* Bits[11:11], Access Type=RWS_V, default=0x00000000*/

                            /* MCACOD - Bus Interconnect Error */
    UINT32 McacodRsvd : 4;

                            /* Bits[15:12], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 MscodCode : 6;

                            /* Bits[21:16], Access Type=RWS_V, default=0x00000000*/

                            /* MSCOD Error Code */
    UINT32 MscodSpare : 10;

                            /* Bits[31:22], Access Type=RWS_V, default=0x00000000*/

                            /* MSCOD SPARE */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /* Other Info */
    UINT32 CorErrCnt : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Corrected Error Count 15-bit counter which is
                               incremented on every corrected error. MSB (bit
                               15) is a sticky overflow bit.
                            */
    UINT32 CorrErrStsInd : 2;

                            /* Bits[54:53], Access Type=RWS, default=0x00000000*/

                            /*  */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Processor Context Corrupt Flag Bit set on all
                               uncorrectable errors
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /* Address Valid in KTI_MC_AD */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /* KTI_MC_MISC valid flag. */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error Enable Flag Set by hardware when MCA
                               (uncorrectable) is signaled.
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error Uncorrected Set for error which was not
                               corrected.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /* MCA Overflow Flag Set on all second error cases */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Set by hardware when an uncorrectable or
                               correctable error is logged.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_KTI_MC_ST_REGISTER;

/**
  Intel UPI MC ADDRESS Intel UPI Agents 0, 1, and 2 are assigned Machine Check Banks 5, 12, and 19, respectively.
**/
#define TGL_MSR_KTI_MC_AD 0x00000422

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 6;

                            /* Bits[5:0], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */
    UINT32 Address4560 : 26;

                            /* Bits[31:6], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Tx Address 45 to 6 Note: this is only applicable
                               if KTI_MC_ST.addrv=1. If both flit slot0 and
                               slot1 hit a Tx address parity error on the same
                               cycle, slot0 is logged here.
                            */
    UINT32 Address4561 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Tx Address 45 to 6 Note: this is only applicable
                               if KTI_MC_ST.addrv=1. If both flit slot0 and
                               slot1 hit a Tx address parity error on the same
                               cycle, slot0 is logged here.
                            */
    UINT32 Rsvd46 : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /* Field never set by hardware */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_KTI_MC_AD_REGISTER;

/**
  Intel UPI Agents 0, 1, and 2 are assigned Machine Check Banks 5, 12, and 19, respectively.
**/
#define TGL_MSR_KTI_MC_MISC 0x00000423

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 FlitHdr : 20;

                            /* Bits[19:0], Access Type=RWS_V, default=0x00000000*/

                            /* HDR bits captured */
    UINT32 SyndromeOrL0cbadlanes0 : 12;

                            /* Bits[31:20], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Captures Syndrome for CRC check, or in L0c error
                               captures 8-bit vector of bad lanes.
                            */
    UINT32 SyndromeOrL0cbadlanes1 : 4;

                            /* Bits[35:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Captures Syndrome for CRC check, or in L0c error
                               captures 8-bit vector of bad lanes.
                            */
    UINT32 IllegalFlitField : 1;

                            /* Bits[36:36], Access Type=RWS_V, default=0x00000000*/

                            /*
                               For Unexpected Flit Errors this bit is set if
                               unsupported error was cause by bits not captured
                               in Flit_HDR fields.
                            */
    UINT32 PhyState : 3;

                            /* Bits[39:37], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Link State from Physical Layer on error used for
                               isolating lane in CRC error cases
                            */
    UINT32 RxLaneReversal : 1;

                            /* Bits[40:40], Access Type=RWS_V, default=0x00000000*/

                            /* Indicates if physical layer Rx is reversed */
    UINT32 Rsvd41 : 1;

                            /* Bits[41:41], Access Type=RWS, default=0x00000000*/

                            /*
                               Unset by hardware. Placeholder bit in case h/w
                               finds reason to add a HDR_Valid
                            */
    UINT32 Nerr : 12;

                            /* Bits[53:42], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Captures the Next Error, which is any later
                               error which occurred after the primary error was
                               logged (in mscod_code).
                            */
    UINT32 CorErr : 10;

                            /* Bits[63:54], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Captures Correctable Errors, indicating all
                               correctable error cases that have occurred since
                               last cleared.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_KTI_MC_MISC_REGISTER;

/**
  The MCi MSR is a 64 bit register and contains information related to a machine check error if its
  VAL (valid) flag is set. Software is responsible for clearing the MC5_STATUS register by writing it with all
  0's. Writing 1's to this register will cause a general protection fault to be generated. This is enforced by the
  combination of WRMSR microcode and the CregPLA features. Refer to the MCA HAS for details.
  x86_architectural: true
  creg_msr_symbol: MCi_STATUS
  creg_msr_mask: 64'hFFFFFFFFFFFFFFFF
**/
#define TGL_MSR_MCI_STATUS 0x00000461

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the machine check architecture defined
                               error code for the machine check error condition
                               detected: bits[15:0] = 0000 0100 0000 0000:
                               Time-out. bits[15:0] = 0000 0000 0000 0101:
                               Parity error on internal Mesh2mem structures.
                               bits[15:7] = 0000 0010 0: Near-Memory Cache
                               controller error. Follow below encodings
                               bits[15:7] = 0000 0000 1: Last level memory
                               controller error. Follow below encodings
                               Bits[6:4] and bits[3:0] further sub-classify the
                               memory controller errors: bits[6:4] = 000:
                               Generic undefined request. bits[6:4] = 001:
                               Memory Read Error (MemRd*, MemSpecRd*, MemInv*).
                               bits[6:4] = 010: Memory Write Error. bits[6:4] =
                               011: Address/Command Error (iMC Parity error,
                               iMC BGF error, bucket1 error). bits[6:4] = 100:
                               Memory Scrubbing Error. bits[6:4] = 101-111:
                               reserved. Bits[3:0] expose physical channel
                               information from where the erroneous transaction
                               received error indications: bits[3:0] = Physical
                               Channel Number (0-2). So bits[3:2] always 0 in
                               this implementation. bits[3:0] = 1111: Channel
                               not specified. If both 1st and 2nd levels of
                               memory simultaneously encounter an error of the
                               same severity for a transaction then the channel
                               number logged here is the 1st level channel.
                            */
    UINT32 Mscoddatarderr : 1;

                            /* Bits[16:16], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for read error (MscodDataRdErr):
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected. 0: No MC read
                               data error logged; 1: Error logged is an MC read
                               data error. In this implementation, 'Read'
                               refers to one of {MemSpecRd, MemRd, MemRdData,
                               MemRdXtoI/S/A, MemInv*}.
                            */
    UINT32 Rsvd17 : 1;

                            /* Bits[17:17], Access Type=RWS_V, default=0x00000000*/

                            /* This bit is reserved for future use. */
    UINT32 Mscodptlwrerr : 1;

                            /* Bits[18:18], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for partial write error
                               (MscodPtlWrErr): Specifies a model specific
                               error code that uniquely identifies the machine
                               check error condition that has been detected. 0:
                               No MC partial write data error logged; 1: Error
                               logged is an MC partial write data error. In
                               this implementation, 'partial write' refers to
                               one of {MemWrPtl_I/S/A, MemWrPtlNI_I/S/A}. The
                               error is detected on the read data of the
                               partial write command.
                            */
    UINT32 Mscodfullwrerr : 1;

                            /* Bits[19:19], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for full write error (MscodFullWrErr):
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected. 0: No MC full
                               write data error logged; 1: Error logged is a
                               full write data error. Here, the term 'full
                               write' refers to one of {MemWr_I/S/A,
                               MemWrNI_I/S/A, MemWrFlush}. In case of
                               MemWrFlush, the ADDRV bit will not get set
                               because there is no relevant physical memory
                               address associated with this command. In SKX,
                               this bit will never be set as all full writes
                               are posted to the memory controller channel. Any
                               'full write' errors would get logged in the
                               memory channel controller Machine Check banks
                               instead of here.
                            */
    UINT32 Mscodbgferr : 1;

                            /* Bits[20:20], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for clock domains crossing error
                               (MscodBgfErr): Specifies a model specific error
                               code that uniquely identifies the machine check
                               error condition that has been detected. 0: No MC
                               cross-clock-domains buffer error logged; 1:
                               Logged an M2M clock-domain-crossing buffer (BGF)
                               error. This is a fatal error type.
                            */
    UINT32 Mscodtimeout : 1;

                            /* Bits[21:21], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for time out (MscodTimeout): Specifies
                               a model specific error code that uniquely
                               identifies the machine check error condition
                               that has been detected. 0: No M2M time-out
                               logged; 1: Error logged is an M2M time out. This
                               is a fatal error type.
                            */
    UINT32 Mscodparerr : 1;

                            /* Bits[22:22], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for M2M tracker parity error
                               (MscodParErr): Specifies a model specific error
                               code that uniquely identifies the machine check
                               error condition that has been detected. 0: An
                               M2M tracker parity error logged; 1: Error logged
                               is an M2M tracker parity error. This is a fatal
                               error type.
                            */
    UINT32 Mscodbucket1err : 1;

                            /* Bits[23:23], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for Bucket1 errors (MscodBucket1Err):
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected. 0: No Bucket1
                               error logged; 1: Error logged is a Bucket1
                               error. This is a fatal error type. Bucket1
                               contains credit and buffer underflows and
                               overflows.
                            */
    UINT32 Mscodddrtype : 2;

                            /* Bits[25:24], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bits for DDR4/DDRT specific error
                               (MscodDdrType): This is an attribute to
                               MscodDataRdErr, MscodPtlWrErr, MscodFullWrErr
                               errors. 00: Not logged whether error to DDR4 or
                               DDRT. 01: Error specifically on DDR4. 10: Error
                               specifically on DDRT. 11: Error for this
                               transaction was detected on both DDR4 and DDRT.
                            */
    UINT32 Mscodmiscerrs : 6;

                            /* Bits[31:26], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MSCOD bit for Miscellaneous errors
                               (MscodMiscErrs): Specifies a model specific
                               error code that uniquely identifies the machine
                               check error condition that has been detected.
                               For each bit in this bitvector: 0: No Misc error
                               logged; 1: Error logged is a Misc error. This
                               bitfield is unused in SKX.
                            */
    UINT32 Otherinfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Other Info (OtherInfo): The functions of the
                               bits in this field are implementation specific
                               and are not part of the machine check
                               architecture. In this particular implementation,
                               no information is revealed in this field.
                            */
    UINT32 Corrcount : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Corrected error count (CorrCount): A 15 bit
                               counter that is incremented each time a
                               corrected error is observed by the MCA recording
                               bank. Corrected in this context means either of:
                               retry corrected, ECC corrected, mirror scrub
                               corrected. No failover events (except when
                               CfgMcaCountOnFailover=1), nor recoverable events
                               are counted. This count value will continue
                               being incremented until cleared by software. The
                               most significant bit, 52, is a sticky count
                               overflow bit.
                            */
    UINT32 Corrstatus : 2;

                            /* Bits[54:53], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Corrected Error Status Indicator (CorrStatus):
                               Not used by the memory controller to reveal any
                               information in this implementation. Will always
                               get written with zeros (by hardware) in this
                               implementation.
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Action Required flag(AR): When set, indicates
                               immediate recovery action is required. M2M
                               always sets this bit to 0.
                            */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Signaling flag(S): When set, indicates an
                               MCE/MSMI was generated for a recoverable error;
                               when clear, indicates a CMCI/CSMI was
                               generated.M2M always sets this bit to 0.
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the state of the
                               processor might have been corrupted by the error
                               condition detected and that reliable restarting
                               of the processor may not be possible.
                               Interpretation: UC=0: corrected error; UC=1,
                               PCC=0: recoverable error; UC=1, PCC=1: fatal
                               error. Recoverable error: Uncorrectable error
                               from memory when poison enabled. Fatal error:
                               (i) Uncorrectable error from memory when poison
                               disabled, or (ii) Non-poison error (i.e. control
                               error, non-data error) when poison enabled.
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               This address-valid bit indicates (when set) that
                               the MC5_ADDR register contains the address of
                               the transaction for which the error occured.
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               This miscellaneous-valid bit indicates (when
                               set) that the MCi_MISC register contains
                               additional information regarding the error.
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that signaling of the
                               machine check exception for the logged error
                               type was enabled by an associated flag bit of
                               the MCi_CTL register.
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error logged in this bank is an uncorrected
                               error. UC=0: corrected error; UC=1, PCC=0:
                               recoverable error; UC=1, PCC=1: fatal error.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Overflow occured. Overflow indicates a second
                               machine check error occured while the
                               information from the first error was still
                               (valid) in the machine check register bank.
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /* VAL flag: Error logged in this bank is valid. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MCI_STATUS_REGISTER;

/**
  The MCi_ADDR MSR is a 64 bit register and contains the address of the memory location that
  produced the machine check error if the ADDRV flag in the MCi_STATUS register is set.
  If there is no meaningful address value for the corresponding MC Error, the ADDRV flag will be zero and,
  the MCi_ADDR value will be meaningless. The address returned is a full physical address. The upper address bits
  of this register (beyond the address size supported) are reserved for future address expansion and should
  always be set to zero by the HW. Refer to the MCA HAS for details.
  x86_architectural: true
  creg_msr_symbol: MCi_ADDR
  creg_msr_mask: 64'hFFFFFFFFFFFFFFFF
**/
#define TGL_MSR_MCI_ADDR 0x00000462

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvdlo0 : 6;

                            /* Bits[5:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Reserved for future address expansion and should
                               always be set to zero by the HW.
                            */
    UINT32 Lophyaddr : 26;

                            /* Bits[31:6], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Low-order Bits of the Physical Address
                               (LoPhyAddr): Contains 26 bits of physical
                               address [31:6] of a cache line.
                            */
    UINT32 Hiphyaddr : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               High-order Bits of the Physical Address
                               (HiPhyAddr): Contains 14 bits of physical
                               address [45:32] of the cache line.
                            */
    UINT32 Rsvdhi46 : 18;

                            /* Bits[63:46], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Reserved for future address expansion and should
                               always be set to zero by the HW.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MCI_ADDR_REGISTER;

/**
  This register is used for storing MCA miscellaneous information. Some of the errors are architectural errors,
  other errors are not.
  creg_msr_symbol: MCi_MISC
  creg_msr_mask: 64'hFFFFFFFFFFFFFFFF
**/
#define TGL_MSR_MCI_MISC 0x00000463

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Addrlsb : 6;

                            /* Bits[5:0], Access Type=RWS_V, default=0x00000006*/

                            /*
                               Address LSb (AddrLsb): Recoverable address LSb.
                               The lowest valid recoverable address bit.
                               Indicates the position of the least significant
                               bit (LSb) of the recoverable error address. It
                               is 6 for this implementation.
                            */
    UINT32 Addrmode : 3;

                            /* Bits[8:6], Access Type=RWS_V, default=0x00000002*/

                            /*
                               Address Mode (AddrMode): Address mode for the
                               address logged in IA32_MCi_ADDR. The supported
                               address modes are: 000 = Segment Offset; 001 =
                               Linear Address; 010 = Physical Address; 011 =
                               Memory Address; 100 to 110 = Reserved; 111 =
                               Generic. It is 2 for this implementation, i.e.
                               the physical (system) address gets logged.
                            */
    UINT32 Rsvd9 : 2;

                            /* Bits[10:9], Access Type=RWS_V, default=0x00000000*/

                            /* These bits are reserved for future use. */
    UINT32 Errortype : 10;

                            /* Bits[20:11], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error type attribute (ErrorType): Error type
                               determined (as best as possible) by error flow:
                               bits[9:8]: reserved. bit7: NM$ data-only-ECC-
                               uncorrectable: Might (or not) have corrected
                               this by data supplied from FM. PCC/UC tells what
                               end-result is, whether corrected from FM or not.
                               bit6: NM$ ECC-uncorrectable fatal: persistently
                               uncorrectable meta-data or data (latter case:
                               uncorr even after reloading from FM). No good
                               data was recovered. This is a fatal condition
                               (not recoverable). bit5: Txn caused permanent
                               hardware channel failover during mirroring.
                               bit4: Scrub check rd returned uncorrected data
                               (ECC correction is enabled during scrub check
                               rd); bit3: Scrub check rd returned good data
                               (note that ECC correction is enabled during
                               scrub check rd); bit2: Txn could not be
                               corrected by ECC; bit1: Txn had an ECC corrected
                               error (corrected by ECC during retry); bit0: Txn
                               had a transient error (corrected by retry
                               without ECC). It is possible for multiple bits
                               to be set in this bitvector. For 2LM, the case
                               of bit2 set and yet corrected error is signalled
                               (PCC=0, UC=0) represents a NMcache location that
                               could not be corrected, yet the FM stored data
                               saved the day.
                            */
    UINT32 Trkid : 9;

                            /* Bits[29:21], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Mesh2mem Tracker Identifier (TrkId): bits[7:6] =
                               physical channel associated with that tracker
                               (i.e. physical channel for initial access).
                               {bit[8],bits[5:0]} = htid within that channel.
                            */
    UINT32 Rsvd30 : 1;

                            /* Bits[30:30], Access Type=RWS_V, default=0x00000000*/

                            /* This bit is reserved for future use. */
    UINT32 Smiopcode0 : 1;

                            /* Bits[31:31], Access Type=RWS_V, default=0x00000000*/

                            /*
                               SMI Opcode (SmiOpcode): Decoding in case of
                               SMIAd==1 and SMIMsgClass==0(Request): 0=MemRd,
                               1=MemSpecRd, 2=MemRdData, 4=MemRdXtoS,
                               5=MemRdXtoI, 6=MemRdXtoA, 8=MemInv,
                               9=MemInvXtoI, 10=MemInvXtoA, 12=MemInvItoX.
                               Decoding in case of SMIBl==1 and
                               SMIMsgClass==5(Writeback): 0=MemWr, 3=MemWrNI,
                               4=MemWrPtl, 7=MemWrPtlNI, 11=MemWrFlush. Any
                               other encodings different from above are
                               illegal/unexpected.
                            */
    UINT32 Smiopcode1 : 3;

                            /* Bits[34:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               SMI Opcode (SmiOpcode): Decoding in case of
                               SMIAd==1 and SMIMsgClass==0(Request): 0=MemRd,
                               1=MemSpecRd, 2=MemRdData, 4=MemRdXtoS,
                               5=MemRdXtoI, 6=MemRdXtoA, 8=MemInv,
                               9=MemInvXtoI, 10=MemInvXtoA, 12=MemInvItoX.
                               Decoding in case of SMIBl==1 and
                               SMIMsgClass==5(Writeback): 0=MemWr, 3=MemWrNI,
                               4=MemWrPtl, 7=MemWrPtlNI, 11=MemWrFlush. Any
                               other encodings different from above are
                               illegal/unexpected.
                            */
    UINT32 Smimsgclass : 3;

                            /* Bits[37:35], Access Type=RWS_V, default=0x00000000*/

                            /*
                               SMI Message Class (SmiMsgClass): The logged
                               transaction's message class. The expectation is
                               to only see following values: 0: Request message
                               class. 5: Write-back message class.
                            */
    UINT32 Smiad : 1;

                            /* Bits[38:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               SMI AD message (SmiAD): The logged transaction
                               came in on AD. 0: txn from BL. 1: txn from AD.
                            */
    UINT32 Mccmdvld : 1;

                            /* Bits[39:39], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Memory Controller Command Valid (McCmdVld):
                               Memory controller command got logged. 0: no
                               McCmd logged, so don't interpret McCmd fields.
                               1: McCmd logged; can interpret McCmd fields.
                            */
    UINT32 Mccmdopcode : 6;

                            /* Bits[45:40], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Memory Controller Command Opcode (McCmdOpcode):
                               Memory controller command for which the error
                               got asserted (first error during retries):
                               0=MEMRD, 1=MEMSPECRD, 2=MEMRDDATA, 4=MEMRDXTOS,
                               5=MEMRDXTOI, 6=MEMRDXTOA, 8=MEMINV,
                               9=MEMINVXTOI, 10=MEMINVXTOA, 12=MEMINVITOX,
                               16=MEMWR, 19=MEMWRNI, 20=MEMWRPTL,
                               23=MEMWRPTLNI, 21=PATROL, 27=MEMWRFLUSH,
                               46=DEALLOCSBRD, 47=DEALLOCSBPF, 40= FMFILLRD,
                               48=DIRUPD, 49=NMFILLWR, 51=FMWR4NM,
                               55=FMWRPTL4NM, 56=FMEVICTWR, 62=DEALLOCSBWR,
                               63=DEALLOCSBALL. See MC_REQ_TYPE_ in mc.vh file.
                            */
    UINT32 Mccmdmemregion : 4;

                            /* Bits[49:46], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Memory region type (McCmdMemRegion): bit 0:
                               block region. bit 1: pmem region. bits [3:2] =
                               {cacheable, persistent}. {cacheable, persistent}
                               encoding: 0 = 1LM DDR4 access, 1 = DDRT access,
                               2 = DDR4 NM cache access (non-Pmem), 3 = DDR4 NM
                               cache access for Pmem.
                            */
    UINT32 Mccmdchnl : 2;

                            /* Bits[51:50], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Memory channel (McCmdChnl): Physical memory
                               channel which had the error. Determined during
                               retry. If no error on retry then this just
                               captures the channel of the initial retry. If
                               there was an error during the retry then this
                               will hold the physical channel on which the
                               error occured.
                            */
    UINT32 Rsvd52 : 5;

                            /* Bits[56:52], Access Type=RWS_V, default=0x00000000*/

                            /* These bits are reserved for future use. */
    UINT32 Mccmdmirrregion : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MC command was to a mirror region
                               (McCmdMirrRegion). Which might or might not have
                               failed over (see McCmdMirrFo bit).
                            */
    UINT32 Mccmdmirrsec : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error on secondary mirror channel
                               (McCmdMirrSec).
                            */
    UINT32 Mccmdmirrfo : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               MC command was to an already permanently failed
                               over channel/region (MirrFo).
                            */
    UINT32 Dataerrorchunk : 2;

                            /* Bits[61:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Chunk containing Data Error (DataErrorChunk):
                               Cache line half on which the data error occured:
                               00: no data error. 01: a data error signal came
                               on 1st half of cache line (critical chunk). 10:
                               a data error signal came on 2nd half of cache
                               line (non-critical chunk). 11: a data error
                               signal asserted both on 1st and 2nd half of
                               cache line.
                            */
    UINT32 Mirrorcorrerr : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Mirror Channel Corrected Error (MirrorCorrErr):
                               Error was corrected during mirroring and primary
                               channel scrubbed successfully. A successful
                               mirror scrub implies an error on the primary
                               channel got corrected by reading the data from
                               the secondary, writing that data to the primary
                               channel and successfully reading back the data
                               from the primary channel.
                            */
    UINT32 Mirrorfailover : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Mirror Failover Error (MirrorFailover): An error
                               occured on a memory channel of the mirror
                               channel pair. The error was corrected by channel
                               failover under mirroring. This implies a non-
                               ECC-correctable error, and not correctable by
                               mirror scrub on a channel. In this context
                               mirror failover is defined as the scrub check
                               read (after scrub wr) still had a non-ECC-
                               correctable error. In case of HW permanent
                               failover, as soon as one such failover event
                               happens, permanent failover i.e. taking out a
                               complete (failed) channel takes place.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_MCI_MISC_REGISTER;

/**
  The MCiCTL MSR controls the signalling of machine check exceptions generated by the bank.
**/
#define TGL_MSR_IMC0_MC_CTL 0x00000464

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DataSpareErr : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data sparing
                               errors.
                            */
    UINT32 DataScrubErr : 1;

                            /* Bits[1:1], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data scrubbing
                               errors.
                            */
    UINT32 DataWrtErr : 1;

                            /* Bits[2:2], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for data write errors */
    UINT32 DataByteEnableErr : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for data byte enable
                               errors
                            */
    UINT32 AddrErr : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for address errors */
    UINT32 CorrRdErr : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               Enables exception signalling for normal read
                               errors.
                            */
    UINT32 WdbParErr : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WDB parity err */
    UINT32 ApppParErr : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for address path
                               parity protection err
                            */
    UINT32 Mc2lmInvalReqErr : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unrecognized
                               request to 2LM controller
                            */
    UINT32 Mc2lmDatToInvalEntErr : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for read response to
                               an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmUnexpectedReadrspErr : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for unexpected 2LM
                               read response
                            */
    UINT32 Mc2lmDdr4CmpErr : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDR4 completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmDdrtCmpErr : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRt completion
                               to an invalid 2LM scoreboard entry
                            */
    UINT32 Mc2lmFifoOvflwErr : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for 2LM data or
                               completion FIFO overflow
                            */
    UINT32 VdbParErr : 1;

                            /* Bits[14:14], Access Type=RW, default=0x00000000*/

                            /*
                               enable exception signaling for DDRT WDB parity
                               err
                            */
    UINT32 RpaParErr : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for RPA parity err */
    UINT32 WpaParErr : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000000*/

                            /* enable exception signaling for WPA parity err */
    UINT32 DdrtEridUc : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /* Enable exception signalling for ERID UC Error */
    UINT32 DdrtIntrOverflow : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for interrupt seen
                               from FNV
                            */
    UINT32 DdrtEridFifoOverflow : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for for ERID FIFO
                               overflow error
                            */
    UINT32 DdrtFnvWrCreditError : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Write credit
                               error
                            */
    UINT32 DdrtFnvRdCreditError : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Read credi
                               error
                            */
    UINT32 DdrtSchedError : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtEridPar : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 LinkFail : 1;

                            /* Bits[24:24], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for DDRT scheduler
                               error
                            */
    UINT32 DdrtFnvThermal : 1;

                            /* Bits[25:25], Access Type=RW, default=0x00000000*/

                            /*
                               Enable exception signalling for FNV Thermal
                               event error
                            */
    UINT32 Rsvd26 : 6;

                            /* Bits[31:26], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC0_MC_CTL_REGISTER;

/**
  The MCiSTATUS MSR contains information related to a machine check error if its VAL (valid) flag is set.
**/
#define TGL_MSR_IMC0_MC_STATUS 0x00000465

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mcacod : 16;

                            /* Bits[15:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the machine check architecture defined
                               error code for the machine check error condition
                               detected
                            */
    UINT32 Mscod : 16;

                            /* Bits[31:16], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies a model specific error code that
                               uniquely identifies the machine check error
                               condition that has been detected
                            */
    UINT32 OtherInfo : 6;

                            /* Bits[37:32], Access Type=RWS_V, default=0x00000000*/

                            /*
                               The functions of the bits in this field are
                               implementation specific and are not part of the
                               machine check architecture.
                            */
    UINT32 CorErrCnt : 15;

                            /* Bits[52:38], Access Type=RWS_V, default=0x00000000*/

                            /*
                               A 15 bit counter that is incremented each time a
                               corrected (or uncorrected but ignorable) error
                               is observed by the MCA recording bank
                            */
    UINT32 CorErrStat : 2;

                            /* Bits[54:53], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are used to indicate when the number
                               of corrected errors has exceeded the safe
                               threshold to the point where an uncorrected
                               error has become more likely to happen
                               CORR_ERR_STAT does not apply to IMC and is
                               marked as reserved attribute
                            */
    UINT32 Ar : 1;

                            /* Bits[55:55], Access Type=RWS_V, default=0x00000000*/

                            /*
                               AR - Action REquired. When set it indicates that
                               SW needs to take immediate recovery action for
                               the error. When clear, SW does not need to take
                               immediate action. Similar to the S bit, the AR
                               bit has meaning only when an error is logged
                               with UC=1 and PCC=0.
                            */
    UINT32 S : 1;

                            /* Bits[56:56], Access Type=RWS_V, default=0x00000000*/

                            /*
                               S - Signaling. When set it indicates that the
                               error was signaled with an MCERR. When clear it
                               indicates that the error was signaled via a
                               CMCI. The S bit has meaning only when an error
                               is logged with UC=1 and PCC=0.
                            */
    UINT32 Pcc : 1;

                            /* Bits[57:57], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the state of the
                               processor might have been corrupted by the error
                               condition detected and that reliable restarting
                               of the processor may not be possible
                            */
    UINT32 Addrv : 1;

                            /* Bits[58:58], Access Type=RWS_V, default=0x00000000*/

                            /*
                               indicates (when set) that the MCiADDR register
                               contains the address where the error occurred
                            */
    UINT32 Miscv : 1;

                            /* Bits[59:59], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that the MCiMISC register
                               contains additional information regarding the
                               error.
                            */
    UINT32 En : 1;

                            /* Bits[60:60], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Indicates (when set) that signaling of the
                               machine check exception for this error was
                               enabled by an associated flag bit of the MCiCTL
                               register
                            */
    UINT32 Uc : 1;

                            /* Bits[61:61], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Error logged in this banks is an uncorrected
                               error.
                            */
    UINT32 Over : 1;

                            /* Bits[62:62], Access Type=RWS_V, default=0x00000000*/

                            /*
                               (Overflow) Indicates (when set) that a machine
                               check error occurred while the results of a
                               previous error were still in the register bank
                            */
    UINT32 Valid : 1;

                            /* Bits[63:63], Access Type=RWS_V, default=0x00000000*/

                            /* Error logged in this bank is valid */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC0_MC_STATUS_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define TGL_MSR_IMC0_MC8_ADDR 0x00000466

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC0_MC8_ADDR_REGISTER;

/**
  The MCiMISC MSR contains additional micro-architecture specific information describing the machine check error if the MISCV flag in the MCiSTATUS register is set. It is also possible to use the Other Info field in the MCiSTATUS register for the same type of model specific error reporting
**/
#define TGL_MSR_IMC0_MC_MISC 0x00000467

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RecErrLsb : 6;

                            /* Bits[5:0], Access Type=RWS_V, default=0x00000000*/

                            /*
                               Specifies the LSB of the recoverable address
                               (this may differ from unit to unit). This tells
                               the OS to ignore bits from LSB-1:0
                            */
    UINT32 AddrMode : 3;

                            /* Bits[8:6], Access Type=RWS_V, default=0x00000000*/

                            /*
                               defines the type of address captured in the
                               MC5ADDR MSR. Set by hardware, Clear by
                               programming. 000: Segment Offset 001: Linear
                               Address 010: Physical (system) Address 011:
                               Memory Address 111: Generic
                            */
    UINT32 ExtraErrInfo0 : 23;

                            /* Bits[31:9], Access Type=RWS_V, default=0x00000000*/

                            /*  */
    UINT32 ExtraErrInfo1 : 32;

                            /* Bits[63:32], Access Type=RWS_V, default=0x00000000*/

                            /*  */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC0_MC_MISC_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define TGL_MSR_IMC1_MC9_ADDR 0x0000046A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC1_MC9_ADDR_REGISTER;

/**
  The MCiADDR MSR contains the address of the code or data memory location that produced the machine check error if the ADDRV flag in the MCiSTATUS register is set.
**/
#define TGL_MSR_IMC2_MCA_ADDR 0x0000046E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Address0 : 32;

                            /* Bits[31:0], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 Address1 : 14;

                            /* Bits[45:32], Access Type=RWS_V, default=0x00000000*/

                            /* Address associated with the error. */
    UINT32 UnimplementedUpperAddress : 18;

                            /* Bits[63:46], Access Type=RWS, default=0x00000000*/

                            /*
                               These bits are not implemented in that they will
                               never by set to one due to a detected error.
                               They can be written and read for software
                               testing.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IMC2_MCA_ADDR_REGISTER;

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in the middle of long flow and hence
  will delay servicing of SMI. SMI will be serviced after the long flow
  completes execution.
**/
#define TGL_MSR_SMM_DELAYED 0x000004E2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 16;

                            /* Bits[15:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit will be set at the start of the events
                               listed below and cleared at the end of the
                               events. Patch load C6 entry C6 exit WBINVD Ratio
                               Change/Throttle/S1
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_SMM_DELAYED_REGISTER;

/**
  This register contains bit per logical processor indicating
  whether the logical processor is in state where SMIs are blocked and hence
  will not be able to service SMI. SMI can be serviced after the logical
  processor exits the state in which SMIs are blocked
**/
#define TGL_MSR_SMM_BLOCKED 0x000004E3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 LogProc : 16;

                            /* Bits[15:0], Access Type=RW_V, default=0x0000FFFF*/

                            /*
                               This bit will be set when the logical processor
                               is in the following states Wait For SIPI SENTER
                               Sleep VMX Abort Error Shutdown (Machine check in
                               WFS state)
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_SMM_BLOCKED_REGISTER;

/**
  Extended Page Table Pointer
**/
#define TGL_MSR_EPTP 0x00000510

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Memtype : 3;

                            /* Bits[2:0], Access Type=RW, default=0x00000000*/

                            /* EPT Memory Type */
    UINT32 Rsvd3 : 3;

                            /* Bits[5:3], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 EptADEnable : 1;

                            /* Bits[6:6], Access Type=RW, default=0x00000000*/

                            /* EPT A/D enable */
    UINT32 EptSssEnable : 1;

                            /* Bits[7:7], Access Type=RW, default=0x00000000*/

                            /*
                               Enable bit for EPT enabling supervisor shadow
                               stack pages
                            */
    UINT32 Rsvd8 : 4;

                            /* Bits[11:8], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 Address0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               Page-Map Level-4/5 Address restrictions : The
                               PMH2_EPTP creg is not a real creg. It is shadow
                               so that a write to the CORE_EPTP will update the
                               ASID_EPTP in the pmh. So if you do a Write then
                               Read of the PMH2_EPTP you will receive Xs.
                            */
    UINT32 Address1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               Page-Map Level-4/5 Address restrictions : The
                               PMH2_EPTP creg is not a real creg. It is shadow
                               so that a write to the CORE_EPTP will update the
                               ASID_EPTP in the pmh. So if you do a Write then
                               Read of the PMH2_EPTP you will receive Xs.
                            */
    UINT32 Rsvd52 : 9;

                            /* Bits[60:52], Access Type=RW, default=0x00000000*/

                            /* Reserved bits */
    UINT32 EptMbeEnable : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               Enable bit for EPT Mode Based Execution
                               (required also paging is ON in guest)
                            */
    UINT32 Ept5l : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /* Enable 5L EPT */
    UINT32 Enable : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               EPT enable bit restrictions : The PMH2_EPTP creg
                               is not a real creg. It is shadow so that a write
                               to the CORE_EPTP will update the ASID_EPTP in
                               the pmh. So if you do a Write then Read of the
                               PMH2_EPTP you will receive Xs.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_EPTP_REGISTER;
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_1_1 0x00000514
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_2_2 0x00000515
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_3_3 0x00000516
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_4_4 0x00000517
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_5_5 0x00000518
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_6_6 0x00000519
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_7_7 0x0000051A
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_8_8 0x0000051B
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_9_9 0x0000051C
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_10_10 0x0000051D
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_11_11 0x0000051E
/**
  This define is used to reserve some MSR addresses for probe mode. Ucode would have a dedicated handler for these MSRs
  " seq has 12 instances in addresses range 0x514 to 0x51F"
**/
#define TGL_MSR_PROBE_MODE_RESERVED_12_12 0x0000051F

/**
  Core UARCH_CTL msr
**/
#define TGL_MSR_CORE_UARCH_CTL 0x00000541

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DcuScrubEn : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* L1 scrubbing enable */
    UINT32 Rsvd1 : 31;

                            /* Bits[31:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CORE_UARCH_CTL_REGISTER;

/**
  Input voltage regulator configuration parameters.
**/
#define TGL_MSR_VR_MISC_CONFIG 0x00000603

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DynamicLoadLineR : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000036*/

                            /*
                               The Dynamic load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 IdleLoadLineR : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000036*/

                            /*
                               The Idle load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 LeakLoadLineR : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000036*/

                            /*
                               The Leakage load line value in 10/256 mOhm
                               increments. Values range from 0 mOhm to 10 mOhm.
                            */
    UINT32 MinVid : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000000*/

                            /*
                               Used to constrain the CPU's minimum voltage
                               during package C6/C7 C-states. The default
                               setting of 0x00 will result in full CPU control
                               over the minimum VID. VID resolution is 10mV /
                               LSB. This is internally clipped by fuses to the
                               C6/C7 voltage.
                            */
    UINT32 IoutOffset : 8;

                            /* Bits[39:32], Access Type=RW, default=0x00000000*/

                            /*
                               Signed offset added to VR dIout readings for
                               correction. 2s-complement signed number
                               expressed as a fraction of the IccMax of the VR.
                               Format: S8.-4.11 (8bits, floating point shifted
                               by 4 points). Precision: 0.049% (1/2^11) Range:
                               +/-6.25% of IccMax of the VR. Allowable range
                               may be clipped by processor on a per-SKU basis.
                            */
    UINT32 IoutSlope : 10;

                            /* Bits[49:40], Access Type=RW, default=0x00000200*/

                            /*
                               This is a slope correction for VR dIout readings
                               for postitive/negative correction. This scalar
                               is applied to every dIout reading before it is
                               consumed by the CPU. This scalar represents a
                               1.x number in U10.1.9 format (0.0 to 2.0 scalar
                               in ~0.19% increments)
                            */
    UINT32 IdleExitRampRate : 1;

                            /* Bits[50:50], Access Type=RW, default=0x00000001*/

                            /*
                               Controls the VR ramp rate on package C-state
                               wake events. 1 == fast, 0 == slow. Note that
                               fast will only apply to the Fast Ramp Voltage in
                               VR_MISC_CONFIG2[7:0]
                            */
    UINT32 IdleEntryRampRate : 1;

                            /* Bits[51:51], Access Type=RW, default=0x00000000*/

                            /*
                               Controls the VR ramp rate on package C-state
                               entry events. 1 == fast, 0 == slow. If Decay is
                               set, it has priority. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 IdleEntryDecayEnable : 1;

                            /* Bits[52:52], Access Type=RW, default=0x00000001*/

                            /*
                               Enables decay mode on package C-state entry.
                               Decay mode implies PS2 or deeper. When Decay is
                               enabled, it has priority over the
                               IDLE_ENTRY_RAMP_RATE. These are used in package
                               C6/C7/C8/C9/C10.
                            */
    UINT32 SlowSlewRateConfig : 2;

                            /* Bits[54:53], Access Type=RW, default=0x00000001*/

                            /*
                               Defines the desired ratio between the VR fast
                               slope and slow slope. Pcode programs the VR on
                               BIOS complition 00 - slow = fast/2 01 - slow =
                               fast/4 (default) 10 - slow = fast/8 11 - slow =
                               fast/16
                            */
    UINT32 Rsvd55 : 9;

                            /* Bits[63:55], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_VR_MISC_CONFIG_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
**/
#define TGL_MSR_PC2_RCNTR 0x0000060D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC2_RCNTR_REGISTER;

/**
  This register allows platform BIOS to limit the power consumption of the processor to the specified values.
**/
#define TGL_MSR_PACKAGE_RAPL_LIMIT 0x00000610

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PkgPwrLim1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000118*/

                            /*
                               Average Power limit value which the package must
                               not exceed over a time window as specified by
                               Power_Limit_1_TIME field above. The processor
                               power consumption will be controlled to the
                               Power_Limit_1 value over an exponential weighted
                               moving average of the time window. This field is
                               specified in the units as identified by the
                               PACKAGE_POWER_SKU_UNIT (MSR 606h). Initial value
                               varies based on the SKU.
                            */
    UINT32 PkgPwrLim1En : 1;

                            /* Bits[15:15], Access Type=RO, default=0x00000001*/

                            /*
                               When set, enables processor to apply control
                               policies such that the package average power
                               does not exceed Power_Limit_1 value over an
                               exponential weighted moving average of the time
                               window. This bit is always enabled indicating
                               Power_Limit_1 is always active. Because the
                               processor must maintain the power consumption to
                               the TDP value, Power_Limit_1 is always enabled.
                            */
    UINT32 PkgClmpLim1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_1 value specified below.
                               This bit is writable only when
                               CPUID.(EAX=06h):EAX[4] is set.
                            */
    UINT32 PkgPwrLim1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               This indicates the time window over which
                               Power_Limit_1 value should be maintained. This
                               field is made up of two numbers from the
                               following equation. The processor power
                               consumption will be controlled to the
                               Power_Limit_1 value over an exponential weighted
                               moving average of the time window. Time Window =
                               (float) ((1+(X/4)) * (2 ^ Y)) Where: X =
                               POWER_LIMIT_1_TIME[23:22] Y =
                               POWER_LIMIT_1_TIME[21:17] The unit of
                               measurement for this field is available from
                               PACKAGE_POWER_SKU_UNIT (MSR 606h). The maximum
                               allowed value in this field is defined in
                               PACKAGE_POWER_SKU (MSR 614h) PACKAGE_MAX_TIME
                               field.
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgPwrLim2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               This field indicates the power limitation #2.
                               The unit of measurement is defined in
                               PACKAGE_POWER_SKU_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 PkgPwrLim2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               This bit enables/disables PKG_PWR_LIM_2. 0b
                               Package Power Limit 2 is Disabled 1b Package
                               Power Limit 2 is Enabled
                            */
    UINT32 PkgClmpLim2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_2 value specified below.
                               This bit is writable only when
                               CPUID.(EAX=6):EAX[4] is set.
                            */
    UINT32 PkgPwrLim2Time : 7;

                            /* Bits[55:49], Access Type=RW_L, default=0x00000000*/

                            /*
                               This indicates the short duration time window
                               over which Power_Limit_2 value should be
                               maintained. This field is made up of two numbers
                               from the following equation. The processor power
                               consumption will be controlled to the
                               Power_Limit_2 value over an exponential weighted
                               moving average of the time window. Time Window =
                               (float) ((1+(X/4)) * (2 ^ Y)) Where: X =
                               POWER_LIMIT_2_TIME[55:54] Y =
                               POWER_LIMIT_2_TIME[53:49] The unit of
                               measurement for this field is available from
                               PACKAGE_POWER_SKU_UNIT (MSR 606h).
                            */
    UINT32 Rsvd56 : 7;

                            /* Bits[62:56], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PkgPwrLimLock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /*
                               When set, all settings in this register are
                               locked and are treated as Read Only. This bit
                               will typically set by BIOS during boot time or
                               resume from Sx.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PACKAGE_RAPL_LIMIT_REGISTER;

/**

**/
#define TGL_MSR_DRAM_POWER_INFO_CFG 0x0000061C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 DramTdp : 15;

                            /* Bits[14:0], Access Type=RW, default=0x00000118*/

                            /*
                               The Spec power allowed for DRAM. The TDP setting
                               is typical (not guaranteed). The units for this
                               value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd15 : 1;

                            /* Bits[15:15], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMinPwr : 15;

                            /* Bits[30:16], Access Type=RW, default=0x00000078*/

                            /*
                               The minimal power setting allowed for DRAM.
                               Lower values will be clamped to this value. The
                               minimum setting is typical (not guaranteed). The
                               units for this value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd31 : 1;

                            /* Bits[31:31], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxPwr : 15;

                            /* Bits[46:32], Access Type=RW, default=0x00000258*/

                            /*
                               The maximal power setting allowed for DRAM.
                               Higher values will be clamped to this value. The
                               maximum setting is typical (not guaranteed). The
                               units for this value are defined in
                               DRAM_POWER_INFO_UNIT_MSR[PWR_UNIT].
                            */
    UINT32 Rsvd47 : 1;

                            /* Bits[47:47], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 DramMaxWin : 7;

                            /* Bits[54:48], Access Type=RW, default=0x00000028*/

                            /*
                               The maximal time window allowed for the DRAM.
                               Higher values will be clamped to this value. x =
                               PKG_MAX_WIN[54:53] y = PKG_MAX_WIN[52:48] The
                               timing interval window is Floating Point number
                               given by 1.x * power(2,y). The unit of
                               measurement is defined in
                               DRAM_POWER_INFO_UNIT_MSR[TIME_UNIT].
                            */
    UINT32 Rsvd55 : 8;

                            /* Bits[62:55], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /* Lock bit to lock the Register */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_DRAM_POWER_INFO_CFG_REGISTER;

/**
  Time spent with LLC flushed. Count at the same frequency as the TSC
**/
#define TGL_MSR_LLC_FLUSHED_RCNTR 0x0000061D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_FLUSHED_RCNTR_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define TGL_MSR_PC8_RCNTR 0x00000630

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC8_RCNTR_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define TGL_MSR_PC9_RCNTR 0x00000631

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC9_RCNTR_REGISTER;

/**
  Time spent in the Package C-State.  It is given in units compatible to P1 clock frequency (Guaranteed / Maximum Core Non-Turbo Frequency).
  This time will be updated by PCODE only after the C-State exit (the update of this register has lower priority than actually ensuring that the C-State exit occurs).
  For C2, this value includes any forced or popup time from other states.
  For C3/C6/C7/C8/C9/C10, this value does not include popup periods, but advances even if VR actions are disabled.
**/
#define TGL_MSR_PC10_RCNTR 0x00000632

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Data1 : 28;

                            /* Bits[59:32], Access Type=RW, default=0x00000000*/

                            /* Counter Value */
    UINT32 Rsvd60 : 4;

                            /* Bits[63:60], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PC10_RCNTR_REGISTER;

/**
  Provides addtional HWP insight when performance limited
**/
#define TGL_MSR_IA_PERF_LIMIT_REASONS2 0x0000064D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* data */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IA_PERF_LIMIT_REASONS2_REGISTER;

/**
  Platform power limit
**/
#define TGL_MSR_PLATFORM_POWER_LIMIT 0x0000065C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 PowerLimit1 : 15;

                            /* Bits[14:0], Access Type=RW_L, default=0x00000000*/

                            /*
                               Average Power limit value which the Platform
                               must not exceed over a time window as specified
                               by Power_Limit_1_TIME field above.
                            */
    UINT32 PowerLimit1En : 1;

                            /* Bits[15:15], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the Platform average power
                               does not exceed Power_Limit_1 value over an
                               exponential weighted moving average of the time
                               window.
                            */
    UINT32 CriticalPowerClamp1 : 1;

                            /* Bits[16:16], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_1 value specified below.
                            */
    UINT32 PowerLimit1Time : 7;

                            /* Bits[23:17], Access Type=RW_L, default=0x0000000A*/

                            /*
                               This indicates the time window over which
                               Power_Limit_1 value should be maintained.
                            */
    UINT32 Rsvd24 : 8;

                            /* Bits[31:24], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 PowerLimit2 : 15;

                            /* Bits[46:32], Access Type=RW_L, default=0x00000000*/

                            /*
                               Duration Power limit value which the Platform
                               must not exceed. This field is specified in the
                               units as identified by the
                               PALTFORM_POWER_SKU_UNIT (MSR606h).
                            */
    UINT32 PowerLimit2En : 1;

                            /* Bits[47:47], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, enables processor to apply control
                               policies such that the platform power does not
                               exceed Power_Limit_2 value.
                            */
    UINT32 CriticalPowerClamp2 : 1;

                            /* Bits[48:48], Access Type=RW_L, default=0x00000000*/

                            /*
                               When set, allows processor to go below the OS
                               requested P States in order to maintain the
                               power below Power_Limit_2 value specified below.
                            */
    UINT32 Rsvd49 : 14;

                            /* Bits[62:49], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Lock : 1;

                            /* Bits[63:63], Access Type=RW_KL, default=0x00000000*/

                            /* Locks all other fields. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PLATFORM_POWER_LIMIT_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_0_0 0x00000680

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_0_0_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_1_1 0x00000681

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_1_1_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_2_2 0x00000682

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_2_2_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_3_3 0x00000683

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_3_3_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_4_4 0x00000684

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_4_4_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_5_5 0x00000685

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_5_5_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_6_6 0x00000686

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_6_6_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_7_7 0x00000687

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_7_7_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_8_8 0x00000688

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_8_8_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_9_9 0x00000689

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_9_9_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_10_10 0x0000068A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_10_10_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_11_11 0x0000068B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_11_11_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_12_12 0x0000068C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_12_12_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_13_13 0x0000068D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_13_13_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_14_14 0x0000068E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_14_14_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_15_15 0x0000068F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_15_15_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_16_16 0x00000690

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_16_16_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_17_17 0x00000691

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_17_17_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_18_18 0x00000692

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_18_18_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_19_19 0x00000693

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_19_19_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_20_20 0x00000694

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_20_20_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_21_21 0x00000695

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_21_21_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_22_22 0x00000696

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_22_22_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_23_23 0x00000697

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_23_23_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_24_24 0x00000698

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_24_24_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_25_25 0x00000699

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_25_25_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_26_26 0x0000069A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_26_26_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_27_27 0x0000069B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_27_27_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_28_28 0x0000069C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_28_28_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_29_29 0x0000069D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_29_29_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_30_30 0x0000069E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_30_30_REGISTER;

/**
  LBR MSR that holds the from IP, canonical check for write, see Vol 3A
**/
#define TGL_MSR_LBR_FROM_IP_31_31 0x0000069F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* From IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_FROM_IP_31_31_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_0_0 0x000006C0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_0_0_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_1_1 0x000006C1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_1_1_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_2_2 0x000006C2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_2_2_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_3_3 0x000006C3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_3_3_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_4_4 0x000006C4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_4_4_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_5_5 0x000006C5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_5_5_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_6_6 0x000006C6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_6_6_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_7_7 0x000006C7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_7_7_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_8_8 0x000006C8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_8_8_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_9_9 0x000006C9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_9_9_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_10_10 0x000006CA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_10_10_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_11_11 0x000006CB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_11_11_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_12_12 0x000006CC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_12_12_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_13_13 0x000006CD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_13_13_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_14_14 0x000006CE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_14_14_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_15_15 0x000006CF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_15_15_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_16_16 0x000006D0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_16_16_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_17_17 0x000006D1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_17_17_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_18_18 0x000006D2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_18_18_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_19_19 0x000006D3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_19_19_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_20_20 0x000006D4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_20_20_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_21_21 0x000006D5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_21_21_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_22_22 0x000006D6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_22_22_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_23_23 0x000006D7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_23_23_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_24_24 0x000006D8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_24_24_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_25_25 0x000006D9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_25_25_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_26_26 0x000006DA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_26_26_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_27_27 0x000006DB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_27_27_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_28_28 0x000006DC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_28_28_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_29_29 0x000006DD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_29_29_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_30_30 0x000006DE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_30_30_REGISTER;

/**
  LBR MSR that holds the from IP
**/
#define TGL_MSR_LBR_TO_IP_31_31 0x000006DF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Data0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 Data1 : 25;

                            /* Bits[56:32], Access Type=RW_V, default=None*/

                            /* Target IP */
    UINT32 SignExt : 7;

                            /* Bits[63:57], Access Type=RO_V, default=None*/

                            /*
                               sign extension of bit 56 (VAPA fuse-enabled) or
                               bit 47 (VAPA fuse-disabled)
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_TO_IP_31_31_REGISTER;

/**
  Controls the operation of the the PMON Counter 1 in IDP 0.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_PERFEVTSEL0_0 0x00000705

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectiv When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification (i.e. the counter
                               will adevance by the specified increment value).
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFEVTSEL0_0_REGISTER;

/**
  Controls the operation of the the PMON Counte 2 in IDP 0.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_PERFEVTSEL1_1 0x00000706

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               a selector for measured signals Details of
                               events are TBD
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               A set of qualifiers defined for each of the
                               events. Details for the counter are TBD.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Enubp : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the generation of micro-breakpoint event
                               on event occurrence. 0b Do not assert micro-
                               breakpoint on event occurrence 1b Assert micro-
                               breakpoint on event occurrence
                            */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfen : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Enable generation of Overfolow indiation when
                               this counter overflows. 0 : PMI Event for this
                               counter is disabled 1 : PMI event is enabled
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active. 0 : counter is disabled and
                               will not count when global enable is set. 1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               Invert the event for counting purposes : 0 :
                               Count when the event is asserted or on it's
                               rising edge 1. : Count when the event is de-
                               asserted or on it's falling edge
                            */
    UINT32 Threshold : 5;

                            /* Bits[28:24], Access Type=RW, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming increment value from event increment
                               bus. The width of this field is determined by
                               the widest event in the iMPH (which is 5 bits
                               for queue occupancy). The result of the
                               comparison is effectivly a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the Invert bit) no
                               matter how wide the original event was.
                            */
    UINT32 Rsvd29 : 3;

                            /* Bits[31:29], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFEVTSEL1_1_REGISTER;

/**
  Holds global control fields for the NCU PMON counters.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCtrClr] is set to 1b.
**/
#define TGL_MSR_NCUPMONCTRLGLCTR 0x00000707

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 4;

                            /* Bits[3:0], Access Type=RW, default=0x00000000*/

                            /*
                               The Thread-ID format is given as follows: [0:0]
                               T0 or T1. For GT Core this bit must be 0. [3:1]
                               Core ID. When "TID Filter Enable" is clear in
                               the Counter Control register, then the specified
                               counter will count all events. Thread-ID value
                               of 0xE is reserved for non-associated requests
                               like LLC victims and External Snoops.
                            */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONCTRLGLCTR_REGISTER;

/**
  IDP 0 PMON Counter 1  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define TGL_MSR_PERFCTR0_0 0x00000709

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFCTR0_0_REGISTER;

/**
  IDP 0 PMON Counter 2  data register
  The Fix counter is counting UCLK cycles.
  All fields in this reigster must be reset when LT_CONTROL_MSR[LTPmonCntClr] is set to 1b.
**/
#define TGL_MSR_PERFCTR1_1 0x0000070A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               Pmon Counter data. The register may be read and
                               written when the counter is stopped.
                            */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PERFCTR1_1_REGISTER;

/**
  Ubox local PMON mask for NCDEC events
**/
#define TGL_MSR_UBOX_PMON_EVENT_NCDEC_MASK_CTL0 0x0000070B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mask : 25;

                            /* Bits[24:0], Access Type=RWS, default=0x00000000*/

                            /*
                               event mask bit per ring message decode [ 0]
                               PMON_NCDEC_MASK_NCB_Int_CBO_IIO [ 1]
                               PMON_NCDEC_MASK_NCB_Int_UBX_QPI [ 2]
                               PMON_NCDEC_MASK_NCB_P2PB_IIO [ 3]
                               PMON_NCDEC_MASK_NCB_P2PB_CBO_UBX_QPI [ 4]
                               PMON_NCDEC_MASK_NCB_VLW_IIO_CBO [ 5]
                               PMON_NCDEC_MASK_NCB_VLW_UBX_QPI [ 6]
                               PMON_NCDEC_MASK_NCB_EOI_CBO [ 7]
                               PMON_NCDEC_MASK_NCB_EOI_UBX_QPI [ 8]
                               PMON_NCDEC_MASK_NCB_EOI_IIO [ 9]
                               PMON_NCDEC_MASK_NCB_STARTREQ234 [10]
                               PMON_NCDEC_MASK_NCB_PMREQ [11]
                               PMON_NCDEC_MASK_NCB_RSVD [12]
                               PMON_NCDEC_MASK_NCS_CfgRd_Wr [13]
                               PMON_NCDEC_MASK_NCS_IORd_Wr [14]
                               PMON_NCDEC_MASK_NCS_LTRd [15]
                               PMON_NCDEC_MASK_NCS_LTWr_IIO_CBO [16]
                               PMON_NCDEC_MASK_NCS_LTWr_UBX_QPI [17]
                               PMON_NCDEC_MASK_NCS_FERR [18]
                               PMON_NCDEC_MASK_NCS_RSVD [19]
                               PMON_NCDEC_MASK_NCS_SHUTDOWN_CBO [20]
                               PMON_NCDEC_MASK_NCS_LOCKS_UNLOCK_CBO_IIO [21]
                               PMON_NCDEC_MASK_NCS_LOCKS_UNLOCK_UBX_QPI [22]
                               PMON_NCDEC_MASK_NCS_STARTREQ1_STOPREQ1234 [23]
                               PMON_NCDEC_MASK_NCS_INVD_WBINVD_CBO_IIO [24]
                               PMON_NCDEC_MASK_NCS_INVD_WBINVD_UBX_QPI
                            */
    UINT32 Rsvd25 : 7;

                            /* Bits[31:25], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_UBOX_PMON_EVENT_NCDEC_MASK_CTL0_REGISTER;

/**
  Ubox local PMON mask for NCDEC events for subunit target
**/
#define TGL_MSR_UBOX_PMON_EVENT_NCDEC_MASK_CTL1 0x0000070C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mask : 12;

                            /* Bits[11:0], Access Type=RWS, default=0x00000000*/

                            /*
                               event mask bit per sub unit target [ 0] GLOB_INT
                               [ 1] PMREQ [ 2] RACU [ 3] NCEVENT [ 4] NCLOCK [
                               5] GLOB_LOCK [ 6] MAST_LOCK [ 7] NCS_SPEC [ 8]
                               NCB_SPEC [ 9] GLOB_EOI [10] NCEOI [11] DROP
                            */
    UINT32 AddrMask : 16;

                            /* Bits[27:12], Access Type=RWS, default=0x00000000*/

                            /* Register address mask for addr[15:0] */
    UINT32 Rsvd28 : 4;

                            /* Bits[31:28], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_UBOX_PMON_EVENT_NCDEC_MASK_CTL1_REGISTER;

/**
  Address offset match value for Ubox match/mask. Will compare bits that are not masked
**/
#define TGL_MSR_UBOX_PMON_EVENT_NCDEC_MATCH_ADDR 0x0000070D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 AddrMatch : 16;

                            /* Bits[15:0], Access Type=RWS, default=0x00000000*/

                            /* Address offset to match */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_UBOX_PMON_EVENT_NCDEC_MATCH_ADDR_REGISTER;

/**

**/
#define TGL_MSR_PCUPMONUNITCTRL 0x00000710

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONUNITCTRL_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTRCFG_0 0x00000711

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=WO, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=WO, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=WO, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=WO, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTRCFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTRCFG_1 0x00000712

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=WO, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=WO, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=WO, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=WO, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTRCFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTRCFG_2 0x00000713

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=WO, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=WO, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=WO, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=WO, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTRCFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTRCFG_3 0x00000714

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Filtermask : 7;

                            /* Bits[6:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               Perfmon HAS and the individual unit HAS
                               documents.
                            */
    UINT32 Useoccupancy : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /*
                               When enabled, this will pass the output of the
                               occupancy block through to the counter
                               (dependent on the event occuring). See the HAS
                               for more details.
                            */
    UINT32 Rsvd8 : 6;

                            /* Bits[13:8], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Occselect : 2;

                            /* Bits[15:14], Access Type=WO, default=0x00000000*/

                            /*
                               Select which of the four occupancy counters to
                               use. 00 - Threads in C0 01 - Cores in C0 10 -
                               Cores in C3 11 - Cores in C6
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L0s mode in Intel UPI. By using
                               edge detect, one can count the number of times
                               that we entered L0s mode (by detecting the
                               rising edge). Edge detect only works in
                               conjunction with threshholding. This is true
                               even for events that can only increment by 1 in
                               a given cycle (like the L0s example above). In
                               this case, one should set a threshhold of 1. One
                               can also use Edge Detect with queue occupancy
                               events. For example, if one wanted to count the
                               number of times when the TOR occupancy was
                               larger than 5, one would selet the TOR occupancy
                               event with a threshold of 5 and set the Edge
                               Detect bit. Edge detect can also be used with
                               the invert. This is generally not particularly
                               useful, as the count of falling edges compared
                               to rising edges will always on differ by 1.
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /*
                               ThreadID filter enable. This is only used by
                               Cbo. For other units it is Reserved.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               overflow enabled, tehn a signal will be
                               transmitted to the Ubox
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are events that are only
                               accessible on unlocked parts. One can basically
                               think of the internal bit as an extension of the
                               event select bits [7:0], as it allows the use to
                               gain access to additional events. It will not be
                               possible to use these events on locked parts.
                               For perfmons that exist in MSR space, the MSR
                               write mask is set on this bit, and the ucode
                               handler will trigger a GP fault if one attempts
                               to write to these bits. Writing to these bits is
                               controlled in other ways in the other units.
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal the events selected by the event
                               select, unit mask, and internal if this bit is
                               set to 1 but the Unit Control Registers have
                               determined that counting is disabled, then the
                               counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=WO, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold >=
                               event. When set to 1, the comparison that will
                               be done is inverted from the case where this bit
                               is set to 0, i.e., threshold event. The invert
                               bit only works when Threshhold != 0. So, if one
                               would like to invert a non-occupancy event (like
                               LLC Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=WO, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the UnCore is 7bits (queue
                               occupancy), bit 31 is unused. The result of the
                               comparison is effectively a 1 bit wide event,
                               i.e., the counter will be incremented by 1 when
                               the comparison is true (the type of comparison
                               depends on the setting of the 'invert' bit - see
                               bit 23 below) no matter how wide the original
                               event was. When this field is zero, threshold
                               comparison is disabled and the event is passed
                               without modification.
                            */
    UINT32 Occinvert : 1;

                            /* Bits[30:30], Access Type=WO, default=0x00000000*/

                            /*
                               Invert the output of the occupancy threshhold
                               comparison logic. 0 - "greater than or equal to"
                               comparison on the threshhold compare 1 - "less
                               than" comparison on the threshhold compare
                            */
    UINT32 Occedgedetect : 1;

                            /* Bits[31:31], Access Type=WO, default=0x00000000*/

                            /*
                               Enable edge detection on the output of the
                               occupancy threshhold comparison. When enabled
                               and used with the Threshhold logic, this will
                               provide the ability to track the number of times
                               when an occupancy counter exceed or was equal to
                               the value in the threshhold. When used with
                               OccInvert, this will track the number of times
                               when the value dropped below the threshhold.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTRCFG_3_REGISTER;
/**

**/
#define TGL_MSR_PCUPMONFILTER 0x00000715

/**

**/
#define TGL_MSR_PCUPMONUNITSTATUS 0x00000716

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counteroverflowbitmask : 7;

                            /* Bits[6:0], Access Type=WO, default=0x00000000*/

                            /*
                               This bitmask that specifies which counter(or
                               counters have overflowed. If the unit has a
                               fixed counter, it's corresponding bitmask will
                               be stored at position 0.
                            */
    UINT32 Rsvd7 : 25;

                            /* Bits[31:7], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONUNITSTATUS_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTR_0 0x00000717

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTR_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTR_1 0x00000718

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTR_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTR_2 0x00000719

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTR_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_PCUPMONCNTR_3 0x0000071A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PCUPMONCNTR_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0 0x00000738

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1 0x00000739

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked part. The UnCore
                               PerfMon hardware does not handle the security of
                               the internal events.
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0 0x0000073A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1 0x0000073B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 12;

                            /* Bits[43:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd44 : 20;

                            /* Bits[63:44], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_REGISTER;

/**
  Power Management Control Hints to a Logical Processor
**/
#define TGL_MSR_IA32_HWP_REQUEST 0x00000774

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MinimumPerformance : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000001*/

                            /*
                               Conveys a hint to the HWP hardware. The OS
                               programs the minimum performance hint to achieve
                               the required quality of service (QOS) or to meet
                               a service level agreement (SLA) as needed. Note
                               that an excursion below the level specified is
                               possible due to hardware constraints. The
                               default value of this field is
                               IA32_HWP_CAPABILITIES.Lowest_Performance.
                            */
    UINT32 MaximumPerformance : 8;

                            /* Bits[15:8], Access Type=RW, default=0x000000FF*/

                            /*
                               Conveys a hint to the HWP hardware. The OS
                               programs this field to limit the maximum
                               performance that is expected to be supplied by
                               the HWP hardware. Excursions above the limit
                               requested by OS are possible due to hardware
                               coordination between the processor cores and
                               other components in the package. The default
                               value of this field is
                               IA32_HWP_CAPABILITIES.Highest_Performance.
                            */
    UINT32 DesiredPerformance : 8;

                            /* Bits[23:16], Access Type=RW, default=0x00000000*/

                            /*
                               Conveys a hint to the HWP hardware. When set to
                               zero, hardware autonomous selection determines
                               the performance target. When set to a non-zero
                               value (between the range of Lowest_Performance
                               and Highest_Performance of
                               IA32_HWP_CAPABILITIES) conveys an explicit
                               performance request hint to the hardware;
                               effectively disabling HW Autonomous selection.
                               The Desired_Performance input is non-
                               constraining in terms of Performance and Energy
                               Efficiency optimizations, which are
                               independently controlled. The default value of
                               this field is 0.
                            */
    UINT32 EnergyPerformancePreference : 8;

                            /* Bits[31:24], Access Type=RW, default=0x00000080*/

                            /*
                               Conveys a hint to the HWP hardware. The OS may
                               write a range of values from 0 (performance
                               preference) to 0FFH (energy efficiency
                               preference) to influence the rate of performance
                               increase /decrease and the result of the
                               hardware's energy efficiency and performance
                               optimizations. The default value of this field
                               is 80H. Note: If CPUID.06H:EAX[bit 10] indicates
                               that this field is not supported, HWP uses the
                               value of the IA32_ENERGY_PERF_BIAS MSR to
                               determine the energy efficiency / performance
                               preference.
                            */
    UINT32 ActivityWindow : 10;

                            /* Bits[41:32], Access Type=RW, default=0x00000000*/

                            /*
                               Conveys a hint to the HWP hardware specifying a
                               moving workload history observation window for
                               performance/frequency optimizations. If 0, the
                               hardware will determine the appropriate window
                               size. When writing a non-zero value to this
                               field, this field is encoded in the format of
                               bits 38:32 as a 7-bit mantissa and bits 41:39 as
                               a 3-bit exponent value in powers of 10. The
                               resultant value is in microseconds. Thus, the
                               minimal/maximum activity window size is 1
                               microsecond/1270 seconds. Combined with the
                               Energy_Performance_Preference input,
                               Activity_Window influences the rate of
                               performance increase / decrease. This non-zero
                               hint only has meaning when Desired_Performance =
                               0. The default value of this field is 0
                            */
    UINT32 PackageControl : 1;

                            /* Bits[42:42], Access Type=RW, default=0x00000000*/

                            /*
                               When set causes thread IA32_HWP_REQUEST control
                               inputs to be derived from IA32_HWP_REQUEST_PKG
                            */
    UINT32 Rsvd43 : 16;

                            /* Bits[58:43], Access Type=RO, default=0x00000000*/

                            /* Reserved Bits */
    UINT32 ActivityWindowsValid : 1;

                            /* Bits[59:59], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes active windows value from this MSR
                            */
    UINT32 EppValid : 1;

                            /* Bits[60:60], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes EPP value from the the this MSR
                            */
    UINT32 DesiredValid : 1;

                            /* Bits[61:61], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Desired Performance value from the
                               the this MSR
                            */
    UINT32 MaximumValid : 1;

                            /* Bits[62:62], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Maximum Performance value from the
                               the this MSR
                            */
    UINT32 MinimumValid : 1;

                            /* Bits[63:63], Access Type=RW, default=0x00000000*/

                            /*
                               When set 1 means that if the package control bit
                               is set, takes Minimum Performance value from the
                               the this MSR
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IA32_HWP_REQUEST_REGISTER;
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 2 instances in addresses range 0x791 to 0x792"
**/
#define TGL_MSR_UNCORE_SPARE_0_0 0x00000791
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 2 instances in addresses range 0x791 to 0x792"
**/
#define TGL_MSR_UNCORE_SPARE_1_1 0x00000792
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_2_2 0x00000794
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_3_3 0x00000795
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_4_4 0x00000796
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_5_5 0x00000797
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_6_6 0x00000798
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_7_7 0x00000799
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_8_8 0x0000079A
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_9_9 0x0000079B
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_10_10 0x0000079C
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_11_11 0x0000079D
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_12_12 0x0000079E
/**
  Spare Virtual MSRs in uncore Creg PLA
  " seq has 12 instances in addresses range 0x794 to 0x79F"
**/
#define TGL_MSR_UNCORE_SPARE_13_13 0x0000079F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 2 instances in addresses range 0x800 to 0x801"
**/
#define TGL_MSR_VIRTUAL_APIC_0_0 0x00000800
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 2 instances in addresses range 0x800 to 0x801"
**/
#define TGL_MSR_VIRTUAL_APIC_1_1 0x00000801
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x804 to 0x807"
**/
#define TGL_MSR_VIRTUAL_APIC_2_2 0x00000804
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x804 to 0x807"
**/
#define TGL_MSR_VIRTUAL_APIC_3_3 0x00000805
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x804 to 0x807"
**/
#define TGL_MSR_VIRTUAL_APIC_4_4 0x00000806
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x804 to 0x807"
**/
#define TGL_MSR_VIRTUAL_APIC_5_5 0x00000807
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 1 instances in addresses range 0x809 to 0x809"
**/
#define TGL_MSR_VIRTUAL_APIC_6_6 0x00000809
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 1 instances in addresses range 0x80C to 0x80C"
**/
#define TGL_MSR_VIRTUAL_APIC_7_7 0x0000080C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 1 instances in addresses range 0x80E to 0x80E"
**/
#define TGL_MSR_VIRTUAL_APIC_8_8 0x0000080E
/**
  APIC In-Service register bits
  " seq has 1 instances in addresses range 0x810 to 0x810"
**/
#define TGL_MSR_PIC_ISR_DWORD_0_0 0x00000810
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_1_1 0x00000811
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_2_2 0x00000812
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_3_3 0x00000813
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_4_4 0x00000814
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_5_5 0x00000815
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_6_6 0x00000816
/**
  APIC In-Service register bits
  " seq has 7 instances in addresses range 0x811 to 0x817"
**/
#define TGL_MSR_PIC_ISR_DWORD_7_7 0x00000817
/**
  APIC Trigger Mode register bits
  " seq has 1 instances in addresses range 0x818 to 0x818"
**/
#define TGL_MSR_PIC_TMR_DWORD_0_0 0x00000818
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_1_1 0x00000819
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_2_2 0x0000081A
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_3_3 0x0000081B
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_4_4 0x0000081C
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_5_5 0x0000081D
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_6_6 0x0000081E
/**
  APIC Trigger Mode register bits
  " seq has 7 instances in addresses range 0x819 to 0x81F"
**/
#define TGL_MSR_PIC_TMR_DWORD_7_7 0x0000081F
/**
  APIC Interrupt Request register bits
  " seq has 1 instances in addresses range 0x820 to 0x820"
**/
#define TGL_MSR_PIC_IRR_DWORD_0_0 0x00000820
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_1_1 0x00000821
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_2_2 0x00000822
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_3_3 0x00000823
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_4_4 0x00000824
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_5_5 0x00000825
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_6_6 0x00000826
/**
  APIC Interrupt Request register bits
  " seq has 7 instances in addresses range 0x821 to 0x827"
**/
#define TGL_MSR_PIC_IRR_DWORD_7_7 0x00000827
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_9_9 0x00000829
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_10_10 0x0000082A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_11_11 0x0000082B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_12_12 0x0000082C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_13_13 0x0000082D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 6 instances in addresses range 0x829 to 0x82E"
**/
#define TGL_MSR_VIRTUAL_APIC_14_14 0x0000082E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 1 instances in addresses range 0x831 to 0x831"
**/
#define TGL_MSR_VIRTUAL_APIC_15_15 0x00000831
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x83A to 0x83D"
**/
#define TGL_MSR_VIRTUAL_APIC_16_16 0x0000083A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x83A to 0x83D"
**/
#define TGL_MSR_VIRTUAL_APIC_17_17 0x0000083B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x83A to 0x83D"
**/
#define TGL_MSR_VIRTUAL_APIC_18_18 0x0000083C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 4 instances in addresses range 0x83A to 0x83D"
**/
#define TGL_MSR_VIRTUAL_APIC_19_19 0x0000083D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_20_20 0x00000840
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_21_21 0x00000841
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_22_22 0x00000842
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_23_23 0x00000843
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_24_24 0x00000844
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_25_25 0x00000845
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_26_26 0x00000846
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_27_27 0x00000847
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_28_28 0x00000848
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_29_29 0x00000849
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_30_30 0x0000084A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_31_31 0x0000084B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_32_32 0x0000084C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_33_33 0x0000084D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_34_34 0x0000084E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_35_35 0x0000084F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_36_36 0x00000850
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_37_37 0x00000851
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_38_38 0x00000852
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_39_39 0x00000853
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_40_40 0x00000854
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_41_41 0x00000855
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_42_42 0x00000856
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_43_43 0x00000857
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_44_44 0x00000858
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_45_45 0x00000859
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_46_46 0x0000085A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_47_47 0x0000085B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_48_48 0x0000085C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_49_49 0x0000085D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_50_50 0x0000085E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_51_51 0x0000085F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_52_52 0x00000860
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_53_53 0x00000861
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_54_54 0x00000862
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_55_55 0x00000863
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_56_56 0x00000864
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_57_57 0x00000865
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_58_58 0x00000866
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_59_59 0x00000867
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_60_60 0x00000868
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_61_61 0x00000869
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_62_62 0x0000086A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_63_63 0x0000086B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_64_64 0x0000086C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_65_65 0x0000086D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_66_66 0x0000086E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_67_67 0x0000086F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_68_68 0x00000870
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_69_69 0x00000871
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_70_70 0x00000872
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_71_71 0x00000873
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_72_72 0x00000874
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_73_73 0x00000875
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_74_74 0x00000876
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_75_75 0x00000877
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_76_76 0x00000878
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_77_77 0x00000879
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_78_78 0x0000087A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_79_79 0x0000087B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_80_80 0x0000087C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_81_81 0x0000087D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_82_82 0x0000087E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_83_83 0x0000087F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_84_84 0x00000880
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_85_85 0x00000881
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_86_86 0x00000882
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_87_87 0x00000883
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_88_88 0x00000884
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_89_89 0x00000885
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_90_90 0x00000886
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_91_91 0x00000887
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_92_92 0x00000888
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_93_93 0x00000889
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_94_94 0x0000088A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_95_95 0x0000088B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_96_96 0x0000088C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_97_97 0x0000088D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_98_98 0x0000088E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_99_99 0x0000088F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_100_100 0x00000890
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_101_101 0x00000891
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_102_102 0x00000892
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_103_103 0x00000893
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_104_104 0x00000894
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_105_105 0x00000895
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_106_106 0x00000896
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_107_107 0x00000897
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_108_108 0x00000898
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_109_109 0x00000899
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_110_110 0x0000089A
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_111_111 0x0000089B
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_112_112 0x0000089C
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_113_113 0x0000089D
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_114_114 0x0000089E
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_115_115 0x0000089F
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_116_116 0x000008A0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_117_117 0x000008A1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_118_118 0x000008A2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_119_119 0x000008A3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_120_120 0x000008A4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_121_121 0x000008A5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_122_122 0x000008A6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_123_123 0x000008A7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_124_124 0x000008A8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_125_125 0x000008A9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_126_126 0x000008AA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_127_127 0x000008AB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_128_128 0x000008AC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_129_129 0x000008AD
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_130_130 0x000008AE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_131_131 0x000008AF
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_132_132 0x000008B0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_133_133 0x000008B1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_134_134 0x000008B2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_135_135 0x000008B3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_136_136 0x000008B4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_137_137 0x000008B5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_138_138 0x000008B6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_139_139 0x000008B7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_140_140 0x000008B8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_141_141 0x000008B9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_142_142 0x000008BA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_143_143 0x000008BB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_144_144 0x000008BC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_145_145 0x000008BD
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_146_146 0x000008BE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_147_147 0x000008BF
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_148_148 0x000008C0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_149_149 0x000008C1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_150_150 0x000008C2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_151_151 0x000008C3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_152_152 0x000008C4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_153_153 0x000008C5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_154_154 0x000008C6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_155_155 0x000008C7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_156_156 0x000008C8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_157_157 0x000008C9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_158_158 0x000008CA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_159_159 0x000008CB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_160_160 0x000008CC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_161_161 0x000008CD
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_162_162 0x000008CE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_163_163 0x000008CF
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_164_164 0x000008D0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_165_165 0x000008D1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_166_166 0x000008D2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_167_167 0x000008D3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_168_168 0x000008D4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_169_169 0x000008D5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_170_170 0x000008D6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_171_171 0x000008D7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_172_172 0x000008D8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_173_173 0x000008D9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_174_174 0x000008DA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_175_175 0x000008DB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_176_176 0x000008DC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_177_177 0x000008DD
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_178_178 0x000008DE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_179_179 0x000008DF
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_180_180 0x000008E0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_181_181 0x000008E1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_182_182 0x000008E2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_183_183 0x000008E3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_184_184 0x000008E4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_185_185 0x000008E5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_186_186 0x000008E6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_187_187 0x000008E7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_188_188 0x000008E8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_189_189 0x000008E9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_190_190 0x000008EA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_191_191 0x000008EB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_192_192 0x000008EC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_193_193 0x000008ED
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_194_194 0x000008EE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_195_195 0x000008EF
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_196_196 0x000008F0
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_197_197 0x000008F1
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_198_198 0x000008F2
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_199_199 0x000008F3
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_200_200 0x000008F4
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_201_201 0x000008F5
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_202_202 0x000008F6
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_203_203 0x000008F7
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_204_204 0x000008F8
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_205_205 0x000008F9
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_206_206 0x000008FA
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_207_207 0x000008FB
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_208_208 0x000008FC
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_209_209 0x000008FD
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_210_210 0x000008FE
/**
  Virtual APIC MSRs that are modeled by ucode
  " seq has 192 instances in addresses range 0x840 to 0x8FF"
**/
#define TGL_MSR_VIRTUAL_APIC_211_211 0x000008FF

/**
  Equivalent to architectural DR6 reg. 16 bit.
  (Mrm roctlregc/roctlregd/{tmpdr6lowSM306L|tmpdr6hiSM306L})
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
  !!!                                                                            !!!
  !!! CAUTION: Adding more bits to this creg or changing the layout of this creg !!!
  !!! will require MSR ucode changes. Talk to MSR ucode owner (rpartha on NHM) if!!!
  !!! you want to make changes to this creg                                      !!!
  !!!                                                                            !!!
  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
**/
#define TGL_MSR_TMPDR6 0x00000902

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 B0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B0 */
    UINT32 B1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B1 */
    UINT32 B2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B2 */
    UINT32 B3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6B3 */
    UINT32 Rsvd4 : 9;

                            /* Bits[12:4], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Bd : 1;

                            /* Bits[13:13], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BD */
    UINT32 Bs : 1;

                            /* Bits[14:14], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6BS */
    UINT32 Bt : 1;

                            /* Bits[15:15], Access Type=RW, default=0x00000000*/

                            /* ROBTMPDR6BT */
    UINT32 Hled : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /* ROBTMPDR6HLED */
    UINT32 EnclaveInterruption : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enclave interruption indication. Cleared by HW
                               on retired EOM
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_TMPDR6_REGISTER;

/**
  Holds address bits [11:0] of a guest load/store access that hit the AVRR range
  C6NoSave Candidate
  FSCP Crunch:  12:32 Used only 12 bits out of 32
**/
#define TGL_MSR_VMX_VMENTRY_AVRR_TBIT_MAILBOX 0x00000907

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 MailboxOffset : 12;

                            /* Bits[11:0], Access Type=RW, default=None*/

                            /*
                               Mailbox address bits [11:0] of a guest
                               load/store access that hit the AVRR range
                            */
    UINT32 Reserved12 : 20;

                            /* Bits[31:12], Access Type=RW, default=None*/

                            /* Unused */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_VMX_VMENTRY_AVRR_TBIT_MAILBOX_REGISTER;

/**
  Holds XSAVE_AREA XCompaction vector for the XMODIFIED optimization.
**/
#define TGL_MSR_XRSTOR_XCOMPACTION_VECTOR 0x00000911

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 XcompactionVector : 10;

                            /* Bits[9:0], Access Type=RW, default=None*/

                            /*
                               Bit 0 => FP Bit 1 => SSE Bit 2 => GSSE Bit 3 =>
                               PL BNDREGS Bit 4 => PL BNDCFS Bit 5 => KMASK Bit
                               6 => AVX3(15:0) Bit 7 => AVX3(31:16) Bit 8 =>
                               RTIT (reserved - actual bit in IA_XSS) Bit 9 =>
                               PKRU
                            */
    UINT32 Rsvd10 : 5;

                            /* Bits[14:10], Access Type=RW, default=None*/

                            /* Available for use */
    UINT32 XcompInUse : 1;

                            /* Bits[15:15], Access Type=RW, default=None*/

                            /*
                               Save area for XRSTOR_INFO used XCOMPACTION, or
                               VECTOR in this MSR is valid.
                            */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RW, default=None*/

                            /* Available for use */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Available for use */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_XRSTOR_XCOMPACTION_VECTOR_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x917 to 0x91A"
**/
#define TGL_MSR_XU_RESERVED_1_1 0x00000917
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x917 to 0x91A"
**/
#define TGL_MSR_XU_RESERVED_2_2 0x00000918
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x917 to 0x91A"
**/
#define TGL_MSR_XU_RESERVED_3_3 0x00000919
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x917 to 0x91A"
**/
#define TGL_MSR_XU_RESERVED_4_4 0x0000091A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x91C to 0x91F"
**/
#define TGL_MSR_XU_RESERVED_5_5 0x0000091C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x91C to 0x91F"
**/
#define TGL_MSR_XU_RESERVED_6_6 0x0000091D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x91C to 0x91F"
**/
#define TGL_MSR_XU_RESERVED_7_7 0x0000091E
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 4 instances in addresses range 0x91C to 0x91F"
**/
#define TGL_MSR_XU_RESERVED_8_8 0x0000091F

/**
  The who-am-I register is used by uCode to set up the APIC ID.
  This register is initialized by the PCU according to the socket configuration using the NcuPcuWHOAMI register.
  The who-am-i register returns a thread specific identifier, however some of the fields of this registers are shared between all threads as indicated by the fields description.
**/
#define TGL_MSR_NCUWHOAMI 0x00000920

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Lpid : 3;

                            /* Bits[2:0], Access Type=RO_V, default=0x00000000*/

                            /*
                               3-bit field. UBOX generates contiguous LPIDs for
                               logical procsesors within an IDI agent. CPUs
                               with fewer than 8 logical processors per IDI (eg
                               ICL, ICX) see holes in the WHOAMI space. Ucode
                               handles this as required (plug holes or live
                               with it)
                            */
    UINT32 Moduleid : 13;

                            /* Bits[15:3], Access Type=RO_V, default=0x00000000*/

                            /* Returns the Module Identification number. */
    UINT32 Packageid : 11;

                            /* Bits[26:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               Maps to the socketId straps; Can be programmed
                               (MSR)
                            */
    UINT32 Rsvd27 : 1;

                            /* Bits[27:27], Access Type=RO_V, default=0x00000000*/

                            /* Reserved */
    UINT32 Corenum : 3;

                            /* Bits[30:28], Access Type=RO, default=0x00000000*/

                            /*
                               Indicates how many common APIC ID bits there are
                               in the socket: 000: upto 8 cores 001: upto 16
                               cores 010: upto 32 cores 011: upto 64 cores 100:
                               upto 128 cores 101: upto 256 cores 110: upto 512
                               cores 111: upto 1024 cores This field is used by
                               uCode for correctly handling the number of
                               variable bits in PID field.
                            */
    UINT32 Bsp : 1;

                            /* Bits[31:31], Access Type=RO_V, default=0x00000000*/

                            /*
                               Indicates to the core uCode that this thread
                               should be made the BSP of the socket, .
                               Selection among multi-socket BSP is done by BIOS
                               SW. 0 : this thread should not be set as BSP 1 :
                               this thread should be set as BSP
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUWHOAMI_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_STATUS (lower 32b) and ROB1_CR_PIC_EVENT_STATUS (upper 32b)
**/
#define TGL_MSR_PPPE_EVENT_STATUS 0x00000925

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=RO_V, default=0x00000000*/

                            /* Event Status GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=RO_V, default=0x00000000*/

                            /* Event Status RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=RO_V, default=0x00000000*/

                            /* Event Status VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to MCE_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=RO_V, default=0x00000000*/

                            /*
                               When Set indicates SMI is pended due to CMCI_CTL
                               setting in core or uncore MCi_Ctl2 register
                            */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=RO_V, default=0x00000000*/

                            /* Event Status : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for Core Retirement Detector
                               (CRD) event
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for ROP event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for RTIT flush event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=RO_V, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=RO_V, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PPPE_EVENT_STATUS_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_SET (lower 32b) and ROB1_CR_PIC_EVENT_SET (upper 32b)
**/
#define TGL_MSR_PPPE_EVENT_SET 0x00000926

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Event Set : INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* used to be A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Set : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Set : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Set : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Set : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /* Event Set : MONITOR */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Set : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Set : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Set : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Set : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Set : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Set : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Set : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Set : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Set GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Set GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event Set RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event Set VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event set MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /* Event set CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /* Event set : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for Machine Check event. set when
                               Parity Error is detected.
                            */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT mem event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /* Set Core Retirement Detector (CRD) pending state */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for FERR_OVERFLOW event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Pending status for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Pending status for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Pending status for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Pending status for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PPPE_EVENT_SET_REGISTER;

/**
  Maps to ML3_CR_PIC_EVENT_RESET (lower 32b) and ROB1_CR_PIC_EVENT_RESET (upper 32b)
**/
#define TGL_MSR_PPPE_EVENT_RESET 0x00000927

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Intr : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* Reset Event INTR */
    UINT32 Rsvd1 : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* Event Reset : A20M */
    UINT32 Init : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* Event Reset : INIT */
    UINT32 Nmi : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* Event Reset : NMI */
    UINT32 Smi : 1;

                            /* Bits[4:4], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SMI */
    UINT32 Psmi : 1;

                            /* Bits[5:5], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PSMI */
    UINT32 Monitor : 1;

                            /* Bits[6:6], Access Type=WO, default=0x00000000*/

                            /*
                               Event Reset : MONITOR: Doesn't write
                               ML3_CR_PIC_EVENT_RESET_MONITOR but clears the
                               MONITOR FSM with a spcl cycle
                            */
    UINT32 Sipi : 1;

                            /* Bits[7:7], Access Type=WO, default=0x00000000*/

                            /* Event Reset : SIPI */
    UINT32 LtDoorbell : 1;

                            /* Bits[8:8], Access Type=WO, default=0x00000000*/

                            /* Event Reset : LT_DOORBELL */
    UINT32 VmxTimer : 1;

                            /* Bits[9:9], Access Type=WO, default=0x00000000*/

                            /* Event Reset : VMX_TIMER */
    UINT32 Preq : 1;

                            /* Bits[10:10], Access Type=WO, default=0x00000000*/

                            /* Event Reset : PREQ */
    UINT32 Mcakind : 1;

                            /* Bits[11:11], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MCAKIND */
    UINT32 CpdEnter : 1;

                            /* Bits[12:12], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_ENTER */
    UINT32 CpdExit : 1;

                            /* Bits[13:13], Access Type=WO, default=0x00000000*/

                            /* Event Reset : CPD_EXIT */
    UINT32 UncoreTrap : 1;

                            /* Bits[14:14], Access Type=WO, default=0x00000000*/

                            /* Event Reset : UNCORE_TRAP */
    UINT32 AsyncMca : 1;

                            /* Bits[15:15], Access Type=WO, default=0x00000000*/

                            /* Event Reset : ASYNC_MCA */
    UINT32 GoCore : 1;

                            /* Bits[16:16], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO CORE */
    UINT32 GoThread : 1;

                            /* Bits[17:17], Access Type=WO, default=0x00000000*/

                            /* Event Reset GO THREAD */
    UINT32 Rar : 1;

                            /* Bits[18:18], Access Type=WO, default=0x00000000*/

                            /* Event Reset RAR */
    UINT32 Vrar : 1;

                            /* Bits[19:19], Access Type=WO, default=0x00000000*/

                            /* Event Reset VRAR */
    UINT32 MceSmi : 1;

                            /* Bits[20:20], Access Type=WO, default=0x00000000*/

                            /* Event Reset MCE_SMI */
    UINT32 CmciSmi : 1;

                            /* Bits[21:21], Access Type=WO, default=0x00000000*/

                            /* Event Reset CMCI_SMI */
    UINT32 MwaitTimerMonitor : 1;

                            /* Bits[22:22], Access Type=WO, default=0x00000000*/

                            /* Event Reset : MWAIT_TIMER_MONITOR */
    UINT32 Rsvd23 : 9;

                            /* Bits[31:23], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 1;

                            /* Bits[32:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 RestartMicro : 1;

                            /* Bits[33:33], Access Type=WO, default=0x00000000*/

                            /* Pending state for Restart micro */
    UINT32 Rsvd34 : 2;

                            /* Bits[35:34], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 CorrectableMc : 1;

                            /* Bits[36:36], Access Type=WO, default=0x00000000*/

                            /* Clear state correctable mc */
    UINT32 RtitMem : 1;

                            /* Bits[37:37], Access Type=WO, default=0x00000000*/

                            /* Pending status for RTIT memory event */
    UINT32 Monitortrap : 1;

                            /* Bits[38:38], Access Type=WO, default=0x00000000*/

                            /* Pending state for Monitor trap */
    UINT32 Btm : 1;

                            /* Bits[39:39], Access Type=WO, default=0x00000000*/

                            /* Pending state for Branch trace message */
    UINT32 Smc : 1;

                            /* Bits[40:40], Access Type=WO, default=0x00000000*/

                            /* Pending state for SMC */
    UINT32 Virtualnuke : 1;

                            /* Bits[41:41], Access Type=WO, default=0x00000000*/

                            /* Pending state for Virtual Nuke */
    UINT32 PeMicrotrap : 1;

                            /* Bits[42:42], Access Type=WO, default=0x00000000*/

                            /* Pending status for PE microtrap */
    UINT32 UcodeMacrotrap : 1;

                            /* Bits[43:43], Access Type=WO, default=0x00000000*/

                            /* Pending state for Ucode macrotrap */
    UINT32 Crd : 1;

                            /* Bits[44:44], Access Type=WO, default=0x00000000*/

                            /*
                               Clear Core Retirement Detector (CRD) pending
                               state
                            */
    UINT32 Rop : 1;

                            /* Bits[45:45], Access Type=WO, default=0x00000000*/

                            /* Pending state for ROP event */
    UINT32 UcodeThreadTrap : 1;

                            /* Bits[46:46], Access Type=WO, default=0x00000000*/

                            /* Clear state for UCODE_THREAD_TRAP event */
    UINT32 RtitFlush : 1;

                            /* Bits[47:47], Access Type=WO, default=0x00000000*/

                            /* Clear state for RTIT event */
    UINT32 Nmip : 1;

                            /* Bits[48:48], Access Type=WO, default=0x00000000*/

                            /* Clear state for NMIP */
    UINT32 TxAbortMisspec : 1;

                            /* Bits[49:49], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to MEU
                               Misspeculation
                            */
    UINT32 TxAbortWatchdog : 1;

                            /* Bits[50:50], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX_ABORT due to Watchdog Time
                               out
                            */
    UINT32 TxCatastrophicAbort : 1;

                            /* Bits[51:51], Access Type=WO, default=0x00000000*/

                            /*
                               Clear state for TX catatrophic abort which is
                               taken as soon as it's posted
                            */
    UINT32 Pebs : 12;

                            /* Bits[63:52], Access Type=WO, default=0x00000000*/

                            /* Clear state for PEBS event per counter */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PPPE_EVENT_RESET_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_9_9 0x00000928
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_10_10 0x00000929
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_11_11 0x0000092A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_12_12 0x0000092B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_13_13 0x0000092C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_14_14 0x0000092D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 7 instances in addresses range 0x928 to 0x92E"
**/
#define TGL_MSR_XU_RESERVED_15_15 0x0000092E
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 3 instances in addresses range 0x930 to 0x932"
**/
#define TGL_MSR_XU_RESERVED_16_16 0x00000930
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 3 instances in addresses range 0x930 to 0x932"
**/
#define TGL_MSR_XU_RESERVED_17_17 0x00000931
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 3 instances in addresses range 0x930 to 0x932"
**/
#define TGL_MSR_XU_RESERVED_18_18 0x00000932
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 1 instances in addresses range 0x93B to 0x93B"
**/
#define TGL_MSR_XU_RESERVED_19_19 0x0000093B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 1 instances in addresses range 0x93F to 0x93F"
**/
#define TGL_MSR_XU_RESERVED_20_20 0x0000093F

/**
  Mode C - Protected Mode PagDir Pointers - 0
  " seq has 4 instances in addresses range 0x940 to 0x943"
**/
#define TGL_MSR_PDPTR_0_0 0x00000940

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PDPTR_0_0_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
  " seq has 4 instances in addresses range 0x940 to 0x943"
**/
#define TGL_MSR_PDPTR_1_1 0x00000941

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PDPTR_1_1_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
  " seq has 4 instances in addresses range 0x940 to 0x943"
**/
#define TGL_MSR_PDPTR_2_2 0x00000942

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PDPTR_2_2_REGISTER;

/**
  Mode C - Protected Mode PagDir Pointers - 0
  " seq has 4 instances in addresses range 0x940 to 0x943"
**/
#define TGL_MSR_PDPTR_3_3 0x00000943

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 P : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Page Directory Pointer Entry 0 - P bit */
    UINT32 Rsvd1 : 2;

                            /* Bits[2:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pwt : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache write through */
    UINT32 Pcd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /* CR3 page level cache disable */
    UINT32 Rsvd5 : 7;

                            /* Bits[11:5], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pdba0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Pdba1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /* Page Directory Base Address */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_PDPTR_3_3_REGISTER;
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_21_21 0x00000944
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_22_22 0x00000945
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_23_23 0x00000946
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_24_24 0x00000947
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_25_25 0x00000948
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_26_26 0x00000949
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_27_27 0x0000094A
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_28_28 0x0000094B
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_29_29 0x0000094C
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 10 instances in addresses range 0x944 to 0x94D"
**/
#define TGL_MSR_XU_RESERVED_30_30 0x0000094D
/**
  This define is used to reserve some MSR addresses for XuCode. Ucode would have a dedicated handler for these MSRs
  " seq has 1 instances in addresses range 0x967 to 0x967"
**/
#define TGL_MSR_XU_RESERVED_31_31 0x00000967

/**
  Holds XCR0 and XSAVE Compaction Vector (used for XMODIFIED optimization check)
**/
#define TGL_MSR_XCR0 0x0000096D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 X87 : 1;

                            /* Bits[0:0], Access Type=RW, default=None*/

                            /* Bit 0 => FP */
    UINT32 Sse : 1;

                            /* Bits[1:1], Access Type=RW, default=None*/

                            /* Bit 1 => SSE */
    UINT32 Gsse : 1;

                            /* Bits[2:2], Access Type=RW, default=None*/

                            /* Bit 2 => GSSE */
    UINT32 PlBndregs : 1;

                            /* Bits[3:3], Access Type=RW, default=None*/

                            /* Bit 3 => PL BNDREGS */
    UINT32 PlBndcfs : 1;

                            /* Bits[4:4], Access Type=RW, default=None*/

                            /* Bit 4 => PL BNDCFS */
    UINT32 Kmask : 1;

                            /* Bits[5:5], Access Type=RW, default=None*/

                            /* Bit 5 => KMASK */
    UINT32 Avx3150 : 1;

                            /* Bits[6:6], Access Type=RW, default=None*/

                            /* Bit 6 => AVX3(15:0) */
    UINT32 Avx33116 : 1;

                            /* Bits[7:7], Access Type=RW, default=None*/

                            /* Bit 7 => AVX3(31:16) */
    UINT32 RsvdIaXssRtit8 : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /*
                               Bit 8 is reserved because of use as RTIT bit in
                               IA_XSS.
                            */
    UINT32 Pkru : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* Bit 9 => Page Protection Keys User. */
    UINT32 Rsvd10 : 22;

                            /* Bits[31:10], Access Type=RW, default=None*/

                            /* Unused bits. */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RW, default=None*/

                            /* Unused bits. */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_XCR0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_M2PPMONCNTRCFG_0 0x00000B16

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_M2PPMONCNTRCFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_M2PPMONCNTRCFG_1 0x00000B17

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_M2PPMONCNTRCFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_M2PPMONCNTRCFG_2 0x00000B18

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_M2PPMONCNTRCFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_M2PPMONCNTRCFG_3 0x00000B19

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_M2PPMONCNTRCFG_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IRPPMONCNTRCFG_0 0x00000B1D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IRPPMONCNTRCFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IRPPMONCNTRCFG_1 0x00000B1E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Queueoccupancyreset : 1;

                            /* Bits[16:16], Access Type=RW_V, default=0x00000000*/

                            /*
                               This write only bit causes the queue occupancy
                               Perf counter for which the event select register
                               is associated to be clearedto all 0 when a 1 is
                               written to it. No action is taken when 0 is
                               written. Note since the queue occupancy counters
                               will never drop to 0 , it is possible for the
                               counters to catch up with the real occupancy of
                               the queuein question when the real occupancy
                               drops to 0
                            */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event.
                               Internal events are only accessible on unlocked
                               parts. One can think of an internal bit as an
                               extension of the event select bits 7:0, as it
                               allows theuse to gain access to additional
                               events. For perfmons that exist in teh MSR space
                               , the MSR write mask is set on this bit and teh
                               ucode handler will trigger a GP fault if one
                               attempts to write to these bits. Writing to
                               these bits is controlled in otehr ways in the
                               other units
                            */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 Threshold : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IRPPMONCNTRCFG_1_REGISTER;

/**

**/
#define TGL_MSR_IIOPMONUNITCTRL 0x00000B20

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 7;

                            /* Bits[15:9], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezeenable : 1;

                            /* Bits[16:16], Access Type=RW, default=0x00000001*/

                            /*
                               This bit controls what the counters in the unit
                               will do when they receive a freeze signal. When
                               set, the counters will be allowed to freeze.
                               When not set, the counters will ignore the
                               freeze signal. For freeze to be enabled for a
                               given unit, all of the unit control registers
                               must have this bit set.
                            */
    UINT32 Overflowenable : 1;

                            /* Bits[17:17], Access Type=RW, default=0x00000001*/

                            /*
                               This bit controls the behavior of counters when
                               they overflow. When set, the system will trigger
                               the overflow handling process throughout the
                               rest of the uncore, potentially triggering a PMI
                               and freezing counters. When it is not set, the
                               counters will simply wrap around and continue to
                               count. For overflow to be enabled for a given
                               unit, all of the unit control registers must
                               have this bit set.
                            */
    UINT32 Rsvd18 : 14;

                            /* Bits[31:18], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONUNITCTRL_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define TGL_MSR_IIOPMONCNTR_0 0x00000B21

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONCNTR_0_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define TGL_MSR_IIOPMONCNTR_1 0x00000B22

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONCNTR_1_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define TGL_MSR_IIOPMONCNTR_2 0x00000B23

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONCNTR_2_REGISTER;

/**
  This register is a perf counter. Software can read it and write it
**/
#define TGL_MSR_IIOPMONCNTR_3 0x00000B24

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Countervalue1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* The value of the counter */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONCNTR_3_REGISTER;

/**

**/
#define TGL_MSR_IIOPMONFRCNTRCLK 0x00000B25

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=WO, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=WO, default=0x00000000*/

                            /*
                               This register is a perfmon counter. Software can
                               both read it and write it
                            */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTRCLK_REGISTER;

/**

**/
#define TGL_MSR_IIOPMONUNITSTATUS 0x00000B27

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /* counter 0 overflowed */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /* counter 1 overflowed */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=WO, default=0x00000000*/

                            /* counter 2 overflowed */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=WO, default=0x00000000*/

                            /* counter3 overflowed */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONUNITSTATUS_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IOPMONCNTRCFG_0 0x00000B28

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IOPMONCNTRCFG_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IOPMONCNTRCFG_1 0x00000B29

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IOPMONCNTRCFG_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IOPMONCNTRCFG_2 0x00000B2A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IOPMONCNTRCFG_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_IOPMONCNTRCFG_3 0x00000B2B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Eventselect : 8;

                            /* Bits[7:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is used to decode the PerfMon event
                               which is selected. The encodings for each of the
                               valid UnCore PerfMon events can be found in the
                               respective individual unit performance
                               monitoring documentation.
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This mask selects the sub-events to be selected
                               for creation of the event. The selected sub-
                               events are bitwise OR-ed together to create
                               event. At least one sub-event must be selected
                               otherwise the PerfMon event signals will not
                               ever get asserted. Events with no sub-events
                               listed effectively have only one sub-event
                               =event -1 bit 8 must be set to 1 in this case.
                            */
    UINT32 Rsvd16 : 1;

                            /* Bits[16:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterreset : 1;

                            /* Bits[17:17], Access Type=RW_V, default=0x00000000*/

                            /*
                               When this bit is set, the corresponding counter
                               will be reset to 0. This allows for a quick
                               reset of the counter when changing event
                               encodings.
                            */
    UINT32 Edgedetect : 1;

                            /* Bits[18:18], Access Type=RW_V, default=0x00000000*/

                            /*
                               Edge Detect allows one to count either 0 to 1 or
                               1 to 0 transitions of a given event. For
                               example, we have an event that counts the number
                               of cycles in L1 mode in Intel QPI. By using edge
                               detect, one can count the number of times that
                               we entered L1 mode (by detecting the rising
                               edge).ect only works in conjunction with
                               threshholding. This is true even for events that
                               can only increment by 1 in a given cycle (like
                               the L1 example above). In this case, one should
                               set a threshhold of 1. One can also use Edge
                               Detect with queue occupancy events. For example,
                               if one wanted to count the number of times when
                               the TOR occupancy was larger than 5, one would
                               selet the TOR occupancy event with a threshold
                               of 5 and set the Edge Detect bit. Can also be
                               used with the invert. This is generally not
                               particularly useful, as the count of falling
                               edges compared to rising edges will always on
                               differ by 1.
                            */
    UINT32 Rsvd19 : 1;

                            /* Bits[19:19], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Overflowenable : 1;

                            /* Bits[20:20], Access Type=RW_V, default=0x00000000*/

                            /*
                               Setting this bit will enable the counter to send
                               an overflow signal. If this bit is not set, the
                               counter will wrap around when it overflows
                               without triggering anything. If this bit is set
                               and the Units configuration register has
                               Overflow enabled, then a signal will be
                               transmitted to the Ubox.
                            */
    UINT32 Rsvd21 : 1;

                            /* Bits[21:21], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Counterenable : 1;

                            /* Bits[22:22], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is the local enable for the PerfMon
                               Counter. This bit must be asserted in order for
                               the PerfMon counter to begin counting the events
                               selected by the event select, unit mask, and
                               internal bits (see the fields below). There is
                               one bit per PerfMon Counter. Note that if this
                               bit is set to 1 but the Unit Control Registers
                               have determined that counting is disabled, then
                               the counter will not count.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is threshold event.
                               When set to 1, the comparison that will be done
                               is inverted from the case where this bit is set
                               to 0, i.e., threshold event. The invert bit only
                               works when Threshhold != 0. So, if one would
                               like to invert a non-occupancy event (like LLC
                               Hit), one needs to set the threshhold to 1.
                            */
    UINT32 ResThreshold0 : 8;

                            /* Bits[31:24], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 ResThreshold1 : 4;

                            /* Bits[35:32], Access Type=RW_V, default=0x00000000*/

                            /*
                               This field is compared directly against an
                               incoming event value for events that can
                               increment by 1 or more in a given cycle. Since
                               the widest event from the ITC/OTC is 10 bits
                               (queue occupancy), it is 10 bit wide. The result
                               of the comparison is effectively a 1 bit wide
                               event, i.e., the counter will be incremented by
                               1 when the comparison is true (the type of
                               comparison depends on the setting of the invert
                               bit - see bit 23 below) no matter how wide the
                               original event was. When this field is zero,
                               threshold comparison is disabled and the event
                               is passed without modification.
                            */
    UINT32 Chnlmask : 12;

                            /* Bits[47:36], Access Type=RW, default=0x00000FFF*/

                            /*
                               This one-hot field specifies which PCIE links
                               should be considered when counting PerfMon
                               events. For example, if only bit 1 is set, then
                               only events corresponding to PCIE link 1 will be
                               counted.
                            */
    UINT32 Fcmask : 3;

                            /* Bits[50:48], Access Type=RW, default=0x00000007*/

                            /*
                               This one-hot field specifies which FCs should be
                               considered when counting PerfMon events: Bit 0 -
                               Posted requests Bit 1 - Non-posted requests Bit
                               2 - Completions
                            */
    UINT32 Rsvd51 : 13;

                            /* Bits[63:51], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IOPMONCNTRCFG_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_0 0x00000B50

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_0_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_1 0x00000B51

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_1_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_2 0x00000B52

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_2_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_3 0x00000B53

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_3_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_4 0x00000B54

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_4_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_5 0x00000B55

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_5_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_6 0x00000B56

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_6_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_7 0x00000B57

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_7_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_8 0x00000B58

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_8_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_9 0x00000B59

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_9_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_10 0x00000B5A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_10_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_11 0x00000B5B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_11_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_12 0x00000B5C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_12_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_13 0x00000B5D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_13_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_14 0x00000B5E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_14_REGISTER;

/**
  This is the foward counter. Software can read and write into it
**/
#define TGL_MSR_IIOPMONFRCNTR_15 0x00000B5F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Countervalue0 : 32;

                            /* Bits[31:0], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Countervalue1 : 4;

                            /* Bits[35:32], Access Type=RO_V, default=0x00000000*/

                            /* The current value of the counter */
    UINT32 Rsvd36 : 28;

                            /* Bits[63:36], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIOPMONFRCNTR_15_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_0 0x00000B60

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_0 0x00000B61

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_0 0x00000B62

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_0 0x00000B63

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_0_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_0 0x00000B64

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_0 0x00000B65

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_0 0x00000B67

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_0 0x00000B68

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_0 0x00000B69

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_0 0x00000B6A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_0_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_0 0x00000B6B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_0_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_1 0x00000B6E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_1 0x00000B6F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_1 0x00000B70

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_1 0x00000B71

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_1_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_1 0x00000B72

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_1 0x00000B73

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_1 0x00000B75

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_1 0x00000B76

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_1 0x00000B77

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_1 0x00000B78

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_1_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_1 0x00000B79

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_1_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_2 0x00000B7C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_2 0x00000B7D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_2 0x00000B7E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_2 0x00000B7F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_2_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_2 0x00000B80

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_2 0x00000B81

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_2 0x00000B83

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_2 0x00000B84

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_2 0x00000B85

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_2 0x00000B86

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_2_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_2 0x00000B87

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_2_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_3 0x00000B8A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_3 0x00000B8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_3 0x00000B8C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_3 0x00000B8D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_3_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_3 0x00000B8E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_3 0x00000B8F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_3 0x00000B91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_3 0x00000B92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_3 0x00000B93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_3 0x00000B94

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_3_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_3 0x00000B95

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_3_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_4 0x00000B98

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_4 0x00000B99

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_4 0x00000B9A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_4 0x00000B9B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_4_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_4 0x00000B9C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_4 0x00000B9D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_4 0x00000B9F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_4 0x00000BA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_4 0x00000BA1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_4 0x00000BA2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_4_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_4 0x00000BA3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_5 0x00000BA6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_5 0x00000BA7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_5 0x00000BA8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_5 0x00000BA9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_5_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_5 0x00000BAA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_5 0x00000BAB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_5 0x00000BAD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_5 0x00000BAE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_5 0x00000BAF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_5 0x00000BB0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_5_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_5 0x00000BB1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_5_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_6 0x00000BB4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_6 0x00000BB5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_6 0x00000BB6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_6 0x00000BB7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_6_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_6 0x00000BB8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_6 0x00000BB9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_6 0x00000BBB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_6 0x00000BBC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_6 0x00000BBD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_6 0x00000BBE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_6_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_6 0x00000BBF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_6_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_7 0x00000BC2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_7 0x00000BC3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_7 0x00000BC4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_7 0x00000BC5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_7_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_7 0x00000BC6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_7_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_7 0x00000BC7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_7_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_7 0x00000BC9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_7 0x00000BCA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_7 0x00000BCB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_7 0x00000BCC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_7_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_7 0x00000BCD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_7_REGISTER;
/**
  Available only in SMM. SMRAM copy of SSP saved by SMI
**/
#define TGL_MSR_SMRAM_SSP 0x00000C26

/**
  STLB QoS MASK configuration
**/
#define TGL_MSR_SF_QOS_INFO 0x00000C87

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 NumSnoopFilterWays : 6;

                            /* Bits[5:0], Access Type=RO_V, default=None*/

                            /*
                               Indicates the number of STLB_QOS_MASK MSRs
                               available. Required for SW since this is a non-
                               architectural feature
                            */
    UINT32 Rsvd6 : 26;

                            /* Bits[31:6], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_SF_QOS_INFO_REGISTER;

/**
  Way Mask for IIO accesses (SF and LLC)
**/
#define TGL_MSR_IIO_LLC_WAYS 0x00000C8B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Iiocosways : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000C0000*/

                            /*
                               available LLC/SF way vectors for class of
                               service of IIO (default is top 2 ways)
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IIO_LLC_WAYS_REGISTER;

/**
  available ways vectors for class of service of IA core
**/
#define TGL_MSR_LLC_QOS_MASK_0 0x00000C90

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_0_REGISTER;

/**
  available ways vectors for class of service of IA core
**/
#define TGL_MSR_LLC_QOS_MASK_1 0x00000C91

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_1_REGISTER;

/**
  available ways vectors for class of service of IA core
**/
#define TGL_MSR_LLC_QOS_MASK_2 0x00000C92

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_2_REGISTER;

/**
  available ways vectors for class of service of IA core
**/
#define TGL_MSR_LLC_QOS_MASK_3 0x00000C93

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_3_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_4_4 0x00000C94

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_4_4_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_5_5 0x00000C95

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_5_5_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_6_6 0x00000C96

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_6_6_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_7_7 0x00000C97

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_7_7_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_8_8 0x00000C98

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_8_8_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_9_9 0x00000C99

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_9_9_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_10_10 0x00000C9A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_10_10_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_11_11 0x00000C9B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_11_11_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_12_12 0x00000C9C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_12_12_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_13_13 0x00000C9D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_13_13_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_14_14 0x00000C9E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_14_14_REGISTER;

/**
  available ways vectors for class of service of IA core
  " seq has 12 instances in addresses range 0x94 to 0x9F"
**/
#define TGL_MSR_LLC_QOS_MASK_15_15 0x00000C9F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CosWaysMask : 20;

                            /* Bits[19:0], Access Type=RW, default=0x000FFFFF*/

                            /*
                               available ways vectors for class of service of
                               IA core restrictions: Only contiguous 1s are
                               allowed.
                            */
    UINT32 Rsvd20 : 12;

                            /* Bits[31:20], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LLC_QOS_MASK_15_15_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_0_0 0x00000D50

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_0_0_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_1_1 0x00000D51

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_1_1_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_2_2 0x00000D52

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_2_2_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_3_3 0x00000D53

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_3_3_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_4_4 0x00000D54

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_4_4_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_5_5 0x00000D55

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_5_5_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_6_6 0x00000D56

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_6_6_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_7_7 0x00000D57

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_7_7_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_8_8 0x00000D58

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_8_8_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_9_9 0x00000D59

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_9_9_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_10_10 0x00000D5A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_10_10_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_11_11 0x00000D5B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_11_11_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_12_12 0x00000D5C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_12_12_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_13_13 0x00000D5D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_13_13_REGISTER;

/**
  This MSR is used for Memory BW enforcement
  " seq has 16 instances in addresses range 0xD50 to 0xD5F"
**/
#define TGL_MSR_QOS_EXT_BW_THRTL_14_14 0x00000D5E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 RbeEnforcementVal : 16;

                            /* Bits[15:0], Access Type=RW, default=0x00000000*/

                            /* The mem bw thrtl value */
    UINT32 Reserved16 : 16;

                            /* Bits[31:16], Access Type=RW, default=0x00000000*/

                            /* Reserved */
    UINT32 Reserved32 : 32;

                            /* Bits[63:32], Access Type=RW, default=0x00000000*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_QOS_EXT_BW_THRTL_14_14_REGISTER;

/**
  Extensible Supervisor State MSR
**/
#define TGL_MSR_IA32_XSS 0x00000DA0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Mbz : 8;

                            /* Bits[7:0], Access Type=RW, default=None*/

                            /* Must be zero */
    UINT32 RtitSupport : 1;

                            /* Bits[8:8], Access Type=RW, default=None*/

                            /* RTIT X* support */
    UINT32 Mbz2 : 1;

                            /* Bits[9:9], Access Type=RW, default=None*/

                            /* Must-Be-Zero */
    UINT32 AiaWsniSupport : 1;

                            /* Bits[10:10], Access Type=RW, default=None*/

                            /* AiA/WSNI support */
    UINT32 UCetSupport : 1;

                            /* Bits[11:11], Access Type=RW, default=None*/

                            /* U_CET support */
    UINT32 SCetSupport : 1;

                            /* Bits[12:12], Access Type=RW, default=None*/

                            /* S_CET support */
    UINT32 HdcSupport : 1;

                            /* Bits[13:13], Access Type=RW, default=None*/

                            /* HDC support */
    UINT32 Reserved14 : 18;

                            /* Bits[31:14], Access Type=RW, default=None*/

                            /* Reserved for future growth */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_IA32_XSS_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_0_0 0x00000DC0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_0_0_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_1_1 0x00000DC1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_1_1_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_2_2 0x00000DC2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_2_2_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_3_3 0x00000DC3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_3_3_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_4_4 0x00000DC4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_4_4_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_5_5 0x00000DC5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_5_5_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_6_6 0x00000DC6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_6_6_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_7_7 0x00000DC7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_7_7_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_8_8 0x00000DC8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_8_8_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_9_9 0x00000DC9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_9_9_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_10_10 0x00000DCA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_10_10_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_11_11 0x00000DCB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_11_11_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_12_12 0x00000DCC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_12_12_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_13_13 0x00000DCD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_13_13_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_14_14 0x00000DCE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_14_14_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_15_15 0x00000DCF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_15_15_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_16_16 0x00000DD0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_16_16_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_17_17 0x00000DD1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_17_17_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_18_18 0x00000DD2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_18_18_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_19_19 0x00000DD3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_19_19_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_20_20 0x00000DD4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_20_20_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_21_21 0x00000DD5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_21_21_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_22_22 0x00000DD6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_22_22_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_23_23 0x00000DD7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_23_23_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_24_24 0x00000DD8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_24_24_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_25_25 0x00000DD9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_25_25_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_26_26 0x00000DDA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_26_26_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_27_27 0x00000DDB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_27_27_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_28_28 0x00000DDC

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_28_28_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_29_29 0x00000DDD

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_29_29_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_30_30 0x00000DDE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_30_30_REGISTER;

/**
  LBR MSR that holds non-IP information
**/
#define TGL_MSR_LBR_INFO_31_31 0x00000DDF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 CycleCount : 16;

                            /* Bits[15:0], Access Type=RW_V, default=None*/

                            /* core-clocks elapsed since last LBR array update */
    UINT32 Rsvd16 : 16;

                            /* Bits[31:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 29;

                            /* Bits[60:32], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 HleAbort : 1;

                            /* Bits[61:61], Access Type=RW_V, default=None*/

                            /* HLE/+ TX Abort occured */
    UINT32 InTx : 1;

                            /* Bits[62:62], Access Type=RW_V, default=None*/

                            /* Executing in HLE/+ TX */
    UINT32 Mispred : 1;

                            /* Bits[63:63], Access Type=RW_V, default=None*/

                            /* Misprediction bit */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_LBR_INFO_31_31_REGISTER;

/**
  Uncore PMU global control
**/
#define TGL_MSR_NCUPMONGLCTRL 0x00000E01

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmiselc0 : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc1 : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc2 : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc3 : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc4 : 1;

                            /* Bits[4:4], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc5 : 1;

                            /* Bits[5:5], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc6 : 1;

                            /* Bits[6:6], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc7 : 1;

                            /* Bits[7:7], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 Pmiselc8 : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enables sending the PMI to the respective core.
                               If WakeOnPMI is '1' a wake request is sent to
                               any sleeping core within the mask prior to
                               sending the event. Otherwise, the PMON event is
                               sent to all waken cores within the mask. The PMI
                               event is sent as a set of un-cast messages to
                               the target cores. 0 - Don't send event to the
                               core (default) 1 - Send event to the core
                            */
    UINT32 PmiselRsrv : 7;

                            /* Bits[15:9], Access Type=RO, default=0x00000000*/

                            /*  */
    UINT32 Rsvd16 : 12;

                            /* Bits[27:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Pmiovfenubp : 1;

                            /* Bits[28:28], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable the generation of uBP event when set. 0 -
                               Does not assert uBP event with the PMI Overflow.
                               1 - Assert uBP event with the PMI Overflow is
                               set.
                            */
    UINT32 Pmongen : 1;

                            /* Bits[29:29], Access Type=RW_V, default=0x00000000*/

                            /*
                               Enable all PMON Counter. This is sent as to all
                               unCore units using the global enable line. 0 -
                               All PrefMon are disabled (default) 1 - Enable
                               all PrefMon that their local enable bit is set.
                               This field is reset if Bit 31 in this register
                               (FrzCountr) is set and any one of the bits in
                               UNCORE_PERF_GLOBAL_STATUS_MSR is set.
                            */
    UINT32 Wkonpmi : 1;

                            /* Bits[30:30], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit determines whether PMI event is sent to
                               waken cores only or is broadcast to all cores
                               after waking up any sleeping core. 0 : Avoid
                               waking a core for PMI event - send event to
                               waken cores only. 1 : Wake any sleeping core and
                               send PMI event to all cores
                            */
    UINT32 Frzcountr : 1;

                            /* Bits[31:31], Access Type=RW_V, default=0x00000000*/

                            /*
                               FreezCounter : This bit, when asserted, cause
                               all of the global enables for the UnCore PerfMon
                               Counters and fixed counters to get freeze on any
                               PMI caused by UnCore PerfMon events.
                               Effectively, this causes all of the UnCore
                               counters to freeze simultaneously. 0 : Do not
                               assert Freeze on PMON event 1 : Assert Freeze on
                               PMON event
                            */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONGLCTRL_REGISTER;

/**
  Uncore PMU main status
**/
#define TGL_MSR_NCUPMONGLSTS 0x00000E02

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Fixctrovf : 1;

                            /* Bits[0:0], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Fix Event. read 0 - No overflow detected 1 -
                               Event overflow event was detected (sticky) Write
                               0 - Ignore 1 - Clear this bit
                            */
    UINT32 Ncuctrovf : 1;

                            /* Bits[1:1], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               NCU and IMPH Event. read 0 - No overflow
                               detected 1 - Event overflow event was detected
                               (sticky) Write 0 - Ignore 1 - Clear this bit
                            */
    UINT32 Chapovf : 1;

                            /* Bits[2:2], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Chap. read 0 - No overflow detected 1 - Event
                               overflow event was detected (sticky) Write 0 -
                               Ignore 1 - Clear this bit
                            */
    UINT32 Ringovf : 1;

                            /* Bits[3:3], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Ring Event signal. read 0 - No overflow detected
                               1 - Event overflow event was detected (sticky)
                               Write 0 - Ignore 1 - Clear this bit
                            */
    UINT32 Ncuctrovf1 : 1;

                            /* Bits[4:4], Access Type=RW1C_FW, default=0x00000000*/

                            /*
                               Indicates that an overflow event occured on the
                               Ring Event signal. Indicates that an overflow
                               event occured on the NCU and IDP1 Event. read 0
                               - No overflow detected 1 - Event overflow event
                               was detected (sticky) Write 0 - Ignore 1 - Clear
                               this bit
                            */
    UINT32 Rsvd5 : 27;

                            /* Bits[31:5], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_NCUPMONGLSTS_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_16 0x00000EE0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_16 0x00000EE1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_16 0x00000EE2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_16 0x00000EE3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_16_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_16 0x00000EE4

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_16 0x00000EE5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_16 0x00000EE7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_16 0x00000EE8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_16 0x00000EE9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_16 0x00000EEA

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_16_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_16 0x00000EEB

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_16_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_17 0x00000EEE

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_17 0x00000EEF

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_17 0x00000EF0

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_17 0x00000EF1

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_17_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_17 0x00000EF2

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_17_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_17 0x00000EF3

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_17_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_17 0x00000EF5

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_17 0x00000EF6

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_17 0x00000EF7

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_17 0x00000EF8

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_17_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_17 0x00000EF9

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_17_REGISTER;

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
  " seq has 1 instances in addresses range 0xF00 to 0xF00"
**/
#define TGL_MSR_AMRR_BASE_0_0 0x00000F00

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TmeEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable TME masking */
    UINT32 Rsvd1 : 11;

                            /* Bits[11:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_BASE_0_0_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
  " seq has 1 instances in addresses range 0xF01 to 0xF01"
**/
#define TGL_MSR_AMRR_MASK_0_0 0x00000F01

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IgnorePw : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR on a stuffed load will
                               be ignored and will not cause assist nor abort.
                               Only the real PA (on redispatch) can cause an
                               assist if matches. restrictions :
                            */
    UINT32 PhysegOvrd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR with PhySegSupOvr is
                               allowed, and will not cause assist or abort
                               restrictions :
                            */
    UINT32 ForceWb : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting AMRR legally (see above bit),
                               will also force WB memtype. This is subject to
                               memtype priorities and can be overridden due to
                               higher priority mem types restrictions :
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ifetch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               If set, allow AMRR assist matches for both
                               I-side and D-side, else assist match D-side
                               only. Pagewalk accesses (stuffed loads and
                               loadpxelocks) always count as D-side. This bit
                               has no effect on abort matches. restrictions :
                               Set corresponding AMRR_BASE appropriately for
                               the address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, AMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, AMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding AMRR_BASE
                               appropriately for the address. Set VLD, ASSIST,
                               IFETCH, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the AMRR */
    UINT32 Rsvd11 : 1;

                            /* Bits[11:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_MASK_0_0_REGISTER;

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF02 to 0xF04"
**/
#define TGL_MSR_AMRR_BASE_1_1 0x00000F02

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TmeEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable TME masking */
    UINT32 Rsvd1 : 11;

                            /* Bits[11:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_BASE_1_1_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF03 to 0xF05"
**/
#define TGL_MSR_AMRR_MASK_1_1 0x00000F03

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IgnorePw : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR on a stuffed load will
                               be ignored and will not cause assist nor abort.
                               Only the real PA (on redispatch) can cause an
                               assist if matches. restrictions :
                            */
    UINT32 PhysegOvrd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR with PhySegSupOvr is
                               allowed, and will not cause assist or abort
                               restrictions :
                            */
    UINT32 ForceWb : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting AMRR legally (see above bit),
                               will also force WB memtype. This is subject to
                               memtype priorities and can be overridden due to
                               higher priority mem types restrictions :
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ifetch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               If set, allow AMRR assist matches for both
                               I-side and D-side, else assist match D-side
                               only. Pagewalk accesses (stuffed loads and
                               loadpxelocks) always count as D-side. This bit
                               has no effect on abort matches. restrictions :
                               Set corresponding AMRR_BASE appropriately for
                               the address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, AMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, AMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding AMRR_BASE
                               appropriately for the address. Set VLD, ASSIST,
                               IFETCH, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the AMRR */
    UINT32 Rsvd11 : 1;

                            /* Bits[11:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_MASK_1_1_REGISTER;

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF02 to 0xF04"
**/
#define TGL_MSR_AMRR_BASE_2_2 0x00000F04

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TmeEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable TME masking */
    UINT32 Rsvd1 : 11;

                            /* Bits[11:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_BASE_2_2_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF03 to 0xF05"
**/
#define TGL_MSR_AMRR_MASK_2_2 0x00000F05

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IgnorePw : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR on a stuffed load will
                               be ignored and will not cause assist nor abort.
                               Only the real PA (on redispatch) can cause an
                               assist if matches. restrictions :
                            */
    UINT32 PhysegOvrd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR with PhySegSupOvr is
                               allowed, and will not cause assist or abort
                               restrictions :
                            */
    UINT32 ForceWb : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting AMRR legally (see above bit),
                               will also force WB memtype. This is subject to
                               memtype priorities and can be overridden due to
                               higher priority mem types restrictions :
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ifetch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               If set, allow AMRR assist matches for both
                               I-side and D-side, else assist match D-side
                               only. Pagewalk accesses (stuffed loads and
                               loadpxelocks) always count as D-side. This bit
                               has no effect on abort matches. restrictions :
                               Set corresponding AMRR_BASE appropriately for
                               the address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, AMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, AMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding AMRR_BASE
                               appropriately for the address. Set VLD, ASSIST,
                               IFETCH, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the AMRR */
    UINT32 Rsvd11 : 1;

                            /* Bits[11:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_MASK_2_2_REGISTER;

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF06 to 0xF08"
**/
#define TGL_MSR_AMRR_BASE_3_3 0x00000F06

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TmeEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable TME masking */
    UINT32 Rsvd1 : 11;

                            /* Bits[11:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_BASE_3_3_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF07 to 0xF09"
**/
#define TGL_MSR_AMRR_MASK_3_3 0x00000F07

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IgnorePw : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR on a stuffed load will
                               be ignored and will not cause assist nor abort.
                               Only the real PA (on redispatch) can cause an
                               assist if matches. restrictions :
                            */
    UINT32 PhysegOvrd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR with PhySegSupOvr is
                               allowed, and will not cause assist or abort
                               restrictions :
                            */
    UINT32 ForceWb : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting AMRR legally (see above bit),
                               will also force WB memtype. This is subject to
                               memtype priorities and can be overridden due to
                               higher priority mem types restrictions :
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ifetch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               If set, allow AMRR assist matches for both
                               I-side and D-side, else assist match D-side
                               only. Pagewalk accesses (stuffed loads and
                               loadpxelocks) always count as D-side. This bit
                               has no effect on abort matches. restrictions :
                               Set corresponding AMRR_BASE appropriately for
                               the address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, AMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, AMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding AMRR_BASE
                               appropriately for the address. Set VLD, ASSIST,
                               IFETCH, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the AMRR */
    UINT32 Rsvd11 : 1;

                            /* Bits[11:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_MASK_3_3_REGISTER;

/**
  Address Match Range Register - Physical Base Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF06 to 0xF08"
**/
#define TGL_MSR_AMRR_BASE_4_4 0x00000F08

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 TmeEn : 1;

                            /* Bits[0:0], Access Type=RW, default=0x00000000*/

                            /* Enable TME masking */
    UINT32 Rsvd1 : 11;

                            /* Bits[11:1], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Base0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Base1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The 4K-aligned platform physical base addresses
                               of the 3 AMRR registers for debugging. These
                               registers are programmed like MTRRs with base
                               and mask. Address matches of an AMRR can be
                               programmed to cause an "assist" or "abort".
                               Assists invoke the address match ucode handler
                               and populate the RR_MATCH_ADDR and
                               RR_MATCH_RESULT CREGs with useful information
                               about the access. Aborts force the memory type
                               to UC and redirect the access to the abort page
                               (causing it to get garbage data from the
                               uncore). See AMRR_MASK bits for more information
                               on how to program. See the PRF register
                               definition for how to resume AMRR assist
                               matches. restrictions : Set corresponding
                               AMRR_MASK appropriately for the address.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_BASE_4_4_REGISTER;

/**
  Address Match Range Register - Physical Mask Control Register for Hidden Lake
  " seq has 2 instances in addresses range 0xF07 to 0xF09"
**/
#define TGL_MSR_AMRR_MASK_4_4 0x00000F09

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Rsvd0 : 3;

                            /* Bits[2:0], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 IgnorePw : 1;

                            /* Bits[3:3], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR on a stuffed load will
                               be ignored and will not cause assist nor abort.
                               Only the real PA (on redispatch) can cause an
                               assist if matches. restrictions :
                            */
    UINT32 PhysegOvrd : 1;

                            /* Bits[4:4], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting the AMRR with PhySegSupOvr is
                               allowed, and will not cause assist or abort
                               restrictions :
                            */
    UINT32 ForceWb : 1;

                            /* Bits[5:5], Access Type=RW, default=0x00000000*/

                            /*
                               If set, hitting AMRR legally (see above bit),
                               will also force WB memtype. This is subject to
                               memtype priorities and can be overridden due to
                               higher priority mem types restrictions :
                            */
    UINT32 Rsvd6 : 2;

                            /* Bits[7:6], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Ifetch : 1;

                            /* Bits[8:8], Access Type=RW, default=0x00000000*/

                            /*
                               If set, allow AMRR assist matches for both
                               I-side and D-side, else assist match D-side
                               only. Pagewalk accesses (stuffed loads and
                               loadpxelocks) always count as D-side. This bit
                               has no effect on abort matches. restrictions :
                               Set corresponding AMRR_BASE appropriately for
                               the address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Assist : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000000*/

                            /*
                               If set, AMRR matches to the programmed address
                               will invoke ucode's address match handler. If
                               clear, AMRR matches will "abort" and redirect
                               the access to the abort page and a UC memory
                               type. restrictions : Set corresponding AMRR_BASE
                               appropriately for the address. Set VLD, ASSIST,
                               IFETCH, and MASK.
                            */
    UINT32 L : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /* Lock bit for the AMRR */
    UINT32 Rsvd11 : 1;

                            /* Bits[11:11], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Mask0 : 20;

                            /* Bits[31:12], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Mask1 : 20;

                            /* Bits[51:32], Access Type=RW, default=0x00000000*/

                            /*
                               The mask value used in MTRR-like address
                               matching of platform. Minimum granularity for
                               matches is 4K (aligned), but the ucode handler
                               can use RR_MATCH_ADDR and the resume capability
                               (see the PRF register definition) to achieve
                               narrower checking. restrictions : Set
                               corresponding AMRR_BASE appropriately for the
                               address. Set VLD, ASSIST, IFETCH, and MASK.
                            */
    UINT32 Rsvd52 : 12;

                            /* Bits[63:52], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_AMRR_MASK_4_4_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_8 0x00000F7A

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_8 0x00000F7B

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_0_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_1_8 0x00000F7C

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_1_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_2_8 0x00000F7D

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_2_8_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_3_8 0x00000F7E

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                               this bit is set to 0, i.e., event-count <
                               threshold.
                            */
    UINT32 Threshold : 6;

                            /* Bits[29:24], Access Type=RW, default=0x00000000*/

                            /*
                               When Threshold is not zero, the corresponding
                               performance counter increments each cycle if the
                               event count is greater than or equal to the
                               Threshold.
                            */
    UINT32 Rsvd30 : 2;

                            /* Bits[31:30], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Rsvd32 : 32;

                            /* Bits[63:32], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRCTRL_3_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRLGLCTR_8 0x00000F7F

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Threadid : 9;

                            /* Bits[8:0], Access Type=RW, default=0x00000000*/

                            /* Thread-ID format[2:0] - ThreadId. [8:3] -Core-ID */
    UINT32 Link0 : 1;

                            /* Bits[9:9], Access Type=RW, default=0x00000001*/

                            /*  */
    UINT32 Link1 : 1;

                            /* Bits[10:10], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link2 : 1;

                            /* Bits[11:11], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Link3 : 1;

                            /* Bits[12:12], Access Type=RW, default=0x00000000*/

                            /*  */
    UINT32 Rsvd13 : 4;

                            /* Bits[16:13], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 State : 10;

                            /* Bits[26:17], Access Type=RW, default=0x00000000*/

                            /*
                               Select the state(s) to monitor in the
                               CBO_CACHE_LOOKUP event (when the STATE submask
                               is selected). Setting multiple bits in this
                               field will allow one to track multiple states.
                               [17] - LLC_I [18] - SF_S [19] - SF_E [20] - SF_H
                               [21] - LLC_S [22] - LLC_E [23] - LLC_M [24] -
                               LLC_F [25] - LLC_D [26] - LLC_P
                            */
    UINT32 Rsvd27 : 5;

                            /* Bits[31:27], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRLGLCTR_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONCTRSTATUS_8 0x00000F81

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Counter0ovf : 1;

                            /* Bits[0:0], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter1ovf : 1;

                            /* Bits[1:1], Access Type=RW_V, default=0x00000000*/

                            /* counter 1 overflowed. Write 1 to clear */
    UINT32 Counter2ovf : 1;

                            /* Bits[2:2], Access Type=RW_V, default=0x00000000*/

                            /* counter 2 overflowed. Write 1 to clear */
    UINT32 Counter3ovf : 1;

                            /* Bits[3:3], Access Type=RW_V, default=0x00000000*/

                            /* counter 3 overflowed. Write 1 to clear */
    UINT32 Rsvd4 : 28;

                            /* Bits[31:4], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCTRSTATUS_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_0_8 0x00000F82

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_0_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_1_8 0x00000F83

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_1_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_2_8 0x00000F84

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_2_8_REGISTER;

/**
  PMON Counter 0 data register. Holds the counter value.
**/
#define TGL_MSR_CBOPMONCT_3_8 0x00000F85

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Pmonctrdata0 : 32;

                            /* Bits[31:0], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Pmonctrdata1 : 16;

                            /* Bits[47:32], Access Type=RW_V, default=0x00000000*/

                            /* Pmon Counter data. */
    UINT32 Rsvd48 : 16;

                            /* Bits[63:48], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONCT_3_8_REGISTER;

/**
  When this bit is written to, the counter configuration registers will be reset. This does not effect the values in the counters. To reset the counters, this bit need only be set by one of the unit control registers
**/
#define TGL_MSR_CBOPMONUNITCTRL_9 0x00000F88

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Resetcounterconfigs : 1;

                            /* Bits[0:0], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counter
                               configuration registers will be reset. This does
                               not effect the values in the counters. This is a
                               WO register, and writing to this bit will
                               trigger a reset for 1 cycle only.
                            */
    UINT32 Resetcounters : 1;

                            /* Bits[1:1], Access Type=WO, default=0x00000000*/

                            /*
                               When this bit is written to, the counters data
                               fields will be reset. The configuration values
                               will not be reset. This is a WO register, and
                               writing to this bit will trigger a reset for 1
                               cycle only.
                            */
    UINT32 Rsvd2 : 6;

                            /* Bits[7:2], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Freezecounters : 1;

                            /* Bits[8:8], Access Type=RW_V, default=0x00000000*/

                            /*
                               This bit is written to when the counters should
                               be frozen. If this bit is written to and freeze
                               is enabled, the counters in the unit will stop
                               counting. To freeze the counters, this bit need
                               only be set by one of the unit control
                               registers.
                            */
    UINT32 Rsvd9 : 23;

                            /* Bits[31:9], Access Type=RO, default=None*/

                            /* Reserved */

  } Bits;

  UINT32 Uint32;
  UINT64 Uint64;

} TGL_MSR_CBOPMONUNITCTRL_9_REGISTER;

/**
  Holds the status information and control the operation of the the PMON Fixed Counter.
**/
#define TGL_MSR_CBOPMONCTRCTRL_0_9 0x00000F89

typedef union {
  ///
  /// Individual bit fields
  ///
  struct {
    UINT32 Evslct : 8;

                            /* Bits[7:0], Access Type=RW, default=0x00000000*/

                            /*
                               Selects the event logic unit to detect certain
                               microarchitectural conditions
                            */
    UINT32 Unitmask : 8;

                            /* Bits[15:8], Access Type=RW, default=0x00000000*/

                            /*
                               Further qualifies the event logic unit selected
                               in the event select field to detect a specific
                               microarchitectural condition.
                            */
    UINT32 Rsvd16 : 2;

                            /* Bits[17:16], Access Type=RO, default=None*/

                            /* Reserved */
    UINT32 Edgedet : 1;

                            /* Bits[18:18], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counting on event edges (count
                               occurrences) or level (number of clocks the
                               event was high) 0 : level count 1 : Edge count
                            */
    UINT32 Tidfilterenable : 1;

                            /* Bits[19:19], Access Type=RW, default=0x00000000*/

                            /*
                               Thread-ID format: [0:0] - T0 or T1. N/A for
                               GT/IO Cores [3:1] - Core-ID When 'TID filter
                               enable' is clear; the specified counter will
                               count All events Thread-ID of 0xF is reserved
                               for non-associated requests like: - LLC victims
                               - PMSeq - External snoops
                            */
    UINT32 Ovfenable : 1;

                            /* Bits[20:20], Access Type=RW, default=0x00000000*/

                            /*
                               Indicates whether the counter should assert the
                               PMON_Overflow output from CBo towards NCU. 0:
                               The counter will not assert PMON_Overflow 1: The
                               counter asserts PMON_Overflow upon counter
                               overflow
                            */
    UINT32 Internal : 1;

                            /* Bits[21:21], Access Type=RW, default=0x00000000*/

                            /*
                               This bit needs to be asserted if the event which
                               needs to be selected is an internal event. This
                               bit effectively increases the address space for
                               event selection. NOTE: Microcode will cause a GP
                               fault when the programmer attempts to enable an
                               internal event from a locked
                            */
    UINT32 Counteren : 1;

                            /* Bits[22:22], Access Type=RW, default=0x00000000*/

                            /*
                               Enable the counter to count when the global
                               enable is active.0 : counter is disabled and
                               will not count when global enable is set.1 :
                               counter is enabled and will count when global
                               enable is set.
                            */
    UINT32 Invert : 1;

                            /* Bits[23:23], Access Type=RW, default=0x00000000*/

                            /*
                               This bit indicates how the threshold field will
                               be compared to the incoming event. When 0, the
                               comparison that will be done is event-count >=
                               threshold. When set to 1, the comparison that
                               will be done is inverted from the case where
                              