 /** @file
  This file contains Cpu Information for specific generation.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 - 2020 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _CPU_GEN_INFO_FRU_LIB_H_
#define _CPU_GEN_INFO_FRU_LIB_H_
#include <CpuRegs.h>
#include <Register/CommonMsr.h>

///
/// Used to identify the CPU used for programming with the VR override table
///
typedef enum {
  EnumUnknownCpuId             = 0,
  EnumMinCpuId                 = 1,
  ///
  /// TGL-Y
  ///
  EnumTglY9WattES1CpuId       = 0x10,
  EnumTglY9Watt42fCpuId       = 0x11,
  EnumTglYMaxCpuId            = EnumTglY9Watt42fCpuId,
  ///
  /// TGL-U
  ///
  EnumTglU28WattES1CTdpCpuId     = 0x20,
  EnumTglU28Watt42f15WCTdpCpuId  = 0x21,
  EnumTglU28Watt42f12WCTdpCpuId  = 0x22,
  EnumTglU28Watt42f10WCTdpCpuId  = 0x23,
  EnumTglU28WattES1CpuId         = 0x24,
  EnumTglU28Watt42fCpuId         = 0x25,
  EnumTglU15Watt22CpuId          = 0x26,
  EnumTglUMaxCpuId               = EnumTglU15Watt22CpuId,
  ///
  /// TGL-H
  ///
  EnumTglH45Watt81CpuId       = 0x30,
  EnumTglH45Watt81CTdpCpuId   = 0x31,
  EnumTglHMaxCpuId            = EnumTglH45Watt81CTdpCpuId,

  EnumMaxCpuId                = EnumTglU28Watt42f10WCTdpCpuId,
} CPU_IDENTIFIER;

/**
  Return CPU Identifier used to identify various CPU types

  @param[in]  CPU_SKU                       CpuSku
  @param[in]  CPU_STEPPING                  CpuStepping
  @param[in]  SelectedCtdpLevel             Ctdp Level Selected in BIOS

  @retval     CPU_IDENTIFIER                CPU Identifier
**/
CPU_IDENTIFIER
EFIAPI
GetCpuSkuIdentifier (
  IN  CPU_SKU         CpuSku,
  IN  CPU_STEPPING    CpuStepping,
  IN  UINT16          SelectedCtdpLevel
  );
#endif // _CPU_GEN_INFO_FRU_LIB_H_
