/** @file
  Header file which contains Voltage regulator topology data and overrides for domains like SA, IA, Ring, GT, Fivr.

@copyright
  INTEL CONFIDENTIAL
  Copyright 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _VOLTAGE_REGULATOR_DOMAINS_H_
#define _VOLTAGE_REGULATOR_DOMAINS_H_

#include <CpuGenInfoFruLib.h>  //CPU_IDENTIFIER structure comes from this header. so we need this include
///
///  VR Domain Definitions
///
#define CPU_VR_DOMAIN_VCCIN         0x0

///
/// VR Topology Data structure containing the address and en/dis information
/// for all SVID VR domains
///
typedef union VR_TOPOLOGY_DATA {
  UINT32 VrTopology;              ///< All bit fields as a 32-bit value.
  ///
  /// Individual bit fields.
  ///
  struct {
    UINT32 VccInAuxExist    : 1;  ///< Vcc In Aux Exist
    UINT32 Reserved         : 1;  ///< Reserved
    UINT32 VccStgPgExist    : 1;  ///< Vcc STG PG Exist
    UINT32 VccStPgExist     : 1;  ///< Vcc ST PG Exist
    UINT32 VccSfrOcPgExist  : 1;  ///< Vcc Sfr OC PG Exist
    UINT32 VccInAuxLpLevel  : 1;  ///< VccIn Aux Lp Level
    UINT32 Reserved1        : 19; ///< Reserved1
    UINT32 FivrInVrAddress  : 4;  ///< FIVR VR address
    UINT32 FivrInVrType     : 1;  ///< FIVR VR Type. 1 - No SVID VR, 0 - SVID VR
    UINT32 SvidNotPresent   : 1;  ///< Asserted when no SVID VR connected
    UINT32 PsysDisable      : 1;  ///< Imon Enable. 1 - Disable, 0 - Enable
  } Fields;
} VR_TOPOLOGY_DATA;

///
/// VR Override table structure
///
typedef struct {
  CPU_IDENTIFIER  CpuIdentifier;
  UINT16          VccInIccMax;
  UINT16          VccInTdclimit;
  UINT16          VccInAcLoadLine;
  UINT16          VccInDcLoadLine;
} CPU_VR_OVERRIDE_TABLE;

#endif // _VOLTAGE_REGULATOR_DOMAINS_H_
