/** @file
  Register names for TCSS USB devices

  <b>Conventions</b>:

  - Prefixes:
    Definitions beginning with "R_" are registers
    Definitions beginning with "B_" are bits within registers
    - Definitions beginning with "V_" are meaningful values of bits within the registers
    Definitions beginning with "S_" are register sizes
    Definitions beginning with "N_" are the bit position

@copyright
  INTEL CONFIDENTIAL
  Copyright 2017 - 2019 Intel Corporation.

  The source code contained or described herein and all documents related to the
  source code ("Material") are owned by Intel Corporation or its suppliers or
  licensors. Title to the Material remains with Intel Corporation or its suppliers
  and licensors. The Material may contain trade secrets and proprietary and
  confidential information of Intel Corporation and its suppliers and licensors,
  and is protected by worldwide copyright and trade secret laws and treaty
  provisions. No part of the Material may be used, copied, reproduced, modified,
  published, uploaded, posted, transmitted, distributed, or disclosed in any way
  without Intel's prior express written permission.

  No license under any patent, copyright, trade secret or other intellectual
  property right is granted to or conferred upon you by disclosure or delivery
  of the Materials, either expressly, by implication, inducement, estoppel or
  otherwise. Any license under such intellectual property rights must be
  express and approved by Intel in writing.

  Unless otherwise agreed by Intel in writing, you may not remove or alter
  this notice or any other notice embedded in Materials by Intel or
  Intel's suppliers or licensors in any way.

  This file contains an 'Intel Peripheral Driver' and is uniquely identified as
  "Intel Reference Module" and is licensed for Intel CPUs and chipsets under
  the terms of your license agreement with Intel or your vendor. This file may
  be modified by the user, subject to additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef _CPU_USB_REGS_H_
#define _CPU_USB_REGS_H_

//
// TCSS USB3 xHCI related definitions
//
#define XHCI_NORTH_BUS_NUM             0
#define XHCI_NORTH_DEV_NUM             13
#define XHCI_NORTH_FUNC_NUM            0

//
// TCSS USB3 xDCI related definitions
//
#define XDCI_NORTH_BUS_NUM             0
#define XDCI_NORTH_DEV_NUM             13
#define XDCI_NORTH_FUNC_NUM            1

#define R_XHCI_PORTSC02_USB3           0x490 ///< First USB3 PORTSC register

#define R_TCSS_USB_HOST_CR_SSPE_REG       0x80B8
#define B_TCSS_USB_HOST_CR_SSPE_REG_MASK  (0xFF >> (8-MAX_TCSS_USB3_PORTS))

#define R_TCSS_USB_HOST_CR_USB3PDO        0x84FC
#define B_TCSS_USB_HOST_CR_USB3PDO_MASK   (0xFF >> (8-MAX_TCSS_USB3_PORTS))

#endif
